<?php
	use Web3p\EthereumTx\Transaction;
	use Web3\Web3;
	use kornrunner\Ethereum\Address;
	require_once('Web3Utils.php');
	class OpBnbApi {
		protected $server;
		protected $network;
	
		function __construct(string $server, string $network = 'mainnet'){
			$this->server = $server;
			$this->network = $network;
		}
		
		public function send($method, $params = []){
			$url = $this->server;
			$strParams = json_encode(array_values($params));
        $data_string = <<<data
{"jsonrpc":"2.0","method":"{$method}","params": $strParams,"id":1}
data;
			$data = [
				'headers' => [
					'Content-Type' => 'application/json',
				],
				'body' => $data_string
			];
			$res = Web3Utils::httpRequest('POST', $url, $data);
			if (isset($res['result'])) {
				return $res['result'];
			} else {
				return json_encode($res);
				//return false;
			}
		}
		
		public function gasPrice() {
			return $this->send('eth_gasPrice');
		}
	
		function getBalance(string $address) {
			$balance = $this->send('eth_getBalance', ['address' => $address, 'latest']);
			return Web3Utils::toDisplayAmount($balance, 18);
		}
		
		function sendRawTransaction($raw) {
			return $this->send('eth_sendRawTransaction', ['hex' => $raw]);
		}
		
		function getNonce(string $address) {
			return $this->send('eth_getTransactionCount', ['address' => $address, 'latest']);
		}
		
		function ethCall($params): string {
			return $this->send('eth_call', ['params' => $params, 'latest']);
		}

		function blockNumber() {
			return hexdec($this->send('eth_blockNumber'));
		}

		function getBlockByNumber(int $blockNumber) {
			$blockNumber = Web3Utils::toHex($blockNumber, true);
			return $this->send('eth_getBlockByNumber', ['blockNumber' => $blockNumber, true]);
		}
		
		function getNetwork(): string {
			return $this->network;
		}
		
		function gasPriceOracle($type = 'standard'){
			$url = 'https://gbsc.blockscan.com/gasapi.ashx?apikey=key&method=pendingpooltxgweidata';
			$res = Web3Utils::httpRequest('GET', $url);
			if ($type && isset($res['result'][$type . 'gaspricegwei'])) {
				$price = Web3Utils::toWei((string)$res['result'][$type . 'gaspricegwei'], 'gwei');
				return $price;
			} else {
				return $res;
			}
		}
		
		function transfer($from_address, $to_address, $amount, $private_key) {
			//$web3 = new Web3($this->server);
			//$eth = $web3->eth;
			$nonce = $this->getNonce($from_address);
			$gas_price = Web3Utils::toHex(75000000, true);
			$value = Web3Utils::toWei((string)$amount, 'ether');
			$value = Web3Utils::toHex($value, true);
			
			$transaction = new Transaction([
				'nonce' => $nonce,
				'from' => $from_address,
				'to' => $to_address,
				'gasPrice' => "$gas_price",
				'value' => "$value",
				'gas' => '0x76c0',
				'chainId' => 204,
			]);
			
			$signedTransaction = $transaction->sign($private_key);
			$res = $this->send('eth_sendRawTransaction', ['data' => '0x'.$signedTransaction]);
			return $res;
		}
	}


?>