<?php
	use Web3p\EthereumTx\Transaction;
	use Web3\Web3;
	use kornrunner\Ethereum\Address;
	require_once('BSCWeb3Utils.php');
	class BscApi {
		protected $server;
		protected $network;
	
		function __construct(string $server, string $network = 'mainnet'){
			$this->server = $server;
			$this->network = $network;
		}
		
		public function send($method, $params = []){
			$url = $this->server;
			$strParams = json_encode(array_values($params));
        $data_string = <<<data
{"jsonrpc":"2.0","method":"{$method}","params": $strParams,"id":1}
data;
			$data = [
				'headers' => [
					'Content-Type' => 'application/json',
				],
				'body' => $data_string
			];
			$res = BSCWeb3Utils::httpRequest('POST', $url, $data);
			if (isset($res['result'])) {
				return $res['result'];
			} else {
				//return json_encode($res);
				return false;
			}
		}
		
		public function gasPrice() {
			return $this->send('eth_gasPrice');
		}
	
		function getBalance(string $address) {
			$balance = $this->send('eth_getBalance', ['address' => $address, 'latest']);
			return BSCWeb3Utils::toDisplayAmount($balance, 18);
		}
		
		function sendRawTransaction($raw) {
			return $this->send('eth_sendRawTransaction', ['hex' => $raw]);
		}
		
		function getNonce(string $address) {
			return $this->send('eth_getTransactionCount', ['address' => $address, 'latest']);
		}
		
		function ethCall($params): string {
			return $this->send('eth_call', ['params' => $params, 'latest']);
		}

		function blockNumber() {
			return hexdec($this->send('eth_blockNumber'));
		}

		function getBlockByNumber(int $blockNumber) {
			$blockNumber = BSCWeb3Utils::toHex($blockNumber, true);
			return $this->send('eth_getBlockByNumber', ['blockNumber' => $blockNumber, true]);
		}
		
		function getNetwork(): string {
			return $this->network;
		}
		
		function gasPriceOracle($type = 'standard'){
			$url = 'https://gbsc.blockscan.com/gasapi.ashx?apikey=key&method=pendingpooltxgweidata';
			$res = BSCWeb3Utils::httpRequest('GET', $url);
			if ($type && isset($res['result'][$type . 'gaspricegwei'])) {
				$price = BSCWeb3Utils::toWei((string)$res['result'][$type . 'gaspricegwei'], 'gwei');
				return $price;
			} else {
				return $res;
			}
		}
		
		function transfer($from_address, $to_address, $amount, $private_key) {
			$web3 = new Web3($this->server);
			$eth = $web3->eth;
			$nonce = $this->getNonce($from_address);
			$gas_price = BSCWeb3Utils::toHex(500000000000, true);
			$value = BSCWeb3Utils::toWei((string)$amount, 'ether');
			$value = BSCWeb3Utils::toHex($value, true);
			
			$transaction = new Transaction([
				'nonce' => $nonce,
				'from' => $from_address,
				'to' => $to_address,
				'gasPrice' => "$gas_price",
				'value' => "$value",
				'gas' => '0x76c0',
				'chainId' => 137,
			]);
			
			$signedTransaction = $transaction->sign($private_key);
			$res = $this->send('eth_sendRawTransaction', ['data' => '0x'.$signedTransaction]);
			return $res;
		}
		
		function get_transaction_info_by_txid($hash) {
			$res = $this->send('eth_getTransactionByHash', ['hash' => $hash]);
			if(is_array($res)) {
				$block_hash = $res['blockHash'];
				$txid = $res['hash'];
				$from_address = $res['from'];
				$to_address = $res['to'];
				$wei = hexdec($res['value']);
				//$amount = $wei / pow(10, 18);
				$amount = $wei / pow(10, 10);
				$time = time();
				$block_id = hexdec($res['blockNumber']);
				 
				//if($time != 0) {
					//$time = hexdec($time);
				//}
				return array(
					'txid'			=> $txid,
					'from_address'	=> $from_address,
					'to_address'	=> $to_address,
					'amount'		=> $amount,
					'time'			=> $time,
					'block_id'		=> $block_id
				);
			}
			return null;
		}
		
	}


?>