<?php
require_once('vendor/autoload.php');
require_once('vendor/opbnbphp/OpBnb.php');
require_once('vendor/bscphp/BSC.php');
function bscapi_generate_address() {
	try {
		$wallet = new \Binance\Wallet();
		$addressData = $wallet->newAccountByPrivateKey();
		return array(
			'private_key'	=> $addressData['key'],
			'public_key'	=> $addressData['address']
		);
	} catch (Exception $e) {
		return '';
	}
}

function bscapi_get_balance($address) {
	$rpc_nodes = [
		"https://bsc-dataseed1.defibit.io/",
		//"https://go.getblock.io/a6e21d00f29c48ca91136660a7e214c7",
		"https://bsc-mainnet.core.chainstack.com/065f8a345485e87c4b61f552adf9f7c9",
		"https://bsc.meowrpc.com",
		"https://binance.nodereal.io",
		"https://bsc-dataseed.binance.org",
		"https://bsc-dataseed1.binance.org",
		"https://bsc-dataseed1.ninicoin.io",
		"https://bsc-dataseed2.binance.org",
		"https://bsc-dataseed2.defibit.io",
		"https://bsc-dataseed2.ninicoin.io",
		"https://bsc-dataseed3.binance.org",
		"https://bsc-dataseed3.defibit.io",
		"https://bsc-dataseed3.ninicoin.io",
		"https://bsc-dataseed4.binance.org",
		"https://bsc-dataseed4.defibit.io",
		"https://bsc-dataseed4.ninicoin.io",
		"https://bsc-mainnet.nodereal.io/v1/64a9df0874fb4a93b9d0a3849de012d3",
		"https://bsc-mainnet.public.blastapi.io/",
		"https://rpc-bsc.48.club",
		"https://bsc.publicnode.com",
		//"https://bsc.rpc.blxrbdn.com",
		//"https://bscrpc.com",
		//"https://1rpc.io/bnb",
		//"https://rpc.ankr.com/bsc",
		//"https://bsc.drpc.org/",
		//"https://bsc.blockpi.network/v1/rpc/public",
		//"https://koge-rpc-bsc.48.club",
		//"https://bnb.api.onfinality.io/public"
	];
	$uri = $rpc_nodes[rand(0, count($rpc_nodes) - 1)];
	try {
		$api = new \Binance\NodeApi($uri);
		$bnbWallet = new \Binance\Bnb($api);
		$bnbBalance = $bnbWallet->bnbBalance($address);
		return $bnbBalance;
	} catch (Exception $e) {
		file_put_contents('rpc_error.txt', $uri.PHP_EOL , FILE_APPEND | LOCK_EX);
		throw new Exception("Error accessing RPC node {$uri}: " . $e->getMessage(), 0, $e);
		return 0;
	}
}

function bscapi_send_transaction($to_address, $amount, $private_key){
	$rpc_nodes = [
		"https://bsc-dataseed1.defibit.io/",
		//"https://go.getblock.io/a6e21d00f29c48ca91136660a7e214c7",
		"https://bsc-mainnet.core.chainstack.com/065f8a345485e87c4b61f552adf9f7c9",
		"https://bsc.meowrpc.com",
		"https://binance.nodereal.io",
		"https://bsc-dataseed.binance.org",
		"https://bsc-dataseed1.binance.org",
		"https://bsc-dataseed1.ninicoin.io",
		"https://bsc-dataseed2.binance.org",
		"https://bsc-dataseed2.defibit.io",
		"https://bsc-dataseed2.ninicoin.io",
		"https://bsc-dataseed3.binance.org",
		"https://bsc-dataseed3.defibit.io",
		"https://bsc-dataseed3.ninicoin.io",
		"https://bsc-dataseed4.binance.org",
		"https://bsc-dataseed4.defibit.io",
		"https://bsc-dataseed4.ninicoin.io",
		"https://bsc-mainnet.nodereal.io/v1/64a9df0874fb4a93b9d0a3849de012d3",
		"https://bsc-mainnet.public.blastapi.io/",
		"https://rpc-bsc.48.club",
		"https://bsc.publicnode.com",
		//"https://bsc.rpc.blxrbdn.com",
		//"https://bscrpc.com",
		//"https://1rpc.io/bnb",
		//"https://rpc.ankr.com/bsc",
		//"https://bsc.drpc.org/",
		//"https://bsc.blockpi.network/v1/rpc/public",
		//"https://koge-rpc-bsc.48.club",
		//"https://bnb.api.onfinality.io/public"
	];
	$uri = $rpc_nodes[rand(0, count($rpc_nodes) - 1)];
	$api = new \Binance\NodeApi($uri);
	$bnbWallet = new \Binance\Bnb($api);
	try {
		$res = $bnbWallet->transfer($private_key, $to_address, $amount);
		return $res;
	} catch (Exception $e) {
		file_put_contents('rpc_error.txt', $uri.PHP_EOL , FILE_APPEND | LOCK_EX);
		throw new Exception("Error accessing RPC node {$uri}: " . $e->getMessage(), 0, $e);
		return 'Unknown reason';
	}
}

function bscapi_get_transactions($address, $time = 0) {
	//$api_key = '56GCHKCBPG1CRBUN86U2F1EEA9V8EP8KF6'; //bscscan
	$api_key = 'K1M4HEYMRPGKD2QWQHIEF9MN8QRHA3E7G3'; //etherscan
	//$trans = json_decode(file_get_contents('https://api.bscscan.com/api?module=account&action=txlist&address='.$address.'&startblock=0&endblock=99999999&page=1&offset=20&sort=desc&apikey='.$api_key)); //v1
	$trans = json_decode(file_get_contents('https://api.etherscan.io/v2/api?chainid=56&module=account&action=txlist&address='.$address.'&startblock=0&endblock=99999999&page=1&offset=20&sort=desc&apikey='.$api_key)); //v2
	$status = $trans->status;
	if($status != 1) {
		return '';
	}
	$data = $trans->result;
	$arr = array();
	if(count($data) > 0) {
		for($i = 0; $i < count($data); $i++) {
			$txid = $data[$i]->hash;
			$amount = $data[$i]->value / 10000000000;
			$from_address = $data[$i]->from;
			$to_address = $data[$i]->to;
			$timeStamp = $data[$i]->timeStamp;
			if($timeStamp > $time - 86400){
				array_push($arr, array(
					'txid'			=> $txid,
					'from_address'	=> $from_address,
					'to_address'	=> $to_address,
					'amount'		=> $amount,
					'time'			=> $timeStamp,
				));
			}
		}
		return $arr;
	}
	return '';
}

function bscapi_get_transactions_from_nodereal($address, $time = 0) {
	$trans = json_decode(file_get_contents('https://bsc-explorer-api.nodereal.io/api/tx/getAssetTransferByAddress?address='.$address.'&pageSize=5&type=transaction&page=1'));
	$message = $trans->msg;
	if($message != 'success') {
		return '';
	}
	$data = $trans->data;
	$arr = array();
	if($data->total > 0) {
		$list = $data->list;
		for($i = 0; $i < count($list); $i++) {
			$txid = $list[$i]->hash;
			if(strpos($list[$i]->value, "0x") === 0) {
				$amount = intval(hexdec($list[$i]->value) / 10000000000);
			} else {
				$amount = $list[$i]->value / 10000000000;
			}
			$from_address = $list[$i]->from;
			$to_address = $list[$i]->to;
			$timeStamp = $list[$i]->blockTimeStamp;
			if($timeStamp > $time){
				array_push($arr, array(
					'txid'			=> $txid,
					'from_address'	=> $from_address,
					'to_address'	=> $to_address,
					'amount'		=> $amount,
					'time'			=> $timeStamp,
				));
			}
		}
		return $arr;
	}
	return '';
}

function bscapi_get_transactions_from_bscscan($address, $time = 0) {
	require_once('simple_html_dom.php');
	$html = file_get_html('https://bscscan.com/address/'.$address);
	$transactions = array();
	foreach($html->find('.myFnExpandBox_searchVal') as $link) {
		$tr = $link->parent->parent->parent;
		$hash = $tr->children(1)->find('a')[0]->href;
		$hash = str_replace("/tx/", "", $hash);
		$block_id = $tr->children(3)->find('a')[0]->href;
		$block_id = str_replace("/block/", "", $block_id);
		$from_address = $tr->children(7)->find('.me-1');
		if(count($from_address) > 0) {
			$from_address = str_replace("/address/", "", $from_address[0]->href);
			$to_address = $tr->children(9)->children(0)->children(0)->children(0);
			$to_address = $to_address->attr['data-highlight-target'];
			$amount = $tr->children(10)->children(0);
			$amount = strip_tags($amount->innertext);
			$amount = str_replace(" BNB", "", $amount);
			$amount = floatval($amount);
			$amount = intval($amount * 100000000);
			$timeStamp = intval($tr->children(6)->children(0)->innertext);
			if($timeStamp > $time) {
				array_push($transactions, array(
					'txid'			=> $hash,
					'from_address'	=> $from_address,
					'to_address'	=> $to_address,
					'amount'		=> $amount,
					'time'			=> $timeStamp,
				));
			}
		}
	}
}

function bscapi_get_transaction_info_by_txid($txid) {
	$res = json_decode(file_get_contents('https://bsc-explorer-api.nodereal.io/api/tx/getDetail?hash='.$txid));
	if(is_object($res) && isset($res->data->hash)) {
		$data = $res->data;
		$txid = $data->hash;
		$time = $data->blockTimeStamp;
		$from_address = $data->vin->address;
		$to_address = $data->vout->address;
		$amount = $data->value / 10000000000;
		return array(
			'txid'			=> $txid,
			'from_address'	=> $from_address,
			'to_address'	=> $to_address,
			'amount'		=> $amount,
			'time'			=> $time,
		);
	}
	return null;
}

function bscapi_get_transaction_info_by_txid2($txid) {
	$rpc_nodes = [
		"https://bsc-dataseed1.defibit.io/",
		//"https://go.getblock.io/a6e21d00f29c48ca91136660a7e214c7",
		"https://bsc-mainnet.core.chainstack.com/065f8a345485e87c4b61f552adf9f7c9",
		"https://bsc.meowrpc.com",
		"https://binance.nodereal.io",
		"https://bsc-dataseed.binance.org",
		"https://bsc-dataseed1.binance.org",
		"https://bsc-dataseed1.ninicoin.io",
		"https://bsc-dataseed2.binance.org",
		"https://bsc-dataseed2.defibit.io",
		"https://bsc-dataseed2.ninicoin.io",
		"https://bsc-dataseed3.binance.org",
		"https://bsc-dataseed3.defibit.io",
		"https://bsc-dataseed3.ninicoin.io",
		"https://bsc-dataseed4.binance.org",
		"https://bsc-dataseed4.defibit.io",
		"https://bsc-dataseed4.ninicoin.io",
		"https://bsc-mainnet.nodereal.io/v1/64a9df0874fb4a93b9d0a3849de012d3",
		"https://bsc-mainnet.public.blastapi.io/",
		"https://rpc-bsc.48.club",
		"https://bsc.publicnode.com",
		//"https://bsc.rpc.blxrbdn.com",
		//"https://bscrpc.com",
		//"https://1rpc.io/bnb",
		//"https://rpc.ankr.com/bsc",
		//"https://bsc.drpc.org/",
		//"https://bsc.blockpi.network/v1/rpc/public",
		//"https://koge-rpc-bsc.48.club",
		//"https://bnb.api.onfinality.io/public"
	];
	$uri = $rpc_nodes[rand(0, count($rpc_nodes) - 1)];
	try {
		$bscapi = new BscApi($uri);
		return $bscapi->get_transaction_info_by_txid($txid);
	} catch (Exception $e) {
		file_put_contents('rpc_error.txt', $uri.PHP_EOL , FILE_APPEND | LOCK_EX);
		throw new Exception("Error accessing RPC node {$uri}: " . $e->getMessage(), 0, $e);
		return 'Unknown reason';
	}
}


///////////////////////// opBNB network /////////////////////////////////

function bscapi_get_transactions_on_opbnb($address, $time = 0) {
	//$api_key = 'ZTKBTWKT8E31KNNUTQEP2WRG77I9G5F2D9';
	$api_key = 'FIJ9P2KGNG69XAM8TKR47P4EADC7465P9G'; //etherscan
	//$trans = json_decode(file_get_contents('https://api-opbnb.bscscan.com/api?module=account&action=txlist&address='.$address.'&startblock=0&endblock=99999999&page=1&offset=20&sort=desc&apikey='.$api_key));
	$trans = json_decode(file_get_contents('https://api.etherscan.io/v2/api?chainid=204&module=account&action=txlist&address='.$address.'&startblock=0&endblock=99999999&page=1&offset=20&sort=desc&apikey='.$api_key));
	$status = $trans->status;
	if($status != 1) {
		return '';
	}
	$data = $trans->result;
	$arr = array();
	if(count($data) > 0) {
		for($i = 0; $i < count($data); $i++) {
			$txid = $data[$i]->hash;
			$amount = $data[$i]->value / 10000000000;
			$from_address = $data[$i]->from;
			$to_address = $data[$i]->to;
			$timeStamp = $data[$i]->timeStamp;
			if($timeStamp > $time){
				array_push($arr, array(
					'txid'			=> $txid,
					'from_address'	=> $from_address,
					'to_address'	=> $to_address,
					'amount'		=> $amount,
					'time'			=> $timeStamp,
				));
			}
		}
		return $arr;
	}
	return '';
}

function bscapi_get_transaction_info_by_txid_on_opbnb($txid) {
		$res = json_decode(file_get_contents('https://op-bnb-mainnet-explorer-api.nodereal.io/api/tx/getDetail?hash='.$txid));
		if(is_object($res) && isset($res->data->hash)) {
			$data = $res->data;
			$txid = $data->hash;
			$time = $data->blockTimeStamp;
			$from_address = $data->vin->address;
			$to_address = $data->vout->address;
			$amount = $data->value / 10000000000;
			return array(
				'txid'			=> $txid,
				'from_address'	=> $from_address,
				'to_address'	=> $to_address,
				'amount'		=> $amount,
				'time'			=> $time,
			);
		}
		return null;
	}

function bscapi_get_balance_on_opbnb($address) {
	//$api_key = 'ZTKBTWKT8E31KNNUTQEP2WRG77I9G5F2D9';
	$api_key = 'FIJ9P2KGNG69XAM8TKR47P4EADC7465P9G';
	$json = json_decode(file_get_contents('https://api.etherscan.io/v2/api?chainid=204&module=account&action=balance&address='.$address.'&tag=latest&apikey='.$api_key));
	$status = $json->status;
	if($status != 1) {
		return 0;
	}
	$bnbBalance = intval(intval($json->result) / 1000000000000000000);
	return $bnbBalance;
}

function bscapi_get_balance_on_opbnb2($address) {
	$rpc_nodes = [
		"https://opbnb-mainnet-rpc.bnbchain.org",
		"https://opbnb-mainnet.nodereal.io/v1/64a9df0874fb4a93b9d0a3849de012d3",
		"https://opbnb-rpc.publicnode.com"
	];
	$uri = $rpc_nodes[rand(0, count($rpc_nodes) - 1)];
	try {
		$opbnb_api = new OpBnbApi($uri);
		return $opbnb_api->getBalance($address);
	} catch (Exception $e) {
		file_put_contents('rpc_error.txt', $uri.PHP_EOL , FILE_APPEND | LOCK_EX);
		return 0;
	}
}

function bscapi_send_transaction_on_opbnb($from_address, $to_address, $amount, $private_key){
	$rpc_nodes = [
		"https://opbnb-mainnet-rpc.bnbchain.org",
		"https://opbnb-mainnet.nodereal.io/v1/64a9df0874fb4a93b9d0a3849de012d3",
		"https://opbnb-rpc.publicnode.com"
	];
	$uri = $rpc_nodes[rand(0, count($rpc_nodes) - 1)];
	try {
		$opbnb_api = new OpBnbApi($uri);
		return $opbnb_api->transfer($from_address, $to_address, $amount, $private_key);
	} catch (Exception $e) {
		file_put_contents('rpc_error.txt', $uri.PHP_EOL , FILE_APPEND | LOCK_EX);
		return 'Unknown reason';
	}
}