<?php
	
	$base_url = "https://bnbpick.io/";
	function sendMail($from_mail, $from_name, $to_mail, $to_name, $subject, $body) {
		require_once(__DIR__ . '/vendor/autoload.php');

		// Configure API key authorization: api-key
		$config = Brevo\Client\Configuration::getDefaultConfiguration()->setApiKey('api-key', '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');
		// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
		// $config = Brevo\Client\Configuration::getDefaultConfiguration()->setApiKeyPrefix('api-key', 'Bearer');
		// Configure API key authorization: partner-key
		//$config = Brevo\Client\Configuration::getDefaultConfiguration()->setApiKey('partner-key', 'YOUR_API_KEY');
		// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
		// $config = Brevo\Client\Configuration::getDefaultConfiguration()->setApiKeyPrefix('partner-key', 'Bearer');

		$apiInstance = new Brevo\Client\Api\TransactionalEmailsApi(
			// If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
			// This is optional, `GuzzleHttp\Client` will be used as default.
			new GuzzleHttp\Client(),
			$config
		);
		$sendSmtpEmail = new \Brevo\Client\Model\SendSmtpEmail([
			 'subject' => $subject,
			 'sender' => ['name' => $from_name, 'email' => $from_mail],
			 //'replyTo' => ['name' => 'Sendinblue', 'email' => 'contact@sendinblue.com'],
			 'to' => [[ 'name' => $to_name, 'email' => $to_mail]],
			 'htmlContent' => $body,
			 'params' => ['bodyMessage' => $body]
		]); // \Brevo\Client\Model\SendSmtpEmail | Values to send a transactional email

		try {
			$result = $apiInstance->sendTransacEmail($sendSmtpEmail);
			//print_r($result);
			return 'Message has been sent';
		} catch (Exception $e) {
			//echo 'Exception when calling TransactionalEmailsApi->sendTransacEmail: ', $e->getMessage(), PHP_EOL;
			return 'Message has not been sent yet';
		}
	}
	
	/*function sendVerificationEmail($user_id, $from_mail, $from_name, $to_mail, $to_name, $verification_code) {
		$subject = "Bnbpick.io Account Verification";
		$body  = '<h3>Bnbpick Verification</h3>';
		$body .= '<p>Dear '.$to_name.'!</p>';
		$body .= '<p>Thank you for signing up to <a href="'.$GLOBALS['base_url'].'">Bnbpick.io</a>. To provide you the best service possible, we require you to verify your email address. If you are receiving this email and have never signed up with us, please feel free to ignore this email. To finish your verification, please follow the directions below.</p>';
		$body .= '<p>Please click on the link below or copy and paste it into your browser to proceed with your registration.</p>';
		//$body .= '<br/><br/><p><a href="'.$GLOBALS['base_url'].'confirm.php?act=verify_email&key='.$verification_code.'">'.$GLOBALS['base_url'].'confirm.php?userid='.$user_id.'&act=verify_email&key='.$verification_code.'</a></p>';
		$body .= '<br/><br/><p><a href="'.$GLOBALS['base_url'].'confirm.php?act=verify_email&key='.$verification_code.'">'.$GLOBALS['base_url'].'confirm.php?act=verify_email&key='.$verification_code.'</a></p>';
		$body .= '<br/><p>- Team Bnbpick</p>';
		return sendMail($from_mail, $from_name, $to_mail, $to_name, $subject, $body);
	}*/
	
	function sendVerificationEmail($user_id, $from_mail, $from_name, $to_mail, $to_name, $verification_code) {
		$subject = "Verify Your Email Address";
		$body = '';
		$body .= '<!DOCTYPE html>';
		$body .= '<html lang="en">';
		$body .= '<head>';
		$body .= '<meta charset="UTF-8">';
		$body .= '<meta name="viewport" content="width=device-width, initial-scale=1.0">';
		$body .= '<title>Verify Email</title>';
		$body .= '<style>';
		$body .= '    body { font-family: Arial, sans-serif; background-color: #f9f9f9; margin: 0; padding: 0; }';
		$body .= '    .container { max-width: 600px; margin: 30px auto; background: #ffffff; padding: 20px; border-radius: 8px; box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1); }';
		$body .= '    .header { text-align: center; background-color: #2196f3; color: white; padding: 15px; border-radius: 8px 8px 0 0; }';
		$body .= '    .header h1 { margin: 0; font-size: 24px; }';
		$body .= '    .content { padding: 20px; color: #333; }';
		$body .= '    .content p { margin: 10px 0; line-height: 1.6; }';
		$body .= '    .actions { text-align: center; margin: 20px 0; }';
		$body .= '    .actions a { display: inline-block; width: 125px; padding: 10px 20px; text-decoration: none; border-radius: 5px; color: white; margin-bottom: 20px; }';
		$body .= '    .verify-btn { background-color: #28a745; }';
		$body .= '    .cancel-btn { background-color: #dc3545; }';
		$body .= '    .footer { text-align: center; margin-top: 20px; font-size: 14px; color: #777; }';
		$body .= '</style>';
		$body .= '</head>';
		$body .= '<body>';
		$body .= '<div class="container">';
		$body .= '    <div class="header">';
		$body .= '        <h1>Verify Your Email</h1>';
		$body .= '    </div>';
		$body .= '    <div class="content">';
		$body .= '        <p>Dear ' . htmlspecialchars($to_name) . ',</p>';
		$body .= '        <p>Thank you for joining Bnbpick.io! Please verify your email address to activate your account and enjoy our services.</p>';
		$body .= '        <div class="actions">';
		$body .= '            <a href="' . $GLOBALS['base_url'] . 'confirm.php?act=verify_email&key=' . $verification_code . '" class="verify-btn">Verify Email</a>';
		$body .= '        </div>';
		$body .= '        <p>If you did not register with us, you can cancel this request below:</p>';
		$body .= '        <div class="actions">';
		$body .= '            <a href="' . $GLOBALS['base_url'] . 'confirm.php?act=ignore&key=' . $verification_code . '" class="cancel-btn">Cancel Request</a>';
		$body .= '        </div>';
		$body .= '    </div>';
		$body .= '    <div class="footer">';
		$body .= '        <p>Thank you for using Bnbpick.io.</p>';
		$body .= '        <p>- Bnbpick.io Team</p>';
		$body .= '    </div>';
		$body .= '</div>';
		$body .= '</body>';
		$body .= '</html>';
		return sendMail($from_mail, $from_name, $to_mail, $to_name, $subject, $body);
	}

	/*function sendRecoveryEmail($user_id, $from_mail, $from_name, $to_mail, $to_name, $verification_code) {
		$subject = "Password Reset Email For Your Bnbpick.io Account";
		$body  = '<h3>Password Reset Email</h3>';
		
		$body .= '<p>Dear '.$to_name.'!</p>';
		$body .= '<p>To reset your password at Bnbpick.io, please click the link below.</p>';
		$body .= '<br/><p><a href="'.$GLOBALS['base_url'].'confirm.php?act=recover_password&key='.$verification_code.'">'.$GLOBALS['base_url'].'confirm.php?act=recover_password&key='.$verification_code.'</a></p>';
		$body .= '<br/><p>In case you did not request for your password to be reset, please click on <a href="'.$GLOBALS['base_url'].'confirm.php?act=ignore&key='.$verification_code.'">this link</a> to cancel the request.</p>';
		$body .= '<br/><p>- Team Bnbpick</p>';
		return sendMail($from_mail, $from_name, $to_mail, $to_name, $subject, $body);
	}*/
	
	function sendRecoveryEmail($user_id, $from_mail, $from_name, $to_mail, $to_name, $verification_code) {
		$subject = "Password Recovery Assistance";
		$body = '';
		$body .= '<!DOCTYPE html>';
		$body .= '<html lang="en">';
		$body .= '<head>';
		$body .= '<meta charset="UTF-8">';
		$body .= '<meta name="viewport" content="width=device-width, initial-scale=1.0">';
		$body .= '<title>Password Recovery</title>';
		$body .= '<style>';
		$body .= '    body { font-family: Arial, sans-serif; background-color: #f9f9f9; margin: 0; padding: 0; }';
		$body .= '    .container { max-width: 600px; margin: 30px auto; background: #ffffff; padding: 20px; border-radius: 8px; box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1); }';
		$body .= '    .header { text-align: center; background-color: #2196f3; color: white; padding: 15px; border-radius: 8px 8px 0 0; }';
		$body .= '    .header h1 { margin: 0; font-size: 24px; }';
		$body .= '    .content { padding: 20px; color: #333; }';
		$body .= '    .content p { margin: 10px 0; line-height: 1.6; }';
		$body .= '    .actions { text-align: center; margin: 20px 0; }';
		$body .= '    .actions a { display: inline-block; width: 125px; padding: 10px 20px; text-decoration: none; border-radius: 5px; color: white; margin-bottom: 20px; }';
		$body .= '    .reset-btn { background-color: #28a745; }';
		$body .= '    .cancel-btn { background-color: #dc3545; }';
		$body .= '    .footer { text-align: center; margin-top: 20px; font-size: 14px; color: #777; }';
		$body .= '</style>';
		$body .= '</head>';
		$body .= '<body>';
		$body .= '<div class="container">';
		$body .= '    <div class="header">';
		$body .= '        <h1>Password Recovery</h1>';
		$body .= '    </div>';
		$body .= '    <div class="content">';
		$body .= '        <p>Dear ' . htmlspecialchars($to_name) . ',</p>';
		$body .= '        <p>We received a request to reset the password for your account at Bnbpick.io. If you initiated this request, you can reset your password using the button below:</p>';
		$body .= '        <div class="actions">';
		$body .= '            <a href="' . $GLOBALS['base_url'] . 'confirm.php?act=recover_password&key=' . $verification_code . '" class="reset-btn">Reset Password</a>';
		$body .= '        </div>';
		$body .= '        <p>If you did not make this request, no action is required. Simply cancel the request and ignore this email.</p>';
		$body .= '        <div class="actions">';
		$body .= '            <a href="' . $GLOBALS['base_url'] . 'confirm.php?act=ignore&key=' . $verification_code . '" class="cancel-btn">Cancel Request</a>';
		$body .= '        </div>';
		$body .= '        <p>Your security is important to us. If you have any questions or need further assistance, please contact our support team at <a href="mailto:support@bnbpick.io">support@bnbpick.io</a>.</p>';
		$body .= '    </div>';
		$body .= '    <div class="footer">';
		$body .= '        <p>Thank you for using Bnbpick.io.</p>';
		$body .= '        <p>- The Bnbpick.io Team</p>';
		$body .= '    </div>';
		$body .= '</div>';
		$body .= '</body>';
		$body .= '</html>';
		return sendMail($from_mail, $from_name, $to_mail, $to_name, $subject, $body);
	}

	/*function sendDisable2FAEmail($user_id, $from_mail, $from_name, $to_mail, $to_name, $verification_code) {
		$subject = "Disable 2FA Email For Your Bnbpick.io Account";
		$body  = '<h3>Disable 2FA Email</h3>';
		
		$body .= '<p>Dear '.$to_name.'!</p>';
		$body .= '<p>To disable your 2FA at Bnbpick.io, please click the link below.</p>';
		$body .= '<br/><p><a href="'.$GLOBALS['base_url'].'confirm.php?act=disable_2fa&key='.$verification_code.'">'.$GLOBALS['base_url'].'confirm.php?act=disable_2fa&key='.$verification_code.'</a></p>';
		$body .= '<br/><p>In case you did not request for your password to be reset, please click on <a href="'.$GLOBALS['base_url'].'confirm.php?act=ignore&key='.$verification_code.'">this link</a> to cancel the request.</p>';
		$body .= '<br/><p>- Team Bnbpick</p>';
		return sendMail($from_mail, $from_name, $to_mail, $to_name, $subject, $body);
	}*/
	
	function sendDisable2FAEmail($user_id, $from_mail, $from_name, $to_mail, $to_name, $verification_code) {
		$subject = "Disable Two-Factor Authentication for Your Bnbpick.io Account";
		$body = '';
		$body .= '<!DOCTYPE html>';
		$body .= '<html lang="en">';
		$body .= '<head>';
		$body .= '<meta charset="UTF-8">';
		$body .= '<meta name="viewport" content="width=device-width, initial-scale=1.0">';
		$body .= '<title>Disable 2FA</title>';
		$body .= '<style>';
		$body .= '    body { font-family: Arial, sans-serif; background-color: #f9f9f9; margin: 0; padding: 0; }';
		$body .= '    .container { max-width: 600px; margin: 30px auto; background: #ffffff; padding: 20px; border-radius: 8px; box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1); }';
		$body .= '    .header { text-align: center; background-color: #2196f3; color: white; padding: 15px; border-radius: 8px 8px 0 0; }';
		$body .= '    .header h1 { margin: 0; font-size: 24px; }';
		$body .= '    .content { padding: 20px; color: #333; }';
		$body .= '    .content p { margin: 10px 0; line-height: 1.6; }';
		$body .= '    .actions { text-align: center; margin: 20px 0; }';
		$body .= '    .actions a { display: inline-block; width: 125px; padding: 10px 20px; text-decoration: none; border-radius: 5px; color: white; margin-bottom: 20px; }';
		$body .= '    .confirm-btn { background-color: #28a745; }';
		$body .= '    .cancel-btn { background-color: #dc3545; }';
		$body .= '    .footer { text-align: center; margin-top: 20px; font-size: 14px; color: #777; }';
		$body .= '</style>';
		$body .= '</head>';
		$body .= '<body>';
		$body .= '<div class="container">';
		$body .= '    <div class="header">';
		$body .= '        <h1>Disable Two-Factor Authentication</h1>';
		$body .= '    </div>';
		$body .= '    <div class="content">';
		$body .= '        <p>Dear ' . htmlspecialchars($to_name) . ',</p>';
		$body .= '        <p>We have received a request to disable Two-Factor Authentication (2FA) for your account at Bnbpick.io.</p>';
		$body .= '        <p>If this request was made by you, please confirm below:</p>';
		$body .= '        <div class="actions">';
		$body .= '            <a href="' . $GLOBALS['base_url'] . 'confirm.php?act=disable_2fa&key=' . $verification_code . '" class="confirm-btn">Disable 2FA</a>';
		$body .= '        </div>';
		$body .= '        <p>If you did not make this request, you can cancel it and ignore this email:</p>';
		$body .= '        <div class="actions">';
		$body .= '            <a href="' . $GLOBALS['base_url'] . 'confirm.php?act=ignore&key=' . $verification_code . '" class="cancel-btn">Cancel Request</a>';
		$body .= '        </div>';
		$body .= '    </div>';
		$body .= '    <div class="footer">';
		$body .= '        <p>Thank you for using Bnbpick.io.</p>';
		$body .= '        <p>- Bnbpick.io Team</p>';
		$body .= '    </div>';
		$body .= '</div>';
		$body .= '</body>';
		$body .= '</html>';
		return sendMail($from_mail, $from_name, $to_mail, $to_name, $subject, $body);
	}

	/*function sendWithdrawalConfirmationEmail($user_id, $from_mail, $from_name, $to_mail, $to_name, $verification_code, $amount, $address) {
		$subject = "Bnbpick.io Withdrawal Confirmation";
		$body  = '<h3>Withdrawal Confirmation</h3>';
		$body .= '<p>Dear '.$to_name.'!</p>';
		$body .= '<p>You requested to withdraw '.$amount.' BNB to address '.$address.'. This is your first time withdrawing with this address. Please confirm this action by clicking on this link</p>';
		$body .= '<br/><p><a href="'.$GLOBALS['base_url'].'confirm.php?act=confirm_withdrawal&key='.$verification_code.'">'.$GLOBALS['base_url'].'confirm.php?act=confirm_withdrawal&key='.$verification_code.'</a></p>';
		$body .= '<br/><p>In case you did not request to withdraw, please contact with Bnbpick support immediately at support@bnbpick.io.</p>';
		$body .= '<br/><p>- Team Bnbpick</p>';
		return sendMail($from_mail, $from_name, $to_mail, $to_name, $subject, $body);
	}*/
	
	function sendWithdrawalConfirmationEmail($user_id, $from_mail, $from_name, $to_mail, $to_name, $verification_code, $amount, $address) {
		$subject = "Withdrawal Confirmation Required for Your Bnbpick.io Account";
		$body = '';
		$body .= '<!DOCTYPE html>';
		$body .= '<html lang="en">';
		$body .= '<head>';
		$body .= '<meta charset="UTF-8">';
		$body .= '<meta name="viewport" content="width=device-width, initial-scale=1.0">';
		$body .= '<title>Withdrawal Confirmation</title>';
		$body .= '<style>';
		$body .= '    body { font-family: Arial, sans-serif; background-color: #f9f9f9; margin: 0; padding: 0; }';
		$body .= '    .container { max-width: 600px; margin: 30px auto; background: #ffffff; padding: 20px; border-radius: 8px; box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1); }';
		$body .= '    .header { text-align: center; background-color: #2196f3; color: white; padding: 15px; border-radius: 8px 8px 0 0; }';
		$body .= '    .header h1 { margin: 0; font-size: 24px; }';
		$body .= '    .content { padding: 20px; color: #333; }';
		$body .= '    .content p { margin: 10px 0; line-height: 1.6; }';
		$body .= '    .address { background-color: #f8f9fa; border: 1px solid #ddd; border-radius: 5px; padding: 10px; font-family: "Courier New", Courier, monospace; color: #007bff; word-break: break-word; margin: 10px 0; }';
		$body .= '    .actions { text-align: center; margin: 20px 0; }';
		$body .= '    .actions a { display: inline-block; width: 125px; padding: 10px 20px; text-decoration: none; border-radius: 5px; color: white; margin-bottom: 20px; }';
		$body .= '    .confirm-btn { background-color: #28a745; }';
		$body .= '    .cancel-btn { background-color: #dc3545; }';
		$body .= '    .footer { text-align: center; margin-top: 20px; font-size: 14px; color: #777; }';
		$body .= '</style>';
		$body .= '</head>';
		$body .= '<body>';
		$body .= '<div class="container">';
		$body .= '    <div class="header">';
		$body .= '        <h1>Withdrawal Confirmation</h1>';
		$body .= '    </div>';
		$body .= '    <div class="content">';
		$body .= '        <p>Dear ' . htmlspecialchars($to_name) . ',</p>';
		$body .= '        <p>We have received a request to withdraw <strong>' . htmlspecialchars($amount) . ' BNB</strong> to the following address:</p>';
		$body .= '        <div class="address">' . htmlspecialchars($address) . '</div>';
		$body .= '        <p>If this request was made by you, please confirm below:</p>';
		$body .= '        <div class="actions">';
		$body .= '            <a href="' . $GLOBALS['base_url'] . 'confirm.php?act=confirm_withdrawal&key=' . $verification_code . '" class="confirm-btn">Confirm Withdrawal</a><br/>';
		$body .= '        </div>';
		$body .= '        <p>If you did not make this request, you can cancel it and ignore this email.</p>';
		$body .= '        <div class="actions">';
		$body .= '            <a href="' . $GLOBALS['base_url'] . 'confirm.php?act=ignore&key=' . $verification_code . '" class="cancel-btn">Cancel Request</a>';
		$body .= '        </div>';
		$body .= '    </div>';
		$body .= '    <div class="footer">';
		$body .= '        <p>Thank you for using Bnbpick.io.</p>';
		$body .= '        <p>- Bnbpick.io Team</p>';
		$body .= '    </div>';
		$body .= '</div>';
		$body .= '</body>';
		$body .= '</html>';
		return sendMail($from_mail, $from_name, $to_mail, $to_name, $subject, $body);
	}

	function sendPaymentEmail($from_mail, $from_name, $to_mail, $to_name) {
		$subject = "Bnbpick.io Payment Notification";
		$body  = '<h3>Payment Notification</h3>';
		$body .= '<p>Dear '.$to_name.'!</p>';
		$body .= '<p>Your withdrawal request is now being processed. Visit <a href="'.$GLOBALS['base_url'].'withdraw.php">'.$GLOBALS['base_url'].'withdraw.php</a> to view your withdrawal status.</p>';
		$body .= "<br/><p>If you don't receive your trons after many hours, please contact us with Bnbpick support immediately at support@bnbpick.io. Thank you for using our services.</p>";
		$body .= '<br/><p>- Team Bnbpick</p>';
		return sendMail($from_mail, $from_name, $to_mail, $to_name, $subject, $body);
	}
	function sendPaymentAndReviewEmail($from_mail, $from_name, $to_mail, $to_name) {
		$subject = "Bnbpick.io Payment Notification";
		$body  = '<h3>Payment Notification</h3>';
		$body .= '<p>Dear '.$to_name.'!</p>';
		$body .= '<p>Your withdrawal request is now being processed. Visit <a href="'.$GLOBALS['base_url'].'withdraw.php">'.$GLOBALS['base_url'].'withdraw.php</a> to view your withdrawal status.</p>';
		$body .= "<br/><p>If you are satisfied with our services, please help us evaluate the website on <a href='https://www.trustpilot.com/review/bnbpick.io'>Trustpilot</a>. You can also comment so we can bring the best services to customers.</p>";
		$body .= '<br/><p>- Team Bnbpick</p>';
		return sendMail($from_mail, $from_name, $to_mail, $to_name, $subject, $body);
	}
	function sendUpdatePasswordEmail($from_mail, $from_name, $to_mail, $to_name) {
		$subject = "Bnbpick.io Password Updated Notification";
		$body  = '<h3>Your password has been changed</h3>';
		$body .= '<p>Dear '.$to_name.'!</p>';
		$body .= "<p>This is a confirmation that your password was changed at ".date("h:i A, l jS \of F Y").". <br/>Didn't change your password? Contact support@bnbpick.io so we can make sure no one else trying to access your account.</p>";
		$body .= '<br/><p>- Team Bnbpick</p>';
		return sendMail($from_mail, $from_name, $to_mail, $to_name, $subject, $body);
	}
	function sendDepositConfirmationEmail($from_mail, $from_name, $to_mail, $to_name, $amount) {
		$subject = "Bnbpick.io Deposit Confirmation";
		$body  = '<h3>Deposit Confirmation</h3>';
		$body .= '<p>Dear '.$to_name.'!</p>';
		$body .= '<p>Your payment of '.$amount.' BNB has been deposited into your Bnbpick account. You can go to <a href="'.$GLOBALS['base_url'].'deposit.php">'.$GLOBALS['base_url'].'deposit.php</a> and review this transaction.</p>';
		$body .= '<br/><p>- Team Bnbpick</p>';
		return sendMail($from_mail, $from_name, $to_mail, $to_name, $subject, $body);
	}

	function sendAccountTerminationEmail($from_mail, $from_name, $to_mail, $to_name) {
		$subject = "Bnbpick.io Account Termination";
		$body  = '<h3>Account Termination</h3>';
		$body .= '<p>Dear '.$to_name.'!</p>';
		$body .= '<p>We would like to inform you that your account has been terminated as a result of violations of our policies. You have 24 hours to appeal. If you are unable to provide any proof, your account will be permanently terminated.</p>';
		$body .= '<br/><p>- Team Bnbpick</p>';
		return sendMail($from_mail, $from_name, $to_mail, $to_name, $subject, $body);
	}

	/*function sendDepositNotificationToAdminEmail($from_mail, $from_name, $to_mail, $to_name, $amount) {
		$subject = "Deposit request";
		$body  = 'Hello admin!.<br/> Someone has just deposited amount of '.$amount.' Satoshis. Please login and check the transaction.';
		return sendMail($from_mail, $from_name, $to_mail, $to_name, $subject, $body);
	}

	function sendWithdrawalNotificationToAdminEmail($from_mail, $from_name, $to_mail, $to_name) {
		$subject = "Withdrawal request";
		$body  = 'Hello admin!.<br/> Someone has just confirmed his withdrawal request. Please process the resquest as soon as posible.';
		$to_mail = 'bitbet910@gmail.com';
		return sendMail($from_mail, $from_name, $to_mail, $to_name, $subject, $body);
	}*/

?>