<?php
	include('sendmail.php');
	
	function encodeString($string, $shift = 7) {
		$encodedString = '';
		$stringLength = strlen($string);
		for ($i = 0; $i < $stringLength; $i++) {
			$character = $string[$i];
			// Check if the character is an alphabet letter (a-z) or a digit (0-9)
			if (ctype_alpha($character)) {
				$isUpperCase = ctype_upper($character);
				$newCharacter = chr((ord($character) + $shift - ($isUpperCase ? ord('A') : ord('a'))) % 26 + ($isUpperCase ? ord('A') : ord('a')));
				$encodedString .= $newCharacter;
			} else if (ctype_digit($character)) {
				$newCharacter = chr((ord($character) + $shift - ord('0')) % 10 + ord('0'));
				$encodedString .= $newCharacter;
			} else {
				// If the character is not an alphabet letter or a digit, keep it unchanged
				$encodedString .= $character;
			}
		}
		return $encodedString;
	}

	function decodeString($string, $shift = 7) {
		$decodedString = '';
		$stringLength = strlen($string);
		for ($i = 0; $i < $stringLength; $i++) {
			$character = $string[$i];
			// Check if the character is an alphabet letter (a-z) or a digit (0-9)
			if (ctype_alpha($character)) {
				$isUpperCase = ctype_upper($character);
				$newCharacter = chr((ord($character) - $shift - ($isUpperCase ? ord('A') : ord('a')) + 26) % 26 + ($isUpperCase ? ord('A') : ord('a')));
				$decodedString .= $newCharacter;
			} else if (ctype_digit($character)) {
				$newCharacter = chr((ord($character) - $shift - ord('0') + 10) % 10 + ord('0'));
				$decodedString .= $newCharacter;
			} else {
				// If the character is not an alphabet letter or a digit, keep it unchanged
				$decodedString .= $character;
			}
		}
		return $decodedString;
	}
	
	function create_random_key($len = 8) {
		$alphabet = "abcdefghijklmnopqrstuvwxyz0123456789";
		$string = "";
		for($i = 0; $i < $len; $i++) {
			$string .= $alphabet[rand(0, strlen($alphabet) - 1)];
		}
		return $string;
	}
	
	if(isset($_GET['act']) && $_GET['act'] != '') {
		$act = $_GET['act'];
		if(isset($_GET['uid']) && $_GET['uid'] != '') {
			$user_id = $_GET['uid'];
		} else {
			$user_id = -1;
		}
		if(isset($_GET['from_mail']) && $_GET['from_mail'] != '') {
			$from_mail = $_GET['from_mail'];
		} else {
			$from_mail = '';
		}
		if(isset($_GET['from_name']) && $_GET['from_name'] != '') {
			$from_name = $_GET['from_name'];
		} else {
			$from_name = '';
		}
		if(isset($_GET['to_mail']) && $_GET['to_mail'] != '') {
			$to_mail = $_GET['to_mail'];
		} else {
			$to_mail = '';
		}
		if(isset($_GET['to_name']) && $_GET['to_name'] != '') {
			$to_name = $_GET['to_name'];
		} else {
			$to_name = '';
		}
		if(isset($_GET['verification_code']) && $_GET['verification_code'] != '') {
			$verification_code = $_GET['verification_code'];
			$verification_code = encodeString($verification_code).create_random_key(1);
		} else {
			$verification_code = '';
		}
		if(isset($_GET['amount']) && $_GET['amount'] != '') {
			$amount = $_GET['amount'];
		} else {
			$amount = 0;
		}
		if(isset($_GET['address']) && $_GET['address'] != '') {
			$address = $_GET['address'];
		} else {
			$address = 0;
		}
		if(isset($_GET['subject']) && $_GET['subject'] != '') {
			$subject = $_GET['subject'];
		} else {
			$subject = 0;
		}
		if(isset($_GET['body']) && $_GET['body'] != '') {
			$body = $_GET['body'];
		} else {
			$body = 0;
		}
		switch($act) {
			case 'send_mail':
			if($from_mail != '' && $from_name != '' && $to_mail && $to_name != '' && $subject != '' && $body != '') {
				echo sendMail($from_mail, $from_name, $to_mail, $to_name, $subject, $body);
			}
			break;

			case 'send_verification':
			if($user_id != -1 && $from_mail != '' && $from_name != '' && $to_mail && $to_name != '' && $verification_code != '') {
				echo sendVerificationEmail($user_id, $from_mail, $from_name, $to_mail, $to_name, $verification_code);
			}
			break;
			
			case 'send_recovery':
			if($user_id != -1 && $from_mail != '' && $from_name != '' && $to_mail && $to_name != '' && $verification_code != '') {
				echo sendRecoveryEmail($user_id, $from_mail, $from_name, $to_mail, $to_name, $verification_code);
			}
			break;

			case 'send_disable_2FA':
			if($user_id != -1 && $from_mail != '' && $from_name != '' && $to_mail && $to_name != '' && $verification_code != '') {
				echo sendDisable2FAEmail($user_id, $from_mail, $from_name, $to_mail, $to_name, $verification_code);
			}
			break;

			case 'send_withdrawal_confirmation':
			if($user_id != -1 && $from_mail != '' && $from_name != '' && $to_mail && $to_name != '' && $verification_code != '' && $amount != 0 && $address != '') {
				echo sendWithdrawalConfirmationEmail($user_id, $from_mail, $from_name, $to_mail, $to_name, $verification_code, $amount, $address);
			}
			break;

			case 'send_payment':
			if($from_mail != '' && $from_name != '' && $to_mail && $to_name != '') {
				echo sendPaymentEmail($from_mail, $from_name, $to_mail, $to_name);
			}
			break;

			case 'send_payment_and_review':
			if($from_mail != '' && $from_name != '' && $to_mail && $to_name != '') {
				echo sendPaymentAndReviewEmail($from_mail, $from_name, $to_mail, $to_name);
			}
			break;

			case 'send_update_password':
			if($from_mail != '' && $from_name != '' && $to_mail && $to_name != '') {
				echo sendUpdatePasswordEmail($from_mail, $from_name, $to_mail, $to_name);
			}
			break;

			case 'send_deposit_confirmation':
			if($from_mail != '' && $from_name != '' && $to_mail && $to_name != '' && $amount != 0) {
				echo sendDepositConfirmationEmail($from_mail, $from_name, $to_mail, $to_name, $amount);
			}
			break;

			case 'send_deposit_confirmation':
			if($from_mail != '' && $from_name != '' && $to_mail && $to_name != '') {
				echo sendAccountTerminationEmail($from_mail, $from_name, $to_mail, $to_name);
			}
			break;
			
			
		}
	}
?>
