<!DOCTYPE html>
<html lang="en">
	<?php include('header.php');?>
	<style>
		#withdrawal_address {
			min-height: 45px;
			border-right: 0px;
			box-shadow: none;
			line-height: 20px;
			padding: 10px;
			overflow: hidden;
		}
		@media only screen and (min-width: 600px) {
			#withdrawal_address {
				height: 45px;
				line-height: 23px;
			}
		}
		#withdrawal_address:focus {
			border: 1px solid #ccc;
			border-right: none;
		}
		.dark_mode #withdrawal_address:focus {
			border: 2px solid #2f4553;
			border-right: none;
		}
		#address_verification {
			background: #FFF;
			padding: 9px;
			width: 45px;
			height: 45px;
		}
		.dark_mode #address_verification {
			background: #0f212e!important;
			border: 2px solid #2f4553;
			border-left: none;
		}
		.dark_mode .form-wrapper__main {
			background: #213743 !important;
			border: none;
			box-shadow: 0 8px 17px 2px rgba(0,0,0,.14), 0 3px 14px 2px rgba(0,0,0,.12), 0 5px 5px -3px rgba(0,0,0,.2);
			border-radius: 2px;
		}
		.dark_mode .form__input#network {
			background: #0f212e !important;
		}
		.withdrawal_amount_group #max_amount, .withdrawal_amount_group #min_amount {
			width: 40px;
			height: 45px;
			line-height: 44px;
			vertical-align: middle;
			background: #8bc34a;
			font-size: 13px;
			color: #fff;
			cursor: pointer;
			position: relative;
			float: left;
			text-align: center;
			margin-top: 0px;
		}
		.withdrawal_amount_group #max_amount:before {
			content: "";
			position: absolute;
			top: 8px;
			left: 0;
			width: 1px;
			height: 28px;
			background: #EFEFEF;
		}
		.withdrawal_amount_group #max_amount:hover, .withdrawal_amount_group #min_amount:hover {
			background: #7fb541;
		}
	</style>
	<?php if(isset($user_info) && $user_info->dark_mode == 1):?>
	<body class="dark_mode">
	<?php else:?>
	<body>
	<?php endif?>
		<?php include('menu.php');?>
		<section class="get_form_nine_area p_100" style="padding-top: 120px">
			<div class="container">
				<div class="single_title_n">
				
					<?php if($unconfirmed_requests > 0):?>
					<div class="alert alert-info">
						<?php 
							echo $langs['withdrawal_email_confirm_required'];
						?>
					</div>
					<?php endif?>
				
					<h2><?=$langs['withdraw_page_heading']?></h2>
					<div class="form-wrapper" style="margin-top: 50px">
						<div class="form-wrapper__inner">
							<div class="form-wrapper__main" style="width: 100%; max-width: 600px">
								<p><?=$langs['withdrawal_guide']?></p>
								<section class="coin-withdrawal-form" style="margin-top: 20px">
									
									<div class="form__input-wrapper">
										<div style="margin: 0px auto; max-width: 500px; text-align: left"><label class="form__label"><?=$langs['select_network_label']?></label></div>
										<div class="form__input-container">
											<select class="form__input" type="text" id="network" name="network" style="padding:5px 15px; max-width: 500px" disabled="disabled">
												<option value="BSC">BNB Smart Chain (BEP20)</option>
											</select>
										</div>
									</div>
									
									<div class="input-group" style="margin: 20px auto 0px; height: 45px; max-width: 500px; width: 100%; font-size: 14px">
										<span class="input-group-addon" style="border-radius: 0px; width: 45px"><img src="<?=base_url()?>assets/img/bnb.svg"/></span>
										<!--<input id="withdrawal_address" name="withdrawal_address" type="text" class="form-control" placeholder="BNB address">-->
										<textarea id="withdrawal_address" name="withdrawal_address" type="text" class="form-control" placeholder="<?=$langs['withdrawal_address']?>"></textarea>
										<span class="input-group-addon" id="address_verification"></span>
									</div>
									<div class="input-group withdrawal_amount_group" style="margin: 20px auto 0px; height: 45px; max-width: 500px; font-size: 14px">
										<span class="input-group-addon" style="border-radius: 0px;  padding: 14px 13.5px"><i class="fas fa-money-bill-alt"></i></span>
										<input id="withdrawal_amount" name="withdrawal_amount" type="text" class="form-control" placeholder="<?=$langs['withdrawal_amount']?>"  style="height: 45px; width: calc(100% - 80px)">
										<span id="min_amount">Min</span>
										<span id="max_amount">Max</span>
									</div>
									<div class="input-group" style="margin: 20px auto 0px; height: 45px; max-width: 500px; font-size: 14px">
										<span class="input-group-addon" style="border-radius: 0px; padding: 14px 13px"><i class="fas fa-funnel-dollar"></i></span>
										<?php if($user_info->user_level >= 3) {
											$withdrawal_fee = 0;
										}
										?>
										<div id="withdrawal_fee" name="withdrawal_fee" type="text" class="form-control" style="height: 45px; background: #FFF; text-align: left; line-height: 30px"><?=$langs['transaction_fee']?>: <b style="color: #0083ff" id="transaction_fee"><?=number_format($withdrawal_fee / 100000000, 8, '.', '')?> BNB</b></div>
									</div>
									<?php if($user_info->enable_2fa):?>
									<div class="input-group" style="margin: 20px auto 0px; height: 45px; max-width: 500px; font-size: 14px">
										<span class="input-group-addon" style="border-radius: 0px; padding: 14px 13px"><i class="fas fa-keyboard"></i></span>
										<input id="withdrawal_2fa_code" name="withdrawal_2fa_code" type="text" class="form-control" placeholder="<?=$langs['enter_2FA_code']?>" style="height: 45px;">
									</div>
									<?php endif?>
									
									<!--- new captcha ----->
									<div class="form__input-wrapper" style="margin: 20px auto 0px; max-width: 300px">
										<div class="form__input-container">
											<select class="form__input" type="text" id="select_captcha" name="select_captcha" style="padding:5px 15px; max-width: 300px">
												<option value="1">reCAPTCHA</option>
												<option value="2">hCaptcha</option>
												<option value="3" selected>Cloudflare Turnstile</option>
											</select>
										</div>
									</div>
									<div class="captcha-box" style="margin-top: 20px; display: none">
										<form name="captcha_form" method="POST">
											<img class="captcha-image" src="<?=base_url()?>captcha.php"/>
											<div><input type="text" class="form-control" style="background: #FFF; padding: 10px;" placeholder="Enter captcha" id="captcha" name="captcha"/></div>
											<p>Can't read? Click <a href="javascript:refresh_captcha();">here</a> to refresh</p>
										</form>
									</div>
									<div id="g_recaptcha" class="g-recaptcha" style="margin-top: 20px; margin-left: calc(50% - 150px); display: none" data-sitekey="<?=$gg_site_key?>"></div>
									<div id="hCaptchaBox" style="margin-top: 20px; display: none"></div>
									<div id="cf_turnstile" class="cf-turnstile" style="margin-top: 20px; display: block" data-sitekey="<?=$cloudflare_site_key?>" data-theme="light"></div>
									<!--- new captcha ----->
									
									
									<button id="process_withdraw_bnb" class="process_btn" type="submit" onclick="process_withdraw_bnb()" style="width: 300px; margin-top: 20px"><span><?=$langs['withdraw_btn']?></span><img src="<?=base_url()?>assets/img/loading.gif" style="width: 35px; display: none;"></button>
								</section>	
							</div>
						</div>
					</div>
					
					<div style="width: 100%; overflow-x: auto; margin-top: 30px">
						<table class="table table-striped bets_table">
							<thead>
								<tr>
									<td><?=$langs['trans_tbl_amount']?></td>
									<td><?=$langs['trans_tbl_address']?> / TxID</td> <!-- Merge Address + TxID -->
									<td><?=$langs['trans_tbl_status']?></td> <!-- Merge Status + Date -->
								</tr>
							</thead>
							<tbody>
								<?php if(isset($user_transactions) && $user_transactions != null): ?>
									<?php foreach($user_transactions as $row): ?>
										<tr>
											<!-- Amount + USD -->
											<td>
												<?php
													$amount = $row->amount / 100000000;
													echo (floor($amount) == $amount) ? intval($amount) : rtrim(rtrim(number_format($amount, 8, '.', ''), '0'), '.');
												?>
												BNB
												<br/>
												<span style="color: #00bcd4">
													$<?=number_format(floatval($row->USD_value), 2, '.', '')?>
												</span>
											</td>

											<!-- Address + TxID -->
											<td>
												<a href="https://bscscan.com/address/<?=$row->address?>">
													<?=substr($row->address, 0, 6).'...'.substr($row->address, -6)?>
												</a>
												<i class="far fa-copy fa-fw js_clipboard" data-copy="<?=$row->address?>" style="color: #adb5bd; cursor: pointer" data-toggle="tooltip" title="Copy"></i>
												<br/>
												<?php if(!empty($row->txid)): ?>
													<?php
														if(strlen($row->txid) > 30) {
															if(strpos($row->txid, "1x") !== false) {
																$row->txid = str_replace("1x", "0x", $row->txid);
																echo '<a href="https://opbnbscan.com/tx/'.$row->txid.'" style="color: #4caf50">'.substr($row->txid, 0, 6).'...'.substr($row->txid, -6).'</a>';
															} else {
																echo '<a href="https://bscscan.com/tx/'.$row->txid.'" style="color: #4caf50">'.substr($row->txid, 0, 6).'...'.substr($row->txid, -6).'</a>';
															}
														} else {
															echo '<a href="javascript:void(0)" style="color: #777">'.$row->txid.'</a>';
														}
													?>
													<i class="far fa-copy fa-fw js_clipboard" data-copy="<?=$row->txid?>" style="color: #adb5bd; cursor: pointer" data-toggle="tooltip" title="Copy"></i>
												<?php endif; ?>
											</td>

											<!-- Status + Date -->
											<td>
												<?php
													if($row->status == 'Completed') {
														echo '<span style="color: #8bc34a">'.$langs['trans_stt_completed'].'</span>';
													} else if ($row->status == 'Processing') {
														echo '<a href="javascript:void(0)" style="color: #03A9F4" title="'.$langs['trans_stt_processing_desc'].'">'.$langs['trans_stt_processing'].'</a>';
													} else if ($row->status == 'Unconfirmed') {
														echo '<span title="'.$langs['trans_stt_unconfirmed_guide'].'">'.$langs['trans_stt_unconfirmed'].'</span> | <a style="color: #ff5722" href="javascript:void(0)" onclick="process_cancel_request('.$row->id.')">'.$langs['trans_act_cancel'].'</a>';
													} else if ($row->status == 'Canceled') {
														echo '<span style="color: #999">'.$langs['trans_stt_cancelled'].'</span>';
													} else if ($row->status == 'Pending') {
														echo '<span style="color: #ff9800">'.$langs['trans_stt_pending'].'</span>';
													} else {
														echo htmlspecialchars($row->status);
													}
												?>
												<br/>
												<?php
													if(date('Y-m-d', $row->time) == date('Y-m-d')) {
														echo date('H:i:s A', $row->time);
													} else {
														echo date('Y-m-d', $row->time);
													}
												?>
											</td>
										</tr>
									<?php endforeach; ?>
								<?php else: ?>
									<tr><td colspan="3"><?=$langs['no_trans_found']?></td></tr>
								<?php endif; ?>
							</tbody>
						</table>
						<?php if($pagination != '') echo '<div class="pagination">'.$pagination.'</div>';?>
					</div>
			   </div>
			</div>
		</section>
		<?php include('footer.php');?>
		
		<script>
			$( "#withdrawal_address").change(function() {
				var address = $('#withdrawal_address').val();
				if(address == '') {
					$('#address_verification').html('');
				} else {
					var check_valid = WAValidator.validate(address, 'bnb');
					if(check_valid) {
						/*$.ajax({
							url: "<?=base_url()?>process.php",
							type: "POST",
							data: "action=check_address_verification&withdrawal_address="+address,
							error: function(){},
							success: function(out){
								let obj = JSON.parse(out);
								if(obj.ret == 0) {
									$('#address_verification').html('<i class="fas fa-question-circle" style="color: #ff9800; font-size: 22px" title="This is a valid address but it has not been verified."></i>');
								} else {
									$('#address_verification').html('<i class="fas fa-check-circle" style="color: #8bc34a; font-size: 22px" title="This address is valid and has been verified"></i>');
								}
							}
						});*/
						$('#address_verification').html('<i class="fas fa-check-circle" style="color: #8bc34a; font-size: 22px" title="<?=$langs['invalid_address_err']?>"></i>');
					} else {
						$('#address_verification').html('<i class="fas fa-times-circle" style="color: #f44336; font-size: 22px" title="<?=$langs['invalid_address_err']?>"></i>');
					}
				}
				
			});
			
			$( "#withdrawal_amount").change(function() {
				var minimum_withdrawal = parseFloat(<?=number_format($minimum_withdrawal / 100000000, 8, '.', '')?>);
				var user_balance = parseFloat(<?=number_format($user_info->balance/ 100000000, 8, '.', '')?>);
				
				var withdrawal_amount = parseFloat($('#withdrawal_amount').val());
				console.log(withdrawal_amount);
				if(withdrawal_amount < minimum_withdrawal || isNaN(withdrawal_amount)) {
					withdrawal_amount = minimum_withdrawal;
				}
				if(withdrawal_amount > user_balance) {
					withdrawal_amount = user_balance;
				}
				$('#withdrawal_amount').val(withdrawal_amount.toFixed(8));
			});
			
			$( "#max_amount").click(function() {
				var user_balance = parseFloat(<?=number_format($user_info->balance/ 100000000, 8, '.', '')?>).toFixed(8);
				$('#withdrawal_amount').val(user_balance);
			});
			
			$( "#min_amount").click(function() {
				var minimum_withdrawal = parseFloat(<?=number_format($minimum_withdrawal / 100000000, 8, '.', '')?>).toFixed(8);
				$('#withdrawal_amount').val(minimum_withdrawal);
				
			});
			
		</script>
	</body>
</html>