<!DOCTYPE html>
<html lang="en">
	<?php include('header.php');?>
	<?php if(isset($user_info) && $user_info->dark_mode == 1):?>
	<body class="dark_mode">
	<?php else:?>
	<body>
	<?php endif?>
		<?php include('menu.php');?>
		<section class="get_form_nine_area p_100" style="padding-top: 120px">
			<div class="container">
				<div class="single_title_n">
					<h2><?=$langs['payout_page_heading']?></h2>
					<p><?=$langs['payout_page_desc']?></p>
					<div style="width: 100%; overflow-x: auto; margin-top: 30px">
						<table class="table table-striped bets_table">
							<thead>
								<tr>
									<td><?=$langs['contest_tbl_user_name']?></td>
									<td><?=$langs['trans_tbl_amount']?></td>
									<td><?=$langs['trans_tbl_address']?> / TxID</td> <!-- Merge Address + TxID -->
									<td><?=$langs['trans_tbl_status']?></td> <!-- Merge Status + Date -->
								</tr>
							</thead>
							<tbody>
								<?php if(isset($lastest_payouts) && $lastest_payouts != null): ?>
									<?php foreach($lastest_payouts as $row): ?>
										<tr>
											<!-- Username -->
											<td>
												<?=substr($row->user_name, 0, 5).str_repeat('*', 3)?>
											</td>

											<!-- Amount -->
											<td>
												<?php
													$amount = $row->amount / 100000000;
													echo (floor($amount) == $amount) ? intval($amount) : rtrim(rtrim(number_format($amount, 8, '.', ''), '0'), '.');
												?>
												BNB
												<br/>
												<span style="color: #00bcd4">
													$<?=number_format(floatval($amount * $BNB_price), 2, '.', '')?>
												</span>
											</td>

											<!-- Address + TxID -->
											<td>
												<a href="https://bscscan.com/address/<?=$row->address?>">
													<?=substr($row->address, 0, 6).'...'.substr($row->address, -6)?>
												</a>
												<i class="far fa-copy fa-fw js_clipboard" data-copy="<?=$row->address?>" style="color: #adb5bd; cursor: pointer" data-toggle="tooltip" title="Copy"></i>

												<?php if(!empty($row->proof)): ?>
													<br/>
													<?php 
														if (strpos($row->proof, "1x") !== false) {
															$row->proof = str_replace("1x", "0x", $row->proof);
															$txLink = 'https://opbnbscan.com/tx/'.$row->proof;
														} else {
															$txLink = 'https://bscscan.com/tx/'.$row->proof;
														}
													?>
													<a href="<?=$txLink?>" style="color: #4caf50">
														<?=substr($row->proof, 0, 6).'...'.substr($row->proof, -6)?>
													</a>
													<i class="far fa-copy fa-fw js_clipboard" data-copy="<?=$row->proof?>" style="color: #adb5bd; cursor: pointer" data-toggle="tooltip" title="Copy"></i>
												<?php endif; ?>
											</td>

											<!-- Status + Date -->
											<td>
												<?php 
													if($row->status == 'Completed') {
														echo '<span style="color: #4caf50">'.$langs['trans_stt_completed'].'</span>';
													}
												?>
												<br/>
												<?php
													if(date('Y-m-d', $row->completion_time) == date('Y-m-d')) {
														echo date('H:i:s A', $row->completion_time);
													} else {
														echo date('Y-m-d', $row->completion_time);
													}
												?>
											</td>
										</tr>
									<?php endforeach; ?>
								<?php else: ?>
									<tr><td colspan="4"><?=$langs['no_trans_found']?></td></tr>
								<?php endif; ?>
							</tbody>
						</table>
						<?php if(isset($pagination) && $pagination != '') echo '<div class="pagination">'.$pagination.'</div>';?>
					</div>
			   </div>
			</div>
		</section>
		<?php include('footer.php');?>
	</body>
</html>