<!DOCTYPE html>
<html lang="en">
	<?php include('header.php');?>
	<?php if(isset($user_info) && $user_info->dark_mode == 1):?>
	<body class="dark_mode">
	<?php else:?>
	<body>
	<?php endif?>
		<?php include('menu.php');?>
		<section class="get_form_nine_area p_100" style="padding-top: 120px">
			<div class="container">
				<div class="single_title_n">
					<h2><?=$langs['gift_page_heading']?></h2>
					<?=$langs['gift_page_desc']?>
					<div style="margin-top: 20px">
						<?=$langs['gift_page_desc2']?>
						<div class="input-group" style="margin: 20px auto 0px; height: 45px; max-width: 450px; font-size: 14px">
							<span class="input-group-addon" style="border-radius: 0px;  padding: 14px 13.5px"><i class="far fa-credit-card"></i></span>
							<input id="gift_code" name="gift_code" maxlength="16" type="text" class="form-control"  value="<?php if(isset($gift_code)) echo $gift_code;?>" placeholder="<?=$langs['dashed_not_required']?>" style="height: 45px; background: #FFF">
						</div>
						<div class="input-group" style="margin: 20px auto 0px; height: 45px; max-width: 450px; font-size: 14px">
							<button id="process_apply_gift_code" class="process_btn" type="submit" onclick="process_apply_gift_code()" style="width: 300px; margin-top: 20px"><?=$langs['redeem_gift_btn']?></button>
						</div>
					</div>
					<div style="width: 100%; max-width: 1000px; overflow-x: auto; margin: 30px auto 0px">
						<table class="table table-striped bets_table" style="min-width: 500px">
							<thead>
								<tr>
									<td width="33.33%"><?=$langs['gift_tbl_code']?></td>
									<td width="33.33%"><?=$langs['gift_tbl_value']?></td>
									<td width="33.33%"><?=$langs['gift_tbl_date']?></td>
								</tr>
							</thead>
							<tbody>
								<?php if(isset($gifts) && $gifts != null):?>
								<?php foreach($gifts as $row):?>
								<tr>
									<?php if(strpos($row->gift_code, 'HPNY-') !== false):?>
										<td>HAPPY-NEW-YEAR</td>
										<td>25 Spins</td>
									<?php else:?>
										<td><?=$row->gift_code?></td>
										<td><?=rtrim(number_format($row->amount / 100000000, 8, '.', ''), '0')?> BNB</td>
									<?php endif?>
									<td>
									<?php
										if(date('Y-m-d', $row->active_time) == date('Y-m-d')) {
											$row->active_time =  date('H:i:s', $row->active_time);
										} else {
											$row->active_time =  date('Y-m-d', $row->active_time);
										}
										echo $row->active_time;
									?>
									</td>
								</tr>
								<?php endforeach?>
								<?php else:?>
								<tr><td colspan="3"><?=$langs['no_gifts_found']?></td></tr>
								<?php endif?>
							</tbody>
						</table>
						<?php if($pagination != '') echo '<div class="pagination">'.$pagination.'</div>';?>
					</div>
			   </div>
			</div>
		</section>
		<?php include('footer.php');?>
		<script src="https://cdn.jsdelivr.net/npm/@tsparticles/confetti@3.0.3/tsparticles.confetti.bundle.min.js"></script>
		<script>
			function createFirework() {
				confetti({
                    particleCount: 100,       // Number of confetti particles
                    startVelocity: 30,        // Initial speed of confetti particles
                    spread: 60,               // Spread angle of confetti (reduced to create a focused effect)
                    origin: { x: 0.5, y: 0.9 }, // Starting point of the confetti (middle of the screen, bottom)
                    angle: 90,                // Angle of confetti launch (90 degrees for upward)
                    gravity: 0.5,             // Gravity's influence on falling speed
                    ticks: 100                // Lifespan of confetti particles
                });

                var duration = 1 * 1000; // 1 seconds
                var animationEnd = Date.now() + duration;
                var defaults = { startVelocity: 30, spread: 360, ticks: 60, zIndex: 0 };

                function randomInRange(min, max) {
                    return Math.random() * (max - min) + min;
                }

                var interval = setInterval(function () {
                    var timeLeft = animationEnd - Date.now();

                    if (timeLeft <= 0) {
                        return clearInterval(interval);
                    }

                    var particleCount = 50 * (timeLeft / duration);
                    confetti(Object.assign({}, defaults, {
                        particleCount,
                        origin: { x: randomInRange(0.1, 0.3), y: Math.random() - 0.2 }
                    }));
                    confetti(Object.assign({}, defaults, {
                        particleCount,
                        origin: { x: randomInRange(0.7, 0.9), y: Math.random() - 0.2 }
                    }));
                }, 250); 
			}
		</script>
		<script>
			function process_apply_gift_code() {
				$("#process_apply_gift_code").attr("disabled", !0);
				var gift_code = $('#gift_code').val();
				$.ajax({
					url: "<?=base_url()?>process.php",
					type: "POST",
					data: "action=apply_gift_code&gift_code="+gift_code,
					error: function(){
						console.log("Request timed out. Please try again!");
					},
					success: function(out){
						obj = JSON.parse(out);
						if(obj.ret == 0) {
							$.toast({
								heading: 'Error!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});
						} else {
							$('.user_balance').text(parseFloat((parseInt(obj.balance)) / 100000000).toFixed(8));
							$.toast({
								heading: 'Success!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'success'
							});
						}
						$("#process_apply_gift_code").attr("disabled", false);
						if(typeof obj.firework !== "undefined") {
							createFirework();
						}
						setTimeout(function() {
							//window.location.reload();
						}, 500);
					}
				});
			}
		</script>
	</body>
</html>