<!DOCTYPE html>
<html lang="en">
	<?php include('header.php');?>
	<?php if(isset($user_info) && $user_info->dark_mode == 1):?>
	<body class="dark_mode">
	<?php else:?>
	<body>
	<?php endif?>
		<?php include('menu.php');?>
		<section class="get_form_nine_area p_100" style="padding-top: 120px">
			<div class="container">
				<div class="single_title_n">
				
					<h2>Games</h2>
					<p>Your level is <b><?=$levels[$user_info->user_level - 1][0]?></b>, to reach the next level please play our <a href="<?=base_url()?>dice.php">games</a>.</p>
					<?php if($user_info->user_level <= sizeof($levels) - 1):?>
					<p>Wagered: <b id="total_wagered"><?=number_format($user_info->wagered / 100000000, 8, '.', '')?></b> / Target: <b id="wagering_target"><?=number_format($levels[$user_info->user_level][1], 8, '.', '')?></b></p>
					<div class="progress" style="background: #9e9e9e29; max-width: 500px; margin: 0px auto; border-radius: 5px"><div class="progress-bar" role="progressbar" id="wagering_progress" style="width: <?=max(5, floor($user_info->wagered  * 100 / ($levels[$user_info->user_level][1] * 100000000)))?>%; background-color: #3498db;" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"><?=max(1, floor($user_info->wagered  * 100 / ($levels[$user_info->user_level][1] * 100000000)))?>%</div></div>
					<div style="max-width: 520px; margin: 5px auto 50px; font-weight: bold; font-size: 14px;letter-spacing: 0.5px;"><div style="float: left"><?=$levels[$user_info->user_level - 1][0]?></div><div style="float: right"><?=$levels[$user_info->user_level][0]?></div></div>
					<?php elseif($user_info->user_level == sizeof($levels)):?>
					<p>You are <b>MASTER</b></p>
					<div class="progress" style="background: #9e9e9e29; max-width: 500px; margin: 0px auto; border-radius: 5px"><div class="progress-bar" role="progressbar" id="wagering_progress" style="width: 100%; background-color: #8bc34a;" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100">100%</div></div>
					<div style="max-width: 520px; margin: 5px auto 50px; font-weight: bold; font-size: 14px;letter-spacing: 0.5px;"><div style="float: left"><?=$levels[$user_info->user_level - 2][0]?></div><div style="float: right"><?=$levels[$user_info->user_level - 1][0]?></div></div>
					<?php endif?>	
				</div>

				<div class="row all_games">
					<div class="col-sm-3 col-xs-4">
						<a href="<?=base_url()?>dice.php">
							<div class="game_thumb">
								<div class="game_img" style="background: url('<?=base_url()?>assets/img/games/Dice_300.png'); background-size: 100%"></div>
							</div>
							<div class="game_title">Dice</div>
						</a>
					</div>
					<div class="col-sm-3 col-xs-4">
						<a href="<?=base_url()?>slots.php">
							<div class="game_thumb">
								<div class="game_img" style="background: url('<?=base_url()?>assets/img/games/Slots_300.png'); background-size: 100%"></div>
							</div>
							<div class="game_title">Slots</div>
						</a>
					</div>
					<div class="col-sm-3 col-xs-4">
						<a href="<?=base_url()?>gems.php">
							<div class="game_thumb">
								<div class="game_img" style="background: url('<?=base_url()?>assets/img/games/Gems_300.png'); background-size: 100%"></div>
							</div>
							<div class="game_title">Gems</div>
						</a>
					</div>
					<div class="col-sm-3 col-xs-4">
						<a href="<?=base_url()?>mines.php">
							<div class="game_thumb">
								<div class="game_img" style="background: url('<?=base_url()?>assets/img/games/Mines_300.png'); background-size: 100%"></div>
							</div>
							<div class="game_title">Mines</div>
						</a>
					</div>
					<div class="col-sm-3 col-xs-4">
						<a href="<?=base_url()?>poker.php">
							<div class="game_thumb">
								<div class="game_img" style="background: url('<?=base_url()?>assets/img/games/Video_poker_300.png'); background-size: 100%"></div>
							</div>
							<div class="game_title">Video Poker</div>
						</a>
					</div>
					<div class="col-sm-3 col-xs-4">
						<a href="<?=base_url()?>baccarat.php">
							<div class="game_thumb">
								<div class="game_img" style="background: url('<?=base_url()?>assets/img/games/Baccarat_300.png'); background-size: 100%"></div>
							</div>
							<div class="game_title">Baccarat</div>
						</a>
					</div>
					<?php if(true):?>
					<div class="col-sm-3 col-xs-4">
						<div class="game_thumb coming_soon">
							<div class="game_img" style="background: url('<?=base_url()?>assets/img/games/UltimateDice_300.png'); background-size: 100%"></div>
							<div class="overlay">
								<div class="text">Coming soon</div>
							</div>
						</div>
						<div class="game_title">Ultimate Dice</div>
					</div>
					<?php endif?>
				</div>
			   

			   
			   <div class="bets_nav" style="width: 192px">
					<ul class="clear">
						<li class="left li_active" id="show_my_bets">MY BETS</li>
						<li class="left" id="show_all_bets">ALL BETS</li>
						<?php if(false):?><li class="left">HIGH WINS</li><?php endif?>
					</ul>
				</div>
				<div style="width: calc(100% - 20px); margin-left: 10px; overflow-x: auto;" id="my_bets_table">
					<table class="table table-striped bets_table">
						<thead>
							<tr>
								<td>Time</td>
								<td>Game</td>
								<td>Bet</td>
								<td>Multiplier</td>
								<td>Profit</td>
							</tr>
						</thead>
						<tbody></tbody>
					</table>
				</div>
				<div style="width: calc(100% - 20px); margin-left: 10px; overflow-x: auto; display: none" id="all_bets_table">
					<table class="table table-striped bets_table">
						<thead>
							<tr>
								<td>Time</td>
								<td>Game</td>
								<td>User</td>
								<td>Bet</td>
								<td>Multiplier</td>
								<td>Profit</td>
							</tr>
						</thead>
						<tbody></tbody>
					</table>
				</div>

			</div>	
		</section>

		<?php include('footer.php');?>
		<script>
		
			var my_bet_data = null;
			
			function show_my_bets() {
				$('#show_all_bets').removeClass('li_active');
				$('#show_my_bets').addClass('li_active');
				$('#my_bets_table').show();
				$('#all_bets_table').hide();
				load_my_bet_data();
			}
			
			function load_my_bet_data() {
				/*$.ajax({
					url: "<?=base_url()?>load.php",
					type: "POST",
					data: "data=my_bet_data",
					error: function(){
						$.toast({
							heading: 'Error!',
							text: 'Request timed out. Please try again!',
							showHideTransition: 'slide',
							position: 'top-right',
							icon: 'error'
						});
					},
					success: function(out){
						let obj = JSON.parse(out);
						if(obj.ret == 1) {
							my_bet_data = obj.my_bet_data;
							show_my_bet_data(my_bet_data);
						}
					}
				});*/
				if(localforage.getItem('my_bet_data') !== null) {
					localforage.getItem("my_bet_data") .then(function (value) {
						my_bet_data = value;
						show_my_bet_data(my_bet_data);
					});
					
				}
			}
			
			
			function show_my_bet_data(bet_data) {
				var html = '';
				if(Array.isArray(bet_data)) {
					for(i = 0; i < Math.min(bet_data.length, 20); i++) {
						html += '<tr>';
						html += '<td>'+bet_data[i].date+'</td>';
						html += '<td>'+bet_data[i].game+'</td>';
						html += '<td>'+bet_data[i].bet_amount+'</td>';
						html += '<td>'+bet_data[i].payout+'</td>';
						html += '<td>'+bet_data[i].profit+'</td>';
						html += '</tr>';
					}
					$('#my_bets_table .bets_table tbody').html(html);
				}
			}

			
			function store_bet_data(bet_data){
				if(Array.isArray(bet_data) && bet_data.length > 10000) {
					bet_data.pop();
				}
				localforage.setItem('my_bet_data', bet_data) .then(() => {});
			}
			
			function show_all_bets() {
				$('#show_my_bets').removeClass('li_active');
				$('#show_all_bets').addClass('li_active');
				$('#my_bets_table').hide();
				$('#all_bets_table').show();
				load_all_bet_data();
			}
		
			function show_all_bets() {
				$('#show_my_bets').removeClass('li_active');
				$('#show_all_bets').addClass('li_active');
				$('#my_bets_table').hide();
				$('#all_bets_table').show();
				load_all_bet_data();
			}
			
			function load_all_bet_data() {
				$.ajax({
					url: "<?=base_url()?>load.php",
					type: "POST",
					data: "data=all_bet_data",
					error: function(){
						$.toast({
							heading: 'Error!',
							text: 'Request timed out. Please try again!',
							showHideTransition: 'slide',
							position: 'top-right',
							icon: 'error'
						});
					},
					success: function(out){
						obj = JSON.parse(out);
						if(obj.ret == 1) {
							show_all_bet_data(obj.all_bet_data);
						}
					}
				});
			}
			
			function show_all_bet_data(bet_data) {
				var html = '';
				if(Array.isArray(bet_data)) {
					for(i = 0; i < bet_data.length; i++) {
						html += '<tr>';
						html += '<td>'+bet_data[i].date+'</td>';
						html += '<td>'+bet_data[i].game+'</td>';
						html += '<td>'+bet_data[i].user_name+'</td>';
						html += '<td>'+bet_data[i].bet_amount+'</td>';
						html += '<td>'+bet_data[i].payout+'</td>';
						html += '<td>'+bet_data[i].profit+'</td>';
						html += '</tr>';
					}
					$('#all_bets_table .bets_table tbody').html(html);
				}
			}
			
			$(document).ready(function() {
				show_all_bets();
				$('#show_my_bets').on('click', show_my_bets);
				$('#show_all_bets').on('click', show_all_bets);
			});
		</script>
	</body>
</html>