<!DOCTYPE html>
<html lang="en">
	<?php include('header.php');?>
		<style>
		#bet_btn:disabled, #deal_btn:disabled {
			opacity: 0.6 !important;
		}
		.dark_mode .hand.highlight.disabled,
		.dark_mode .prize.highlight.disabled,
		.dark_mode .hand.highlight2.disabled,
		.dark_mode .prize.highlight2.disabled {
			border: 1px solid #8bc34a!important;
			background: #8bc34a!important;
		}
		.dark_mode .game_poker_payout_tbl .input_group {
			height: 32px!important;
		}
		</style>
		<?php if(isset($user_info) && $user_info->dark_mode == 1):?>
		<body class="dark_mode">
		<?php else:?>
		<body>
		<?php endif?>
		<?php include('menu.php');?>
		<section class="get_form_nine_area p_100" style="padding-top: 120px">
			<div class="container">
				<div class="single_title_n">
					<h2><?=$langs['game_video_poker']?></h2>
					<div class="game_main poker_game_container">
						<div class="col-xs-12">
							<div class="game_poker_payout_tbl">
								<div class="row">
									<div class="col-sm-9 col-xs-8 px-2 pt-0">
										<div class="input_group disabled hand" id="result1">
											<i class="fas fa-circle addon" style="line-height: 28px; font-size: 10px; color: #CCC"></i>
											<div class="text"><?=$langs['royal_flush_label']?></div>
										</div>
									</div>
									<div class="col-sm-3 col-xs-4 px-2 mt-0">
										<div class="input_group disabled prize" id="reward1">
											<div class="text text-center">800.00×</div>
										</div>
									</div>
									<div class="col-sm-9 col-xs-8 px-2 pt-0">
										<div class="input_group disabled hand" id="result2">
											<i class="fas fa-circle addon" style="line-height: 28px; font-size: 10px; color: #CCC"></i>
											<div class="text"><?=$langs['straight_flush_label']?></div>
										</div>
									</div>
									<div class="col-sm-3 col-xs-4 px-2 mt-0">
										<div class="input_group disabled prize" id="reward2">
											<div class="text text-center">60.00×</div>
										</div>
									</div>
									<div class="col-sm-9 col-xs-8 px-2 pt-0">
										<div class="input_group disabled hand" id="result3">
											<i class="fas fa-circle addon" style="line-height: 28px; font-size: 10px; color: #CCC"></i>
											<div class="text"><?=$langs['4_of_a_kind_label']?></div>
										</div>
									</div>
									<div class="col-sm-3 col-xs-4 px-2 mt-0">
										<div class="input_group disabled prize" id="reward3">
											<div class="text text-center">22.00×</div>
										</div>
									</div>
									<div class="col-sm-9 col-xs-8 px-2 pt-0">
										<div class="input_group disabled hand" id="result4">
											<i class="fas fa-circle addon" style="line-height: 28px; font-size: 10px; color: #CCC"></i>
											<div class="text"><?=$langs['full_house_label']?></div>
										</div>
									</div>
									<div class="col-sm-3 col-xs-4 px-2 mt-0">
										<div class="input_group disabled prize" id="reward4">
											<div class="text text-center">9.00×</div>
										</div>
									</div>
									<div class="col-sm-9 col-xs-8 px-2 pt-0">
										<div class="input_group disabled hand" id="result5">
											<i class="fas fa-circle addon" style="line-height: 28px; font-size: 10px; color: #CCC"></i>
											<div class="text"><?=$langs['flush_label']?></div>
										</div>
									</div>
									<div class="col-sm-3 col-xs-4 px-2 mt-0">
										<div class="input_group disabled prize" id="reward5">
											<div class="text text-center">6.00×</div>
										</div>
									</div>
									<div class="col-sm-9 col-xs-8 px-2 pt-0">
										<div class="input_group disabled hand" id="result6">
											<i class="fas fa-circle addon" style="line-height: 28px; font-size: 10px; color: #CCC"></i>
											<div class="text"><?=$langs['straight_label']?></div>
										</div>
									</div>
									<div class="col-sm-3 col-xs-4 px-2 mt-0">
										<div class="input_group disabled prize" id="reward6">
											<div class="text text-center">4.00×</div>
										</div>
									</div>
									<div class="col-sm-9 col-xs-8 px-2 pt-0">
										<div class="input_group disabled hand" id="result7">
											<i class="fas fa-circle addon" style="line-height: 28px; font-size: 10px; color: #CCC"></i>
											<div class="text"><?=$langs['3_of_a_kind_label']?></div>
										</div>
									</div>
									<div class="col-sm-3 col-xs-4 px-2 mt-0">
										<div class="input_group disabled prize" id="reward7">
											<div class="text text-center">3.00×</div>
										</div>
									</div>
									<div class="col-sm-9 col-xs-8 px-2 pt-0">
										<div class="input_group disabled hand" id="result8">
											<i class="fas fa-circle addon" style="line-height: 28px; font-size: 10px; color: #CCC"></i>
											<div class="text"><?=$langs['2_pair_label']?></div>
										</div>
									</div>
									<div class="col-sm-3 col-xs-4 px-2 mt-0">
										<div class="input_group disabled prize" id="reward8">
											<div class="text text-center">2.00×</div>
										</div>
									</div>
									<div class="col-sm-9 col-xs-8 px-2 pt-0">
										<div class="input_group disabled hand" id="result9">
											<i class="fas fa-circle addon" style="line-height: 28px; font-size: 10px; color: #CCC"></i>
											<div class="text"><?=$langs['pair_of_jack_or_better']?></div>
										</div>
									</div>
									<div class="col-sm-3 col-xs-4 px-2 mt-0">
										<div class="input_group disabled prize" id="reward9">
											<div class="text text-center">1.00×</div>
										</div>
									</div>
								</div>
							</div>
							<div class="game_poker_board">
								<div class="poker_card" id="card_1" card_id="1">
									<div class="poker_card_inner flipped">
										<div class="front">
											<p class="card_number"></p>
											<p class="card_symbol"></p>
											<div class="text"><?=$langs['hold_card']?></div>
										</div>
										<div class="back">
											<div></div><div></div><div></div><div></div>
											<i class="fas fa-question-circle"></i>
										</div>
									</div>
								</div>
								<div class="poker_card" id="card_2" card_id="2">
									<div class="poker_card_inner flipped">
										<div class="front">
											<p class="card_number"></p>
											<p class="card_symbol"></p>
											<div class="text"><?=$langs['hold_card']?></div>
										</div>
										<div class="back">
											<div></div><div></div><div></div><div></div>
											<i class="fas fa-question-circle"></i>
										</div>
									</div>
								</div>
								<div class="poker_card" id="card_3" card_id="3">
									<div class="poker_card_inner flipped">
										<div class="front">
											<p class="card_number"></p>
											<p class="card_symbol"></p>
											<div class="text"><?=$langs['hold_card']?></div>
										</div>
										<div class="back">
											<div></div><div></div><div></div><div></div>
											<i class="fas fa-question-circle"></i>
										</div>
									</div>
								</div>
								<div class="poker_card" id="card_4" card_id="4">
									<div class="poker_card_inner flipped">
										<div class="front">
											<p class="card_number"></p>
											<p class="card_symbol"></p>
											<div class="text"><?=$langs['hold_card']?></div>
										</div>
										<div class="back">
											<div></div><div></div><div></div><div></div>
											<i class="fas fa-question-circle"></i>
										</div>
									</div>
								</div>
								<div class="poker_card" id="card_5" card_id="5">
									<div class="poker_card_inner flipped">
										<div class="front">
											<p class="card_number"></p>
											<p class="card_symbol"></p>
											<div class="text"><?=$langs['hold_card']?></div>
										</div>
										<div class="back">
											<div></div><div></div><div></div><div></div>
											<i class="fas fa-question-circle"></i>
										</div>
									</div>
								</div>
							</div>
							<div class="col-12" style="text-align: center;">
								<?php if($cards == ''):?>
								<button class="btn bet_btn" id="bet_btn" style="width: 150px; margin: 10px auto"><img src="<?=base_url()?>assets/img/loading.gif" style="width: 35px; display: none"><span><?=$langs['bet_btn']?></span></button>
								<button class="btn bet_btn" id="deal_btn" style="width: 150px; margin: 10px auto; background: #8BC34A !important; border: 1px solid #8BC34A !important;; display: none"><img src="<?=base_url()?>assets/img/loading.gif" style="width: 35px; display: none"><span><?=$langs['deal_btn']?></span></button>
								<?php else:?>
								<button class="btn bet_btn" id="bet_btn" style="width: 150px; margin: 10px auto; display: none"><img src="<?=base_url()?>assets/img/loading.gif" style="width: 35px; display: none"><span><?=$langs['bet_btn']?></span></button>
								<button class="btn bet_btn" id="deal_btn" style="width: 150px; margin: 10px auto; background: #8BC34A !important; border: 1px solid #8BC34A !important;"><img src="<?=base_url()?>assets/img/loading.gif" style="width: 35px; display: none"><span><?=$langs['deal_btn']?></span></button>
								<?php endif?>
							</div>
							<div class="input_container">
								<div class="row">
									<div class="col-xs-12 bet_amount">
										<div class="input_label"><?=$langs['bet_ammount_label']?></div>
										<div class="input_group <?php if($cards != '') echo 'disabled';?>">
											<img src="<?=base_url()?>assets/img/bnb.svg" style="width: 20px; height: 20px; margin-top: 9px">
											<input type="text" id="bet_amount" value="<?php if($bet_amount != 0) echo number_format($bet_amount / 100000000, 8); else echo $MIN_BET_AMOUNT;?>" <?php if($cards != '') echo 'disabled="disabled"';?>>
										</div>
										<span id="bet_double">2X</span>
										<span id="bet_half">1/2</span>
									</div>
								</div>
							</div>
						</div>
						<div style="clear: both"></div>
					</div>
					<div class="gameBar_wrap">
						<ul class="gameBar_main clear">
							<li class="left gameBar_li" onclick="show_game_rules('Poker')">
								<div class="footer_wrap"><i class="fas fa-book"></i></div>
								<span class="footer_text"><?=$langs['game_rules_label']?></span>
							</li>
							<li class="left gameBar_li" onclick="show_game_fairness('Poker')">
								<div class="footer_wrap"><i class="fas fa-balance-scale"></i></div>
								<span class="footer_text"><?=$langs['game_fairness_label']?></span>
							</li>
							<?php if(false):?>
							<li class="left gameBar_li">
								<div class="footer_wrap"><i class="fas fa-keyboard"></i></div>
								<span class="footer_text"><?=$langs['game_hotkeys_label']?></span>
							</li>
							<?php endif?>
						</ul>
					</div>
					<div class="bets_nav" style="width: 192px">
						<ul class="clear">
							<li class="left li_active" id="show_my_bets"><?=$langs['MY_BETS']?></li>
							<li class="left" id="show_all_bets"><?=$langs['ALL_BETS']?></li>
							<?php if(false):?><li class="left"><?=$langs['HIGH_WINS']?></li><?php endif?>
						</ul>
					</div>
					<div style="width: calc(100% - 20px); margin-left: 10px; overflow-x: auto;" id="my_bets_table">
						<table class="table table-striped bets_table">
							<thead>
								<tr>
									<td><?=$langs['bet_tbl_time']?></td>
									<td><?=$langs['bet_tbl_game']?></td>
									<td><?=$langs['bet_tbl_bet_amount']?></td>
									<td><?=$langs['bet_tbl_multiplier']?></td>
									<td><?=$langs['bet_tbl_profit']?></td>
								</tr>
							</thead>
							<tbody></tbody>
						</table>
					</div>
					<div style="width: calc(100% - 20px); margin-left: 10px; overflow-x: auto; display: none" id="all_bets_table">
						<table class="table table-striped bets_table">
							<thead>
								<tr>
									<td><?=$langs['bet_tbl_time']?></td>
									<td><?=$langs['bet_tbl_game']?></td>
									<td><?=$langs['bet_tbl_user']?></td>
									<td><?=$langs['bet_tbl_bet_amount']?></td>
									<td><?=$langs['bet_tbl_multiplier']?></td>
									<td><?=$langs['bet_tbl_profit']?></td>
								</tr>
							</thead>
							<tbody></tbody>
						</table>
					</div>
				</div>
			   </div>
			</div>
		</section>
		<?php include('footer.php');?>
		<script>
			var user_balance = <?=number_format($user_info->balance / 100000000, 8, '.', '')?>;
			const MIN_BET_AMOUNT = <?=$MIN_BET_AMOUNT?>;
			const MAX_BET_AMOUNT = <?=$MAX_BET_AMOUNT?>;
			
			var g_cards = <?php if($cards != '') {echo json_encode($cards);} else {echo "''";} ?>;
			var g_selected_cards = [];
			var my_bet_data = [];
			
			function removeA(arr) {
				var what, a = arguments, L = a.length, ax;
				while (L > 1 && arr.length) {
					what = a[--L];
					while ((ax= arr.indexOf(what)) !== -1) {
						arr.splice(ax, 1);
					}
				}
				return arr;
			}
			
			function set_bet_double_amount() {
				if($('#bet_amount').prop("disabled")) {
					return;
				}					
				if($('#bet_btn').css('display') == 'none'){
					return;
				}
				var bet_amount = parseFloat($('#bet_amount').val());
				bet_amount *= 2;
				if(bet_amount > Math.min(MAX_BET_AMOUNT, user_balance)) {
					bet_amount = Math.min(MAX_BET_AMOUNT, user_balance);
				}
				$('#bet_amount').val(bet_amount.toFixed(8));
			}
			
			function set_bet_half_amount() {
				if($('#bet_amount').prop("disabled")) {
					return;
				}	
				if($('#bet_btn').css('display') == 'none'){
					return;
				}
				var bet_amount = parseFloat($('#bet_amount').val());
				bet_amount /= 2;
				if(bet_amount < MIN_BET_AMOUNT || isNaN(bet_amount)) {
					bet_amount = MIN_BET_AMOUNT;
				}
				$('#bet_amount').val(bet_amount.toFixed(8));
			}
			
			function change_bet_amount() {
				if($('#bet_btn').css('display') == 'none'){
					return;
				}
				var bet_amount = parseFloat($('#bet_amount').val());
				if(bet_amount < MIN_BET_AMOUNT || isNaN(bet_amount)) {
					bet_amount = MIN_BET_AMOUNT;
				}
				if(bet_amount > Math.min(MAX_BET_AMOUNT, user_balance)) {
					//bet_amount = Math.min(MAX_BET_AMOUNT, user_balance);
					 $('#bet_amount').parent().css('border', '2px solid #f44336');
				} else {
					 $('#bet_amount').parent().css('border', '1px solid #DDD');
				}
				setTimeout(function() {
					$('#bet_amount').val(bet_amount.toFixed(8));
				}, 100);
			}
			
			function select_card(card_id) {
				if($('#deal_btn').css('display') == 'none'){
					return;
				}
				if($('#deal_btn').is(':disabled')){
					return;
				}
				if($('#card_'+card_id+' .poker_card_inner').hasClass('blurred') 
				 ||$('#card_'+card_id+' .poker_card_inner').hasClass('revealed')) {
					return;
				}
				if($('#card_'+card_id+' .poker_card_inner').hasClass('picked')) {
					$('#card_'+card_id+' .poker_card_inner').removeClass('picked');
					removeA(g_selected_cards, (card_id - 1));
				} else {
					$('#card_'+card_id+' .poker_card_inner').addClass('picked');
					g_selected_cards.push((card_id - 1));
				}
				var cards2 = [];
				for(i = 0; i < 5; i++) {
					if(i < g_selected_cards.length) {
						cards2.push(g_cards[g_selected_cards[i]]);
					} else {
						cards2.push(52);
					}
				}
				calculate_result(cards2);
			}
			function highlight_card(card_id) {
				$('#card_'+card_id+' .poker_card_inner').addClass('highlight');
			}
			function hide_card(card_id) {
				$('#card_'+card_id+' .poker_card_inner').addClass('flipped');
			}
			function show_card(card_id) {
				$('#card_'+card_id+' .poker_card_inner').removeClass('flipped');
			}
			function setup_card_data(card_id, card_value) {
				var number = '';
				var suit = '';
				if(Math.floor(card_value / 4) < 9) {
					number = Math.floor(card_value / 4) + 2;
				} else if (Math.floor(card_value / 4) == 9) {
					number = 'J';
				} else if (Math.floor(card_value / 4) == 10) {
					number = 'Q';
				} else if (Math.floor(card_value / 4) == 11) {
					number = 'K';
				} else {
					number = 'A';
				}
				$('#card_'+card_id+' .card_number').html(number);
				if(card_value % 4 == 0) {
					suit = 'diamond';
				} else if(card_value % 4 == 1) {
					suit = 'heart';
				} else if(card_value % 4 == 2) {
					suit = 'club';
				} else if(card_value % 4 == 3) {
					suit = 'spade';
				}
				$('#card_'+card_id+' .poker_card_inner').removeClass('diamond');
				$('#card_'+card_id+' .poker_card_inner').removeClass('heart');
				$('#card_'+card_id+' .poker_card_inner').removeClass('club');
				$('#card_'+card_id+' .poker_card_inner').removeClass('spade');
				if(suit == 'diamond') {
					$('#card_'+card_id+' .poker_card_inner').addClass('diamond');
					$('#card_'+card_id+' .card_symbol').html('<i class="fas fa-diamond"></i>');
				} else if(suit == 'heart') {
					$('#card_'+card_id+' .poker_card_inner').addClass('heart');
					$('#card_'+card_id+' .card_symbol').html('<i class="fas fa-heart"></i>');
				} else if(suit == 'club') {
					$('#card_'+card_id+' .poker_card_inner').addClass('club');
					$('#card_'+card_id+' .card_symbol').html('<i class="fas fa-club"></i>');
				} else if(suit == 'spade') {
					$('#card_'+card_id+' .poker_card_inner').addClass('spade');
					$('#card_'+card_id+' .card_symbol').html('<i class="fas fa-spade"></i>');
				}
			}
			function calculate_result(cards) {
				cards.sort(function(a, b){return a-b});
				$('#result1').removeClass('highlight');
				$('#result2').removeClass('highlight');
				$('#result3').removeClass('highlight');
				$('#result4').removeClass('highlight');
				$('#result5').removeClass('highlight');
				$('#result6').removeClass('highlight');
				$('#result7').removeClass('highlight');
				$('#result8').removeClass('highlight');
				$('#result9').removeClass('highlight');
				$('#reward1').removeClass('highlight');
				$('#reward2').removeClass('highlight');
				$('#reward3').removeClass('highlight');
				$('#reward4').removeClass('highlight');
				$('#reward5').removeClass('highlight');
				$('#reward6').removeClass('highlight');
				$('#reward7').removeClass('highlight');
				$('#reward8').removeClass('highlight');
				$('#reward9').removeClass('highlight');
				if(royal_flush(cards)) {
					$('#result1').addClass('highlight');
					$('#reward1').addClass('highlight');
					return 'royal_flush';
				}
				if(straight_flush(cards)) {
					$('#result2').addClass('highlight');
					$('#reward2').addClass('highlight');
					return 'straight_flush';
				}
				if(four_of_a_kind(cards)) {
					$('#result3').addClass('highlight');
					$('#reward3').addClass('highlight');
					return 'four_of_a_kind';
				}
				if(full_house(cards)) {
					$('#result4').addClass('highlight');
					$('#reward4').addClass('highlight');
					return 'full_house';
				}
				if(flush(cards)) {
					$('#result5').addClass('highlight');
					$('#reward5').addClass('highlight');
					return 'flush';
				}
				if(straight(cards)) {
					$('#result6').addClass('highlight');
					$('#reward6').addClass('highlight');
					return 'straight';
				}
				if(three_of_a_kind(cards)) {
					$('#result7').addClass('highlight');
					$('#reward7').addClass('highlight');
					return 'three_of_a_kind';
				}
				if(two_pair(cards)) {
					$('#result8').addClass('highlight');
					$('#reward8').addClass('highlight');
					return 'two_pair';
				}
				if(pair_of_jack(cards)) {
					$('#result9').addClass('highlight');
					$('#reward9').addClass('highlight');
					return 'pair_of_jack';
				}
				return '';
			}
			
			function royal_flush(cards) {
				if(cards.length == 5) {
					if(cards[0] == 52 || cards[1] == 52 || cards[2] == 52 || cards[3] == 52 || cards[4] == 52) {
						return 0;
					}
					if(cards[0] == 32 && cards[1] == 36 && cards[2] == 40 && cards[3] == 44 && cards[4] == 48) {
						return 1;
					}
					if(cards[0] == 33 && cards[1] == 37 && cards[2] == 41 && cards[3] == 45 && cards[4] == 49) {
						return 1;
					}
					if(cards[0] == 34 && cards[1] == 38 && cards[2] == 42 && cards[3] == 46 && cards[4] == 50) {
						return 1;
					}
					if(cards[0] == 35 && cards[1] == 39 && cards[2] == 43 && cards[3] == 47 && cards[4] == 51) {
						return 1;
					}
				}
				return 0;
			}
			
			function straight_flush(cards) {
				if(cards.length == 5) {
					if(cards[0] == 52 || cards[1] == 52 || cards[2] == 52 || cards[3] == 52 || cards[4] == 52) {
						return 0;
					}
					if(	cards[1] - cards[0] == 4
						&&  cards[2] - cards[1] == 4
						&&  cards[3] - cards[2] == 4
						&&  cards[4] - cards[3] == 4
					) {
						return 1;
					}
					if(	cards[1] - cards[0] == 4
						&&  cards[2] - cards[1] == 4
						&&  cards[3] - cards[2] == 4
						&&  cards[4] - cards[3] == 36
					) {
						return 1;
					}
				}
				return 0;
			}
			
			function four_of_a_kind(cards) {
				if(cards.length == 5) {
					if(	Math.floor(cards[0] / 4) == Math.floor(cards[1] / 4)
						&&  Math.floor(cards[1] / 4) == Math.floor(cards[2] / 4)
						&&  Math.floor(cards[2] / 4)== Math.floor(cards[3] / 4)
						&& (cards[0] != 52 && cards[1] != 52 && cards[2] != 52 && cards[3] != 52)
					) {
						return 1;
					}
					if(	Math.floor(cards[1] / 4) == Math.floor(cards[2] / 4)
						&&  Math.floor(cards[2] / 4) == Math.floor(cards[3] / 4)
						&&  Math.floor(cards[3] / 4)== Math.floor(cards[4] / 4)
						&& (cards[1] != 52 && cards[2] != 52 && cards[3] != 52 && cards[4] != 52)
					) {
						return 1;
					}
				}
				return 0;
			}
			
			function full_house(cards) {
				if(cards.length == 5) {
					if(cards[0] == 52 || cards[1] == 52 || cards[2] == 52 || cards[3] == 52 || cards[4] == 52) {
						return 0;
					}
					if(	Math.floor(cards[0] / 4) == Math.floor(cards[1] / 4)
						&&  Math.floor(cards[1] / 4) == Math.floor(cards[2] / 4)
						&&  Math.floor(cards[3] / 4)== Math.floor(cards[4] / 4)
					) {
						return 1;
					}
					if(	Math.floor(cards[0] / 4) == Math.floor(cards[1] / 4)
						&&  Math.floor(cards[2] / 4) == Math.floor(cards[3] / 4)
						&&  Math.floor(cards[3] / 4)== Math.floor(cards[4] / 4)
					) {
						return 1;
					}
				}
				return 0;
			}

			function flush(cards) {
				if(cards.length == 5) {
					if(cards[0] == 52 || cards[1] == 52 || cards[2] == 52 || cards[3] == 52 || cards[4] == 52) {
						return 0;
					}
					if(cards[0] % 4 == cards[1] % 4
					&& cards[1] % 4 == cards[2] % 4
					&& cards[2] % 4 == cards[3] % 4
					&& cards[3] % 4 == cards[4] % 4
					) {
						return 1;
					}
				}
				return 0;
			}
			
			function straight(cards) {
				if(cards.length == 5) {
					if(cards[0] == 52 || cards[1] == 52 || cards[2] == 52 || cards[3] == 52 || cards[4] == 52) {
						return 0;
					}
					if(Math.floor(cards[1] / 4) - Math.floor(cards[0] / 4) == 1
					&& Math.floor(cards[2] / 4) - Math.floor(cards[1] / 4) == 1
					&& Math.floor(cards[3] / 4) - Math.floor(cards[2] / 4) == 1
					&& Math.floor(cards[4] / 4) - Math.floor(cards[3] / 4) == 1
					) {
						return 1;
					}
					if(Math.floor(cards[1] / 4) - Math.floor(cards[0] / 4) == 1
					&& Math.floor(cards[2] / 4) - Math.floor(cards[1] / 4) == 1
					&& Math.floor(cards[3] / 4) - Math.floor(cards[2] / 4) == 1
					&& Math.floor(cards[4] / 4) - Math.floor(cards[3] / 4) == 9
					) {
						return 1;
					}
				}
				return 0;
			}
			
			function three_of_a_kind(cards) {
				if(cards.length == 5) {
					if(	Math.floor(cards[0] / 4) == Math.floor(cards[1] / 4)
						&&  Math.floor(cards[1] / 4) == Math.floor(cards[2] / 4)
						&& (cards[0] != 52 && cards[1] != 52 && cards[2] != 52)
					) {
						return 1;
					}
					if(	Math.floor(cards[1] / 4) == Math.floor(cards[2] / 4)
						&&  Math.floor(cards[2] / 4)== Math.floor(cards[3] / 4)
						&& (cards[1] != 52 && cards[2] != 52 && cards[3] != 52)
					) {
						return 1;
					}
					if(	Math.floor(cards[2] / 4) == Math.floor(cards[3] / 4)
						&&  Math.floor(cards[3] / 4)== Math.floor(cards[4] / 4)
						&& (cards[2] != 52 && cards[3] != 52 && cards[4] != 52)
					) {
						return 1;
					}
				}
				return 0;
			}
			
			function two_pair(cards) {
				if(cards.length == 5) {
					if(	Math.floor(cards[1] / 4) == Math.floor(cards[2] / 4)
						&&  Math.floor(cards[3] / 4) == Math.floor(cards[4] / 4)
						&& (cards[1] != 52 && cards[2] != 52 && cards[3] != 52 && cards[4] != 52)
					) {
						return 1;
					}
					if(	Math.floor(cards[0] / 4) == Math.floor(cards[1] / 4)
						&&  Math.floor(cards[3] / 4)== Math.floor(cards[4] / 4)
						&& (cards[0] != 52 && cards[1] != 52 && cards[3] != 52 && cards[4] != 52)
					) {
						return 1;
					}
					if(	Math.floor(cards[0] / 4) == Math.floor(cards[1] / 4)
						&&  Math.floor(cards[2] / 4)== Math.floor(cards[3] / 4)
						&& (cards[0] != 52 && cards[1] != 52 && cards[2] != 52 && cards[3] != 52)
					) {
						return 1;
					}
				}
				return 0;
			}
			
			function pair_of_jack(cards) {
				if(cards.length == 5) {
					if(	Math.floor(cards[0] / 4) == Math.floor(cards[1] / 4)
						&&  Math.floor(cards[0] / 4) >= 9
						&& (cards[0] != 52 && cards[1] != 52)
					) {
						return 1;
					}
					if(	Math.floor(cards[1] / 4) == Math.floor(cards[2] / 4)
						&&  Math.floor(cards[1] / 4) >= 9
						&& (cards[1] != 52 && cards[2] != 52)
					) {
						return 1;
					}
					if(	Math.floor(cards[2] / 4) == Math.floor(cards[3] / 4)
						&&  Math.floor(cards[2] / 4) >= 9
						&& (cards[2] != 52 && cards[3] != 52)
					) {
						return 1;
					}
					if(	Math.floor(cards[3] / 4) == Math.floor(cards[4] / 4)
						&&  Math.floor(cards[3] / 4) >= 9
						&& (cards[3] != 52 && cards[4] != 52)
					) {
						return 1;
					}
				}
				return 0;
			}
			
			function process_bet_game_poker() {
				var bet_amount = parseFloat($('#bet_amount').val());
				g_selected_cards = [];
				$('#bet_amount').prop('disabled', true);
				$('#bet_amount').parent().addClass('disabled');
				$('#bet_btn').prop('disabled', true);
				$('#bet_btn span').hide();
				$('#bet_btn img').show();
				setTimeout(function() {
					$.ajax({
						url: "<?=base_url()?>process.php",
						type: "POST",
						data: "action=bet_game_poker&bet_amount="+bet_amount,
						error: function(){
							$.toast({
								heading: 'Error!',
								text: 'Request timed out. Please try again!',
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});
							$('#bet_amount').prop('disabled', false);
							$('#bet_amount').parent().removeClass('disabled');
							$('#bet_btn').prop('disabled', false);
							$('#bet_btn img').hide();
							$('#bet_btn span').show();
						},
						success: function(out){
							let obj = JSON.parse(out);
							if(obj.ret == 0) {
								$.toast({
									heading: 'Error!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'error'
								});
								$('#bet_amount').prop('disabled', false);
								$('#bet_amount').parent().removeClass('disabled');
								$('#bet_btn').prop('disabled', false);
								$('#bet_btn img').hide();
								$('#bet_btn span').show();
							} else {
								g_cards = obj.cards;
								if(!$('.poker_card_inner').hasClass('flipped')) {
									$('.poker_card_inner').removeClass('picked');
									$('.poker_card_inner').removeClass('highlight');
									$('.poker_card_inner').removeClass('blurred');
									$('.poker_card_inner').removeClass('revealed');
									$('.hand').removeClass('highlight');
									$('.prize').removeClass('highlight');
									$('.hand').removeClass('highlight2');
									$('.prize').removeClass('highlight2');
									for(i = 0; i < 5; i++) {
										hide_card(i+1);
									}
									setTimeout(function(){
										for(i = 0; i < 5; i++) {
											setup_card_data(i+1, g_cards[i]);
											show_card(i+1);
										}
	
									}, 1000);
								} else {
									for(i = 0; i < 5; i++) {
										setup_card_data(i+1, g_cards[i]);
										show_card(i+1);
									}
								}
								$("#bet_btn").hide();
								$("#deal_btn").show();
								$('#bet_btn').prop('disabled', false);
								$('#bet_btn img').hide();
								$('#bet_btn span').show();
								$('.user_balance').text(parseFloat(parseInt(obj.balance) / 100000000).toFixed(8));
								user_balance = parseFloat((parseInt(obj.balance)) / 100000000).toFixed(8);
							}		
						}
					});
				}, 100);
			}
			
			function process_deal_game_poker() {
				$('#deal_btn').prop('disabled', true);
				$('#deal_btn span').hide();
				$('#deal_btn img').show();
				setTimeout(function() {
					$.ajax({
						url: "<?=base_url()?>process.php",
						type: "POST",
						data: "action=deal_game_poker&selected_cards="+g_selected_cards,
						error: function(){
							$.toast({
								heading: 'Error!',
								text: 'Request timed out. Please try again!',
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});
							$('#deal_btn').prop('disabled', false);
							$('#deal_btn img').hide();
							$('#deal_btn span').show();
						},
						success: function(out){
							let obj = JSON.parse(out);
							if(obj.ret == 0) {
								$.toast({
									heading: 'Error!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'error'
								});
								$('#deal_btn').prop('disabled', false);
								$('#deal_btn img').hide();
								$('#deal_btn span').show();
							} else {
								var cards = obj.cards;		
								for(i = 0; i < 5; i++) {
									if(!g_selected_cards.includes(i)) {
										hide_card(i+1);
									}
								}
								setTimeout(function(){
									for(i = 0; i < 5; i++) {
										if(!g_selected_cards.includes(i)) {
											var card_id = i+1;
											setup_card_data(card_id, cards[card_id-1]);
											show_card(card_id);
										}
									}
									$('.poker_card_inner').removeClass('picked');
									$('.poker_card_inner').addClass('revealed');
									$('.hand').removeClass('highlight');
									$('.prize').removeClass('highlight');
									g_selected_cards = [];
									if(obj.hand != null) {
										if(obj.hand == 'royal_flush') {
											$('#result1').addClass('highlight2');
											$('#reward1').addClass('highlight2');
										}
										if(obj.hand == 'straight_flush') {
											$('#result2').addClass('highlight2');
											$('#reward2').addClass('highlight2');
										}
										if(obj.hand == 'four_of_a_kind') {
											$('#result3').addClass('highlight2');
											$('#reward3').addClass('highlight2');
										}
										if(obj.hand == 'full_house') {
											$('#result4').addClass('highlight2');
											$('#reward4').addClass('highlight2');
										}
										if(obj.hand == 'flush') {
											$('#result5').addClass('highlight2');
											$('#reward5').addClass('highlight2');
										}
										if(obj.hand == 'straight') {
											$('#result6').addClass('highlight2');
											$('#reward6').addClass('highlight2');
										}
										if(obj.hand == 'three_of_a_kind') {
											$('#result7').addClass('highlight2');
											$('#reward7').addClass('highlight2');
										}
										if(obj.hand == 'two_pair') {
											$('#result8').addClass('highlight2');
											$('#reward8').addClass('highlight2');
										}
										if(obj.hand == 'pair_of_jack') {
											$('#result9').addClass('highlight2');
											$('#reward9').addClass('highlight2');
										}
									}
									if(obj.highlights != null) {
										for(i = 0; i < 5; i++) {
											if(obj.highlights.includes(i)) {
												highlight_card(i+1);
											}
										}
									}
									setTimeout(function(){
										$('.poker_card_inner').addClass('blurred');
									}, 1000);
									
									$('.user_balance').text(parseFloat(parseInt(obj.balance) / 100000000).toFixed(8));
									user_balance = parseFloat((parseInt(obj.balance)) / 100000000).toFixed(8);
								}, 1000);
								
								setTimeout(function(){
									$("#bet_btn").show();
									$("#deal_btn").hide();
									$('#deal_btn img').hide();
									$('#deal_btn span').show();
									$('#deal_btn').prop('disabled', false);
									$('#bet_amount').prop('disabled', false);
									$('#bet_amount').parent().removeClass('disabled');
									
									if(Array.isArray(my_bet_data)) {
										my_bet_data.unshift(obj.bet_data);
									} else {
										my_bet_data = [obj.bet_data];
									}
									if (Array.isArray(my_bet_data) && my_bet_data.length > 20) {
										my_bet_data = my_bet_data.slice(0, 20);
									}
									store_bet_data(my_bet_data);
									show_my_bet_data(my_bet_data);
									
								}, 1500);
							}		
						}
					});
				}, 100);
			}
			
			
			if(g_cards.length == 5) {
				setup_card_data(1, g_cards[0]);
				setup_card_data(2, g_cards[1]);
				setup_card_data(3, g_cards[2]);
				setup_card_data(4, g_cards[3]);
				setup_card_data(5, g_cards[4]);
				show_card(1);
				show_card(2);
				show_card(3);
				show_card(4);
				show_card(5);
			}
			
			$('.poker_card').click(function(){
				var card_id = $(this).attr('card_id');
				select_card(card_id);
			});
			
			$(document).ready(function() {
				$("#bet_double").on("click", set_bet_double_amount);
				$("#bet_half").on("click", set_bet_half_amount);
				$("#bet_amount").on("change", change_bet_amount);
				$("#bet_btn").on("click", process_bet_game_poker);
				$("#deal_btn").on("click", process_deal_game_poker);

				show_my_bets(my_bet_data);
				$('#show_my_bets').on('click', function(){show_my_bets(my_bet_data);});
				$('#show_all_bets').on('click', show_all_bets);
			});
			
		</script>
	</body>
</html>