<!DOCTYPE html>
<html lang="en">
	<?php include('header.php');?>
	<?php if(isset($user_info) && $user_info->dark_mode == 1):?>
	<body class="dark_mode">
	<?php else:?>
	<body>
	<?php endif?>
		<?php include('menu.php');?>
		<section class="get_form_nine_area p_100" style="padding-top: 120px">
			<div class="container">
				<div class="single_title_n">
					<h2><?=$langs['game_keno']?></h2>
					<div class="game_main row" style="max-width: 550px; width: 100%;">	
						<div class="table_gamebox keno_gameboard" id="keno_gameboard">
							<div class="keno_table" id="keno_table">
							</div>
						</div>
						
						<div class="game_info_bar keno_cell_selections"><span style="display: block; display: block; font-size: 13px"><?=$langs['select_keno_numbers']?></span></div>
						
						<div class="difficulty">
							<div class="row">
								<div class="col-xs-4">
									<div class="radio icheck-success">
										<input type="radio" id="easy" name="difficulty" checked>
										<label for="easy"><?=$langs['game_level_easy_label']?></label>
									</div>
								</div>
								<div class="col-xs-4">
									<div class="radio icheck-success">
										<input type="radio" id="medium" name="difficulty">
										<label for="medium"><?=$langs['game_level_medium_label']?></label>
									</div>
								</div>
								<div class="col-xs-4">
									<div class="radio icheck-success">
										<input type="radio" id="hard" name="difficulty">
										<label for="hard"><?=$langs['game_level_hard_label']?></label>
									</div>
								</div>
							</div>
						</div>
						
						<div class="col-xs-12 bet_amount">
							<div class="input_label"><?=$langs['bet_ammount_label']?></div>
							<div class="input_group">
								<img src="<?=base_url()?>assets/img/bnb.svg" style="width: 20px; height: 20px; margin-top: 9px">
								<input type="text" id="bet_amount" value="<?=$MIN_BET_AMOUNT?>">
							</div>
							<span id="bet_double">2X</span>
							<span id="bet_half">1/2</span>
						</div>
						<div class="col-12">
							<div class="row">
								<div class="col-xs-3 auto_dice_box">
									<div class="checkbox icheck-info" style="margin-left: 20px">
										<?php if(1):?>
										<input type="checkbox" id="switch_bet_mode">
										<?php else:?>
										<input type="checkbox" id="switch_bet_mode" disabled="disabled">
										<?php endif?>
										<label for="switch_bet_mode"><?=$langs['switch_auto']?></label>
									</div>
								</div>
								<div class="col-xs-6 text-center">
									<div id="manual_bet">
										<button class="btn bet_btn process_bet_game_keno" id="play_button" style="max-width: 300px; margin-top: 20px; height: 50px"><img src="<?=base_url()?>assets/img/loading.gif" style="width: 35px; display: none"><span><?=$langs['bet_btn']?></span></button>
									</div>
									<div id="auto_bet">
										<button class="btn bet_btn" id="start_autobet"><span><?=$langs['game_start_auto_bet_btn']?></span></button>
										<button class="btn bet_btn" id="stop_autobet"><img src="<?=base_url()?>assets/img/loading.gif" style="width: 35px"><span><?=$langs['game_stop_auto_bet_btn']?></span></button>
									</div>
								</div>
								<div class="col-xs-3">
								</div>
							</div>
						</div>
						
						
						<div class="col-xs-12 col-sm-6" id="on_win_box">
							<div class="input_container">
								<div class="input_label"><?=$langs['on_win_label']?></div>
								<div class="radio icheck-success">
								  <input type="radio" id="reset_onwin" name="onwin" checked="checked">
								  <label for="reset_onwin"><?=$langs['reset_bet_label']?></label>
								</div>
								<div style="display: flex">
									<div class="radio icheck-success">
									  <input type="radio" id="increase_onwin" name="onwin">
									  <label for="increase_onwin"><?=$langs['increase_bet_amount']?></label>
									</div>
									<div class="input_group disabled" style="width: 100px; margin-left: 15px; margin-top: -5px">
										<input type="text" id="increase_onwin_by" value="100" disabled="">
										<i style="font-size: 12px" class="fas fa-percent addon"></i>
									</div>
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6" id="on_loss_box">
							<div class="input_container">
								<div class="input_label"><?=$langs['on_loss_label']?></div>
								<div class="radio icheck-success">
								  <input type="radio" id="reset_onloss" name="onloss" checked="checked">
								  <label for="reset_onloss"><?=$langs['reset_bet_label']?></label>
								</div>
								<div style="display: flex">
									<div class="radio icheck-success">
									  <input type="radio" id="increase_onloss" name="onloss">
									  <label for="increase_onloss"><?=$langs['increase_bet_amount']?></label>
									</div>
									<div class="input_group disabled" style="width: 100px; margin-left: 15px; margin-top: -5px">
										<input type="text" id="increase_onloss_by" value="100" disabled="">
										<i style="font-size: 12px" class="fas fa-percent addon"></i>
									</div>
								</div>
							</div>
						</div>
						<div class="col-xs-12" id="stop_profit_box">
							<div class="input_container">
								<div class="row">
									<div class="col-xs-6">
										<div class="input_label"><?=$langs['stop_on_profit_label']?></div>
										<div class="input_group">
											<img src="<?=base_url()?>assets/img/bnb.svg" style="width: 20px; height: 20px; margin-top: 9px">
											<input type="text" id="stop_on_profit" value="0.00000000">
										</div>
									</div>
									<div class="col-xs-6">
										<div class="input_label"><?=$langs['stop_on_loss_label']?></div>
										<div class="input_group">
											<img src="<?=base_url()?>assets/img/bnb.svg" style="width: 20px; height: 20px; margin-top: 9px">
											<input type="text" id="stop_on_loss" value="0.00000000">
										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="col-xs-12" id="total_profit_box">
							<div class="input_container">
								<div class="row">
									<div class="col-xs-6">
										<div class="input_label"><?=$langs['number_rolls_label']?></div>
										<div class="input_group">
											<input type="text" id="number_rolls" value="0">
										</div>
									</div>
									<div class="col-xs-6">
										<div class="input_label"><?=$langs['total_profit_label']?></div>
										<div class="input_group">
											<img src="<?=base_url()?>assets/img/bnb.svg" style="width: 20px; height: 20px; margin-top: 9px">
											<input type="text" id="profit_loss" value="0.00000000">
										</div>
									</div>
								</div>
							</div>
						</div>
						
					</div>
					<div class="gameBar_wrap">
						<ul class="gameBar_main clear">
							<li class="left gameBar_li" onclick="show_game_rules('Keno')">
								<div class="footer_wrap"><i class="fas fa-book"></i></div>
								<span class="footer_text"><?=$langs['game_rules_label']?></span>
							</li>
							<li class="left gameBar_li" onclick="show_game_fairness('Keno')">
								<div class="footer_wrap"><i class="fas fa-balance-scale"></i></div>
								<span class="footer_text"><?=$langs['game_fairness_label']?></span>
							</li>
							<?php if(false):?>
							<li class="left gameBar_li">
								<div class="footer_wrap"><i class="fas fa-keyboard"></i></div>
								<span class="footer_text"><?=$langs['game_hotkeys_label']?></span>
							</li>
							<?php endif?>
						</ul>
					</div>
					<div class="bets_nav" style="width: 192px">
						<ul class="clear">
							<li class="left li_active" id="show_my_bets"><?=$langs['MY_BETS']?></li>
							<li class="left" id="show_all_bets"><?=$langs['ALL_BETS']?></li>
							<?php if(false):?><li class="left"><?=$langs['HIGH_WINS']?></li><?php endif?>
						</ul>
					</div>
					<div style="width: calc(100% - 20px); margin-left: 10px; overflow-x: auto;" id="my_bets_table">
						<table class="table table-striped bets_table">
							<thead>
								<tr>
									<td><?=$langs['bet_tbl_time']?></td>
									<td><?=$langs['bet_tbl_game']?></td>
									<td><?=$langs['bet_tbl_bet_amount']?></td>
									<td><?=$langs['bet_tbl_multiplier']?></td>
									<td><?=$langs['bet_tbl_profit']?></td>
								</tr>
							</thead>
							<tbody></tbody>
						</table>
					</div>
					<div style="width: calc(100% - 20px); margin-left: 10px; overflow-x: auto; display: none" id="all_bets_table">
						<table class="table table-striped bets_table">
							<thead>
								<tr>
									<td><?=$langs['bet_tbl_time']?></td>
									<td><?=$langs['bet_tbl_game']?></td>
									<td><?=$langs['bet_tbl_user']?></td>
									<td><?=$langs['bet_tbl_bet_amount']?></td>
									<td><?=$langs['bet_tbl_multiplier']?></td>
									<td><?=$langs['bet_tbl_profit']?></td>
								</tr>
							</thead>
							<tbody></tbody>
						</table>
					</div>
			   </div>
			</div>
		</section>
		<?php include('footer.php');?>
		<script>
		
		
		var user_balance = <?=number_format($user_info->balance / 100000000, 8, '.', '')?>;
		const MIN_BET_AMOUNT = <?=$MIN_BET_AMOUNT?>;
		const MAX_BET_AMOUNT = <?=$MAX_BET_AMOUNT?>;
		const MIN_BET_INCREASE_PERCENT = <?=$MIN_BET_INCREASE_PERCENT?>;
		const MAX_BET_INCREASE_PERCENT = <?=$MAX_BET_INCREASE_PERCENT?>;
		const MIN_STOP_ON_PROFIT = <?=$MIN_STOP_ON_PROFIT?>;
		const MAX_STOP_ON_PROFIT = <?=$MAX_STOP_ON_PROFIT?>;
		var difficulty = 'easy';
		var my_bet_data = [];
		var selected_numbers = [];
		var bet_mode = 'manual';
		var auto_betting_status = 'stopped';
		
		const PAYOUT_TABLE = [
			[
				[0, 3.88],
				[0, 1.86, 4.4],
				[0, 1, 3, 9.8],
				[0, 0.8, 1.71, 5, 22],
				[0, 0.25, 1.3, 4.3, 15.7, 35],
				[0, 0, 1, 3.6, 6, 23, 50],
				[0, 0, 0.5, 2.2, 6, 21, 34, 60],
				[0, 0, 0, 2, 4, 15, 20, 55, 70],
				[0, 0, 0, 1.5, 3, 7.5, 17, 40, 60, 86],
				[0, 0, 0, 1.3, 2.3, 4.5, 7.9, 20, 50, 80, 100]
			],
			[
				[0.7, 1.78],
				[0, 2, 3.48],
				[0, 1, 2.1, 20],
				[0, 0, 2, 9, 81],
				[0, 0, 1, 3, 35, 310],
				[0, 0, 1, 2, 10, 60, 700],
				[0, 0, 1.1, 1.3, 4, 25, 80, 750],
				[0, 0, 1.1, 1.3, 1.8, 10, 20, 135, 800],
				[0, 0, 1.1, 1.3, 1.6, 2.5, 5, 40, 200, 900],
				[0, 0, 1.1, 1.2, 1.3, 1.5, 2.7, 12, 100, 250, 1000]
			],
			[
				[0.4, 2.68],
				[0, 1.8, 4.8],
				[0, 0, 3.1, 45],
				[0, 0, 1.8, 9, 100],
				[0, 0, 1.4, 4, 14, 339],
				[0, 0, 0, 3, 9, 170, 730],
				[0, 0, 0, 2, 7, 30, 340, 800],
				[0, 0, 0, 2, 4, 10, 62, 400, 900],
				[0, 0, 0, 2, 2.4, 5, 12, 100, 500, 1000],
				[0, 0, 0, 1.6, 2, 3.5, 7.2, 26, 100, 500, 1000]
			],
			[
				[0, 3.88],
				[0, 0, 16.8],
				[0, 0, 0, 79.8],
				[0, 0, 0, 10, 250],
				[0, 0, 0, 4.5, 45, 475],
				[0, 0, 0, 0, 10, 350, 770],
				[0, 0, 0, 0, 7, 84, 445, 800],
				[0, 0, 0, 0, 5, 20, 250, 680, 900],
				[0, 0, 0, 0, 4, 11, 55, 410, 800, 1000],
				[0, 0, 0, 0, 3.5, 8, 11, 50, 500, 800, 1000]
			]
		
		];

		function change_difficulty() {
			if($('#easy').is(':checked')) {
				$('#easy_difficulty').show();
				$('#medium_difficulty').hide();
				$('#hard_difficulty').hide();
				difficulty = 'easy';
			} else if($('#medium').is(':checked')){
				$('#easy_difficulty').hide();
				$('#medium_difficulty').show();
				$('#hard_difficulty').hide();
				difficulty = 'medium';
			} else if($('#hard').is(':checked')){
				$('#easy_difficulty').hide();
				$('#medium_difficulty').hide();
				$('#hard_difficulty').show();
				difficulty = 'hard';
			}
			calculate_game_payout();
		}
		
		function set_bet_double_amount() {
			if($('#bet_amount').prop("disabled")) {
				return;
			}				
			var bet_amount = parseFloat($('#bet_amount').val());
			bet_amount *= 2;
			if(bet_amount > Math.min(MAX_BET_AMOUNT, user_balance)) {
				bet_amount = Math.min(MAX_BET_AMOUNT, user_balance);
			}
			$('#bet_amount').val(bet_amount.toFixed(8));
		}
		
		function set_bet_half_amount() {
			if($('#bet_amount').prop("disabled")) {
				return;
			}
			var bet_amount = parseFloat($('#bet_amount').val());
			bet_amount /= 2;
			if(bet_amount < MIN_BET_AMOUNT || isNaN(bet_amount)) {
				bet_amount = MIN_BET_AMOUNT;
			}
			$('#bet_amount').val(bet_amount.toFixed(8));
		}

		function draw_keno_table(opened_numbers) {
			var html = '';
			for(let i = 1; i <= 40; i++) {
				if(opened_numbers.includes(i) && selected_numbers.includes(i)) {
					html += '<div class="keno_gamecell matched" number_id="'+i+'"><div class="keno_gem">'+i+'</div></div>';
				} else if (opened_numbers.includes(i) && !selected_numbers.includes(i)) {
					html += '<div class="keno_gamecell opened" number_id="'+i+'"><div class="keno_gamecell_index">'+i+'</div></div>';
				} else if (!opened_numbers.includes(i) && selected_numbers.includes(i)) {
					html += '<div class="keno_gamecell selected" number_id="'+i+'"><div class="keno_gamecell_coverimg"></div><div class="keno_gamecell_index">'+i+'</div></div>';
				} else {
					html += '<div class="keno_gamecell" number_id="'+i+'"><div class="keno_gamecell_coverimg"></div><div class="keno_gamecell_index">'+i+'</div></div>';
				}
			}
			$('#keno_table').html(html);
		}
		
		function calculate_game_payout(matched = -1) {
			if(selected_numbers.length > 0) {
				let html = '<div>';
				for(let i = 0; i < selected_numbers.length + 1; i++) {
					let multiplier = 0;
					if(difficulty == 'easy') {
						multiplier = PAYOUT_TABLE[0][selected_numbers.length-1][i];
					} else if(difficulty == 'medium') {
						multiplier = PAYOUT_TABLE[1][selected_numbers.length-1][i];
					} else if(difficulty == 'hard') {
						multiplier = PAYOUT_TABLE[2][selected_numbers.length-1][i];
					} else if(difficulty == 'extreme') {
						multiplier = PAYOUT_TABLE[3][selected_numbers.length-1][i];
					}
					if(multiplier < 100) {
						multiplier = multiplier.toFixed(2);
					} else if (multiplier < 1000) {
						multiplier = multiplier.toFixed(1);
					}
					if(matched == i) {
						html += '<div class="selected_item highlighted"><div class="info">'+(i)+'<i></i><span>×'+multiplier+'</span></div></div>';
					} else {
						html += '<div class="selected_item"><div class="info">'+(i)+'<i></i><span>×'+multiplier+'</span></div></div>';
					}
					
				}
				html += '</div>';
				$('.keno_cell_selections').html(html);
			} else {
				$('.keno_cell_selections').html('<span style="display: block; font-size: 13px">Select 1-10 numbers to play</span>');
			}
		}
		
		function process_select_cell_game_keno() {
			var cell_obj = $(this);
			var number_id = parseInt(cell_obj.attr('number_id'));
			if(!selected_numbers.includes(number_id)) {
				if(selected_numbers.length < 10) {
					selected_numbers.push(number_id);
					draw_keno_table([]);
				}
			} else {
				selected_numbers.splice(selected_numbers.indexOf(number_id), 1);
				draw_keno_table([]);
			}
			calculate_game_payout();
		}
		
		function process_bet_game_keno() {
			var bet_amount = parseFloat($('#bet_amount').val());
			var stop_on_profit = parseFloat($('#stop_on_profit').val());
			var stop_on_loss = parseFloat($('#stop_on_loss').val());
			if(selected_numbers.length == 0) {
				return;
			}
			if(bet_mode == 'manual') {
				$('#play_button span').hide();
				$('#play_button img').show();
				$("#play_button").attr("disabled", !0);
			} else {
				var number_rolls = parseInt($('#number_rolls').val());
			}
			$('.game_result_wrap').fadeOut();
			disable_all_inputs();
			setTimeout(function() {
				$.ajax({
					url: "<?=base_url()?>process.php",
					type: "POST",
					data: "action=bet_game_keno&bet_amount="+bet_amount+'&difficulty='+difficulty+'&numbers='+selected_numbers,
					error: function(){
						$.toast({
							heading: 'Error!',
							text: 'Request timed out. Please try again!',
							showHideTransition: 'slide',
							position: 'top-right',
							icon: 'error',
							loaderBg: '#ec4f5b',
						});
						enable_all_inputs();
						if(bet_mode == 'manual') {
							$('#play_button span').show();
							$('#play_button img').hide();
							$("#play_button").attr("disabled", false);
						} else {
							reset_start_button();
						}
					},
					success: function(out){
						obj = JSON.parse(out);
						if(obj.ret == 0) {
							$.toast({
								heading: 'Error!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error',
								loaderBg: '#ec4f5b',
							});
							enable_all_inputs();
							if(bet_mode == 'manual') {
								$('#play_button span').show();
								$('#play_button img').hide();
								$("#play_button").attr("disabled", false);
							} else {
								reset_start_button();
							}
							enable_all_inputs();
						} else {
							var opened_numbers = [];
							var matched_count = 0;
							var show_numbers = setInterval(function(){
								let number = obj.numbers.pop();
								opened_numbers.push(number);
								if(selected_numbers.includes(number)) {
									matched_count++;
								}
								calculate_game_payout(matched_count);
								draw_keno_table(opened_numbers);
								if(obj.numbers.length == 0) {
									clearInterval(show_numbers);
								}
							}, 100);
							setTimeout(function(){

								$('.user_balance').text(parseFloat((parseInt(obj.balance)) / 100000000).toFixed(8));
								user_balance = parseFloat((parseInt(obj.balance)) / 100000000).toFixed(8);
								if(Array.isArray(my_bet_data) && my_bet_data.length > 20) {
									my_bet_data.pop();
								}						
								if(Array.isArray(my_bet_data)) {
									my_bet_data.unshift(obj.bet_data);
								} else {
									my_bet_data = [obj.bet_data];
								}
								if (Array.isArray(my_bet_data) && my_bet_data.length > 20) {
									my_bet_data = my_bet_data.slice(0, 20);
								}
								store_bet_data(my_bet_data);
								show_my_bet_data(my_bet_data);
								if(bet_mode == 'manual') {
									$('#play_button span').show();
									$('#play_button img').hide();
									$("#play_button").attr("disabled", false);
									enable_all_inputs();
								} else if(bet_mode == 'auto') {
									let profit_loss = ((parseInt(parseFloat($('#profit_loss').val()) * 100000000) + parseInt(obj.win_amount)) / 100000000).toFixed(8);
									$('#profit_loss').val(profit_loss);
									$('#number_rolls').val(number_rolls+1);
									if(obj.win_amount >= 0) { //on win
										if($('#increase_onwin').is(':checked')) {
											let increase_onwin_by = parseInt($('#increase_onwin_by').val());
											bet_amount = parseFloat(bet_amount * (increase_onwin_by + 100) / 100).toFixed(8);
											$('#bet_amount').val(bet_amount);
										} else {
											$('#bet_amount').val(base_bet.toFixed(8));
										}
									} 
									if(obj.win_amount < 0) { // on loss
										if($('#increase_onloss').is(':checked')) {
											let increase_onloss_by = parseInt($('#increase_onloss_by').val());
											bet_amount = parseFloat(bet_amount * (increase_onloss_by + 100) / 100).toFixed(8);
											$('#bet_amount').val(bet_amount);
										} else {
											$('#bet_amount').val(base_bet.toFixed(8));
										}
									}
									if((stop_on_profit > 0 && profit_loss >= stop_on_profit)
									|| (stop_on_loss > 0 && (profit_loss * -1) >= stop_on_loss)
									) {
										stop_auto_bet();
									}
									if(auto_betting_status == 'running') {
										setTimeout(function(){
											process_bet_game_keno();
										}, 500);
									} else {
										enable_all_inputs();
										reset_start_button();
									}
								}
							}, 1000);
							
							
						}
					}
				});
			}, 500);
		}
		
		function disable_all_inputs() {
			$('#bet_amount').prop('disabled', true);
			$('#bet_amount').parent().addClass('disabled');
			$('input[type=radio][name=difficulty]').prop('disabled', true);
			$('#reset_onwin').prop('disabled', true);
			$('#increase_onwin').prop('disabled', true);
			$('#increase_onwin_by').prop('disabled', true);
			$('#increase_onwin_by').parent().addClass('disabled');
			$('#reset_onloss').prop('disabled', true);
			$('#increase_onloss').prop('disabled', true);
			$('#increase_onloss_by').prop('disabled', true);
			$('#increase_onloss_by').parent().addClass('disabled');	
			$('#stop_on_profit').prop('disabled', true);
			$('#stop_on_profit').parent().addClass('disabled');
			$('#stop_on_loss').prop('disabled', true);
			$('#stop_on_loss').parent().addClass('disabled');
			$('#number_rolls').prop('disabled', true);
			$('#number_rolls').parent().addClass('disabled');
			$('#profit_loss').prop('disabled', true);
			$('#profit_loss').parent().addClass('disabled');
			$('#switch_bet_mode').prop('disabled', true);
		}
		
		function enable_all_inputs() {
			$('#bet_amount').prop('disabled', false);
			$('#bet_amount').parent().removeClass('disabled');
			$('input[type=radio][name=difficulty]').prop('disabled', false);
			$('#reset_onwin').prop('disabled', false);
			$('#increase_onwin').prop('disabled', false);
			if($('#increase_onwin').is(':checked')) {
				$('#increase_onwin_by').prop('disabled', false);
				$('#increase_onwin_by').parent().removeClass('disabled');
			}
			$('#reset_onloss').prop('disabled', false);
			$('#increase_onloss').prop('disabled', false);
			if($('#increase_onloss').is(':checked')) {
				$('#increase_onloss_by').prop('disabled', false);
				$('#increase_onloss_by').parent().removeClass('disabled');
			} 
			$('#stop_on_profit').prop('disabled', false);
			$('#stop_on_profit').parent().removeClass('disabled');
			$('#stop_on_loss').prop('disabled', false);
			$('#stop_on_loss').parent().removeClass('disabled');
			$('#number_rolls').prop('disabled', false);
			$('#number_rolls').parent().removeClass('disabled');
			$('#profit_loss').prop('disabled', false);
			$('#profit_loss').parent().removeClass('disabled');
			$('#switch_bet_mode').prop('disabled', false);
		}
		
		function change_bet_amount() {
			if($('#bet_amount').prop('disabled')) {
				return;
			}
			var bet_amount = parseFloat($('#bet_amount').val());
			if(bet_amount < MIN_BET_AMOUNT) {
				bet_amount = MIN_BET_AMOUNT;
			}
			if(bet_amount > Math.min(MAX_BET_AMOUNT, user_balance)) {
				//bet_amount = Math.min(MAX_BET_AMOUNT, user_balance);
				 $('#bet_amount').parent().css('border', '2px solid #f44336');
			} else {
				 $('#bet_amount').parent().css('border', '1px solid #DDD');
			}
			$('#bet_amount').val(bet_amount.toFixed(8));
		}
		
		function set_bet_double_amount() {
			if($('#bet_amount').prop('disabled')) {
				return;
			}
			var bet_amount = parseFloat($('#bet_amount').val());
			bet_amount *= 2;
			if(bet_amount > Math.min(MAX_BET_AMOUNT, user_balance)) {
				bet_amount = Math.min(MAX_BET_AMOUNT, user_balance);
			}
			$('#bet_amount').val(bet_amount.toFixed(8));
		}
		
		function set_bet_half_amount() {
			if($('#bet_amount').prop('disabled')) {
				return;
			}
			var bet_amount = parseFloat($('#bet_amount').val());
			bet_amount /= 2;
			if(bet_amount < MIN_BET_AMOUNT || isNaN(bet_amount)) {
				bet_amount = MIN_BET_AMOUNT;
			}
			$('#bet_amount').val(bet_amount.toFixed(8));
		}
		
		function switch_bet_mode() {
			if(bet_mode == 'manual') {
				$('#on_win_box').show();
				$('#on_loss_box').show();
				$('#stop_profit_box').show();
				$('#total_profit_box').show();
				$('#auto_bet').show();
				$('#start_autobet').show();
				$('#manual_bet').hide();
				$('#auto_mine_board').show();
				$('#manual_mine_board').hide();
				bet_mode = 'auto';
			} else {
				$('#on_win_box').hide();
				$('#on_loss_box').hide();
				$('#stop_profit_box').hide();
				$('#total_profit_box').hide();
				$('#auto_bet').hide();
				$('#manual_bet').show();
				$('#manual_mine_board').show();
				$('#auto_mine_board').hide();
				bet_mode = 'manual';
			}
		}
		
		function change_on_win() {
			if($('#increase_onwin').is(':checked')) {
				$('#increase_onwin_by').prop('disabled', false);
				$('#increase_onwin_by').parent().removeClass('disabled');
			} else {
				$('#increase_onwin_by').prop('disabled', true);
				$('#increase_onwin_by').parent().addClass('disabled');
			}
		}

		function change_on_loss() {
			if($('#increase_onloss').is(':checked')) {
				$('#increase_onloss_by').prop('disabled', false);
				$('#increase_onloss_by').parent().removeClass('disabled');
			} else {
				$('#increase_onloss_by').prop('disabled', true);
				$('#increase_onloss_by').parent().addClass('disabled');
			}
		}
		
		function change_increase_onwin_by() {
			var increase_onwin_by = parseInt($('#increase_onwin_by').val());
			if(increase_onwin_by < MIN_BET_INCREASE_PERCENT || isNaN(increase_onwin_by)) {
				increase_onwin_by = MIN_BET_INCREASE_PERCENT;
			} else if(increase_onwin_by > MAX_BET_INCREASE_PERCENT) {
				increase_onwin_by = MAX_BET_INCREASE_PERCENT;
			}
			$('#increase_onwin_by').val(increase_onwin_by);
		}
		
		function change_increase_onloss_by() {
			var increase_onloss_by = parseInt($('#increase_onloss_by').val());
			if(increase_onloss_by < MIN_BET_INCREASE_PERCENT || isNaN(increase_onloss_by)) {
				increase_onloss_by = MIN_BET_INCREASE_PERCENT;
			} else if(increase_onloss_by > MAX_BET_INCREASE_PERCENT) {
				increase_onloss_by = MAX_BET_INCREASE_PERCENT;
			}
			$('#increase_onloss_by').val(increase_onloss_by);
		}

		function change_stop_on_profit() {
			var stop_on_profit = parseFloat($('#stop_on_profit').val());
			if(stop_on_profit < MIN_STOP_ON_PROFIT || isNaN(stop_on_profit)) {
				stop_on_profit = MIN_STOP_ON_PROFIT;
			} else if(stop_on_profit > MAX_STOP_ON_PROFIT) {
				stop_on_profit = MAX_STOP_ON_PROFIT;
			}
			$('#stop_on_profit').val(stop_on_profit.toFixed(8));
		}

		function change_stop_on_loss() {
			var stop_on_loss = parseFloat($('#stop_on_loss').val());
			if(stop_on_loss < MIN_STOP_ON_PROFIT || isNaN(stop_on_loss)) {
				stop_on_loss = MIN_STOP_ON_PROFIT;
			} else if(stop_on_loss > MAX_STOP_ON_PROFIT) {
				stop_on_loss = MAX_STOP_ON_PROFIT;
			}
			$('#stop_on_loss').val(stop_on_loss.toFixed(8));
		}
		
		function start_auto_bet() {
			if(selected_numbers.length == 0) {
				return;
			}
			$('#start_autobet').hide();
			$('#stop_autobet').show();
			$('#number_rolls').val(0);
			auto_betting_status = 'running';
			profit_loss = 0.00000000;
			base_bet = parseFloat($('#bet_amount').val());
			$('#profit_loss').val(profit_loss.toFixed(8));
			$('#profit_loss').css('color', '#333');
			disable_all_inputs();
			process_bet_game_keno();
		}
		
		function stop_auto_bet() {
			auto_betting_status = 'stopped';
			enable_all_inputs();
			$('#stop_autobet').hide();
			$('#start_autobet').show();
		}
		
		function reset_start_button() {
			auto_betting_status = 'stopped';
			$('#play_button').addClass('process_start_auto_bet_game_keno');
			$('#play_button').removeClass('process_stop_auto_bet_game_keno');
			$('#play_button span').html('START');
			$('#play_button span').show();
			$('#play_button img').hide();
			$("#play_button").attr("disabled", false);
		}
		
		$(document).ready(function() {
			draw_keno_table([]);
			show_my_bets(my_bet_data);
			$('#show_my_bets').on('click', function(){show_my_bets(my_bet_data);});
			$('#show_all_bets').on('click', show_all_bets);
			$(document).on("click","#keno_gameboard .keno_gamecell", process_select_cell_game_keno);
			$("input[type=radio][name=difficulty]").on("change", change_difficulty);
			$(document).on("click",".process_bet_game_keno", process_bet_game_keno);
			$("input[type=radio][name=onwin]").on("change", change_on_win);
			$("input[type=radio][name=onloss]").on("change", change_on_loss);
			$("#increase_onwin_by").on("change", change_increase_onwin_by);
			$("#increase_onloss_by").on("change", change_increase_onloss_by);
			$("#stop_on_profit").on("change", change_stop_on_profit);
			$("#stop_on_loss").on("change", change_stop_on_loss);
			$("#start_autobet").on("click", start_auto_bet);
			$("#stop_autobet").on("click", stop_auto_bet);
			$("#bet_double").on("click", set_bet_double_amount);
			$("#bet_half").on("click", set_bet_half_amount);
			$("#bet_amount").on("change", change_bet_amount);
			$("#switch_bet_mode").on("change", switch_bet_mode);
		});
		</script>
	</body>
</html>