<!DOCTYPE html>
<html lang="en">
	<?php include('header.php');?>
	<?php if(isset($user_info) && $user_info->dark_mode == 1):?>
	<body class="dark_mode">
	<?php else:?>
	<body>
	<?php endif?>
		<?php include('menu.php');?>
		<style>
		#start_game_gems:disabled, #stop_game_gems:disabled {
			opacity: 0.6 !important;
		}
		.progress_table {
			position: relative;
		}
		.game_result_wrap {
			font-size: 0.875rem;
			border-radius: 10px;
			text-align: center;
			position: absolute;
			width: 150px;
			height: 85px;
			left: calc(50% - 75px);
			top: calc(50% - 37.5px);
			border: 4px solid;
			box-shadow: 0 10px 15px -3px rgba(0, 0, 0, .2), 0 4px 6px -2px rgba(0, 0, 0, .1);
			z-index: 2;
			display: none;
			background-image: url(<?=base_url()?>assets/img/games/3440162.png) !important;
			background-repeat: repeat;
		}
		.game_result_wrap.win {
			border-color: #00e701;
			color:  #00e701;
		}
		.game_result_wrap .multiplier {
			font-size: 25px;
			font-weight: 600;
			width: 100%;
			margin-top: 5px;
		}
		.game_result_wrap .win_amount {
			font-size: 14px;
		}
		</style>
		<section class="get_form_nine_area p_100" style="padding-top: 120px">
			<div class="container">
				<div class="single_title_n">
					<h2><?=$langs['game_gems']?></h2>
					<div class="gems_game_container game_main" style="width: 100%">
						<div class="col-xs-12">
							<div class="input_label"><?=$langs['total_profit_label']?></div>
							<div class="input_group disabled">
								<img src="<?=base_url()?>assets/img/bnb.svg" style="width: 20px; height: 20px; margin-top: 9px">
								<input type="text" id="profit" value="<?=number_format($temp_profit / 100000000, 8, '.', '')?>">
							</div>
						</div>
						<div class="progress_table">
							<?php 
								$MAGIC_NUMBER = 0.97;
								$easy_difficulty_payout = array();
								$medium_difficulty_payout = array();
								$hard_difficulty_payout = array();
								$payout = 1;
								for($i = 0; $i < 10; $i++) {
									$payout = number_format($payout * $MAGIC_NUMBER * 1.5, 2, '.', '');
									array_push($easy_difficulty_payout, $payout);
								}
								
								$payout = 1;
								for($i = 0; $i < 10; $i++) {
									$payout = number_format($payout * $MAGIC_NUMBER * 2, 2, '.', '');
									array_push($medium_difficulty_payout, $payout);
								}
								
								$payout = 1;
								for($i = 0; $i < 10; $i++) {
									$payout = number_format($payout * $MAGIC_NUMBER * 3, 2, '.', '');
									array_push($hard_difficulty_payout, $payout);
								}
							?>
							
							
							<?php if($difficulty == ''):?>
							<div id="easy_difficulty">
								<?php for($i = 9; $i >= 0; $i--){?>
									<div class="progress_row col_3" id="re<?=$i?>">
										<?php for($j = 0; $j < 3; $j++):?>
										<button class="progress_cell" id="ce<?=$i.$j?>" tile_id="<?=$i.$j?>" type="button"><span>x<?=$easy_difficulty_payout[$i]?></span></button>
										<?php endfor?>
									</div>
								<?php }?>
							</div>
							<div id="medium_difficulty" style="display: none">
								<?php for($i = 9; $i >= 0; $i--){?>
									<div class="progress_row col_2" id="rm<?=$i?>">
										<?php for($j = 0; $j < 2; $j++):?>
										<button class="progress_cell" id="cm<?=$i.$j?>" tile_id="<?=$i.$j?>" type="button"><span>x<?=$medium_difficulty_payout[$i]?></span></button>
										<?php endfor?>
									</div>
								<?php }?>
							</div>
							<div id="hard_difficulty" style="display: none">
								<?php for($i = 9; $i >= 0; $i--){?>
									<div class="progress_row col_3" id="rh<?=$i?>">
										<?php for($j = 0; $j < 3; $j++):?>
										<button class="progress_cell" id="ch<?=$i.$j?>" tile_id="<?=$i.$j?>" type="button"><span>x<?=$hard_difficulty_payout[$i]?></span></button>
										<?php endfor?>
									</div>
								<?php }?>
							</div>
							
							<div class="game_result_wrap">
								<div class="multiplier"></div>
								<div class="win_amount"></div>
							</div>
							
							
							<?php elseif($difficulty == 'easy'):?>
							<div id="easy_difficulty">
								<?php for($i = 9; $i >= 0; $i--){?>
									<div class="progress_row col_3 <?php if(($i == 0 && $tiles[0] == -1) || ($i > 0 && $tiles[$i] == -1 && $tiles[$i-1] != -1)) {echo 'selected';} else if($tiles[$i] != -1) echo 'opened';?>" id="re<?=$i?>">
										<?php for($j = 0; $j < 3; $j++):?>
										<button class="progress_cell <?php if($tiles[$i] == $j) echo 'chosen';?>" id="ce<?=$i.$j?>" tile_id="<?=$i.$j?>" type="button"><span><?php if($tiles[$i] == $j) {echo '<i class="fas fa-gem"></i>';} else {echo 'x'.$easy_difficulty_payout[$i];}?></span></button>
										<?php endfor?>
									</div>
								<?php }?>
							</div>
							<div id="medium_difficulty" style="display: none">
								<?php for($i = 9; $i >= 0; $i--){?>
									<div class="progress_row col_2" id="rm<?=$i?>">
										<?php for($j = 0; $j < 2; $j++):?>
										<button class="progress_cell" id="cm<?=$i.$j?>" tile_id="<?=$i.$j?>" type="button"><span>x<?=$medium_difficulty_payout[$i]?></span></button>
										<?php endfor?>
									</div>
								<?php }?>
							</div>
							<div id="hard_difficulty" style="display: none">
								<?php for($i = 9; $i >= 0; $i--){?>
									<div class="progress_row col_3" id="rh<?=$i?>">
										<?php for($j = 0; $j < 3; $j++):?>
										<button class="progress_cell" id="ch<?=$i.$j?>" tile_id="<?=$i.$j?>" type="button"><span>x<?=$hard_difficulty_payout[$i]?></span></button>
										<?php endfor?>
									</div>
								<?php }?>
							</div>
							
							
							
							
							<?php elseif($difficulty == 'medium'):?>
							<div id="medium_difficulty">
								<?php for($i = 9; $i >= 0; $i--){?>
									<div class="progress_row col_2 <?php if(($i == 0 && $tiles[0] == -1) || ($i > 0 && $tiles[$i] == -1 && $tiles[$i-1] != -1)) {echo 'selected';} else if($tiles[$i] != -1) echo 'opened';?>" id="rm<?=$i?>">
										<?php for($j = 0; $j < 2; $j++):?>
										<button class="progress_cell <?php if($tiles[$i] == $j) echo 'chosen';?>" id="cm<?=$i.$j?>" tile_id="<?=$i.$j?>" type="button"><span><?php if($tiles[$i] == $j) {echo '<i class="fas fa-gem"></i>';} else {echo 'x'.$medium_difficulty_payout[$i];}?></span></button>
										<?php endfor?>
									</div>
								<?php }?>
							</div>
							<div id="easy_difficulty" style="display: none">
								<?php for($i = 9; $i >= 0; $i--){?>
									<div class="progress_row col_3" id="re<?=$i?>">
										<?php for($j = 0; $j < 3; $j++):?>
										<button class="progress_cell" id="ce<?=$i.$j?>" tile_id="<?=$i.$j?>" type="button"><span>x<?=$easy_difficulty_payout[$i]?></span></button>
										<?php endfor?>
									</div>
								<?php }?>
							</div>
							<div id="hard_difficulty" style="display: none">
								<?php for($i = 9; $i >= 0; $i--){?>
									<div class="progress_row col_3" id="rh<?=$i?>">
										<?php for($j = 0; $j < 3; $j++):?>
										<button class="progress_cell" id="ch<?=$i.$j?>" tile_id="<?=$i.$j?>" type="button"><span>x<?=$hard_difficulty_payout[$i]?></span></button>
										<?php endfor?>
									</div>
								<?php }?>
							</div>
							
							
							
							
							<?php elseif($difficulty == 'hard'):?>
							<div id="hard_difficulty">
								<?php for($i = 9; $i >= 0; $i--){?>
									<div class="progress_row col_3 <?php if(($i == 0 && $tiles[0] == -1) || ($i > 0 && $tiles[$i] == -1 && $tiles[$i-1] != -1)) {echo 'selected';} else if($tiles[$i] != -1) echo 'opened';?>" id="rh<?=$i?>">
										<?php for($j = 0; $j < 3; $j++):?>
										<button class="progress_cell <?php if($tiles[$i] == $j) echo 'chosen';?>" id="ch<?=$i.$j?>" tile_id="<?=$i.$j?>" type="button"><span><?php if($tiles[$i] == $j) {echo '<i class="fas fa-gem"></i>';} else {echo 'x'.$hard_difficulty_payout[$i];}?></span></button>
										<?php endfor?>
									</div>
								<?php }?>
							</div>
							<div id="easy_difficulty" style="display: none">
								<?php for($i = 9; $i >= 0; $i--){?>
									<div class="progress_row col_3" id="re<?=$i?>">
										<?php for($j = 0; $j < 3; $j++):?>
										<button class="progress_cell" id="ce<?=$i.$j?>" tile_id="<?=$i.$j?>" type="button"><span>x<?=$easy_difficulty_payout[$i]?></span></button>
										<?php endfor?>
									</div>
								<?php }?>
							</div>
							<div id="medium_difficulty" style="display: none">
								<?php for($i = 9; $i >= 0; $i--){?>
									<div class="progress_row col_2" id="rm<?=$i?>">
										<?php for($j = 0; $j < 2; $j++):?>
										<button class="progress_cell" id="cm<?=$i.$j?>" tile_id="<?=$i.$j?>" type="button"><span>x<?=$medium_difficulty_payout[$i]?></span></button>
										<?php endfor?>
									</div>
								<?php }?>
							</div>
							
							<?php endif?>
						</div>
						<div class="difficulty">
							<div class="row">
								<div class="col-xs-4">
									<div class="radio icheck-success">
										<input type="radio" id="easy" name="difficulty" <?php if($difficulty == '' || $difficulty == 'easy') echo 'checked="checked"'?> <?php if($difficulty != '') echo 'disabled="disabled"';?>>
										<label for="easy"><?=$langs['game_level_easy_label']?></label>
									</div>
								</div>
								<div class="col-xs-4">
									<div class="radio icheck-success">
										<input type="radio" id="medium" name="difficulty" <?php if($difficulty == 'medium') echo 'checked="checked"'?> <?php if($difficulty != '') echo 'disabled="disabled"';?>>
										<label for="medium"><?=$langs['game_level_medium_label']?></label>
									</div>
								</div>
								<div class="col-xs-4">
									<div class="radio icheck-success">
										<input type="radio" id="hard" name="difficulty" <?php if($difficulty == 'hard') echo 'checked="checked"'?> <?php if($difficulty != '') echo 'disabled="disabled"';?>>
										<label for="hard"><?=$langs['game_level_hard_label']?></label>
									</div>
								</div>
							</div>
						</div>
						<div class="col-xs-12 bet_amount">
							<div class="input_label"><?=$langs['bet_ammount_label']?></div>
							<div class="input_group <?php if($difficulty != '') echo 'disabled';?>">
								<img src="<?=base_url()?>assets/img/bnb.svg" style="width: 20px; height: 20px; margin-top: 9px">
								<input type="text" id="bet_amount" value="<?php if($bet_amount != 0) echo number_format($bet_amount / 100000000, 8); else echo $MIN_BET_AMOUNT;?>" <?php if($bet_amount != 0) echo 'disabled="disabled"';?>>
							</div>
							<span id="bet_double">2X</span>
							<span id="bet_half">1/2</span>
						</div>
						<div class="col-xs-12">
						<?php if($difficulty == ''):?>
						<button id="start_game_gems" class="btn btn-success" type="submit"><img src="<?=base_url()?>assets/img/loading.gif" style="width: 35px; display: none"><span><?=$langs['game_start_btn']?></span></button>
						<button id="stop_game_gems" class="btn btn-success" type="submit" style="display: none"><img src="<?=base_url()?>assets/img/loading.gif" style="width: 35px; display: none"><span><?=$langs['game_cashout_btn']?></span></button>
						<?php else:?>
						<button id="start_game_gems" class="btn btn-success" type="submit" style="display: none"><img src="<?=base_url()?>assets/img/loading.gif" style="width: 35px; display: none"><span><?=$langs['game_start_btn']?></span></button>
						<button id="stop_game_gems" class="btn btn-success" type="submit"><img src="<?=base_url()?>assets/img/loading.gif" style="width: 35px; display: none"><span><?=$langs['game_cashout_btn']?></span></button>
						<?php endif?>
						</div>
						<div style="clear: both"></div>
					</div>
					<div class="gameBar_wrap">
						<ul class="gameBar_main clear">
							<li class="left gameBar_li" onclick="show_game_rules('Gems')">
								<div class="footer_wrap"><i class="fas fa-book"></i></div>
								<span class="footer_text"><?=$langs['game_rules_label']?></span>
							</li>
							<li class="left gameBar_li" onclick="show_game_fairness('Gems')">
								<div class="footer_wrap"><i class="fas fa-balance-scale"></i></div>
								<span class="footer_text"><?=$langs['game_fairness_label']?></span>
							</li>
							<?php if(false):?>
							<li class="left gameBar_li">
								<div class="footer_wrap"><i class="fas fa-keyboard"></i></div>
								<span class="footer_text"><?=$langs['game_hotkeys_label']?></span>
							</li>
							<?php endif?>
						</ul>
					</div>
					<div class="bets_nav" style="width: 192px">
						<ul class="clear">
							<li class="left li_active" id="show_my_bets"><?=$langs['MY_BETS']?></li>
							<li class="left" id="show_all_bets"><?=$langs['ALL_BETS']?></li>
							<?php if(false):?><li class="left"><?=$langs['HIGH_WINS']?></li><?php endif?>
						</ul>
					</div>
					<div style="width: calc(100% - 20px); margin-left: 10px; overflow-x: auto;" id="my_bets_table">
						<table class="table table-striped bets_table">
							<thead>
								<tr>
									<td><?=$langs['bet_tbl_time']?></td>
									<td><?=$langs['bet_tbl_game']?></td>
									<td><?=$langs['bet_tbl_bet_amount']?></td>
									<td><?=$langs['bet_tbl_multiplier']?></td>
									<td><?=$langs['bet_tbl_profit']?></td>
								</tr>
							</thead>
							<tbody></tbody>
						</table>
					</div>
					<div style="width: calc(100% - 20px); margin-left: 10px; overflow-x: auto; display: none" id="all_bets_table">
						<table class="table table-striped bets_table">
							<thead>
								<tr>
									<td><?=$langs['bet_tbl_time']?></td>
									<td><?=$langs['bet_tbl_game']?></td>
									<td><?=$langs['bet_tbl_user']?></td>
									<td><?=$langs['bet_tbl_bet_amount']?></td>
									<td><?=$langs['bet_tbl_multiplier']?></td>
									<td><?=$langs['bet_tbl_profit']?></td>
								</tr>
							</thead>
							<tbody></tbody>
						</table>
					</div>
				</div>
			   </div>
			</div>
		</section>
		<?php include('footer.php');?>
		<script>
			var user_balance = <?=number_format($user_info->balance / 100000000, 8, '.', '')?>;
			const MIN_BET_AMOUNT = <?=$MIN_BET_AMOUNT?>;
			const MAX_BET_AMOUNT = <?=$MAX_BET_AMOUNT?>;
			
			const MAGIC_NUMBER = 0.97;
			var difficulty = 'easy';
			var my_bet_data = [];
			
			
			function load_difficulty() {
				if($("#easy").is(":checked")) {
					difficulty = 'easy';
				} else if($("#medium").is(":checked")) {
					difficulty = 'medium';
				} else if($("#hard").is(":checked")) {
					difficulty = 'hard';
				}
			}
			
			function set_bet_double_amount() {
				if($('#bet_amount').prop("disabled")) {
					return;
				}				
				var bet_amount = parseFloat($('#bet_amount').val());
				bet_amount *= 2;
				if(bet_amount > Math.min(MAX_BET_AMOUNT, user_balance)) {
					bet_amount = Math.min(MAX_BET_AMOUNT, user_balance);
				}
				$('#bet_amount').val(bet_amount.toFixed(8));
			}
			
			function set_bet_half_amount() {
				if($('#bet_amount').prop("disabled")) {
					return;
				}
				var bet_amount = parseFloat($('#bet_amount').val());
				bet_amount /= 2;
				if(bet_amount < MIN_BET_AMOUNT || isNaN(bet_amount)) {
					bet_amount = MIN_BET_AMOUNT;
				}
				$('#bet_amount').val(bet_amount.toFixed(8));
			}
			
			function change_bet_amount() {
				var bet_amount = parseFloat($('#bet_amount').val());
				if(bet_amount < MIN_BET_AMOUNT || isNaN(bet_amount)) {
					bet_amount = MIN_BET_AMOUNT;
				}
				if(bet_amount > Math.min(MAX_BET_AMOUNT, user_balance)) {
					//bet_amount = Math.min(MAX_BET_AMOUNT, user_balance);
					 $('#bet_amount').parent().css('border', '2px solid #f44336');
				} else {
					 $('#bet_amount').parent().css('border', '1px solid #DDD');
				}
				setTimeout(function() {
					$('#bet_amount').val(bet_amount.toFixed(8));
				}, 100);
			}
			
			function clean_game_board() {
				var payout = 1;
				for(i = 0; i < 10; i++) {
					$('#re'+i).removeClass('selected');
					$('#re'+i).removeClass('opened');
					payout = (payout * MAGIC_NUMBER * 1.5).toFixed(2);
					for(j = 0; j < 3; j++) {
						$('#ce'+i+''+j).removeClass('chosen');
						$('#ce'+i+''+j).html('<span>x'+payout+'</span>');
					}
				}
				payout = 1;
				for(i = 0; i < 10; i++) {
					$('#rm'+i).removeClass('selected');
					$('#rm'+i).removeClass('opened');
					payout = (payout * MAGIC_NUMBER * 2).toFixed(2);
					for(j = 0; j < 2; j++) {
						$('#cm'+i+''+j).removeClass('chosen');
						$('#cm'+i+''+j).html('<span>x'+payout+'</span>');
					}
				}
				payout = 1;
				for(i = 0; i < 10; i++) {
					$('#rh'+i).removeClass('selected');
					$('#rh'+i).removeClass('opened');
					payout = (payout * MAGIC_NUMBER * 3).toFixed(2);
					for(j = 0; j < 3; j++) {
						$('#ch'+i+''+j).removeClass('chosen');
						$('#ch'+i+''+j).html('<span>x'+payout+'</span>');
					}
				}
				$('.game_result_wrap').hide();
			}
			
			function reveal_game_board(gems) {
				for(i = 0; i < gems.length; i++) {
					for(j = 0; j < gems[i].length; j++) {
						if(gems[i][j] == 1) {
							if(difficulty == 'easy') {
								$('#ce'+i+''+j).html('<span><i class="fas fa-gem"></i></span>')
							}
							if(difficulty == 'medium') {
								$('#cm'+i+''+j).html('<span><i class="fas fa-gem"></i></span>')
							}
							if(difficulty == 'hard') {
								$('#ch'+i+''+j).html('<span><i class="fas fa-gem"></i></span>')
							}
						} else {
							if(difficulty == 'easy') {
								$('#ce'+i+''+j).html('<span></span>')
							}
							if(difficulty == 'medium') {
								$('#cm'+i+''+j).html('<span></span>')
							}
							if(difficulty == 'hard') {
								$('#ch'+i+''+j).html('<span></span>')
							}
						}
					}
				}
				$("#start_game_gems").show();
				$("#stop_game_gems").hide();
				$('#bet_amount').prop('disabled', false);
				$('#bet_amount').parent().removeClass('disabled');
				$('input[type=radio][name=difficulty]').prop('disabled', false);
				$('#profit').val('0.00000000');
			}
			
			function change_difficulty() {
				if($('#easy').is(':checked')) {
					$('#easy_difficulty').show();
					$('#medium_difficulty').hide();
					$('#hard_difficulty').hide();
					difficulty = 'easy';
				} else if($('#medium').is(':checked')){
					$('#easy_difficulty').hide();
					$('#medium_difficulty').show();
					$('#hard_difficulty').hide();
					difficulty = 'medium';
				} else if($('#hard').is(':checked')){
					$('#easy_difficulty').hide();
					$('#medium_difficulty').hide();
					$('#hard_difficulty').show();
					difficulty = 'hard';
				}
				clean_game_board();
			}
			
			
			function process_bet_game_gems() {
				var bet_amount = parseFloat($('#bet_amount').val());
				$('#bet_amount').prop('disabled', true);
				$('#bet_amount').parent().addClass('disabled');
				$('input[type=radio][name=difficulty]').prop('disabled', true);
				$('#start_game_gems span').hide();
				$('#start_game_gems img').show();
				$("#start_game_gems").attr("disabled", true);
				clean_game_board();
				setTimeout(function() {
					$.ajax({
						url: "<?=base_url()?>process.php",
						type: "POST",
						data: "action=bet_game_gems&bet_amount="+bet_amount+"&difficulty="+difficulty,
						error: function(){
							$.toast({
								heading: 'Error!',
								text: 'Request timed out. Please try again!',
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});
							$('#bet_amount').prop('disabled', false);
							$('#bet_amount').parent().removeClass('disabled');
							$('input[type=radio][name=difficulty]').prop('disabled', false);
							$('#start_game_gems img').hide();
							$('#start_game_gems span').show();
							$("#start_game_gems").attr("disabled", false);
						},
						success: function(out){
							let obj = JSON.parse(out);
							if(obj.ret == 0) {
								$.toast({
									heading: 'Error!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'error'
								});
								$('#bet_amount').prop('disabled', false);
								$('#bet_amount').parent().removeClass('disabled');
								$('input[type=radio][name=difficulty]').prop('disabled', false);
							} else {
								$("#start_game_gems").hide();
								$("#stop_game_gems").show();
								if(difficulty == 'easy') {
									$('#re0').addClass('selected');
								}
								if(difficulty == 'medium') {
									$('#rm0').addClass('selected');
								}
								if(difficulty == 'hard') {
									$('#rh0').addClass('selected');
								}
								$('.user_balance').text(parseFloat((parseInt(obj.balance)) / 100000000).toFixed(8));
								user_balance = parseFloat((parseInt(obj.balance)) / 100000000).toFixed(8);
							}
							$('#start_game_gems img').hide();
							$('#start_game_gems span').show();
							$("#start_game_gems").attr("disabled", false);
						}
					});
				}, 10);
			}
			
			
			function process_select_tile_game_gems() {
				if(!$(this).parent().hasClass('selected')) {
					return;
				}
				if($(this).parent().children().hasClass('chosen')) {
					return;
				}
				var tile_obj = $(this);
				var tile_id =  tile_obj.attr('tile_id');
				tile_obj.addClass('chosen');
				tile_obj.html('<img src="<?=base_url()?>assets/img/loading.gif" style="width: 25px;">');
				setTimeout(function() {
					$.ajax({
						url: "<?=base_url()?>process.php",
						type: "POST",
						data: "action=select_tile_game_gems&tile_id="+tile_id,
						error: function(){
							$.toast({
								heading: 'Error!',
								text: 'Request timed out. Please try again!',
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});
						},
						success: function(out){
							let obj = JSON.parse(out);
							if(obj.ret == 0) {
								$.toast({
									heading: 'Error!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'error'
								});
							} else {
								tile_obj.addClass('chosen');
								if(obj.type == 'gem') {
									if(obj.gems == '') {
										tile_obj.html('<span><i class="fas fa-gem"></i></span>');
										tile_obj.parent().removeClass('selected');
										tile_obj.parent().addClass('opened');
										$('#profit').val((parseFloat(obj.temp_profit) / 100000000).toFixed(8));
										$('#'+obj.next_row_id).addClass('selected');
									} else {
										reveal_game_board(obj.gems);
										/*$.toast({
											heading: 'Success!',
											text: obj.mes,
											showHideTransition: 'slide',
											position: 'top-right',
											icon: 'success'
										});*/
										$('.user_balance').text(parseFloat((parseInt(obj.balance)) / 100000000).toFixed(8));
										user_balance = parseFloat((parseInt(obj.balance)) / 100000000).toFixed(8);
										if(Array.isArray(my_bet_data)) {
											my_bet_data.unshift(obj.bet_data);
										} else {
											my_bet_data = [obj.bet_data];
										}
										if (Array.isArray(my_bet_data) && my_bet_data.length > 20) {
											my_bet_data = my_bet_data.slice(0, 20);
										}
										store_bet_data(my_bet_data);
										show_my_bet_data(my_bet_data);
										
										$('.game_result_wrap').show();
										$('.game_result_wrap').addClass('win');
										$('.game_result_wrap .multiplier').text(obj.multiplier);
										$('.game_result_wrap .win_amount').text(parseFloat((parseInt(obj.win_amount)) / 100000000).toFixed(8));
									}
									
								} else if(obj.type == 'poop'){
									reveal_game_board(obj.gems);
									if(Array.isArray(my_bet_data)) {
										my_bet_data.unshift(obj.bet_data);
									} else {
										my_bet_data = [obj.bet_data];
									}
									if (Array.isArray(my_bet_data) && my_bet_data.length > 20) {
										my_bet_data = my_bet_data.slice(0, 20);
									}
									store_bet_data(my_bet_data);
									show_my_bet_data(my_bet_data);
								}
							}
						}
					});			
				}, 10);
			}
			
			function process_cashout_game_gems() {
				$('#stop_game_gems span').hide();
				$('#stop_game_gems img').show();
				$("#stop_game_gems").attr("disabled", true);
				setTimeout(function() {
					$.ajax({
						url: "<?=base_url()?>process.php",
						type: "POST",
						data: "action=cashout_game_gems",
						error: function(){
							$.toast({
								heading: 'Error!',
								text: 'Request timed out. Please try again!',
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});
							$('#stop_game_gems img').hide();
							$('#stop_game_gems span').show();
							$("#stop_game_gems").attr("disabled", false);
						},
						success: function(out){
							let obj = JSON.parse(out);
							if(obj.ret == 0) {
								$.toast({
									heading: 'Error!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'error'
								});
							} else {
								/*$.toast({
									heading: 'Success!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'success'
								});*/
								reveal_game_board(obj.gems);
								$('.user_balance').text(parseFloat((parseInt(obj.balance)) / 100000000).toFixed(8));
								user_balance = parseFloat((parseInt(obj.balance)) / 100000000).toFixed(8);
								if(Array.isArray(my_bet_data)) {
									my_bet_data.unshift(obj.bet_data);
								} else {
									my_bet_data = [obj.bet_data];
								}
								if (Array.isArray(my_bet_data) && my_bet_data.length > 20) {
									my_bet_data = my_bet_data.slice(0, 20);
								}
								store_bet_data(my_bet_data);
								show_my_bet_data(my_bet_data);
								
								$('.game_result_wrap').show();
								$('.game_result_wrap').addClass('win');
								$('.game_result_wrap .multiplier').text(obj.multiplier);
								$('.game_result_wrap .win_amount').text(parseFloat((parseInt(obj.win_amount)) / 100000000).toFixed(8));
							}
							$('#stop_game_gems img').hide();
							$('#stop_game_gems span').show();
							$("#stop_game_gems").attr("disabled", false);
						}
					});
				}, 10);
			}
			
			$(document).ready(function() {
				load_difficulty();
				$("#bet_double").on("click", set_bet_double_amount);
				$("#bet_half").on("click", set_bet_half_amount);
				$("#bet_amount").on("change", change_bet_amount);
				$("#start_game_gems").on("click", process_bet_game_gems);
				$(".progress_cell").on("click", process_select_tile_game_gems);
				$("#stop_game_gems").on("click", process_cashout_game_gems);
				$("input[type=radio][name=difficulty]").on("change", change_difficulty);
				
				show_my_bets(my_bet_data);
				$('#show_my_bets').on('click', function(){show_my_bets(my_bet_data);});
				$('#show_all_bets').on('click', show_all_bets);
				
			});
			
		</script>
	</body>
</html>