<!DOCTYPE html>
<html lang="en">
	<?php include('header.php');?>
	<!-- strategy bet -->
	<style>
		#strategy_box .strategy_btn {
			background: #03a9f4;
			color: #FFF;
			padding: 10px 15px;
			height: 45px;
			width: 45px;
			line-height: 26px;
			margin-top: -2px;
			margin-right: -1px;
			position: relative;
			border-radius: 0px 3px 3px 0px;
			cursor: pointer;
		}
		#strategy_box .strategy_btn:hover {
			background: #2196f3;
		}
		#strategy_box .strategy_btn:last-child {
			background: #8bc34a;
			margin-right: -12px;
		}
		#strategy_box .strategy_btn:last-child:hover {
			background: #7fb541;
		}
		.strategy_condition_block {
			padding: 10px 5px;
			background: #F5F5F5;
			border-radius: 5px;
			border: 1px solid #DDD;
			width: calc(100% + 20px);
			margin-left: -10px;
			font-size: 13px!important;
		}
		.strategy_condition_block .input_group {
			margin: 5px auto 10px;
			height: 40px!important;
			padding: 0px;
		}
		.dark_mode .strategy_condition_block .input_group {
			height: 44px !important;
		}
		.strategy_condition_block .input_label {
			font-weight: 600;
			margin-left: 5px;
		}
		.strategy_condition_block_title {
			font-weight: 700;
			font-size: 13px;
			margin: 25px -5px 5px;
		}
		.strategy_condition_block .input_group select {
			height: 40px;
			margin: 0px;
			border: none;
			width: 100%;
			padding: 10px;
			font-size: 13px;
		}
		.strategy_condition_block .input_group input {
			padding: 10px;
			font-size: 12px;
			height: 38px;
			width: 100%;
		}
		.save_strategy_btn {
			width: calc(100% + 20px);
			height: 40px;
			font-weight: bold;
			font-size: 13px;
			background: #8bc34a!important;
			border: 1px solid #8bc34a!important;
			color: #FFF;
			line-height: 25px;
			margin-top: 15px;
			margin-left: -10px;
		}
		.save_strategy_btn:hover{
			color: #FFF;
			background: #7fb541!important;
			border: 1px solid #7fb541!important;
		}
		.delete_strategy_btn {
			width: calc(100% + 20px);
			height: 40px;
			font-weight: bold;
			font-size: 13px;
			background: #f44336 !important;
			border: 1px solid #f44336 !important;
			color: #FFF;
			line-height: 25px;
			margin-top: 15px;
			margin-left: -10px;
			margin-right: -10px;
			display: none;
		}
		.delete_strategy_btn:hover{
			background: #e93528 !important;
			border: 1px solid #e93528 !important;
			color: #FFF;
		}
		
		.add_condition_block_btn {
			width: 100px;
			height: 40px;
			font-weight: bold;
			font-size: 13px;
			background: #03a9f4 !important;
			border: 1px solid #03a9f4 !important;
			color: #FFF;
			float: right;
			margin-right: 10px;
			line-height: 25px;
		}
		.add_condition_block_btn:hover{
			color: #FFF;
			background: #2196f3!important;
			border: 1px solid #2196f3!important;
		}
		.delete_condition_block_btn {
			width: 100px;
			height: 40px;
			font-weight: bold;
			font-size: 13px;
			background: #f44336 !important;
			border: 1px solid #f44336 !important;
			color: #FFF;
			float: right;
			margin-right: 10px;
			line-height: 25px;
		}
		.delete_condition_block_btn:hover {
			background: #e93528 !important;
			border: 1px solid #e93528 !important;
			color: #FFF;
		}
		.condition_type {
			display: flex;
			margin-bottom: 10px;
		}
		.profit_condition_wrap {
			display: none;
		}
		.bet_condition_wrap div, .profit_condition_wrap div, .do_action_wrap div {
			padding: 0px 5px;
		}
		#start_strategy_bet, #stop_strategy_bet {
			display: none;
		}
		#strategy_profit_box {
			display: none;
		}
		.delete_strategy_wrap {
			float: right;
			cursor: pointer;
			margin-top: 5px;
			margin-right: 5px;
		}
		.delete_strategy_wrap label{
			color: #AAA;
		}
		.delete_strategy_wrap .icheck-info > input:first-child:checked + label::before, .delete_strategy_wrap .icheck-info > input:first-child:checked + input[type="hidden"] + label::before {
			background-color: #F44336!important;
			border-color: #F44336!important;
		}
		.delete_strategy_wrap .icheck-info > input:first-child:not(:checked):not(:disabled):hover + label::before, .delete_strategy_wrap .icheck-info > input:first-child:not(:checked):not(:disabled):hover + input[type="hidden"] + label::before {
			border-color: #F44336!important;
		}
	</style>
	<!-- strategy bet -->
	<?php if(isset($user_info) && $user_info->dark_mode == 1):?>
	<body class="dark_mode">
	<?php else:?>
	<body>
	<?php endif?>
		<?php include('menu.php');?>
		<section class="get_form_nine_area p_100" style="padding-top: 120px">
			<div class="container">
				<div class="single_title_n">
					<h2><?=$langs['game_dice']?></h2>
					<div class="game_main row" id="game_dice">		
						<div class="col-xs-12">
							<div class="input_container">
								<div class="row">
									<div class="col-xs-12 col-sm-6 bet_amount">
										<div class="input_label"><?=$langs['bet_ammount_label']?></div>
										<div class="input_group" style="height: 44px">
											<img src="<?=base_url()?>assets/img/bnb.svg" style="width: 20px; height: 20px; margin-top: 9px"/>
											<input type="text" id="bet_amount" value="<?=$DICE_MIN_BET_AMOUNT?>">
										</div>
										<span id="bet_double" onclick="set_bet_double_amount">2X</span>
										<span id="bet_half" onclick="set_bet_half_amount">1/2</span>
									</div>
									<div class="col-xs-12 col-sm-6">
										<div class="input_label"><?=$langs['profit_on_win_label']?></div>
										<div class="input_group">
											<img src="<?=base_url()?>assets/img/bnb.svg" style="width: 20px; height: 20px; margin-top: 9px"/>
											<input type="text" id="win_profit" value="0.00000001" readonly="readonly">
										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="col-xs-12">
							<div class="input_container">
								<div class="row">
									<div class="col-sm-4 col-xs-12">
										<div class="input_label" id="roll_to_win_lb" style="cursor: pointer" onclick="switch_bet_on()"><?=$langs['roll_over_to_win_label']?></div>
										<div class="input_group" onclick="switch_bet_on()" style="cursor: pointer" >
											<input type="text" id="roll_to_win" value="51.50" readonly="readonly" style="cursor: pointer" class="noselect">
											<i class="fas fa-random addon"></i>
										</div>
									</div>
									<div class="col-sm-4 col-xs-6">
										<div class="input_label"><?=$langs['multiplier_label']?></div>
										<div class="input_group">
											<input type="text" id="multiplier" value="2.00">
											<i class="fas fa-times addon"></i>
										</div>
									</div>
									<div class="col-sm-4 col-xs-6">
										<div class="input_label"><?=$langs['win_chance_label']?></div>
										<div class="input_group">
											<input type="text" id="win_chance" value="48.50">
											<i style="font-size: 12px" class="fas fa-percent addon"></i>
										</div>
									</div>
								</div>
							</div>
						</div>
						<!-- strategy bet -->
						<div class="col-xs-3" id="switch_bet_mode" style="margin-top: 25px">
							<!--<div class="checkbox icheck-info">
								<input type="checkbox" id="auto_dice">
								<label for="auto_dice">Auto</label>
							</div>-->
							<input type="checkbox" class="jtoggler" data-jtmulti-state="">
							<div id="bet_mode_label" style="margin-left: 12px; font-size: 12px"><?=$langs['switch_manual']?></div>
						</div>
						<!-- strategy bet -->
						<div class="col-xs-6">
							<button class="btn bet_btn" id="roll_dice"><img src="<?=base_url()?>assets/img/loading.gif" style="width: 35px; display: none"><span><?=$langs['roll_dice_btn']?></span></button>
							<button class="btn bet_btn" id="start_autobet"><span><?=$langs['start_auto_dice_btn']?></span></button>
							<button class="btn bet_btn" id="stop_autobet"><img src="<?=base_url()?>assets/img/loading.gif" style="width: 35px"><span><?=$langs['stop_auto_dice_btn']?></span></button>
							<!-- strategy bet -->
							<button class="btn bet_btn" id="start_strategy_bet"><span><?=$langs['start_strategy_btn']?></span></button>
							<button class="btn bet_btn" id="stop_strategy_bet"><img src="<?=base_url()?>assets/img/loading.gif" style="width: 35px"><span><?=$langs['stop_strategy_btn']?></span></button>
							<!-- strategy bet -->
						</div>
						<div class="col-xs-3"></div>
						<div class="col-xs-12">
							<div class="slider">
								<div class="min_max">0</div>
								<div class="runway">
									<div class="slider_bar"></div>
									<div class="result_maker">
										<span>62.66</span>
									</div>
									<div class="slider_button"></div>
								</div>
								<div class="min_max">100</div>
							</div>
						</div>
						
						<div class="col-xs-12 col-sm-6" id="on_win_box">
							<div class="input_container">
								<div class="input_label"><?=$langs['on_win_label']?></div>
								<div class="radio icheck-success">
								  <input type="radio" id="reset_onwin" name="onwin" checked="checked">
								   <label for="reset_onwin"><?=$langs['reset_bet_label']?></label>
								</div>
								<div style="display: flex">
									<div class="radio icheck-success">
									  <input type="radio" id="increase_onwin" name="onwin">
									   <label for="increase_onwin"><?=$langs['increase_bet_amount']?></label>
									</div>
									<div class="input_group disabled" style="width: 100px; margin-left: 15px; margin-top: -5px">
										<input type="text" id="increase_onwin_by" value="100" disabled="">
										<i style="font-size: 12px" class="fas fa-percent addon"></i>
									</div>
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6" id="on_loss_box">
							<div class="input_container">
								<div class="input_label"><?=$langs['on_loss_label']?></div>
								<div class="radio icheck-success">
								  <input type="radio" id="reset_onloss" name="onloss" checked="checked">
								   <label for="reset_onloss"><?=$langs['reset_bet_label']?></label>
								</div>
								<div style="display: flex">
									<div class="radio icheck-success">
									  <input type="radio" id="increase_onloss" name="onloss">
									   <label for="increase_onloss"><?=$langs['increase_bet_amount']?></label>
									</div>
									<div class="input_group disabled" style="width: 100px; margin-left: 15px; margin-top: -5px">
										<input type="text" id="increase_onloss_by" value="100" disabled="">
										<i style="font-size: 12px" class="fas fa-percent addon"></i>
									</div>
								</div>
							</div>
						</div>
						<div class="col-xs-12" id="stop_profit_box">
							<div class="input_container">
								<div class="row">
									<div class="col-xs-6">
										<div class="input_label"><?=$langs['stop_on_profit_label']?></div>
										<div class="input_group">
											<img src="<?=base_url()?>assets/img/bnb.svg" style="width: 20px; height: 20px; margin-top: 9px"/>
											<input type="text" id="stop_on_profit" value="0.00000000">
										</div>
									</div>
									<div class="col-xs-6">
										<div class="input_label"><?=$langs['stop_on_loss_label']?></div>
										<div class="input_group">
											<img src="<?=base_url()?>assets/img/bnb.svg" style="width: 20px; height: 20px; margin-top: 9px"/>
											<input type="text" id="stop_on_loss" value="0.00000000">
										</div>
									</div>
								</div>
							</div>
						</div>
						
						<div class="col-xs-12" id="total_profit_box">
							<div class="input_container">
								<div class="row">
									<div class="col-xs-6">
										<div class="input_label"><?=$langs['number_bets_label']?></div>
										<div class="input_group">
											<input type="text" id="number_rolls" value="0">
										</div>
									</div>
									<div class="col-xs-6">
										<div class="input_label"><?=$langs['total_profit_label']?></div>
										<div class="input_group">
											<img src="<?=base_url()?>assets/img/bnb.svg" style="width: 20px; height: 20px; margin-top: 9px"/>
											<input type="text" id="profit_loss" value="0.00000000">
										</div>
									</div>
								</div>
							</div>
						</div>
						
						<!-- strategy bet -->
						<div class="col-xs-12" id="strategy_box" style="margin-top: 10px; display: none">
							<div class="input_container">
								<div class="row">
									<div class="col-xs-12">
										<div class="input_label" style="float: left"><?=$langs['select_strategy_label']?></div>
										<div class="input_label" id="create_strategy" style="float: right; cursor: pointer; color: #2196F3"><i class="fas fa-plus-circle"></i> <?=$langs['create_strategy_label']?></div>
									</div>
									<div class="col-xs-12">
										<div class="input_group">
											<select id="strategies"></select>
											<span class="strategy_btn" id="edit_strategy"><i class="fas fa-eye"></i></span>
											<!--<span class="strategy_btn" id="create_strategy"><i class="fas fa-plus-circle"></i></span>-->
										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="col-xs-12" id="strategy_profit_box">
							<div class="input_container">
								<div class="row">
									<div class="col-xs-6">
										<div class="input_label"><?=$langs['number_bets_label']?></div>
										<div class="input_group">
											<input type="text" id="strategy_bets" value="0" readonly="readonly">
										</div>
									</div>
									<div class="col-xs-6">
										<div class="input_label"><?=$langs['total_profit_label']?></div>
										<div class="input_group">
											<img src="<?=base_url()?>assets/img/bnb.svg" style="width: 20px; height: 20px; margin-top: 9px"/>
											<input type="text" id="strategy_profit_loss" value="0.00000000" readonly="readonly">
										</div>
									</div>
								</div>
							</div>
						</div>
						<!-- strategy bet -->
					</div>
					<div class="gameBar_wrap">
						<ul class="gameBar_main clear">
							<li class="left gameBar_li" onclick="show_game_rules('Dice')">
								<div class="footer_wrap"><i class="fas fa-book"></i></div>
								<span class="footer_text"><?=$langs['game_rules_label']?></span>
							</li>
							<li class="left gameBar_li" onclick="show_game_fairness('Dice')">
								<div class="footer_wrap"><i class="fas fa-balance-scale"></i></div>
								<span class="footer_text"><?=$langs['game_fairness_label']?></span>
							</li>
							<?php if(false):?>
							<li class="left gameBar_li">
								<div class="footer_wrap"><i class="fas fa-keyboard"></i></div>
								<span class="footer_text"><?=$langs['game_hotkeys_label']?></span>
							</li>
							<?php endif?>
						</ul>
					</div>
					<div class="bets_nav" style="width: 192px">
						<ul class="clear">
							<li class="left li_active" id="show_my_bets"><?=$langs['MY_BETS']?></li>
							<li class="left" id="show_all_bets"><?=$langs['ALL_BETS']?></li>
							<?php if(false):?><li class="left"><?=$langs['HIGH_WINS']?></li><?php endif?>
						</ul>
					</div>
					<div style="width: calc(100% - 20px); margin-left: 10px; overflow-x: auto;" id="my_bets_table">
						<table class="table table-striped bets_table">
							<thead>
								<tr>
									<td><?=$langs['bet_tbl_time']?></td>
									<td><?=$langs['bet_tbl_game']?></td>
									<td><?=$langs['bet_tbl_bet_amount']?></td>
									<td><?=$langs['bet_tbl_multiplier']?></td>
									<td><?=$langs['bet_tbl_profit']?></td>
								</tr>
							</thead>
							<tbody></tbody>
						</table>
					</div>
					<div style="width: calc(100% - 20px); margin-left: 10px; overflow-x: auto; display: none" id="all_bets_table">
						<table class="table table-striped bets_table">
							<thead>
								<tr>
									<td><?=$langs['bet_tbl_time']?></td>
									<td><?=$langs['bet_tbl_game']?></td>
									<td><?=$langs['bet_tbl_user']?></td>
									<td><?=$langs['bet_tbl_bet_amount']?></td>
									<td><?=$langs['bet_tbl_multiplier']?></td>
									<td><?=$langs['bet_tbl_profit']?></td>
								</tr>
							</thead>
							<tbody></tbody>
						</table>
					</div>
			   </div>
			</div>
		</section>
		<?php include('footer.php');?>
		
		<?php
			function is_valid_json($string) {
				$string = str_replace('\\', '', $string);
				$string = trim($string);
				if (!in_array($string[0] ?? '', ['{', '[']) || !in_array($string[strlen($string) - 1] ?? '', ['}', ']'])) {
					return false;
				}
				json_decode($string, true);
				return json_last_error() === JSON_ERROR_NONE;
			}
		?>
		
		<script>
			var user_balance = <?=number_format($user_info->balance / 100000000, 8, '.', '')?>;
			const MIN_BET_AMOUNT = <?=$DICE_MIN_BET_AMOUNT?>;
			const MAX_BET_AMOUNT = <?=$MAX_BET_AMOUNT?>;
			const MIN_BET_INCREASE_PERCENT = <?=$MIN_BET_INCREASE_PERCENT?>;
			const MAX_BET_INCREASE_PERCENT = <?=$MAX_BET_INCREASE_PERCENT?>;
			const MIN_STOP_ON_PROFIT = <?=$MIN_STOP_ON_PROFIT?>;
			const MAX_STOP_ON_PROFIT = <?=$MAX_STOP_ON_PROFIT?>;
			
			const MAGIC_NUMBER = 9700;
			const MIN_MULTIPLIER = 1.01;
			const MAX_MULTIPLIER = MAGIC_NUMBER / 2;
			const MIN_WIN_CHANCE = (parseFloat(MAGIC_NUMBER / MAX_MULTIPLIER) / 100).toFixed(2);
			const MAX_WIN_CHANCE = (parseFloat(MAGIC_NUMBER / MIN_MULTIPLIER) / 100).toFixed(2);

			var auto_betting_status = 'stopped';
			var profit_loss = 0.00000000;
			var base_bet = 0.00000001;
			var bet_mode = 'manual';
			var bet_on = 'higher';
			var slide_btn_moving = false;
			//var hideMaker = null;
			var my_bet_data = [];
			var prepare_for_stopping = false;
			
			<!-- strategy bet -->
			var strategy_betting_status = 'stopped';
			var strategy_base_bet_amount = 0;
			var strategy_base_win_chance = 48.50;
			var strategy_bets = 0;
			var strategy_history = [];
			var strategy_profit_loss = 0.00000000;
			var strategies = [];
			var user_strategies = [];
			var default_strategies = [
				{'name' : 'Martingale', 'id' : 0, 'conditions' : [
					{
						'condition_option' : {'type': 'bet_condition', 'condition_term_option': 'every', 'condition_count_input': 1, 'condition_bet_type_option' : 'losses'},
						'condition_action' : {'condition_action_option': 'increase_bet_amount', 'condition_action_percentage_input': 100}
					
					},{
						'condition_option' : {'type': 'bet_condition', 'condition_term_option': 'every', 'condition_count_input': 1, 'condition_bet_type_option' : 'wins'},
						'condition_action' : {'condition_action_option': 'reset_bet_amount'}
					
					}
				]},
				{'name' : 'Delayed Martingale', 'id' : 1, 'conditions' : [
					{
						'condition_option' : {'type': 'bet_condition', 'condition_term_option': 'streak_greater_than', 'condition_count_input': 3, 'condition_bet_type_option' : 'losses'},
						'condition_action' : {'condition_action_option': 'increase_bet_amount', 'condition_action_percentage_input': 100}
					
					},{
						'condition_option' : {'type': 'bet_condition', 'condition_term_option': 'first_streak_of', 'condition_count_input': 3, 'condition_bet_type_option' : 'losses'},
						'condition_action' : {'condition_action_option': 'increase_bet_amount', 'condition_action_percentage_input': 100}
					
					},{
						'condition_option' : {'type': 'bet_condition', 'condition_term_option': 'every', 'condition_count_input': 1, 'condition_bet_type_option' : 'wins'},
						'condition_action' : {'condition_action_option': 'reset_bet_amount'}
					
					}
				]}, 
				{'name' : 'Paroli', 'id' : 2, 'conditions' : [
					{
						'condition_option' : {'type': 'bet_condition', 'condition_term_option': 'every', 'condition_count_input': 1, 'condition_bet_type_option' : 'wins'},
						'condition_action' : {'condition_action_option': 'increase_bet_amount', 'condition_action_percentage_input': 100}
					
					},{
						'condition_option' : {'type': 'bet_condition', 'condition_term_option': 'streak_greater_than', 'condition_count_input': 3, 'condition_bet_type_option' : 'wins'},
						'condition_action' : {'condition_action_option': 'reset_bet_amount'}
					
					},{
						'condition_option' : {'type': 'bet_condition', 'condition_term_option': 'every', 'condition_count_input': 1, 'condition_bet_type_option' : 'losses'},
						'condition_action' : {'condition_action_option': 'reset_bet_amount'}
					
					}
				]},
				{'name' : "D 'Alembert", 'id' : 3, 'conditions' : [
					{
						'condition_option' : {'type': 'bet_condition', 'condition_term_option': 'every', 'condition_count_input': 1, 'condition_bet_type_option' : 'wins'},
						'condition_action' : {'condition_action_option': 'add_to_bet_amount', 'condition_action_amount_input': 0.00000001}
					
					},{
						'condition_option' : {'type': 'bet_condition', 'condition_term_option': 'every', 'condition_count_input': 1, 'condition_bet_type_option' : 'losses'},
						'condition_action' : {'condition_action_option': 'subtract_from_bet_amount', 'condition_action_amount_input': 0.00000001}
					
					}
				]}
			];
			<!-- strategy bet -->
			
			
			<!-- strategy bet -->
			function switch_bet_mode(mode) {
				//bet_mode_label
				if(auto_betting_status == 'running' || strategy_betting_status == 'running') {
					return;
				}
				if(mode == 0) {
					$('#on_win_box').hide();
					$('#on_loss_box').hide();
					$('#stop_profit_box').hide();
					$('#total_profit_box').hide();
					$('#start_autobet').hide();
					$('#start_strategy_bet').hide();
					$('#roll_dice').show();
					$('#strategy_box').hide();
					$('#bet_mode_label').html('<?=$langs['switch_manual']?>');
					$('#strategy_profit_box').hide();
					bet_mode = 'manual';
				} else if(mode == 1) {
					$('#on_win_box').show();
					$('#on_loss_box').show();
					$('#stop_profit_box').show();
					$('#total_profit_box').show();
					$('#start_autobet').show();
					$('#start_strategy_bet').hide();
					$('#roll_dice').hide();
					$('#bet_mode_label').html('<?=$langs['switch_auto']?>');
					$('#strategy_box').hide();
					$('#strategy_profit_box').hide();
					bet_mode = 'auto';
				} else if(mode == 2){
					$('#on_win_box').hide();
					$('#on_loss_box').hide();
					$('#stop_profit_box').hide();
					$('#total_profit_box').hide();
					$('#start_autobet').hide();
					$('#roll_dice').hide();
					$('#start_strategy_bet').show();
					$('#strategy_box').show();
					$('#bet_mode_label').html('<?=$langs['switch_strategy']?>');
					$('#strategy_profit_box').show();
					setup_strategies();
					load_strategies();
					bet_mode = 'strategy';
				}
			}
			<!-- strategy bet -->
			

			function set_bet_double_amount() {
				if(auto_betting_status == 'running' || strategy_betting_status == 'running') {
					return;
				}				
				var bet_amount = parseFloat($('#bet_amount').val());
				bet_amount *= 2;
				if(bet_amount > Math.min(MAX_BET_AMOUNT, user_balance)) {
					bet_amount = Math.min(MAX_BET_AMOUNT, user_balance);
				}
				$('#bet_amount').val(bet_amount.toFixed(8));
				set_win_profit();
			}
			
			function set_bet_half_amount() {
				if(auto_betting_status == 'running' || strategy_betting_status == 'running') {
					return;
				}
				var bet_amount = parseFloat($('#bet_amount').val());
				bet_amount /= 2;
				if(bet_amount < MIN_BET_AMOUNT || isNaN(bet_amount)) {
					bet_amount = MIN_BET_AMOUNT;
				}
				$('#bet_amount').val(bet_amount.toFixed(8));
				set_win_profit();
			}
			
			function change_bet_amount() {
				var bet_amount = parseFloat($('#bet_amount').val());
				if(bet_amount < MIN_BET_AMOUNT || isNaN(bet_amount)) {
					bet_amount = MIN_BET_AMOUNT;
				}
				if(bet_amount > Math.min(MAX_BET_AMOUNT, user_balance)) {
					//bet_amount = Math.min(MAX_BET_AMOUNT, user_balance);
					 $('#bet_amount').parent().css('border', '2px solid #f44336');
				} else {
					 $('#bet_amount').parent().css('border', '1px solid #DDD');
				}
				$('#bet_amount').val(bet_amount.toFixed(8));
				set_win_profit();
			}
			
			function change_bet_amount2(bet_amount) {
				if(bet_amount < MIN_BET_AMOUNT || isNaN(bet_amount)) {
					strategy_betting_status = 'stopped';
					$.toast({
						heading: 'Strategy finished!',
						text: 'Invalid bet amount',
						showHideTransition: 'slide',
						position: 'top-right',
						icon: 'error'
					});
					return;
				}
				if(bet_amount > Math.min(MAX_BET_AMOUNT, user_balance)) {
					strategy_betting_status = 'stopped';
					$.toast({
						heading: 'Strategy finished!',
						text: 'Invalid bet amount',
						showHideTransition: 'slide',
						position: 'top-right',
						icon: 'error'
					});
					return;
				}
				$('#bet_amount').val(bet_amount.toFixed(8));
				set_win_profit();
			}
			
			function change_multiplier() {
				var multiplier = parseFloat($('#multiplier').val());
				if(multiplier < MIN_MULTIPLIER || isNaN(multiplier)) {
					multiplier = MIN_MULTIPLIER;
				}
				if(multiplier > MAX_MULTIPLIER) {
					multiplier = MAX_MULTIPLIER;
				}
				multiplier = parseFloat(MAGIC_NUMBER / (10000 - Math.round(10000 - (MAGIC_NUMBER /  multiplier))));
				var win_chance = (Math.round(MAGIC_NUMBER / multiplier) / 100);
				$('#multiplier').val(multiplier.toFixed(2));
				$('#win_chance').val(win_chance.toFixed(2));
				set_roll_to_win();
				set_slide_bar();
				set_win_profit();
			}

			function change_win_chance() {
				var win_chance = parseFloat($('#win_chance').val());
				if(win_chance < MIN_WIN_CHANCE || isNaN(win_chance)) {
					win_chance = MIN_WIN_CHANCE;
				}
				if(win_chance > MAX_WIN_CHANCE) {
					win_chance = MAX_WIN_CHANCE;
				}
				var multiplier = parseFloat(MAGIC_NUMBER / Math.round(win_chance * 100));
				win_chance = (Math.round(MAGIC_NUMBER / multiplier) / 100);
				$('#multiplier').val(multiplier.toFixed(2));
				$('#win_chance').val(win_chance.toFixed(2));
				set_roll_to_win();
				set_slide_bar();
				set_win_profit();
			}
			
			function change_win_chance2(win_chance) {
				if(win_chance < MIN_WIN_CHANCE || isNaN(win_chance)) {
					strategy_betting_status = 'stopped';
					$.toast({
						heading: 'Strategy finished!',
						text: 'Invalid win chance',
						showHideTransition: 'slide',
						position: 'top-right',
						icon: 'error'
					});
					return;
				}
				if(win_chance > MAX_WIN_CHANCE) {
					strategy_betting_status = 'stopped';
					$.toast({
						heading: 'Strategy finished!',
						text: 'Invalid win chance',
						showHideTransition: 'slide',
						position: 'top-right',
						icon: 'error'
					});
					return;
				}
				var multiplier = parseFloat(MAGIC_NUMBER / Math.round(win_chance * 100));
				$('#multiplier').val(multiplier.toFixed(2));
				win_chance = (Math.round(MAGIC_NUMBER / multiplier) / 100);
				$('#win_chance').val(win_chance.toFixed(2));
				set_roll_to_win();
				set_slide_bar();
				set_win_profit();
			}
			
			function set_win_profit() {
				var bet_amount = parseFloat($('#bet_amount').val());
				var multiplier = parseFloat($('#multiplier').val());
				var win_profit = (Math.floor(bet_amount * 100000000 * (multiplier - 1) + 0.0001) / 100000000).toFixed(8);
				$('#win_profit').val(win_profit);
			}
			
			function set_roll_to_win() {
				var multiplier = parseFloat($('#multiplier').val());
				var lt = (Math.round(MAGIC_NUMBER / multiplier) / 100);
				var gt = (100 - lt);
				if(bet_on == 'higher') {
					$('#roll_to_win').val(gt.toFixed(2));
				} else {
					$('#roll_to_win').val(lt.toFixed(2));
				}
			}
			
			function switch_bet_on() {
				if(auto_betting_status == 'running' || strategy_betting_status == 'running') {
					return;
				}
				if(bet_on == 'higher') {
					$('#roll_to_win_lb').text('<?=$langs['roll_under_to_win_label']?>');
					bet_on = 'lower';
				} else {
					$('#roll_to_win_lb').text('<?=$langs['roll_over_to_win_label']?>');
					bet_on = 'higher';
				}
				set_roll_to_win();
				set_slide_bar();
			}
			
			function set_slide_bar() {
				var multiplier = parseFloat($('#multiplier').val());
				var lt = (Math.round(MAGIC_NUMBER / multiplier) / 100).toFixed(2);
				var gt = (100 - lt).toFixed(2);
				var slider_bar = $(".game_main .slider .runway .slider_bar");
				var slider_button = $(".game_main .slider .runway .slider_button");
				if(bet_on == 'higher') {
					slider_bar.css('width', gt+'%');
					slider_button.css('left', 'calc('+gt+'% - 17px)');
					slider_bar.css('border-radius', '5px 0px 0px 5px');
					slider_bar.css('float', 'left');
				} else {
					slider_bar.css('width', gt+'%');
					slider_button.css('left', 'calc('+lt+'% - 17px)');
					slider_bar.css('border-radius', '0px 5px 5px 0px');
					slider_bar.css('float', 'right');
				}
			}
			
			function start_moving_slide_btn() {
				slide_btn_moving = true;
			}
			
			function stop_moving_slide_btn() {
				slide_btn_moving = false;
			}
			
			function move_slide_btn(e, device = 'Mobile') {
				if(auto_betting_status == 'running' || strategy_betting_status == 'running') {
					return;
				}
				if(device == 'Mobile' || slide_btn_moving) {
					var min_gt = (Math.round(10000 - (MAGIC_NUMBER / MIN_MULTIPLIER)) / 100).toFixed(2);
					var max_gt = (Math.round(10000 - (MAGIC_NUMBER / MAX_MULTIPLIER)) / 100).toFixed(2);
					var min_lt = (Math.round(MAGIC_NUMBER / MAX_MULTIPLIER) / 100).toFixed(2);
					var max_lt = (Math.round(MAGIC_NUMBER / MIN_MULTIPLIER) / 100).toFixed(2);
					var slider = $(".game_main .slider .runway");
					var slider_button = $(".game_main .slider .runway .slider_button");
					var slider_bar = $(".game_main .slider .runway .slider_bar");
					var gt = 0;
					var lt = 0;
					var multiplier = 0;
					var win_chance = 0;
					if(bet_on == 'higher') {
						if(device == 'Mobile') {
							gt = ((e.originalEvent.touches[0].pageX - slider.offset().left) / slider.width() * 100).toFixed(2);
						} else {
							gt = ((e.pageX - slider.offset().left) / slider.width() * 100).toFixed(2);
						}
						gt = Math.min(Math.max(gt, min_gt), max_gt);
						lt = (100 - gt).toFixed(2);
						
						slider_bar.css('width', gt+'%');
						slider_button.css('left', 'calc('+gt+'% - 17px)');
					} else {
						if(device == 'Mobile') {
							lt = ((e.originalEvent.touches[0].pageX - slider.offset().left) / slider.width() * 100).toFixed(2);
						} else {
							lt = ((e.pageX - slider.offset().left) / slider.width() * 100).toFixed(2);
						}
						lt = Math.min(Math.max(lt, min_lt), max_lt);
						gt = (100 - lt).toFixed(2);
						slider_bar.css('width', gt+'%');
						slider_button.css('left', 'calc('+lt+'% - 17px)');
					}
					multiplier = (MAGIC_NUMBER / lt / 100).toFixed(2); 
					win_chance = lt;
					$('#multiplier').val(multiplier);
					$('#win_chance').val(win_chance);
					set_roll_to_win();
					set_win_profit();
				}
				
			}
			
			function process_bet_game_dice() {
				if(auto_betting_status == 'running' || strategy_betting_status == 'running') {
					return;
				}
				var bet_amount = parseFloat($('#bet_amount').val());
				var multiplier = parseFloat($('#multiplier').val());
				$('#roll_dice span').hide();
				$('#roll_dice img').show();
				$("#roll_dice").attr("disabled", !0);
				disable_all_inputs();
				auto_betting_status = 'running';
				setTimeout(function() {
					$.ajax({
						url: "<?=base_url()?>process.php",
						type: "POST",
						data: "action=bet_game_dice&bet_amount="+bet_amount+"&payout="+multiplier+"&bet_on="+bet_on,
						error: function(){
							$.toast({
								heading: 'Error!',
								text: 'Request timed out. Please try again!',
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});
							$('#roll_dice span').show();
							$('#roll_dice img').hide();
							$("#roll_dice").attr("disabled", false);
							enable_all_inputs();
							auto_betting_status = 'stopped';
						},
						success: function(out){
							obj = JSON.parse(out);
							if(obj.ret == 0) {
								$.toast({
									heading: 'Error!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'error'
								});
								$('#roll_dice span').show();
								$('#roll_dice img').hide();
								$("#roll_dice").attr("disabled", false);
								enable_all_inputs();
								auto_betting_status = 'stopped';
							} else {
								if(obj.amount >= 0 && $("#game_dice .result_maker").hasClass('negative')) {
									$("#game_dice .result_maker").removeClass('negative');
								} 
								if(obj.amount < 0 && !$(".result_maker").hasClass('negative')) {
									$(".result_maker").addClass('negative');
								}
								//if(hideMaker != null) clearTimeout(hideMaker);
								$("#game_dice .result_maker").show();
								$('#game_dice .result_maker span').html(obj.num);
								$('#game_dice .result_maker').css('left', 'calc('+parseFloat(obj.num)+'% - 30px)');
								$('.user_balance').text(parseFloat((parseInt(obj.balance)) / 100000000).toFixed(8));
								user_balance = parseFloat((parseInt(obj.balance)) / 100000000).toFixed(8);						
								if(Array.isArray(my_bet_data)) {
									my_bet_data.unshift(obj.bet_data);
								} else {
									my_bet_data = [obj.bet_data];
								}
								if (Array.isArray(my_bet_data) && my_bet_data.length > 20) {
									my_bet_data = my_bet_data.slice(0, 20);
								}
								store_bet_data(my_bet_data);
								show_my_bet_data(my_bet_data);
								/*hideMaker = setTimeout(function(){
									$(".result_maker").fadeOut();
								}, 2000);*/
								$('#roll_dice span').show();
								$('#roll_dice img').hide();
							}
							$("#roll_dice").attr("disabled", false);
							enable_all_inputs();
							auto_betting_status = 'stopped';
						}
					});
				}, 100);
			}

			function change_on_win() {
				if($('#increase_onwin').is(':checked')) {
					$('#increase_onwin_by').prop('disabled', false);
					$('#increase_onwin_by').parent().removeClass('disabled');
				} else {
					$('#increase_onwin_by').prop('disabled', true);
					$('#increase_onwin_by').parent().addClass('disabled');
				}
			}

			function change_on_loss() {
				if($('#increase_onloss').is(':checked')) {
					$('#increase_onloss_by').prop('disabled', false);
					$('#increase_onloss_by').parent().removeClass('disabled');
				} else {
					$('#increase_onloss_by').prop('disabled', true);
					$('#increase_onloss_by').parent().addClass('disabled');
				}
			}
			
			function change_increase_onwin_by() {
				var increase_onwin_by = parseInt($('#increase_onwin_by').val());
				if(increase_onwin_by < MIN_BET_INCREASE_PERCENT || isNaN(increase_onwin_by)) {
					increase_onwin_by = MIN_BET_INCREASE_PERCENT;
				} else if(increase_onwin_by > MAX_BET_INCREASE_PERCENT) {
					increase_onwin_by = MAX_BET_INCREASE_PERCENT;
				}
				$('#increase_onwin_by').val(increase_onwin_by);
			}
			
			function change_increase_onloss_by() {
				var increase_onloss_by = parseInt($('#increase_onloss_by').val());
				if(increase_onloss_by < MIN_BET_INCREASE_PERCENT || isNaN(increase_onloss_by)) {
					increase_onloss_by = MIN_BET_INCREASE_PERCENT;
				} else if(increase_onloss_by > MAX_BET_INCREASE_PERCENT) {
					increase_onloss_by = MAX_BET_INCREASE_PERCENT;
				}
				$('#increase_onloss_by').val(increase_onloss_by);
			}

			function change_stop_on_profit() {
				var stop_on_profit = parseFloat($('#stop_on_profit').val());
				if(stop_on_profit < MIN_STOP_ON_PROFIT || isNaN(stop_on_profit)) {
					stop_on_profit = MIN_STOP_ON_PROFIT;
				} else if(stop_on_profit > MAX_STOP_ON_PROFIT) {
					stop_on_profit = MAX_STOP_ON_PROFIT;
				}
				$('#stop_on_profit').val(stop_on_profit.toFixed(8));
			}

			function change_stop_on_loss() {
				var stop_on_loss = parseFloat($('#stop_on_loss').val());
				if(stop_on_loss < MIN_STOP_ON_PROFIT || isNaN(stop_on_loss)) {
					stop_on_loss = MIN_STOP_ON_PROFIT;
				} else if(stop_on_loss > MAX_STOP_ON_PROFIT) {
					stop_on_loss = MAX_STOP_ON_PROFIT;
				}
				$('#stop_on_loss').val(stop_on_loss.toFixed(8));
			}
			
			function disable_all_inputs() {
				$('#auto_dice').prop('disabled', true);
				$('#bet_amount').prop('disabled', true);
				$('#bet_amount').parent().addClass('disabled');
				$('#win_profit').prop('disabled', true);
				$('#win_profit').parent().addClass('disabled');
				$('#roll_to_win').prop('disabled', true);
				$('#roll_to_win').parent().addClass('disabled');
				$('#multiplier').prop('disabled', true);
				$('#multiplier').parent().addClass('disabled');
				$('#win_chance').prop('disabled', true);
				$('#win_chance').parent().addClass('disabled');
				$('#reset_onwin').prop('disabled', true);
				$('#increase_onwin').prop('disabled', true);
				$('#increase_onwin_by').prop('disabled', true);
				$('#increase_onwin_by').parent().addClass('disabled');
				$('#reset_onloss').prop('disabled', true);
				$('#increase_onloss').prop('disabled', true);
				$('#increase_onloss_by').prop('disabled', true);
				$('#increase_onloss_by').parent().addClass('disabled');	
				$('#stop_on_profit').prop('disabled', true);
				$('#stop_on_profit').parent().addClass('disabled');
				$('#stop_on_loss').prop('disabled', true);
				$('#stop_on_loss').parent().addClass('disabled');
				$('#number_rolls').prop('disabled', true);
				$('#number_rolls').parent().addClass('disabled');
				$('#profit_loss').prop('disabled', true);
				$('#profit_loss').parent().addClass('disabled');
				<!-- strategy bet -->
				$('#switch_bet_mode .jtoggler-radio').prop('disabled', true);
				$('#strategies').prop('disabled', true);
				$('#strategy_bets').prop('disabled', true);
				$('#strategy_bets').parent().addClass('disabled');
				$('#strategy_profit_loss').prop('disabled', true);
				$('#strategy_profit_loss').parent().addClass('disabled');
				<!-- strategy bet -->
			}
			
			function enable_all_inputs() {
				$('#auto_dice').prop('disabled', false);
				$('#bet_amount').prop('disabled', false);
				$('#bet_amount').parent().removeClass('disabled');
				$('#win_profit').prop('disabled', false);
				$('#win_profit').parent().removeClass('disabled');
				$('#roll_to_win').prop('disabled', false);
				$('#roll_to_win').parent().removeClass('disabled');
				$('#multiplier').prop('disabled', false);
				$('#multiplier').parent().removeClass('disabled');
				$('#win_chance').prop('disabled', false);
				$('#win_chance').parent().removeClass('disabled');
				$('#reset_onwin').prop('disabled', false);
				$('#increase_onwin').prop('disabled', false);
				if($('#increase_onwin').is(':checked')) {
					$('#increase_onwin_by').prop('disabled', false);
					$('#increase_onwin_by').parent().removeClass('disabled');
				}
				$('#reset_onloss').prop('disabled', false);
				$('#increase_onloss').prop('disabled', false);
				if($('#increase_onloss').is(':checked')) {
					$('#increase_onloss_by').prop('disabled', false);
					$('#increase_onloss_by').parent().removeClass('disabled');
				} 
				$('#stop_on_profit').prop('disabled', false);
				$('#stop_on_profit').parent().removeClass('disabled');
				$('#stop_on_loss').prop('disabled', false);
				$('#stop_on_loss').parent().removeClass('disabled');
				$('#number_rolls').prop('disabled', false);
				$('#number_rolls').parent().removeClass('disabled');
				$('#profit_loss').prop('disabled', false);
				$('#profit_loss').parent().removeClass('disabled');
				<!-- strategy bet -->
				$('#switch_bet_mode .jtoggler-radio').prop('disabled', false);
				$('#strategies').prop('disabled', false);
				$('#strategy_bets').prop('disabled', false);
				$('#strategy_bets').parent().removeClass('disabled');
				$('#strategy_profit_loss').prop('disabled', false);
				$('#strategy_profit_loss').parent().removeClass('disabled');
				<!-- strategy bet -->
			}
			
			function process_auto_bet_game_dice() {
				if(auto_betting_status != 'running') {
					return;
				}
				var bet_amount = parseFloat($('#bet_amount').val());
				var multiplier = parseFloat($('#multiplier').val());
				var on_win = null;
				var increase_onwin_by = 0;
				var on_loss = null;
				var increase_onloss_by = 0;
				var stop_on_profit = 0;
				var stop_on_loss = 0;
				var number_rolls = parseInt($('#number_rolls').val());
				if($('#increase_onwin').is(':checked')) {
					on_win = 'increase_onwin';
					increase_onwin_by = parseInt($('#increase_onwin_by').val());
				} else {
					on_win = 'reset_onwin';
				}
				if($('#increase_onloss').is(':checked')) {
					on_loss = 'increase_onloss';
					increase_onloss_by = parseInt($('#increase_onloss_by').val());
				} else {
					on_loss = 'reset_onloss';
				}
				stop_on_profit = parseFloat($('#stop_on_profit').val());
				stop_on_loss = parseFloat($('#stop_on_loss').val());
				
				setTimeout(function() {
					$.ajax({
						url: "<?=base_url()?>process.php",
						type: "POST",
						data: "action=bet_game_dice&bet_amount="+bet_amount+"&payout="+multiplier+"&bet_on="+bet_on,
						error: function(){
							$.toast({
								heading: 'Error!',
								text: 'Request timed out. Please try again!',
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});
							stop_auto_bet();
						},
						success: function(out){
							obj = JSON.parse(out);
							if(obj.ret == 0) {
								$.toast({
									heading: 'Error!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'error'
								});
								stop_auto_bet();
							} else {
								if(obj.amount >= 0 && $("#game_dice .result_maker").hasClass('negative')) {
									$("#game_dice .result_maker").removeClass('negative');
								} 
								if(obj.amount < 0 && !$("#game_dice .result_maker").hasClass('negative')) {
									$("#game_dice .result_maker").addClass('negative');
								} 
								profit_loss = parseFloat((profit_loss * 100000000 +  parseInt(obj.amount)) / 100000000).toFixed(8);
								$('#profit_loss').val(profit_loss);
								
								if(profit_loss > 0) {
									$('#profit_loss').css('color', '#03a9f4');
								} else if(profit_loss < 0) {
									$('#profit_loss').css('color', '#e91e63');
								} else {
									$('#profit_loss').css('color', '#333');
								}
								//if(hideMaker != null) clearTimeout(hideMaker);
								$("#game_dice .result_maker").show();
								$('#game_dice .result_maker span').html(obj.num);
								$('#game_dice .result_maker').css('left', 'calc('+parseFloat(obj.num)+'% - 30px)');
								$('.user_balance').text(parseFloat((parseInt(obj.balance)) / 100000000).toFixed(8));
								user_balance = parseFloat((parseInt(obj.balance)) / 100000000).toFixed(8);
								/*hideMaker = setTimeout(function(){
									$(".result_maker").fadeOut();
								}, 2000);*/
								if(obj.amount >= 0) {
									if(on_win == 'reset_onwin') {
										bet_amount = base_bet;
									} else if(on_win == 'increase_onwin') {
										bet_amount =  parseFloat(bet_amount * (1 + increase_onwin_by / 100));
									}
								} else {
									if(on_loss == 'reset_onloss') {
										bet_amount = base_bet;
									} else if(on_loss == 'increase_onloss') {
										bet_amount =  parseFloat(bet_amount * (1 + increase_onloss_by / 100));
									}
								}
								$('#bet_amount').val(bet_amount.toFixed(8));
								$('#number_rolls').val(number_rolls+1);
								if(Array.isArray(my_bet_data)) {
									my_bet_data.unshift(obj.bet_data);
								} else {
									my_bet_data = [obj.bet_data];
								}
								if (Array.isArray(my_bet_data) && my_bet_data.length > 20) {
									my_bet_data = my_bet_data.slice(0, 20);
								}
								store_bet_data(my_bet_data);
								show_my_bet_data(my_bet_data);
								if((stop_on_profit > 0 && profit_loss >= stop_on_profit) 
								|| (stop_on_loss > 0 && profit_loss <= -stop_on_loss)) {
									stop_auto_bet();
								} else {
									process_auto_bet_game_dice();
								}
							}
						}
					});
				}, 300);
			}
			
			function start_auto_bet() {
				$('#start_autobet').hide();
				$('#stop_autobet').show();
				$('#number_rolls').val(0);
				auto_betting_status = 'running';
				profit_loss = 0.00000000;
				base_bet = parseFloat($('#bet_amount').val());
				$('#profit_loss').val(profit_loss.toFixed(8));
				$('#profit_loss').css('color', '#333');
				disable_all_inputs();
				process_auto_bet_game_dice();
			}
			
			function stop_auto_bet() {
				auto_betting_status = 'stopped';
				enable_all_inputs();
				$('#stop_autobet').hide();
				$('#start_autobet').show();
			}
			
			function game_dice_key_down(e) {
				if(e.key == 'w' && auto_betting_status == 'stopped') {
					e.preventDefault();
					set_bet_double_amount();
				} else if(e.key == 's' && auto_betting_status == 'stopped') {
					e.preventDefault();
					set_bet_half_amount();
				} else if(e.key == 'a' && bet_mode == 'manual') {
					e.preventDefault();
					process_bet_game_dice('higher');
				} else if (e.key == 'd' && bet_mode == 'manual') {
					e.preventDefault();
					process_bet_game_dice('lower');
				} else if(e.keyCode == 32 && bet_mode == 'auto' && auto_betting_status == 'stopped') {
					e.preventDefault();
					start_auto_bet();
				} else if (e.keyCode == 32 && bet_mode == 'auto' && auto_betting_status == 'running') {	
					e.preventDefault();
					stop_auto_bet();
				}
			}
			
			$(document).ready(function() {
				change_multiplier();
				<!-- strategy bet -->
				//$("#auto_dice").on("change", switch_bet_mode);
				<!-- strategy bet -->
				$("#bet_double").on("click", set_bet_double_amount);
				$("#bet_half").on("click", set_bet_half_amount);
				$("#bet_amount").on("change", change_bet_amount);
				$("#multiplier").on("change", change_multiplier);
				$("#win_chance").on("change", change_win_chance);
				$("#bet_on_lower_btn").on("click", function(){process_bet_game_dice()});
				$("#roll_dice").on("click", process_bet_game_dice);
				$("#start_autobet").on("click", start_auto_bet);
				$("#stop_autobet").on("click", stop_auto_bet);
				$("input[type=radio][name=onwin]").on("change", change_on_win);
				$("input[type=radio][name=onloss]").on("change", change_on_loss);
				$("#increase_onwin_by").on("change", change_increase_onwin_by);
				$("#increase_onloss_by").on("change", change_increase_onloss_by);
				$("#stop_on_profit").on("change", change_stop_on_profit);
				$("#stop_on_loss").on("change", change_stop_on_loss);
				$(".game_main .slider .runway .slider_button").on("mousedown", start_moving_slide_btn);
				$(document).on("mouseup", stop_moving_slide_btn);
				$(document).mousemove(function(e) {move_slide_btn(e, 'PC');});
				$(".game_main .slider .runway .slider_button").on("touchmove", function(e) {move_slide_btn(e, 'Mobile');});
				
				show_my_bets(my_bet_data);
				$('#show_my_bets').on('click', function(){show_my_bets(my_bet_data);});
				$('#show_all_bets').on('click', show_all_bets);
				
			});
		</script>
		
		<script>
		<!-- strategy bet -->
		$(function(){
			$('.jtoggler').jtoggler();
		});
		$(document).on('jt:toggled:multi', function (event, target) {
			var mode = $(target).parent().index();
			switch_bet_mode(mode);
		});
		
		function show_strategy_dialog(strategy) {
			if(strategy_betting_status =='running') {
				return;
			}
			var name = strategy['name'];
			var strategy_id = strategy['id'];
			var conditions = strategy['conditions'];
			var html = '';
			html += '<div class="input_group" style="width: calc(100% + 20px); margin-left: -10px; margin-right: -10px; margin-top: 0px; height: 40px">';
			html += '<input type="text" style="padding: 10px; height: 38px; width: 100%" id="strategy_name" value="'+name+'" placeholder="<?=$langs['strategy_name']?>">';
			html += '<input type="hidden" style="padding: 10px; height: 38px; width: 100%" id="strategy_id" value="'+strategy_id+'">';
			html += '</div>';
			if(strategy_id >= default_strategies.length && strategy_id < strategies.length) {
				html += '<div class="row"><div class="input_label delete_strategy_wrap"><div class="checkbox icheck-info"><input type="checkbox" id="confirm_delete_strategy"><label for="confirm_delete_strategy">Delete strategy</label></div></div></div>';
			}
			html += '<div id="strategy_conditions">';
			if(conditions.length <= 0) {
				html += '<div class="strategy_condition_block_title">Condition 1</div>';
				html += '<div class="row strategy_condition_block" id="strategy_condition_block1">';
				html += '<div class="col-xs-12">';
				html += '<div class="input_container">';
				html += '<div class="row">';
				html += '<div class="condition_type">';
				html += '<div class="radio icheck-success">';
				html += '<input type="radio" class="switch_condition_type" id="bet_condition1" name="condition_type1" condition_id="1" checked="checked">';
				html += '<label for="bet_condition1"><?=$langs['strategy_bet_condition_label']?></label>';
				html += '</div>';
				html += '<div class="radio icheck-success" style="margin-left: 15px">';
				html += '<input type="radio" class="switch_condition_type" id="profit_condition1" name="condition_type1" condition_id="1">';
				html += '<label for="profit_condition1"><?=$langs['strategy_profit_condition_label']?></label>';
				html += '</div>';
				html += '</div>';
				html += '<div class="bet_condition_wrap" id="bet_condition_wrap1">';
				html += '<div class="col-xs-12"><div class="input_label"><?=$langs['strategy_on_condition_label']?></div></div>';
				html += '<div class="col-xs-4"><div class="input_group"><select id="condition_term_options1" class="condition_term_options"><option value="every"><?=$langs['every_option']?></option><option value="every_streak_of"><?=$langs['every_streak_of_option']?></option><option value="first_streak_of"><?=$langs['first_streak_of_option']?></option><option value="streak_greater_than"><?=$langs['streak_greater_than_option']?></option><option value="streak_lower_than"><?=$langs['streak_lower_than_option']?></option></select></div></div>';
				html += '<div class="col-xs-4"><div class="input_group"><input type="text" class="condition_count_input" id="condition_count_input1" value="0"></div></div>';
				html += '<div class="col-xs-4"><div class="input_group"><select id="condition_bet_type_options1" class="condition_bet_type_options"><option value="bets"><?=$langs['num_bets_option']?></option><option value="wins"><?=$langs['num_wins_option']?></option><option value="losses"><?=$langs['num_losses_option']?></option></select></div></div>';
				html += '</div>';
				html += '<div class="profit_condition_wrap" id="profit_condition_wrap1">';
				html += '<div class="col-xs-12"><div class="input_label"><?=$langs['strategy_on_condition_label']?></div></div>';
				html += '<div class="col-sm-4 col-xs-6"><div class="input_group"><select id="condition_profit_type1" class="condition_profit_type"><option value="balance"><?=$langs['strategy_balance_option']?></option><option value="profit"><?=$langs['strategy_win_amount_option']?></option><option value="loss"><?=$langs['strategy_loss_amount_option']?></option></select></div></div>';
				html += '<div class="col-sm-4 col-xs-6"><div class="input_group"><select id="condition_profit_term_type_options1" class="condition_profit_term_type_options"><option value="greater_than"><?=$langs['greater_than_option']?></option><option value="greater_than_or_equal_to"><?=$langs['greater_than_or_equal_option']?></option><option value="lower_than"><?=$langs['lower_than_option']?></option><option value="lower_than_or_equal_to"><?=$langs['lower_than_or_equal_option']?></option></select></div></div>';
				html += '<div class="col-sm-4 col-xs-12"><div class="input_group"><img src="<?=base_url()?>assets/img/bnb.svg" style="width:20px;height:20px; margin-left: 5px"><input style="width: calc(100% - 25px);" type="text" class="condition_profit_amount_input" id="condition_profit_amount_input1" value="'+(0).toFixed(8)+'"></div></div>';
				html += '</div>';
				html += '<div class="do_action_wrap">';
				html += '<div class="col-xs-12"><div class="input_label"><?=$langs['strategy_do_action_label']?></div></div>';
				html += '<div class="col-xs-6"><div class="input_group"><select class="condition_action_options" id="condition_action_options1" condition_id="1"><option value="increase_bet_amount"><?=$langs['increase_bet_amount_action']?></option><option value="decrease_bet_amount"><?=$langs['decrease_bet_amount_action']?></option><option value="increase_win_chance"><?=$langs['increase_bet_win_chance_action']?></option><option value="decrease_win_chance"><?=$langs['decrease_bet_win_chance_action']?></option><option value="add_to_bet_amount"><?=$langs['add_to_bet_amount_action']?></option><option value="subtract_from_bet_amount"><?=$langs['subtract_from_bet_amount_action']?></option><option value="add_to_win_chance"><?=$langs['add_to_win_chance_action']?></option><option value="subtract_from_win_chance"><?=$langs['subtract_from_win_chance_action']?></option><option value="set_bet_amount"><?=$langs['set_bet_amount_action']?></option><option value="set_win_chance"><?=$langs['set_win_chance_action']?></option><option value="switch_over_under"><?=$langs['switch_over_under_action']?></option><option value="reset_bet_amount"><?=$langs['reset_bet_amount_action']?></option><option value="reset_win_chance"><?=$langs['reset_win_chance_action']?></option><option value="stop_auto_bet"><?=$langs['stop_auto_action']?></option></select></div></div>';
				html += '<div class="col-xs-6"><div class="input_group" style="display: none"><img src="<?=base_url()?>assets/img/bnb.svg" style="width:20px;height:20px; margin-left: 5px"><input style="width: calc(100% - 25px); padding: 0px; padding-left: 5px" type="text" class="condition_action_amount_input" id="condition_action_amount_input1" value="'+(0).toFixed(8)+'"></div></div>';
				html += '<div class="col-xs-6"><div class="input_group"><input style="width: calc(100% - 20px)" type="text" class="condition_action_percentage_input" id="condition_action_percentage_input1" value="0"><i style="font-size:12px; color: #8bc34a" class="fas fa-percent addon"></i></div></div>';
				html += '</div>';
				html += '</div>';
				html += '</div>';
				html += '</div>';
				html += '<div class="row" style="padding: 0px 10px; margin-top: 10px"><div class="btn add_condition_block_btn"><i class="fas fa-plus"></i> <?=$langs['add_condition_btn']?></div></div>';
				html += '</div>';
			} else {
				for(let i = 1; i <= conditions.length; i++) {
					html += '<div class="strategy_condition_block_title"><?=$langs['strategy_condition_label']?> '+i+'</div>';
					html += '<div class="row strategy_condition_block" id="strategy_condition_block'+i+'">';
					html += '<div class="col-xs-12">';
					html += '<div class="input_container">';
					html += '<div class="row">';
					html += '<div class="condition_type">';
					html += '<div class="radio icheck-success">';
					html += '<input type="radio" class="switch_condition_type" id="bet_condition'+i+'" name="condition_type'+i+'" condition_id="'+i+'" checked="checked">';
					html += '<label for="bet_condition'+i+'"><?=$langs['strategy_bet_condition_label']?></label>';
					html += '</div>';
					html += '<div class="radio icheck-success" style="margin-left: 15px">';
					html += '<input type="radio" class="switch_condition_type" id="profit_condition'+i+'" name="condition_type'+i+'" condition_id="'+i+'">';
					html += '<label for="profit_condition'+i+'"><?=$langs['strategy_profit_condition_label']?></label>';
					html += '</div>';
					html += '</div>';
					html += '<div class="bet_condition_wrap" id="bet_condition_wrap'+i+'">';
					html += '<div class="col-xs-12"><div class="input_label"><?=$langs['strategy_on_condition_label']?></div></div>';
					html += '<div class="col-xs-4"><div class="input_group"><select class="condition_term_options" id="condition_term_options'+i+'"><option value="every"><?=$langs['every_option']?></option><option value="every_streak_of"><?=$langs['every_streak_of_option']?></option><option value="first_streak_of"><?=$langs['first_streak_of_option']?></option><option value="streak_greater_than"><?=$langs['streak_greater_than_option']?></option><option value="streak_lower_than"><?=$langs['streak_lower_than_option']?></option></select></div></div>';
					html += '<div class="col-xs-4"><div class="input_group"><input type="text" class="condition_count_input" id="condition_count_input'+i+'" value="0"></div></div>';
					html += '<div class="col-xs-4"><div class="input_group"><select class="condition_bet_type_options" id="condition_bet_type_options'+i+'"><option value="bets"><?=$langs['num_bets_option']?></option><option value="wins"><?=$langs['num_wins_option']?></option><option value="losses"><?=$langs['num_losses_option']?></option></select></div></div>';
					html += '</div>';
					html += '<div class="profit_condition_wrap" id="profit_condition_wrap'+i+'">';
					html += '<div class="col-xs-12"><div class="input_label"><?=$langs['strategy_on_condition_label']?></div></div>';
					html += '<div class="col-sm-4 col-xs-6"><div class="input_group"><select class="condition_profit_type" id="condition_profit_type'+i+'"><option value="balance"><?=$langs['strategy_balance_option']?></option><option value="profit"><?=$langs['strategy_win_amount_option']?></option><option value="loss"><?=$langs['strategy_loss_amount_option']?></option></select></div></div>';
					html += '<div class="col-sm-4 col-xs-6"><div class="input_group"><select class="condition_profit_term_type_options" id="condition_profit_term_type_options'+i+'"><option value="greater_than"><?=$langs['greater_than_option']?></option><option value="greater_than_or_equal_to"><?=$langs['greater_than_or_equal_option']?></option><option value="lower_than"><?=$langs['lower_than_option']?></option><option value="lower_than_or_equal_to"><?=$langs['lower_than_or_equal_option']?></option></select></div></div>';
					html += '<div class="col-sm-4 col-xs-12"><div class="input_group"><img src="<?=base_url()?>assets/img/bnb.svg" style="width:20px;height:20px; margin-left: 5px"><input style="width: calc(100% - 25px)" type="text" class="condition_profit_amount_input" id="condition_profit_amount_input'+i+'" value="'+(0).toFixed(8)+'"></div></div>';
					html += '</div>';
					html += '<div class="do_action_wrap">';
					html += '<div class="col-xs-12"><div class="input_label"><?=$langs['strategy_do_action_label']?></div></div>';
					html += '<div class="col-xs-6"><div class="input_group"><select class="condition_action_options" id="condition_action_options'+i+'" condition_id="'+i+'"><option value="increase_bet_amount"><?=$langs['increase_bet_amount_action']?></option><option value="decrease_bet_amount"><?=$langs['decrease_bet_amount_action']?></option><option value="increase_win_chance"><?=$langs['increase_bet_win_chance_action']?></option><option value="decrease_win_chance"><?=$langs['decrease_bet_win_chance_action']?></option><option value="add_to_bet_amount"><?=$langs['add_to_bet_amount_action']?></option><option value="subtract_from_bet_amount"><?=$langs['subtract_from_bet_amount_action']?></option><option value="add_to_win_chance"><?=$langs['add_to_win_chance_action']?></option><option value="subtract_from_win_chance"><?=$langs['subtract_from_win_chance_action']?></option><option value="set_bet_amount"><?=$langs['set_bet_amount_action']?></option><option value="set_win_chance"><?=$langs['set_win_chance_action']?></option><option value="switch_over_under"><?=$langs['switch_over_under_action']?></option><option value="reset_bet_amount"><?=$langs['reset_bet_amount_action']?></option><option value="reset_win_chance"><?=$langs['reset_win_chance_action']?></option><option value="stop_auto_bet"><?=$langs['stop_auto_action']?></option></select></div></div>';
					html += '<div class="col-xs-6"><div class="input_group" style="display: none"><img src="<?=base_url()?>assets/img/bnb.svg" style="width:20px;height:20px; margin-left: 5px"><input style="width: calc(100% - 25px)" type="text" class="condition_action_amount_input" id="condition_action_amount_input'+i+'" value="'+(0).toFixed(8)+'"></div></div>';
					html += '<div class="col-xs-6"><div class="input_group"><input style="width: calc(100% - 20px)" type="text" class="condition_action_percentage_input" id="condition_action_percentage_input'+i+'" value="0"><i style="font-size:12px; color: #8bc34a" class="fas fa-percent addon"></i></div></div>';
					html += '</div>';
					html += '</div>';
					html += '</div>';
					html += '</div>';
					html += '<div class="row" style="padding: 0px 10px;">';
					if(conditions.length >= 2) {
						html += '<div style="padding: 0px"><div class="btn delete_condition_block_btn" block_id="'+i+'"><i class="fas fa-trash-alt"></i> <?=$langs['delete_condition_btn']?></div></div>';
					}
					if(i == conditions.length) {
						html += '<div class="btn add_condition_block_btn"><i class="fas fa-plus"></i> <?=$langs['add_condition_btn']?></div>';
					}
					html += '</div>';
					html += '</div>';
				}
			}
			html += '</div>';
			html += '<div class="save_strategy_btn btn"><i class="fas fa-save"></i> <?=$langs['save_strategy_btn']?></div>';
			html += '<div class="delete_strategy_btn btn"><i class="fas fa-trash-alt"></i> <?=$langs['delete_strategy_btn']?></div>';
			
			if(strategy_id < default_strategies.length) {
				show_modal('<i class="fas fa-eye"></i> <?=$langs['show_strategy_label']?>', html);
			} else if(strategy_id == strategies.length){
				show_modal('<i class="fas fa-plus-circle"></i> <?=$langs['create_strategy_label']?>', html);
			} else {
				show_modal('<i class="fas fa-pencil-alt"></i> <?=$langs['edit_strategy_label']?>', html);
			}
			if(strategy_id < default_strategies.length) {
				$('#strategy_name').attr("disabled", !0);
				$('.condition_term_options').attr("disabled", !0);
				$('.condition_count_input').attr("disabled", !0);
				$('.condition_bet_type_options').attr("disabled", !0);
				$('.condition_action_options').attr("disabled", !0);
				$('.condition_action_percentage_input').attr("disabled", !0);
				$('.condition_action_amount_input').attr("disabled", !0);
				$('.condition_profit_type').attr("disabled", !0);
				$('.condition_profit_term_type_options').attr("disabled", !0);
				$('.condition_profit_amount_input').attr("disabled", !0);
				$('.delete_condition_block_btn').attr("disabled", !0);
				$('.add_condition_block_btn').attr("disabled", !0);
				$('.save_strategy_btn').attr("disabled", !0);
				$('.switch_condition_type').attr("disabled", !0);
			}
			for(let i = 1; i <= conditions.length; i++) {
				if(conditions[i-1].condition_option.type == 'bet_condition') {
					$('#bet_condition'+i).attr('checked', true);
					$('#condition_term_options'+i).val(conditions[i-1].condition_option.condition_term_option);
					$('#condition_count_input'+i).val(conditions[i-1].condition_option.condition_count_input);
					$('#condition_bet_type_options'+i).val(conditions[i-1].condition_option.condition_bet_type_option);
					$('#bet_condition_wrap'+i).show();
					$('#profit_condition_wrap'+i).hide();
				} else {
					$('#profit_condition'+i).attr('checked', true);
					$('#condition_profit_type'+i).val(conditions[i-1].condition_option.condition_profit_type);
					$('#condition_profit_amount_input'+i).val(conditions[i-1].condition_option.condition_profit_amount_input.toFixed(8));
					$('#condition_profit_term_type_options'+i).val(conditions[i-1].condition_option.condition_profit_term_type_option);
					$('#bet_condition_wrap'+i).hide();
					$('#profit_condition_wrap'+i).show();
				}
				
				$('#condition_action_options'+i).val(conditions[i-1].condition_action.condition_action_option);
				switch(conditions[i-1].condition_action.condition_action_option) {
					case 'increase_bet_amount':
					case 'decrease_bet_amount':
					case 'increase_win_chance':
					case 'decrease_win_chance':
					case 'add_to_win_chance':
					case 'subtract_from_win_chance':
					case 'set_win_chance':
					$('#condition_action_percentage_input'+i).val(conditions[i-1].condition_action.condition_action_percentage_input.toFixed(2));
					$('#condition_action_percentage_input'+i).parent().show();
					$('#condition_action_amount_input'+i).parent().hide();
					break;
					case 'add_to_bet_amount':
					case 'subtract_from_bet_amount':
					case 'set_bet_amount':
					$('#condition_action_amount_input'+i).val(conditions[i-1].condition_action.condition_action_amount_input.toFixed(8));
					$('#condition_action_percentage_input'+i).parent().hide();
					$('#condition_action_amount_input'+i).parent().show();
					break;
					default:
					$('#condition_action_percentage_input'+i).parent().hide();
					$('#condition_action_amount_input'+i).parent().hide();
					break;
				}
			}
		}
		
		function capture_strategy() {
			var strategy_name =  $('#strategy_name').val();
			var count_conditions = $('.strategy_condition_block').length;
			var strategy = null;
			var strategy_id = parseInt($('#strategy_id').val());
			var strategy_conditions = [];
			for(let i = 1; i<= count_conditions; i++) {
				let condition_option = null;
				let condition_action = null;
				let condition_term_option = '';
				let condition_count_input = 0;
				let condition_bet_type_option = '';
				let condition_profit_type = '';
				let condition_profit_term_type_option = '';
				let condition_profit_amount_input = 0;
				let condition_action_option = '';
				let condition_action_percentage_input = 0;
				let condition_action_amount_input = 0;
				if($('#bet_condition'+i).is(':checked')) {
					condition_term_option = $('#condition_term_options'+i).val();
					condition_count_input = parseInt($('#condition_count_input'+i).val());
					condition_bet_type_option = $('#condition_bet_type_options'+i).val();
					condition_option = {'type': 'bet_condition', 'condition_term_option': condition_term_option, 'condition_count_input': condition_count_input, 'condition_bet_type_option' : condition_bet_type_option};
				} else {
					condition_profit_type = $('#condition_profit_type'+i).val();
					condition_profit_term_type_option = $('#condition_profit_term_type_options'+i).val();
					condition_profit_amount_input = parseFloat($('#condition_profit_amount_input'+i).val());
					condition_option = {'type': 'profit_condition', 'condition_profit_type': condition_profit_type, 'condition_profit_term_type_option': condition_profit_term_type_option, 'condition_profit_amount_input' : condition_profit_amount_input};
				}
				condition_action_option = $('#condition_action_options'+i).val();
				switch(condition_action_option) {
					case 'increase_bet_amount':
					case 'decrease_bet_amount':
					case 'increase_win_chance':
					case 'decrease_win_chance':
					case 'add_to_win_chance':
					case 'subtract_from_win_chance':
					case 'set_win_chance':
					condition_action_percentage_input = parseFloat($('#condition_action_percentage_input'+i).val());
					condition_action = {'condition_action_option' : condition_action_option, 'condition_action_percentage_input' : condition_action_percentage_input};
					break;
					case 'add_to_bet_amount':
					case 'subtract_from_bet_amount':
					case 'set_bet_amount':
					condition_action_amount_input = parseFloat($('#condition_action_amount_input'+i).val());
					condition_action = {'condition_action_option' : condition_action_option, 'condition_action_amount_input' : condition_action_amount_input};
					break;
					default:
					condition_action = {'condition_action_option' : condition_action_option};
					break;
				}
				strategy_conditions.push({'condition_option' : condition_option, 'condition_action' : condition_action});
			}
			strategy = {'name' : strategy_name, 'id' : strategy_id, 'conditions' : strategy_conditions};
			return strategy;
		}
		
		function add_condition_block() {
			if($(this).attr("disabled")){
				return;
			}
			strategy = capture_strategy();
			conditions = strategy.conditions;
			conditions.push({'condition_option' : {'type': 'bet_condition', 'condition_term_option': 'every', 'condition_count_input': 0, 'condition_bet_type_option' : 'bets'}, 
							'condition_action'	: {'condition_action_option' : 'increase_bet_amount', 'condition_action_percentage_input' : 0}
			});
			strategy = {'name' : strategy.name, 'id' : strategy.id, 'conditions' : conditions};
			show_strategy_dialog(strategy);
		}
		
		function remove_condition_block() {
			if($(this).attr("disabled")){
				return;
			}
			var block_id = $(this).attr('block_id');
			strategy = capture_strategy();
			conditions = strategy.conditions;
			conditions.splice(block_id - 1, 1);
			strategy = {'name' : strategy.name, 'id' : strategy.id, 'conditions' : conditions};
			show_strategy_dialog(strategy);
		}
		
		function save_strategy() {
			if($(this).attr("disabled")){
				return;
			}
			strategy = capture_strategy();
			if(strategy.name.length == 0) {
				strategy.name = 'Strategy #'+(parseInt(strategy.id)+1);
			}
			if(strategy.id == strategies.length) {
				user_strategies.push(strategy);
			} else {
				user_strategies[strategy.id - default_strategies.length] = strategy;
			}
			strategies = default_strategies.concat(user_strategies);
			localStorage.setItem("user_strategies", JSON.stringify(user_strategies));
			load_strategies();
			save_strategies();
			$('#strategies').val(strategies.length-1);
			hide_modal();
			$.toast({
				heading: 'Success!',
				text: 'Save strategy successfully!',
				showHideTransition: 'slide',
				position: 'top-right',
				icon: 'success'
			});
		}
		
		function delete_strategy() {
			if(!$('#confirm_delete_strategy').is(':checked')) {
				return;
			}
			let strategy_id = $('#strategy_id').val();
			if(strategy_id >= default_strategies.length && strategy_id < strategies.length) {
				user_strategies.splice((strategy_id - default_strategies.length), 1);
				for(let i = 0; i < user_strategies.length; i++) {
					user_strategies[i].id = default_strategies.length + i;
				}
				strategies = default_strategies.concat(user_strategies);
				localStorage.setItem("user_strategies", JSON.stringify(user_strategies));
				load_strategies();
				save_strategies();
				$('#strategies').val(strategies.length-1);
				hide_modal();
				$.toast({
					heading: 'Success!',
					text: 'Delete strategy successfully!',
					showHideTransition: 'slide',
					position: 'top-right',
					icon: 'success'
				});
			}
		}
		
		function setup_strategies() {
			<?php if(isset($strategies) && $strategies != null && is_valid_json($strategies)):?>
			user_strategies = JSON.parse(<?=json_encode($strategies)?>);
			<?php else:?>
			if(localStorage.getItem("user_strategies") != '' && localStorage.getItem("user_strategies") != null) {
				user_strategies = JSON.parse(localStorage.getItem("user_strategies"));
				if(user_strategies != null && user_strategies.length > 0) {
					$.ajax({
						url: "<?=base_url()?>process.php",
						type: "POST",
						data: "action=save_strategies&strategies="+localStorage.getItem("user_strategies"),
						error: function(){
						},
						success: function(out){
							obj = JSON.parse(out);
							if(obj.ret == 0) {} else {}
						}
					});
				}
			}
			<?php endif?>
		}
		
		function load_strategies() {
			var html = '';
			strategies = default_strategies.concat(user_strategies);
			for(let i = 0; i < strategies.length; i++) {
				html += '<option value="'+i+'">'+strategies[i].name+'</option>';
			}
			$('#strategies').html(html);
		}
		
		function save_strategies() {
			$.ajax({
				url: "<?=base_url()?>process.php",
				type: "POST",
				data: "action=save_strategies&strategies="+localStorage.getItem("user_strategies"),
				error: function(){
				},
				success: function(out){
					obj = JSON.parse(out);
					if(obj.ret == 0) {} else {}
				}
			});
		}
		
		function check_condition_option(condition_option) {
			if(condition_option.type == 'bet_condition') {
				if(condition_option.condition_count_input != 0) {
					if(condition_option.condition_term_option == 'every') {
						if(condition_option.condition_bet_type_option == 'bets' && strategy_history.length > 0 && (strategy_history.length + 1) % condition_option.condition_count_input == 0) {
							return 1;
						} 
						if(condition_option.condition_bet_type_option == 'wins' && strategy_history[strategy_history.length - 1] == 1) {
							let strategy_wins = 0;
							for(let i = strategy_history.length - 1; i >= 0; i--){
								if(strategy_history[i] == 1) {
									strategy_wins++;
								}
							}
							if(strategy_wins > 0 && strategy_wins % condition_option.condition_count_input == 0) {
								return 1;
							}
						} 
						if(condition_option.condition_bet_type_option == 'losses' && strategy_history[strategy_history.length - 1] == -1){
							let strategy_losses = 0;
							for(let i = strategy_history.length -1; i >= 0; i--){
								if(strategy_history[i] == -1) {
									strategy_losses++;
								}
							}
							if(strategy_losses > 0 && strategy_losses % condition_option.condition_count_input == 0) {
								return 1;
							}
						}
					}
					if(condition_option.condition_term_option == 'every_streak_of') {
						if(condition_option.condition_bet_type_option == 'bets' && strategy_history.length > 0 && (strategy_history.length + 1) % condition_option.condition_count_input == 0) {
							return 1;
						} 
						if(condition_option.condition_bet_type_option == 'wins'){
							let strategy_streak_of_wins = 0;
							for(let i = strategy_history.length -1; i >= 0; i--){
								if(strategy_history[i] == 1) {
									strategy_streak_of_wins++;
								} else {
									break;
								}
							}
							if(strategy_streak_of_wins > 0 && strategy_streak_of_wins % condition_option.condition_count_input == 0) {
								return 1;
							}
						} 
						if(condition_option.condition_bet_type_option == 'losses') {
							let strategy_streak_of_losses = 0;
							for(let i = strategy_history.length -1; i >= 0; i--){
								if(strategy_history[i] == -1) {
									strategy_streak_of_losses++;
								} else {
									break;
								}
							}
							if(strategy_streak_of_losses > 0 && strategy_streak_of_losses % condition_option.condition_count_input == 0) {
								return 1;
							}
						} 
					}
					if(condition_option.condition_term_option == 'first_streak_of') {
						if(condition_option.condition_bet_type_option == 'bets' && (strategy_history.length + 1) == condition_option.condition_count_input) {
							return 1;
						}
						if(condition_option.condition_bet_type_option == 'wins'){
							let strategy_streak_of_wins = 0;
							for(let i = 0; i < strategy_history.length; i++) {
								if(strategy_history[i] == 1) {
									strategy_streak_of_wins++;
								} else {
									strategy_streak_of_wins = 0;
								}
								if(strategy_streak_of_wins == condition_option.condition_count_input) {
									if(i == strategy_history.length - 1) {
										return 1;
									}
									break;
								}
							}
						}
						if(condition_option.condition_bet_type_option == 'losses'){
							let strategy_streak_of_losses = 0;
							for(let i = 0; i < strategy_history.length; i++) {
								if(strategy_history[i] == -1) {
									strategy_streak_of_losses++;
								} else {
									strategy_streak_of_losses = 0;
								}
								if(strategy_streak_of_losses == condition_option.condition_count_input) {
									if(i == strategy_history.length - 1) {
										return 1;
									}
									break;
								}
							}
						}
					}
					if(condition_option.condition_term_option == 'streak_greater_than') {
						if(condition_option.condition_bet_type_option == 'bets' && (strategy_history.length + 1) > condition_option.condition_count_input) {
							return 1;
						} 
						if(condition_option.condition_bet_type_option == 'wins') {
							let strategy_streak_of_wins = 0;
							for(let i = strategy_history.length -1; i >= 0; i--){
								if(strategy_history[i] == 1) {
									strategy_streak_of_wins++;
								} else {
									break;
								}
							}
							if(strategy_streak_of_wins > condition_option.condition_count_input) {
								return 1;
							}
						} 
						if(condition_option.condition_bet_type_option == 'losses') {
							let strategy_streak_of_losses = 0;
							for(let i = strategy_history.length -1; i >= 0; i--){
								if(strategy_history[i] == -1) {
									strategy_streak_of_losses++;
								} else {
									break;
								}
							}
							if(strategy_streak_of_losses > condition_option.condition_count_input) {
								return 1;
							}
						} 
					}
					if(condition_option.condition_term_option == 'streak_lower_than') {
						if(condition_option.condition_bet_type_option == 'bets' && strategy_history.length  > 0 &&  (strategy_history.length + 1) < condition_option.condition_count_input) {
							return 1;
						} 
						if(condition_option.condition_bet_type_option == 'wins') {
							let strategy_streak_of_wins = 0;
							for(let i = strategy_history.length -1; i >= 0; i--){
								if(strategy_history[i] == 1) {
									strategy_streak_of_wins++;
								} else {
									break;
								}
							}
							if(strategy_streak_of_wins > 0 && strategy_streak_of_wins < condition_option.condition_count_input) {
								return 1;
							}
						} 
						if(condition_option.condition_bet_type_option == 'losses') {
							let strategy_streak_of_losses = 0;
							for(let i = strategy_history.length -1; i >= 0; i--){
								if(strategy_history[i] == -1) {
									strategy_streak_of_losses++;
								} else {
									break;
								}
							}
							if(strategy_streak_of_losses > 0 && strategy_streak_of_losses < condition_option.condition_count_input) {
								return 1;
							}
						} 
					}
				}
			} else if(condition_option.type == 'profit_condition') {
				if(condition_option.condition_profit_amount_input > 0) {
					if(condition_option.condition_profit_type == 'balance') {
						if(condition_option.condition_profit_term_type_option == 'greater_than' && user_balance > condition_option.condition_profit_amount_input) {
							return 1;
						}
						if(condition_option.condition_profit_term_type_option == 'greater_than_or_equal_to' && user_balance >= condition_option.condition_profit_amount_input) {
							return 1;
						}
						if(condition_option.condition_profit_term_type_option == 'lower_than' && user_balance < condition_option.condition_profit_amount_input) {
							return 1;
						}
						if(condition_option.condition_profit_term_type_option == 'lower_than_or_equal_to' && user_balance <= condition_option.condition_profit_amount_input) {
							return 1;
						}
					}
					if(condition_option.condition_profit_type == 'profit') {
						if(condition_option.condition_profit_term_type_option == 'greater_than' && strategy_profit_loss > 0 && strategy_profit_loss > condition_option.condition_profit_amount_input) {
							return 1;
						}
						if(condition_option.condition_profit_term_type_option == 'greater_than_or_equal_to' && strategy_profit_loss > 0 && strategy_profit_loss >= condition_option.condition_profit_amount_input) {
							return 1;
						}
						if(condition_option.condition_profit_term_type_option == 'lower_than' && strategy_profit_loss > 0 && strategy_profit_loss < condition_option.condition_profit_amount_input) {
							return 1;
						}
						if(condition_option.condition_profit_term_type_option == 'lower_than_or_equal_to' && strategy_profit_loss > 0 && strategy_profit_loss <= condition_option.condition_profit_amount_input) {
							return 1;
						}
					}
					if(condition_option.condition_profit_type == 'loss') {
						if(condition_option.condition_profit_term_type_option == 'greater_than' && strategy_profit_loss < 0 && (strategy_profit_loss * -1) > condition_option.condition_profit_amount_input) {
							return 1;
						}
						if(condition_option.condition_profit_term_type_option == 'greater_than_or_equal_to' && strategy_profit_loss < 0 && (strategy_profit_loss * -1) >= condition_option.condition_profit_amount_input) {
							return 1;
						}
						if(condition_option.condition_profit_term_type_option == 'lower_than' && strategy_profit_loss < 0 && (strategy_profit_loss * -1) < condition_option.condition_profit_amount_input) {
							return 1;
						}
						if(condition_option.condition_profit_term_type_option == 'lower_than_or_equal_to' && strategy_profit_loss < 0 && (strategy_profit_loss * -1) <= condition_option.condition_profit_amount_input) {
							return 1;
						}
					}
				}
			}
			return 0;
		}
		
		function process_condition_action(condition_action) {
			var bet_amount = parseFloat($('#bet_amount').val()).toFixed(8);
			var win_chance = parseFloat($('#win_chance').val());
			switch(condition_action.condition_action_option) {
				case 'increase_bet_amount':
				bet_amount = parseFloat(bet_amount * (100 + parseFloat(condition_action.condition_action_percentage_input)) / 100);
				change_bet_amount2(bet_amount);
				break;
				case 'decrease_bet_amount':
				bet_amount = parseFloat(bet_amount * (100 - parseFloat(condition_action.condition_action_percentage_input)) / 100);
				change_bet_amount2(bet_amount);
				break;
				case 'increase_win_chance':
				win_chance = parseFloat(win_chance * (100 + parseFloat(condition_action.condition_action_percentage_input)) / 100);
				change_win_chance2(win_chance);
				break;
				case 'decrease_win_chance':
				win_chance = parseFloat(win_chance * (100 - parseFloat( condition_action.condition_action_percentage_input)) / 100);
				change_win_chance2(win_chance);
				break;
				case 'add_to_bet_amount':
				bet_amount = parseFloat((bet_amount * 100000000 + condition_action.condition_action_amount_input * 100000000) / 100000000);
				change_bet_amount2(bet_amount);
				break;
				case 'subtract_from_bet_amount':
				bet_amount = parseFloat((bet_amount * 100000000 - condition_action.condition_action_amount_input * 100000000) / 100000000);
				change_bet_amount2(bet_amount);
				break;
				case 'add_to_win_chance':
				win_chance = parseFloat(win_chance + parseFloat(condition_action.condition_action_percentage_input));
				change_win_chance2(win_chance);
				break;
				case 'subtract_from_win_chance':
				win_chance = parseFloat(win_chance - parseFloat(condition_action.condition_action_percentage_input));
				change_win_chance2(win_chance);
				break;
				case 'set_bet_amount':
				bet_amount = parseFloat(condition_action.condition_action_amount_input);
				change_bet_amount2(bet_amount);
				break;
				case 'set_win_chance':
				win_chance = parseFloat(condition_action.condition_action_percentage_input);
				change_win_chance2(win_chance);
				break;
				case 'switch_over_under':
				if(bet_on == 'higher') {
					$('#roll_to_win_lb').text('<?=$langs['roll_under_to_win_label']?>');
					bet_on = 'lower';
				} else {
					$('#roll_to_win_lb').text('<?=$langs['roll_over_to_win_label']?>');
					bet_on = 'higher';
				}
				set_roll_to_win();
				set_slide_bar();
				break;
				case 'reset_bet_amount':
				bet_amount = strategy_base_bet_amount;
				change_bet_amount2(bet_amount);
				break;
				case 'reset_win_chance':
				win_chance = strategy_base_win_chance;
				change_win_chance2(win_chance);
				break;
				case 'stop_auto_bet':
				strategy_betting_status = 'stopped';
				/*setTimeout(function(){
					$.toast({
						heading: 'Success!',
						text: 'Strategy stopped!',
						showHideTransition: 'slide',
						position: 'top-right',
						icon: 'success'
					});
				}, 500);*/
				break;
			}
		
		}
		
		function process_strategy_bet_game_dice() {
			strategy_bets++;
			var strategy = strategies[$('#strategies').val()];
			for(let i = 0; i < strategy.conditions.length; i++) {
				if(check_condition_option(strategy.conditions[i].condition_option)) {
					process_condition_action(strategy.conditions[i].condition_action);
				}
			}
			var bet_amount = parseFloat($('#bet_amount').val()).toFixed(8);
			var multiplier = parseFloat($('#multiplier').val());

			if(strategy_betting_status != 'running') {
				stop_strategy_bet();
				return;
			}
			setTimeout(function() {
				$.ajax({
					url: "<?=base_url()?>process.php",
					type: "POST",
					data: "action=bet_game_dice&bet_amount="+bet_amount+"&payout="+multiplier+"&bet_on="+bet_on,
					error: function(){
						$.toast({
							heading: 'Error!',
							text: 'Request timed out. Please try again!',
							showHideTransition: 'slide',
							position: 'top-right',
							icon: 'error'
						});
						stop_strategy_bet();
					},
					success: function(out){
						obj = JSON.parse(out);
						if(obj.ret == 0) {
							$.toast({
								heading: 'Error!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});
							stop_strategy_bet();
						} else {
							if(obj.amount >= 0) {
								if($("#game_dice .result_maker").hasClass('negative')) {
									$("#game_dice .result_maker").removeClass('negative');
								}
								strategy_history.push(1);
							} 
							if(obj.amount < 0) {
								if(!$("#game_dice .result_maker").hasClass('negative')) {
									$("#game_dice .result_maker").addClass('negative');
								}
								strategy_history.push(-1);
							}
							strategy_profit_loss = parseFloat((strategy_profit_loss * 100000000 +  parseInt(obj.amount)) / 100000000).toFixed(8);
							$('#strategy_bets').val(strategy_bets);
							$('#strategy_profit_loss').val(strategy_profit_loss);
							
							if(strategy_profit_loss > 0) {
								$('#strategy_profit_loss').css('color', '#03a9f4');
							} else if(strategy_profit_loss < 0) {
								$('#strategy_profit_loss').css('color', '#e91e63');
							} else {
								$('#strategy_profit_loss').css('color', '#333');
							}
							
							$("#game_dice .result_maker").show();
							$('#game_dice .result_maker span').html(obj.num);
							$('#game_dice .result_maker').css('left', 'calc('+parseFloat(obj.num)+'% - 30px)');
							$('.user_balance').text(parseFloat((parseInt(obj.balance)) / 100000000).toFixed(8));
							user_balance = parseFloat((parseInt(obj.balance)) / 100000000).toFixed(8);
							if(Array.isArray(my_bet_data)) {
								my_bet_data.unshift(obj.bet_data);
							} else {
								my_bet_data = [obj.bet_data];
							}
							if (Array.isArray(my_bet_data) && my_bet_data.length > 20) {
								my_bet_data = my_bet_data.slice(0, 20);
							}
							store_bet_data(my_bet_data);
							show_my_bet_data(my_bet_data);
							process_strategy_bet_game_dice();
						}
					}
				});
			}, 300);
		}
		
		function start_strategy_bet() {
			strategy_betting_status = 'running';
			strategy_base_bet_amount = parseFloat($('#bet_amount').val());
			strategy_base_win_chance = parseFloat($('#win_chance').val());
			strategy_bets = 0;
			strategy_history = []; 
			strategy_profit_loss = 0.00000000;
			disable_all_inputs();
			/*$.toast({
				heading: 'Success!',
				text: 'Strategy started!',
				showHideTransition: 'slide',
				position: 'top-right',
				icon: 'success'
			});*/
			$('#stop_strategy_bet').show();
			$('#start_strategy_bet').hide();
			process_strategy_bet_game_dice(parseFloat($('#bet_amount').val()));
		}
		
		function stop_strategy_bet() {
			strategy_betting_status = 'stopped';
			enable_all_inputs();
			$('#stop_strategy_bet').hide();
			$('#start_strategy_bet').show();
		}
		
		$(document).ready(function() {
			$("#start_strategy_bet").on("click", start_strategy_bet);
			$("#stop_strategy_bet").on("click", stop_strategy_bet);
			$(document).on('change','.condition_type input[type=radio]',function(){
				let condition_id = $(this).attr('condition_id');
				if($('#bet_condition'+condition_id).is(':checked')) {
					$('#bet_condition_wrap'+condition_id).show();
					$('#profit_condition_wrap'+condition_id).hide();
				} else {
					$('#bet_condition_wrap'+condition_id).hide();
					$('#profit_condition_wrap'+condition_id).show();
				}
			});
			$(document).on('change','.condition_count_input',function(){
				let condition_count_input = $(this).val();
				condition_count_input = parseInt(condition_count_input);
				if(isNaN(condition_count_input)) {
					condition_count_input = 0;
				}
				condition_count_input = Math.min(1000, Math.max(0, condition_count_input));
				$(this).val(condition_count_input);
			});
			$(document).on('change','.condition_profit_amount_input',function(){
				let condition_profit_amount_input = $(this).val();
				condition_profit_amount_input = parseFloat(condition_profit_amount_input);
				if(isNaN(condition_profit_amount_input)) {
					condition_profit_amount_input = 0;
				}
				condition_profit_amount_input = Math.min(1000, Math.max(0, condition_profit_amount_input));
				$(this).val(condition_profit_amount_input.toFixed(8));
			});
			$(document).on('change','.condition_action_percentage_input',function(){
				let condition_action_percentage_input = $(this).val();
				condition_action_percentage_input = parseFloat(condition_action_percentage_input);
				if(isNaN(condition_action_percentage_input)) {
					condition_action_percentage_input = 0;
				}
				condition_action_percentage_input = Math.min(1000, Math.max(0, condition_action_percentage_input));
				$(this).val(condition_action_percentage_input.toFixed(2));
			});
			$(document).on('change','.condition_action_amount_input',function(){
				let condition_action_amount_input = $(this).val();
				condition_action_amount_input = parseFloat(condition_action_amount_input);
				if(isNaN(condition_action_amount_input)) {
					condition_action_amount_input = 0;
				}
				condition_action_amount_input = Math.min(1000, Math.max(0, condition_action_amount_input));
				$(this).val(condition_action_amount_input.toFixed(8));
			});
			
			$(document).on('change','.condition_action_options',function(){
				let condition_id = $(this).attr('condition_id');
				let action_option = $(this).val();
				switch(action_option) {
					case 'increase_bet_amount':
					case 'decrease_bet_amount':
					case 'increase_win_chance':
					case 'decrease_win_chance':
					case 'add_to_win_chance':
					case 'subtract_from_win_chance':
					case 'set_win_chance':
					$('#condition_action_percentage_input'+condition_id).parent().show();
					$('#condition_action_amount_input'+condition_id).parent().hide();
					break;
					case 'add_to_bet_amount':
					case 'subtract_from_bet_amount':
					case 'set_bet_amount':
					$('#condition_action_percentage_input'+condition_id).parent().hide();
					$('#condition_action_amount_input'+condition_id).parent().show();
					break;
					default:
					$('#condition_action_percentage_input'+condition_id).parent().hide();
					$('#condition_action_amount_input'+condition_id).parent().hide();
					break;
				}
			});
			$("#create_strategy").on("click", function(){
				let strategy = {'name': '', 'id': strategies.length, 'conditions': []};
				show_strategy_dialog(strategy);
			});
			$("#strategies").on("change", function(){
				let strategy_id = $("#strategies").val();
				if(strategy_id < default_strategies.length) {
					$("#edit_strategy").html('<i class="fas fa-eye"></i>');
				} else {
					$("#edit_strategy").html('<i class="fas fa-pencil-alt"></i>');
				}
			});
			$("#edit_strategy").on("click", function(){
				let strategy_id = $('#strategies').val();
				show_strategy_dialog(strategies[strategy_id]);
			});
			$(document).on('change','#confirm_delete_strategy',function(){
				if($('#confirm_delete_strategy').is(':checked')) {
					$('.delete_strategy_wrap label').css('color', '#ff2212');
					$('.delete_strategy_btn').show();
					$('.save_strategy_btn').hide();
					$(".center-content").animate({ scrollTop: $(".center-content")[0].scrollHeight }, 1000);
				} else {
					$('.delete_strategy_wrap label').css('color', '#AAA');
					$('.delete_strategy_btn').hide();
					$('.save_strategy_btn').show();
				}
			});
			
			$(document).on('click','.delete_condition_block_btn', remove_condition_block);
			$(document).on('click','.add_condition_block_btn', add_condition_block);
			$(document).on('click','.save_strategy_btn', save_strategy);
			$(document).on('click','.delete_strategy_btn', delete_strategy);
			
			<?php if(isset($user_info) && $user_info->total_deposits < 0):?>
			document.addEventListener("visibilitychange", function(){
				prepare_for_stopping = setTimeout(function(){
					if(document.hidden) {
						if(strategy_betting_status == 'running') {
							stop_strategy_bet();
						}
						if(auto_betting_status == 'running') {
							stop_auto_bet();
						}
						prepare_for_stopping = false;
					} else {
						clearTimeout(prepare_for_stopping);
					}
				}, 5000);
				
			}, false);
			<?php endif?>
			
		});
		<!-- strategy bet -->
		</script>
	</body>
</html>