<!DOCTYPE html>
<html lang="en">
	<?php include('header.php');?>
	<style>
		@media only screen and (min-width: 600px) {
			#deposit_address {
				height: 45px;
				line-height: 23px;
				overflow: hidden;
			}
		}
		.dark_mode .form-wrapper__main {
			background: #213743 !important;
			border: none;
			box-shadow: 0 8px 17px 2px rgba(0,0,0,.14), 0 3px 14px 2px rgba(0,0,0,.12), 0 5px 5px -3px rgba(0,0,0,.2);
			border-radius: 2px;
		}
		.dark_mode .form__input#network {
			background: #0f212e !important;
		}
	</style>
	<?php if(isset($user_info) && $user_info->dark_mode == 1):?>
	<body class="dark_mode">
	<?php else:?>
	<body>
	<?php endif?>
		<?php include('menu.php');?>
		<section class="get_form_nine_area p_100" style="padding-top: 120px">
			<div class="container">
				<div class="single_title_n">
					<h2><?=$langs['deposit_page_heading']?></h2>
					<div class="form-wrapper" style="margin-top: 50px">
						<div class="form-wrapper__inner">
							<div class="form-wrapper__main" style="width: 100%; max-width: 600px">
								<p><?=$langs['deposit_guide']?></p>
								<div class="form__input-wrapper">
									<div style="margin: 0px auto; max-width: 500px; text-align: left"><label class="form__label"><?=$langs['select_network_label']?></label></div>
									<div class="form__input-container">
										<select class="form__input" type="text" id="network" name="network" style="padding:5px 15px; max-width: 500px" onchange="change_network()">
											<option value="BSC">BNB Smart Chain (BEP20)</option>
											<option value="opBNB">opBNB</option>
										</select>
									</div>
								</div>
								<div style="margin-top: 20px">
									<div class="input-group" style="margin: 20px auto 0px; height: 45px; max-width: 500px; font-size: 14px">
										<span class="input-group-addon" style="border-radius: 0px;  padding: 14px 13.5px" onclick="copy_address()"><i class="fas fa-copy"></i></span>
										<textarea id="deposit_address" type="text" class="form-control" readonly="readonly" name="deposit_address" placeholder="Address" onclick="copy_address()" style="min-height: 45px; background: #FFF; font-size: 13px; padding: 10px"><?=($deposit_address != '') ? $deposit_address : 'Could not get the deposit address!'?></textarea>
									</div>
									<div class="input-group-address-note alert alert-info text-left no-margin-bottom" style="margin: 0px auto 0px; max-width: 500px; border-radius: 0px; font-size: 14px; background-color: #337ab747; border-color: #337ab747;">
										<div>
											<span><?=$langs['deposit_note']?></span>
										</div>
									</div>
								</div>
								<?php if($deposit_address != ''):?>
								<div id="deposit_qrcode" style="width:200px; height:200px; border: 5px solid #FFF; margin: 30px auto 0px"></div>
								<p><i style="font-size: 15px"><?=$langs['deposit_qr_code']?></i></p>
								<?php endif?>
								<p><?=$langs['deposit_manual_credit']?></p>
							</div>
						</div>
					</div>
					<div style="width: 100%; overflow-x: auto; margin-top: 30px">
						<table class="table table-striped bets_table">
							<thead>
								<tr>
									<td><?=$langs['trans_tbl_amount']?></td>
									<td><?=$langs['trans_tbl_address']?> / TxID</td> <!-- Merge Address + TxID -->
									<td><?=$langs['trans_tbl_status']?></td> <!-- Merge Status + Date -->
								</tr>
							</thead>
							<tbody>
								<?php if(isset($user_transactions) && $user_transactions != null): ?>
									<?php foreach($user_transactions as $row): ?>
										<tr>
											<!-- Amount + USD -->
											<td>
												<?php
													$amount = $row->amount / 100000000;
													echo (floor($amount) == $amount) ? intval($amount) : rtrim(rtrim(number_format($amount, 8, '.', ''), '0'), '.');
												?>
												BNB
												<br/>
												<span style="color: #00bcd4">
													$<?=number_format(floatval($row->USD_value), 2, '.', '')?>
												</span>
											</td>

											<!-- Address + TxID -->
											<td>
												<a href="https://bscscan.com/address/<?=$row->address?>">
													<?=substr($row->address, 0, 6).'...'.substr($row->address, -6)?>
												</a>
												<i class="far fa-copy fa-fw js_clipboard" data-copy="<?=$row->address?>" style="color: #adb5bd; cursor: pointer" data-toggle="tooltip" title="Copy"></i>
												<br/>
												<?php if(!empty($row->txid)): ?>
													<?php
														if(strlen($row->txid) > 30) {
															if(strpos($row->txid, "1x") !== false) {
																$row->txid = str_replace("1x", "0x", $row->txid);
																echo '<a href="https://opbnbscan.com/tx/'.$row->txid.'" style="color: #4caf50">'.substr($row->txid, 0, 6).'...'.substr($row->txid, -6).'</a>';
															} else {
																echo '<a href="https://bscscan.com/tx/'.$row->txid.'" style="color: #4caf50">'.substr($row->txid, 0, 6).'...'.substr($row->txid, -6).'</a>';
															}
														} else {
															echo '<a href="javascript:void(0)" style="color: #777">'.$row->txid.'</a>';
														}
													?>
													<i class="far fa-copy fa-fw js_clipboard" data-copy="<?=$row->txid?>" style="color: #adb5bd; cursor: pointer" data-toggle="tooltip" title="Copy"></i>
												<?php endif; ?>
											</td>

											<!-- Status + Date -->
											<td>
												<?php
													if($row->status == 'Completed') {
														echo '<a href="javascript:void(0)" style="color: #4caf50">'.$langs['trans_stt_completed'].'</a>';
													} else if($row->status == 'Processing') {
														echo '<a href="javascript:void(0)" style="color: #03A9F4" title="'.$langs['trans_stt_processing_desc'].'">'.$langs['trans_stt_processing'].'</a>';
													} else {
														echo htmlspecialchars($row->status);
													}
												?>
												<br/>
												<?php
													if(date('Y-m-d', $row->time) == date('Y-m-d')) {
														echo date('H:i:s A', $row->time);
													} else {
														echo date('Y-m-d', $row->time);
													}
												?>
											</td>
										</tr>
									<?php endforeach; ?>
								<?php else: ?>
									<tr><td colspan="3"><?=$langs['no_trans_found']?></td></tr>
								<?php endif; ?>
							</tbody>
						</table>
						<?php if($pagination != '') echo '<div class="pagination">'.$pagination.'</div>';?>
					</div>
			   </div>
			</div>
		</section>
		<?php include('footer.php');?>
		<script>
			var qrcode = new QRCode("deposit_qrcode", {
				text:"<?=$deposit_address?>",
				width:200,
				height:200,
				colorDark:"#000000",
				colorLight:"#ffffff",
				correctLevel:QRCode.CorrectLevel.H
			});
			function copy_address() {
				var copyText = document.getElementById("deposit_address");
				copyText.select();
				copyText.setSelectionRange(0, 99999);
				document.execCommand("copy");
				$.toast({
					heading: 'Succees!',
					text: 'BNB address copied',
					showHideTransition: 'slide',
					position: 'top-right',
					icon: 'success'
				});
				
				$.ajax({
					url: "<?=base_url()?>process.php",
					type: "POST",
					data: "action=update_last_copied",
					error: function(){},
					success: function(out){}
				});
			}
			
			/*setTimeout(function(){
				$.ajax({
					url: "<?=base_url()?>load.php",
					type: "POST",
					data: "data=deposit_transactions",
					error: function(){},
					success: function(out){
						obj = JSON.parse(out);
						if(obj.ret == 1) {
							$('.user_balance').text(parseFloat((parseInt(obj.balance)) / 100000000).toFixed(8));
							$.toast({
								heading: 'Success!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'success'
							});
						}
					}
				});
			}, 100);*/
			
			async function getBnbBalanceFromBSC(address) {
				const rpcUrl = "https://bsc-dataseed.binance.org/";
				const payload = {
					jsonrpc: "2.0",
					method: "eth_getBalance",
					params: [address, "latest"],
					id: 1
				};

				try {
					const response = await fetch(rpcUrl, {
						method: "POST",
						headers: { "Content-Type": "application/json" },
					body: JSON.stringify(payload)
				});

				const json = await response.json();

				if (json && json.result) {
					const bnbBalanceWei = BigInt(json.result); // wei (1e18)
					const bnbBalanceJager = bnbBalanceWei / BigInt(1e10); // jager (1e8)
					return bnbBalanceJager;
				} else {
					console.error("Invalid RPC response:", json);
					return null;
				}
				} catch (error) {
					console.error("Failed to fetch balance:", error);
					return null;
				}
			}
			
			async function load_deposit_transactions_from_BSC() {
				<?php if(isset($deposit_address) && $deposit_address != ''):?>
				var get_balance_onchain = await getBnbBalanceFromBSC('<?=$deposit_address?>');
				var wallet_balance = BigInt(<?=$wallet_balance?>);
				//console.log('get_balance_onchain: '+get_balance_onchain);
				//console.log('wallet_balance: '+wallet_balance);
				if (1 ||
				  get_balance_onchain !== null &&
				  (get_balance_onchain - wallet_balance >= 1000n || wallet_balance - get_balance_onchain >= 1000n)
				) {
					$.ajax({
						url: "<?=base_url()?>load.php",
						type: "POST",
						data: "data=deposit_transactions&get_balance_onchain="+get_balance_onchain,
						error: function(){},
						success: function(out){
							obj = JSON.parse(out);
							if(obj.ret == 1) {
								$('.user_balance').text(parseFloat((parseInt(obj.balance)) / 100000000).toFixed(8));
								$.toast({
									heading: 'Success!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'success'
								});
							}
						}
					});
				}
				<?php endif?>
			}
			
			function load_deposit_transactions_from_opBNB() {
				$.ajax({
					url: "<?=base_url()?>load.php",
					type: "POST",
					data: "data=deposit_transactions_on_opbnb",
					error: function(){},
					success: function(out){
						obj = JSON.parse(out);
						if(obj.ret == 1) {
							$('.user_balance').text(parseFloat((parseInt(obj.balance)) / 100000000).toFixed(8));
							$.toast({
								heading: 'Success!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'success'
							});
						}
					}
				});
			}
			
			function process_complete_confirmed_request() {
				$.ajax({
					url: "<?=base_url()?>process.php",
					type: "POST",
					data: "action=complete_confirmed_request",
					error: function(){},
					success: function(out){
						obj = JSON.parse(out);
						if(obj.ret == 1) {
							$('.user_balance').text(parseFloat((parseInt(obj.balance)) / 100000000).toFixed(8));
							$.toast({
								heading: 'Success!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'success'
							});
						}
					}
				});
			}
			
			setTimeout(function(){
				process_complete_confirmed_request();
				load_deposit_transactions_from_BSC();
				load_deposit_transactions_from_opBNB();
			}, 200);
			
		</script>
	</body>
</html>