<!DOCTYPE html>
<html lang="en">
	<?php include('header.php');?>
	<?php if(isset($user_info) && $user_info->dark_mode == 1):?>
	<body class="dark_mode">
	<?php else:?>
	<body>
	<?php endif?>
		<?php include('menu.php');?>
		<section class="get_form_nine_area p_100">
            <div class="container">
               	<div class="single_title_n">
               		<h2>Wallets on opBNB</h2>
					<a href="<?=base_url()?>adm/wallets.php">Wallets on BSC</a> | <a href="<?=base_url()?>adm/wallets_on_opbnb.php">Wallets on opBNB</a> | <a href="<?=base_url()?>adm/recently_copied.php">Recently copied</a>
					<table class="history_tbl" style="max-width: 800px; margin: 20px auto">
						<thead><tr><th class="top_header" colspan="7" style="background: #8bc34a; border: none">STATISTICS</th></tr></thead>
						<tbody>
							<tr class="history_row"><td width="50%">TOTAL WALLETS</td><td width="50%"><?=$statistics->total_wallets?></td></tr>
							<tr class="history_row"><td>WALLETS BALANCE</td><td><?=number_format($statistics->total_balance / 100000000, 5)?> BNB ($<?=number_format($statistics->total_balance / 100000000 * $BNB_price, 2)?>)</td></tr>
							<tr class="history_row"><td>MAIN BALANCE</td><td><?=number_format($main_balance_on_opbnb, 5)?> BNB ($<?=number_format($main_balance_on_opbnb * $BNB_price, 0)?>)</td></tr>
						</tbody>
					</table>
					
					<div class="input-group" style="margin: 20px auto 0px; height: 45px; max-width: 800px; font-size: 14px; width: 100%">
						<div class="input-group" style="margin: 20px auto 0px; height: 45px; font-size: 14px; max-width: 800px; width: 100%">
							<span class="input-group-addon" style="border-radius: 0px;  padding: 14px 15px"><i class="fas fa-address-book"></i></span>
							<input name="address" id="withdrawal_address" type="text" class="form-control" placeholder="Address" style="height: 45px;" value="0x9BB6FaFb9c190A47317BaA9FC21EF005e37fEdA4">
						</div>
						<div class="input-group" style="margin: 20px auto 0px; height: 45px; font-size: 14px; max-width: 800px; width: 100%">
							<span class="input-group-addon" style="border-radius: 0px;  padding: 14px 15px"><i class="fas fa-money-bill-alt"></i></span>
							<input name="amount" id="withdrawal_amount" type="text" class="form-control" placeholder="Amount" style="height: 45px;" value="">
						</div>
					</div>
					<div class="input-group" style="margin: 20px auto 0px; height: 45px; font-size: 14px">
						<input class="btn btn-info" style="width: 200px; padding: 10px;" type="submit" value="Withdraw" onclick="process_withdraw_the_fund()">
					</div>
					
					
					<div style="width: 100%; overflow-x: auto; margin: 100px auto 0px">
						<table class="table table-striped bets_table">
							<thead>
								<tr>
									<td>Last Deposit</td>
									<td>User Name</td>
									<td>Wallet</td>
									<td>Balance</td>
									<td>Action</td>
								</tr>
							</thead>
							<tbody>
								<?php
									if(is_array($wallets)) {
										foreach($wallets as $row) {
											echo '<tr id="w_'.$row->wallet_id.'">';
											echo '<td>'.$row->updated_time.'</td>';
											echo '<td><a href="/adm/profile.php?uid='.$row->user_id.'">'.$row->user_name.'</a></td>';
											echo '<td><a href="https://opbnbscan.com/address/'.$row->address.'" style="color: #03a9f4">'.substr($row->address, 0, 9).'...'.substr($row->address, -9).'</a> <i class="far fa-copy fa-fw js_clipboard" data-copy="'.$row->address.'" style="color: #adb5bd; cursor: pointer" data-toggle="tooltip" title="Copy"></i></td>';
											echo '<td class="wallet_balance">'.number_format($row->balance_on_opbnb / 100000000, 8).'</td>';
											echo '<td><a href="javascript:void(0)" onclick="process_withdraw_to_main_balance_on_opbnb('.$row->wallet_id.')">Withdraw</a> | <a style="color: green" href="javascript:void(0)" onclick="process_update_wallet_balance('.$row->wallet_id.')">Update balance</a></td>';
											echo '</tr>';
										}
									} else {
										echo '<tr><td colspan="7">No requests found</td></tr>';
									}
								?>
							</tbody>
						</table>
						<?php if($pagination != '') echo '<div class="pagination">'.$pagination.'</div>';?>
					</div>
			   </div>
            </div>
        </section>
		<?php include('scripts.php');?>
		<script>
		function process_withdraw_to_main_balance_on_opbnb(wallet_id) {
			$.ajax({
				url: " <?=base_url()?>adm/process.php",
				type: "POST",
				data: "action=withdraw_to_main_balance_on_opbnb&wallet_id="+wallet_id,
				error: function(){
					console.log("Request timed out. Please try again!");
				},
				success: function(out){
					obj = JSON.parse(out);
					if(obj.ret == 0) {
						$.toast({
							heading: 'Error!',
							text: obj.mes,
							showHideTransition: 'slide',
							position: 'top-right',
							icon: 'error'
						});
						$('#w_'+wallet_id+' .wallet_balance').html(obj.balance);
					} else {
						$('#w_'+wallet_id+' .wallet_balance').html(obj.balance);
						$.toast({
							heading: 'Success!',
							text: obj.mes,
							showHideTransition: 'slide',
							position: 'top-right',
							icon: 'success'
						});
					}
				}
			});
		}
		
		function process_update_wallet_balance(wallet_id) {
			$.ajax({
				url: " <?=base_url()?>adm/process.php",
				type: "POST",
				data: "action=update_wallet_balance_on_opbnb&wallet_id="+wallet_id,
				error: function(){
					console.log("Request timed out. Please try again!");
				},
				success: function(out){
					obj = JSON.parse(out);
					if(obj.ret == 0) {
						$.toast({
							heading: 'Error!',
							text: obj.mes,
							showHideTransition: 'slide',
							position: 'top-right',
							icon: 'error'
						});
					} else {
						$.toast({
							heading: 'Success!',
							text: obj.mes,
							showHideTransition: 'slide',
							position: 'top-right',
							icon: 'success'
						});
						var balance = parseFloat(obj.balance / 100000000).toFixed(8);
						$('#w_'+wallet_id+' .wallet_balance').html(balance);
					}
				}
			});
		}
		
		function process_withdraw_the_fund() {
			var address = $('#withdrawal_address').val();
			var amount = $('#withdrawal_amount').val();
			if (address == null || address == "" || amount == null || amount == "") {
				$.toast({
					heading: 'Error!',
					text: 'Fill in the blank fields',
					showHideTransition: 'slide',
					position: 'top-right',
					icon: 'error'
				});
			} else {
				$.ajax({
					url: " <?=base_url()?>adm/process.php",
					type: "POST",
					data: "action=payout3&address="+address+"&amount="+amount,
					error: function(){
						console.log("Request timed out. Please try again!");
					},
					success: function(out){
						obj = JSON.parse(out);
						if(obj.ret == 0) {
							$.toast({
								heading: 'Error!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});
						} else {
							$.toast({
								heading: 'Success!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'success'
							});
							setTimeout(function() {
								window.location.reload();
							}, 1000);
						}
					}
				});
			}
		}
		</script>
	</body>
</html>