<!DOCTYPE html>
<html lang="en">
	<?php include('header.php');?>
	<style>
		input[type="checkbox"] {
			-webkit-appearance: auto;
		}
	</style>
	<?php if(isset($user_info) && $user_info->dark_mode == 1):?>
	<body class="dark_mode">
	<?php else:?>
	<body>
	<?php endif?>
		<?php include('menu.php');?>
		<section class="get_form_nine_area p_100">
			<div class="container">
				<div class="single_title_n">
					<h2>Users</h2>
					<table class="history_tbl" style="max-width: 800px; margin: 20px auto">
						<thead><tr><th class="top_header" colspan="7" style="background: #8bc34a; border: none">STATISTICS</th></tr></thead>
						<tbody>
							<tr class="history_row"><td width="50%">TOTAL USERS</td><td width="50%"><?=$statistics['total_users']?></td></tr>
							<tr class="history_row"><td>TOTAL DEPOSITS</td><td><?=number_format($statistics['total_deposits'] / 100000000, 8, '.', '')?></td></tr>
							<tr class="history_row"><td>TOTAL WITHDRAWALS</td><td><?=number_format($statistics['total_withdrawals'] / 100000000, 8, '.', '')?></td></tr>
							<tr class="history_row"><td>BALANCE</td><td><?=number_format($statistics['balance'] / 100000000, 8, '.', '')?></td></tr>
						</tbody>
					</table>
					<form style="margin: 20px auto;" method="GET">
						<a href="<?=base_url()?>adm/user_statistics.php">Advanced search</a>
						<div style="width: 100%; text-align: left; max-width: 800px; margin: auto;">
							<a href="<?=base_url()?>adm/users.php?k=WHERE+total_withdrawals+<+%28total_deposits+%2B+total_survey_rewards%29&s=temp_bet_balance&o=ASC&g=0" style="color: #4CAF50; margin-right: 10px">#Cashback</a>
							<a href="<?=base_url()?>adm/users.php?k=WHERE+total_withdrawals+>+total_deposits+AND+user_id+NOT+IN+%28SELECT+user_id+FROM+ez_staminas%29&s=amount_claims&o=DESC&g=0" style="color: #FF9800; margin-right: 10px">#MostClaims</a>
							<a href="<?=base_url()?>/adm/users.php?k=WHERE+user_id+IN+%28SELECT+user_id+FROM+ez_logs+WHERE+action+%3D+%27Detected+auto+claim%27+GROUP+BY+user_id%29+AND+banned+%3D+0+AND+total_deposits+%3D+0&s=balance&o=DESC&g=0" style="color: red; margin-right: 10px">#AutoClaim</a>
						</div>
						<div class="input-group" style="margin: 20px auto 0px; height: 45px; font-size: 14px; max-width: 800px; ">
							<span class="input-group-addon" style="border-radius: 0px;  padding: 14px 15px"><i class="fas fa-search"></i></span>
							<input name="k" type="text" class="form-control" placeholder="ID, Email, Wallet Address..." style="height: 45px;" value="<?=$search_key?>">
						</div>
						<div class="input-group" style="margin: 20px auto 0px; height: 45px; max-width: 800px; font-size: 14px">
							<span class="input-group-addon" style="border-radius: 0px;  padding: 14px 13.5px"><i class="fas fa-filter"></i></span>
							<select name="s" class="form-control" style="height: 45px;">
								<option value="user_id">Sorted by</option>
								<option value="user_id" <?php if($sorted_by == 'user_id') echo 'selected';?>>User ID</option>
								<option value="total_referrals" <?php if($sorted_by == 'total_referrals') echo 'selected';?>>Referrals</option>
								<option value="total_deposits" <?php if($sorted_by == 'total_deposits') echo 'selected';?>>Deposits</option>
								<option value="total_withdrawals" <?php if($sorted_by == 'total_withdrawals') echo 'selected';?>>Withdrawals</option>
								<option value="profit" <?php if($sorted_by == 'profit') echo 'selected';?>>Profit</option>
								<option value="temp_bet_balance" <?php if($sorted_by == 'temp_bet_balance') echo 'selected';?>>Temp profit</option>
								<option value="total_bonuses" <?php if($sorted_by == 'total_bonuses') echo 'selected';?>>Bonuses</option>
								<option value="balance" <?php if($sorted_by == 'balance') echo 'selected';?>>Balance</option>
								<option value="claims" <?php if($sorted_by == 'claims') echo 'selected';?>>Claims</option>
								<option value="amount_claims" <?php if($sorted_by == 'amount_claims') echo 'selected';?>>Amount claims</option>
								<option value="bets" <?php if($sorted_by == 'bets') echo 'selected';?>>Bets</option>
								<option value="total_survey_rewards" <?php if($sorted_by == 'total_survey_rewards') echo 'selected';?>>Surveys</option>
								<option value="wagered" <?php if($sorted_by == 'wagered') echo 'selected';?>>Wagered</option>
								<option value="registered_time" <?php if($sorted_by == 'registered_time') echo 'selected';?>>Registered</option>
								<option value="accessed_time" <?php if($sorted_by == 'accessed_time') echo 'selected';?>>Accessed</option>
							</select>
						</div>
						<div class="input-group" style="margin: 20px auto 0px; height: 45px; max-width: 800px; font-size: 14px">
							<span class="input-group-addon" style="border-radius: 0px;  padding: 14px 13.5px"><i class="fas fa-sort"></i></span>
							<select name="o" class="form-control" style="height: 45px;">
								<option value="DESC">Order</option>
								<option value="DESC" <?php if($search_order == 'DESC') echo 'selected';?>>DESC</option>
								<option value="ASC" <?php if($search_order == 'ASC') echo 'selected';?>>ASC</option>
							</select>
						</div>
						 <!--group feature-->
						<div class="input-group" style="margin: 20px auto 0px; height: 45px; max-width: 800px; font-size: 14px">
							
							<span class="input-group-addon" style="border-radius: 0px;  padding: 14px 13.5px"><i class="fas fa-users-class"></i></span>
							<select id="groupDropdown" name="g" class="form-control" style="height: 45px;">
								<option value="0">Group</option>
								<?php foreach ($all_groups as $group): ?>
									<option <?php if($get_group == $group->group_id) echo 'selected';?> value="<?=$group->group_id ?>"><?= htmlspecialchars($group->group_name)?></option>
								<?php endforeach; ?>
							</select>
							<span class="input-group-addon" id="create_group" style="border-radius: 0px;  padding: 14px 13.5px" data-toggle="modal" data-target="#addGroupModal"><i class="fas fa-plus-circle"></i></span>
							<span class="input-group-addon" id="delete_group" style="border-radius: 0px;  padding: 14px 13.5px; display: none" onclick="process_delete_group()"><i class="fas fa-trash-alt"></i></span>
						</div>
						<!-- Modal for adding group -->
						 <!--group feature-->
						<div class="input-group" style="margin: 20px auto 0px; height: 45px; font-size: 14px">
							<input class="btn btn-info" style="width: 200px; padding: 10px;" type="submit" value="Search">
						</div>
					</form>
					 <!--group feature-->
					<div class="modal fade" id="addGroupModal" tabindex="-1" role="dialog" aria-labelledby="addGroupModalLabel" aria-hidden="true">
						<div class="modal-dialog" role="document" style="text-align: left">
							<div class="modal-content">
								<div class="modal-header">
									<h5 class="modal-title" id="addGroupModalLabel">Create Group</h5>
								</div>
								<div class="modal-body">
									<div class="form-group">
										<label for="group_name">Group Name</label>
										<input type="text" name="group_name" id="group_name" class="form-control" required>
									</div>
									<div class="form-group">
										<label for="group_description">Description</label>
										<textarea name="group_description" id="group_description" class="form-control" rows="3"></textarea>
									</div>
								</div>
								<div class="modal-footer">
									<button type="button" class="btn btn-success" onclick="process_create_group()">Create</button>
									<button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
								</div>
							</div>
						</div>
					</div>
					 <!--group feature-->
					 
					<?php if($referrer != 0):?>
					<div style="margin-top: 30px; font-weight: bold; font-size: 15px">REGISTERED USERS</div>
					<label for="registerStartDate">Start:</label>
					<input type="date" id="registerStartDate" style="border-radius: 2px; border: 1px solid #DDD; background: #EFEFEF" id="cashflowStartDate">
					<label for="registerEndDate">Start:</label>
					<input type="date" id="registerEndDate" style="border-radius: 2px; border: 1px solid #DDD; background: #EFEFEF" id="cashflowStartDate">
					<label for="registerGroupMode">Group by:</label>
					<select id="registerGroupMode" style="border-radius: 2px; border: 1px solid #DDD; background: #EFEFEF" id="cashflowStartDate">
						<option value="day">Day</option>
						 <!--<option value="week">Week</option>-->
						<option value="month">Month</option>
					</select>
					<button onclick="loadRegisterChart()" class="btn btn-info">View Chart</button>
					<div style="width: 100%; max-width: 800px; margin: 0px auto">
						<canvas id="registerChart"></canvas>
					</div>
					<?php endif?>
					
					
					<?php if(intval($referrer) != 0 || intval($get_group) != 0):?>
					<div style="margin-top: 30px; font-weight: bold; font-size: 15px">CASH FLOW</div>
					<!-- Date filters for cashflow chart -->
					<label for="cashflowStartDate">Start:</label>
					<input type="date" style="border-radius: 2px; border: 1px solid #DDD; background: #EFEFEF" id="cashflowStartDate">

					<label for="cashflowEndDate">End:</label>
					<input type="date" style="border-radius: 2px; border: 1px solid #DDD; background: #EFEFEF" id="cashflowEndDate">

					<label for="cashflowGroupMode">Group by:</label>
					<select id="cashflowGroupMode" style="border-radius: 2px; border: 1px solid #DDD; background: #EFEFEF">
					  <option value="day">Day</option>
					  <!--<option value="week">Week</option>-->
					  <option value="month">Month</option>
					</select>
					
					<label for="cashflowUnit">Unit:</label>
					<select id="cashflowUnit" style="border-radius: 2px; border: 1px solid #DDD; background: #EFEFEF">
					  <option value="BNB">BNB</option>
					  <option value="USD">USD</option>
					</select>
					<button onclick="loadCashflowChart()" class="btn btn-info">View Chart</button>
					<!-- Chart container -->
					<div style="width: 100%; max-width: 800px; margin: 0px auto">
						<canvas id="cashflowChart"></canvas>
					</div>
					<?php endif?>
					
					<div style="margin-bottom:10px">
						<div style="float:left;margin-right:10px;font-weight:bold;margin-bottom:10px;font-size:15px">Show columns:</div>
						<div style="clear:both;margin-left:10px;font-size:14px">
							<?php 
								$show_user_data = $admin_settings['show_user_data'];
								foreach($show_user_data as $key => $checked) {
									if($checked) {
										$checked = 'checked';
									} else {
										$checked = '';
									}
									echo '<div style="float:left;margin-right:15px"><input type="checkbox" class="show_user_data" id="'.$key.'" data-key="'.$key.'" '.$checked.'><label for="'.$key.'" style="float:left;margin-right:5px;font-size:14px">'.ucfirst(str_replace('user ', '', (str_replace(' time', '', str_replace('total ', '', str_replace('_', ' ', str_replace('show_', '', $key))))))).'</label></div>';
								}
							
							?>
						</div>
					</div>
					
					<!--//handle_selected_users-->
					<div style="width: 200px; margin: auto; margin-top: 50px">
						<select style="width: 200px; float: right; border: 1px solid #ccc; border-radius: 3px; height: 35px; margin-top: 10px; padding-left: 10px;" id="mult_actions">
							<option value="cashback">Cashback</option>
							<option value="ban">Ban</option>
							<option value="disable_payout">Disable Payout</option>
							<option value="disable_survey">Disable Survey</option>
							<option value="enable_stamina">Enable Stamina</option>
							<option value="add_to_group">Add to group</option>
						</select>
						
						<select id="add_to_group" style="width: 200px; float: right; border: 1px solid #ccc; border-radius: 3px; height: 35px; margin-top: 10px; padding-left: 10px; display: none">
							<?php foreach ($all_groups as $group): ?>
								<option value="<?=$group->group_id?>"><?= htmlspecialchars($group->group_name)?></option>
							<?php endforeach; ?>
						</select>
						
						
						<button class="btn btn-warning" style="width: 200px; margin-top: 10px" id="handle_selected_users" onclick="process_handle_selected_users()">Handle selected users</button>
					</div>
					<!--//handle_selected_users-->
					
					<div style="width: 100%; overflow-x: auto; margin: 100px auto 0px">
						<table class="table table-striped bets_table">
							<thead>
								<tr>
									<?php
										echo '<td>UserID</td>';
										echo '<td>Level</td>';
										if($sorted_by == 'profit' || $sorted_by == 'temp_bet_balance') {
											echo '<td>Profit</td>';
										}
										if($sorted_by == 'temp_bet_balance') {
											echo '<td>Temp profit</td>';
										}
										$cnt_columns = 1; 
										foreach($show_user_data as $key => $checked) {
											if($checked) {
												echo '<td>'.ucfirst(str_replace('user ', '', (str_replace(' time', '', str_replace('total ', '', str_replace('_', ' ', str_replace('show_', '', $key))))))).'</td>'; 
												$cnt_columns++;
											}
										}
										echo '<td>Ban</td>';
										//handle_selected_users
										echo '<td><input type="checkbox" id="select_all_users"/></td>';
										//handle_selected_users
									?>
								</tr>
							</thead>
							<tbody>
								<?php
									if(is_array($users) && sizeof($users) > 0) {
										foreach($users as $row) {
											echo '<tr>';
											echo '<td><a href="'.base_url().'adm/profile.php?uid='.$row->user_id.'">'.$row->user_id.'</a></td>';
											echo '<td>'.$row->user_level.'</td>';
											if($sorted_by == 'profit' || $sorted_by == 'temp_bet_balance') {
												if($row->profit > 0) {
													echo '<td style="color: #4caf50">'.number_format($row->profit / 100000000, 8).'</td>'; 
												} else {
													echo '<td style="color: red">'.number_format($row->profit / 100000000, 8).'</td>'; 
												}
											}
											if($sorted_by == 'temp_bet_balance') {
												if($row->temp_profit > 0) {
													echo '<td style="color: #4caf50">'.number_format($row->temp_profit / 100000000, 8).'</td>'; 
												} else {
													echo '<td style="color: red">'.number_format($row->temp_profit / 100000000, 8).'</td>'; 
												}
											}
											foreach($show_user_data as $key => $checked) {
												if($checked) {
													$key = str_replace('show_', '', $key);
													if($key == 'user_name') {
														echo '<td>';
														if($row->auto_payout == 1) {
															echo '<i class="fas fa-badge-check" style="color: #8bc34a; margin-right: 5px"></i>';
														}
														echo '<a href="'.base_url().'adm/profile.php?uid='.$row->user_id.'">'.$row->$key.'</a>';
														echo '</td>';
													} else if ($key == 'country') {
														echo '<td><a href="'.base_url().'adm/users.php?k='.$row->$key.'">'.$row->$key.'</a></td>'; 
													} else if ($key == 'referrer') {
														echo '<td>'; 
														echo '<a href="'.base_url().'adm/profile.php?uid='.$row->referrer.'">'.$row->referrer.'</a>';
														echo '</td>';
													} else if ($key == 'user_email') {
														echo '<td>';
														echo $row->user_email;
														if($row->email_verification) echo ' <i class="fas fa-check"></i>';
														echo '</td>';
													} else {
														echo '<td>'.$row->$key.'</td>'; 
													}
												}
											}
											if($row->banned) {
												echo '<td><a href="javascript: void(0)" class="change_user_status banned" data-uid="'.$row->user_id.'" style="color: red"><i class="fas fa-ban"></i></a></td>';
											} else {
												echo '<td><a href="javascript: void(0)" class="change_user_status" data-uid="'.$row->user_id.'"  style="color: green"><i class="fas fa-user-check"></i></a></td>';
											}
											//handle_selected_users
											echo '<td><input type="checkbox" class="select_user" value="'.$row->user_id.'"/></td>';
											//handle_selected_users
											echo '</tr>';
											echo '</tr>';
										}
										
									} else {
										echo '<tr><td colspan="'.$cnt_columns.'">No users found</td></tr>';
									}
								?>
							</tbody>
						</table>
						<?php if($pagination != '') echo '<div class="pagination">'.$pagination.'</div>';?>
					</div>
			   </div>
			</div>
		</section>
		<?php include('scripts.php');?>
		<script>
			$(".show_user_data").change(function() {
				var key = $(this).attr('data-key');
				var val = Number($(this).prop("checked")).toString();
				$.ajax({
					url: "<?=base_url()?>adm/process.php",
					type: "POST",
					data: "action=change_settings&group_settings=show_user_data&key="+key+"&val="+val,
					error: function(){
						$.toast({
							heading: 'Error!',
							text: 'Request timeout!',
							showHideTransition: 'slide',
							position: 'top-right',
							icon: 'error'
						});
					},
					success: function(out){
						obj = JSON.parse(out);
						if(obj.return == 0) {
							$.toast({
								heading: 'Error!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});
						} else {
							$.toast({
								heading: 'Success!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'success'
							});
						}
					}
				});
			});
			
			function process_ban(user_id) {
				var ban_time = 0;
				var reason = '';
				//var r = confirm("Ban user!");
				var r = true;
				if (r == true) {
					$.ajax({
						url: " <?=base_url()?>adm/process.php",
						type: "POST",
						data: "action=ban&ban_object="+user_id+"&ban_time="+ban_time+"&reason="+reason,
						error: function(){
							console.log("Request timed out. Please try again!");
						},
						success: function(out){
							obj = JSON.parse(out);
							if(obj.ret == 0) {
								$.toast({
									heading: 'Error!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'error'
								});
							} else {
								$.toast({
									heading: 'Success!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'success'
								});
								$("[data-uid='"+user_id+"']").addClass('banned');
								$("[data-uid='"+user_id+"']").css('color', 'red');
								$("[data-uid='"+user_id+"']").html('<i class="fas fa-ban"></i>');
							}
						}
					});
				}
			}
			
			function process_unban2(user_id) {
				//var r = confirm("Unban user!");
				var r = true;
				if (r == true) {
					$.ajax({
						url: " <?=base_url()?>adm/process.php",
						type: "POST",
						data: "action=unban2&user_id="+user_id,
						error: function(){
							console.log("Request timed out. Please try again!");
						},
						success: function(out){
							obj = JSON.parse(out);
							if(obj.ret == 0) {
								$.toast({
									heading: 'Error!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'error'
								});
							} else {
								$.toast({
									heading: 'Success!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'success'
								});
								$("[data-uid='"+user_id+"']").removeClass('banned');
								$("[data-uid='"+user_id+"']").css('color', 'green');
								$("[data-uid='"+user_id+"']").html('<i class="fas fa-user-check"></i>');
							}
						}
					});
				}
			}
			
			$('.change_user_status').click(function(){
				var user_id = parseInt($(this).attr('data-uid'));
				if($(this).hasClass('banned')) {
					process_unban2(user_id);
				} else {
					process_ban(user_id);
				}
			});
		</script>
		
		<?php if(intval($referrer) != 0 || intval($get_group) != 0):?>
		<script>
		function setCashflowDefaultDates() {
			const end = new Date();
			const start = new Date();
			start.setDate(end.getDate() - 9);

			const formatDate = date => date.toISOString().split('T')[0];

			document.getElementById('cashflowStartDate').value = formatDate(start);
			document.getElementById('cashflowEndDate').value = formatDate(end);
		}

		function loadCashflowChart() {
			const start = document.getElementById('cashflowStartDate').value;
			const end = document.getElementById('cashflowEndDate').value;
			const groupMode = document.getElementById('cashflowGroupMode').value;
			const unit = document.getElementById('cashflowUnit').value;

			if (!start || !end) {
				alert('Please select both start and end dates.');
				return;
			}
			<?php if(intval($get_group) != 0):?>
			fetch(`/adm/load.php?data=cashflow_from_group_by_date_range&group_id=<?=$get_group?>&start=${start}&end=${end}&group_mode=${groupMode}&unit=${unit}`)
			<?php else:?>
			fetch(`/adm/load.php?data=cashflow_from_referrer_by_date_range&referrer=<?=$referrer?>&start=${start}&end=${end}&group_mode=${groupMode}&unit=${unit}`)
			<?php endif?>
				.then(res => res.json())
				.then(data => {
					const labels = data.map(row => row.group_label);
					const deposits = data.map(row => parseFloat(row.deposit));
					const withdrawals = data.map(row => parseFloat(row.withdrawal));
					const profits = data.map((_, i) => deposits[i] - withdrawals[i]);

					const ctx = document.getElementById('cashflowChart').getContext('2d');
					if (window.cashflowChartInstance) window.cashflowChartInstance.destroy();

					window.cashflowChartInstance = new Chart(ctx, {
						type: 'line',
						data: {
							labels,
							datasets: [
								{ label: 'Deposit', data: deposits, backgroundColor: '#03a9f46e', borderColor: '#03a9f4', fill: false, borderWidth: 1},
								{ label: 'Withdrawal', data: withdrawals, backgroundColor: '#f443366b', borderColor: '#f44336', fill: false, borderWidth: 1},
								{ label: 'Profit', data: profits, backgroundColor: '#4caf507a', borderColor: '#4CAF50', fill: false, borderWidth: 1}
							]
						},
						options: {
							responsive: true,
							scales: {
								y: { beginAtZero: true }
							}
						}
					});
				});
			
		}
		
		function setCashflowDefaultDatesByGroupMode(mode) {
			const end = new Date();
			const start = new Date();

			switch (mode) {
				case 'month':
					start.setMonth(end.getMonth() - 9); // 10 months
					break;
				case 'week':
					start.setDate(end.getDate() - 7 * 9); // 10 weeks
					break;
				case 'day':
				default:
					start.setDate(end.getDate() - 9); // 10 days
					break;
			}

			const formatDate = date => date.toISOString().split('T')[0];

			document.getElementById('cashflowStartDate').value = formatDate(start);
			document.getElementById('cashflowEndDate').value = formatDate(end);
		}
		
		document.getElementById('cashflowGroupMode').addEventListener('change', function () {
			const mode = this.value;
			setCashflowDefaultDatesByGroupMode(mode);
			loadCashflowChart();
		});
		
		document.getElementById('cashflowUnit').addEventListener('change', function () {
			loadCashflowChart();
		});
		setCashflowDefaultDates();
		loadCashflowChart();
		</script>
		<?php endif?>
		
		<?php if($referrer != 0):?>
		<script>
		function setRegisterDefaultDates() {
			const end = new Date();
			const start = new Date();
			start.setDate(end.getDate() - 9);

			const formatDate = date => date.toISOString().split('T')[0];

			document.getElementById('registerStartDate').value = formatDate(start);
			document.getElementById('registerEndDate').value = formatDate(end);
		}

		function loadRegisterChart() {
			const start = document.getElementById('registerStartDate').value;
			const end = document.getElementById('registerEndDate').value;
			const groupMode = document.getElementById('registerGroupMode').value;

			if (!start || !end) {
				alert('Please select both start and end dates.');
				return;
			}

			fetch(`/adm/load.php?data=registered_users_by_referrer_range&referrer=<?=$referrer?>&start=${start}&end=${end}&group_mode=${groupMode}`)
				.then(res => res.json())
				.then(data => {
					const labels = data.map(row => row.group_label);
					const totals = data.map(row => parseInt(row.total_registered));

					const ctx = document.getElementById('registerChart').getContext('2d');
					if (window.registerChartInstance) window.registerChartInstance.destroy();

					window.registerChartInstance = new Chart(ctx, {
						type: 'bar',
						data: {
							labels,
							datasets: [
								{ 
									label: 'Total Registered Users', 
									data: totals, 
									backgroundColor: '#03a9f4', 
									borderColor: '#0288d1', 
									borderWidth: 1 
								}
							]
						},
						options: {
							responsive: true,
							scales: {
								y: { beginAtZero: true }
							}
						}
					});
				});
		}

		function setRegisterDefaultDatesByGroupMode(mode) {
			const end = new Date();
			const start = new Date();

			switch (mode) {
				case 'month':
					start.setMonth(end.getMonth() - 9); // 10 months
					break;
				case 'week':
					start.setDate(end.getDate() - 7 * 9); // 10 weeks
					break;
				case 'day':
				default:
					start.setDate(end.getDate() - 9); // 10 days
					break;
			}

			const formatDate = date => date.toISOString().split('T')[0];

			document.getElementById('registerStartDate').value = formatDate(start);
			document.getElementById('registerEndDate').value = formatDate(end);
		}

		document.getElementById('registerGroupMode').addEventListener('change', function () {
			const mode = this.value;
			setRegisterDefaultDatesByGroupMode(mode);
			loadRegisterChart();
		});

		setRegisterDefaultDates();
		loadRegisterChart();
		</script>
		
		<?php endif?>
		
		<script>
		//handle_selected_users
		$(document).ready(function() {
			$('#select_all_users').click(function () { 
				$('.select_user').prop('checked', this.checked);    
			});
		});
		
		function process_handle_selected_users() {
			var r = confirm("Are you sure?");
			if (r == true) {
				var users = [];
				var action2 = $('#mult_actions').val();
				var group_id = $('#add_to_group').val();
				$('input.select_user:checkbox:checked').each(function () {
					var user_id = $(this).val();
					users.push(user_id);
				});
				$.ajax({
					url: " <?=base_url()?>adm/process.php",
					type: "POST",
					data: "action=handle_selected_users&action2="+action2+"&users="+users+"&group_id="+group_id,
					error: function(){
						console.log("Request timed out. Please try again!");
					},
					success: function(out){
						obj = JSON.parse(out);
						if(obj.ret == 0) {
							$.toast({
								heading: 'Error!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});
						} else {
							$.toast({
								heading: 'Success!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'success'
							});
							setTimeout(function() {
								window.location.reload();
							}, 500);
						}
					}
				});
			}
		}
		//handle_selected_users
		</script>
		
		
		<script>
		//group feature
		function process_create_group() {
			var group_name = $('#group_name').val();
			var group_description = $('#group_description').val();

			$.ajax({
				url: "<?= base_url('adm/process.php') ?>",
				type: "POST",
				data: {
					action: 'create_group',
					group_name: group_name,
					group_description: group_description
				},
				timeout: 10000,
				error: function() {
					console.log("Request timed out. Please try again!");
				},
				success: function(out) {
					let obj;
					try {
						obj = JSON.parse(out);
					} catch (e) {
						console.error("Invalid JSON:", out);
						return;
					}

					if (obj.ret == 0) {
						$.toast({
							heading: 'Error!',
							text: obj.mes,
							showHideTransition: 'slide',
							position: 'top-right',
							icon: 'error'
						});
					} else {
						$.toast({
							heading: 'Success!',
							text: obj.mes,
							showHideTransition: 'slide',
							position: 'top-right',
							icon: 'success'
						});

						$('#addGroupModal').modal('hide');
						// Optionally refresh dropdown
						$('#groupDropdown').append(
							 $('<option>', {
								value: obj.group_id,
								text: obj.group_name
							})
						);
						$('#add_to_group').append(
							 $('<option>', {
								value: obj.group_id,
								text: obj.group_name
							})
						);
					}
				}
			});
		}
		
		function process_delete_group() {
			var r = confirm("Are you sure?");
			if (r == true) {
				var group_id = $('#groupDropdown').val();
				$.ajax({
					url: "<?= base_url('adm/process.php') ?>",
					type: "POST",
					data: {
						action: 'delete_group',
						group_id: group_id,
					},
					timeout: 10000,
					error: function() {
						console.log("Request timed out. Please try again!");
					},
					success: function(out) {
						let obj;
						try {
							obj = JSON.parse(out);
						} catch (e) {
							console.error("Invalid JSON:", out);
							return;
						}

						if (obj.ret == 0) {
							$.toast({
								heading: 'Error!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});
						} else {
							$.toast({
								heading: 'Success!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'success'
							});
							const dropdown = $('#groupDropdown');
							dropdown.empty();
							dropdown.append('<option value="0">Group</option>'); // Default option

							obj.groups.forEach(function(group) {
								dropdown.append(
									$('<option>', {
										value: group.group_id,
										text: group.group_name
									})
								);
							});
							$('#create_group').show();
							$('#delete_group').hide();
							const dropdown2 = $('#add_to_group');
							dropdown2.empty();
							obj.groups.forEach(function(group) {
								dropdown2.append(
									$('<option>', {
										value: group.group_id,
										text: group.group_name
									})
								);
							});
							
						}
					}
				});
			}
		}
		
		$('#groupDropdown').on('change', function() {
			var group_id = $(this).val();
			if (group_id == '0') {
				$('#create_group').show();
				$('#delete_group').hide();
			} else {
				$('#create_group').hide();
				$('#delete_group').show();
			}
		});
		
		$('#mult_actions').on('change', function() {
			var action = $(this).val();
			if (action == 'add_to_group') {
				$('#add_to_group').show();
			} else {
				$('#add_to_group').hide();
			}
		});
		
		</script>
		
	</body>
</html>