<!DOCTYPE html>
<html lang="en">
	<?php include('header.php');?>
	<style>
		input[type="checkbox"] {
			-webkit-appearance: auto;
		}
	</style>
	<?php if(isset($user_info) && $user_info->dark_mode == 1):?>
	<body class="dark_mode">
	<?php else:?>
	<body>
	<?php endif?>
		<?php include('menu.php');?>
		<section class="get_form_nine_area p_100">
			<div class="container">
				<div class="single_title_n">
					<h2>User Statistics</h2>
					<form style="margin: 20px auto;" method="GET">
						<!-- Select search key (k) -->
						<div class="input-group" style="margin: 20px auto 0; height: 45px; max-width: 800px; font-size: 14px;">
							<span class="input-group-addon" style="border-radius: 0; padding: 14px 13.5px;">
								<i class="fas fa-filter"></i>
							</span>
							<select name="k" class="form-control" style="height: 45px;">
								<?php
								// Define search key options
								$keys = [
									'profit' => 'Profit',
									'net_flow' => 'Net flow',
									'wagering_contest' => 'Wagering contest',
									'referral_contest' => 'Referral contest',
									'deposit' => 'Deposit',
									'withdrawal' => 'Withdrawal',
									'bonus' => 'Bonus',
									'referral' => 'Referral',
									'survey' => 'Survey'
								];
								// Render each option with selected attribute if matched
								foreach ($keys as $key => $label) {
									echo '<option value="' . $key . '"' . ($search_key == $key ? ' selected' : '') . '>' . $label . '</option>';
								}
								?>
							</select>
						</div>

						<!-- Select time range (t) -->
						<div class="input-group" style="margin: 20px auto 0; height: 45px; max-width: 800px; font-size: 14px;">
							<span class="input-group-addon" style="border-radius: 0; padding: 14px 13.5px;">
								<i class="fas fa-calendar-check"></i>
							</span>
							<select name="t" class="form-control" style="height: 45px;">
								<!-- Time options will be dynamically populated by JavaScript -->
							</select>
						</div>

						<!-- Select sort order (o) -->
						<div class="input-group" style="margin: 20px auto 0; height: 45px; max-width: 800px; font-size: 14px;">
							<span class="input-group-addon" style="border-radius: 0; padding: 14px 13.5px;">
								<i class="fas fa-sort-amount-up-alt"></i>
							</span>
							<select name="o" class="form-control" style="height: 45px;">
								<option value="DESC" <?= ($sort_order == 'DESC') ? 'selected' : '' ?>>DESC</option>
								<option value="ASC" <?= ($sort_order == 'ASC') ? 'selected' : '' ?>>ASC</option>
							</select>
						</div>

						<!-- Submit button -->
						<div class="input-group" style="margin: 20px auto 0; height: 45px; font-size: 14px;">
							<input class="btn btn-info" style="width: 200px; padding: 10px;" type="submit" value="Search">
						</div>
					</form>
					<div style="width: 100%; overflow-x: auto; margin: 100px auto 0px">
						<table class="table table-striped bets_table">
							<thead>
								<tr>
									<?php
										if($users != null) {
											echo '<tr>';
											foreach($users[0] as $column => $data) {
												echo '<td>'.ucfirst($column).'</td>';
											}
											if($search_key == 'profit' || (($search_key == 'wagering_contest' || $search_key == 'referral_contest')) && $during == 'last_week') {
												echo '<td>Action</td>';
											}
											echo '</tr>';
										}
									?>
								</tr>
							</thead>
							<tbody>
								<?php
									if($users != null) {
										foreach($users as $row) {
											echo '<tr data-uid="'.$row->user_id.'">';
											foreach($row as $column => $data) {
												if($column == 'user_id' || $column == 'referrer') {
													echo '<td><a href="'.base_url().'adm/profile.php?uid='.$data.'">'.$data.'</a></td>';
												} else if($column == 'temp_profit') {
													if($data > 0) {
														echo '<td><span style="color: #4caf50">'.$data.'</span></td>';
													} else {
														echo '<td><span style="color: red">'.$data.'</span></td>';
													}
												} else if($column == 'all_time' || $column == 'period_time') {
													if($data > 0) {
														echo '<td><span style="color: #4caf50">'.$data.'</span></td>';
													} else {
														echo '<td><span style="color: red">'.$data.'</span></td>';
													}
												} else if($column == 'paid') {
													if($data == 1) {
														echo '<td><span style="color: #4caf50">Yes</span></td>';
													} else {
														echo '<td><span style="color: #333">No</span></td>';
													}
												} else {
													echo '<td>'.$data.'</td>';
												}
											}
											if($search_key == 'profit') {
												echo '<td ><a href="javascript:void(0)" onclick="process_reset_temp_profit('.$row->user_id.')">Reset</a> | <a href="javascript:void(0)" onclick="process_reset_and_pay_cashback('.$row->user_id.')">Bonus and Reset</a></td>';
											} else if (($search_key == 'wagering_contest' || $search_key == 'referral_contest') && $during == 'last_week') {
												echo '<td ><a href="javascript:void(0)" onclick="process_reset_temp_profit('.$row->user_id.')">Reset</a> | <a href="javascript:void(0)" onclick="process_pay_contest_reward('.$row->user_id.', `'.$search_key.'`)">Pay reward</a></td>';
											}
											echo '</tr>';
										}
									}
								?>
							</tbody>
						</table>
						<?php if($pagination != '') echo '<div class="pagination">'.$pagination.'</div>';?>
					</div>
			   </div>
			</div>
		</section>
		<?php include('scripts.php');?>
		<script>
		function process_reset_temp_profit(user_id) {
			$.ajax({
				url: " <?=base_url()?>adm/process.php",
				type: "POST",
				data: "action=reset_temp_profit&user_id="+user_id,
				error: function(){
					console.log("Request timed out. Please try again!");
				},
				success: function(out){
					obj = JSON.parse(out);
					if(obj.ret == 0) {
						$.toast({
							heading: 'Error!',
							text: obj.mes,
							showHideTransition: 'slide',
							position: 'top-right',
							icon: 'error'
						});
					} else {
						$.toast({
							heading: 'Success!',
							text: obj.mes,
							showHideTransition: 'slide',
							position: 'top-right',
							icon: 'success'
						});
						$("[data-uid='"+user_id+"']").css('background', 'rgb(158 158 158 / 22%)');
					}
				}
			});
		}

		function process_reset_and_pay_cashback(user_id) {
			$.ajax({
				url: " <?=base_url()?>adm/process.php",
				type: "POST",
				data: "action=reset_and_pay_cashback&user_id="+user_id,
				error: function(){
					console.log("Request timed out. Please try again!");
				},
				success: function(out){
					obj = JSON.parse(out);
					if(obj.ret == 0) {
						$.toast({
							heading: 'Error!',
							text: obj.mes,
							showHideTransition: 'slide',
							position: 'top-right',
							icon: 'error'
						});
					} else {
						$.toast({
							heading: 'Success!',
							text: obj.mes,
							showHideTransition: 'slide',
							position: 'top-right',
							icon: 'success'
						});
						$("[data-uid='"+user_id+"']").css('background', 'rgb(158 158 158 / 22%)');
					}
				}
			});
		}

		function process_pay_contest_reward(user_id, contest) {
			$.ajax({
				url: " <?=base_url()?>adm/process.php",
				type: "POST",
				data: "action=pay_contest_reward&user_id="+user_id+"&contest="+contest,
				error: function(){
					console.log("Request timed out. Please try again!");
				},
				success: function(out){
					obj = JSON.parse(out);
					if(obj.ret == 0) {
						$.toast({
							heading: 'Error!',
							text: obj.mes,
							showHideTransition: 'slide',
							position: 'top-right',
							icon: 'error'
						});
					} else {
						$.toast({
							heading: 'Success!',
							text: obj.mes,
							showHideTransition: 'slide',
							position: 'top-right',
							icon: 'success'
						});
						$("[data-uid='"+user_id+"']").css('background', 'rgb(158 158 158 / 22%)');
					}
				}
			});
		}
		
		$(document).ready(function() {
			// Define all available time options
			const options = {
				today: "Today",
				this_week: "This week",
				last_week: "Last week",
				last_30_days: "Last 30 days",
				this_year: "This year",
				all: "All"
			};

			const duringDefault = "<?= $during ?>"; // Get default selected time range from PHP

			// Function to update available time options based on selected search key
			function updateTimeOptions(selectedK) {
				let allowedOptions = [];

				if (selectedK === 'profit') {
					allowedOptions = ['all'];
				} else if (selectedK === 'wagering_contest' || selectedK === 'referral_contest') {
					allowedOptions = ['this_week', 'last_week'];
				} else {
					allowedOptions = Object.keys(options);
				}

				const $tSelect = $('select[name="t"]');
				$tSelect.empty(); // Clear current options

				// Append only allowed options
				allowedOptions.forEach(function(key) {
					const selected = (key === duringDefault) ? 'selected' : '';
					$tSelect.append('<option value="' + key + '" ' + selected + '>' + options[key] + '</option>');
				});
			}

			// Event: when search key changes
			$('select[name="k"]').on('change', function() {
				const selectedK = $(this).val();
				updateTimeOptions(selectedK);
			});

			// Initialize time options when page is loaded
			updateTimeOptions($('select[name="k"]').val());
		});
		
		</script>
	</body>
</html>