<!DOCTYPE html>
<html lang="en">
	<?php include('header.php');?>
	<?php if(isset($user_info) && $user_info->dark_mode == 1):?>
	<body class="dark_mode">
	<?php else:?>
	<body>
	<?php endif?>
		<?php include('menu.php');?>
		<section class="get_form_nine_area p_100">
            <div class="container">
               	<div class="single_title_n">
               		<h2>Profile</h2>
					<table class="history_tbl" style="max-width: 800px; margin: 20px auto">
						<thead><tr><th class="top_header" colspan="7" style="background: #8bc34a; border: none">USER INFORMATION</th></tr></thead>
						<tbody>
							<tr class="history_row">
								<td style="min-width: 150px">EMAIL</td>
								<td>
									<a href="<?=base_url()?>adm/messages.php?email=<?=$get_user_info->user_email?>"><?=$get_user_info->user_email?></a>
									<?php if($get_user_info->email_verification) {echo ' <i class="fas fa-check"></i>';} echo '<br/><a href="javascript:void(0)" onclick="correct_email('.$get_user_info->user_id.', `'.$get_user_info->user_email.'`)" style="color: red">[Correct]</a>';?>
								</td>
							</tr>
							<tr class="history_row"><td>NAME</td><td><?php if($get_user_info->accessed_time > time() - 300):?><i style="color: #8BC34A" class="fas fa-user-check"></i> <?php endif?><?=$get_user_info->user_name?></td></tr>
							<tr class="history_row"><td>IP</td>
							<td>
								<?php 
									if($get_all_ips != null) {
										foreach($get_all_ips as $row) {
											echo '<a href="'.base_url().'adm/users.php?k='.$row->ip.'">'.$row->ip.'</a>';
										}
									} else {
										echo '<a href="'.base_url().'adm/users.php?k='.$get_user_info->ip_address.'">'.$get_user_info->ip_address.'</a>';
									}
								
								?>
							</td>
							</tr>
							<tr class="history_row"><td>RELEVANT USERS</td><td><a href="<?=base_url()?>adm/users.php?k=fp%3D<?=$get_user_info->user_token?>"><?=$get_user_info->user_token?> (<?=$get_relevant_users?>)</a></td></tr>
							<tr class="history_row"><td>PASSWORD</td><td><a href="<?=base_url()?>adm/users.php?k=pw%3D<?=$get_user_info->password?>"><?=$get_user_info->password?> (<?=$users_same_password?>)</a></td></tr>
							<tr class="history_row"><td>2FA ENABLED</td><td><?=(($get_user_info->enable_2fa) ? 'Yes' : 'No')?></td></tr>
							<tr class="history_row"><td>DEPOSIT ADDRESS</td><td><a href="https://bscscan.com/address/<?=$deposit_address?>"><?=$deposit_address?></a></td></tr>
							<tr class="history_row"><td>LOG</td><td>(<?=$get_user_log_data[0]?>, <?=$get_user_log_data[1]?>)</td></tr>
							<tr class="history_row"><td>REFERRER</td><td><a href="<?=base_url()?>adm/profile.php?uid=<?=$get_user_info->referrer?>"><?=$get_user_info->referrer?></a> | <a style="color: #f44336" href="javascript: void(0)" onclick="changeReferrer(<?=$get_user_info->user_id?>, <?=$get_user_info->referrer?>)">Change referrer</a></td></tr>
							
							<!-- group feature -->
							<?php if(is_array($user_groups) && count($user_groups) > 0):?>
							<tr class="history_row">
								<td>GROUPS</td>
								<td>
									<?php foreach ($user_groups as $group): ?>
										<a href="<?=base_url()?>adm/users.php?g=<?=$group->group_id?>"><?=htmlspecialchars($group->group_name)?></a> <i onclick="remove_user_from_group(<?=$get_user_info->user_id?>, <?=$group->group_id?>)" style="color: #f44336; cursor: pointer" class="fas fa-times-circle"></i> <br/>
									<?php endforeach; ?>
								</td>
							</tr>
							<?php endif?>
							<?php if(is_array($groups_not_joined) && count($groups_not_joined) > 0):?>
							<tr class="history_row">
								<td>ADD TO GROUP</td>
								<td>
									<select id="add_to_group" style="width: 200px; border: 1px solid #ccc; border-radius: 3px; height: 35px; margin: 5px; padding-left: 10px; background: #FFF">
										<?php foreach ($groups_not_joined as $group): ?>
											<option value="<?=$group->group_id ?>"><?= htmlspecialchars($group->group_name)?></option>
										<?php endforeach; ?>
									</select>
									<button class="btn btn-info" onclick="add_user_to_group()">Add</button>
								</td>
							</tr>
							<?php endif?>
							<!-- group feature -->
							
							<tr class="history_row"><td>COUNTRY</td><td><a href="<?=base_url()?>adm/users.php?k=<?=GeoIp2CountryIsoCode($get_user_info->ip_address)?>"><?=GeoIp2Country($get_user_info->ip_address)?></a></td></tr>
							<tr class="history_row"><td>LANGUAGE</td><td><a href="<?=base_url()?>adm/users.php?k=lang%3D<?=$get_user_info->language?>"><?=$get_user_info->language?></a></td></tr>
							<tr class="history_row"><td>LEVEL</td><td><?=$get_user_info->user_level?></td></tr>
							<tr class="history_row"><td>REGISTERED DATE</td><td><?=date('Y-m-d H:i:s', $get_user_info->registered_time)?></td></tr>
							<tr class="history_row"><td>LAST ACCESSED </td><td><?=date('Y-m-d H:i:s', $get_user_info->accessed_time)?></td></tr>
							<tr class="history_row"><td>LAST FAUCET CLAIM </td><td><?=date('Y-m-d H:i:s', $get_user_info->last_claim_faucet_time)?></td></tr>
							<tr class="history_row"><td>LAST BET </td><td><?=date('Y-m-d H:i:s', $get_user_info->last_bet_time)?></td></tr>
							<tr class="history_row"><td>TOTAL WAGERED</td><td><?=number_format($get_user_info->wagered  / 100000000, 8, '.', '')?> BNB</td></tr>
							<tr class="history_row">
								<td>BALANCE</td>
								<td>
									<?php
										$balance = $get_user_info->balance;
										$expected_balance = $get_user_info->total_deposits + $get_user_info->total_bonuses + $total_faucet_rewards + $get_user_info->total_survey_rewards + $get_user_info->amount_wins - $get_user_info->amount_losses - $get_user_info->total_withdrawals - $get_user_info->pending_balance;
									?>
									<?=number_format($balance / 100000000, 8, '.', '')?> BNB <br/><?=number_format($expected_balance / 100000000, 8, '.', '')?> BNB
									<?php
										if($balance != $expected_balance) {
											echo '<br/><a href="javascript:void(0)" onclick="process_fix_balance_discrepancy('.$get_user_info->user_id.')">Fix balance discrepancy</a>';
										}
									?>
								</td>
							</tr>
							<tr class="history_row"><td>PROFIT LAST WEEK</td><td><?=$get_profit_lastweek?></td></tr>
							<tr class="history_row"><td>PROFIT LAST WEEK FROM REFERRALS</td><td><?=$get_profit_lastweek_from_referrals?></td></tr>
							<tr class="history_row"><td>GAMES</td><td><?=$get_user_info->bets?></td></tr>
							<tr class="history_row"><td>WINS</td><td><?=$get_user_info->wins?> (<?=number_format($get_user_info->amount_wins / 100000000, 8, '.', '')?> BNB)</td></tr>
							<tr class="history_row"><td>LOSSES</td><td><?=$get_user_info->losses?> (<?=number_format($get_user_info->amount_losses / 100000000, 8, '.', '')?> BNB)</td></tr>
							<tr class="history_row"><td>CLAIMS</td><td><?=$get_user_info->claims?> (<?=number_format($total_faucet_rewards / 100000000, 8, '.', '')?> BNB)<br/><?=($claim_rate ?? number_format(($get_user_info->claims  / ceil(($get_user_info->accessed_time + 1 - $get_user_info->registered_time) / 86400)), 2))?> times/day</td></tr>
							<tr class="history_row"><td>BONUSES</td><td><a href="<?=base_url()?>adm/bonuses.php?uid=<?=$get_user_info->user_id?>"><?=number_format($get_user_info->total_bonuses / 100000000, 8, '.', '')?> BNB</a></td></tr>
							<tr class="history_row"><td>TOTAL DEPOSITS</td><td><a href="<?=base_url()?>adm/deposits.php?uid=<?=$get_user_info->user_id?>"><?=number_format($get_user_info->total_deposits / 100000000, 8, '.', '')?> BNB</a></td></tr>
							<tr class="history_row"><td>TOTAL WITHDRAWALS</td><td><a href="<?=base_url()?>adm/withdrawals.php?uid=<?=$get_user_info->user_id?>"><?=number_format($get_user_info->total_withdrawals / 100000000, 8, '.', '')?> BNB</a></td></tr>
							<tr class="history_row"><td>TOTAL SURVEY REWARDS</td><td><a href="<?=base_url()?>adm/surveys.php?user_id=<?=$get_user_info->user_id?>"><?=number_format($get_user_info->total_survey_rewards / 100000000, 8, '.', '')?> BNB</a> <br/> <span style="color: #ff9800"><?=number_format($get_user_info->uncredited_survey_rewards / 100000000, 8, '.', '')?> BNB</span></td></tr>
							<tr class="history_row"><td>FREE SPINS</td><td><?=$get_user_info->free_spins?></td></tr>
							<tr class="history_row"><td>BAN</td><td><?=$get_user_info->banned?></td></tr>
							<tr class="history_row"><td>REFERRING URL</td><td><?php if($get_user_info->referring_url == '' || $get_user_info->referring_url == 'direct') echo 'direct'; else echo '<a href="'.$get_user_info->referring_url.'">'.$get_user_info->referring_url.'</a>';?></td></tr>
							<tr class="history_row"><td>REFERRALS</td><td><a href="<?=base_url()?>adm/users.php?k=ref%3D<?=$get_user_info->user_id?>"><?=$get_user_info->total_referrals?></a></td></tr>
							
							<tr class="history_row"><td>DISABLE COMMISSION</td><td><?php if($get_user_info->disable_commission == 0) echo '<a href="javascript:void(0)" style="color: red; display: none" id="enable_commission" onclick="enable_commission('.$get_user_info->user_id.')">Disabled</a> <a href="javascript:void(0)" style="color: green" id="disable_commission" onclick="disable_commission('.$get_user_info->user_id.')">Enabled</a>'; else echo '<a href="javascript:void(0)" style="color: red" id="enable_commission" onclick="enable_commission('.$get_user_info->user_id.')">Disabled</a> <a href="javascript:void(0)" style="color: green; display: none" id="disable_commission" onclick="disable_commission('.$get_user_info->user_id.')">Enabled</a>';?></td></tr>
							<tr class="history_row"><td>DISABLE REFERRER COMMISSION</td><td><?php if($get_user_info->disable_referrer_commission == 0) echo '<a href="javascript:void(0)" style="color: red; display: none" id="enable_referrer_commission" onclick="enable_referrer_commission('.$get_user_info->user_id.')">Disabled</a> <a href="javascript:void(0)" style="color: green" id="disable_referrer_commission" onclick="disable_referrer_commission('.$get_user_info->user_id.')">Enabled</a>'; else echo '<a href="javascript:void(0)" style="color: red" id="enable_referrer_commission" onclick="enable_referrer_commission('.$get_user_info->user_id.')">Disabled</a> <a href="javascript:void(0)" style="color: green; display: none" id="disable_referrer_commission" onclick="disable_referrer_commission('.$get_user_info->user_id.')">Enabled</a>';?></td></tr>
							<tr class="history_row"><td>DISABLE PAYOUT</td><td><?php if($get_user_info->disable_payout == 0) echo '<a href="javascript:void(0)" style="color: green" id="disable_payout" onclick="disable_payout('.$get_user_info->user_id.')">Enabled</a> <a href="javascript:void(0)" style="color: red; display: none" id="enable_payout" onclick="enable_payout('.$get_user_info->user_id.')">Disabled</a>'; else echo '<a href="javascript:void(0)" style="color: green; display: none" id="disable_payout" onclick="disable_payout('.$get_user_info->user_id.')">Enabled</a> <a href="javascript:void(0)" style="color: red" id="enable_payout" onclick="enable_payout('.$get_user_info->user_id.')">Disabled</a>';?></td></tr>
							<tr class="history_row"><td>DISABLE SURVEY</td><td><?php if($get_user_info->disable_survey == 0) echo '<a href="javascript:void(0)" style="color: green" id="disable_survey" onclick="disable_survey('.$get_user_info->user_id.')">Enabled</a> <a href="javascript:void(0)" style="color: red; display: none" id="enable_survey" onclick="enable_survey('.$get_user_info->user_id.')">Disabled</a>'; else echo '<a href="javascript:void(0)" style="color: green; display: none" id="disable_survey" onclick="disable_survey('.$get_user_info->user_id.')">Enabled</a> <a href="javascript:void(0)" style="color: red" id="enable_survey" onclick="enable_survey('.$get_user_info->user_id.')">Disabled</a>';?></td></tr>
							<tr class="history_row"><td>AUTO PAYOUT</td><td><?php if($get_user_info->auto_payout == 1) echo '<a href="javascript:void(0)" style="color: green" id="disable_auto_payout" onclick="disable_auto_payout('.$get_user_info->user_id.')">Enabled</a> <a href="javascript:void(0)" style="color: red; display: none" id="enable_auto_payout" onclick="enable_auto_payout('.$get_user_info->user_id.')">Disabled</a>'; else echo '<a href="javascript:void(0)" style="color: green; display: none" id="disable_auto_payout" onclick="disable_auto_payout('.$get_user_info->user_id.')">Enabled</a> <a href="javascript:void(0)" style="color: red" id="enable_auto_payout" onclick="enable_auto_payout('.$get_user_info->user_id.')">Disabled</a>';?></td></tr>
							<tr class="history_row"><td>BLOCK EMAIL</td><td><?php if($is_spammer) {echo '<a href="javascript:void(0)" onclick="process_unblock_sender()" id="process_unblock_sender" style="color: red">Blocked</a> <a href="javascript:void(0)" style="color: green; display: none" onclick="process_block_sender()" id="process_block_sender">Unblocked</a>';} else {echo '<a href="javascript:void(0)" onclick="process_unblock_sender()" id="process_unblock_sender" style="color: red; display: none">Blocked</a> <a href="javascript:void(0)" style="color: green" onclick="process_block_sender()" id="process_block_sender">Unblocked</a>';}?></td></tr>
							<tr class="history_row"><td>FREE FAUCET</td><td><?php if(isset($stamina_enabled) && $stamina_enabled == 1) {echo '<a href="javascript:void(0)" style="color: red" onclick="process_disable_stamina()" id="process_disable_stamina">No</a> <a href="javascript:void(0)" onclick="process_enable_stamina()" id="process_enable_stamina" style="color: green; display: none">Yes</a>';} else {echo '<a href="javascript:void(0)" style="color: red; display: none" onclick="process_disable_stamina()" id="process_disable_stamina">No</a> <a href="javascript:void(0)" onclick="process_enable_stamina()" id="process_enable_stamina" style="color: green">Yes</a>';}?></td></tr>
							
							<?php if($referring_urls != null):?>
							<tr class="history_row"><td>AFFILIATES</td>
								<td>
									<?php 
										foreach($referring_urls as $row) {
											if($row->referring_url == 'direct') {
												echo 'Direct ('.$row->cnt_users.')<br/>';
											} else if($row->referring_url == '') {
												echo 'Undefined ('.$row->cnt_users.')<br/>';
											} else {
												echo '<a href="'.$row->referring_url.'">'.substr($row->referring_url, 0, 50).' ('.$row->cnt_users.')</a><br/>';
											}
										}
									?>
								</td>
							</tr>
							<tr class="history_row"><td>COMMISSION SHARE</td><td><?=$get_user_info->commission_share?>%</td></tr>
							<?php endif?>
							<tr class="history_row">
								<td>ACTIONS</td>
								<td>
									<a href="<?=base_url()?>adm/tickets.php?uid=<?=$get_user_info->user_id?>"><i class="fa fa-envelope"></i> Tickets</a> |
									<a href="<?=base_url()?>adm/bonuses.php?uid=<?=$get_user_info->user_id?>"><i class="fas fa-coins"></i> Send bonus</a> |
									<a href="<?=base_url()?>adm/gifts.php?uid=<?=$get_user_info->user_id?>"><i class="fa fa-gift"></i> Send a gift</a> |
									<a href="<?=base_url()?>adm/bans.php?uid=<?=$get_user_info->user_id?>"><i class="fa fa-ban"></i> Ban user</a> |
									<a href="<?=base_url()?>adm/games.php?uid=<?=$get_user_info->user_id?>"><i class="fas fa-gamepad"></i> Games</a> |
									<a href="<?=base_url()?>adm/notifications.php?uid=<?=$get_user_info->user_id?>"><i class="fas fa-bell"></i> Notify</a>
									<a href="<?=base_url()?>adm/surveys.php?user_id=<?=$get_user_info->user_id?>"><i class="fas fa-poll"></i> Surveys</a>
									<a href="<?=base_url()?>adm/logs.php?s=<?=$get_user_info->user_id?>"><i class="fas fa-shoe-prints"></i> Logs</a>
								</td>
							</tr>
						</tbody>
					</table>
					
					<div style="margin-top: 30px; font-weight: bold; font-size: 15px">CASH FLOW</div>
					<!-- Date filters for cashflow chart -->
					<label for="cashflowStartDate">Start:</label>
					<input type="date" style="border-radius: 2px; border: 1px solid #DDD; background: #EFEFEF" id="cashflowStartDate">

					<label for="cashflowEndDate">End:</label>
					<input type="date" style="border-radius: 2px; border: 1px solid #DDD; background: #EFEFEF" id="cashflowEndDate">

					<label for="cashflowGroupMode">Group by:</label>
					<select id="cashflowGroupMode" style="border-radius: 2px; border: 1px solid #DDD; background: #EFEFEF">
					  <option value="day">Day</option>
					  <!--<option value="week">Week</option>-->
					  <option value="month">Month</option>
					</select>
					
					<label for="cashflowUnit">Unit:</label>
					<select id="cashflowUnit" style="border-radius: 2px; border: 1px solid #DDD; background: #EFEFEF">
					  <option value="BNB">BNB</option>
					  <option value="USD">USD</option>
					</select>
					<button onclick="loadCashflowChart()" class="btn btn-info">View Chart</button>
					<!-- Chart container -->
					<div style="width: 100%; max-width: 800px; margin: 0px auto">
						<canvas id="cashflowChart"></canvas>
					</div>
					
					<div style="width: 100%; overflow-x: auto; margin: 20px auto 0px">
						<table class="table table-striped bets_table">
							<thead>
								<tr>
									<td>Date</td>
									<td>Type</td>
									<td>Amount</td>
									<td>Address</td>
									<td>TxID</td>
									<td>Status</td>
								</tr>
							</thead>
							<tbody>
								<?php
									if(is_array($transactions)) {
										foreach($transactions as $row) {
											echo '<tr>';
											if(date('Y-m-d', $row->time) == date('Y-m-d')) {
												$row->time =  date('H:i:s', $row->time);
											} else {
												$row->time =  date('Y-m-d', $row->time);
											}
											echo '<td>'.$row->time.'</td>';
											echo '<td>'.$row->type.'</td>';
											echo '<td>'.rtrim(number_format($row->amount / 100000000, 8, '.', ''), '0').'</td>';
											echo '<td><a href="'.base_url().'adm/users.php?k='.$row->address.'">'.substr($row->address, 0, 9).'...'.substr($row->address, -9).' <i class="far fa-copy fa-fw js_clipboard" data-copy="'.$row->address.'" style="color: #adb5bd; cursor: pointer" data-toggle="tooltip" title="Copy"></i></a></td>';
											
											if(strlen($row->txid) > 30) {
												if (strpos($row->txid, "1x") !== false) { //BNB on opbnb
													$row->txid = str_replace("1x" , "0x", $row->txid);
													echo '<td><a href="https://opbnbscan.com/tx/'.$row->txid.'">'.substr($row->txid, 0, 8).'...'.substr($row->txid, -8).' <i class="far fa-copy fa-fw js_clipboard" data-copy="'.$row->txid.'" style="color: #adb5bd; cursor: pointer" data-toggle="tooltip" title="Copy"></i></a></td>';
												} else {
													echo '<td><a href="https://bscscan.com/tx/'.$row->txid.'">'.substr($row->txid, 0, 8).'...'.substr($row->txid, -8).' <i class="far fa-copy fa-fw js_clipboard" data-copy="'.$row->txid.'" style="color: #adb5bd; cursor: pointer" data-toggle="tooltip" title="Copy"></i></a></td>';
												}
											} else if($row->txid != ''){
												echo '<td><a style="color: orange" href="'.base_url().'adm/users.php?k=txid='.$row->txid.'">'.$row->txid.' <i class="far fa-copy fa-fw js_clipboard" data-copy="'.$row->txid.'" style="color: #adb5bd; cursor: pointer" data-toggle="tooltip" title="Copy"></i></a></td>';
											} else {
												echo '<td></td>';
											}
											
											if($row->status == 'Completed') {
												echo '<td><span style="color: #4caf50">'.$row->status.'</span></td>';
											} else if($row->status == 'Processing') {
												echo '<td id="req'.$row->id.'"><span style="color: #03A9F4">'.$row->status.'</span></td>';
											} else if($row->status == 'Pending') {
												echo '<td id="req'.$row->id.'">Pending</td>';
											} else if($row->status == 'Unconfirmed') {
												echo '<td id="req'.$row->id.'">Unconfirmed</td>';
											} else {
												echo '<td id="req'.$row->id.'">'.$row->status.'</td>';
											}
											
											echo '</tr>';
										}
									} else {
										echo '<tr><td colspan="6">No requests found</td></tr>';
									}
								?>
							</tbody>
						</table>
						<?php if($pagination != '') echo '<div class="pagination">'.$pagination.'</div>';?>
					</div>
			   </div>
            </div>
        </section>
		<?php include('scripts.php');?>
		<script>
		
			function changeReferrer(user_id, referrer_id) {
				var get_referrer_id = prompt("Please enter referrer ID", referrer_id);
				if (get_referrer_id != null) {
					$.ajax({
						url: " <?=base_url()?>adm/process.php",
						type: "POST",
						data: "action=change_referrer&user_id="+user_id+"&referrer_id="+get_referrer_id,
						error: function(){
							console.log("Request timed out. Please try again!");
						},
						success: function(out){
							obj = JSON.parse(out);
							if(obj.ret == 0) {
								$.toast({
									heading: 'Error!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'error'
								});
							} else {
								$.toast({
									heading: 'Success!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'success'
								});
								setTimeout(function() {
									window.location.reload();
								}, 500);
							}
						}
					});
				}
			}

			function correct_email(user_id, old_email) {
				var new_email = prompt("Please enter new email", old_email);
				if (new_email != null) {
					$.ajax({
						url: " <?=base_url()?>adm/process.php",
						type: "POST",
						data: "action=correct_email&user_id="+user_id+"&old_email="+old_email+"&new_email="+new_email,
						error: function(){
							console.log("Request timed out. Please try again!");
						},
						success: function(out){
							obj = JSON.parse(out);
							if(obj.ret == 0) {
								$.toast({
									heading: 'Error!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'error'
								});
							} else {
								$.toast({
									heading: 'Success!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'success'
								});
								setTimeout(function() {
									window.location.reload();
								}, 500);
							}
						}
					});
				}
			}
		
			function enable_commission(user_id) {
				//var r = confirm("Enabled commissions!");
				var r = true;
				if (r == true) {
					$.ajax({
						url: " <?=base_url()?>adm/process.php",
						type: "POST",
						data: "action=enable_commission&user_id="+user_id,
						error: function(){
							console.log("Request timed out. Please try again!");
						},
						success: function(out){
							obj = JSON.parse(out);
							if(obj.ret == 0) {
								$.toast({
									heading: 'Error!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'error'
								});
							} else {
								$.toast({
									heading: 'Success!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'success'
								});
								/*setTimeout(function() {
									window.location.reload();
								}, 500);*/
								$("#enable_commission").hide();
								$("#disable_commission").show();
							}
						}
					});
				}
			}

			function disable_commission(user_id) {
				//var r = confirm("Disable payout!");
				var r = true;
				if (r == true) {
					$.ajax({
						url: " <?=base_url()?>adm/process.php",
						type: "POST",
						data: "action=disable_commission&user_id="+user_id,
						error: function(){
							console.log("Request timed out. Please try again!");
						},
						success: function(out){
							obj = JSON.parse(out);
							if(obj.ret == 0) {
								$.toast({
									heading: 'Error!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'error'
								});
							} else {
								$.toast({
									heading: 'Success!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'success'
								});
								/*setTimeout(function() {
									window.location.reload();
								}, 500);*/
								$("#enable_commission").show();
								$("#disable_commission").hide();
							}
						}
					});
				}
			}
			
			function enable_referrer_commission(user_id) {
				var r = true;
				if (r == true) {
					$.ajax({
						url: " <?=base_url()?>adm/process.php",
						type: "POST",
						data: "action=enable_referrer_commission&user_id="+user_id,
						error: function(){
							console.log("Request timed out. Please try again!");
						},
						success: function(out){
							obj = JSON.parse(out);
							if(obj.ret == 0) {
								$.toast({
									heading: 'Error!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'error'
								});
							} else {
								$.toast({
									heading: 'Success!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'success'
								});
								$("#enable_referrer_commission").hide();
								$("#disable_referrer_commission").show();
							}
						}
					});
				}
			}

			function disable_referrer_commission(user_id) {
				var r = true;
				if (r == true) {
					$.ajax({
						url: " <?=base_url()?>adm/process.php",
						type: "POST",
						data: "action=disable_referrer_commission&user_id="+user_id,
						error: function(){
							console.log("Request timed out. Please try again!");
						},
						success: function(out){
							obj = JSON.parse(out);
							if(obj.ret == 0) {
								$.toast({
									heading: 'Error!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'error'
								});
							} else {
								$.toast({
									heading: 'Success!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'success'
								});
								$("#enable_referrer_commission").show();
								$("#disable_referrer_commission").hide();
							}
						}
					});
				}
			}
			
			function enable_payout(user_id) {
				//var r = confirm("Enabled payout!");
				var r = true;
				if (r == true) {
					$.ajax({
						url: " <?=base_url()?>adm/process.php",
						type: "POST",
						data: "action=enable_payout&user_id="+user_id,
						error: function(){
							console.log("Request timed out. Please try again!");
						},
						success: function(out){
							obj = JSON.parse(out);
							if(obj.ret == 0) {
								$.toast({
									heading: 'Error!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'error'
								});
							} else {
								$.toast({
									heading: 'Success!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'success'
								});
								/*setTimeout(function() {
									window.location.reload();
								}, 500);*/
								$("#enable_payout").hide();
								$("#disable_payout").show();
							}
						}
					});
				}
			}
			
			function disable_payout(user_id) {
				//var r = confirm("Disable payout!");
				var r = true;
				if (r == true) {
					$.ajax({
						url: " <?=base_url()?>adm/process.php",
						type: "POST",
						data: "action=disable_payout&user_id="+user_id,
						error: function(){
							console.log("Request timed out. Please try again!");
						},
						success: function(out){
							obj = JSON.parse(out);
							if(obj.ret == 0) {
								$.toast({
									heading: 'Error!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'error'
								});
							} else {
								$.toast({
									heading: 'Success!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'success'
								});
								/*setTimeout(function() {
									window.location.reload();
								}, 500);*/
								$("#enable_payout").show();
								$("#disable_payout").hide();
							}
						}
					});
				}
			}
			
			function enable_auto_payout(user_id) {
				//var r = confirm("Enabled auto payout!");var 
				var r = true;
				if (r == true) {
					$.ajax({
						url: " <?=base_url()?>adm/process.php",
						type: "POST",
						data: "action=enable_auto_payout&user_id="+user_id,
						error: function(){
							console.log("Request timed out. Please try again!");
						},
						success: function(out){
							obj = JSON.parse(out);
							if(obj.ret == 0) {
								$.toast({
									heading: 'Error!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'error'
								});
							} else {
								$.toast({
									heading: 'Success!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'success'
								});
								/*setTimeout(function() {
									window.location.reload();
								}, 500);*/
								$("#disable_auto_payout").show();
								$("#enable_auto_payout").hide();
							}
						}
					});
				}
			}
			
			function disable_auto_payout(user_id) {
				//var r = confirm("Disable auto payout!");
				var r = true;
				if (r == true) {
					$.ajax({
						url: " <?=base_url()?>adm/process.php",
						type: "POST",
						data: "action=disable_auto_payout&user_id="+user_id,
						error: function(){
							console.log("Request timed out. Please try again!");
						},
						success: function(out){
							obj = JSON.parse(out);
							if(obj.ret == 0) {
								$.toast({
									heading: 'Error!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'error'
								});
							} else {
								$.toast({
									heading: 'Success!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'success'
								});
								$("#disable_auto_payout").hide();
								$("#enable_auto_payout").show();
								/*setTimeout(function() {
									window.location.reload();
								}, 500);*/
							}
						}
					});
				}
			}
			
			//15092024
			function enable_survey(user_id) {
				//var r = confirm("Enabled survey!");
				var r = true;
				if (r == true) {
					$.ajax({
						url: " <?=base_url()?>adm/process.php",
						type: "POST",
						data: "action=enable_survey&user_id="+user_id,
						error: function(){
							console.log("Request timed out. Please try again!");
						},
						success: function(out){
							obj = JSON.parse(out);
							if(obj.ret == 0) {
								$.toast({
									heading: 'Error!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'error'
								});
							} else {
								$.toast({
									heading: 'Success!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'success'
								});
								/*setTimeout(function() {
									window.location.reload();
								}, 500);*/
								$("#enable_survey").hide();
								$("#disable_survey").show();
							}
						}
					});
				}
			}
			
			function disable_survey(user_id) {
				//var r = confirm("Disable survey!");
				var r = true;
				if (r == true) {
					$.ajax({
						url: " <?=base_url()?>adm/process.php",
						type: "POST",
						data: "action=disable_survey&user_id="+user_id,
						error: function(){
							console.log("Request timed out. Please try again!");
						},
						success: function(out){
							obj = JSON.parse(out);
							if(obj.ret == 0) {
								$.toast({
									heading: 'Error!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'error'
								});
							} else {
								$.toast({
									heading: 'Success!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'success'
								});
								$("#enable_survey").show();
								$("#disable_survey").hide();
								/*setTimeout(function() {
									window.location.reload();
								}, 500);*/
							}
						}
					});
				}
			}
			//15092024
			
			function process_block_sender() {
				$("#process_block_sender").attr("disabled", !0);
				var email = '<?=$get_user_info->user_email?>';
				$.ajax({
					url: " <?=base_url()?>adm/process.php",
					type: "POST",
					data: "action=block_sender&email="+email,
					error: function(){
						console.log("Request timed out. Please try again!");
					},
					success: function(out){
						obj = JSON.parse(out);
						if(obj.ret == 0) {
							$.toast({
								heading: 'Error!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});
						} else {
							$.toast({
								heading: 'Success!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'success'
							});
							/*setTimeout(function() {
								window.location.reload();
							}, 500);*/
							$("#process_unblock_sender").show();
							$("#process_block_sender").hide();
						}
						$("#process_block_sender").attr("disabled", false);
					}
				});	
			}
			
			function process_unblock_sender() {
				$("#process_unblock_sender").attr("disabled", !0);
				var email = '<?=$get_user_info->user_email?>';
				$.ajax({
					url: " <?=base_url()?>adm/process.php",
					type: "POST",
					data: "action=unblock_sender&email="+email,
					error: function(){
						console.log("Request timed out. Please try again!");
					},
					success: function(out){
						obj = JSON.parse(out);
						if(obj.ret == 0) {
							$.toast({
								heading: 'Error!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});
						} else {
							$.toast({
								heading: 'Success!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'success'
							});
							/*setTimeout(function() {
								window.location.reload();
							}, 500);*/
							$("#process_unblock_sender").hide();
							$("#process_block_sender").show();
						}
						$("#process_unblock_sender").attr("disabled", false);
					}
				});	
			}
			
			//stamina feature
			function process_enable_stamina() {
				$("#process_enable_stamina").attr("disabled", !0);
				var user_id = '<?=$get_user_info->user_id?>';
				var user_name = '<?=$get_user_info->user_name?>';
				$.ajax({
					url: " <?=base_url()?>adm/process.php",
					type: "POST",
					data: "action=enable_stamina&user_id="+user_id+"&user_name="+user_name,
					error: function(){
						console.log("Request timed out. Please try again!");
					},
					success: function(out){
						obj = JSON.parse(out);
						if(obj.ret == 0) {
							$.toast({
								heading: 'Error!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});
						} else {
							$.toast({
								heading: 'Success!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'success'
							});
							/*setTimeout(function() {
								window.location.reload();
							}, 500);*/
							$("#process_enable_stamina").hide();
							$("#process_disable_stamina").show();
						}
						$("#process_enable_stamina").attr("disabled", false);
					}
				});	
			}
			
			function process_disable_stamina() {
				$("#process_disable_stamina").attr("disabled", !0);
				var user_id = '<?=$get_user_info->user_id?>';
				$.ajax({
					url: " <?=base_url()?>adm/process.php",
					type: "POST",
					data: "action=disable_stamina&user_id="+user_id,
					error: function(){
						console.log("Request timed out. Please try again!");
					},
					success: function(out){
						obj = JSON.parse(out);
						if(obj.ret == 0) {
							$.toast({
								heading: 'Error!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});
						} else {
							$.toast({
								heading: 'Success!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'success'
							});
							/*setTimeout(function() {
								window.location.reload();
							}, 500);*/
							$("#process_enable_stamina").show();
							$("#process_disable_stamina").hide();
						}
						$("#process_disable_stamina").attr("disabled", false);
					}
				});	
			}
			//stamina feature
			
			function process_fix_balance_discrepancy(user_id) {
				var r = confirm("Fix balance discrepancy?");
				if (r == true) {
					$.ajax({
						url: " <?=base_url()?>adm/process.php",
						type: "POST",
						data: "action=fix_balance_discrepancy&user_id="+user_id,
						error: function(){
							console.log("Request timed out. Please try again!");
						},
						success: function(out){
							obj = JSON.parse(out);
							if(obj.ret == 0) {
								$.toast({
									heading: 'Error!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'error'
								});
							} else {
								$.toast({
									heading: 'Success!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'success'
								});
								setTimeout(function() {
									window.location.reload();
								}, 500);
							}
						}
					});
				}
			}
			
		</script>
		
		<script>
		function setCashflowDefaultDates() {
			const end = new Date();
			const start = new Date();
			start.setDate(end.getDate() - 9);

			const formatDate = date => date.toISOString().split('T')[0];

			document.getElementById('cashflowStartDate').value = formatDate(start);
			document.getElementById('cashflowEndDate').value = formatDate(end);
		}

		function loadCashflowChart() {
			const start = document.getElementById('cashflowStartDate').value;
			const end = document.getElementById('cashflowEndDate').value;
			const groupMode = document.getElementById('cashflowGroupMode').value;
			const unit = document.getElementById('cashflowUnit').value;

			if (!start || !end) {
				alert('Please select both start and end dates.');
				return;
			}
			fetch(`/adm/load.php?data=cashflow_from_user_by_date_range&user_id=<?=$get_user_info->user_id?>&start=${start}&end=${end}&group_mode=${groupMode}&unit=${unit}`)
				.then(res => res.json())
				.then(data => {
					const labels = data.map(row => row.group_label);
					const deposits = data.map(row => parseFloat(row.deposit));
					const withdrawals = data.map(row => parseFloat(row.withdrawal));
					const profits = data.map((_, i) => deposits[i] - withdrawals[i]);

					const ctx = document.getElementById('cashflowChart').getContext('2d');
					if (window.cashflowChartInstance) window.cashflowChartInstance.destroy();

					window.cashflowChartInstance = new Chart(ctx, {
						type: 'line',
						data: {
							labels,
							datasets: [
								{ label: 'Deposit', data: deposits, backgroundColor: '#03a9f46e', borderColor: '#03a9f4', fill: false, borderWidth: 1},
								{ label: 'Withdrawal', data: withdrawals, backgroundColor: '#f443366b', borderColor: '#f44336', fill: false, borderWidth: 1},
								{ label: 'Profit', data: profits, backgroundColor: '#4caf507a', borderColor: '#4CAF50', fill: false, borderWidth: 1}
							]
						},
						options: {
							responsive: true,
							scales: {
								y: { beginAtZero: true }
							}
						}
					});
				});
			
		}
		
		function setCashflowDefaultDatesByGroupMode(mode) {
			const end = new Date();
			const start = new Date();

			switch (mode) {
				case 'month':
					start.setMonth(end.getMonth() - 9); // 10 months
					break;
				case 'week':
					start.setDate(end.getDate() - 7 * 9); // 10 weeks
					break;
				case 'day':
				default:
					start.setDate(end.getDate() - 9); // 10 days
					break;
			}

			const formatDate = date => date.toISOString().split('T')[0];

			document.getElementById('cashflowStartDate').value = formatDate(start);
			document.getElementById('cashflowEndDate').value = formatDate(end);
		}
		
		document.getElementById('cashflowGroupMode').addEventListener('change', function () {
			const mode = this.value;
			setCashflowDefaultDatesByGroupMode(mode);
			loadCashflowChart();
		});
		
		document.getElementById('cashflowUnit').addEventListener('change', function () {
			loadCashflowChart();
		});
		setCashflowDefaultDates();
		loadCashflowChart();
		</script>
		
		<script>
		<!-- group feature -->
		function add_user_to_group() {
			var r = confirm("Are you sure?");
			if (r == true) {
				var user_id = <?=$get_user_info->user_id?>;
				var group_id = $('#add_to_group').val();
				$.ajax({
					url: " <?=base_url()?>adm/process.php",
					type: "POST",
					data: "action=add_user_to_group&user_id="+user_id+"&group_id="+group_id,
					error: function(){
						console.log("Request timed out. Please try again!");
					},
					success: function(out){
						obj = JSON.parse(out);
						if(obj.ret == 0) {
							$.toast({
								heading: 'Error!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});
						} else {
							$.toast({
								heading: 'Success!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'success'
							});
							setTimeout(function() {
								window.location.reload();
							}, 500);
						}
					}
				});
			}
		}
		
		function remove_user_from_group(user_id, group_id) {
			if (!confirm('Are you sure you want to remove this user from the group?')) return;
			$.ajax({
				url: " <?=base_url()?>adm/process.php",
				type: "POST",
				data: "action=remove_user_from_group&user_id="+user_id+"&group_id="+group_id,
				error: function(){
					console.log("Request timed out. Please try again!");
				},
				success: function(out){
					obj = JSON.parse(out);
					if(obj.ret == 0) {
						$.toast({
							heading: 'Error!',
							text: obj.mes,
							showHideTransition: 'slide',
							position: 'top-right',
							icon: 'error'
						});
					} else {
						$.toast({
							heading: 'Success!',
							text: obj.mes,
							showHideTransition: 'slide',
							position: 'top-right',
							icon: 'success'
						});
						setTimeout(function() {
							window.location.reload();
						}, 500);
					}
				}
			});
		}
		
		<!-- group feature -->
		</script>
		
	</body>
</html>