<!DOCTYPE html>
<html lang="en">
	<?php include('header.php');?>
	<?php if(isset($user_info) && $user_info->dark_mode == 1):?>
	<body class="dark_mode">
	<?php else:?>
	<body>
	<?php endif?>
		<?php include('menu.php');?>
		<section class="get_form_nine_area p_100">
            <div class="container">
               	<div class="single_title_n">
               		<h2>Deposits</h2>
					<a href="<?=base_url()?>adm/deposits.php?status=Processing"><h5>[Load Processing Transactions]</h5></a>
					<table class="history_tbl" style="max-width: 800px; margin: 20px auto">
						<thead><tr><th class="top_header" colspan="7" style="background: #8bc34a; border: none">STATISTICS</th></tr></thead>
						<tbody>
							<tr class="history_row"><td width="50%">TOTAL AMOUNT</td><td width="50%"><?=number_format($statistics->total_amount / 100000000, 8, '.', '')?><br/><span style="color: #03A9F4">$<?=$statistics->USD_value?></span></td></tr>
							<tr class="history_row"><td>TOTAL REQUESTS</td><td><?=$statistics->total_requests?></td></tr>
							<tr class="history_row"><td>HIDE INTERNAL TRANSACTIONS</td><td><input type="checkbox" id="hide_internal_tx" name="hide_internal_tx" <?php if(isset($_COOKIE['hide_internal_tx']) && $_COOKIE['hide_internal_tx'] == 1) echo 'checked';?>></td></tr>
						</tbody>
					</table>
					
					<div class="input-group" style="margin: 20px auto 0px; height: 45px; max-width: 800px; font-size: 14px; width: 100%">
						<div class="input-group" style="margin: 20px auto 0px; height: 45px; font-size: 14px; max-width: 800px; width: 100%">
							<span class="input-group-addon" style="border-radius: 0px;  padding: 14px 15px"><i class="far fa-file-contract"></i></span>
							<input name="txid" type="text" class="form-control" placeholder="txid" style="height: 45px;" value="">
						</div>
					</div>
					<div class="input-group" style="margin: 20px auto 0px; height: 45px; font-size: 14px">
						<input class="btn btn-info" style="width: 200px; padding: 10px;" type="submit" value="Check transaction" onclick="process_deposit()">
					</div>
					
					<div style="width: 100%; overflow-x: auto; margin: 100px auto 0px">
						<table class="table table-striped bets_table">
						<thead>
							<tr>
								<td>User</td>
								<td>Amount</td>
								<td>Address / TxID</td>
								<td>Status</td>
							</tr>
						</thead>
						<tbody>
							<?php
							if (is_array($transactions)) {
								foreach ($transactions as $row) {
									echo '<tr>';

									// USER
									echo '<td>';
									if (isset($row->auto_payout) && $row->auto_payout == 1) {
										echo '<i class="fas fa-badge-check" style="color: #8bc34a; margin-right: 5px"></i>';
									}
									echo '<a href="' . base_url() . 'adm/profile.php?uid=' . $row->uid . '">' . $row->user_name . '</a><br/>';
									echo '<a href="' . base_url() . 'adm/users.php?k=' . GeoIp2CountryIsoCode($row->ip_address) . '" style="color: #9e9e9e">' . GeoIp2Country($row->ip_address) . '</a>';
									echo '</td>';

									// AMOUNT
									echo '<td>';
									echo number_format($row->amount / 100000000, 8, '.', '');
									echo '<br/><span style="color: #03A9F4">$' . number_format($row->USD_value, 2, '.', '').'</span>';
									echo '</td>';

									// ADDRESS + TXID
									echo '<td>';
									echo '<a href="https://bscscan.com/address/' . $row->address . '">' . substr($row->address, 0, 9) . '...' . substr($row->address, -9) . '</a> ';
									echo '<i class="far fa-copy fa-fw js_clipboard" data-copy="' . $row->address . '" style="color: #adb5bd; cursor: pointer" data-toggle="tooltip" title="Copy"></i>';

									if (strlen($row->txid) > 30) {
										$txid_fixed = $row->txid;
										if (strpos($row->txid, "1x") !== false) {
											$txid_fixed = str_replace("1x", "0x", $row->txid);
											$txid_link = 'https://opbnbscan.com/tx/' . $txid_fixed;
										} else {
											$txid_link = 'https://bscscan.com/tx/' . $txid_fixed;
										}
										echo '<br/><a  style="color: #4caf50" href="' . $txid_link . '">' . substr($txid_fixed, 0, 8) . '...' . substr($txid_fixed, -8) . '</a> ';
										echo '<i class="far fa-copy fa-fw js_clipboard" data-copy="' . $txid_fixed . '" style="color: #adb5bd; cursor: pointer" data-toggle="tooltip" title="Copy"></i>';
									} else if ($row->txid != '') {
										echo '<br/><a style="color: orange" href="' . base_url() . 'adm/users.php?k=txid=' . $row->txid . '">' . $row->txid . '</a> ';
										echo '<i class="far fa-copy fa-fw js_clipboard" data-copy="' . $row->txid . '" style="color: #adb5bd; cursor: pointer" data-toggle="tooltip" title="Copy"></i>';
									}
									echo '</td>';

									// STATUS + DATE
									echo '<td>';
									if ($row->status == 'Completed') {
										echo '<span style="color: #4caf50">' . $row->status . '</span>';
									} else if ($row->status == 'Processing') {
										echo '<span style="color: #03a9f4">' . $row->status . '</span>';
									}
									echo '<br/>' . $row->time;
									echo '</td>';

									echo '</tr>';
								}
							} else {
								echo '<tr><td colspan="4">No requests found</td></tr>';
							}
							?>
						</tbody>
					</table>
						<?php if($pagination != '') echo '<div class="pagination">'.$pagination.'</div>';?>
					</div>
			   </div>
            </div>
        </section>
		<?php include('scripts.php');?>
		<script>
			
			function process_deposit() {
				var txid = $('input[name="txid"]').val();
				$.ajax({
					url: " <?=base_url()?>adm/process.php",
					type: "POST",
					data: "action=check_deposit_transactions&txid="+txid,
					error: function(){
						console.log("Request timed out. Please try again!");
					},
					success: function(out){
						obj = JSON.parse(out);
						if(obj.ret == 0) {
							$.toast({
								heading: 'Error!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});
						} else {
							$.toast({
								heading: 'Success!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'success'
							});
							setTimeout(function() {
								window.location.reload();
							}, 500);
						}
					}
				});
			}
			
			$(document).ready(function() {
				$('#hide_internal_tx').click(function(){
					if($("#hide_internal_tx").is(':checked')) {
						document.cookie = "hide_internal_tx=1";
					} else {
						document.cookie = "hide_internal_tx=0";
					}
					location.reload();
				});
			});
		</script>
	</body>
</html>