<!DOCTYPE html>
<html lang="en">
	<?php include('header.php');?>
	<?php if(isset($user_info) && $user_info->dark_mode == 1):?>
	<body class="dark_mode">
	<?php else:?>
	<body>
	<?php endif?>
		<?php include('menu.php');?>
		<section class="get_form_nine_area p_100">
            <div class="container">
               	<div class="single_title_n">
               		<h2>Bonuses</h2>
					<table class="history_tbl" style="max-width: 800px; margin: 20px auto">
						<thead><tr><th class="top_header" colspan="7" style="background: #8bc34a; border: none">STATISTICS</th></tr></thead>
						<tbody>
							<tr class="history_row"><td width="50%">TOTAL AMOUNT</td><td width="50%"><?=number_format($statistics->total_amount / 100000000, 8, '.', '')?></td></tr>
							<tr class="history_row"><td>TOTAL REQUESTS</td><td><?=$statistics->total_requests?></td></tr>
							<tr class="history_row"><td>MAX AMOUNT</td><td><?=number_format($statistics->max_amount / 100000000, 8, '.', '')?></td></tr>
							<!-- auto cashback 29092024 -->
							<tr class="history_row"><td>AUTO CASHBACK</td><td><?php if($allow_auto_cashback == 1) echo '<a style="color: green" onclick="disable_auto_cashback()">Enabled</a>'; else echo '<a style="color: red" onclick="enable_auto_cashback()">Disabled</a>';?></td></tr>
							<!-- auto cashback 29092024 -->
						</tbody>
					</table>
					<div style="margin-top: 30px; font-weight: bold; font-size: 15px">SEND BONUS</div>
					<div class="row" style="max-width: 350px; margin: 20px auto">
						<div class="col-xs-6" style="padding: 0px">
							<div class="radio icheck-success">
								<input type="radio" id="send_bnb" name="bonus_unit">
								<label for="send_bnb">Send BNB</label>
							</div>
						</div>
						<div class="col-xs-6" style="padding: 0px">
							<div class="radio icheck-success">
								<input type="radio" id="send_usd" name="bonus_unit" checked="checked">
								<label for="send_usd">Send USD</label>
							</div>
						</div>
					</div>
					<section style="max-width: 800px; margin: 20px auto;">
						<div class="input-group" style="margin: 20px auto 0px; height: 45px; max-width: 800px; font-size: 14px">
							<span class="input-group-addon" style="border-radius: 0px;  padding: 14px 15px"><i class="fas fa-user"></i></span>
							<input id="user_id" name="user_id" type="text" class="form-control" placeholder="User ID" value="<?php if($user_id != 0) echo $user_id;?>" style="height: 45px;">
						</div>
						<div class="input-group" style="margin: 20px auto 0px; height: 45px; max-width: 800px; font-size: 14px">
							<span class="input-group-addon" style="border-radius: 0px;  padding: 14px 12px"><i class="fas fa-money-bill-alt"></i></span>
							<input id="amount" name="amount" type="text" class="form-control" placeholder="Amount" style="height: 45px;">
						</div>
						<div class="input-group" style="margin: 20px auto 0px; height: 45px; max-width: 800px; font-size: 14px">
							<span class="input-group-addon" style="border-radius: 0px;  padding: 14px 13.5px"><i class="fas fa-pen-alt"></i></span>
							<input id="message" name="message" type="text" class="form-control" placeholder="Note" style="height: 45px;">
						</div>
						<div class="input-group" style="margin: 20px auto 0px; height: 45px; max-width: 800px; font-size: 14px">
							<div class="btn btn-info" style="width: 200px; padding: 10px;" onclick="process_bonus()">Send bonus</div>
						</div>
					</section>
					
					<!-- 12062024 -->
					<?php if($get_user_bonuses_by_dates != null):?>
						<div style="margin-top: 30px; font-weight: bold; font-size: 15px">EARNINGS BY DATES</div>
						<div style="width: 100%; max-width: 800px; margin: 0px auto">
							<canvas id="chart2"></canvas>
						</div>
					<?php endif?>
					<!-- 12062024 -->
					
					
					<div style="width: 100%; overflow-x: auto; margin: 100px auto 0px">
						<table class="table table-striped bets_table">
							<thead>
								<tr>
									<td>Date</td>
									<td>User</td>
									<td>Amount BNB</td>
									<td>USD</td>
									<td>Note</td>
								</tr>
							</thead>
							<tbody>
								<?php
									if(is_array($bonuses)) {
										foreach($bonuses as $row) {
											echo '<tr>';
											if(date('Y-m-d', $row->time) == date('Y-m-d')) {
												$row->time =  date('H:i:s A', $row->time);
											} else {
												$row->time =  date('Y-m-d', $row->time);
											}
											echo '<td>'.$row->time.'</td>';
											echo '<td><a href="'.base_url().'adm/profile.php?uid='.$row->uid.'">'.$row->user_name.'</a></td>';
											echo '<td>'.number_format($row->amount / 100000000, 8, '.', '').' BNB </td>';
											$USD_value = number_format(floatval($row->amount / 100000000 * $BNB_price), 2, '.', '');
											echo '<td>$'.$USD_value.'</td>';
											if($row->message != '') {
												echo '<td>'.$row->message.'</td>';
											} else {
												echo '<td>...</td>';
											}
											echo '</tr>';
										}
									} else {
										echo '<tr><td colspan="5">No bonuses found</td></tr>';
									}
								?>
							</tbody>
						</table>
						<?php if($pagination != '') echo '<div class="pagination">'.$pagination.'</div>';?>
					</div>
			   </div>
            </div>
        </section>
		<?php include('scripts.php');?>
		<script>
			function process_bonus() {
				var user_id = $('#user_id').val();
				var amount = $('#amount').val();
				var message = $('#message').val();
				var bonus_unit = 'bnb';
				if(!$('#send_bnb').is(':checked')) {
					bonus_unit = 'usd';
				}
				$.ajax({
					url: " <?=base_url()?>adm/process.php",
					type: "POST",
					data: "action=bonus&user_id="+user_id+"&amount="+amount+"&bonus_unit="+bonus_unit+"&message="+message,
					error: function(){
						console.log("Request timed out. Please try again!");
					},
					success: function(out){
						obj = JSON.parse(out);
						if(obj.ret == 0) {
							$.toast({
								heading: 'Error!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});
						} else {
							$.toast({
								heading: 'Success!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'success'
							});
							setTimeout(function() {
								window.location.reload();
							}, 500);
						}
					}
				});
			}
			
			<!-- auto cashback 29092024 -->
			function enable_auto_cashback() {
				var r = confirm("Enabled auto cashback!");
				if (r == true) {
					$.ajax({
						url: " <?=base_url()?>adm/process.php",
						type: "POST",
						data: "action=enable_auto_cashback",
						error: function(){
							console.log("Request timed out. Please try again!");
						},
						success: function(out){
							obj = JSON.parse(out);
							if(obj.ret == 0) {
								$.toast({
									heading: 'Error!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'error'
								});
							} else {
								$.toast({
									heading: 'Success!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'success'
								});
								setTimeout(function() {
									window.location.reload();
								}, 500);
							}
						}
					});
				}
			}
			
			function disable_auto_cashback() {
				var r = confirm("Disable auto cashback!");
				if (r == true) {
					$.ajax({
						url: " <?=base_url()?>adm/process.php",
						type: "POST",
						data: "action=disable_auto_cashback",
						error: function(){
							console.log("Request timed out. Please try again!");
						},
						success: function(out){
							obj = JSON.parse(out);
							if(obj.ret == 0) {
								$.toast({
									heading: 'Error!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'error'
								});
							} else {
								$.toast({
									heading: 'Success!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'success'
								});
								setTimeout(function() {
									window.location.reload();
								}, 500);
							}
						}
					});
				}
			}
			<!-- auto cashback 29092024 -->
			
			
		</script>
		
		<!-- 12062024 -->
		<?php if($get_user_bonuses_by_dates != null):?>
		<script>
		var chart2 = new Chart(document.getElementById('chart2').getContext('2d'), {
			type: 'bar',
			data: {
				labels: <?=$get_user_bonuses_by_dates[0]?>,
				datasets: [{
					label: 'earnings (BNB)',
					data: <?=$get_user_bonuses_by_dates[1]?>,
					backgroundColor: '#8bc34a',
					borderColor: '#8bc34a',
					borderWidth: 1
				}]
			}
		});
		</script>
		<?php endif?>
		
		
	</body>
</html>