<?php
class WalletModel extends CI_Model {
	
	public $limit_entries = 20;
	
	function __construct() {
		parent::__construct();
		$this->load->database();
	}

	public function create_new_wallet($user_id, $type, $address, $private_key) {
		$user_id = $this->db->escape_str($user_id);
		$type = $this->db->escape_str($type);
		$address = $this->db->escape_str($address);
		$private_key = $this->db->escape_str($private_key);
		$data = array(
			'user_id' 		=> $user_id,
			'type' 			=> $type,
			'address'		=> $address,
			'private_key'	=> $private_key,
			'created_time'	=> time(),
			'updated_time'	=> time(),
		);
		$this->db->insert('ez_wallets', $data);
		$insert_id = $this->db->insert_id();
		
		//sync_data
		$this->auto_sync_wallet_data($insert_id);
		//sync_data
		
		return  $insert_id;
	}
	
	public function search_wallet_by_address($address, $type = 'Deposit') {
		$address = $this->db->escape_str($address);
		$sql = "SELECT * FROM `ez_wallets` WHERE `address` = ? AND `type` = ? LIMIT 1";
		$query = $this->db->query($sql, array($address, $type));
		if($query->num_rows() > 0) {
			return $query->result()[0];
		}
		return null;
	}
	
	public function get_wallet_by_wallet_id($wallet_id) {
		$wallet_id = $this->db->escape_str($wallet_id);
		$sql = "SELECT * FROM `ez_wallets` WHERE `wallet_id` = ? LIMIT 1";
		$query = $this->db->query($sql, array($wallet_id));
		if($query->num_rows() > 0) {
			return $query->result()[0];
		}
		return '';
	}

	public function get_wallet_by_user_id($user_id) {
		$user_id = $this->db->escape_str($user_id);
		$sql = "SELECT * FROM `ez_wallets` WHERE `user_id` = ? AND `type` = 'Deposit' ORDER BY `wallet_id` DESC LIMIT 1";
		$query = $this->db->query($sql, array($user_id));
		if($query->num_rows() > 0) {
			return $query->result()[0];
		}
		return '';
	}

	public function get_deposit_address_by_user_id($user_id) {
		$user_id = $this->db->escape_str($user_id);
		$sql = "SELECT `address` FROM `ez_wallets` WHERE `user_id` = ? AND `type` = 'Deposit' ORDER BY `wallet_id` DESC LIMIT 1";
		$query = $this->db->query($sql, array($user_id));
		if($query->num_rows() > 0) {
			return $query->result()[0]->address;
		}
		return '';
	}
	
	public function get_all_deposit_wallets($deposit_addresses) {
		$query = $this->db->query("SELECT * FROM `ez_wallets` WHERE `address` IN (".$deposit_addresses.") AND `type` = 'Deposit'");
		if($query->num_rows() > 0) {
			return $query->result();
		}
		return null;
	}
	
	public function update_wallet_balance($wallet_id, $balance, $time){
		$wallet_id = $this->db->escape_str($wallet_id);
		$sql = "UPDATE `ez_wallets` SET `balance` = ?, `updated_time` = ? WHERE `wallet_id` = ?";
		$query = $this->db->query($sql, array($balance, $time, $wallet_id));
		
		//sync_data
		$this->auto_sync_wallet_data($wallet_id);
		//sync_data
	}

	public function update_wallet_balance_on_opbnb($wallet_id, $balance, $time){
		$wallet_id = $this->db->escape_str($wallet_id);
		$sql = "UPDATE `ez_wallets` SET `balance_on_opbnb` = ?, `updated_time` = ? WHERE `wallet_id` = ?";
		$query = $this->db->query($sql, array($balance, $time, $wallet_id));
		
		//sync_data
		$this->auto_sync_wallet_data($wallet_id);
		//sync_data
	}

	public function update_last_copied($wallet_id){
		$wallet_id = $this->db->escape_str($wallet_id);
		$sql = "UPDATE `ez_wallets` SET `last_copied` = ? WHERE `wallet_id` = ?";
		$query = $this->db->query($sql, array(time(), $wallet_id));
		
		//sync_data
		$this->auto_sync_wallet_data($wallet_id);
		//sync_data
	}
	
	public function load_user_wallets($page_id = 1, $sort = 'balance', $order = 'DESC') {
		//$sql = "SELECT `ez_users`.`user_name`, `ez_wallets`.* FROM `ez_wallets`, `ez_users` WHERE `ez_wallets`.`user_id` = `ez_users`.`user_id` AND (`created_time` != `updated_time` OR `ez_wallets`.`balance` != 0) ORDER BY `".$sort."` ".$order." LIMIT ".$this->limit_entries." OFFSET ".($this->limit_entries * ($page_id - 1));
		if($sort == 'balance') {
			$sql = "SELECT `ez_users`.`user_name`, `ez_wallets`.*, CASE WHEN `note` = 'payment' THEN 99999 ELSE (`ez_wallets`.`balance` / 1000000000) END AS `weight` FROM `ez_wallets`, `ez_users` WHERE `ez_wallets`.`user_id` = `ez_users`.`user_id` AND (`created_time` != `updated_time` OR `ez_wallets`.`balance` != 0) ORDER BY `weight` ".$order." LIMIT ".$this->limit_entries." OFFSET ".($this->limit_entries * ($page_id - 1));
		} else {
			$sql = "SELECT `ez_users`.`user_name`, `ez_wallets`.* FROM `ez_wallets`, `ez_users` WHERE `ez_wallets`.`user_id` = `ez_users`.`user_id` AND (`created_time` != `updated_time` OR `ez_wallets`.`balance` != 0) ORDER BY `".$sort."` ".$order." LIMIT ".$this->limit_entries." OFFSET ".($this->limit_entries * ($page_id - 1));
		}
		$query = $this->db->query($sql);
		if($query->num_rows() > 0) {
			return $query->result();
		}
		return null;
	}

	public function load_user_wallets_on_opbnb($page_id = 1) {
		$sql = "SELECT `ez_users`.`user_name`, `ez_wallets`.* FROM `ez_wallets`, `ez_users` WHERE `ez_wallets`.`user_id` = `ez_users`.`user_id` AND `ez_wallets`.`balance_on_opbnb` != 0 ORDER BY `balance_on_opbnb` DESC LIMIT ".$this->limit_entries." OFFSET ".($this->limit_entries * ($page_id - 1));
		$query = $this->db->query($sql);
		if($query->num_rows() > 0) {
			return $query->result();
		}
		return null;
	}
	
	public function load_recently_copied_wallets($page_id = 1) {
		$sql = "SELECT `ez_users`.`user_name`, `ez_users`.`total_deposits`, `ez_wallets`.* FROM `ez_wallets`, `ez_users` WHERE `ez_wallets`.`user_id` = `ez_users`.`user_id` AND `last_copied` > `updated_time` ORDER BY `last_copied` DESC LIMIT ".$this->limit_entries." OFFSET ".($this->limit_entries * ($page_id - 1));
		$query = $this->db->query($sql);
		if($query->num_rows() > 0) {
			return $query->result();
		}
		return null;
	}
	
	public function count_recently_copied_wallets() {
		$sql = "SELECT COUNT(`wallet_id`) AS `cnt` FROM `ez_wallets` WHERE `last_copied` > `updated_time`";
		$query = $this->db->query($sql);
		if($query->num_rows() > 0) {
			return $query->result()[0]->cnt;
		}
		return 0;
	}
	
	public function get_wallet_statistics() {
		$sql = "SELECT COUNT(`wallet_id`) AS `total_wallets`, SUM(`balance`) AS `total_balance` FROM `ez_wallets` WHERE (`created_time` != `updated_time` OR `ez_wallets`.`balance` != 0)";
		$query = $this->db->query($sql);
		if($query->num_rows() > 0) {
			return $query->result()[0];
		}
		return null;
	}

	public function get_wallet_statistics_on_opbnb() {
		$sql = "SELECT COUNT(`wallet_id`) AS `total_wallets`, SUM(`balance_on_opbnb`) AS `total_balance` FROM `ez_wallets` WHERE `ez_wallets`.`balance_on_opbnb` != 0";
		$query = $this->db->query($sql);
		if($query->num_rows() > 0) {
			return $query->result()[0];
		}
		return null;
	}
	
	/*public function find_wallet_to_pay($amount) {
		$amount = $this->db->escape_str($amount);
		$sql = "SELECT * FROM `ez_wallets` WHERE balance > ? ORDER BY `balance` ASC LIMIT 1";
		$query = $this->db->query($sql, array($amount));
		if($query->num_rows() > 0) {
			return $query->result()[0];
		}
		return null;
	}*/
	
	public function find_wallet_to_pay($amount) {
		$amount = $this->db->escape_str($amount);
		$sql = "SELECT * FROM `ez_wallets` WHERE balance > ? AND `note` = 'payment' ORDER BY `updated_time` ASC LIMIT 1";
		$query = $this->db->query($sql, array($amount));
		if($query->num_rows() > 0) {
			return $query->result()[0];
		}
		return null;
	}
	
	public function find_wallet_to_deposit() {
		$sql = "SELECT * FROM `ez_wallets` WHERE `note` = 'payment' ORDER BY `balance` ASC LIMIT 1";
		$query = $this->db->query($sql);
		if($query->num_rows() > 0) {
			return $query->result()[0];
		}
		return null;
	}
	
	public function is_payment_address($address) {
		$sql = "SELECT * FROM `ez_wallets` WHERE `address` = ? AND `note` = 'payment' ORDER BY `updated_time` ASC LIMIT 1";
		$query = $this->db->query($sql, array($address));
		if($query->num_rows() > 0) {
			return 1;
		}
		return 0;
	}
	
	public function get_random_wallet($from_amount = 0, $to_amount = 10000000) {
		$sql = "SELECT * FROM `ez_wallets` WHERE balance >= ? AND balance <= ? ORDER BY RAND() LIMIT 1";
		$query = $this->db->query($sql, array($from_amount, $to_amount));
		if($query->num_rows() > 0) {
			return $query->result()[0];
		}
		return null;
	}
	
	
	//sync_data
	public function auto_sync_wallet_data($wallet_id) {
		if(!SYNC_DATA_ALLOWED) {
			return;
		}
		$wallet_info = $this->get_wallet_by_wallet_id($wallet_id);
		$apiUrl = 'http://'.SYNC_DATA_IP.'/backup/bnbpick/wallets.php';
		$walletData = $wallet_info;
		$jsonData = json_encode($walletData);
		$cmd = "curl -X POST -H 'Content-Type: application/json' -d '$jsonData' '$apiUrl' > /dev/null 2>&1 &";
		exec($cmd);
	}
	//sync_data
}
?>