<?php
class TicketModel extends CI_Model {
	
	public $limit_entries = 20;
	
	function __construct() {
		parent::__construct();
		$this->load->database();
	}
	
	public function create_new_ticket($user_id, $email, $user_name, $subject, $ticket_code, $hidden = 0) {
		$user_id = $this->db->escape_str($user_id);
		$email = $this->db->escape_str($email);
		$user_name = $this->db->escape_str($user_name);
		$subject = $this->db->escape_str($subject);
		$replied = 0;
		if($user_id == -1) {
			$replied = 1;
		}
		$data = array(
			'user_id' 		=> $user_id,
			'email' 		=> $email,
			'user_name' 	=> $user_name,
			'subject'	    => $subject,
			'created_time' 	=> time(),
			'updated_time' 	=> time(),
			'replied' 		=> $replied,
			'closed' 		=> 0,
			'hidden'		=> $hidden,
			'mail_sent' 	=> 0,
			'ticket_code'	=> $ticket_code
		);
		$this->db->insert('ez_tickets', $data);
		$insert_id = $this->db->insert_id();
		
		//sync_data
		$this->auto_sync_ticket_data($insert_id);
		//sync_data
		
		return  $insert_id;
	}
	
		
	function get_ticket_info($ticket_id) {
		$ticket_id = $this->db->escape_str($ticket_id);
		$sql = "SELECT * FROM `ez_tickets` WHERE `ticket_id` = ? LIMIT 1";
		$query = $this->db->query($sql, array($ticket_id));
		if($query->num_rows() > 0) {
			return $query->result()[0];
		}
		return null;
	}
	
	function get_ticket_id($ticket_code) {
		$ticket_code = $this->db->escape_str($ticket_code);
		$sql = "SELECT * FROM `ez_tickets` WHERE `ticket_code` LIKE ? LIMIT 1";
		$query = $this->db->query($sql, array($ticket_code));
		if($query->num_rows() > 0) {
			return $query->result()[0]->ticket_id;
		}
		return 0;
	}
	
	public function update_ticket_time($ticket_id){
		$ticket_id = $this->db->escape_str($ticket_id);
		$this->db->set('updated_time', time());
		$this->db->where('ticket_id', $ticket_id);
		$res =  $this->db->update('ez_tickets');
		
		//sync_data
		$this->auto_sync_ticket_data($ticket_id);
		//sync_data
		
		return $res;
		
	}
	
	public function send_email_reply_ticket($ticket_id){
		$ticket_id = $this->db->escape_str($ticket_id);
		$this->db->set('mail_sent', 1);
		$this->db->where('ticket_id', $ticket_id);
		$res = $this->db->update('ez_tickets');
		
		//sync_data
		$this->auto_sync_ticket_data($ticket_id);
		//sync_data
		
		return $res;
		
	}

	public function reply_ticket($ticket_id){
		$ticket_id = $this->db->escape_str($ticket_id);
		$this->db->set('replied', 1);
		$this->db->where('ticket_id', $ticket_id);
		$res =  $this->db->update('ez_tickets');
		
		//sync_data
		$this->auto_sync_ticket_data($ticket_id);
		//sync_data
		
		return $res;
		
	}
	
	public function user_reply_ticket($ticket_id){
		$ticket_id = $this->db->escape_str($ticket_id);
		$this->db->set('replied', 0);
		$this->db->where('ticket_id', $ticket_id);
		$res = $this->db->update('ez_tickets');
		
		//sync_data
		$this->auto_sync_ticket_data($ticket_id);
		//sync_data
		
		return $res;
		
	}
	
	public function close_ticket($ticket_id){
		$ticket_id = $this->db->escape_str($ticket_id);
		$this->db->set('closed', 1);
		$this->db->where('ticket_id', $ticket_id);
		$res = $this->db->update('ez_tickets');
		
		//sync_data
		$this->auto_sync_ticket_data($ticket_id);
		//sync_data
		
		return $res;
		
	}

	public function reopen_ticket($ticket_id){
		$ticket_id = $this->db->escape_str($ticket_id);
		$this->db->set('closed', 0);
		$this->db->where('ticket_id', $ticket_id);
		$res = $this->db->update('ez_tickets');
		
		//sync_data
		$this->auto_sync_ticket_data($ticket_id);
		//sync_data
		
		return $res;
		
	}
	
	public function update_user_time_seen($ticket_id){
		$ticket_id = $this->db->escape_str($ticket_id);
		$this->db->set('time_seen', time());
		$this->db->where('ticket_id', $ticket_id);
		$res = $this->db->update('ez_tickets');
		
		//sync_data
		$this->auto_sync_ticket_data($ticket_id);
		//sync_data
		
		return $res;
		
	}
	
	public function load_tickets($email, $user_id = 0, $page_id = 1) {
		$email = $this->db->escape_str($email);
		if($email != '') {
			$sql = "SELECT * FROM `ez_tickets` WHERE `email` = ? ORDER BY `updated_time` DESC LIMIT ".$this->limit_entries." OFFSET ".($this->limit_entries * ($page_id - 1));
			$query = $this->db->query($sql, array($email));
		} else if($user_id != 0) {
			$sql = "SELECT * FROM `ez_tickets` WHERE `user_id` = ? ORDER BY `updated_time` DESC LIMIT ".$this->limit_entries." OFFSET ".($this->limit_entries * ($page_id - 1));
			$query = $this->db->query($sql, array($user_id));
		} else {
			$sql = "SELECT * FROM `ez_tickets` WHERE `hidden` = '0' ORDER BY `updated_time` DESC LIMIT ".$this->limit_entries." OFFSET ".($this->limit_entries * ($page_id - 1));
			$query = $this->db->query($sql);
		}
		if($query->num_rows() > 0) {
			return $query->result();
		}
		return null;
	}
	
	public function count_tickets($email = '') {
		$email = $this->db->escape_str($email);
		if($email != '') {
			$sql = "SELECT COUNT(`ticket_id`) AS `cnt` FROM `ez_tickets` WHERE `email` = ?";
			$query = $this->db->query($sql, array($email));
		} else {
			$sql = "SELECT COUNT(`ticket_id`) AS `cnt` FROM `ez_tickets`";
			$query = $this->db->query($sql);
		}
		if($query->num_rows() > 0) {
			return $query->result()[0]->cnt;
		}
		return 0;
	}
	
	//sync_data
	public function auto_sync_ticket_data($ticket_id) {
		if(!SYNC_DATA_ALLOWED) {
			return;
		}
		$ticket_info = $this->get_ticket_info($ticket_id);
		$apiUrl = 'http://'.SYNC_DATA_IP.'/backup/bnbpick/tickets.php';
		$jsonData = json_encode($ticket_info);
		$cmd = "curl -X POST -H 'Content-Type: application/json' -d '$jsonData' '$apiUrl' > /dev/null 2>&1 &";
		exec($cmd);
	}
	//sync_data
}
?>