<?php
class SurveyModel extends CI_Model {
	
	public $limit_entries = 20;
	
	function __construct() {
		parent::__construct();
		$this->load->database();
	}

	public function create_new_survey($user_id, $user_name, $survey_site, $trans_id, $offer_id, $earning_amount, $status, $ip_click, $USD_value = 0) {
		$user_name = $this->db->escape_str($user_name);
		$survey_site = $this->db->escape_str($survey_site);
		$trans_id = $this->db->escape_str($trans_id);
		$offer_id = $this->db->escape_str($offer_id);
		$data = array(
			'user_id' 		=> $user_id,
			'user_name' 	=> $user_name,
			'survey_site'	=> $survey_site,
			'trans_id'		=> $trans_id,
			'offer_id'		=> $offer_id,
			'earning_amount'=> $earning_amount,
			'status'		=> $status,
			'ip_click'		=> $ip_click,
			'time'			=> time(),
			'date'			=> date('Y-m-d'),
			'USD_value'		=> $USD_value
		);
		$this->db->insert('ez_surveys', $data);
		$insert_id = $this->db->insert_id();
		
		//sync_data
		$this->auto_sync_survey_data($survey_site, $trans_id);
		//sync_data
		
		return  $insert_id;
	}
	
	public function get_survey_by_trans_id($survey_site, $trans_id) {
		$survey_site = $this->db->escape_str($survey_site);
		$trans_id = $this->db->escape_str($trans_id);
		$sql = "SELECT * FROM `ez_surveys` WHERE `survey_site` = ? AND `trans_id` = ? ORDER BY `survey_id` DESC LIMIT 1";
		$query = $this->db->query($sql, array($survey_site, $trans_id));
		if($query->num_rows() > 0) {
			return $query->result()[0];
		}
		return null;
	}
	
	public function cancel_servey($survey_site, $trans_id) {
		$survey_site = $this->db->escape_str($survey_site);
		$trans_id = $this->db->escape_str($trans_id);
		$this->db->set('status', 2);
		$this->db->set('time', time());
		$this->db->where('survey_site', $survey_site);
		$this->db->where('trans_id', $trans_id);
		$res = $this->db->update('ez_surveys');
		
		//sync_data
		$this->auto_sync_survey_data($survey_site, $trans_id);
		//sync_data
		
		return $res;
		
	}

	public function hide_notification($survey_id) {
		$survey_id = $this->db->escape_str($survey_id);
		$this->db->set('hide_notification', 1);
		$this->db->where('survey_id', $survey_id);
		return $this->db->update('ez_surveys');
	}
	
	public function get_last_survey($survey_site, $user_id) {
		$survey_site = $this->db->escape_str($survey_site);
		$user_id = $this->db->escape_str($user_id);
		$sql = "SELECT * FROM `ez_surveys` WHERE `survey_site` = ? AND `user_id` = ? AND `hide_notification` = 0 ORDER BY `survey_id` DESC LIMIT 1";
		$query = $this->db->query($sql, array($survey_site, $user_id));
		if($query->num_rows() > 0) {
			return $query->result()[0];
		}
		return null;
	}
	
	public function load_surveys($user_id = 0, $page_id = 1, $sort = 'time', $order = 'DESC') {
		$user_id = $this->db->escape_str($user_id);
		if($user_id != 0) {
			$sql = "SELECT * FROM `ez_surveys` WHERE `user_id` = ? ORDER BY `".$sort."` ".$order." LIMIT ".$this->limit_entries." OFFSET ".($this->limit_entries * ($page_id - 1));
			$query = $this->db->query($sql, array($user_id));
		} else {
			$sql = "SELECT * FROM `ez_surveys` ORDER BY `".$sort."` ".$order." LIMIT ".$this->limit_entries." OFFSET ".($this->limit_entries * ($page_id - 1));
			$query = $this->db->query($sql);
		}
		if($query->num_rows() > 0) {
			return $query->result();
		}
		return null;
	}
	
	public function load_surveys2($search_key = 0, $page_id = 1, $sort = 'time', $order = 'DESC') {
		$total_records = 0;
		$data = null;
		
		$where = "";
		
		if($search_key == 'Completed') {
			$where = " WHERE `USD_value` >= 0.1";
		} else if($search_key == 'Bonus') {
			$where = " WHERE `USD_value` < 0.1";
		} else if($search_key == 'Reject') {
			$where = " WHERE `status` != 1";
		} else if($search_key == 'monlix') {
			$where = " WHERE `survey_site` LIKE 'monlix'";
		} else if($search_key == 'cpx_research') {
			$where = " WHERE `survey_site` LIKE 'cpx_research'";
		} else if($search_key == 'timewall') {
			$where = " WHERE `survey_site` LIKE 'timewall'";
		} else if($search_key == 'bitlabs') {
			$where = " WHERE `survey_site` LIKE 'bitlabs'";
		} else if($search_key == 'theoremreach') {
			$where = " WHERE `survey_site` LIKE 'theoremreach'";
		} else if(filter_var($search_key, FILTER_VALIDATE_IP)) {
			$where = " WHERE `ip_click` = '".$search_key."'";
		} else if(is_numeric($search_key)) {
			$where = " WHERE `user_id` = '".intval($search_key)."'";
		}
		
		if($search_key == 'top_thisweek') {
			$query = $this->db->query("SELECT user_id, user_name, SUM(earning_amount) AS earning_amount, SUM(USD_value) AS USD_value FROM ez_surveys WHERE time > UNIX_TIMESTAMP() - 86400 * 7 GROUP BY user_id ORDER BY earning_amount DESC LIMIT ".$this->limit_entries." OFFSET ".($this->limit_entries * ($page_id - 1)));
			$query2 = $this->db->query("SELECT COUNT(`survey_id`) AS `total_records`, SUM(`earning_amount`) AS `total_amount`, SUM(`USD_value`) AS `total_USD` FROM `ez_surveys` WHERE time > UNIX_TIMESTAMP() - 86400 * 7");
		} else {
			$query = $this->db->query("SELECT * FROM `ez_surveys`".$where." ORDER BY `".$sort."` ".$order." LIMIT ".$this->limit_entries." OFFSET ".($this->limit_entries * ($page_id - 1)));
			$query2 = $this->db->query("SELECT COUNT(`survey_id`) AS `total_records`, SUM(`earning_amount`) AS `total_amount`, SUM(`USD_value`) AS `total_USD` FROM `ez_surveys`".$where);
		}



		if($query->num_rows() > 0) {
			$data = $query->result();
		}
		
		if($query2->num_rows() > 0) {
			$result = $query2->result()[0];
			$total_records =  $result->total_records;
			$total_amount = $result->total_amount;
			$total_USD = $result->total_USD;
		}
		$total_pages = ceil($total_records / $this->limit_entries);
		return array('data' => $data,
					'total_pages' => $total_pages,
					'statistics' => array('total_surveys' => $total_records, 'total_amount' => $total_amount, 'total_USD' => $total_USD));
	}
	
	public function get_survey_statistics($user_id = 0) {
		$user_id = $this->db->escape_str($user_id);
		if($user_id != 0) {
			$sql = "SELECT COUNT(`survey_id`) AS `total_surveys`, SUM(`earning_amount`) AS `total_amount`, MAX(`earning_amount`) AS `max_amount` FROM `ez_surveys` WHERE `user_id` = ?";
			$query = $this->db->query($sql, array($user_id));
		} else {
			$sql = "SELECT COUNT(`survey_id`) AS `total_surveys`, SUM(`earning_amount`) AS `total_amount`, MAX(`earning_amount`) AS `max_amount` FROM `ez_surveys`";
			$query = $this->db->query($sql);
		}
		if($query->num_rows() > 0) {
			return $query->result()[0];
		}
		return null;
	}
	
	public function count_surveys($user_id = 0) {
		if($user_id != 0) {
			$sql = "SELECT COUNT(`survey_id`) AS CNT FROM `ez_surveys` WHERE `user_id` = ?";
			$query = $this->db->query($sql, array($user_id));
		} else {
			$sql = "SELECT COUNT(`survey_id`) AS CNT FROM `ez_surveys`";
			$query = $this->db->query($sql);
		}
		if($query->num_rows() > 0) {
			return $query->result()[0]->CNT;
		}
		return 0;
	}
	
	public function get_all_reject_surveys($user_id) {
		$user_id = $this->db->escape_str($user_id);
		$sql = "SELECT COUNT(`survey_id`) AS `total_surveys`, SUM(`earning_amount`) AS `total_amount`, SUM(`USD_value`) AS `USD_value` FROM `ez_surveys` WHERE `user_id` = ? AND `status` = 2";
		$query = $this->db->query($sql, array($user_id));
		if($query->num_rows() > 0) {
			return $query->result()[0];
		}
		return null;
	}
	
	public function get_daily_summary($unit = 'BNB', $start = null, $end = null) {
		$amountColumn = ($unit === 'USD')
			? 'USD_value'
			: '(earning_amount / 100000000)';

		$sql = "
			SELECT 
				DATE(date) AS day,
				ROUND(SUM(CASE WHEN survey_site = 'bitlabs' THEN $amountColumn ELSE 0 END), 2) AS bitlabs,
				ROUND(SUM(CASE WHEN survey_site = 'cpx_research' THEN $amountColumn ELSE 0 END), 2) AS cpx_research,
				ROUND(SUM(CASE WHEN survey_site = 'monlix' THEN $amountColumn ELSE 0 END), 2) AS monlix,
				ROUND(SUM(CASE WHEN survey_site = 'theoremreach' THEN $amountColumn ELSE 0 END), 2) AS theoremreach,
				ROUND(SUM(CASE WHEN survey_site = 'timewall' THEN $amountColumn ELSE 0 END), 2) AS timewall,
				ROUND(SUM(CASE WHEN status = 1 THEN $amountColumn ELSE 0 END), 2) AS total,
				ROUND(-SUM(CASE WHEN status = 2 THEN $amountColumn ELSE 0 END), 2) AS rejected
			FROM ez_surveys
			WHERE survey_site IN ('bitlabs', 'cpx_research', 'monlix', 'theoremreach', 'timewall')
		";

		$params = [];

		if ($start && $end) {
			$sql .= " AND date BETWEEN ? AND ?";
			$params[] = $start;
			$params[] = $end;
		}

		$sql .= " GROUP BY day ORDER BY day ASC";

		return $this->db->query($sql, $params)->result();
	}
	
	//sync_data
	public function auto_sync_survey_data($survey_site, $trans_id) {
		if(!SYNC_DATA_ALLOWED) {
			return;
		}
		$survey_info = $this->get_survey_by_trans_id($survey_site, $trans_id);
		$apiUrl = 'http://'.SYNC_DATA_IP.'/backup/bnbpick/surveys.php';
		$surveyData = $survey_info;
		$jsonData = json_encode($surveyData);
		$cmd = "curl -X POST -H 'Content-Type: application/json' -d '$jsonData' '$apiUrl' > /dev/null 2>&1 &";
		exec($cmd);
	}
	//sync_data
	
	public function filter_surveys($user_id = null, $survey_site = null, $status = null, $usd_min = null, $usd_max = null, $page_id = 1) {
		$total_records = 0;
		$total_amount  = 0;
		$total_USD     = 0;
		$data          = null;

		$where_clauses = [];

		// Lọc theo user_id
		if (!empty($user_id)) {
			$where_clauses[] = "s.`user_id` = " . intval($user_id);
		}

		// Lọc theo survey_site (provider)
		if (!empty($survey_site)) {
			$where_clauses[] = "s.`survey_site` = " . $this->db->escape($survey_site);
		}

		// Lọc theo status
		if (!empty($status)) {
			if ($status == 1) {
				// Completed: USD_value > 0.05 hoặc Bonus
				$where_clauses[] = "(s.`USD_value` > 0.05 OR s.`status` = 'Bonus')";
			} elseif ($status == 2) {
				// Rejected
				$where_clauses[] = "s.`status` = 2";
			}
		}

		// Lọc theo range USD_value
		if (!is_null($usd_min)) {
			$where_clauses[] = "s.`USD_value` >= " . floatval($usd_min);
		}
		if (!is_null($usd_max)) {
			$where_clauses[] = "s.`USD_value` <= " . floatval($usd_max);
		}

		// Ghép điều kiện WHERE
		$where = "";
		if (!empty($where_clauses)) {
			$where = " WHERE " . implode(" AND ", $where_clauses);
		}

		// Lấy dữ liệu
		$query = $this->db->query("
			SELECT s.*, u.country
			FROM `ez_surveys` AS s
			LEFT JOIN `ez_users` AS u ON s.user_id = u.user_id
			{$where}
			ORDER BY s.`survey_id` DESC
			LIMIT {$this->limit_entries} OFFSET " . ($this->limit_entries * ($page_id - 1))
		);

		// Lấy thống kê
		$query2 = $this->db->query("
			SELECT 
				COUNT(s.`survey_id`) AS total_records,
				SUM(s.`earning_amount`) AS total_amount,
				SUM(s.`USD_value`) AS total_USD
			FROM `ez_surveys` AS s
			LEFT JOIN `ez_users` AS u ON s.user_id = u.user_id
			{$where}
		");

		if ($query->num_rows() > 0) {
			$data = $query->result();
		}

		if ($query2->num_rows() > 0) {
			$result = $query2->row();
			$total_records = $result->total_records;
			$total_amount  = $result->total_amount;
			$total_USD     = $result->total_USD;
		}

		$total_pages = ceil($total_records / $this->limit_entries);

		return [
			'data'        => $data,
			'total_pages' => $total_pages,
			'statistics'  => [
				'total_surveys' => $total_records,
				'total_amount'  => $total_amount,
				'total_USD'     => $total_USD
			]
		];
	}
	
	 public function update_survey_amount($site, $trans_id, $new_amount, $new_usd_value = null) {
        $data = array(
            'earning_amount' => $new_amount,
			'time'			=> time(),
			'date'			=> date('Y-m-d'),
        );

        if ($new_usd_value !== null) {
            $data['USD_value'] = $new_usd_value;
        }

        $this->db->where('survey_site', $site);
        $this->db->where('trans_id', $trans_id);
        return $this->db->update('ez_surveys', $data);
    }

}
?>