<?php
class StatisticModel extends CI_Model {
	
	public $limit_entries = 20;
	
	function __construct() {
		parent::__construct();
		$this->load->database();
	}
	
	function set_statistic_by_date($statistic_key, $statistic_value, $date) {
		$sql = "SELECT * FROM `ez_statistics` WHERE statistic_key = ? AND date = ? ORDER BY `statistic_id` DESC LIMIT 1";
		$query = $this->db->query($sql, array($statistic_key, $date));
		if($query->num_rows() > 0) {
			$data = $query->result()[0];
			$this->db->set('statistic_value', $statistic_value);
			$this->db->set('updated_time', time());
			$this->db->where('statistic_id', $data->statistic_id);
			$this->db->update('ez_statistics');
			
			//sync_data
			$this->auto_sync_statistic_data(array(
				'statistic_id'	=> $data->statistic_id,
				'statistic_key'	=> $statistic_key,
				'statistic_value'	=> $statistic_value,
				'date'	=> $date,
				'updated_time'	=> time(),
			));
			//sync_data
			
			
			return $data->statistic_id;
		} else {
			$data = array(
				'statistic_key'		=> $statistic_key,
				'statistic_value ' 	=> $statistic_value,
				'date' 				=> $date,
				'updated_time' 		=> time(),
			);
			$this->db->insert('ez_statistics', $data);
			$insert_id = $this->db->insert_id();
			
			//sync_data
			$this->auto_sync_statistic_data(array(
				'statistic_id'	=> $insert_id,
				'statistic_key'	=> $statistic_key,
				'statistic_value'	=> $statistic_value,
				'date'	=> $date,
				'updated_time'	=> time(),
			));
			//sync_data
			
			return $insert_id;
		}
	}
	
	function get_statistic_by_date($statistic_key, $date = 0) {
		if($date != 0) {
			$sql = "SELECT * FROM `ez_statistics` WHERE `statistic_key` = ? AND `date` = ? ORDER BY `statistic_id` DESC LIMIT 1";
			$query = $this->db->query($sql, array($statistic_key, $date));
		} else {
			$sql = "SELECT * FROM `ez_statistics` WHERE `statistic_key` = ? ORDER BY `statistic_id` DESC LIMIT 1";
			$query = $this->db->query($sql, array($statistic_key));
		}
		if($query->num_rows() > 0) {
			return $query->result()[0]->statistic_value;
		} else {
			return 0;
		}
	}
	
	public function get_statistics($key) {
		$sql = "SELECT * FROM `ez_statistics` WHERE `statistic_key` = ? ORDER BY `statistic_id` DESC LIMIT 10";
		$query = $this->db->query($sql, array($key));
		$labels = array();
		$data = array();
		if($query->num_rows() > 0) {
			$result = array_reverse($query->result());
			foreach($result as $row) {
				array_push($labels, $row->date);
				if($key == 'deposits' || $key == 'withdrawals' || $key == 'survey_reward_amount') {
					$row->statistic_value = $row->statistic_value / 100000000;
				}
				array_push($data, $row->statistic_value);
			}
		} 		
		return array(json_encode($labels), json_encode($data));
	}
	
	public function get_statistics_by_month($key) {
		$sql = "SELECT SUM(statistic_value) AS `statistic_value`, DATE_FORMAT(FROM_UNIXTIME(`updated_time`), '%m-%Y') AS `month` FROM `ez_statistics` WHERE statistic_key = ? GROUP BY `month` ORDER BY MAX(`updated_time`) DESC LIMIT 12";
		$query = $this->db->query($sql, array($key));
		$labels = array();
		$data = array();
		if($query->num_rows() > 0) {
			$result = array_reverse($query->result());
			foreach($result as $row) {
				array_push($labels, $row->month);
				if($key == 'deposits' || $key == 'withdrawals' || $key == 'survey_reward_amount') {
					$row->statistic_value = $row->statistic_value / 100000000;
				}
				array_push($data, $row->statistic_value);
			}
		} 		
		return array(json_encode($labels), json_encode($data));
	}
	
	///12062024//
	public function get_registered_users_by_dates($referrer) {
		$sql = "SELECT COUNT(user_id) AS `registered_users`, DATE_FORMAT(FROM_UNIXTIME(`registered_time`), '%d-%m-%Y') AS `date`, MAX(`registered_time`) AS `registered_time` FROM `ez_users` WHERE referrer = ? GROUP BY DATE_FORMAT(FROM_UNIXTIME(`registered_time`), '%d-%m-%Y') ORDER BY `registered_time` DESC LIMIT 30";
		$query = $this->db->query($sql, array($referrer));
		$labels = array();
		$data = array();
		if($query->num_rows() > 0) {
			$result = array_reverse($query->result());
			foreach($result as $row) {
				array_push($labels, $row->date);
				array_push($data, $row->registered_users);
			}
			return array(json_encode($labels), json_encode($data));
		} 		
		return null;
	}
	
	
	public function get_user_bonuses_by_dates($user_id) {
		$sql = "SELECT SUM(amount) / 100000000 AS `total_amount`, DATE_FORMAT(FROM_UNIXTIME(`time`), '%d-%m-%Y') AS `date`, MAX(`time`) AS time FROM `ez_bonuses` WHERE user_id = ? AND (`message` LIKE '%Referral commissions%' OR `message` LIKE '%Auto claim commissions%') GROUP BY `date` ORDER BY `time` DESC LIMIT 30;";
		$query = $this->db->query($sql, array($user_id));
		$labels = array();
		$data = array();
		if($query->num_rows() > 0) {
			$result = array_reverse($query->result());
			foreach($result as $row) {
				array_push($labels, $row->date);
				array_push($data, $row->total_amount);
			}
			return array(json_encode($labels), json_encode($data));
		} 		
		return null;
	}
	
	public function get_user_revenue_by_date($referrer) {
		$sql = "SELECT SUM(IF(r.type = 'Deposit', r.amount, -r.amount)) / 100000000 AS total_amount, date, MAX(r.created_time) AS time FROM ez_requests r JOIN ez_users u ON r.user_id = u.user_id WHERE u.referrer = ? GROUP BY date ORDER BY time DESC LIMIT 30;";
		$query = $this->db->query($sql, array($referrer));
		$labels = array();
		$data = array();
		if($query->num_rows() > 0) {
			$result = array_reverse($query->result());
			foreach($result as $row) {
				array_push($labels, $row->date);
				array_push($data, $row->total_amount);
			}
			return array(json_encode($labels), json_encode($data));
		} 		
		return null;
	}
	///12062024//
	
	//sync_data
	public function auto_sync_statistic_data($statistic_data) {
		$apiUrl = 'http://'.SYNC_DATA_IP.'/backup/bnbpick/statistics.php';
		$jsonData = json_encode($statistic_data);
		$cmd = "curl -X POST -H 'Content-Type: application/json' -d '$jsonData' '$apiUrl' > /dev/null 2>&1 &";
		exec($cmd);
	}
	//sync_data
	
}
?>