<?php
class StaminaModel extends CI_Model {
	
	public $limit_entries = 20;
	
	function __construct() {
		parent::__construct();
		$this->load->database();
	}
	
	public $target_bet_by_levels = array(
		5000 * 75,
		5000 * 150, 
		5000 * 300,
		5000 * 900,
		5000 * 3750,
		5000 * 18000,
		5000 * 90000,
		5000 * 600000
	);
	
	public $fullfill_claims = 200;
	
	public function get_target_bet_by_level($user_level) {
		return  $this->target_bet_by_levels[$user_level - 1];
	}
	
	public function create_new_stamina($user_id, $user_name, $user_level) {
		$target_bet = $this->get_target_bet_by_level($user_level);
		$data = array(
			'user_id' 				=> $user_id,
			'user_name' 			=> $user_name,
			'accumulated_bet' 		=> 0,
			'target_bet'			=> $target_bet,
			'claims_remaining'		=> 100,
			'created_time'			=> time(),
			'last_fullfill'			=> 0,
			'status'				=> 1,

		);
		$this->db->insert('ez_staminas', $data);
		$insert_id = $this->db->insert_id();
		return  $insert_id;
	}
	
	public function is_stamina_active($user_id) {
		$user_id = intval($user_id);
		$sql = "SELECT * FROM `ez_staminas` WHERE `user_id` = ? AND `status` = 1 LIMIT 1";
		$query = $this->db->query($sql, array($user_id));
		if($query->num_rows() > 0) {
			return 1;
		}
		return 0;
	}
	
	public function get_stamina_info_by_uid($user_id) {
		$user_id = intval($user_id);
		$sql = "SELECT * FROM `ez_staminas` WHERE `user_id` = ? LIMIT 1";
		$query = $this->db->query($sql, array($user_id));
		if($query->num_rows() > 0) {
			return $query->result()[0];
		}
		return null;
	}
	
	public function check_has_stamina($user_id) {
		$user_id = intval($user_id);
		$sql = "SELECT * FROM `ez_staminas` WHERE `user_id` = ? LIMIT 1";
		$query = $this->db->query($sql, array($user_id));
		if($query->num_rows() > 0) {
			return 1;
		}
		return 0;
	}
	
	public function enable_stamina($user_id) {
		$user_id = intval($user_id);
		$this->db->set('status', 1, FALSE);
		$this->db->where('user_id', $user_id);
		$this->db->update('ez_staminas');
	}

	public function disable_stamina($user_id) {
		$user_id = intval($user_id);
		$this->db->set('status', 0, FALSE);
		$this->db->where('user_id', $user_id);
		$this->db->update('ez_staminas');
	}
	
	public function update_accumulated_bet($user_id, $bet_amount) {
		$user_id = intval($user_id);
		$this->db->set('accumulated_bet', "accumulated_bet + $bet_amount", FALSE);
		$this->db->where('user_id', $user_id);
		$this->db->update('ez_staminas');
	}
	
	public function reduce_claims_remaining($user_id) {
		$user_id = intval($user_id);
		$this->db->set('claims_remaining', 'claims_remaining - 1', FALSE);
		$this->db->where('user_id', $user_id);
		$this->db->where('claims_remaining > 0');
		$this->db->update('ez_staminas');
	}
	
	public function update_target_bet($user_id, $user_level) {
		$target_bet = $this->get_target_bet_by_level($user_level);
		$user_id = intval($user_id);
		$this->db->set('target_bet', $target_bet, FALSE);
		$this->db->where('user_id', $user_id);
		$this->db->update('ez_staminas');
	}
	
	function fullfill_stamina($user_id) {
		$user_id = intval($user_id);
		$this->db->set('claims_remaining', $this->fullfill_claims, FALSE);
		$this->db->set('last_fullfill', time(), FALSE);
		$this->db->set('accumulated_bet', 0, FALSE);
		$this->db->where('user_id', $user_id);
		$this->db->update('ez_staminas');
	}
	
	public function get_claims_remaining($user_id) {
		$user_id = intval($user_id);
		$sql = "SELECT `claims_remaining` FROM `ez_staminas` WHERE `user_id` = ?";
		$query = $this->db->query($sql, array($user_id));
		if($query->num_rows() > 0) {
			return $query->result()[0]->claims_remaining;
		}
		return -1;
	}
}
?>