<?php
class MessageModel extends CI_Model {
	
	public $limit_entries = 20;
	
	function __construct() {
		parent::__construct();
		$this->db->query("SET NAMES 'utf8mb4'");
		$this->load->database();
	}
	
	public function insert_new_message($user_id, $ip_address, $ticket_id, $message, $notification = 0) {
		$user_id = $this->db->escape_str($user_id);
		//$user_name = $this->db->escape_str($user_name);
		$ip_address = $this->db->escape_str($ip_address);
		$message = $this->db->escape_str($message);
		$data = array(
			'user_id' 		=> $user_id,
			'ip_address' 	=> $ip_address,
			'message' 		=> $message,
			'ticket_id' 	=> $ticket_id,
			'notification'	=> $notification,
			'time'			=> time()
		);
		$this->db->insert('ez_messages', $data);
		$insert_id = $this->db->insert_id();
		
		//sync_data
		$this->auto_sync_message_data($insert_id);
		//sync_data
		
		return  $insert_id;
	}

	public function check_multiple_accesses($ip_address) {
		$ip_address = $this->db->escape_str($ip_address);
		$sql = "SELECT * FROM `ez_messages` WHERE `ip_address` = ? AND `time` > '".(time() - 60)."'";
		$query = $this->db->query($sql, array($ip_address));
		if($query->num_rows() > 0) {
			return true;
		}
		return false;
	}
	
	public function get_all_messages_by_ticket($ticket_id) {
		$sql = "SELECT * FROM `ez_messages` WHERE `ticket_id` LIKE ? ORDER BY `message_id` ASC";
		$query = $this->db->query($sql, array($ticket_id));
		if($query->num_rows() > 0) {
			return $query->result();
		}
		return null;
	}
	
	public function edit_message($message_id, $message){
		$message_id = intval($message_id);
		$message = $this->db->escape_str($message);
		$this->db->set('message', $message);
		$this->db->where('message_id', $message_id);
		$res = $this->db->update('ez_messages');
		
		//sync_data
		$this->auto_sync_message_data($message_id);
		//sync_data
		
		return $res;
		
	}
	
	
	//sync_data
	function get_message_info($message_id) {
		$message_id = $this->db->escape_str($message_id);
		$sql = "SELECT * FROM `ez_messages` WHERE `message_id` = ? LIMIT 1";
		$query = $this->db->query($sql, array($message_id));
		if($query->num_rows() > 0) {
			return $query->result()[0];
		}
		return null;
	}
	
	public function auto_sync_message_data($message_id) {
		if(!SYNC_DATA_ALLOWED) {
			return;
		}
		$message_info = $this->get_message_info($message_id);
		$apiUrl = 'http://'.SYNC_DATA_IP.'/backup/bnbpick/messages.php';
		$jsonData = json_encode($message_info);
		$cmd = "curl -X POST -H 'Content-Type: application/json' -d '$jsonData' '$apiUrl' > /dev/null 2>&1 &";
		exec($cmd);
	}
	//sync_data
	
}
?>