<?php
class GiftModel extends CI_Model {
	
	public $limit_entries = 20;
	
	function __construct() {
		parent::__construct();
		$this->load->database();
	}
	
	public function create_gift($gift_code, $user_id, $amount, $note = '') {
		$gift_code = $this->db->escape_str($gift_code);
		$user_id = $this->db->escape_str($user_id);
		$amount = $this->db->escape_str($amount);
		$data = array(
			'gift_code' 	=> $gift_code,
			'user_id' 		=> $user_id,
			'amount' 		=> $amount,
			'created_time ' => time(),
			'note' 			=> $note,
		);
		$this->db->insert('ez_gifts', $data);
		$insert_id = $this->db->insert_id();
		return  $insert_id;
	}
	
	public function apply_gift_code($gift_id, $user_id) {
		$user_id = $this->db->escape_str($user_id);
		$gift_id = $this->db->escape_str($gift_id);
		$gift_id = intval($gift_id);
		$user_id = intval($user_id);
		$this->db->set('user_id', $user_id, FALSE);
		$this->db->set('active_time', time(), FALSE);
		$this->db->set('expired_time', time(), FALSE);
		$this->db->where('gift_id', $gift_id);
		$this->db->update('ez_gifts');
	}

	public function get_gift_info_by_gift_code($gift_code) {
		$gift_code = $this->db->escape_str($gift_code);
		$gift_code = strtoupper(preg_replace('/[^\da-zA-Z0-9]/', '', $gift_code));
		$sql = "SELECT * FROM `ez_gifts` WHERE REPLACE(`gift_code`, '-', '') = ? LIMIT 1";
		$query = $this->db->query($sql, array($gift_code));
		if($query->num_rows() > 0) {
			return $query->result()[0];
		}
		return null;
	}
	
	public function get_gift_cards_by_user_id($user_id, $page_id = 1) {
		$user_id = $this->db->escape_str($user_id);
		$user_id = intval($user_id);
		$page_id = max(intval($page_id), 1);
		$sql = "SELECT * FROM `ez_gifts` WHERE `user_id` = ? AND `active_time` != '0' ORDER BY `gift_id` DESC LIMIT ".$this->limit_entries." OFFSET ".($this->limit_entries * ($page_id - 1));
		$query = $this->db->query($sql, array($user_id));
		if($query->num_rows() > 0) {
			return $query->result();
		}
		return null;
	}
	
	public function get_statistics($user_id = 0) {
		if($user_id != 0) {
			$sql = "SELECT COUNT(`gift_id`) AS `total_gifts`, SUM(`amount`) AS `total_amount`, MAX(`amount`) AS `max_amount` FROM `ez_gifts` WHERE `user_id` = ?";
			$query = $this->db->query($sql, array($user_id));
		} else {
			$sql = "SELECT COUNT(`gift_id`) AS `total_gifts`, SUM(`amount`) AS `total_amount`, MAX(`amount`) AS `max_amount` FROM `ez_gifts`";
			$query = $this->db->query($sql);
		}
		if($query->num_rows() > 0) {
			return $query->result()[0];
		}
		return null;
	}

	public function load_user_gifts($user_id, $page_id = 1, $show_all_gifts = true) {
		$user_id = $this->db->escape_str($user_id);
		if($show_all_gifts) {
			if($user_id != 0) {
				$sql = "SELECT `gift_id` AS `id`, `gift_code`, `ez_gifts`.`user_id` AS `uid`, `amount`, `created_time`, `active_time`, `user_name` FROM `ez_gifts`, `ez_users` WHERE `ez_gifts`.`user_id` = `ez_users`.`user_id` AND `ez_gifts`.`user_id` = ? ORDER BY `gift_id` DESC LIMIT ".$this->limit_entries." OFFSET ".($this->limit_entries * ($page_id - 1));
				$query = $this->db->query($sql, array($user_id));
			} else {
				$sql = "SELECT `gift_id` AS `id`, `gift_code`, `ez_gifts`.`user_id` AS `uid`, `amount`, `created_time`, `active_time`, `user_name` FROM `ez_gifts`, `ez_users` WHERE `ez_gifts`.`user_id` = `ez_users`.`user_id` AND `gift_code` NOT LIKE '%HPNY-%' ORDER BY `gift_id` DESC LIMIT ".$this->limit_entries." OFFSET ".($this->limit_entries * ($page_id - 1));
				$query = $this->db->query($sql);
			}
		} else {
			$sql = "SELECT `gift_id` AS `id`, `gift_code`, `ez_gifts`.`user_id` AS `uid`, `amount`, `created_time`, `active_time`, `user_name` FROM `ez_gifts`, `ez_users` WHERE `ez_gifts`.`user_id` = `ez_users`.`user_id` AND `ez_gifts`.`user_id` = ? AND `ez_gifts`.`active_time` != 0 ORDER BY `gift_id` DESC LIMIT ".$this->limit_entries." OFFSET ".($this->limit_entries * ($page_id - 1));
			$query = $this->db->query($sql, array($user_id));
		}
	
		
		if($query->num_rows() > 0) {
			return $query->result();
		}
		return null;
	}
	
}
?>