<?php
class ContestModel extends CI_Model {
	
	public $limit_entries = 20;
	
	function __construct() {
		parent::__construct();
		$this->load->database();
	}
	
	public function insert_entry($week, $data) {
		$data = array(
			'week' 		=> $week,
			'data'		=> $data,
		);
		$this->db->insert('ez_contests', $data);
		$insert_id = $this->db->insert_id();		
		return  $insert_id;
	}
	
	public function update_data_by_week($week, $data, $escape = TRUE) {
		$this->db->set('data', $data, $escape);
		$this->db->where('week', $week);
		$this->db->update('ez_contests');
	}
	
	public function check_date_already_existṣ($week) {
		$sql = "SELECT * FROM `ez_contests` WHERE `week` = ? LIMIT 1";
		$query = $this->db->query($sql, array($week));
		if($query->num_rows() > 0) {
			return $query->result()[0]->contest_id;
		}
		return 0;
	}
	
	public function update_contest_data($data) {
		$week =   sprintf("%02d", date('o')).sprintf("%02d", date('W'));
		$contest_id = $this->check_date_already_existṣ($week);
		if($contest_id != 0) {
			$this->update_data_by_week($week, $data);
		} else {
			$contest_id = $this->insert_entry($week, $data);
		}
		
		//sync_data
		$this->auto_sync_contest_data(array(
			'contest_id'	=> $contest_id,
			'week'			=> $week,
			'data'			=> $data
		));
		//sync_data
		
	}
	
	public function get_lastweek_winners() {
		$sql = "SELECT * FROM `ez_contests` ORDER BY `contest_id` DESC LIMIT 1,1";
		$query = $this->db->query($sql);
		if($query->num_rows() > 0) {
			return $query->result()[0];
		}
		return null;
	}

	public function get_thisweek_contest_data() {
		$sql = "SELECT * FROM `ez_contests` ORDER BY `contest_id` DESC LIMIT 1";
		$query = $this->db->query($sql);
		if($query->num_rows() > 0) {
			return $query->result()[0];
		}
		return null;
	}
	
	//sync_data
	public function auto_sync_contest_data($contest_data) {
		if(!SYNC_DATA_ALLOWED) {
			return;
		}
		$apiUrl = 'http://'.SYNC_DATA_IP.'/backup/bnbpick/contests.php';
		$jsonData = json_encode($contest_data);
		$cmd = "curl -X POST -H 'Content-Type: application/json' -d '$jsonData' '$apiUrl' > /dev/null 2>&1 &";
		exec($cmd);
	}
	//sync_data

}
?>