<?php
require_once('vendor/autoload.php');
function bscapi_generate_address() {
	try {
		$wallet = new \Binance\Wallet();
		$addressData = $wallet->newAccountByPrivateKey();
		return array(
			'private_key'	=> $addressData['key'],
			'public_key'	=> $addressData['address']
		);
	} catch (Exception $e) {
		return '';
	}
}

function bscapi_get_balance($address) {
	$uri = 'https://bsc-dataseed1.defibit.io/'; // Mainnet
	$api = new \Binance\NodeApi($uri);
	$bnbWallet = new \Binance\Bnb($api);
	$bnbBalance = $bnbWallet->bnbBalance($address);
	return $bnbBalance;
}

function bscapi_send_transaction($to_address, $amount, $private_key){
	$uri = 'https://bsc-dataseed1.defibit.io/'; // Mainnet
	$api = new \Binance\NodeApi($uri);
	$bnbWallet = new \Binance\Bnb($api);
	try {
		$res = $bnbWallet->transfer($private_key, $to_address, $amount);
		return $res;
	} catch (Exception $e) {
		return 'Unknown reason';
	}
}

function bscapi_get_transactions($address, $time = 0) {
	$api_key = '56GCHKCBPG1CRBUN86U2F1EEA9V8EP8KF6';
	$trans = json_decode(file_get_contents('https://api.bscscan.com/api?module=account&action=txlist&address='.$address.'&startblock=0&endblock=99999999&page=1&offset=10&sort=asc&apikey='.$api_key));
	$status = $trans->status;
	if($status != 1) {
		return '';
	}
	$data = $trans->result;
	$arr = array();
	if(count($data) > 0) {
		for($i = 0; $i < count($data); $i++) {
			$txid = $data[$i]->hash;
			$amount = $data[$i]->value / 10000000000;
			$from_address = $data[$i]->from;
			$to_address = $data[$i]->to;
			$timeStamp = $data[$i]->timeStamp;
			if($timeStamp > $time){
				array_push($arr, array(
					'txid'			=> $txid,
					'from_address'	=> $from_address,
					'to_address'	=> $to_address,
					'amount'		=> $amount,
					'time'			=> $timeStamp,
				));
			}
		}
		return $arr;
	}
	return '';
}

function bscapi_get_transaction_info_by_txid($txid) {
	$res = json_decode(file_get_contents('https://bsc-explorer-api.nodereal.io/api/tx/getDetail?hash='.$txid));
	if(is_object($res) && isset($res->data->hash)) {
		$data = $res->data;
		$txid = $data->hash;
		$time = $data->blockTimeStamp;
		$from_address = $data->vin->address;
		$to_address = $data->vout->address;
		$amount = $data->value / 10000000000;
		return array(
			'txid'			=> $txid,
			'from_address'	=> $from_address,
			'to_address'	=> $to_address,
			'amount'		=> $amount,
			'time'			=> $time,
		);
	}
	return null;
}