<?php
    Class LangPT {
        public $langs = array(
            'under_maintenance' => 'O site está em manutenção. Por favor, volte mais tarde!',
            'connection_timeout_err' => 'Tempo limite de conexão, tente novamente mais tarde!',
            'invalid_input_err' => 'Entrada inválida!',
            'username_min_length_err' => 'O nome de usuário deve ter pelo menos 6 caracteres!',
            'username_max_length_err' => 'O nome de usuário deve ter no máximo 16 caracteres!',
            'username_invalid_chars_err' => 'Apenas caracteres alfanuméricos!',
            'email_invalid_err' => 'O e-mail deve ser válido!',
            'email_invalid_suppliers_err' => 'Não é permitido usar este e-mail para registro. Escolha um e-mail de outro provedor!',
            'password_min_length_err' => 'A senha deve ter pelo menos 6 caracteres!',
            'password_max_length_err' => 'A senha deve ter no máximo 32 caracteres!',
            'passwords_not_match_err' => 'As senhas não coincidem!',
            'captcha_incorrect_err' => 'Código captcha inválido. Por favor, tente novamente!',
            'signup_too_often_err' => 'Muitos acessos deste endereço IP. Tente novamente mais tarde!',
            'username_exists_err' => 'Nome de usuário já existe!',
            'email_exists_err' => 'E-mail já existe!',
            'country_not_allowed_err' => 'País não permitido!',
            'undefined_err' => 'Algo deu errado!',
            'register_success' => 'Sua conta foi registrada com sucesso!',
            'empty_fields_err' => 'Todos os campos não podem estar vazios!',
            'incorrect_username_or_password_err' => 'Digite o nome de usuário ou a senha corretos!',
            'account_banned_err' => 'Sua conta foi banida permanentemente. Motivo: violação de política!',
            'incorrect_2FA_err' => 'Digite o código 2FA correto para continuar!',
            'login_success' => 'Login realizado com sucesso!',
            'send_mail_too_often_err' => 'Aguarde 5 minutos antes de solicitar outro e-mail!',
            'email_not_exists_err' => 'Seu endereço de e-mail não está registrado!',
            'send_verify_email_success' => 'Enviamos um e-mail com um link de confirmação para %s. Clique neste link para continuar. Este link expira em 2 horas.',
            'unavailable_feature_err' => 'Este recurso está indisponível no momento',
            'verified_email_err' => 'Seu e-mail já foi verificado!',
            'login_required_err' => 'É necessário fazer login para continuar!',
            'logout_success' => 'Saindo!',
            'captcha_incorrect_many_times_err' => 'Captcha incorreto várias vezes. Tente novamente em 10 minutos!',
            'wait_hourly_faucet' => 'Aguarde %d minutos, %d segundos para a próxima coleta!',
            'claim_success' => 'Você ganhou %.8f BNB!',
            'out_of_spins_err' => 'Sem giros restantes. Para ganhar mais giros de bônus, jogue mais nossos jogos!',
            'dismiss_noti_success' => 'Notificação dispensada com sucesso!',
            'empty_commission_balance_err' => 'Seu saldo de comissões disponível está vazio!',
            'invalid_gift_code_err' => 'Insira um código de presente válido!',
            'incorrect_gift_code_err' => 'Este código de presente é inválido ou foi excluído!',
            'used_gift_code_err' => 'Este código de presente já foi utilizado!',
            'apply_gift_success' => 'Código de presente aplicado com sucesso!',
            'password_changed_success' => 'Senha alterada com sucesso!',
            'incorrect_ver_code_err' => 'O código de verificação não existe ou expirou!',
            'incorrect_2FA_err2' => 'É necessário fornecer um token válido para ativar o 2FA na sua conta!',
            '2FA_enabled_success' => '2FA ativado!',
            '2FA_disabled_success' => '2FA desativado!',
            'incorrect_password_err' => 'Senha incorreta!',
            'update_privacy_success' => 'Privacidade atualizada com sucesso!',
            'update_commission_share_success' => 'Compartilhamento de comissão atualizado com sucesso!',
            'verification_required_err' => 'Por favor, verifique seu e-mail antes de fazer retiradas!',
            'invalid_address_err' => 'Insira um endereço de retirada válido!',
            'balance_not_enough_err' => 'Você tem menos de %.8f BNB. Aguarde o valor mínimo!',
            'withdrawal_amount_too_less_err' => 'O valor mínimo de retirada é %.8f BNB!',
            'amount_too_much_err' => 'O valor da retirada é maior que o saldo da sua conta!',
            'withdraw_too_often_err' => 'Você está tentando retirar com muita frequência. Tente novamente mais tarde!',
            'withdrawal_being_processed' => 'Sua solicitação de retirada está em processamento!',
            'withdrawal_confirmation_required' => 'Por favor, confirme a solicitação de retirada clicando no link que enviamos ao seu e-mail!',
            'transaction_not_exist_err' => 'Esta solicitação não existe!',
            'transaction_not_exist_err2' => 'A solicitação foi cancelada ou não existe!',
            'transaction_canceled_success' => 'Sua solicitação foi cancelada!',
            'feature_being_upgrade' => 'Este recurso está sendo atualizado!',
            'empty_email_err' => 'Insira seu e-mail!',
            'invalid_email_err' => 'Seu e-mail não é válido!',
            'empty_subject_err' => 'Insira o assunto!',
            'empty_message_err' => 'Insira a mensagem!',
            'send_message_too_often_err' => 'Envie cada mensagem com 1 minuto de intervalo!',
            'ticket_closed' => 'Este ticket está fechado!',
            'send_message_success' => 'Sua mensagem foi enviada com sucesso!',
            'empty_client_seed_err' => 'Insira seu seed de cliente!',
            'change_client_seed_success' => 'Seed do cliente alterado com sucesso!',
            'bet_amount_too_less_err' => 'O valor da aposta deve ser no mínimo %.8f BNB!',
            'insufficient_balance_err' => 'Saldo insuficiente!',
            'bet_amount_too_much_err' => 'O valor da aposta deve ser no máximo %.8f BNB!',
            'min_payout_err' => 'O pagamento mínimo deve ser maior ou igual a %f!',
            'max_payout_err' => 'O pagamento máximo deve ser menor ou igual a %f!',
			'min_multiplier_err' => 'O multiplicador mínimo deve ser maior ou igual a %f!', //MIN MULTIPLIER
			'max_multiplier_err' => 'O multiplicador máximo deve ser menor ou igual a %f!', //MAX MULTIPLIER
            'select_lower_higher' => 'Por favor, selecione menor ou maior!',
            'select_inside_outside' => 'Por favor, selecione dentro ou fora!',
            'connection_timeout' => 'Tempo limite de conexão!',
            'create_game_err' => 'Não foi possível criar um novo jogo!',
            'select_difficulty_err' => 'Por favor, selecione a dificuldade!',
            'create_game_success' => 'Novo jogo criado com sucesso!',
            'unstarted_game_err' => 'Por favor, clique em iniciar primeiro!',
            'choose_tile_err' => 'Escolha o tile correto!',
            'open_a_bomb' => 'Você abriu uma bomba!',
            'open_a_gem' => 'Você abriu uma gema!',
            'open_all_gems' => 'Você abriu todas as gemas!',
            'no_tiles_selected_err' => 'Selecione pelo menos um tile!',
            'cashout_success' => 'Aposta sacada com sucesso!',
            'select_num_mines_err' => 'Por favor, selecione o número de minas!',
            'select_num_lines_err' => 'Por favor, selecione o número de linhas',
            'tile_chosen_err' => 'Este tile já foi escolhido!',
            'game_created_err' => 'Você já possui um jogo ativo. Termine este antes de iniciar um novo!',
            'tile_limited_err' => 'Número de tiles além do limite!',
            'unexpected_err' => 'Erro inesperado!',
            'select_player_banker_err' => 'Por favor, selecione banqueiro, jogador ou empate!',
            'invalid_start_card_err' => 'Carta inicial inválida!',
            'you_lose' => 'Você perdeu!',
            'open_new_card' => 'Você abriu uma nova carta!',
            'can_not_cashout_err' => 'Não é possível sacar!',
            'invalid_txid_err' => 'Insira um ID de transação válido!',
            'invalid_network_err' => 'Rede inválida!',
            'credited_txid_err' => 'A transação já foi creditada!',
            'update_transaction_success' => 'Transação atualizada com sucesso!',
            'load_data_success' => 'Dados carregados com sucesso!',
            'invalid_game_id_err' => 'ID do jogo não existe!',
            'load_game_seed_failed' => 'Não é possível carregar os seeds do jogo!',
            'deposit_credited_success' => 'Depósito de %.8f BNB realizado com sucesso!',
			'game_dice'							=> 	'Dados',
			'game_slots'						=> 	'Caça-níqueis',
			'game_gems'							=> 	'Gemas',
			'game_mines'						=> 	'Minas',
			'game_video_poker'					=> 	'Video Poker',
			'game_baccarat'						=> 	'Baccarat',
			'game_high_low'						=> 	'Alto-Baixo',
			'game_roulette'						=> 	'Roleta',
			'game_wof'							=> 	'Roda da Fortuna',
			'game_plinko'						=> 	'Plinko',
			'game_limbo'						=> 	'Limbo',
			'game_ultimate'						=> 	'Dados Definitivos',
        );

        public function __construct() {}

        public function print($key, ...$params) {
            if (isset($this->langs[$key])) {
                if (!empty($params)) {
                    return vsprintf($this->langs[$key], $params);
                }
                return $this->langs[$key];
            }
            return '';
        }
    }
?>