<?php
	Class LangID {
		public $langs = array(
			'under_maintenance'					=>	'Situs sedang dalam proses pemeliharaan. Silakan kembali nanti!',
			'connection_timeout_err'			=>  'Batas waktu koneksi habis, silakan coba lagi nanti!',
			'invalid_input_err'					=>  'Input tidak valid!',
			'username_min_length_err'			=>	'Nama pengguna minimal harus 6 karakter!',
			'username_max_length_err'			=>	'Nama pengguna maksimal harus 16 karakter!',
			'username_invalid_chars_err'		=>	'Hanya masukan alfanumerik!',
			'email_invalid_err'					=>	'Email harus berupa alamat email yang valid!',
			'email_invalid_suppliers_err'		=>	'Anda tidak dapat menggunakan email ini untuk mendaftar. Silakan pilih email dari penyedia lain!',
			'password_min_length_err'			=>	'Kata sandi minimal harus 6 karakter!',
			'password_max_length_err'			=>	'Kata sandi maksimal harus 32 karakter!',
			'passwords_not_match_err'			=>	'Kata sandi tidak cocok!',
			'captcha_incorrect_err'				=>	'Kode captcha tidak valid. Silakan coba lagi!',
			'signup_too_often_err'				=>	'Terlalu banyak akses dari alamat IP ini. Silakan coba lagi nanti!',
			'username_exists_err'				=>	'Nama pengguna sudah ada!',
			'email_exists_err'					=>	'Email sudah terdaftar!',
			'country_not_allowed_err'			=>	'Negara tidak diizinkan!',
			'undefined_err'						=>	'Ada yang salah!',
			'register_success'					=>	'Akun Anda telah berhasil terdaftar!',
			'empty_fields_err'					=>	'Semua kolom tidak boleh kosong!',
			'incorrect_username_or_password_err'=>	'Harap masukkan nama pengguna atau kata sandi yang benar!',
			'account_banned_err'				=>	'Akun Anda telah diblokir secara permanen. Alasan: pelanggaran kebijakan!',
			'incorrect_2FA_err'					=>	'Harap masukkan kode 2FA yang benar untuk melanjutkan!',
			'login_success'						=>	'Berhasil login!',
			'send_mail_too_often_err'			=>	'Tunggu 5 menit sebelum meminta email lain!',
			'email_not_exists_err'				=>	'Alamat email Anda tidak terdaftar!',
			'send_verify_email_success'			=>	'Kami telah mengirimkan email dengan tautan konfirmasi ke %s. Anda perlu mengklik tautan ini untuk melanjutkan. Tautan ini akan kedaluwarsa dalam 2 jam.', 
			'unavailable_feature_err'			=>	'Fitur ini saat ini tidak tersedia',
			'verified_email_err'				=>	'Email Anda sudah terverifikasi!',
			'login_required_err'				=>	'Anda harus login untuk melanjutkan!',
			'logout_success'					=>	'Berhasil logout!',
			'captcha_incorrect_many_times_err'	=>	'Gagal captcha terlalu sering. Silakan coba lagi dalam 10 menit!',
			'wait_hourly_faucet'				=>	'Harap tunggu %d menit, %d detik untuk klaim faucet berikutnya!',
			'claim_success'						=>	'Anda mendapatkan %.8f BNB!',
			'out_of_spins_err'					=>	'Putaran habis. Untuk mendapatkan lebih banyak bonus, silakan mainkan lebih banyak game kami!',
			'dismiss_noti_success'				=>	'Berhasil mengabaikan pemberitahuan!',
			'empty_commission_balance_err'		=>	'Saldo komisi Anda kosong!',
			'invalid_gift_code_err'				=>	'Masukkan kode hadiah yang valid!',
			'incorrect_gift_code_err'			=>	'Kode hadiah ini tidak valid atau sudah dihapus!',
			'used_gift_code_err'				=>	'Kode hadiah ini sudah digunakan!',
			'apply_gift_success'				=>	'Kode hadiah berhasil diterapkan!',
			'password_changed_success'			=>	'Kata sandi berhasil diubah!',
			'incorrect_ver_code_err'			=>	'Kode verifikasi tidak ada atau sudah kedaluwarsa!',
			'incorrect_2FA_err2'				=>	'Anda perlu memberikan token yang valid untuk mengaktifkan 2FA untuk akun Anda!',
			'2FA_enabled_success'				=>	'2FA Diaktifkan!',
			'2FA_disabled_success'				=>	'2FA Dinonaktifkan!',
			'incorrect_password_err'			=>	'Kata sandi tidak benar!',
			'update_privacy_success'			=>	'Pembaruan privasi berhasil!',
			'update_commission_share_success'	=>	'Pembaruan komisi berhasil!',
			'verification_required_err'			=>	'Harap verifikasi email Anda sebelum melakukan penarikan!',
			'invalid_address_err'				=>	'Harap masukkan alamat penarikan yang valid!',
			'balance_not_enough_err'			=>	'Anda memiliki kurang dari %.8f BNB. Tunggu jumlah minimum!',
			'withdrawal_amount_too_less_err'	=>	'Jumlah penarikan minimum adalah %.8f BNB!',
			'amount_too_much_err'				=>	'Jumlah penarikan lebih besar dari saldo akun Anda!',
			'withdraw_too_often_err'			=>	'Anda terlalu sering mencoba. Silakan coba lagi nanti!',
			'withdrawal_being_processed'		=>	'Permintaan penarikan Anda sedang diproses!',
			'withdrawal_confirmation_required'	=>	'Harap konfirmasi permintaan penarikan dengan mengklik tautan yang kami kirimkan ke email Anda!',
			'transaction_not_exist_err'			=>	'Permintaan ini tidak ada!',
			'transaction_not_exist_err2'		=>	'Permintaan telah dibatalkan atau tidak ada!',
			'transaction_canceled_success'		=>	'Permintaan Anda telah dibatalkan!',
			'feature_being_upgrade'				=>	'Fitur ini sedang dalam peningkatan!',
			'empty_email_err'					=>	'Masukkan email Anda!',
			'invalid_email_err'					=>	'Email Anda bukan alamat email yang valid!',
			'empty_subject_err'					=>	'Masukkan subjek!',
			'empty_message_err'					=>	'Masukkan pesan!',
			'send_message_too_often_err'		=>	'Kirim setiap pesan setelah 1 menit!',
			'ticket_closed'						=>	'Tiket ini ditutup!',
			'send_message_success'				=>	'Pesan Anda telah berhasil dikirim!',
			'empty_client_seed_err'				=>	'Masukkan client seed Anda!',
			'change_client_seed_success'		=>	'Berhasil mengganti client seed!',
			'bet_amount_too_less_err'			=>	'Jumlah taruhan harus minimal %.8f BNB!',
			'insufficient_balance_err'			=>	'Saldo tidak mencukupi!',
			'bet_amount_too_much_err'			=>	'Jumlah taruhan harus kurang dari atau sama dengan %.8f BNB!',
			'min_payout_err'					=>	'Pembayaran minimum harus lebih dari atau sama dengan %f!',
			'max_payout_err'					=>	'Pembayaran maksimum harus kurang dari atau sama dengan %f!',
			'min_multiplier_err' => 'Pengali minimum harus lebih dari atau sama dengan %f!', //MIN MULTIPLIER
			'max_multiplier_err' => 'Pengali maksimum harus kurang dari atau sama dengan %f!', //MAX MULTIPLIER
			'select_lower_higher'				=>	'Pilih lebih rendah atau lebih tinggi!',
			'select_inside_outside'				=>	'Pilih di dalam atau di luar!',
			'connection_timeout'				=>	'Batas waktu koneksi habis!',
			'create_game_err'					=>	'Tidak dapat membuat game baru!',
			'select_difficulty_err'				=>	'Pilih tingkat kesulitan!',
			'create_game_success'				=>	'Berhasil membuat game baru!',
			'unstarted_game_err'				=>	'Klik mulai terlebih dahulu!',
			'choose_tile_err'					=>	'Pilih tile yang benar!',
			'open_a_bomb'						=>	'Anda membuka bom!',
			'open_a_gem'						=>	'Anda membuka permata!',
			'open_all_gems'						=>	'Anda membuka semua permata!',
			'no_tiles_selected_err'				=>	'Pilih minimal satu tile!',
			'cashout_success'					=>	'Taruhan berhasil dicairkan!',
			'select_num_mines_err'				=>	'Pilih jumlah ranjau!',
			'select_num_lines_err'				=>	'Pilih jumlah baris',
			'tile_chosen_err'					=>	'Tile ini sudah dipilih!',
			'game_created_err'					=>	'Anda sudah memiliki permainan aktif. Selesaikan yang ini terlebih dahulu sebelum memulai permainan baru!',
			'tile_limited_err'					=>	'Jumlah tile melebihi batas!',
			'unexpected_err'					=>	'Kesalahan tak terduga!',
			'select_player_banker_err'			=>	'Pilih banker, pemain atau seri!',
			'invalid_start_card_err'			=>	'Kartu awal tidak valid!',
			'you_lose'							=>	'Anda kalah!',
			'open_new_card'						=>	'Anda membuka kartu baru!',
			'can_not_cashout_err'				=>	'Anda tidak dapat mencairkan!',
			'invalid_txid_err'					=>	'Masukkan ID transaksi yang valid!',
			'invalid_network_err'				=>	'Jaringan tidak valid!',
			'credited_txid_err'					=>	'Transaksi telah dikreditkan!',
			'update_transaction_success'		=>	'Berhasil memperbarui transaksi!',
			'load_data_success'					=>	'Berhasil memuat data!',
			'invalid_game_id_err'				=>	'ID permainan tidak ada!',
			'load_game_seed_failed'				=>	'Tidak dapat memuat seed game!',
			'deposit_credited_success'			=>	'Anda berhasil melakukan deposit sebesar %.8f BNB!',
			'game_dice'							=> 	'Dadu',
			'game_slots'						=> 	'Slot',
			'game_gems'							=> 	'Permata',
			'game_mines'						=> 	'Ranjau',
			'game_video_poker'					=> 	'Video Poker',
			'game_baccarat'						=> 	'Baccarat',
			'game_high_low'						=> 	'Tinggi-Rendah',
			'game_roulette'						=> 	'Roulette',
			'game_wof'							=> 	'Wheel of Fortune',
			'game_plinko'						=> 	'Plinko',
			'game_limbo'						=> 	'Limbo',
			'game_ultimate'						=> 	'Ultimate Dice',
		);
		
		public function __construct() {}
		
		public function print($key, ...$params) {
			if (isset($this->langs[$key])) {
				if (!empty($params)) {
					return vsprintf($this->langs[$key], $params);
				}
				return $this->langs[$key];
			}
			return '';
		}
	}
?>