<?php
Class LangES {
	public $langs = array(
		'under_maintenance'					=>	'El sitio está en proceso de mantenimiento. ¡Por favor, vuelve más tarde!',
		'connection_timeout_err'			=>  'Tiempo de conexión agotado, ¡intente de nuevo más tarde!',
		'invalid_input_err'					=>  '¡Entrada no válida!',
		'username_min_length_err'			=>	'¡El nombre de usuario debe tener al menos 6 caracteres!',
		'username_max_length_err'			=>	'¡El nombre de usuario debe tener como máximo 16 caracteres!',
		'username_invalid_chars_err'		=>	'¡Solo se permiten caracteres alfanuméricos!',
		'email_invalid_err'					=>	'¡Debe ingresar un correo electrónico válido!',
		'email_invalid_suppliers_err'		=>	'No puedes usar este correo electrónico para registrarte. ¡Elige un correo de otro proveedor!',
		'password_min_length_err'			=>	'¡La contraseña debe tener al menos 6 caracteres!',
		'password_max_length_err'			=>	'¡La contraseña debe tener como máximo 32 caracteres!',
		'passwords_not_match_err'			=>	'¡Las contraseñas no coinciden!',
		'captcha_incorrect_err'				=>	'Código captcha incorrecto. ¡Intente de nuevo!',
		'signup_too_often_err'				=>	'Demasiados accesos desde esta dirección IP. ¡Intente de nuevo más tarde!',
		'username_exists_err'				=>	'¡El nombre de usuario ya existe!',
		'email_exists_err'					=>	'¡El correo electrónico ya existe!',
		'country_not_allowed_err'			=>	'¡País no permitido!',
		'undefined_err'						=>	'¡Algo salió mal!',
		'register_success'					=>	'¡Tu cuenta ha sido registrada con éxito!',
		'empty_fields_err'					=>	'¡Todos los campos no pueden estar vacíos!',
		'incorrect_username_or_password_err'=>	'¡Por favor, ingrese un nombre de usuario o contraseña correctos!',
		'account_banned_err'				=>	'Tu cuenta ha sido permanentemente suspendida. Motivo: violación de política.',
		'incorrect_2FA_err'					=>	'¡Por favor ingresa el código 2FA correcto para continuar!',
		'login_success'						=>	'¡Inicio de sesión exitoso!',
		'send_mail_too_often_err'			=>	'¡Espere 5 minutos antes de solicitar otro correo!',
		'email_not_exists_err'				=>	'¡Su correo electrónico no está registrado!',
		'send_verify_email_success'			=>	'Hemos enviado un correo electrónico con un enlace de confirmación a %s. Necesita hacer clic en este enlace para continuar. Este enlace caducará en 2 horas.', //$email
		'unavailable_feature_err'			=>	'Esta función está actualmente no disponible',
		'verified_email_err'				=>	'¡Su correo electrónico ya ha sido verificado!',
		'login_required_err'				=>	'¡Debe iniciar sesión para continuar!',
		'logout_success'					=>	'¡Cerrando sesión!',
		'captcha_incorrect_many_times_err'	=>	'Fallaste el captcha demasiadas veces. ¡Intente de nuevo en 10 minutos!',
		'wait_hourly_faucet'				=>	'Por favor espera %d minutos, %d segundos para la próxima reclamación del faucet.', //$email, $seconds
		'claim_success'						=>	'¡Recibiste %.8f BNB!', //(reward / 100000000)
		'out_of_spins_err'					=>	'Sin giros restantes. Para obtener más giros, ¡juega más nuestros juegos!',
		'dismiss_noti_success'				=>	'¡Notificación descartada exitosamente!',
		'empty_commission_balance_err'		=>	'¡El saldo de tus comisiones disponibles está vacío!',
		'invalid_gift_code_err'				=>	'¡Ingrese un código de regalo válido!',
		'incorrect_gift_code_err'			=>	'¡Este código de regalo es inválido o ha sido eliminado!',
		'used_gift_code_err'				=>	'¡Este código de regalo ya ha sido usado!',
		'apply_gift_success'				=>	'¡Código de regalo aplicado con éxito!',
		'password_changed_success'			=>	'¡Contraseña cambiada con éxito!',
		'incorrect_ver_code_err'			=>	'¡El código de verificación no existe o ha expirado!',
		'incorrect_2FA_err2'				=>	'¡Debes proporcionar un token válido para habilitar 2FA en tu cuenta!',
		'2FA_enabled_success'				=>	'¡2FA habilitado!',
		'2FA_disabled_success'				=>	'¡2FA deshabilitado!',
		'incorrect_password_err'			=>	'¡Contraseña incorrecta!',
		'update_privacy_success'			=>	'¡Privacidad actualizada con éxito!',
		'update_commission_share_success'	=>	'¡Participación en comisiones actualizada con éxito!',
		'verification_required_err'			=>	'¡Por favor, verifique su correo electrónico antes de retirar fondos!',
		'invalid_address_err'				=>	'¡Ingrese una dirección de retiro válida!',
		'balance_not_enough_err'			=>	'Tienes menos de %.8f BNB. ¡Espera hasta alcanzar el monto mínimo!', //($minimum_withdrawal / 100000000)
		'withdrawal_amount_too_less_err'	=>	'¡El monto mínimo de retiro es %.8f BNB!', //($minimum_withdrawal / 100000000)
		'amount_too_much_err'				=>	'¡El monto de retiro es mayor que el saldo de su cuenta!',
		'withdraw_too_often_err'			=>	'Estás intentando demasiado seguido. ¡Intente de nuevo más tarde!',
		'withdrawal_being_processed'		=>	'¡Su solicitud de retiro está siendo procesada!',
		'withdrawal_confirmation_required'	=>	'¡Por favor confirme la solicitud de retiro haciendo clic en el enlace que le enviamos a su correo!',
		'transaction_not_exist_err'			=>	'¡Esta solicitud no existe!',
		'transaction_not_exist_err2'		=>	'¡La solicitud ha sido cancelada o no existe!',
		'transaction_canceled_success'		=>	'¡Tu solicitud ha sido cancelada!',
		'feature_being_upgrade'				=>	'¡Esta función está siendo mejorada!',
		'empty_email_err'					=>	'¡Por favor, ingrese su correo electrónico!',
		'invalid_email_err'					=>	'¡Su correo electrónico no es una dirección válida!',
		'empty_subject_err'					=>	'¡Por favor, ingrese el asunto!',
		'empty_message_err'					=>	'¡Por favor, ingrese el mensaje!',
		'send_message_too_often_err'		=>	'¡Envíe cada mensaje después de 1 minuto!',
		'ticket_closed'						=>	'¡Este ticket está cerrado!',
		'send_message_success'				=>	'¡Su mensaje ha sido enviado exitosamente!',
		'empty_client_seed_err'				=>	'¡Ingrese su semilla de cliente!',
		'change_client_seed_success'		=>	'¡Cambio de semilla de cliente exitoso!',
		'bet_amount_too_less_err'			=>	'¡La cantidad de apuesta debe ser al menos %.8f BNB!', //($MIN_BET_AMOUNT / 100000000)
		'insufficient_balance_err'			=>	'¡Saldo insuficiente!',
		'bet_amount_too_much_err'			=>	'¡La cantidad de apuesta debe ser menor o igual a %.8f BNB!', //($MAX_BET_AMOUNT / 100000000)
		'min_payout_err'					=>	'¡El pago mínimo debe ser mayor o igual a %f!', //$MIN_PAYOUT
		'max_payout_err'					=>	'¡El pago máximo debe ser menor o igual a %f!', //$MAX_PAYOUT
		'min_multiplier_err' => 'El multiplicador mínimo debe ser mayor o igual a %f!', //MIN MULTIPLIER
		'max_multiplier_err' => 'El multiplicador máximo debe ser menor o igual a %f!', //MAX MULTIPLIER
		'select_lower_higher'				=>	'¡Por favor, selecciona menor o mayor!',
		'select_inside_outside'				=>	'¡Por favor, selecciona dentro o fuera!',
		'connection_timeout'				=>	'¡Tiempo de conexión agotado!',
		'create_game_err'					=>	'¡No se puede crear un nuevo juego!',
		'select_difficulty_err'				=>	'¡Por favor, selecciona la dificultad!',
		'create_game_success'				=>	'¡Nuevo juego creado con éxito!',
		'unstarted_game_err'				=>	'¡Por favor haz clic en iniciar primero!',
		'choose_tile_err'					=>	'¡Por favor, elige la baldosa correcta!',
		'open_a_bomb'						=>	'¡Abriste una bomba!',
		'open_a_gem'						=>	'¡Abriste una gema!',
		'open_all_gems'						=>	'¡Abriste todas las gemas!',
		'no_tiles_selected_err'				=>	'¡Por favor, selecciona al menos una baldosa!',
		'cashout_success'					=>	'¡Apuesta retirada con éxito!',
		'select_num_mines_err'				=>	'¡Por favor selecciona el número de minas!',
		'select_num_lines_err'				=>	'¡Por favor selecciona el número de líneas!',
		'tile_chosen_err'					=>	'¡Esta baldosa ya ha sido elegida!',
		'game_created_err'					=>	'Ya tienes un juego activo. ¡Termina ese antes de comenzar uno nuevo!',
		'tile_limited_err'					=>	'¡Número de baldosas más allá del límite!',
		'unexpected_err'					=>	'¡Error inesperado!',
		'select_player_banker_err'			=>	'¡Por favor, selecciona jugador, banquero o empate!',
		'invalid_start_card_err'			=>	'¡Carta de inicio no válida!',
		'you_lose'							=>	'¡Perdiste!',
		'open_new_card'						=>	'¡Abres una nueva carta!',
		'can_not_cashout_err'				=>	'¡No puedes retirar fondos!',
		'invalid_txid_err'					=>	'¡Por favor ingrese un ID de transacción válido!',
		'invalid_network_err'				=>	'¡Red no válida!',
		'credited_txid_err'					=>	'¡La transacción ya ha sido acreditada!',
		'update_transaction_success'		=>	'¡Actualización de la transacción exitosa!',
		'load_data_success'					=>	'¡Datos cargados exitosamente!',
		'invalid_game_id_err'				=>	'¡El ID del juego no existe!',
		'load_game_seed_failed'				=>	'¡No se pueden cargar las semillas del juego!',
		'deposit_credited_success'			=>	'¡Has depositado con éxito %.8f BNB!', //($total_amount / 100000000)
		'game_dice'							=> 	'Dados',
		'game_slots'						=> 	'Tragamonedas',
		'game_gems'							=> 	'Gemas',
		'game_mines'						=> 	'Minas',
		'game_video_poker'					=> 	'Video Póker',
		'game_baccarat'						=> 	'Baccarat',
		'game_high_low'						=> 	'Alto-Bajo',
		'game_roulette'						=> 	'Ruleta',
		'game_wof'							=> 	'Ruleta de la Fortuna',
		'game_plinko'						=> 	'Plinko',
		'game_limbo'						=> 	'Limbo',
		'game_ultimate'						=> 	'Dados Definitivos',
	);
	
	public function __construct() {}
	
	public function print($key, ...$params) {
		if (isset($this->langs[$key])) {
			if (!empty($params)) {
				return vsprintf($this->langs[$key], $params);
			}
			return $this->langs[$key];
		}
		return '';
	}
}
?>
