<?php

	function show_image_captcha($difficulty = 1) {
		//session_start();
		//PHP CAPTCHA image
		//Generated by https://www.html-code-generator.com/php/captcha-image-code-generator


		$width = 277;
		$height = 70;
		$font_size = 35;
		$font = dirname(__FILE__)."/sketch_block.ttf";
		$font = realpath($font);
		
		$chars_length = rand(6, 8);
		$vert_line = round($width/5);
		
		if($difficulty == 1) {
			$chars_length = rand(4, 5);
			$vert_line = round($width/6);
		} else if($difficulty == 2){
			$chars_length = rand(6, 7);
			$vert_line = round($width/5);
		} else if($difficulty == 3){
			$chars_length = rand(8, 9);
			$vert_line = round($width/4);
			$font_size = 40;
		}
		
		
		$captcha_characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';

		$image = imagecreatetruecolor($width, $height);
		$bg_color_palette = array(
			//array(44, 165, 141),
			//array(10, 35, 66),
			//array(30, 56, 136),
			//array(71, 168, 189),
			//array(156, 230, 99),
			array(156, 56, 72),
			//array(27, 44, 193),
			//array(9, 21, 64),
		);
		$bg_color = imagecolorallocate($image, $bg_color_palette[rand(0, count($bg_color_palette) - 1)][0], $bg_color_palette[rand(0, count($bg_color_palette) - 1)][1], $bg_color_palette[rand(0, count($bg_color_palette) - 1)][2]);
		$font_color = imagecolorallocate($image, 255, 255, 255);
		imagefilledrectangle($image, 0, 0, $width, $height, $bg_color);

		//background random-line
		
		$color = imagecolorallocate($image, 255, 255, 255);
		for($i=0; $i < $vert_line; $i++) {
			imageline($image, rand(0,$width), rand(0,$height), rand(0,$height), rand(0,$width), $color);
		}

		$xw = ($width/$chars_length);
		$x = 0;
		$font_gap = $xw/2-$font_size/2;
		$digit = '';
		for($i = 0; $i < $chars_length; $i++) {
			$letter = $captcha_characters[rand(0, strlen($captcha_characters)-1)];
			$digit .= $letter;
			if ($i == 0) {
				$x = 0;
			}else {
				$x = $xw*$i;
			}
			imagettftext($image, $font_size, rand(-20,20), $x+$font_gap, rand(27, $height-5), $font_color, $font, $letter);
		}

		// record token in session variable
		$_SESSION['captcha_token'] = strtolower($digit);

		// display image
		header('Content-Type: image/png');
		imagepng($image);
		imagedestroy($image);
	}
	
	function validate_image_captcha($code) {
		$code = strtolower($code);
		if(strcmp($code, $_SESSION['captcha_token']) == 0) {
			return 1;
		}
		return 0;
	}
?>
