<?php
include('bscphp7/api.php');	
include('GoogleAuthenticator.php');	

require_once(APPPATH .'controllers/iconcaptcha/vendor/autoload.php');
use IconCaptcha\IconCaptcha;

include('phpmailer/Sendmail.php');
include('languages.php');
defined('BASEPATH') OR exit('No direct script access allowed');
date_default_timezone_set("UTC");
define ("JACKPOTSCOSTS", serialize (array(12500, 1250, 125, 13, 2)));
define ("JACKPOTSPRIZES", serialize (array(100000000, 10000000, 1000000, 100000, 10000)));
require_once(APPPATH .'geolite2/index.php');

set_time_limit(10);
ini_set('default_socket_timeout', 5);

class Frontend extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */
	
	public $user_info = null;	
	public $show_login_captcha = true;
	public $gg_site_key = '6Le5mIwlAAAAADmaHuGxaf5KTEiWwG9FhQex0JDc';
	public $gg_secret_key = '6Le5mIwlAAAAACIFowT1OblsMk6nV38RpZTaEalK';
	public $hcaptcha_site_key = '1cf1ac2d-e962-4efc-a097-265d3b11ed32';
	public $hcaptcha_secret_key = '0xfc088F0B3baae62ebd70AC44Ee80b94ac96Ce7D0';
	
	public $hcaptcha_hard_site_key = 'a507b816-4591-4606-870e-f6a55fc76e29';
	public $hcaptcha_hard_secret_key = '0xfc088F0B3baae62ebd70AC44Ee80b94ac96Ce7D0';
	
	public $cloudflare_site_key = '0x4AAAAAAA0_O3uScCqtpqXl';
	public $cloudflare_secret_key = '0x4AAAAAAA0_O4ia8dNnZ1sMnLbfzWF5b0w';
	
	public $captcha_type = 3;
	public $faucetpay_api_key = '319dc79cae1e2532fa74d4ff7838304b59a26da2';
	
	public $allow_sending_email = 1;
	public $sending_email_ip = '45.77.43.245';
	public $skip_withdrawal_confirmation = 0;
	
	
	public $settings_file = 'application/controllers/settings.txt';
	public $lang = null;
	public $main_wallet = array(
		'address'	=> '0x339c51b58ca14000dbbb9e3c3e015fbfdcb57cf0',
		'private_key'	=> '5327a04d4a5425d0fe4e767b54d79c014acae5918f97b1ca0a971596e59ddf8f'
	);
	
	public $levels = array(
		array('Stone', 0, 0.00000075),
		array('Iron', 0.006, 0.00000150),
		array('Bronze', 0.06, 0.00000300),
		array('Silver', 0.6, 0.00000900),
		array('Gold', 6, 0.00003750),
		array('Platinum', 60, 0.00018000),
		array('Diamond', 600, 0.00090000),
		array('Master', 6000, 0.00600000),
	);
	
	public $lucky_numbers = array(
		array(0, 75),
		array(9886, 2250),
		array(9986, 22500),
		array(9994, 225000),
		array(9998, 2250000),
		array(10000,22500000),
	);
	public $minimum_withdrawal = 200000;
	public $withdrawal_fee = 10000;
	public $BNB_price = 1000;
	public $UNITS_PER_COIN = 1e8;
	public $COIN_DECIMALS = 8;
	
	public $MIN_BET_AMOUNT = 10;
	public $MAX_BET_AMOUNT = 10 * 1e8;
	
	public $captcha_result = null;
	
	public function __construct() {
		parent::__construct();
		$this->load->helper('url');
		$this->load->model('UserModel', 'User');
		$this->load->model('BanModel', 'Ban');
		$this->load->model('BonusModel', 'Bonus');
		$this->load->model('ConfirmationModel', 'Confirmation');
		$this->load->model('FaucetModel', 'Faucet');
		$this->load->model('GiftModel', 'Gift');
		$this->load->model('WalletModel', 'Wallet');
		$this->load->model('RequestModel', 'Request');
		$this->load->model('MessageModel', 'Message');
		$this->load->model('TicketModel', 'Ticket');
		$this->load->model('GameModel', 'Game');
		$this->load->model('NotificationModel', 'Notification');
		$this->load->model('StatisticModel', 'Statistic');
		$this->load->model('LogModel', 'Log');
		$this->load->model('ContestModel', 'Contest');
		$this->load->model('SurveyModel', 'Survey');
		$this->load->model('StaminaModel', 'Stamina'); //stamina feature
		$this->load->model('StrategyModel', 'Strategy');
		$this->load->model('GroupModel', 'Group'); //group 
		$this->load->library('session');
		$this->load->driver('cache', ['adapter' => 'memcached', 'backup' => 'file']);
		$this->load->library('CI_Minifier');
		$this->ci_minifier->init(0);
		$this->ci_minifier->enable_obfuscator();
		
		$this->load->helper('pcaptcha');
		
		//load language file
		if(isset($_COOKIE['language']) && !empty($_COOKIE['language'])) {
			$language = $_COOKIE['language'];
		} else {
			$language = 'EN';
		}
		$this->lang = new Languages(strtoupper($language));
		//load language file
		
		
		///////rate limit///////
		//if(isset($_SESSION['temporarily_banned']) && $_SESSION['temporarily_banned'] > time()) {
		if($this->session->userdata('temporarily_banned') !== NULL && $this->session->userdata('temporarily_banned') > time()) {
			echo json_encode(array('ret' => 0, 'mes' =>  $this->lang->print('connection_timeout_err')));
			exit();
		}
		///////rate limit///////
		
		/** remember me **/
		if($this->session->userdata('user_info') == NULL) {
			if(isset($_COOKIE['remember_token'])) {
				$remember_token = $_COOKIE['remember_token'];
				$user_id = $this->User->get_user_id_by_token($remember_token);
				if($user_id != 0) {
					$this->user_info = $this->User->get_user_info_by_id($user_id);
					$this->session->set_userdata('user_info', $this->user_info);
				}
			}
		}
		/** remember me **/
		
		//if(isset($_SESSION['user_info'])) {
		if($this->session->userdata('user_info') !== NULL) {
			//if($_SESSION['user_info']->accessed_time < time() - 300) {
			if($this->session->userdata('user_info')->accessed_time < time() - 300) {
				//$this->User->update_user_info_by_id($_SESSION['user_info']->user_id, 'accessed_time', time());
				//$_SESSION['user_info']->accessed_time = time();	
				
				$this->User->update_user_info_by_id($this->session->userdata('user_info')->user_id, 'accessed_time', time());
				$user_info = $this->session->userdata('user_info');
				$user_info->accessed_time = time();
				$this->session->set_userdata('user_info', $user_info);
			}
			
			//$this->user_info = $this->User->get_user_info_by_id($_SESSION['user_info']->user_id);
			$this->user_info = $this->User->get_user_info_by_id($this->session->userdata('user_info')->user_id);
			
			//sync_data
			if($this->user_info->accessed_time < time() - 300) {
				$this->User->auto_sync_user_data($this->user_info);
			}
			//sync_data
			
			if($this->user_info->banned == 1) {
				//unset($_SESSION['user_info']);
				$this->session->unset_userdata('user_info');
				header("Location: ".base_url()."login.php");
			} else {
				//$_SESSION['user_info'] = $this->user_info;
				$this->session->set_userdata('user_info', $this->user_info);
				
				if(rand(0, 5000) == 1) {
					$this->Game->clean_bet_data();
				}
				if(rand(0, 10000) == 2) {
					$this->Log->clean_log_data();
				}
			}
			
			if(isset($_COOKIE['fp']) && $_COOKIE['fp'] != $this->user_info->user_token) {
				if($this->user_info->user_role == 0) {
					//unset($_SESSION['user_info']);
					$this->session->unset_userdata('user_info');
					header("Location: ".base_url()."login.php");
				}
			}
			
			if($this->user_info->total_deposits >= 1500000 && $this->user_info->auto_payout == 0 && $this->user_info->banned == 0 && $this->user_info->disable_payout == 0) {
				$this->User->update_user_info_by_id($this->user_info->user_id, 'auto_payout', 1);
			}
			
			if($this->user_info->user_role == 1) {
				ini_set('display_errors', 1);
				ini_set('display_startup_errors', 1);
				error_reporting(E_ALL);
			}
			
			if($this->user_info->language == '') {
				if(isset($_COOKIE['language']) && !empty($_COOKIE['language'])) {
					$language = strtoupper($_COOKIE['language']);
					if($language != 'EN' 
						&& $language != 'ES' 
						&& $language != 'PT' 
						&& $language != 'FR' 
						&& $language != 'RU' 
						&& $language != 'DE' 
						&& $language != 'NL' 
						&& $language != 'ZH' 
						&& $language != 'AR' 
						&& $language != 'HI' 
						&& $language != 'JA' 
						&& $language != 'BN' 
						&& $language != 'MN' 
						&& $language != 'TR' 
						&& $language != 'FA' 
						&& $language != 'UZ'
						&& $language != 'VI'
						&& $language != 'UR'
						&& $language != 'ID'
						&& $language != 'TH'
						&& $language != 'HR'
						&& $language != 'KO'
						&& $language != 'IT'
					) {
						$language = 'EN';
					}
				} else {
					$language = 'EN';
				}
				$this->lang = new Languages($language);
				$this->User->update_user_info_by_id($this->user_info->user_id, 'language', $language);
				$this->user_info->language = $language;
			} else {
				$language = strtoupper($this->user_info->language);
			}
			
		}
		$this->BNB_price = $this->get_BNB_price();
	}
	 
	public function index() {
		if($this->user_info != null) {
			header("Location: ".base_url()."faucet.php");
		} else {
			
			$country = GeoIp2CountryIsoCode($this->input->ip_address());
			if($country == 'VN') {
				$this->load->view('country_blocked', array());
				return;
			}
			
			$referrer = $this->input->post_get('ref');
			if($referrer != '') {
				$this->session->set_userdata('referrer', $referrer);
			}
			if($referrer != '' && !preg_match("/^[A-Za-z0-9_\.]{6,16}$/", $referrer)) {
				$referrer = '';
			}
			if(isset($_SERVER['HTTP_REFERER'])) {
				$this->session->set_userdata('referring_url', $_SERVER['HTTP_REFERER']);
			}
			$web_statistics = $this->User->get_web_statistics();
			$data = array(
				'referrer' => $referrer,
				'registered_users'	=> $web_statistics->users,
				'total_games'	=> $web_statistics->games,
				'won_by_users'	=> $web_statistics->games * 0.00000025513,
			);
			$this->load->view('index', $data);
		}
		
	}
	
	public function create_virtual_request() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			if($this->user_info->user_level == 0) {
				header("Location: ".base_url()."faucet.php");
			} else {
				$this->get_unconfirmed_transactions('BNB', true);
			}
		}
	}
	
	public function login() {
		if($this->user_info != null) {
			header("Location: ".base_url()."faucet.php");
		} else {
			
			$country = GeoIp2CountryIsoCode($this->input->ip_address());
			if($country == 'VN') {
				$this->load->view('country_blocked', array());
				return;
			}
			
			$email = $this->input->post_get('email');
			$email = filter_var($email, FILTER_SANITIZE_EMAIL);
			$referrer = $this->input->post_get('ref');
			if($referrer != '' && !preg_match("/^[A-Za-z0-9_\.]{6,16}$/", $referrer)) {
				$referrer = '';
			}
			$data = array(
				'referrer' => $referrer,
				'email' => $email,
				'captcha_type'	=> $this->captcha_type,
				'show_login_captcha'	=> $this->show_login_captcha,
				'gg_site_key'	=> $this->gg_site_key,
				'hcaptcha_site_key'	=> $this->hcaptcha_site_key,
				'cloudflare_site_key'	=> $this->cloudflare_site_key,
				'BNB_price'	=> $this->BNB_price,
				'menu'	=> 'login',
			);
			$this->load->view('login', $data);
		}
	}
	
	public function login2() {
		if($this->user_info != null) {
			header("Location: ".base_url()."faucet.php");
		} else {
			$email = $this->input->post_get('email');
			$email = filter_var($email, FILTER_SANITIZE_EMAIL);
			$referrer = $this->input->post_get('ref');
			if($referrer != '' && !preg_match("/^[A-Za-z0-9_\.]{6,16}$/", $referrer)) {
				$referrer = '';
			}
			$data = array(
				'referrer' => $referrer,
				'email' => $email,
				'captcha_type'	=> $this->captcha_type,
				'show_login_captcha'	=> $this->show_login_captcha,
				'gg_site_key'	=> $this->gg_site_key,
				'hcaptcha_site_key'	=> $this->hcaptcha_site_key,
				'cloudflare_site_key'	=> $this->cloudflare_site_key,
				'BNB_price'	=> $this->BNB_price,
				'menu'	=> 'login',
			);
			$this->load->view('login2', $data);
		}
	}

	public function recover() {
		if($this->user_info != null) {
			header("Location: ".base_url()."faucet.php");
		} else {
			$email = $this->input->post_get('email');
			$email = filter_var($email, FILTER_SANITIZE_EMAIL);
			$data = array(
				'captcha_type'	=> $this->captcha_type,
				'email' => $email,
				'gg_site_key'	=> $this->gg_site_key,
				'hcaptcha_site_key'	=> $this->hcaptcha_site_key,
				'cloudflare_site_key'	=> $this->cloudflare_site_key,
				'BNB_price'	=> $this->BNB_price,
				'menu'	=> 'recover',
			);
			$this->load->view('recover', $data);
		}
	}

	public function disable_2fa() {
		if($this->user_info != null) {
			header("Location: ".base_url()."faucet.php");
		} else {
			$email = $this->input->post_get('email');
			$email = filter_var($email, FILTER_SANITIZE_EMAIL);
			$data = array(
				'captcha_type'	=> $this->captcha_type,
				'email' => $email,
				'gg_site_key'	=> $this->gg_site_key,
				'hcaptcha_site_key'	=> $this->hcaptcha_site_key,
				'cloudflare_site_key'	=> $this->cloudflare_site_key,
				'BNB_price'	=> $this->BNB_price,
				'menu'	=> 'disable_2fa',
			);
			$this->load->view('disable_2fa', $data);
		}
	}	
	
	public function signup() {
		if($this->user_info != null) {
			header("Location: ".base_url()."faucet.php");
		} else {
			
			$country = GeoIp2CountryIsoCode($this->input->ip_address());
			if($country == 'VN') {
				$this->load->view('country_blocked', array());
				return;
			}
			
			$referrer = $this->input->post_get('ref');
			if($referrer == '' && $this->session->userdata('referrer') !== NULL) {
				$referrer = $this->session->userdata('referrer');
			}
			if(!preg_match("/^[A-Za-z0-9_\.]{6,16}$/", $referrer)) {
				$referrer = '';
			}
			$email = $this->input->post_get('email');
			$email = filter_var($email, FILTER_SANITIZE_EMAIL);
			$data = array(
				'referrer' => $referrer,
				'email' => $email,
				'captcha_type'	=> $this->captcha_type,
				'gg_site_key'	=> $this->gg_site_key,
				'hcaptcha_site_key'	=> $this->hcaptcha_site_key,
				'cloudflare_site_key'	=> $this->cloudflare_site_key,
				'BNB_price'	=> $this->BNB_price,
				'menu'	=> 'signup',
			);
			$this->load->view('signup', $data);
		}
	}
	
	public function logout() {
		if($this->user_info != null) {
			$this->session->unset_userdata('user_info');
		}
		header("Location: ".base_url());
	}
	
	public function iconcaptcha() {
		
		$referer = $_SERVER['HTTP_REFERER'] ?? '';
		$host = parse_url($referer, PHP_URL_HOST);
		if ($host !== 'bnbpick.io') {
			return;
		}
		
		try {
			// Start a session.
			// * Only required when using any 'session' driver in the configuration. See the documentation for more information.
			//session_start();
			// Load the IconCaptcha options.
			$options = require_once(APPPATH .'controllers/iconcaptcha/examples/captcha-config.php');
			// Create an instance of IconCaptcha.
			$captcha = new IconCaptcha($options);
			// Handle the CORS preflight request.
			// * If you have disabled CORS in the configuration, you may remove this line.
			$captcha->handleCors();
			// Process the request.
			$captcha->request()->process();
			// Request was not supported/recognized.
			//http_response_code(400);
		} catch (Throwable $exception) {
			http_response_code(500);
			// Add your custom error logging handling here.
		}
	}
	
	public function generate_pcaptcha() {
		$result = generate_pcaptcha_image();
        if (isset($result['error'])) {
            show_error($result['error'], 500);
        }
        echo json_encode($result);
	}
	
	public function check_ban_user() {
		if($this->user_info != null) {
			$check_ban_user = $this->Ban->check_ban_user(0, $this->get_client_ip());
			if($this->user_info->banned == 1 || ($check_ban_user != null && $check_ban_user->expired_time == 0)) {
				//unset($_SESSION['user_info']);
				$this->session->unset_userdata('user_info');
				header("Location: ".base_url()."login.php");
			} 
		}
	}
	
	public function update_accessed_time() {
		if($this->user_info != null) {
			//$this->User->update_user_info_by_id($this->user_info->user_id, 'accessed_time', time());
			//$this->user_info->accessed_time = time();
			//$_SESSION['user_info']->accessed_time = time();
		}
	}

	public function faucet() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$ip_address = $this->get_client_ip();

			/*if($this->user_info->total_deposits > 0 || $this->user_info->total_withdrawals > 0 || $this->user_info->total_survey_rewards >= 50000) {
				$last_claim_faucet = $this->user_info->last_claim_faucet_time;
			} else {
				$last_claim_faucet = $this->Log->get_last_claim_faucet_time($this->user_info->user_id, $ip_address);
				$last_claim_faucet = max($last_claim_faucet, $this->user_info->last_claim_faucet_time);
			}*/
			$last_claim_faucet = $this->user_info->last_claim_faucet_time;
			
			$next_claim_faucet = max(3600 - (time() - $last_claim_faucet), 0);
			
			$user_faucet = $this->Faucet->get_user_faucet($this->user_info->user_id);
			$levels = $this->levels;
			if($this->user_info->user_level <= sizeof($levels) - 1 && $this->user_info->wagered > $levels[$this->user_info->user_level][1] * $this->UNITS_PER_COIN) {
				$updated_info = clone($this->user_info);
				$updated_info->user_level += 1;
				if($updated_info->user_level == 2) {
					$updated_info->free_spins += 5;
					$this->Faucet->create_new_faucet($this->user_info->user_id, 2, 86400 * 1, 'Double rewards for 1 days');
					$this->Notification->create_notification($this->user_info->user_id, 'Congratulation! Your level has increased. You received 5 free spins.');
				} else if ($updated_info->user_level == 3) {
					$updated_info->free_spins += 10;
					$this->Faucet->create_new_faucet($this->user_info->user_id, 2, 86400 * 2, 'Double rewards for 2 days');
					$this->Notification->create_notification($this->user_info->user_id, 'Congratulation! Your level has increased. You received 10 free spins.');
				} else if ($updated_info->user_level == 4) {
					$updated_info->free_spins += 20;
					$this->Faucet->create_new_faucet($this->user_info->user_id, 2, 86400 * 2, 'Double rewards for 2 days');
					$this->Notification->create_notification($this->user_info->user_id, 'Congratulation! Your level has increased. You received 20 free spins.');
				} else if ($updated_info->user_level == 5) {
					$updated_info->free_spins += 40;
					$this->Faucet->create_new_faucet($this->user_info->user_id, 2, 86400 * 2, 'Double rewards for 2 days');
					$this->Notification->create_notification($this->user_info->user_id, 'Congratulation! Your level has increased. You received 40 free spins.');
				} else if ($updated_info->user_level == 6) {
					$updated_info->free_spins += 50;
					$this->Faucet->create_new_faucet($this->user_info->user_id, 2, 86400 * 2, 'Double rewards for 2 days');
					$this->Notification->create_notification($this->user_info->user_id, 'Congratulation! Your level has increased. You received 50 free spins.');
				} else if ($updated_info->user_level == 7) {
					$updated_info->free_spins += 100;
					$this->Faucet->create_new_faucet($this->user_info->user_id, 2, 86400 * 2, 'Double rewards for 2 days');
					$this->Notification->create_notification($this->user_info->user_id, 'Congratulation! Your level has increased. You received 100 free spins.');
				} else if ($updated_info->user_level == 8) {
					$updated_info->free_spins += 200;
					$this->Faucet->create_new_faucet($this->user_info->user_id, 2, 86400 * 2, 'Double rewards for 2 days');
					$this->Notification->create_notification($this->user_info->user_id, 'Congratulation! Your level has increased. You received 200 free spins.');
				}
				
				//stamina feature
				$stamina_info = $this->Stamina->get_stamina_info_by_uid($this->user_info->user_id);
				if($stamina_info != null && $stamina_info->status == 1) {
					$this->Stamina->update_target_bet($updated_info->user_id, $updated_info->user_level);
				}
				//stamina feature
				
				$this->User->update_user_info($this->user_info, $updated_info);
				$this->user_info = $updated_info;
			}
			
			/** 13-02-2024 **/
			if ($this->user_info->uncredited_survey_rewards > 0) {
				$uncredited_survey_rewards = $this->user_info->uncredited_survey_rewards;

				// Start transaction to ensure atomic updates
				$this->db->trans_begin();

				// Update current user's info
				$updated_info = clone($this->user_info);
				$updated_info->total_survey_rewards += $uncredited_survey_rewards;
				$updated_info->balance = $this->User->get_user_balance_by_id($this->user_info->user_id);
				$updated_info->balance += $uncredited_survey_rewards;
				$updated_info->wagered += ($uncredited_survey_rewards * 5); // Increase wagered amount based on survey rewards
				$updated_info->uncredited_survey_rewards = 0;

				// Handle referral commission if user has a referrer
				if ($this->user_info->referrer != 0) {
					$get_referrer = $this->User->get_user_info_by_id($this->user_info->referrer);
					$referral_commission = intval($uncredited_survey_rewards * 5 / 100); // 5% referral commission

					// Check for referrer's commission share
					if ($get_referrer && $get_referrer->commission_share > 0 && $get_referrer->commission_share <= 100) {
						$commission_share = intval($referral_commission * $get_referrer->commission_share / 100);
						$referral_commission -= $commission_share;

						// Add shared commission to current user's commission balance
						$updated_info->available_commission_balance += $commission_share;
					}

					// Update referrer's commission balance
					$ref_updated = $this->User->update_user_info_by_id(
						$this->user_info->referrer,
						'available_commission_balance',
						'available_commission_balance+' . $referral_commission,
						FALSE
					);

					// Rollback if referrer update fails
					if (!$ref_updated) {
						$this->db->trans_rollback();
						return;
					}

					$updated_info->total_referral_commissions += $referral_commission;
				}

				// Update current user with new balances
				$main_updated = $this->User->update_user_info($this->user_info, $updated_info);
				if (!$main_updated) {
					$this->db->trans_rollback();
					return;
				}

				// Commit transaction after all updates are successful
				$this->user_info = $updated_info;
				$this->db->trans_commit();

				// Update user's stamina (can be outside transaction if it's not critical)
				$this->update_user_stamina($uncredited_survey_rewards * 5);
			}
			/** 13-02-2024 **/
			
			
			$user_wallet = $this->Wallet->get_wallet_by_user_id($this->user_info->user_id);
			if($user_wallet == '') {
				$deposit_address = '';
				$last_deposit = 0;
				$wallet_balance = 0;
			} else {
				$deposit_address = $user_wallet->address;
				$last_deposit = $user_wallet->updated_time;
				$wallet_balance = $user_wallet->balance;
			}

			$country = GeoIp2CountryIsoCode($this->get_client_ip());
			if($country != $this->user_info->country) {
				$this->User->update_user_info_by_id($this->user_info->user_id, 'country', $country);
			}

			
			//group feature
			$bypass_group_id = 1;
			$check_bypass_captcha = $this->Group->is_user_in_group($this->user_info->user_id, $bypass_group_id);
			//group feature
			
			$this->session->set_userdata('faucet_token', $this->create_random_key(64));
			
			$captcha_token = bin2hex(random_bytes(32));
			$this->session->set_userdata('captcha_token_info', [
				'token' => $captcha_token,
				'ip' => $this->input->ip_address(),
				'ua' => $this->input->user_agent(),
				'expires' => time() + 60
			]);
			
			
			$data = array(
				'user_info' 		=> $this->user_info,
				'show_alert'		=> false,
				'user_faucet'		=> $user_faucet,
				'next_claim_faucet'	=> $next_claim_faucet,
				//'notifications'	=> $this->Notification->get_all_notifications_by_user_id($this->user_info->user_id),
				'levels'			=> $levels,
				'captcha_type'	=> $this->captcha_type,
				'gg_site_key'	=> $this->gg_site_key,
				'hcaptcha_site_key'	=> $this->hcaptcha_site_key,
				'cloudflare_site_key'	=> $this->cloudflare_site_key,
				'lucky_numbers'	=> $this->lucky_numbers,
				'BNB_price'	=> $this->BNB_price,
				'deposit_address'	=> $deposit_address,
				'last_deposit'		=> $last_deposit,
				'wallet_balance'	=> $wallet_balance,
				'faucet_token'		=> $this->session->userdata('faucet_token'),
				'stamina_info'	=> $this->Stamina->get_stamina_info_by_uid($this->user_info->user_id), //stamina feature
				'check_bypass_captcha'	=> $check_bypass_captcha,
				'menu'		=> 'faucet',
			);
			$this->load->view('faucet', $data);
			
			//sync_data
			$this->User->auto_sync_user_data($this->user_info);
			//sync_data
		}
	}

	public function provably_fair() {
		if($this->user_info == null) {
			$this->Log->create_log(0, 'provably_fair', $this->get_client_ip());
		} else {
			$this->Log->create_log($this->user_info->user_id, 'provably_fair', $this->get_client_ip());
		}
		$data = array(
			'user_info' => $this->user_info,
			'BNB_price'	=> $this->BNB_price,
			'menu'		=> 'provably_fair'
		);
		$this->load->view('provably_fair', $data);
	}
	
	public function games() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			$levels = $this->levels;
			$data = array(
				'user_info' => $this->user_info,
				'levels'	=> $levels,
				'BNB_price'	=> $this->BNB_price,
				'menu'		=> 'games'
			);
			$this->load->view('games', $data);
		}
	}
	
	
	public function multiply() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			$levels = $this->levels;
			if(rand(1, 50) == 1 || $this->user_info->user_role == 1) {
				$bet_statistics_today = $this->Game->get_bet_statistics_today();
				$games_played_today = $this->Statistic->get_statistic_by_date('games', date("Y-m-d"));
				//if($bet_statistics_today != null && $bet_statistics_today->total_bets > $games_played_today) {
					$this->Statistic->set_statistic_by_date('games', intval($bet_statistics_today->total_bets), date("Y-m-d"));
					$this->Statistic->set_statistic_by_date('users_bet', intval($bet_statistics_today->total_users), date("Y-m-d"));
					$this->Statistic->set_statistic_by_date('profit', intval(-$bet_statistics_today->bet_balance), date("Y-m-d"));
					$this->Statistic->set_statistic_by_date('wagered', intval($bet_statistics_today->total_wagered), date("Y-m-d"));
				//}
			}
			
			$user_wallet = $this->Wallet->get_wallet_by_user_id($this->user_info->user_id);
			if($user_wallet == '') {
				$deposit_address = '';
				$last_deposit = 0;
			} else {
				$deposit_address = $user_wallet->address;
				$last_deposit = $user_wallet->updated_time;
			}

			$data = array(
				'user_info' => $this->user_info,
				'levels'			=> $levels,
				'BNB_price'	=> $this->BNB_price,
				'deposit_address'	=> $deposit_address,
				'last_deposit'		=> $last_deposit,
				'menu'		=> 'multiply'
			);
			$this->load->view('multiply', $data);
		}
	}
	
	public function game_history() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();

			$data = array(
				'user_info' => $this->user_info,
				'BNB_price'	=> $this->BNB_price,
				'menu'		=> 'multiply'
			);
			$this->load->view('game_history', $data);
		}
	}
	
	public function dice() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			$data = array(
				'user_info' => $this->user_info,
				'BNB_price'	=> $this->BNB_price,
				'strategies'	=> $this->Strategy->get_strategies_by_user_id($this->user_info->user_id),
				'menu'		=> 'dice'
			);
			$this->load->view('game_dice', $data);
		}
	}
	
	public function ultimate_dice() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			$data = array(
				'user_info' => $this->user_info,
				'BNB_price'	=> $this->BNB_price,
				'menu'		=> 'dice'
			);
			$this->load->view('game_ultimate_dice', $data);
		}
	}
	
	public function gems() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			$game_data = $this->Game->get_last_game_data_by_uid('Gems', $this->user_info->user_id);
			$tiles = array();
			$gems = array();
			$difficulty = '';
			$temp_profit = 0;
			$bet_amount = 0;
			if($game_data != null) {
				$bet_amount = $game_data->bet_amount;
				$gems = json_decode($game_data->data)->gems;
				$difficulty = json_decode($game_data->prediction)->difficulty;
				$tiles = json_decode($game_data->prediction)->tiles;
				$steps = 0;
				for($i = 0; $i < 10; $i++) {
					if($tiles[$i] != -1) {
						$steps++;
					} else {
						break;
					}
				}
				if($steps > 0) {
					$temp_profit = intval($this->Game->calculate_game_gems_payout($difficulty, $steps) * $game_data->bet_amount);
				}
			}
			$data = array(
				'bet_amount'	=> $bet_amount,
				'user_info' 	=> $this->user_info,
				'difficulty'	=> $difficulty,
				'gems'			=> $gems,
				'tiles'			=> $tiles,
				'temp_profit'	=> $temp_profit,
				'BNB_price'	=> $this->BNB_price,
				'menu'				=> 'gems'
			);
			$this->load->view('game_gems', $data);
		}
	}

	public function slots() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			$data = array(
				'user_info' => $this->user_info,
				'reels'		=> $this->Game->get_game_slots_reels(),
				'BNB_price'	=> $this->BNB_price,
				'menu'		=> 'slots'
			);
			$this->load->view('game_slots', $data);
		}
	}
	
	public function mines() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			$game_data = $this->Game->get_last_game_data_by_uid('Mines', $this->user_info->user_id);
			$tiles = array();
			$mines = array();
			$bet_amount = 0;
			if($game_data != null) {
				$bet_amount = $game_data->bet_amount;
				$tiles = json_decode($game_data->prediction)->tiles;
				$mines = json_decode($game_data->data)->mines;
			}
			$data = array(
				'bet_amount'	=> $bet_amount,
				'user_info' => $this->user_info,
				'tiles'		=> $tiles,
				'mines'		=> $mines,
				'BNB_price'	=> $this->BNB_price,
				'menu'		=> 'mines'
			);
			$this->load->view('game_mines', $data);
		}
	}
	
	public function keno() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			$data = array(
				'user_info' => $this->user_info,
				'BNB_price'	=> $this->BNB_price,
				'menu'		=> 'keno'
			);
			$this->load->view('game_keno', $data);
		}
	}
	
	public function triple_dice() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			$data = array(
				'user_info' => $this->user_info,
				'BNB_price'	=> $this->BNB_price,
				'menu'		=> 'triple_dice'
			);
			$this->load->view('game_triple_dice', $data);
		}
	}
	
	public function poker() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			$game_data = $this->Game->get_last_game_data_by_uid('Poker', $this->user_info->user_id);
			$cards = '';
			$bet_amount = 0;
			if($game_data != null) {
				$bet_amount = $game_data->bet_amount;
				$cards = json_decode($game_data->data)->cards;
				$cards = array_slice($cards, 0, 5);
			}
			$data = array(
				'bet_amount'	=> $bet_amount,
				'user_info' => $this->user_info,
				'menu'		=> 'poker',
				'BNB_price'	=> $this->BNB_price,
				'cards'		=> $cards,
			);
			$this->load->view('game_poker', $data);
		}
	}
	
	public function baccarat() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			$data = array(
				'user_info' => $this->user_info,
				'BNB_price'	=> $this->BNB_price,
				'menu'		=> 'baccarat',
			);
			$this->load->view('game_baccarat', $data);
		}
	}
	public function hilow() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			$game_data = $this->Game->get_last_game_data_by_uid('Hilow', $this->user_info->user_id);
			if($game_data != null) {
				$bet_amount = $game_data->bet_amount;
				$cards = json_decode($game_data->data)->cards;
				$selections = json_decode($game_data->prediction)->selections;
				$started_game = 1;
			} else {
				$cards = array(rand(0, 51));
				$selections = array();
				$started_game = 0;
				$bet_amount = 0;
			}
			$cards = array_slice($cards, 0, count($selections) + 1);
			$total_profit = $this->Game->calculate_game_hilow_profit($cards, $selections);
			$data = array(
				'bet_amount'	=> $bet_amount,
				'cards' 	=> json_encode($cards),
				'selections' 	=> json_encode($selections),
				'started_game'	=> $started_game,
				'total_profit'	=> $total_profit,
				'user_info' => $this->user_info,
				'BNB_price'	=> $this->BNB_price,
				'menu'		=> 'hilow',
			);
			$this->load->view('game_hilow', $data);
		}
	}
		
	public function roulette() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			$data = array(
				'user_info' => $this->user_info,
				'BNB_price'	=> $this->BNB_price,
				'menu'		=> 'roulette'
			);
			$this->load->view('game_roulette', $data);
		}
	}
	
	public function wheel() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			$data = array(
				'user_info' => $this->user_info,
				'BNB_price'	=> $this->BNB_price,
				'menu'		=> 'wheel'
			);
			$this->load->view('game_wheel', $data);
		}
	}
	
	public function plinko() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			$data = array(
				'user_info' => $this->user_info,
				'BNB_price'	=> $this->BNB_price,
				'menu'		=> 'plinko'
			);
			$this->load->view('game_plinko', $data);
		}
	}
	
	public function limbo() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			$data = array(
				'user_info' => $this->user_info,
				'BNB_price'	=> $this->BNB_price,
				'menu'		=> 'limbo'
			);
			$this->load->view('game_limbo', $data);
		}
	}

	public function withdraw() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			$page_id = intval($this->input->post_get('p'));
			if($page_id == 0) {
				$page_id = 1;
			}
			if($page_id > 99999) {
				$page_id = 99999;
			}
			$user_transactions = $this->Request->load_user_transactions($this->user_info->user_id, $page_id, 'Withdrawal');
			$total_requests = $this->Request->get_number_transactions($this->user_info->user_id, 'Withdrawal');
			$total_pages = ceil($total_requests / $this->Request->limit_entries);
			$unconfirmed_requests = $this->Request->count_unconfirmed_requests($this->user_info->user_id);
			$data = array(
				'minimum_withdrawal' => $this->minimum_withdrawal,
				'withdrawal_fee' => $this->withdrawal_fee,
				'unconfirmed_requests'	=> $unconfirmed_requests,
				'user_info' => $this->user_info,
				'user_transactions'	=> $user_transactions,
				'pagination'	=> $this->create_pagination($page_id, $total_pages , base_url().'withdraw.php'),
				'BNB_price'	=> $this->BNB_price,
				'captcha_type'	=> $this->captcha_type,
				'gg_site_key'	=> $this->gg_site_key,
				'hcaptcha_site_key'	=> $this->hcaptcha_site_key,
				'cloudflare_site_key'	=> $this->cloudflare_site_key,
				'menu'		=> 'withdraw',
			);
			$this->load->view('withdraw', $data);
		}
	}

	public function deposit() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			$user_wallet = $this->Wallet->get_wallet_by_user_id($this->user_info->user_id);
			if($user_wallet == '') {
				$get_wallet = bscapi_generate_address();
				if($get_wallet != ''){
					$deposit_address = $get_wallet['public_key'];
					$private_key = $get_wallet['private_key'];
					$wallet_id = $this->Wallet->create_new_wallet($this->user_info->user_id, 'Deposit', $deposit_address, $private_key);
				} else {
					$deposit_address = '';
				}
				$last_deposit = 0;
				$wallet_balance = 0;
			} else {
				$deposit_address = $user_wallet->address;
				$last_deposit = $user_wallet->updated_time;
				$wallet_balance = $user_wallet->balance;
			}

			$page_id = intval($this->input->post_get('p'));
			if($page_id == 0) {
				$page_id = 1;
			}
			if($page_id > 99999) {
				$page_id = 99999;
			}
			$user_transactions = $this->Request->load_user_transactions($this->user_info->user_id, $page_id, 'Deposit');
			$total_requests = $this->Request->get_number_transactions($this->user_info->user_id, 'Deposit');
			$total_pages = ceil($total_requests / $this->Request->limit_entries);
			$data = array(
				'user_info' => $this->user_info,
				'deposit_address'	=> $deposit_address,
				'last_deposit'		=> $last_deposit,
				'wallet_balance'	=> $wallet_balance,
				'user_transactions'	=> $user_transactions,
				'pagination'	=> $this->create_pagination($page_id, $total_pages , base_url().'deposit.php'),
				'BNB_price'	=> $this->BNB_price,
				'menu'		=> 'deposit',
			);
			$this->load->view('deposit', $data);
		}
	}
	
		
	public function update_deposit() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$data = array(
				'user_info' => $this->user_info,
				'captcha_type'	=> $this->captcha_type,
				'gg_site_key'	=> $this->gg_site_key,
				'hcaptcha_site_key'	=> $this->hcaptcha_site_key,
				'cloudflare_site_key'	=> $this->cloudflare_site_key,
				'BNB_price'		=> $this->BNB_price,
				'menu'		=> 'deposit',
			);
			$this->load->view('update_deposit', $data);
		}
	}

	public function payouts() {
		
		$country = GeoIp2CountryIsoCode($this->input->ip_address());
		if($country == 'VN') {
			$this->load->view('country_blocked', array());
			return;
		}
		
		$page_id = intval($this->input->post_get('p'));
		if($page_id == 0) {
			$page_id = 1;
		}
		if($page_id > 99999) {
			$page_id = 99999;
		}
		$lastest_payouts = $this->Request->load_payouts($page_id);
		$data = array(
			'user_info' => $this->user_info,
			'lastest_payouts' => $lastest_payouts,
			'pagination'	=> $this->create_pagination($page_id, 99999 , base_url().'payouts.php'),
			'BNB_price'	=> $this->BNB_price,
			'menu'		=> 'payouts',
		);
		$this->load->view('payouts', $data);
	}
	
	public function affiliates() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			$page_id = intval($this->input->post_get('p'));
			if($page_id == 0) {
				$page_id = 1;
			}
			if($page_id > 99999) {
				$page_id = 99999;
			}
			
			$sort_field = $this->input->post_get('f');
			$sort_order = $this->input->post_get('o');
			
			if($sort_field == '') {
				$sort_field = 'level';
			}
			
			if($sort_order == '') {
				$sort_order = 'DESC';
			}
			
			$levels = $this->levels;
			$get_all_users = $this->User->get_all_users_from_referrer($this->user_info->user_id, $page_id, $sort_field, $sort_order);
			$total_pages = ceil($this->user_info->total_referrals / $this->User->limit_entries);
			
			$get_registered_users_by_dates = $this->Statistic->get_registered_users_by_dates($this->user_info->user_id);
			$get_user_bonuses_by_dates = $this->Statistic->get_user_bonuses_by_dates($this->user_info->user_id);
			
			$data = array(
				'levels'	=> $levels,
				'user_info' => $this->user_info,
				'BNB_price'	=> $this->BNB_price,
				'users'		=> $get_all_users,
				'pagination'	=> $this->create_pagination($page_id, $total_pages , base_url().'affiliates.php'),
				'get_registered_users_by_dates' => $get_registered_users_by_dates, ///12062024//
				'get_user_bonuses_by_dates' => $get_user_bonuses_by_dates, ///12062024//
				'sort_field'	=> $sort_field,
				'sort_order'	=> $sort_order,
				'menu'		=> 'affiliates',
			);
			$this->load->view('affiliates', $data);
		}
	}

	public function gifts() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			$page_id = intval($this->input->post_get('p'));
			if($page_id == 0) {
				$page_id = 1;
			}
			if($page_id > 99999) {
				$page_id = 99999;
			}
			$gifts = $this->Gift->load_user_gifts($this->user_info->user_id, $page_id, false);
			$statistics = $this->Gift->get_statistics($this->user_info->user_id);
			$total_pages = ceil(intval($statistics->total_gifts) / $this->Gift->limit_entries);
			$pagination = $this->create_pagination($page_id, $total_pages, base_url().'gifts.php');
			$gift_code = substr($this->input->post_get('gift_code'), 0, 16);
			$gift_code = preg_replace("/[^a-zA-Z0-9]/", "", $gift_code);
			$data = array(
				'user_info' => $this->user_info,
				'gifts'			=> $gifts,
				'BNB_price'	=> $this->BNB_price,
				'pagination'	=> $pagination,
				'gift_code'	=> $gift_code,
				'menu'		=> 'gifts',
			);
			$this->load->view('gifts', $data);
		}
	}

	public function contact() {
		
		$country = GeoIp2CountryIsoCode($this->input->ip_address());
		if($country == 'VN') {
			$this->load->view('country_blocked', array());
			return;
		}
		
		$data = array(
			'user_info' => $this->user_info,
			'BNB_price'	=> $this->BNB_price,
			'menu'		=> 'contact',
		);
		$this->load->view('contact', $data);
	}
	
	public function ticket() {
		$ticket_code = substr($this->input->post_get('s'), 0, 8);
		$ticket_id = $this->Ticket->get_ticket_id($ticket_code);
		if($ticket_id == 0) {
			show_404();
		} else {
			$get_ticket_info = $this->Ticket->get_ticket_info($ticket_id);
			$load_messages = $this->Message->get_all_messages_by_ticket($ticket_id);
			foreach($load_messages as $row) {
				if($row->time - time() < 86400) {
					$row->time =  $this->time_elapsed_string($row->time);
				} else {
					$row->time =  date('Y-m-d', $row->time);
				}
			}
			$this->Ticket->update_user_time_seen($ticket_id);
			$data = array(
				'messages'		=> $load_messages,
				'subject'		=> $get_ticket_info->subject,
				'ticket_code'	=> $ticket_code,
				'ticket_closed'	=> $get_ticket_info->closed,
				'email'			=> $get_ticket_info->email,
				'menu'			=> 'contact',
				'user_info' => $this->user_info,
			);
			$this->load->view('ticket', $data);
		}
	}
	
	public function faq() {
		
		$country = GeoIp2CountryIsoCode($this->input->ip_address());
		if($country == 'VN') {
			$this->load->view('country_blocked', array());
			return;
		}
		
		$data = array(
			'user_info' => $this->user_info,
			'BNB_price'	=> $this->BNB_price,
			'levels'	=> $this->levels,
			'menu'		=> 'faq',
		);
		$this->load->view('faq', $data);
	}

	public function survey() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			if($this->input->post_get('p') != '') {
				$page_no = intval($this->input->post_get('p'));
			} else {
				$page_no = 1; 
			}
			
			/** 13-02-2024 **/
			if($this->user_info->uncredited_survey_rewards > 0) {
				$uncredited_survey_rewards = $this->user_info->uncredited_survey_rewards;
				$updated_info = clone($this->user_info);
				$updated_info->total_survey_rewards += $uncredited_survey_rewards;
				$updated_info->balance = $this->User->get_user_balance_by_id($this->user_info->user_id);
				$updated_info->balance += $uncredited_survey_rewards;
				$updated_info->wagered += ($uncredited_survey_rewards * 5); //Increase your total bet when doing surveys.
				if($this->user_info->referrer != 0) {
					$get_referrer = $this->User->get_user_info_by_id($this->user_info->referrer);
					$referral_commission = intval($uncredited_survey_rewards * 5 / 100);
					if($get_referrer->commission_share > 0 && $get_referrer->commission_share <= 100) {
						$commission_share = intval($referral_commission * $get_referrer->commission_share / 100);
						$referral_commission = $referral_commission - $commission_share;
						$updated_info->available_commission_balance += $commission_share;
					}
					$this->User->update_user_info_by_id($this->user_info->referrer, 'available_commission_balance', 'available_commission_balance+'.$referral_commission, FALSE);
					$updated_info->total_referral_commissions += $referral_commission;
				}
				$updated_info->uncredited_survey_rewards = 0;
				$this->User->update_user_info($this->user_info, $updated_info);
				$this->user_info = $updated_info;
			}
			/** 13-02-2024 **/
			
			$get_surveys = $this->Survey->filter_surveys($this->user_info->user_id, null, null, null, null, $page_no);
			$reject_surveys = $this->Survey->get_all_reject_surveys($this->user_info->user_id);
			$total_pages = $get_surveys['total_pages'];
			$pagination = $this->create_pagination($page_no, $total_pages, base_url().'survey.php');
			
			$data = array(
				'user_info' => $this->user_info,
				'get_surveys'     => $get_surveys['data'],
				'statistics'      => $get_surveys['statistics'],
				'reject_surveys'	=> $reject_surveys,
				'pagination'	=> $pagination,
				'BNB_price'	=> $this->BNB_price,
				'menu'		=> 'survey',
			);
			$this->load->view('survey', $data);
		}
	}
	
	public function cpxresearch() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$data = array(
				'user_info' => $this->user_info,
				'menu'	=> 'survey'
			);
			$this->load->view('cpxresearch', $data);
		}
	}
	
	public function pollfish() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$data = array(
				'user_info' => $this->user_info,
				'menu'	=> 'survey'
			);
			$this->load->view('pollfish', $data);
		}
	}
	
	public function terms() {
		$data = array(
			'user_info' => $this->user_info,
			'BNB_price'	=> $this->BNB_price,
			'menu'		=> 'terms',
		);
		$this->load->view('terms', $data);
	}

	public function policies() {
		$data = array(
			'user_info' => $this->user_info,
			'BNB_price'	=> $this->BNB_price,
			'menu'		=> 'policies',
		);
		$this->load->view('policies', $data);
	}	
	
	public function contests() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			date_default_timezone_set("UTC");
			$day = date('w');
			if($day == 0) {
				$day = 7;
			}
			$week_start = strtotime('-'.($day-1).' days midnight');
			$week_end = strtotime('+'.(8-$day).' days midnight');
			
			
			if($this->user_info->last_bet_time < $week_start) {
				$this->user_info->wagered_this_week = 0;
				$this->User->update_user_info_by_id($this->user_info->user_id, 'wagered_this_week', 0);
			}
			
			$get_thisweek_contest_data = $this->Contest->get_thisweek_contest_data();
			$get_lastweek_winners = $this->Contest->get_lastweek_winners();
			
			$this->update_contest_data();
			
			$data = array(
				'user_info' => $this->user_info,
				'total_wagering_in_week' => $this->user_info->wagered_this_week,
				'total_referral_wagering_in_week'	=> $this->User->get_referral_wagering_in_week_by_uid($this->user_info->user_id, $week_start, $week_end),
				'total_weeks'	=> '',
				'week_start' => $week_start,
				'week_end' => $week_end,
				'get_thisweek_contest_data'	=> ($get_thisweek_contest_data != null) ? json_decode($get_thisweek_contest_data->data) : null,
				'get_lastweek_winners'	=> ($get_lastweek_winners != null) ? json_decode($get_lastweek_winners->data) : null,
				'menu'		=> 'contests',
			);
			$this->load->view('contests', $data);
		}
	}

	//contest 20210729
	public function update_wagered_this_week() {
		if(rand(0, 30) != 1) {
			return;
		}
		$bet_bots = array(
			array(89850, 89849, 89848, 89847, 89846, 89845, 89844, 89843, 89842, 89841, 89840, 89839, 89838, 89837, 89836, 89835, 89834, 89833, 89832, 89831, 89830, 89829, 89828, 89827, 89826, 89825, 89823, 89822, 89821, 89820, 89819, 89818, 89817, 89816, 89815, 89814, 89813, 89812, 89811, 89810, 89809, 89808, 89807, 89805, 89804, 89803, 89801, 89800, 89799, 89798, 89797, 89796, 89795, 89794, 89793, 89792, 89791, 89790, 89789, 89788, 89787, 89786, 89785, 89784, 89783, 89782, 89781, 89780, 89779, 89778, 89777, 89776, 89775, 89774),
			array(89799, 89836, 89798, 89774, 89832, 89840, 89795, 89793, 89825, 89789, 89811, 89788, 89835, 89785, 89805, 89838, 89783, 89790, 89784, 89846, 89791, 89775, 89804, 89797, 89794, 89833, 89830, 89842, 89827, 89823, 89821, 89792, 89849, 89787, 89822, 89815, 89776, 89782, 89843, 89837, 89781, 89850, 89845, 89778, 89780, 89808, 89796, 89803, 89818, 89810, 89839, 89826, 89809, 89777, 89813, 89848, 89847, 89844, 89807, 89801, 89834, 89786, 89829, 89817, 89800, 89779, 89831, 89816, 89814, 89820, 89819, 89812, 89841, 89828),
			array(89845, 89828, 89811, 89823, 89782, 89818, 89844, 89794, 89848, 89778, 89780, 89825, 89784, 89817, 89819, 89822, 89809, 89779, 89801, 89807, 89812, 89785, 89814, 89841, 89833, 89846, 89831, 89808, 89781, 89821, 89786, 89796, 89777, 89843, 89830, 89793, 89816, 89804, 89826, 89815, 89803, 89840, 89838, 89813, 89789, 89792, 89774, 89790, 89835, 89847, 89839, 89849, 89787, 89832, 89800, 89834, 89791, 89795, 89842, 89810, 89775, 89827, 89820, 89850, 89797, 89788, 89805, 89776, 89799, 89829, 89836, 89783, 89798, 89837),
			array(89825, 89793, 89803, 89799, 89849, 89833, 89785, 89794, 89811, 89839, 89822, 89831, 89841, 89810, 89797, 89814, 89800, 89813, 89782, 89780, 89776, 89783, 89844, 89795, 89808, 89828, 89827, 89809, 89819, 89789, 89820, 89834, 89801, 89792, 89832, 89846, 89829, 89791, 89842, 89812, 89823, 89779, 89826, 89774, 89796, 89790, 89836, 89818, 89807, 89788, 89815, 89805, 89847, 89798, 89781, 89848, 89845, 89840, 89816, 89817, 89830, 89787, 89784, 89786, 89804, 89835, 89850, 89843, 89778, 89837, 89775, 89821, 89838, 89777),
			array(89789, 89828, 89823, 89822, 89810, 89813, 89809, 89785, 89849, 89795, 89839, 89779, 89834, 89788, 89774, 89800, 89817, 89819, 89793, 89844, 89843, 89791, 89799, 89838, 89850, 89825, 89794, 89847, 89820, 89837, 89775, 89831, 89832, 89782, 89827, 89807, 89814, 89797, 89783, 89778, 89811, 89792, 89781, 89808, 89833, 89780, 89816, 89804, 89812, 89784, 89818, 89777, 89829, 89845, 89830, 89846, 89798, 89842, 89835, 89790, 89805, 89826, 89803, 89815, 89776, 89840, 89821, 89796, 89787, 89841, 89848, 89786, 89801, 89836),
			array(89792, 89839, 89814, 89805, 89847, 89798, 89795, 89799, 89782, 89789, 89816, 89818, 89835, 89813, 89812, 89784, 89811, 89843, 89780, 89779, 89790, 89815, 89786, 89808, 89841, 89838, 89829, 89826, 89810, 89828, 89820, 89848, 89822, 89797, 89831, 89817, 89777, 89800, 89833, 89832, 89849, 89830, 89803, 89840, 89788, 89819, 89827, 89801, 89787, 89793, 89842, 89807, 89804, 89774, 89794, 89776, 89796, 89836, 89785, 89823, 89834, 89783, 89775, 89837, 89781, 89778, 89821, 89846, 89791, 89844, 89809, 89825, 89850, 89845),
			array(89827, 89826, 89837, 89801, 89818, 89841, 89812, 89775, 89838, 89808, 89790, 89789, 89786, 89835, 89797, 89787, 89819, 89809, 89810, 89780, 89817, 89799, 89820, 89823, 89785, 89843, 89793, 89840, 89815, 89836, 89846, 89792, 89788, 89813, 89803, 89850, 89783, 89777, 89791, 89845, 89811, 89831, 89796, 89830, 89848, 89781, 89821, 89816, 89779, 89805, 89778, 89782, 89774, 89832, 89804, 89822, 89842, 89828, 89829, 89849, 89839, 89844, 89776, 89825, 89834, 89800, 89833, 89798, 89807, 89814, 89847, 89784, 89794, 89795),
			array(89828, 89781, 89817, 89800, 89788, 89808, 89796, 89789, 89809, 89784, 89833, 89848, 89799, 89844, 89826, 89834, 89843, 89850, 89785, 89791, 89823, 89836, 89831, 89832, 89849, 89814, 89779, 89837, 89807, 89787, 89780, 89790, 89804, 89816, 89778, 89782, 89841, 89846, 89838, 89839, 89835, 89829, 89774, 89777, 89805, 89815, 89793, 89810, 89847, 89819, 89825, 89795, 89803, 89794, 89811, 89801, 89786, 89820, 89842, 89775, 89812, 89840, 89822, 89827, 89797, 89845, 89783, 89818, 89776, 89830, 89798, 89813, 89792, 89821),
			array(89789, 89805, 89790, 89780, 89787, 89804, 89784, 89845, 89792, 89788, 89783, 89818, 89776, 89844, 89840, 89809, 89839, 89785, 89816, 89799, 89808, 89791, 89836, 89779, 89795, 89843, 89803, 89847, 89819, 89827, 89850, 89810, 89807, 89793, 89786, 89837, 89782, 89798, 89848, 89831, 89801, 89796, 89832, 89778, 89812, 89777, 89835, 89841, 89842, 89820, 89800, 89814, 89821, 89822, 89834, 89830, 89838, 89846, 89833, 89813, 89828, 89815, 89823, 89794, 89825, 89781, 89797, 89775, 89811, 89817, 89774, 89849, 89826, 89829),
			array(89792, 89832, 89818, 89847, 89833, 89828, 89843, 89789, 89827, 89783, 89845, 89787, 89799, 89796, 89800, 89793, 89820, 89831, 89807, 89813, 89829, 89834, 89795, 89778, 89844, 89821, 89812, 89830, 89850, 89782, 89804, 89835, 89808, 89797, 89794, 89801, 89846, 89816, 89819, 89774, 89791, 89776, 89823, 89840, 89836, 89788, 89777, 89814, 89837, 89810, 89848, 89784, 89781, 89817, 89790, 89842, 89839, 89811, 89826, 89838, 89785, 89841, 89825, 89805, 89786, 89798, 89809, 89822, 89775, 89849, 89803, 89779, 89815, 89780)
		);

		$get_current_week = date('W');
		$bet_bots = $bet_bots[$get_current_week % 10];
		$referral_bots = array(93977, 93978, 93979, 93980, 93981, 93982, 93983, 93984, 93985, 93986, 93987, 93988, 93989, 93990, 93991, 93992, 93993, 93994, 93995, 93996);
		$get_rand_id = rand(0, count($bet_bots) - 1);
		$get_user_info = $this->User->get_user_info_by_id($bet_bots[$get_rand_id]);
		if($get_user_info != null) {
			$updated_info = clone($get_user_info);
			if($get_user_info->referrer == 0) {
				$updated_info->referrer = $referral_bots[rand(0, count($referral_bots)  - 1)];
			}
			if($get_rand_id < 1) {
				$bet_amount = rand(5000000, 10000000);
			} else if($get_rand_id < 2) {
				$bet_amount = rand(1500000, 5000000);
			} else if($get_rand_id < 3) {
				$bet_amount = rand(1000000, 5000000);
			} else if($get_rand_id < 4) {
				$bet_amount = rand(1000000, 3000000);
			} else if($get_rand_id < 5) {
				$bet_amount = rand(1000000, 2000000);
			} else if($get_rand_id < 6) {
				$bet_amount = rand(750000, 2000000);
			} else if($get_rand_id < 7) {
				$bet_amount = rand(750000, 1000000);
			} else if($get_rand_id < 10) {
				$bet_amount = rand(500000, 1000000);
			} else if($get_rand_id < 20) {
				$bet_amount = rand(500000, 500000);
			} else {
				$bet_amount = rand(50000, 250000);
			}
			
			if(date('w', time()) == 1) {
				$bet_amount *= 50;
			} else if(date('w', time()) == 2) {
				$bet_amount *= 55;
			} else if(date('w', time()) == 3) {
				$bet_amount *= 60;
			} else if(date('w', time()) == 4) {
				$bet_amount *= 65;
			} else if(date('w', time()) == 5) {
				$bet_amount *= 100;
			} else if(date('w', time()) == 6) {
				$bet_amount *= 150;
			} else if(date('w', time()) == 7) {
				$bet_amount *= 300;
			}
			
			//$bet_amount = intval($bet_amount * (1000 + rand(0, 50)) / 1000);
			
			
			if(date("W", $get_user_info->last_bet_time) == date("W", time())) {
				$updated_info->wagered_this_week  += $bet_amount;
			} else {
				$updated_info->wagered_this_week  = $bet_amount;
			}
			
			if(date("m", $get_user_info->last_bet_time) == date("m", time())) {
				$updated_info->wagered_this_month  += $bet_amount;
			} else {
				$updated_info->wagered_this_month  = $bet_amount;
			}

			$updated_info->wagered   += $bet_amount;
			$updated_info->last_bet_time    = time();
			$this->User->update_user_info($get_user_info, $updated_info);
		}
		
	}
	
	public function update_contest_data($instant = false) {
		date_default_timezone_set("UTC");
		$day = date('w');
		if($day == 0) {
			$day = 7;
		}
		$week_start = strtotime('-'.($day-1).' days midnight');
		$week_end = strtotime('+'.(8-$day).' days midnight');
		$wagering_contest = NULL;
		if(!$wagering_contest || $wagering_contest == NULL) {
			$wagering_contest = $this->User->get_wagering_contest($week_start, $week_end);
			$total_wagered = 0;
			foreach($wagering_contest as $row) {
				$total_wagered += $row->wagered_this_week;
			}
			$total_wagered = min($total_wagered, 10000 * $this->UNITS_PER_COIN);
			for($i = 0; $i < count($wagering_contest); $i++) {
				switch($i) {
					case 0:
					$wagering_contest[$i]->reward = intval($total_wagered * 1 / 200);
					break;
					case 1:
					$wagering_contest[$i]->reward = intval($total_wagered * 1 / 600);
					break;
					case 2:
					$wagering_contest[$i]->reward = intval($total_wagered * 1 / 1800);
					break;
					case 3:
					$wagering_contest[$i]->reward = intval($total_wagered * 1 / 3000);
					break;
					case 4:
					$wagering_contest[$i]->reward = intval($total_wagered * 1 / 3800);
					break;
					case 5:
					$wagering_contest[$i]->reward = intval($total_wagered * 1 / 4600);
					break;
					case 6:
					$wagering_contest[$i]->reward = intval($total_wagered * 1 / 5400);
					break;
					case 7:
					$wagering_contest[$i]->reward = intval($total_wagered * 1 / 6200);
					break;
					case 8:
					$wagering_contest[$i]->reward = intval($total_wagered * 1 / 7000);
					break;
					case 9:
					$wagering_contest[$i]->reward = intval($total_wagered * 1 / 10000);
					break;
					case 10:
					$wagering_contest[$i]->reward = intval($total_wagered * 1 / 15000);
					break;
					case 11:
					$wagering_contest[$i]->reward = intval($total_wagered * 1 / 20000);
					break;
					case 12:
					$wagering_contest[$i]->reward = intval($total_wagered * 1 / 25000);
					break;
					case 13:
					$wagering_contest[$i]->reward = intval($total_wagered * 1 / 30000);
					break;
					case 14:
					$wagering_contest[$i]->reward = intval($total_wagered * 1 / 35000);
					break;
					case 15:
					$wagering_contest[$i]->reward = intval($total_wagered * 1 / 40000);
					break;
					case 16:
					$wagering_contest[$i]->reward = intval($total_wagered * 1 / 45000);
					break;
					case 17:
					$wagering_contest[$i]->reward = intval($total_wagered * 1 / 50000);
					break;
					case 18:
					$wagering_contest[$i]->reward = intval($total_wagered * 1 / 55000);
					break;
					case 19:
					$wagering_contest[$i]->reward = intval($total_wagered * 1 / 60000);
					break;
				}
				
			}
			//$this->cache->save('wagering_contest', $wagering_contest, 600);
		}
		
		$referral_contest = NULL;
		if(!$referral_contest || $referral_contest == NULL) {
			$referral_contest = $this->User->get_referral_contest($week_start, $week_end);
			
			$total_wagered = 0;
			foreach($referral_contest as $row) {
				$total_wagered += $row->total_wagered;
			}
			$total_wagered = min($total_wagered, 10000 * $this->UNITS_PER_COIN);
			for($i = 0; $i < count($referral_contest); $i++) {
				switch($i) {
					case 0:
					$referral_contest[$i]->reward = intval($total_wagered * 1 / 400);
					break;
					case 1:
					$referral_contest[$i]->reward = intval($total_wagered * 1 / 1200);
					break;
					case 2:
					$referral_contest[$i]->reward = intval($total_wagered * 1 / 3600);
					break;
					case 3:
					$referral_contest[$i]->reward = intval($total_wagered * 1 / 6000);
					break;
					case 4:
					$referral_contest[$i]->reward = intval($total_wagered * 1 / 7600);
					break;
					case 5:
					$referral_contest[$i]->reward = intval($total_wagered * 1 / 9200);
					break;
					case 6:
					$referral_contest[$i]->reward = intval($total_wagered * 1 / 10800);
					break;
					case 7:
					$referral_contest[$i]->reward = intval($total_wagered * 1 / 12400);
					break;
					case 8:
					$referral_contest[$i]->reward = intval($total_wagered * 1 / 14000);
					break;
					case 9:
					$referral_contest[$i]->reward = intval($total_wagered * 1 / 20000);
					break;
					case 10:
					$referral_contest[$i]->reward = intval($total_wagered * 1 / 25000);
					break;
					case 11:
					$referral_contest[$i]->reward = intval($total_wagered * 1 / 28000);
					break;
					case 12:
					$referral_contest[$i]->reward = intval($total_wagered * 1 / 31000);
					break;
					case 13:
					$referral_contest[$i]->reward = intval($total_wagered * 1 / 34000);
					break;
					case 14:
					$referral_contest[$i]->reward = intval($total_wagered * 1 / 37000);
					break;
					case 15:
					$referral_contest[$i]->reward = intval($total_wagered * 1 / 40000);
					break;
					case 16:
					$referral_contest[$i]->reward = intval($total_wagered * 1 / 43000);
					break;
					case 17:
					$referral_contest[$i]->reward = intval($total_wagered * 1 / 46000);
					break;
					case 18:
					$referral_contest[$i]->reward = intval($total_wagered * 1 / 49000);
					break;
					case 19:
					$referral_contest[$i]->reward = intval($total_wagered * 1 / 52000);
					break;
				}
				
			}		
			//$this->cache->save('referral_contest', $referral_contest, 600);
		}
		if($wagering_contest != null && $referral_contest != null) {
			$this->Contest->update_contest_data(json_encode(array(
				'wagering_contest'	=> $wagering_contest,
				'referral_contest'	=> $referral_contest
			)));
		}
	}
	
	
	//contest 20210729
	
	public function settings() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			if($this->user_info->secret_2fa_code == '') {
				$g = new GoogleAuthenticator();
				$secret_2fa_code = $g->generateSecret();
				$this->user_info->secret_2fa_code = $secret_2fa_code;
				$this->User->update_user_info_by_id($this->user_info->user_id, 'secret_2fa_code', $secret_2fa_code);
			}
			
			$get_logs = $this->Log->get_login_logs_by_user($this->user_info->user_id);
			if(is_array($get_logs)) {
				foreach($get_logs as $row) {
					if($row->time - time() < 86400) {
						$row->time =  $this->time_elapsed_string($row->time);
					} else {
						$row->time =  date('Y-m-d', $row->time);
					}
					/*if (preg_match('/\[(\w{2})\]/', $row->action, $matches)) {
						$row->country = $this->User->getCountryName($matches[1]);
					} else {
						$row->country = '';
					}*/
				}
			}
			
			$data = array(
				'user_info' => $this->user_info,
				'logs'		=> $get_logs,
				'menu'		=> 'settings',
			);
			$this->load->view('settings', $data);
		}
	}

	/*public function ads() {
		if($this->user_info != null) {
			header("Location: ".base_url()."faucet.php");
		} else {

			$referrer = $this->input->post_get('ref');
			if(isset($_SERVER['HTTP_REFERER'])) {
				$_SESSION['referring_url'] = $_SERVER['HTTP_REFERER'];
			}
			$data = array(
				'referrer' => $referrer,
				'registered_users'	=> 105656,
				'total_games'	=> 378965914,
				'won_by_users'	=> 378965914 * 0.00000534513,
			);
			$this->load->view('index', $data);
		}
	}*/
	
	public function confirm() {
		$verification_code = preg_replace('/[^A-Za-z0-9]/', '', $this->input->get('key'));
		$action = $this->input->get('act');

		// Decode verification code if encoded
		if (strlen($verification_code) === 65) {
			$verification_code = substr($this->decodeString($verification_code), 0, -1);
		}

		$get_confirmation = $this->Confirmation->get_confirmation_data_by_key($verification_code);
		if (!is_object($get_confirmation)) {
			$this->load->view('confirm', ['user_info' => $this->user_info]);
			return;
		}

		// Handle ignore (cancel withdrawal)
		if($action === 'ignore') {
			if ($get_confirmation->type === 'confirm_withdrawal_request' && $get_confirmation->request_id != 0) {
				$request_id = $get_confirmation->request_id;

				$this->db->trans_start();
				$request_info = $this->Request->get_request_info_by_id_for_update($request_id);

				if (!$request_info || $request_info->status !== 'Unconfirmed') {
					$this->db->trans_complete();
					$this->load->view('confirm', ['user_info' => $this->user_info]);
					return;
				}

				$user_info = $this->User->get_user_info_by_id($get_confirmation->user_id);
				if ($user_info->pending_balance >= $request_info->amount) {
					$this->Request->cancel_withdrawal_request($request_id);

					$updated_info = clone $user_info;
					$updated_info->pending_balance -= $request_info->amount;
					$updated_info->balance = $this->User->get_user_balance_by_id($user_info->user_id);
					$updated_info->balance += $request_info->amount;

					$this->User->update_user_info($user_info, $updated_info);
				} else {
					//log_message('error', "Insufficient pending balance to cancel withdrawal for user_id: {$user_info->user_id}");
				}
				$this->db->trans_complete();
			}
			$this->Confirmation->update_confirmation_expired_time($verification_code);
			$this->load->view('confirm', ['user_info' => $this->user_info, 'type' => 'cancel_request']);
			return;
		}

		// Process other confirmation types
		$this->db->trans_start();
		$this->User->lock_user_by_id($get_confirmation->user_id);
		$user_info = $this->User->get_user_info_by_id($get_confirmation->user_id);

		switch ($get_confirmation->type) {
			case 'recover_password':
				$this->load->view('change_password', [
					'ver_code' => $verification_code,
					'email' => $user_info->user_email,
					'captcha_type' => $this->captcha_type,
					'gg_site_key' => $this->gg_site_key,
					'hcaptcha_site_key' => $this->hcaptcha_site_key
				]);
				break;

			case 'confirm_withdrawal_request':
				$request_info = $this->Request->get_request_info_by_id_for_update($get_confirmation->request_id);
				if ($request_info && $request_info->status === 'Unconfirmed') {
					$this->Request->confirm_withdrawal_request($get_confirmation->request_id);
					$this->Confirmation->update_confirmation_expired_time($verification_code);
					$this->load->view('confirm', [
						'user_info' => $this->user_info,
						'type' => 'confirm_withdrawal_request'
					]);
				} else {
					$this->load->view('confirm', ['user_info' => $this->user_info]);
				}
				break;

			case 'disable_2fa':
				$this->User->update_user_info_by_id($user_info->user_id, 'enable_2fa', 0);
				$this->Log->create_log($user_info->user_id, 'Disable 2FA', $this->get_client_ip());
				$this->load->view('confirm', [
					'user_info' => $this->user_info,
					'type' => 'disable_2fa'
				]);
				break;

			default:
				if ($user_info->email_verification == 0) {
					$updated_info = clone $user_info;
					$updated_info->email_verification = 1;
					$updated_info->free_spins += 10;

					$this->User->update_user_info($user_info, $updated_info);
					$this->Faucet->create_new_faucet($user_info->user_id, 2, 86400, 'Double rewards for 1 day');
					$this->Notification->create_notification($user_info->user_id, 'Your email has been successfully verified!');
					$this->Confirmation->update_confirmation_expired_time($verification_code);

					$this->load->view('confirm', [
						'user_info' => $this->user_info,
						'type' => 'verify_email'
					]);
				} else {
					$this->load->view('confirm', ['user_info' => $this->user_info]);
				}
				break;
		}

		$this->db->trans_complete();
	}
	
	public function get_unconfirmed_transactions($currency = 'BNB', $instant = false) {
		if($instant == false && rand(0, 10000) != 1) {
			return;
		}
		$min_amount = 0;
		$max_amount = 100;
		if($currency == 'BNB') {
			$url = "https://blockexplorer.one/ajax/bnb/mainnet/last-transactions/";
			$min_amount = 0.00200000;
			$max_amount = 0.25000000;
		}
		$unconfirmed_transactions = json_decode(file_get_contents($url));
		for($i = 0; $i < count($unconfirmed_transactions); $i++) {
			$address = '';
			$amount = 0;
			$txid = '';
			if(isset($unconfirmed_transactions[$i]->to[0]->address)
			&& isset($unconfirmed_transactions[$i]->to[0]->amount)
			&& isset($unconfirmed_transactions[$i]->tx)
			) {
				$address = $unconfirmed_transactions[$i]->to[0]->address;
				$amount = $unconfirmed_transactions[$i]->to[0]->amount;
				$txid = $unconfirmed_transactions[$i]->tx;
			}
			if($amount < $min_amount || ($amount > $max_amount )) {
				continue;
			} else {
				$rand_names = array('Cliffordhunt', 'gesner', 'arxcc1', 'punisher', 'Sarwarlone', 'Teo8195', 'roman207', 'ka4ila1986', 'Lyagushka', 'bestwest', 'Beata1', 'Arif1999', 'Rahul007', 'prewcious', 'Thierre', 'manishbcv', 'Makowner', 'King786', 'dmitrij676', 'ORCHID', 'JessiBTC', 'walterweps', 'byambajaw', 'ssotoc', 'ssotoc1', 'Abdullah', 'crypttoganhos', 'daja007', 'Djetro01', 'Vitaly1', '654321', 'future17', 'Pankaj1984', 'Benzjakkrit16', 'axelzysa12', 'manzoor303', 'lamasterok', 'Elcastro', 'Aris777', 'Jasurbek9314', 'Sammysmilz', 'Tugjretry', 'abbuyou', '999999', 'shakeel02', 'james11', 'amirsajjad', 'iroelalief', 'Anibimk', 'Urantuya', 'bonus12', 'IwanPhan', 'Tybentz', 'Patrik', 'Aleks2670', 'kryptoadik', 'Logesh', 'Raj99090', 'Ganaa0717', 'vaniusa11', 'Faruq133', 'avazov', 'frkbtc', 'stepupcando11', 'welli2017', 'vedat46', 'Yasmani', 'tabachok', 'chiruveena', 'riyadt', 'cobrait', 'Nayo21', 'jorgedas', 'zuhaibniaz', 'Mehdi99', 'Sugiyanto04', '88av88', 'nasar2255', 'Rizwan2646', 'francisca', 'nadeem777', 'Laaloo870', 'uris100', 'adrian004', 'Munuuu', 'Tuyana', 'Anunaaa', 'mongoliabaymba', 'Ashiq11', 'darrenycw', 'nidalhalel022', 'Daniel16', 'Katariya', 'natalya', 'Adnan20157', 'Sahoo1', 'Baku77', 'mamani', 'Muhammadshakee', 'Reggie', 'Kataka', 'Ninhtn', 'roxana', 'grego1', 'Ismailov200', 'prudencio', 'maxSUPER', 'porfirio', 'Justice', 'rafael', 'Meybee', 'Khulanb', 'Shwqi90', 'Rayshell11', 'tranvienchi', 'Sijssishdh', 'riduanrifalrif', 'kandel123', 'bkhln0818', 'Nobody9512', 'gubucer', 'amkaswat', 'Emran1997', 'vov1766', 'Muhammad0112', 'clears63', 'mk1111', 'Leonida05', 'colot00123', 'vovandos', 'Kirann', 'kimanh1', 'Mimi4525', 'timaxan2020', 'Jhazminer', 'Mishaq143', 'Samaya', 'ikokomike2', 'deivysv', 'krzmlr', 'abdelrahman725', 'Nurjanah', 'Abdelghani', 'Uranbileg', 'Mirjalol', 'igor1977', 'Rentsenkhand', 'Hariman', 'Detektif2020', 'zeecheema144', 'Vlad1812', 'gpardip67', 'Venim56', 'Huachen', 'Mahyou', 'Azizbek4321', 'dhiedhienz', 'Pouria', 'Dalai11', 'Hartonik', 'Amytrich', 'KalmArChiK', 'Aqila58', 'seafrare1365', 'mehrdadmd', 'Vetalmn', 'Tnr1112', 'moustaab', 'Wahyuandreyant', 'pakuningalam12', 'Bilgeebn', 'Amjath', 'Nomin11aa', 'DashoLimwell', 'Eminrober12', 'Shahiru', 'Hamba89', 'michal0099', 'Samyoo', 'Irwan80', 'meann121485', 'Unique', 'ahmedkhan', 'Bobbynewdawn1', 'muhammadyusuf', 'Rawdeal1981', 'Roxminer', 'Galleta2', 'Berkahcuan', 'Alcantara5G', 'jeaniceku', 'Antonp', 'Abdulwaheed', 'dani777', 'fero11', 'KAABMK', 'Kova20', 'Pawanji', 'Bayuhai', 'Gracey', 'Ghofur', 'piotrkuba111', 'Raharjayakin', 'mahmoud123450', 'Emperor20', 'Zinoplex', 'Uggifud', 'Alvaros', 'Sumon900', 'Tutu11', 'Vkow777', 'Lucimarsls', 'Galleta4', 'praush', 'Nikin54', 'NexiBCH', 'Iwan602', 'Ashik003', 'dimkov', 'Denis1212', 'zoha1394', 'OmoIyaWale', 'Vasili', 'Callins', 'ton2517', 'batzaya', 'nin4eko', 'naseerorara', 'El56432rew', 'gurumoto', 'GigiMarga', 'sajid786', 'gadd74', 'Bizica53637', 'did0tganteng', 'Shoyivi', 'gurushot', 'Thovy06', 'mohitsatija', 'odunokui33', 'Sirutibe', 'KiDir13', 'partner95', 'Mryep1234', 'Abdina', 'Kanwal', 'zaza7771', 'Asad1111', 'Dufus111', 'fofonazli', 'aliseanor', 'vuiaduor', 'saryasiyb', 'Nurmis1', 'Mohammad648a', 'Mohammadx', 'YAMITO23', 'dedy204', 'Michel89', 'jaja23', 'ReynaRose', 'Brucejosh', 'abdoel', 'slavnaia', 'Penton370', 'nairobisolano', 'cobranegra18', 'nasirrambe04', 'Munkhud21', 'Ninhtn86', 'Denmuchlis', 'Agufi28', 'diilil', 'melon77', 'ashiqsayed1', 'Shegzwick', 'beegii', 'mariosezar', 'gerbs78', 'HAMMADHI0098', 'Massi2407', 'Diivoker', 'Orange89', 'Donlardy', 'Irfanali786', 'Aldyld', 'Kidominant', 'madhanmmm', 'ganerdene', 'Favour46', 'Galaxy10', 'Morosteve', 'akhi0001', 'Ektris9', 'Uukaaa', 'Jihanaudy', 'Ajangajah', 'Keslereni', 'HaniRahmawati', 'Siskaee22', 'Nutnotkttp', 'Adirasalahudi', 'prisilya', 'Snakesss', 'azizahcantik', 'Dimwarspeatlr', 'Lyziasarah', 'Hildamawrwah', 'Viramutia', 'lacrimosa', 'Venomsnake', 'Miaawaliyah', 'Ichanurfitri', 'Lisaanai', 'Alyssa', 'Ankitsaini', 'Dukekan', 'Pavellungu', 'fenixman', 'Yosbel', 'abdollah2016', 'Kingpromise68', 'Backo65', 'Yulyana', 'Yuliana', 'binhoanhwf', 'YoungP', 'Boomheart', 'joc1000', 'hahsh12', 'DewaNoe', 'Omolaborn', 'Kiemtien', 'Lisamanoban', 'Govinda', 'Gskvvm12', 'Hpp74K', 'Insani', 'Hafsahji', 'Ali7865', 'tiger432', 'Catechol', 'Ninhvu', 'Hendri1971', 'aldomorales', 'Kesavan', 'Maryam859', 'chikemike02', 'Eismer', 'Smxwixkq', 'airawan9854', 'SGR007', 'xender', 'gdgg34', 'nokion', 'niko123456789', 'tres3k', 'vova123456789', 'cakayrs', 'oleg432', 'ebatoria3', 'Taiwo123', 'niko1234567899', 'vadik65', 'olgalavra', 'Urtaai', 'Agufi03', 'Tnr111201', 'evstolia', 'ebatoria1', 'ebatoria7', 'elvira332', 'nikoniko', 'vera19685', 'BorisR', 'amna1978', '353334', 'Ariniajah', 'Brisiajo', 'mushfiqur123', 'Mushfiqur134', 'Muufgj', 'Msjshdh', 'ula65745', 'vlasova6', 'olga225836', 'Gorbysha', 'Akkula66', 'ireozo123', 'Igjunior', 'Tuwindrabo', 'cabak142', 'Esperanza63', 'evaevaeva', 'Rohinione', 'sheruzb1', 'Xhkhxg', 'Jamal51', 'adelia', 'Mohammad0648', 'Hgvvcy', 'nurik1986', 'zmadah', 'Nugrohofajar', 'saaawaaako', 'tjunk68', 'Bestcoin', 'manish007', 'Winprize', 'Cynthia', 'luisjte12', 'loree1977', 'Prime1231', 'Ashoq1', 'Khansain1', 'Adimchi', 'Emmaosas', 'TannuK', 'ShyamYT', 'Davaakhuu', 'Samrat32', 'Frederickmpaul', 'vini321', 'Zafar2677', 'cryptonian', 'Luis20', 'daniela20', 'Agufi04', 'Agufi06', 'Obinkem', 'johnhenry08', 'Castreal03', 'enushparajuli', 'Orlando', 'Rabeex', 'Shanzz', 'Lukasmisota', 'Praise100', 'Dosa1968', 'Mahamrdt', 'Soddpfflkck', 'Kamran', 'Ugghhgv', 'songuuli', 'triyono12', 'eman84', 'Tsolmon', 'sheruzb', 'Hilarydan', 'gretelmary', 'Domalama', 'kabody', 'Xjxkxxkx', 'ali9595', 'Jkfkffk', 'Babak55', 'raju17', 'Diamondcare', 'Djiejffdv', 'Omotoba30', 'Richwayboss201', 'Richwayboss014', 'Charlotte245', 'Ismail27', 'Alamiige12', 'Dambrose', 'Haryorkiss1', 'Collins45', 'Awoke1', '01Tnr1112', 'Agufi07', 'Dalesdale', 'POKER99', 'Alexmar', 'Xwizdom', 'elvis20', 'Aldinkepa', 'Yusufma', 'DARDAR', 'Kevinsil', 'Arshad786', 'Sonyaaki', 'Akizuraa', 'Emilia', 'Miasanita', 'Karlesima', 'Melissaa', 'Shenazbay', 'Katsuya', 'Kakaadinda', 'Robifuji', 'Kaditaa', 'Alanjedinak', 'Kishaa', 'Donaagnes', 'AmarmUu', 'AndiPERMANA', 'Sirotsoli', 'Sofikalwa', 'Sofauyaina', 'Jinnapassara9', 'Limanoslo', 'DeaAnita', 'Sandra88', 'Buuuuuuuu', 'Armanjaya', 'Janeeeee', 'Kariarmada', 'Ulinbagas', 'Muhlisino', 'Deniramdaniii', 'Rianmasiah', 'aliusman', 'PiRaPerMana', 'Anwaryan', 'Sumaniaja', 'Rio9999', 'Sidiknur', 'Nikitrias', 'Nikamajdi', 'Streetgirl', 'Rakesh', 'Leonuha', 'Sarinurty', 'Muhamadpian', 'Salimrr', 'Rustamrina', 'JoniRr', 'Rikibaehaki', 'Seema99', 'JayaJamal', 'Firsayani', 'Wiwinwiwin', 'Antifuji', 'Kahfiafi', 'Jeeyyyy', 'Deriswawa', 'Adeadeade', 'Tiamiti', 'Mimisamimi', 'x1x1yasi', 'Karinaaa', 'Mangepong', 'Samirtaris', 'Reihanabi5i', 'Litayuswa', 'awialman', 'RatnaGalah', 'Simontanama', 'Sasasavana', 'Adesilia', 'Komarsudin', 'Pestilicia', 'Ajengg', 'Cikarasia', 'Jajang', 'Sricahya', 'Janujazi', 'Dikdiksali', 'Omenwida', 'Islankarim', 'Karinananda', 'Morganasali', 'Dedensariah', 'Mandramandra', 'Jenisan', 'Adotsuradot', 'Desiratna', 'Sahriniamoy', '02Tnr112', 'Mikelia77', 'Onuku55', 'Nurhusen', 'Gugungay', 'Agufi08', 'Priadii', 'Kuayadi', 'Beniarton', 'Herumaeda', 'Mortonaliu', 'Deliaaa', 'Kadirakbat', 'FIFIPOPI', 'Zidanpradi', 'Cacama', 'LIPdmACxbr', 'Jephthah001', 'Abbeylee', 'Kemisola', 'Lincoln', 'jefime', 'Reena0', 'Climbingmonkey', 'Climbin1', 'clmonkey01', 'Priyandi', 'Papalayemo12', 'Vicente35', 'tarantino767', 'Lisandra', 'Ponce61', 'Jahbless', 'Dimeji', 'Afolayan', 'uzokwe', 'Adewale058', 'ElGris', 'Agufi09', 'Agufi10', 'EmmyDraiz', 'asgar1322', 'Veronica2020', 'Bright583', 'imiboy', 'Pilot12', 'Dammy617', 'Tomisco', 'kayode', 'Omotoba111', '1MNWrmJTsiKNPC', 'Awelewa111', 'freecryptoearn', 'johnbtcmaker', 'Okanlawon', 'Habeeb785', 'Nymaaa', 'Shinee20', 'Pro1113', 'zila555', '1234ali89', 'Abbeytosweet', 'Delealao', 'Pogbaigando', 'Suman000', 'Cuwicute', 'Zainalabidii', 'Yahya17', 'tanka13', 'Funmilayo', 'goincom', 'Edwardjohn', 'Caridad', 'Saleem477', 'Akasamuda', 'Gan0524', 'Abbeylincoln', 'Wasilat', 'Tony2rich', 'Jegede', 'ekwunifechukwu', 'Prashu880', 'Junion', 'AdytGantenk', 'Shehum740', 'Aashish8822', 'Miguel20', 'Krkbtc', 'Krkbitpick', 'Mian123', 'tanyunya33', 'mahinak', 'Kotabit', 'Munachim', 'Johnsnow', 'OrnellaJ', 'mmerlo', 'Frostkid', 'Yujra1', 'santo008', 'Yasmai2706', 'YasmaniBarza', 'Yasman', 'Oluwatobi5525', 'Yasma96', 'masud2', 'Kuklasuka', 'Maires', 'CrashBandicoot', 'sonatap', 'Yasmanyahoo', '02climb', 'namastes', 'AngelUO', 'Molly1975', 'Chukz99', 'Soronzonbold', 'Alpesh', 'Kotabtc', 'Ritagodhani', 'Williamsmoke', 'Limber27', 'Promise230', 'Sasha992992', 'Anuragbhilwad', 'Prostotak', 'jasmin6', 'Emmybest', 'Soni99', 'yaghoubi1355', 'Arie2020', 'Dearta', 'Arta12', 'Echo26', 'Zeoohast', 'Tyopetricc', 'Darta03', 'Badutbenjol', 'Kuklovod', 'Melany', 'Deyjoh992', 'Krishnan', 'Nonamalam', 'Chevy1024', 'Ucoqboy', 'Heriyana', 'Adebayo719', 'Agunbiade', 'Hajandrainy', 'Kenneth12abc', 'devm93', 'Ferizeo', 'Ozeddidi', 'Alifilhan', 'Adsbadut', 'Israelminer', 'Altantuya', 'Wiser10', 'Tamasurya', 'Jonhreo9', 'Gbadebokunle', 'Jeronimo', 'bakarelaide', 'Fabunmi', 'Tundealao', 'BURHANUDIN', 'yashwabhatti29', 'Helmi1996', 'Renatave', 'Artastore', 'Dhindhin', 'Jesus07', 'Pukarbam', 'scimus', 'Skmohammod', 'Mariamn', 'Viniciusbar', 'Negroliver', 'Negrosam', 'Superkosmos', 'Badmus145', 'BCUBE2020', 'MrUY01', 'Susa15', 'oluaina', 'hunri2005', 'Tulum15', 'Beta16', 'Yesuraja', 'Maninder98161', 'muhammadhanzal', 'Bofesp', 'Praveengoud', 'aurimuxis', 'Snekec', 'Recycle', 'jimohhabib', 'lesalex1997', 'Amiolohun', 'Rhances80', 'Chris24', 'autowebnet', 'Justin777', 'Yusufer', 'Yaxano', 'ibrahim205', 'alexpin', 'Umair0314', 'Shivashiva', 'Rajatpandey', 'devisuhe', 'hanzwenz', 'heobaru', 'Mendee007', 'Umair031434', 'acilie', 'Lugaa007', 'Sabina890', 'hykamu', 'James3', 'Theboss1000vip', 'Foolish', 'Rashmi', 'elang158', 'kamug4644', 'ampaskamu', 'dimanakamu', 'ampask', 'Johnvillanah', 'AkohJunior', 'Jeremiah8991', 'pulsaidnet', 'Pasookota15', 'ahrapna', 'apgainao', 'Dasep72', 'mayberde', 'temanhibu', 'Dark100', 'Makindef', 'Syalim', 'jinabat', 'ayuse6', 'Miloxxx', 'Adedele', 'Bimpeade', 'Zolhon', 'Sheruzbek', 'onicakuku', 'PRABHUDEV', 'lusdehk', 'Ryosteven', 'Yogaganong', 'Anangjhon', 'tinevu', 'Mjay10', 'Wikjaka', 'Antroosawa', 'Sudarkaya', 'RAJLANSUNA', 'Zumulmil', 'Ajikasalman', 'Sasikichan', 'HadifadlaN', 'Gigikaliwa', 'Ridhomudho', 'Roilaknak', 'Resiookpik', 'Benconglasa', 'Sowekkila', 'Mbahbejoo', 'Siswansiswan', 'Petealaba', 'Cucupitil', 'Nurisadang', 'EduriadYY', 'Ageagesta', 'Badusantoi', 'dayiMAKAN', 'Nuhajar55', 'KONTOLgede', 'memekBAU', 'kalisumhuya', 'WahyuSuraya', 'Sakrilajam', 'TOYOTOYA', 'adihidayat', 'Nursyabango', 'Tonibasota', 'Arifgunaha', 'Ponijoobe', 'Faisgudang', 'Jonieneteng', 'Paladin', 'Cepicepott22', 'Sidikkurzawa', 'Ariowaa', 'Sansiaulet', 'Ojaksurojak', 'Girisugugu', 'Idrisbojok', 'Riochan', 'Reksadadang', 'Arianiiiiii', 'Indahaawin', 'Diniohdini', 'Dianamare', 'Ariniayahu', 'sitirahmidaAAA', 'Anggitagar', 'Faridakelain', 'Risma4u', 'Erossaa', 'Ervinacwwe', 'Anitasesi1', 'Sitiyuanbtc', 'Putrabuek', 'AriAmOng', 'Resacinunuk', 'Rikibagaju', 'Fahmitoke', 'Heriadnan', 'Nurmarhaman', 'Diansudarajat9', 'Wanwanketes', 'Harisculuk', 'Maramahchan', 'Rahmatramada', 'samir1980', 'Siskamayang', 'Ratihanul', 'Anisandera', 'Dahepradas', 'Rudianabobo', 'Ganjurhides', 'teloromana9999', 'Lalanatendi', 'Faharatali', 'Nikamalio', 'Elsupoli', 'Enungmarta', 'Nindiarahayu', 'Liakali', 'Rosisilaa', 'Astribata', 'Okiokioki', 'Alpelible', 'Asepaowo', 'Agumsukana', 'iislista', 'MeiHatane', 'LOADINGeRROR', 'DATABASEeRRor', 'Error404', 'Pasukan62', 'YangNuyulKayaA', 'Bulmangentot', 'Onlinebeast201', 'yohmaro', 'Timmy3', 'Soyin377', 'Waleomoba', 'Serg1988', 'Bimbooshin', 'petera', '999810423', 'jlorena', 'Dkstrong', 'mansurov2019', 'lisenok', 'Sherxfff', '122eueg3h', 'Qrcyubj', 'Sgaupyy', 'Dayatfatah', 'Otgontsetseg', 'Bendel', 'Eyitayo', 'Khadijahibrahi', 'lolo10', 'Bennyberry', 'jumbagas', 'Abgold124', 'fary12', 'Asphodel', 'Akramjon', 'belger', 'Jairo97', 'Demays', 'Wasiu57', 'Oluwaseyi98', 'Dyms1er', 'Adesh8', 'Ehrrrry', 'Shotefh', 'Sh3tfux', 'Hshtehej', 'Muchlis31', 'Dailyyss', 'Sh3rr8ru', 'Shyam2062', 'AdebanjoMichae', 'Jessygoud', 'Iamogs', 'Petroleum527', 'DaniAso26', 'Oluwashina', 'Bayustrom', 'Zordan', 'Geozex', 'Berlian', 'Gusgar', 'SOLDmxtVCL', 'hayyuk356', 'Bennex', 'Boyqiz', '329796', 'Didbek', 'kumbangsf', 'AlterMann', 'recepozkan', 'David789', 'Leminhquang', 'egyi74', 'Ngbede', 'Adepojuwale', 'Abdullah11', 'NuelAbi', 'Carla09', 'kimiya', 'Reallyg', 'Richmondugochu', 'Greedy', 'Briann', 'BI0TOXIN', 'EduardoLG', 'Mohamedkom7a', 'Ferdinant', 'Ilxombek', 'Nasir7575', 'Hefrontom344', 'Derrick67', 'Christoffer24', 'Ahmenok', 'javier0289', 'Wolfrenxome', 'isholaelijah7', 'isholaelijah10', 'Abdugaffor20', 'nambas', 'Musyoki', 'ardijenie', 'JohnIthagu', 'ChachaMenge', 'Descorche', 'centurion12', 'jleyva', 'Jperez2020', 'robleda', 'Bayandalai11', 'Harsik', 'Rachelita', 'heeyeueje9', 'heheuriir0', 'hehwueu9', 'terrence100', 'esuarezr', 'AtutiJunior', 'Baatar', 'Farheeneskhan', 'Farheenkhan', 'Jeqweaon', 'Vivianne830', 'flora254', 'Zian91', 'Zakopela', 'Kopela', 'yankvip', 'Abrantes', 'medarametla', 'Gangaanyam', 'noragami', 'Joeovanny19', 'Josephina', 'Tarpoungue', 'linarcoin', 'SauravSimp', 'Bathong', 'nelminer', 'Tuuzen', 'Znsjsbh', 'Nurilo', 'Iwan8585', 'NimraF', 'Sostenidob', 'Nishavbhujel', 'Destimoney', 'Abezzyog', 'Johnreystar09', 'ebaalai', 'Handrew', 'Adamikky', 'Drophhh', 'Odogwu', 'shivendr7', 'DanteTycoon254', 'shahmeer', 'umair12345', 'Yoelmm90', 'Laura9999', 'puujee', 'Collinsgreen', 'Ceezaa', 'mixail3458', 'zagoz1', 'yaiamashish', 'Geebel', 'Valerian111111', 'BuBuuuuuuu', 'Wealthwwg', 'cwonodi', 'Abraham2004', 'Bimpeade611', 'Atandaaliu', 'Tundea', 'Paulwalls', 'Joshillz', 'Gkgo9u9', 'Chcuog0', 'Cjcivio98', 'Zorig09', 'Cjcjci9', 'Fufu99hig', 'Donbrahay', 'calebvg', 'naimur', 'strike85', 'LurdOlamide', 'Msllppo', 'Monky07', 'Dotel12', 'Josh12', 'vidhya', 'Lydiahwaweru', 'gluck28', 'gilvansilva', 'Ebiijoe', 'Kellyjay', 'tankist', 'Baezkjose', 'Walter7780', 'kingabdul', 'anorok', 'Nallkmm', 'Raymark', 'Sharonkoko', 'Paskillo', 'Steepboy4ik', 'Danadam', 'adeoluwa7', 'sanchezmarbe73', 'Seenu34', 'Randall5', 'Edet90', 'mustehsan', 'Josman11', 'itsmehbenj', 'minty666', 'kingkong', 'H3ry77', 'Alcatraz2580', 'Sitimaroatulja', 'Kimmie', 'Senja1312', 'Kimmie20', 'Collow', 'Supandi', 'Snookkj', 'Kashifsumra20', 'gekabar', 'Jot4real', 'Alifia', 'Hina98', 'Tabasomnz', 'shadsumra', 'Brenfil', 'Charito', 'Stephenesquire', 'Artur16', 'yvessteve', 'Mostafasharifi', 'Manuela2015', 'Hectoriii', 'Akomolafe', 'Timzy1', 'Melodic', 'Khalid16', 'Wasilat18', 'Willy1997', 'Suliyah13', 'lawrenceadetom', 'Lianamay', 'Sulastri', 'Ashakemi', 'jdultra', 'Henry60', 'Lamekan34', 'Qwertyqwert', 'lalamove20', 'Oyinade', 'MazHuuu', 'Doveline', 'Vigneshwaran87', 'Rasheed25', 'Salgaldo1996', 'Bbello06', 'Khoeey', '15313409', 'sergei65', 'ulzii16', 'Ogbonu36', 'minerzoha', 'KalleshaS', 'Josejoe0795', 'Mickzy10', 'Arnoldxxx', 'Josesmash6941', 'javadsfv', 'Gozielaw', 'Danielosamudia', 'Ismaila', 'Jemesvi', 'Thian18', 'Yungwhezz', 'MegaNovelia29', 'Mbahsumo', 'Jayesh1988', 'favouredly', 'Anggi10', 'babar956', 'Brardokath', 'Wahyujabari', 'Bulloh', 'Success6633', 'Sana2000', 'Tegasamuel781', 'chin4567', 'james6787', 'Sane555', 'erkhemee', 'Bulgaa', 'kakcikferdhi', 'taro300', 'Seun123', 'jsnacksng123', 'babarick', 'judeit', 'castillo43', 'Nomans', 'Subaidi9', 'patrick2014', 'Nwolu22', '3N9UgrJYbtkRPZ', 'foird123', 'Godwinss', 'getech0110', 'esquire', 'TIGERSIVA', 'jannt544', 'kfkdjkded', 'gfdeseaesh', 'mnmfeew3', 'kjjfkjiuyyft', 'hvgnvf', 'jeank40', 'Carlina', 'hjnjbvgfvgvv', 'Rashmanista', 'ghghghm', 'Belauskas', 'Mwanikig41', 'Clement254', 'Irfan0332', 'dest845', 'Ale920622', 'Budi212', 'Dante101', 'Hguiroun', 'Rantarous', 'Emmyrex66', 'utoyo23828234', 'Inspired660', 'amjilt', 'pleasentflower', 'Josinthabliss', 'Yusra122', 'Muhammad619', 'Charles707', 'Baljinnyam', 'shinabe', 'Saikumar', 'asriani', 'Mubashar2', 'ha7867860', 'Trendee', 'suhnamhnja', 'Cahya13', 'PorTT321', 'yinusa04', 'Omidiran', 'dataaa', 'sanjaynisheal', 'Rajamtix', 'Byambajargal', 'Simonkaruya', 'Itikaveni', 'Taniyaelsa', 'Arfilame', 'Nuketroya', 'Kevilada', 'Akd8nareni', 'Aussiemeha', 'Ublakaya', 'Sitidarifah', 'Itanekido', 'Taromijejek', 'Nukemarayi', 'Ukasahminna', 'Kanujaa', 'Tarekhh', 'Ausfanera', 'Ubizakareen', 'S8maeima', 'Ityasasami', 'Tamirra', 'Uusmayaka', 'Aryantimisa', 'Rignania', 'Konohamary', 'Oowalegru', 'Olisbara', 'Lutakamasao', 'Tunsakmayama', 'Uonamaria', 'Resilsusuya', 'Edwinmakkia', 'Danalikra', 'NeesiasiseeN', 'Ellsakarafi', 'Nodirbek7', 'Lalaponu', 'Akifahsana', 'Nnanamir', 'Adireasalah', 'Lilysalty', 'Binsala', 'Amirrasena', 'Mabinosulton', 'Meihatayu', 'Lassikburma', 'Ahmeyra', 'Kamsiarehan', 'Ayamimi', 'Yenibalapia', 'Nasreenk', 'Namiyuaka', 'Aksanguyan', 'Kisamida', 'Iasmurika', 'Asmirayuky', 'Sellymanja', 'Elinoryca', 'Lesnavura', 'Estundafa', 'Nunikjasmin', 'Usmakido', 'Sunadera', 'Usmiladena', 'Unsahdafa', 'Nartodenis', 'Akinoymu', 'Kagesaruya', 'Ekkamarya', 'Ginnaka', 'Nurhsasan', 'Zasimii', 'Ubrikame', 'Bamsdarta', 'Mayasar', 'Asritatami', 'Koj8ma', 'Olikadanima', 'Austin199986', 'Lotismayan', 'Uosnax', 'Kurinaifafa', 'Usanadirewa', 'Amitrich', 'Munarkia', 'Uierasasaky', 'Memeysonoki', 'Ervinaelya', 'Rapitulu', 'Abangciel', 'Bonitahena', 'Ochihasasa', 'Fetylilia', 'Forsakenraya', 'Osynakare', 'Ricafaya', 'Cicibeby', 'Lycaann', 'Ikissamawa', 'Karl8ngoma', 'Asintropp', 'Siantyka', 'Kingzltana', 'Cepmuad', 'GanduGarcia', 'Fhr33z', 'beobaru', 'muhammadficki', 'liohant23', 'Micelliahus', 'Icaruzbara', 'Rosilaerik', 'Osofykenna', 'Soffymarnia', 'Oftykarena', 'Fitrikakano', 'Cobinnamila', 'Obafahune', 'Prenniamakao', 'Emirsataaran', 'Ummasaroka', 'Mawamunea', 'Asumakakary', 'Sukanaymirra', 'Ukanovjaja', 'Outmarenna', 'Tylopinom', 'Ookasarymela', 'Sambriomom', 'Ambillasary', 'Mbuniare', 'Bunakmahaya', 'Unkarabesi', 'Sulaimanyy', 'Eleminadara', 'Esaikanono', 'Sainaronna', 'Ereukamania', 'Esakaru', 'Safitadew', 'Aikomasumi', 'Ikadilaso', 'Kanirraelyas', 'Anniakupay', 'Bansiadodo', 'Anymsa', 'Nylatakami', 'Yakinnameta', 'Akmalrehann', 'Hasunnakani', 'Allenigarga', 'Makaniaa', 'Ilfahasy', 'Daniartasoli', 'Annisafi', 'Mandshir', 'Waweru344', 'Majid1332', 'Fametobi', 'Aryaputra', 'arianalamdarii', 'Davbazzy36', 'Simomade', 'catubaylorna', '17032001peter', 'hisyam873', 'a223532', 'Nipheme', 'emekzy10', 'cslmeow', 'hopacint', 'Quintero11', 'Rai1990', 'Emekos', 'Ogbonu12', 'adrian009', 'lildrake3692', 'Kachukwu', 'cheemazia195', 'Sammyyoung', 'Elfazaputra', 'khlnbb', 'khlnbbb', 'Taherbd88', 'Suvro88543', 'Francis97', 'webzzy', '3AFpwqpvgRUT4p', 'fathurrahman12', 'Hhabila', 'Oluwasegun2003', 'samudra06', 'sam0606', 'Putrisx', 'Adibaru', 'endyfreeway123', 'Hannia93', 'PongKer', 'Faith123', 'Sumaryanto56', 'Sugiono', 'Marshs40', 'MAINSAIL', 'Novarah', 'StanDivine', 'robi99', '1D4N5aGBGcrhbY', 'Xokaido', 'bannyYA', 'friend31', 'friend32', 'Maslam', 'RealJames', 'Nugraha77', 'Dgonz07', 'ShamzyMg', 'YvonneRenz', 'Papat1', 'Ivan11', 'Papitoo', 'Egwazedo', 'Adeleke', 'Montfortjohn', 'GraceChinonso', 'Smash254', 'indra001', 'GyanuKumar', 'Hana11', 'Slowstunter', 'Zaki5a', 'labat76', 'paseu76', 'gghg23', 'dfghgh8', 'gfhbhfjn', 'sdgfhhuhiu', 'jghdfgbm', 'cvuuig', 'jdmsmsmcnk', 'fxsafvhghgn', 'gdfsnmuuyt', 'kcskaaa', 'khuftercvvfzs', 'nsbckjsncjk', 'klllaann', 'jskskskskks', 'khgffdfgn', 'hhhftdrseaedhj', 'sususu1', 'Mizanul', 'hgxhhs123', 'jjaahhygt', 'kjdhcjxklq', 'akllssmmm', 'nnzzmmaa', 'hhaakkmm', 'iiaaookk', 'MAnunited123', 'namajqkaka', 'hjjajajakks', 'adfgafda', 'nnzzmmzz', 'Wilfred1950', 'Jaanblac', 'Tovisam', 'tokmakci', 'Ninobrown', 'meos09', 'Dharmarajrana', 'nestor888', 'Gogak12', 'Giveitall', 'Harry77', 'Jaasiel', 'iskandar732', 'Maria1111', 'Asih11', 'oiuygfdsdh', 'hshghgyazz', 'Mahsuye', 'nzcbhobvcs', 'hdhcudhhdbu', 'nbcxawwe', 'jdsnmcnbvcvc', 'dgdgdhh', 'WendyJacks01', 'jkjkhghg', 'koopel', 'jaironegocio1', 'KiriTROLL', 'yosvaniasoto', 'sotoyosvania', 'darknegocios64', 'Billionaire201', 'Indhuk', 'Dejavu', 'Lilenapb', 'alvinmicheal15', 'hdfjsdhjkkls', 'mmaakkaazzxx', 'jjdhvjhufhue', 'mnsjchujschus', 'jhdcgsdh', 'nanajsjsdhd', 'Mauytaqq', 'jdjkdjkdsk', 'jjiiiikkaa', 'kakakkalol', 'zkzkzloi', 'koiuytsdf', 'iiuuiiuuaa', 'ggyyttrsrrs', 'dhgvgfgaasw', 'oiwwsdf', 'yyatttattftggh', 'mauiaghxg', 'oahjsbbcc', 'kaswed', 'mamamama', 'dhfbhsdffdd', 'kkaallmm', 'ooqqwess', 'ajjhhddgg', 'Wiwiwi', 'ngghgujj', 'kiyfddgvgt', 'iihgfkffc', 'Merceditas', 'iakjssds', 'nhyyajdsjjchd', 'kkalloicc', 'hauytrgdvhj', 'dtsiioall', 'youiloiuy', 'pooaall', 'uqqaassd', 'weratyh', 'fgxfcgshdjgv', 'werarar', 'iuqqwaffhhc', 'aasskkiov', 'opaaredbb', 'oaoaoajkdds', 'yuaoaiaa', 'aakkosopps', 'oippddhhg', 'djunglefreeman', 'clockwiseman42', 'pnyutu254', 'patnyutu254', 'waliedhegazy', 'Eddy02', 'Hefrontom34', 'Edukopela254', 'Peter123', 'Samudra7', 'uisuusija', 'juailopqa', 'Manuniuuaax', 'Najjjagay', 'kjiiaaiji', 'kioiaajbhhs', 'uioiuajklo', 'hauiuytr', 'Uyattrfvj', 'uiaajjffdkdk', 'uyolomiuytfbs', 'Treaggcb', 'soianvjjej', 'Eratytfg', 'kjjaiiajfhvhhd', 'okashdfre', 'Asdfgzhzjj', 'Youandqwe', 'wyuuayyag', 'aoiuybcx', 'uiaythhchsh', 'ughgtdeasjj', 'Haoikutrewqa', 'Yomisars', 'Manunited123kj', 'iugvcfdsrtghvj', 'hebakader', 'Susan1994', 'Samilee1', 'GraceN', 'ulyaa6278', 'sondieukhac', 'Donkhan99', 'Tegarr', 'Mosy0121', 'mana2pon', 'FarisHidayat', 'Black123', 'gilberto2020', 'Cryptoworld', 'Hamapadi', 'Hamababa', 'kongciwenz08', 'hhaki9983', 'Theus94', 'Ranaamar', 'hyqiu5830', 'hykyu687', 'veobaru', 'Thisisme3', 'Ibrahim3738', 'sglassma123', 'Andi88', 'Munkhaldar', 'Diamondwiz', 'johnsda', 'Tommyjon', 'Sheruzb111', 'Sheruzb1111', 'Adewale005', 'Chikauzor286', 'Deimer', 'sdfc1523', 'Susifitri', 'Susan19', 'Waweru6', 'MrDami', 'gleibys', 'yulian123', 'hitme1629', 'Rauf78', 'Timmy25', 'Research', 'Amjhbgyt', 'hftdtdtctytyj', 'hhghucxvc', 'hfaychyufkwg', 'bbbbmmkiiii', 'Manunited123as', 'Aususubvvvv', 'JJHKNmnana', 'wehjujjhggghjg', 'GHGVCxzaqwe', 'Bahabalkh', 'Jghuhiuytgfr', 'JKIJHHbvcxz', 'AWQPOLKJHgh', 'qwqwertuopo', 'JhujJhhksksv', 'cvcvbvzzz', 'NMbvtrfgyd', 'beforeGod', 'nmzmzxz', 'mzmznnbcc', 'mynameqwertyui', 'yuiaiaiah', 'sdfghjklqwerty', 'olopawqsedcx', 'Antomama', 'gt1991', 'Ayeaye', 'samudraaa', 'Mode9noni', 'logris', 'Skfwesh', 'btcman64', 'aqzwsxedc', 'emamakijjh', 'doakuyfvc', 'batskkhgbfd', 'axzscdftre', 'qazaqwsxedcrfv', 'qwasvvcbcvcx', 'cfcxzasnhu', 'qwaxbjkbvffgty', 'Elijah20', 'qazxvbtgfddsss', 'qawsedrccxx', 'zaqbghvc', 'zesajnbgcfff', 'qazyhhcfvkk', 'Matze230687', '6hjkcazasx', 'qazxswedvggh', 'Godzealla', 'Pepeaguilar25', 'djhitz', 'rijal90', 'Owuowo', 'phemsammy', 'ertyubvcmmm', 'vfdsazxzxzx', 'rickyakbar097', 'Fiki89', 'Henrycruz', 'Collboy', 'boaz254', 'Jeremiahezeji', 'bartus11', 'Johnnyhenry', 'JNas02', 'samuls', 'Adamskyrain', 'Muawuya', 'Zoloo1206', 'Kaps86', 'seagalcross', 'NadiusaBTCCOM', 'platinum575', 'cdcddgod', 'bvcxzbbbbbv', 'jhjhjhbbvvg', 'Dgonzpoke', 'Mahesh55', 'KENOMEGA', 'Rodavilez', 'ketanreply', 'Pedrito', 'Yakubu', 'azizullah12', 'masariiuyt', 'somenaakka', 'enywheriii', 'merylmpower', 'Upindra222', 'Enkay92', 'Tybentz20', 'Kiritojas', 'tholfreddy', 'Waripamoere', 'Ibarra', 'Tamunoimama', 'babaidayy', 'talhaumair', 'Joseflavio', 'freaknux', 'Tirret', 'mklk112', 'bvnbv12', 'zxzxc12', 'Diwura', 'iwaeka23', 'livinusprogres', 'jvseph', 'Obiechina', 'Shovakanta', 'Gabry79', 'Pej2209', 'nbnbvbvc', 'Onjanhr', 'gugun88', 'Arfandi', 'MichaelOduguwa', 'Jitupatel38', 'Rajeshwari', 'ZeroPookie', 'Boluzy', 'Andalanno1', 'jeshwin', 'Sheruzb123', 'Nurasanni', 'vladimir12', 'samudramrohiim', 'man722', 'samudrarohiimy', 'Sam411', 'Switenana', 'budhi20', 'Micholu', 'Slavaneo', 'Uwem22', 'raeesrahi14', 'Obideyit', 'Phabian1', 'samudrarohiimo', 'rohiim2outlook', 'rohiim1outlook', 'Fadadizzy', 'Sadik1234', 'Samudrarohiim1', 'samudrarohiima', 'rohiimsamudraa', 'xeq2nk', 'ender1907', 'Bela10000BTC', 'temuge', 'Tsoomoo96', 'kamalyaseen', 'Sheruzb1234', 'man725', 'Musty22', 'sabbirchy', 'Israel12345', 'Akaansh', 'Fajarannur', 'Manaration', 'youngwolf1', 'Nosianna', 'Samudrarohiim', 'Sammmm59', 'Srohiim', 'Sherzb1234', 'Sheuzb1', 'Suwandijhoni', 'serraerbay', 'Ilya186', 'Arameshsharifi', 'Junapandey', 'Barantara', 'Juna2034', 'Sjggkh', 'Qwerrr', 'Rohiimsamudra', 'samrohiim', 'napoleon1986', 'Gabo123', 'RoMann', 'samodrorohiim', 'mahmudnasir', 'rohiimsam', 'rohiimsamyahoo', 'IHASU455', 'man738', 'Sanchirr', 'Lolagina', 'Ilyas121472', 'Jewelose', 'MiladTS', 'Aguofia2nd', 'JOHNJAMIU1995', 'maradu', 'Abdulrazzaq39', 'Surakxya', 'sadaura254', 'Sirbee', 'Muffin9', 'JimmyJr', 'Azizbek2004062', 'Shukrullo', 'Mambaa', 'Jean3216', 'sammrohiimgmai', 'rohimsammyahoo', 'sammrohiimyaho', 'Lofiato', 'rohiimsaol', 'sammsamudrayah', 'Agung20', 'Sammsamudraaol', 'kuljude', 'titodinero', 'vxsdazewq', 'rollabjcnxa', 'GanarDineroo', 'asedrigig', 'drdrewqghlkj', 'becaojdn', 'akokokaaa', 'conconddds', 'ijustaaaa', 'vccclllhugy', 'hugybnbmnb', 'jhgfdasdfghjk', 'bestyuiii', 'otitujhgfx', 'portescdaf', 'wdcgfnajuiu', 'dalaibayar911', 'ashabbvbmmk', 'fireasvbvbnc', 'SoniaBTCmisa', 'fucjjkkta', 'neverlesshbh', 'somebodyiui', 'Tulotollo34', 'critakanm', 'overkjhgf', 'olauands', 'edonspojggc', 'iloveyouvvj', 'nonoskikk', 'ehaehazsz', 'mamauoiyt', 'marrygilo', 'covictmusicc', 'chopmymoney', 'downroof', 'anythingdo', 'carrygoolkm', 'amplayer', 'matternbcxgg', 'fridayoiuy', 'condiuyuy', 'familyooo', 'thanksddd', 'tellyuo', 'nobelie', 'xwrlde', 'wahaladey', 'cartaggfh', 'letitshine', 'Arefeelme', 'anyhyuii', 'loveyouhhbb', 'giveitto', 'psertvvbv', 'isaacinfan', 'uhgvdwac', 'imkoyttv', 'jkccxvzzzl', 'jzlkopiuyt', 'qwbbnnvl', 'frdsyioomn', 'patty1302', 'kilalad', 'oiuytrfgcv', 'nbhggddhjjsaaa', 'nowkiwlo', 'fgxxzvnnkoigf', 'hkmncxzdsasedr', 'gguhfytdhsgsyd', 'rohiimsyahoo', 'srohiimyahoo', 'rohiimsamaol', 'Bek0202', 'samrohiimaol', 'Bekzodrek', 'Sherbek002', 'RosaColon12', 'Charisma', 'Naimku', 'utikaaa', 'poesposes', 'gcfsdrfxndj', 'Loksjsjaaqa', 'hamamaz', 'conconmama', 'axctgbyhn', 'imtgb12345', 'jhgresaqxc', '9933weqasxz', 'mazewqkl', 'fcgvtredsx', 'rk0058747', 'milyaderlee31', 'regardlee2', 'ricardroy3', 'samrohiimyaho', 'samrohiim50aol', 'srohiimyah', 'samudrohiimaol', 'samudrohiimyah', 'samud7rohiimao', 'Manuijhyhgt', 'opoiunxmz', 'timetjay', 'asamalwy', 'nowuliedo', 'soppyuiu', 'oneforbhs', 'runrunii', 'putapoikj', 'foajksbxnz', 'supermanuis', 'babagodre', 'moremusicva', 'olupauyt', 'waysdaf', 'theisaba', 'kilosdiua', 'showmegg', 'gatyounhd', 'rouyasderf', 'permitmeyou', 'sayloversta', 'betcaiuus', 'shakuss', 'repetaa', 'ashawowa', 'yeyeooa', 'Aikutdcsv', 'owahyeh', 'piapiaa', 'aecvhiombv', 'handfcsw', 'pupumkjh', 'golryubn', 'Mtfredswaq', 'dadanbvcxz', 'housefaith', 'Jahongir661', 'Elisha1', 'Nkamachikezie', 'Tumee88', 'indosatlyagmai', 'Lilian', 'John7101', 'fathm773', 'satrianiree', 'SerCha', 'Wafa18', 'Lyaaindodat', 'Heroesboy67', 'Nakamotokun', 'hogmail', 'Officers', 'Suresh1', 'samrohiim6yaho', 'samrohiim06614', 'samdotrohiimao', 'samdotrohiimya', 'everaldo97', 'rohiimsamudaol', 'rohiim7samudra', 'steelafriend', 'Levon200507', 'LonL05', 'Line2005', 'Dianafuenmayor', 'xdouglasx', 'DoDoLuLu', 'jamespremacio', 'Diwe05', 'Izorte99', 'Buchiboy', 'Ungwayya', 'Mawlay', 'ELELEGIDO22', 'hasballah', 'TaraSeit', 'Isaac76', 'ArdiHidayat', 'Rose24', 'Maricela', 'Sushmaa', 'Zzzolzaya', 'CreZiMeN', 'Entrepre', 'KARTEL55', 'Fawaz2020', 'Popsej', '210819', 'ADxgb68', 'medomido11883', 'Toivrdd', 'Wisnu7', 'Naya46', 'Hariburuk4', 'Oskido', 'adel66', 'Ahsen76', 'Fati9669', 'bcoinhu9', 'TahirMehmood', 'bcoin531', 'emrys195', 'Ghsghs6810', 'rohiimsamudyah', 'samud7rohiimya', 'rohiim7samudao', 'samud7raol', 'sariulyaaol', 'sariulya61yaho', 'daniibarreno', 'iliya96', 'ghasemmahmood', 'Aslbek', 'fanitp', 'steparutka', 'defalang', 'iratorova', 'antohasab', 'aleientab', 'valyasamka', 'Bashirmilan651', 'Terrygoodman', 'Sanaz65', 'Salmanmalhi0', 'LoaDinG1', 'iranmobaraki', 'Tohid63', 'sari0ulyaaol', 'sari0ulyayahoo', 'Abdulsamad09', 'samudra0rohiim', 'rohiim0samudra', 'kioko344', 'sariulyaayahoo', 'apostolkir', 'kiryasan', 'dgdgcjjjjj', 'olegsadam', 'sahkaking', 'maksimaara', 'vbnvnbffff', 'Agaaev', 'Statik', 'FaucetOlya', 'AllaKorobka', 'TanyaTka4', 'fghfghfh', 'dsgfdgdfcvbc', 'Nasrun2001', 'jehoahaz344', 'Naeeel', 'santoshchy', 'IgorekKolpak', 'SashkaPoleno', 'VikaBlonda', 'MaksKot', 'DimaStone', 'OvodKolya', 'OlyaGlib', 'Stasik2345', 'ViolkaSamka', 'arrow80', 'kononcukigor', 'tanyunya143', 'Tanyunya123tq', 'Taraskol5', 'Bash434333', 'Golusadert44', 'Toronka745', 'Kirtavan34', 'Salvadordali34', 'Poloztema77', 'Fikafuka', 'dropbox9', 'Ciaseed', 'Lowrino', 'Kokakola', 'Ufuoma', 'ZMEY76', 'mimatimmy', 'Kedovod55', 'Panamera6633', 'Katyhavuho333', 'Maksimpryt664', 'SorokerRysya', 'lenkasparta', 'Krivosapka6363', 'Olgamolga22', 'vladikpes64', 'irishkamocuk', 'Zaya99', 'Bishesh415', 'Mario2', 'HamiDrezaa', 'Elycolque', 'Kent17', 'Bitebo321', 'Ulalala', 'bcoin0909', 'Hbgfjng', 'KINGLAW', 'Thedjavhu', 'lalunan', 'SubashYT2', 'Srilavanya', 'Yasinjan4600', 'kgaledarzadeh', 'Junior202', 'Slimboi911', 'MellyDon', 'Makanan', 'Kezchriskris', 'Boboban', 'jorgeiber', 'Zuhi1995', 'Ogonwa', 'Mamudulala', 'hs860240339', 'argaabc8', 'Cyriaque94', 'Kalista', 'Kokocici', 'Samson22', 'lexzus11', 'Petergodwin', 'ramin2sm', 'udf44354', 'lexzus0622', 'samrohiim06yah', 'samrohiim06aol', 'Oceanpoint', 's7rohiimyahoo', 'rohiim7syahoo', 'rohiim7saol', 'Syaprilasis', 'Jetoluwa', 'irfanrockyy', 'haditayebifar', 'Mikegever', 'HRaditya', 'FarelFR', 'Sadrekanter', 'samrohiimoutlo', 'samrohiim6outl', 'samrohiim1out', 'Battuwshin', 'Gorbunov233', 'Paleyka733', 'Karapyzik773', 'Tulgaa8905', 'Banana88373ban', 'radg12', 'cquesadae', 'Hadiman20', 'Mayauskee', 'samrohiim2outl', 'rohiim0syahoo', 'rohiim7samyaho', 'arif82', 'Veerah', 'albertify', 'fabregasjuninh', 'Chikitodaddy', 'Bannu5161', 'srohiim1outlok', 'srohiim5outlok', 'srohiimoutlook', 'srohiim2outlok', 'srohiim3outlok', 'saharsaghi', 'Grahamagic', 'PrinceSamTee', 'Oluwasegun', 'srohiim1yahoo', 'Kongciwenz', 'Marcelan', 'Zaya123', 'Fabled1', 'Leeyu5', 'srohim4outlook', 'bahadir', 'samrohiim1yaho', 'srohiim1aol', 'Mob123', 'maidala', 'sali2020', 'Pbl2020', 'Risch41mut', 'Deadmanwalking', 'Otgontogos', 'amarmilan6802', 'Raja1122', 'clauisaac', 'Myagmarsuren', 'srohiim8outlok', 'srohiim9outlok', 'srohiim10outlk', 'srohiim3aol', 'srohiim4aol', 'Atul1987', 'Knowledgeable', 'Kamlesh1991', 'naraa0310', 'Martisska', 'Irenmasamia', 'Cecilina', 'Kasumihanoi', 'Rannymuyai', 'Oyukotarae', 'Osmonkaka', 'Fifiteham', 'Caliafa', 'Bryanchiga', 'Andinimisa', 'Featuka', 'Rendahilim', 'Ersamayami', 'Maldaia', 'Indriatik', 'Uhainasarah', 'Mamahiasuru', 'Marelaknui', 'Aaunaxx', 'Sushilrai', 'SAZIZAulum', 'Temuulen', 'Kriatianyui', 'Ouravinyl', 'Tamiyamomon', 'L9nsingkara', 'Ominikate', 'Kakawasila', 'Ohaiopapam', 'Samyangkamui', 'Feriyantohid3', 'Adessalala', 'Mayakanuiy', 'Bibiexhi', 'Utaraselatan', 'Nehanmusai', 'Gagandada', 'Kaamirilopa', 'srohiim3yahoo', 'Asindasaya', 'Nutyuikasa', 'Sajaradarah', 'Uusrarate', 'Ukicafaren', 'Nananinni', 'Silzimamuan', 'Ezuikabasa', 'Lastriamuya', 'Vick94', 'Tsogtb13', 'Shamasbilal', 'eddieerc', 'Aqwe9898', 'Mosco90', 'may1986', 'mooncoin33', 'srohiim5yahoo', 'srohiim4yahoo', 'pervillanuevad', 'purevjavbayars', 'Temuulen0730', 'Dannypst', '800530', 'Ochgerel', 'Calta247', 'srohiim11outlk', 'srohiim17aol', 'srohiim18aol', 'UUGANBAYR', 'Anna1208', 'hony123', 'tormandakh', 'Benoyubu', 'Vivien', 'Cjay5646', 'Oleg5388', 'Tileuck', 'Aurelgerin', 'osval2', 'gigigol', 'srohiim13outlo', 'srohiim14outlo', 'srohiim15outlo', 'Enkhtur', 'AmirAkhter', 'anett51', 'ronaldi', 'Nmlooo', 'Happiness', 'solid22', 'Mijimaka', 'Ittasrya', 'Cheerypuput', 'Sazaraaa', 'Sellamarca', 'Ossasaha', 'Felitayanna', 'Taarandahsa', 'Carryussa', 'Oselotbaha', 'Barrasudah', 'Pankaj191085', 'Aksandro', 'Nikita1991', 'Putrisara', 'Esteshela', 'Makkiasollo', 'Iahtarmili', 'Udanayate', 'Udehoj', 'Maxwell2', 'ganhuleg', 'Hishgee12314', 'Sasashi', 'Nishar', 'almaguer', 'Taradd', 'Arabmoni', 'aidilirsyada', 'aftab916', 'Masnahda', 'Mirracahayu', 'Arafahkuli', 'Sasukijaju', 'Ugsesaturr', 'Katrinalala', 'Odemiwiyui', 'Usengrawa', 'Tirtaella', 'Ladiesamaya', 'Popolkupa', 'Asewabuya', 'Sazaraewwa', 'Kikiwerra', 'Orraymalu', 'Karenakamui', 'Bilguun', 'trident', 'Tempest', 'ststst111', 'Rotons', 'navillalee', 'jackdennil', 'leoranger38', 'qiyunkeer', 'Arameshtara', 'SHAYEM45', 'Mooyoo', 'maydarani', 'joks555', 'Bilegee', 'Ridmacool', 'srohiim16outlo', 'srohiim17outlo', 'srohiim8aol', 'srohiim7aol', 'srohiim7yahoo', 'Chichijesus', 'srohiim9aol', 'Geespook', 'Chimeg', 'Yosedani', 'Menma23', 'Arielvh', 'ajmg09', 'aifosha', 'Umid1991', 'Spoila', 'Galbayar', 'Sosorburam', 'Garpastum', 'flooray', 'Zorgery', 'Debyrise', 'Sunday002', 'hantonia', 'Dorcie', 'srohiim11yaho', 'srohiim12aol', 'vdkvillanueva', 'srohiim20outl', 'srohiim21outl', 'srohiim10yahoo', 'srohiim11aol', 'Radius', 'harunsefa11', 'desktroyer', 'moulay1', 'Stickersambila', 'Hanzhanz410', 'Omarzh', 'hamid62', 'Surajpulami', 'juliolg', 'GOLDYJMQ', 'Thokdavid', 'Javhaa', 'yordin24', 'zubairsumra', 'haidersial33', 'Ariusthok', 'Suwarni123', 'ahmadhamat59', 'kasihtau130', 'sakihaka47', 'roxastm', 'Candrabol', 'zenochan', 'chanzeno', 'srohiim22outl', 'srohiim23outl', 'srohiim8yahoo', 'srohiim2aol', 'DiceHustler', 'Chizzy202046', 'Ajap789', 'Khuvitogoldor', 'Dffreeman', 'Queenmarvey', 'ragiltandon', 'kusumaland', 'RepeatXx', 'Anir01', 'yaser91', 'SHOBHAJMQ', 'Robertobb77', 'Wenikude', 'Lkhagvajav', 'Nyamsuld', 'huzaifachudary', 'jawhaa2000', 'Mellisadams062', 'zal1359', 'Budo123', 'qiyuntom', 'Ari789', 'Cinta789', 'zaara201', 'sarah999', 'isla2943583', 'GOMERO5866', 'fjwytr2346', 'COLLO45', 'Damola123', 'Frad82', 'Supernoble', 'Agbaje011', 'Agbaje111', 'Agbaje11', 'Agbaje01', 'Agbaje001', 'Agbaje0', 'Agbaje000', 'Agbaje222', 'Agbaje11111', 'Lovejess', 'Agbaje22', 'Happiness0414', 'Sinta456', 'Kadi123', 'Muklis789', 'Bondan98', 'rezaaras', 'alnopeni', 'Cepedacenteno', 'NARENDERJMQ', 'Debby011', 'rasool63', 'Jentinoh14', 'kurniawan71', 'Ayomide111', 'Stillas', 'Biy111', 'Nana1100', 'Tegshee8899', 'Btc001', 'Btc002', 'Btc003', 'Btc004', 'Btc005', 'Tugsuu', 'kimanh10', 'Jehoshua', 'Saranapeka33', 'yuniaputri', 'Bitcoin99', 'Bitcoin0000', 'Ichyan59', 'Btc09999999999', 'Jahjay05', 'diyako7656', 'Agus789', 'Bitcoin888', 'Ani1234', 'Juniarvid789', 'Alireza73', 'Alimilan65', 'Aslam916', 'Ghffhgg', 'Naser1988', 'GHAHREMANPRM', 'Thomas10', 'Marribel', 'Naseremrah', 'Erka4400', 'Cryptogts', 'ehsan5205', 'Btc4444444', 'Btcgang011', 'Sammy2', 'tahir2418', 'BTC000000', 'Btc00111', 'Btc888888', 'Btcgang', 'Btcgang1', 'Btcgang2', 'Gabbisergio', 'Yossefer', 'Lulu29', '29292929', '9012345', 'Adeyemi123', 'Handika234', 'Fatima27', 'Ivan23', 'lydiana917', 'Taiwo0000', 'Michguns', 'ankol68', 'juan2025', 'ELGRINGO24', 'Drey0998', 'Dreymoney', 'cendana', 'Enkushi', 'BlessNwoye1', 'Narxarchive01', 'Ihave1btc', 'uncledrew', 'bungarespati', 'Faheemgul', 'bmining025', 'javkhaa', 'kevin0243', 'mandaniaina', 'Kinqdavid', 'Bminin030', 'bmining031', 'Bmining032', 'Bmin8ng033', 'Bmining111', 'Luiznocrato', 'mrregg', 'termo1', 'NARANTSETSEG', 'sky4444', 'SYAZAn', 'Bahar04', 'Mercy1', 'Buffypro', 'Madhan4848', 'Hannahia', 'TahirNadeem', 'Olamide111', 'RizkiFahlevi', 'emiejomo77', 'Joezer', 'elyger', 'umairsumra555', 'Bmining222', 'Bmining223', 'Bmining224', 'Ajedrio', 'Chy1010', 'Suwarna', 'Ednovison', 'Mostafa1981', 'Mughal7086', 'haidersial34', 'Ferorich', 'Stephen22', 'Josemichel75', 'yordanhf', 'Gajenry', 'Sanwar2186', 'Bujangpopeye', 'Seladiv', 'sensey05', 'Narxarchive04', 'sagarsunar049', 'Sagar1sunar', 'Buboloqi', 'RJonathan', 'Temex1933', 'anakbabah', 'Elvis24', 'Noorhadi', 'falling', 'Elbeg1999', 'Elbeg19990817', 'Drmining1', 'Brminig1', 'Drmining2', 'Agum09', 'Azhar993', 'Manoj1982', 'Ozubide', 'Omeiza101', 'SPACO1', 'vianlf', 'Tyty77', 'hayotbek5314', 'Safi26', 'Drmining3', 'Drmining4', 'tincola8888', 'babijahanam88', 'gabygabg', 'lajakajak88', 'bongsano8888', 'jaikati88', 'zar123', 'saberamrah', 'sajad1986', 'Parsa91', 'Drmining5', 'Vinzha', 'Andi12', 'Damnotti', 'Basbayar', 'Shakeel206570', 'Drminig6', 'tulga5', 'Billy0115', 'dimasikalex', 'Andiks12', 'Drmining7', 'Drmining8', 'Drmining9', 'Drmining10', 'tHekiNg96', 'Babnikjon', 'ParakRafft', 'Afftparakr', 'Ngozinancyobun', 'RaKrafftpa', 'Muclis', 'KraParafft', 'FTparaKraf', 'U07st1028', 'aqa19918', 'Arameshsharif', 'Kazempuyan', 'Javadsharifi', 'Zeeshsn', 'Kamala00', 'zubairkhan65', 'Monkhbat', 'Solongo', 'lablab', 'Tedyprastyo', 'gilangarsena', 'MilanKhanal', 'Richad95', 'sunnyp20', 'talhamuhammad2', 'OsmayV', 'alexei8812', 'gerlee99999', 'jos2391954', 'Tabish1741', 'enkhtsetseg', 'Batsaihan', 'Michaelkichson', 'Anasseh', 'JsPoker7', 'Naserrahfam', 'ochtin', 'hbaluazi', 'Babysisi', 'MSholah', 'MuhamadYusup', 'abdullah01', 'joehen845', 'Nasir2654', 'Nekochan1700', 'mojtaba1966', 'lablab45', 'Rizaldiprayoga', 'AfaqHussain', 'Badoo070', 'Omowunmieyinju', 'Trum95', 'Haydee007', 'Handika990', 'santi0913', 'DikaJo', 'Leogabriel', 'ctrvan2', 'antt31056', 'niton1021', 'risk33283', 'tikka498', 'Tuguldur0706', 'nurre7232', 'lorr94091', 'AkhterAmir', 'Chibabechuks', 'gend35423', 'ronn9561', 'dol08196', 'Tasin2655', 'nna159677', 'aluc14135', 'bne977996', 'byruby451', 'gord77327', 'sonj06260', 'nata03192', 'freddyjz', 'aldou677', 'AleWin', 'mya833197', 'Antoni79', 'Obongamami', 'olakehinde3073', 'Klaimo', 'mert123', 'Gjhghh', 'Ikrush', 'loongloke', 'loong2008', 'Loong2018', 'paratrooper', 'zulfikurniawan', 'Papolight', 'Seregagggjv', 'Vdkdbdjdb', 'ironsantos', 'mavx011', 'SYED3805', 'Ryansatria', 'Babadeby', 'Marjorie10', 'physicistaik', 'Rosali21', 'haseebsalam', 'Glinnn', 'freddowise', 'qiyunsoft', 'CesarA', 'Bilguun999', 'Mohamad56', 'Dette1', 'samudrarohiim4', 'iammatexzy', 'Ibadshah855', 'Rosa13', 'Ripanpanjoel', 'Tsegmee', 'Muqadas', 'Jargaa', 'turmunh1993', 'Buyan77', 'apaya1', 'GhulamRasool', 'Sodikin95', 'Tungaa', 'Oyeleke', 'itgel0526', 'Sarangua', 'OkeyHope', 'ampuedus', 'vugarH8', 'Ernestken', 'Tochukwu', 'uyhanaa', 'Victoromc140', 'natwidodo', 'Festusability', 'Hesamhesami', 'Arameshnazanin', 'Undrakh', 'Sunka1970', 'Joseph006', 'lucasandria', 'Hamidin', 'sohail724', 'Anar77', 'detzkie95', 'frank87', 'Bayaraa', 'Kdwea247', 'donalbein', 'tere59', 'Amirhedayat', 'Oyunbaatar', 'Almarojalmaroj', 'tuwshuu', 'EvyAli', 'Yudelalvarez', 'mohrofiq', 'Azeezhar', 'enheeee', 'irfan4499', 'Galindew', 'mehdib', 'Shafisk5', 'banoy95', 'jesa05', 'marlon05', 'ganaada112', 'janet05', 'hamzabscs', 'Tavakoly58', 'Dedenau23', 'Castillo20', 'Naheun12', 'Temmytope9242', 'Meekness', 'Sor339', 'Emmaria', 'MahdiM', '0911955', 'allysayu', 'monkherdene', 'ibrar123', 'Enkhsolongo', 'cryptoborn', 'rianmanja', 'Frekylove', 'bscshamza', 'GunjaVishkarma', 'sinacj', 'hassanalimahmo', 'Blagosti', 'Guess01', 'josemgp91', 'Tasin26544', 'Ahmadjahan', 'Mahanlovelove2', 'MakiLaki', 'ramadevi', 'Gideon12', 'Markwww3', 'Umar7861', 'TimmyIce', 'Anaskhan5', 'jmonterof', 'alexangar6', 'Uzbekvsg', 'Princecob2001', 'Srecko', 'hmahmed1890', 'Ozlems', 'sandyprince21', 'ramilolouie', 'rogeroramilo', 'gelyna', 'Ali1354', 'Bshaish', 'opaalexander', 'SudirmanCandra', 'johnsmith12', 'Rukayat676', 'mpmajo', 'Asmiramir', 'Saiber', 'hanick', 'mfadli', 'MUNKHUUGG', 'adri18', 'Boos1234', 'zlong6980', 'Kannie', 'Anthony150', 'YERRI0105', 'Ankit55', 'Iveelujin', 'faramrzian', 'Batsukh', 'Waqas916', 'Deboungoma', 'Nadeemtahir', 'Emrisking', 'tahir910', 'riantam4', 'Babulu2224', 'Tahir9100', 'awaisqerni', 'Edesunday', 'rakha12', 'Ranjan2223', 'Tikechan2224', 'Hemanta2221', 'Manish2007', 'Phakira093', 'Suren807', 'fastriki', 'a1r234', 'Prinzechibuzor', 'Tanemduid17', 'starlikop', 'dreesign', 'karuikjang', 'NITIN2018', 'SARANTSOGT', 'raghab2224', 'Biju0093', 'Sumitra234', 'ashoka205', 'Yusanabidj7', 'mamate99', 'Amrahdasspark', 'Ejukwa', 'gamangbana', 'aurelio346', 'hassan5237', 'Azra916', 'Eshal916', 'odonkhuu', 'Eshaal916', 'Denno123', 'Aleks777', 'magodainformat', 'Erikafebri', 'Lohnytbd', 'Basude1520', 'ullaba222', 'Abhisek229', 'Narendra044', 'YASIRAHMED', 'Utam0085', 'Amyloveth', 'Hammadali1', 'Ali916', '121629', 'SammyD', 'CCRNGO', 'dsoiwu', 'Manzoor851', 'Arfamanzoor', 'Adewale1', 'Milu2530', 'Bulu2224', 'Jassiel0121', 'Khalia2200', 'Raghumani', 'Ramukamal', 'umairkhan1937', 'alisadikin', 'Jawadch', 'Edaroma', 'nisuery', 'CristianCrypto', 'Elindigo', 'kamaukhi', 'Ramumunu', 'Qkrahaman', 'Rahulma095', 'Sofabae', 'Kamala093', 'Rajeev577', 'Susmiati123', 'Cakep789', 'AlexBos', 'Gondol123', 'Andik1234', 'Kuncung789', 'Kiya123', 'Farazkhn', 'Arameshsharif9', 'Tahaehsani95', 'Mazinaniali', 'Jangelesro', 'tulutollo', 'Arthur99', 'jackjackson', 'Dziku98', 'abolfazlp1393', 'omoaghefred', 'Omoaghefredric', 'Babrek', 'gold6969', 'Michaelsy', 'hony234', 'amualama', 'hery11', 'josegamez6929', 'Zhe123', 'Lalagq', 'Perihan', 'Khing19', 'Benitodiana', 'Jhonz95', 'Arslanjavaid', 'hamza60', 'Maker2020', 'Romaric12', 'NiainSD', 'pertiwi123', 'Olamilhekan', 'Muhammadirfan', 'Mehdialavi', 'Asad314', 'Lasemo123', 'Ekoa123', 'Ancor123', 'Mustafa11', 'Hiswordxray', 'Chrisking7', 'Vickymma', 'Ecrinada', 'QuiqueJP', 'Zoldyck', 'Raymond12345', 'yuniap', 'Key1hoseinpoor', 'mandakh71', 'Tuwastin', 'oyuky6363', 'Esmeraldino', 'Lukadazong', 'Eterovaudo', 'duvamng', 'serdic', 'Eucklaydis', 'krishnavadivu', 'Chinalu', 'btcpervilla1', 'btcpervilla2', 'btcpervilla3', 'Arwati789', 'Nus123', 'Hamzakhan1', 'btcpervilla4', 'santipo1', 'btcpervilla5', 'btcpervilla6', 'Fisgi1991', 'tayyab7070', 'buyawka', 'Puput69', 'Ummeey', 'Favrik', 'Rahmatollah', 'Esther1991', 'Falademumeen', 'Pemburucoin089', 'alisial6500050', 'alisial6500051', 'alisial6500052', 'alisial6500053', 'Xampi91', 'arusg30', 'thantai899', 'Chris0709', 'Ifeoluwa2020', 'Theoblaze', 'neila2020', 'yorpro', 'mamiSD', 'Chuhero', 'Herotest', 'zazah17', 'Herotest2', 'adraez', 'NEWMAKER', 'mimask', 'Drshakeel', 'gatyyy', 'Warley', 'Hishigee', 'Hery12', 'harrychi', 'Gunja5161', 'Udindico', 'Rockky', 'Ludruk', 'Zeek4real', '33GORGON', 'LUPPERGROW', 'DyahAyuSulisty', 'Iqra1122', 'Veera7', 'michael55', 'Riadh88', 'btcpervilla7', 'Chiagozie', 'Sterrywhyte', 'Haddassa', 'Sophia4u', 'zaib034', 'Deysdry', 'Harry66', 'RamiroB03', 'Tonitr83', 'Hcfmadren4hh', 'Jayman27', 'Ikeyoung', 'josline', 'araaaz', 'Ilohjhenny', 'Usman9080', 'uzmarani', 'mamiiii', 'mamikely', 'hhazzzza', 'SHANAS', 'kryptonatka', 'Hirmeneu', 'Probe246', 'Oluwagbade1', 'Rizwanamalik', 'Gyoufaucet', 'Naseer222', 'Smile4ali', 'Bety123', 'Mralez', 'Temmyadex', 'williams09', 'LISAMAGSAYO', 'Yuniapr14', 'jrabbasi93', 'alibafd', 'akamirolaa', 'anmolsingh9708', 'Mehedi46', 'Olegan86', 'Mamikwely', 'tovoandrts', 'bemami', 'zazabe', 'Tbongani', 'Drjavaid', 'nadir11', 'Sunilchauhan', 'MICHELZ96', 'Frank12', 'Aurora84', 'jawh41128', 'Maaz1213', 'Idaelolives', 'Ganbat1', 'MuznaRajput', 'Anjali08', 'Awais39', 'Leelen', 'cant0nik', 'Roacoa', 'Warriors', 'arjuntapia82', 'temvvjin', 'yaanivapeji', 'tumee8889', 'AnaTheaMoretz', 'Btcmake46', 'superhitankit', 'Chrisbenwall20', 'VonZipper', 'Rubyrider', 'Brandolee', 'Olatunbosun', 'Tsoomoo', 'Awhykya', 'Suon034', 'ela8201', 'alerighi', 'Sernaell', 'dadabe', 'zazahbeloha', 'ritaaa', 'rahul10224', 'zafymalo1', 'Spyker69', 'jhanmopl', 'Breakthrough50', 'Sakthu', 'MCSheesowm01', 'Bitmake', 'isora865', 'Oluwadamilola', 'mpumelelo', 'llastre', 'HJ270612', 'AbhishekC', 'AkashaS', 'Alfjt2', '09025530605', 'Rayhan20', 'Husseinamer', 'Azharshah800', 'Sowbix', 'alexbab111', 'Toothy', 'Jacare', 'dreeand', 'Michal', 'Oyunbold', 'Olalekanwwe', 'Jagadheesh', 'Sazad11', 'Arashi', 'Arashi123', 'Julie22', 'Zuly123', 'fadilah70', 'Yarixza1', 'Yarixza2', 'Yarixza3', 'Abokiwire', 'Dragneel96', 'oneseven', 'wisegar24', 'coolingtunnel', 'Amatua', 'Tsogoo1231', 'temvk2000', 'wpwithme', 'Fatin76', 'Jijoca', 'Heidy81', 'Tritambiche', 'Abraham01', 'sotoweb2', 'ErwinSalim', 'Nemesis01', 'Taher616EF', 'Vivat54', 'shahroz90100', 'ROBERHTPEREZ', 'saleem8787', 'Kacyque', 'Hamar1009', 'JessicaDM', 'shAhid5523', 'somakun005', 'Shingraf00fati', 'Adeelmalik', 'Adeblessing', 'ElianyAleman', 'Shivu1122', 'Jhon121', 'Reycute18', 'technical677', 'Chimude', 'angelica02', 'Ajaysharma1234', 'Ramzanahmadg', 'Ramzanahmad33', 'anubd13', 'ratarataEZ', 'Darielito', 'Ali8410a', 'godwin22', 'richardrdn', 'nettycune', 'Papillo', 'indrit', 'Kkbhardwaj', 'turmunkh58', 'laurentrdnr', 'Masooood', 'VOLOD112020', 'zaazhllk12', 'Samuelorhe', 'Angelmario', 'nilamaral', 'Kiko23', 'Iyung123', 'aahilzeeshan14', 'Pol1207', 'zarmeena447', 'adnan555', 'aahilcheema144', 'JaiPrakashS', 'sharpuncle95', 'Avinashdevtwal', 'Sylviry', 'oklombar', 'JOHANSAEFUL93', 'tapas4911', 'Godwin881', 'Cimiden', 'sammy80', 'Ashiq786786', 'Ashiqali786', 'Fandra22', 'Okikiayo', 'selenge', 'Gabo1234', 'Togsoo', 'Selcukxx', 'Kotahash', 'Unstable1', 'Yarixza4', 'JIEFFRIANSYAH', 'Mighow', 'Isrealchuks50', 'tseegii1841', 'Leprexel', 'saihana', 'Hanasdas1978', 'Khalyas', 'Sandesh11', 'Manoj9680', 'Sahilpb4151', 'Dhananjay122', 'zazabeoi', 'baara12', 'UuganaaBatbold', '1234eq', 'Lbowens1', 'Arkanaya', 'zazakelimo', 'Subham750', 'enkhpurev', 'ochirsukh', 'FarooqBhutto', 'manohar369', 'john2056', 'Enhzul', 'A990303', 'nishant7000', 'Ajay143', 'Gauravnewton', 'Almirha', 'Azan143', 'Ferenczi', 'raralla', 'razaali7868', 'omotayotimothy', 'Daxi369', 'Badamkhatan', 'Yhawcarlos', 'Nashee13', 'afzrkza', 'Munhuush123', 'zuberch', 'atingtg', 'Joeklean101', 'Parkashkumar', 'Marianniem', 'CHOUDHURYWAHID', 'sandeepmazumda', 'zazabelelo', 'kileurlog', 'Sitingaisah', 'Narantuya', 'miyegombo', 'Satyamrai99', 'Danimore', 'Juliet2001', 'Aishk07', 'okeafaisolo', 'shab291', 'akash41196', 'SamuelMakco', 'shafqatali144', 'feliexis', 'Uuganaa0508', 'Onipede', 'Subhankhan', 'Mimikelly20', 'hatanbvvwei', 'Norielcruz97', 'Naraa12', 'Temuulen1005', 'Shaazgai', 'Muhammad668', 'taskeen786', 'Shun24', 'Preciouszosu', 'SamJos', 'Shacks123', 'derisaLV', 'madr8782', 'Veronical', 'Rishi2004', 'Sarat1234', 'Ariga1207', 'Shinebayar1', 'Vasudevnv', 'Meuquizedeque', 'Suresh2590', 'Chinbayar', 'chak144murad', 'alexwatson372', 'Mujahid144', 'jacobrose886', 'Kharizma', 'rosetaylor775', 'bumer33', 'sehrash144', 'niranj', 'temuulen1030', 'Saujanya', 'baysmaa0916', 'Ffavour', 'SMAHLANGU', 'onsterm', 'gatemkaa', 'gankhuyag', 'mandess', 'Shirbazar', 'mallaup', 'rapidshovers', 'Usukhbayr09', 'kmalla12', 'vscccricket', 'jacobrose786', 'Ankush123', 'riaz31622051', 'ganulzii', 'Otgonbat', 'Anthony1', 'Sandagjav', 'ByambaaJaal', 'ayaan7868', 'feltoxXx', 'Tormandax', 'Davaa13', 'shahbaz1463', 'Nabuko', 'Aditya95169', 'rarafinar', 'Marwan222', 'Udayteja', 'Oogiio', 'lkhagvaragchaa', 'HARISH7327', 'waqarsajjad007', 'Khulan', 'reinabetancour', 'Omi2509', 'Babulu', 'onlytheone', 'delger9103', 'Suyodh', 'Blaqberry', 'Farhaanmalik12', 'HANU9772', 'Yellowize', 'Varad333', 'Ujjal12', 'senseitulgaa', 'mbfairy', 'Nikodemos', 'Gaaaaaa', 'Sancho199', 'Joseaq865', 'Joseaq86', 'Edinson', 'javad009', 'muritala21', 'Lkhagvaa218', 'Justdati', 'sitrahaj', 'Vaidyanath', 'riazahmad9674', 'Shehbaz168', 'Sourabhkh', 'Shumailanawab', 'sotirisdimi198', 'Olasmith218', 'Soderdene', 'Salman0752', 'Janbolat1234', 'Zoolko', 'soaliny75', 'BILTU420', 'Jadaran', 'SoafaraMarie', 'lkhagvaragcha', 'BolorBaatar', 'Baaskaganaa', 'Tomorbaatar', 'Gediyon', 'Prakash7990', 'Sahilbakal7082', 'Zulzaga', 'ssamiran164', 'Moxie15', 'Rajsuman', 'Zokozul', 'Dariaari', 'Glover54', 'abdirahim', 'ibrahimyau922', 'Munkhbat74', 'Haagii', 'Avirmed1103', 'Monkeymomo78', 'Erdene0716', 'Soumya122', 'Mano0509', 'cyberhunter786', 'turtolone', 'Soyabb', 'Kendie', 'Abid2015', 'jose1975neo1', 'Sarvhfxgy', 'ichinhorol', 'Kambleadesh123', 'Mesuman', 'Adeelahmed85', 'mcaladio', 'jonathanisac', 'samreflex1234', 'Ram8604968736', 'Pintupanda398', 'Shabbir100', 'Pavilo', 'Akashdubey', 'Kojogates', 'ICUNGILANG', 'saraaganaa217', 'ykpsbs', 'kotrikamiahmok', 'Maidar', 'ayaan80', 'ayaan8090', 'aaydhfda', 'Sanris', 'chrishayden998', 'bharatkumat123', 'rosebell0786', 'Saruultuya', 'PGM305', 'rarataou', 'mlkfnpagape', 'Arsambaba', 'owoaka', 'patrik12', 'Sidz123', 'Egooyibo', 'Danito0565', 'Cakep123', 'Aconk23', 'AGAFAZE', 'Miliannys', 'valmore', 'Bookhey', 'John2020', 'Lealkenny', 'Gbolaga', 'Bbtsgr', 'Sonu059', 'rolandoortega1', 'sfss2442', 'maebilu2021', 'Tilekaibol', 'mahdik', 'Huwituguldur', 'Xunill', 'daaltna', 'Ganbold', 'holilah', 'mariyah', 'ymacuran', 'Safasharif', 'Tutucaoliveira', 'Moogii', 'alikhan6500050', 'behealthy894', 'learning998', 'Uche111', 'Laybokeh', 'Chudut', 'Maliha123', 'Satrio15', 'Kiki15', 'Cyproin', 'Nishadklbm51', 'Kryptoniteee', 'Xatau1', 'samaon', 'Jaima1997', 'sidaniy', 'Sungod88k', 'Adonis30', 'Anupam', 'ramztm', 'DevilclownMac', 'Maynornengi', 'EndrasutaNaa', 'Jadab9', 'Mechboy', 'Melvin18', 'Chsaif', 'Anubrata', 'AASHAN', 'Anhbeotn', 'Narantuya02', 'Neet1117', 'France1996', 'Lodesiva', 'Yuvi123', 'Waruna', 'Oerdene', 'behaartem', 'Maryjane001', 'vienarose', 'Ankitjatkk', 'honey1212', 'EarnerOS', 'Jasiingh', 'Ekenejames', 'BilalAhmed', 'Pranshu', 'tinmd69', 'Hamim20', 'KANHASAINI8475', 'ria0123', 'himal200', 'Rose39', 'Covid020202', 'sadafBatool', 'Godongtelo001', 'Jojoxxx', 'prake058', 'Gokul332', 'Suvveking', 'mustafaishaq', 'Tawfik', 'Rishikumar', 'nomanE', 'DEEPAKgamer', 'Pascal090309', 'Amidral', 'Dedemahwita', 'banker14', 'Pascal1', 'Sudhir7', 'chayan1123', 'oyigbo', 'Rahulsolanki7', 'Klebian', 'Selina201', 'chriscasmir', 'Yash5000', 'Wildan475', 'markotok', 'Dilwarkhan', 'Deep20191983', 'holilong', 'Davaasuren116', 'mehedi44', 'galinga', 'Mariam1988', 'Lanangn', 'Rahulabk25', 'Mosexx', 'Henry12', 'Majid301', '0r6i7o0', 'vickyonye', 'DM2000', 'Rajverma', 'Khandsuren', 'mehrdadsaadat', 'Haddikhan', 'Jonny2020', 'Sunnyade1', 'Felix1998', 'Lucybabe', 'Aaron25', 'adeabel', 'Henry74', 'Maxaxel', 'Amulbhai', 'Clique', 'Okoyeochapaul', 'Bizman', 'Lisbet', 'Daphnedolly09', 'Semogaberuntun', 'mamiya', 'maspiye', 'makiyla',
					'MaykelA', 'Mercy95', 'Khadim007', 'psdhir', 'Thakor1', 'Farukh', 'Rushikesh07R', 'Farhan123a', 'Kamiku', 'Snazzyqueen', 'NurilHuda', 'RWALTON1980', 'cesarrfajardo', 'Shikandar007', 'Anant125', 'Sodnomdemberel', 'Shirlya83', 'mdmiraj', 'Nomioko', 'Uitumen', 'torootoroo', 'Vishal7913', 'Kenzomilli', 'Sahbaj', 'Balbir', 'Khursid', 'Tuvshinjargal', 'Sujaydutta941', 'Santyd', 'brijmohan', 'Zapdos', 'Mayoroffct', 'Amdijo', 'Kumarlucha', 'hope77205', 'Lorwal', 'aagii8872', 'Blumlime', 'Ghannu', 'Irrulone', 'Ghansh', 'WaqarVickey', 'gol990116', 'Rajdev12', 'Preet1', 'Masik11', 'Joshua108', 'Batbuyan', 'blessingedeh', 'Ajayak47', 'Kkt007', 'Amgaa887766', 'Hamzakhan1238', 'Shaeera', 'XagiTroga47', 'Junaidjabir', 'Nixieee', 'Chan48', 'Narxarchive05', 'ChauDong10', 'haidermirza712', 'arizona', 'Narxarchive06', 'Narxarchive07', 'Narxarchive08', 'Pkn1996', 'waveclt', 'Namuunaa', 'Ernest102', 'ubaldocr', 'Somnathmanna', 'loke2020', 'Tanaprayoga', 'Focussneh', 'Manuelxoc', 'Flanigar', 'Quinsha', 'Kvngmovik76', 'Cynthie', 'Oogiizoogii', 'smairi', 'Alokraj1247', 'Brave1234', 'Belloismail', 'pahrul', 'loke2021', 'loke2022', 'loke2023', 'Dennis2005', '1411amraa', 'loke2024', 'Arulkumar2219', 'loke2025', 'Enkhjavkhlan', 'loke2026', 'Pujee8850', 'berisi', 'hustla', 'KINGBEK', 'bagusbanget23', 'berisiy', 'sitirubiy', 'hoiriyah', 'Fahat2', 'mliyah', 'huseiri', 'Bayraa', 'Sandeep30', 'Xatnaaa', 'Audthom', 'baljkapurwee', 'Kashi1122', 'Dashka0070', 'gsdgshayui', 'Lhynnex', 'Masudjr', 'Hasibul1234', 'Precimado', 'Blessing124', 'Zulaa1234', 'Yungmib', 'Bodismaa', 'Tere0909', 'agfgazerhy', 'Suugii00', 'ab8899', 'Bakrmono7890', 'Otgonsukh', 'myozawhein', 'Narxarchive09', 'baasandorj123', 'Raja45', 'Ashutoshgupta', 'nandia12', 'sugarerdene', 'AriunzayaZaya', 'Sansartuya', 'Amaraa2', 'CashqueeZie', 'tunggulwulung', 'Sukhsaikhan', 'Aagugun', 'Mendsaikhan007', 'ganaa13', 'Ganaa247', 'yoha40', 'yoha300', 'BCYani', 'Pharez', 'yranisleal', 'pahmis', 'miming', 'miongg', 'Yun4457', 'dagvadaagii', 'goodandrew', 'Pietradalyanto', 'Talktohare', 'SoReal', 'Shymol', 'harry901', 'Khyalias21', 'thasim15', 'tugs0517', 'tsingh18', 'bayara1', 'karan55', 'Abdulrazak', 'kilortaa', 'mamdouari', 'Parejo41', 'reeewhe', 'muapiy', 'mupiye', 'Aminaa', 'RodneyW36', 'dulhol', 'saliya', 'purevdash', 'zerostress', 'reeeweh', 'amapure', 'reeewhea', 'Sanjay14', 'addurr', 'PrinceE9', 'Ulziibayar', 'Ulziikaaa', 'Imran100', 'kileurbeo', 'seiyalima2020', 'sebastiaovisao', 'jahanzeb', 'jucaberry123', 'luisbluered123', 'henrique12345', 'eegii1225', 'Ahmadc', 'Moopet44', 'joao282821', 'Erdenee', 'Maikel88', 'Bannihera', 'Asadiq', 'lovaaa', 'khuselbaatar', 'Apbantab89', 'ALF234', 'AjitSingh', 'CoolTugu', 'ludok01', 'all4gideon', 'hoirul', 'harulu', 'GoldStar', 'Tamiraa1997', 'rurorr', 'hoilil', 'Dictator', 'Cjcarlos3564', 'ennorr', 'Ganzorigng0628', 'yaaniy', 'Justindave', 'natsagdorj', 'Batzorig', 'Yukio0115', 'Buyandelger', 'TSEDO1027', 'ikorom', 'enkhod', 'amanai', 'cocomm', 'Narxarchive10', 'ilhama', 'narxarchive11', 'Crystal0425', 'Haroonuwais', 'nyamd893', 'namika', 'narxarchive12', 'narxarchive13', 'Ernestmario', 'fanjaarino', 'Bolor1989', 'odgooo', 'Nomanbolt', 'ropede', 'rosila', 'rositi', 'riskiy', 'sitima', 'williamsbizz', 'Esilka', 'Mimicarey', 'Oyuntungalag', 'narxarchive14', 'Narxarchive15', 'segaslonxxx', 'Tayyabdawar', 'fsdeseres', 'Jacky222', 'Gastengengs99', 'sugathmadushan', 'Margaderdene', 'bitcionbilguun', 'Grady75', 'Jonnysander', 'Testament', 'Goodguy', 'Kobra77', 'Akash1996', 'Akash86', 'kakaishiushi', 'sasukeio', 'Buykana', 'zuber2000', 'miigaakolya', 'gantomor', 'azelie', 'Manawiahsa', 'MnQL3333', 'Cakpangan', 'Fantinalasri', 'Budisudarsani', 'Futiranira', 'Rosalisanawiah', 'Rosalisan', 'Lastrining', 'Tangantuhan', 'Uswatunh', 'Mudjionosa', 'tsoomeow', 'Rahayupa', 'Budisurijana', 'Egor1st', 'amirsfv', 'Naynbuu', 'narxarchive16', 'Mirza2496', 'Amgaa86', 'SwairaMalik', 'Bilguundalai', 'bujeep', 'miigaakolya020', 'oogii0311', 'attlas', 'rollbitter', 'Leydis1', 'Daymer1', 'Daymer12', 'Spehcial', 'andyyuri', 'allize', 'balona', 'matbul', 'saniri', 'liyank', 'sasani', 'roniya', 'jadipa', 'Abayomi97', 'ochir5', 'mamiyO', 'amilay', 'amkab98', 'amkab0305', 'cboxes', 'torrnt', 'Pitrirahmawati', 'Natshit', 'Nutgldr', 'batorgil123', 'rorilo', 'fikala', 'Baagii11111', 'lailiy', 'tofiki', 'Bayrbat', 'Erdenezaan', 'sunahi', 'Dulmaa', 'batorgil138', 'maulid', 'saweri', 'Altantsetseg', 'Dolgorsuren', 'Dondogmaa', 'laiyli', 'Sumya4', 'boldsaikhan', 'Nickbh', 'Tangankanan', 'Foodmeald', 'kakashiai', 'miigaa001', 'batnasan999', 'Ariukaaa', 'Choijoo', 'Odnoo0216', 'JAMNA9818', 'Yorisbel84', 'Altka98', 'Freeway123', 'Nominee', 'Ifeoluwa1', 'Cippolino', 'abyyy1', 'jazzman', 'Yelenny', 'Ungodly', 'Skyface77', 'Yivimar', 'mari22', 'saeful19', 'AsalTulis', 'puujeebay', 'Uugaas', 'odonchimeg', 'Wazir006', 'Maeiyama', 'lartin', 'chuluuntsetseg', 'LonLuu', 'nvrh234', 'Arasittt', 'agfswyV', 'Tontito', 'yassinhilali', 'Faysaljeses', 'Sonyafilal', 'Khuselbat', 'goncho', 'NIKHIL4158', 'Olumyte', 'Victorjavier', 'Otongin', 'Munkhdelger', 'Javierledesma', 'Sahilasupri', 'Hendrasup', 'Omer02', 'Hendrachemsu', 'OCGIRLLIA', 'Uswatunhaaa', 'Kiranaarjuna', 'Vboot1', 'Alibits', 'khosey', 'alunga', 'pipita', 'manapi', '88482012', 'tatika', 'hibbin', 'jehraa', 'hayati', 'mahela', 'makura', 'alisaa', 'wehila', 'matsai', 'soimah', 'masnah', 'werohm', 'Nala326', 'melung', 'maysar', 'Burhan01', 'User967256', 'shineod', 'seiriy', 'marwen', 'Baljka77', 'solehi', 'rahamt', 'Ayyappa', 'aizazahmads', 'sakini', 'ShhZib5', 'Umesh91', 'raniya', 'sakira', 'bvjinlham', 'nimoro', 'Yana290593', 'Nanangkaya01', 'Kwadwo', 'Tsolmontuya', 'Battsoglog', 'Otokpajohn', 'Sarantsetseg', 'Rajaatif', 'Bayaruh', 'Djarot00', 'baagiina', 'tsetseee', 'Zulaaa', 'Kokuko', 'Zuyi12', 'Tsetseekhen', 'Sombra', 'Loluloo', 'paiyra', 'fiyrah', 'saruji', 'Hitut5x', 'saryeh', 'hosliy', 'Didynn24', 'Tarno00', 'sokodalai', 'Ariyt123', 'Seemii', 'Kata676', 'kenzost', 'Dias567', 'Yasirch', 'Djarum761', 'Batudam', 'Karinatapir', 'Jokowidodoo', 'Prabowosubiant', 'tapolenko', 'polachkeck', 'alibhai67', 'arifmoh', 'rubiye', 'simani', 'suamiy', 'Mberrrr33', 'Choirunafis', 'Omprakash09', 'Haidarraza786', 'WasiAhmed', 'lutfie', 'Sims12', 'forestwowo', 'galaksyj700', 'mehdializadehh', 'sahlah', 'Mbeeee', 'Plusss00', 'Prettt', 'ripana', 'Mbaaaaa', 'Aep1988', 'Riz213', 'yasir0', 'Bpjs10', 'tadnur', 'assada', 'mahrip', 'sapiye', 'yusuup', 'Yogipratama200', 'Bryanadams01', 'alpana', 'Lindsaypoh', 'riyzal', 'Dedenpatir', 'maruji', 'naurat', 'dulwed', 'Anthony324g', 'madudi', 'najwah', 'masiyd', 'Andrewdes', 'yahyak', 'Cindydean', 'parisi', 'amsala', 'bigmaa', 'kikorio', 'Rakhshanda', 'hitakio', 'Bjuworld', 'phool315', 'Franklinmuogbo', 'Baloch1214', 'Meharwaheed', 'vinodktr', 'BenoBrock', 'Syifa22', 'Bulgaajaal', 'emanasad05', 'ahsan2032', 'Jacobdean', 'puubaa', 'Janethdean', 'Jeanetteee', 'Jessiiiccaa', 'Juanalost', 'Richard001', 'dareth1', 'darethli', 'Raquel1', 'Reynol1', 'Adrian1', 'Sofia1', 'kajigret', 'fankiemu', 'crookedn', 'dannieldan', 'gravittysv', 'dilarigerar', 'relentlieve', 'plastiktacticc', 'uplightfunkiie', 'moreminnie', 'palindrome', 'saliiecori', 'tedddibya', 'xanorod', 'ando22', 'kisscamm', 'foedtilli', 'xavicalio', 'mrrkittenn', 'torregt', 'victiriiann', 'abrrahamic', 'ssonicboom', 'Cik123', 'gettincloser', 'geraldou', 'Kennethguy98', 'laiyla', 'rosidy', 'Gami67', 'Taiwan', 'Josemoros', 'norsal', 'salmai', 'holpai', 'pardik', 'pahila', 'Nyanjara', 'karima', 'ratnai', 'Zolbayr', 'Oogiijsd', 'masodi', 'suyema', 'sumari', 'moyopa', 'mohsiy', 'Debbygatty', 'holipa', 'zeideh', 'wehede', 'pukika', 'rezagh25624', 'Turbat88', 'Tombozibe4t', 'Rafn234', 'aldoso', 'seynap', 'kasani', 'amilon', 'lalong', 'seloka', 'adisiy', 'fredrickken871', 'Nailahbela', 'sumaei', 'ruksin', 'hadiko', 'Altushka0903', 'maskuro', 'batdelger', 'Natturaj', 'timothyprince5', 'hosnai', 'Chahar', 'maliye', 'Ahmadd11', 'Balajiii', 'Strajaji', 'mamzella', 'Shahzaib8088', 'Johnraj', 'Chimedtseye', 'Pornood23', 'Prasith', 'Andry1212', 'Davgasumberel', 'Saranyaaa', 'Anjimmmm', 'Fuck00', 'Ranchini', 'Sridivya', 'Emediong42', 'apalu123', 'Nitheesh', 'Subashbaiya', 'Iamsubbu', 'Iamvenkie', 'Iamrajesh', 'Zala04', 'youmeng', 'waqaso', 'Jahangirhossai', 'haroon3456', 'QueenJummy', 'Manojraj', 'Manojraj555', 'LottaGramz', 'Arokiya', 'Aselvan', 'Aarthi654', 'Sakthi765', 'Aavudai', 'Kamalesh432', 'Gurusankar000', 'Manick88', 'Malaiarsan', 'Sathyaa333', 'Harry45', 'Oxzybest27', 'Christine123c', 'Clemente1', 'Mercedes1', 'Confi1309', 'Mercedita12', 'Leticia1', 'Gilberto1', 'Raviash', 'Muviskutty', 'Muvispaiyaa', 'Velsamu', 'Crismat', 'Success9', 'Velsathish', 'Santhi444', 'Santhanam', 'Tigre26', 'kahara', 'Mariselvi', 'susila', 'mohtip', 'timlah', 'kolmar', 'simadi', 'rohweh', 'amanga', 'juhali', 'iksani', 'mathot', 'jonata', 'anithas', 'asmadi', 'martua', 'makiloiu', 'hilariolo', 'Sajid1212', 'kilorier', 'Khan2654', 'Fokus02', 'Khan2655', 'Khan2656', 'Khan2657', 'Khan2658', 'Khan2659', 'Khan2660', 'Didar2654', 'Didar2655', 'chukwumanwodo2', 'Dineshpaiya', 'Selvakumaran', 'Shees8899', 'Santhooshg', 'Kavi888', 'Iammani', 'OdexN182', 'Muugii88', 'Vennila', 'Bavithraa', 'Anbupriya', 'Premalathaa', 'shaanaa', 'Suresh001', 'Velraji', 'Giacomo4690', 'Oguntoyinbojoe', 'Gulug85', 'odett3', 'udinsip', 'amatbacok', 'kodokkayang', 'rhandy536', 'Jasper121', 'Didar2656', 'Didar2657', 'Didar2658', 'Emmatest', 'Didar2659', 'Didar2660', 'gansum', 'Ayesha2015', 'johnnypaully63', 'Turuu98', 'Ayesha2016', 'Ayesha2017', 'Ayesha2018', 'toto0000', 'toto0001', 'toto0002', 'toto0004', 'helado1', 'helado2', 'toto0005', 'helado3', 'helado4', 'Hauten77', 'toto0006', 'HELADO5', 'helado6', 'HELADO7', 'toto0007', 'helado8', 'toto0008', 'HELADO9', 'helado10', 'toto0009', 'helado11', 'helado12', 'toto0010', 'toto0011', 'toto0012', 'toto0013', 'Nico6969', 'helado13', '123123llll', '123123123', 'BASTAPORFAVOR', 'HELADO207', 'toto0014', 'Ajith666', 'Dhruba98', 'helado121', 'toto0015', 'helado14', 'helado15', 'toto0016', 'helado16', 'toto0017', 'helado17', 'Hariharan543', 'helado18', 'toto0018', 'helado19', 'toto0019', 'Manikandaa', 'helado20', 'toto0020', 'helado21', 'Ramkumar123', 'HELADO22', 'toto0021', 'helado23', 'toto0022', 'Dineshkumaru', 'helado24', 'toto0023', 'helado25', 'toto0024', 'Rajeshvenkat', 'toto0025', 'helado26', 'toto0026', 'HELADO27', 'toto0027', 'Karthickboy', 'HELADO28', 'toto0028', 'healdo29', 'toto0029', 'HELADO30', 'toto0030', 'helado31', 'toto0031', 'helado32', 'toto0032', 'helado33', 'toto0033', 'toto0034', 'helado34', 'toto0036', 'toto0037', 'toto0038', 'toto0039', 'toto0040', 'helado35', 'toto0041', 'helado36', 'helado37', 'toto0042', 'toto0043', 'HELADO38', 'toto0044', 'helado39', 'toto0045', 'helado40', 'healdo41', 'toto0046', 'healdo42', 'Abid2016', 'toto0047', 'HEALDO43', 'toto0048', 'healdo44', 'toto0049', 'HELADO45', 'Abid2017', 'helado46', 'toto0050', 'helado47', 'toto0051', 'helado48', 'Abid2018', 'toto0052', 'healdo49', 'healdo50', 'toto0053', 'toto0054', 'helado51', 'toto0055', 'helado52', 'Turuu9889', 'toto0056', 'toto0057', 'helado53', 'coolomnivore', 'Alex5455', 'Leticia2', 'Lisbet1', 'Krishnakumar10', 'Mathi88', 'Marimuthu000', 'Vetriraj', 'Sundarsingh555', 'Buttlerman', 'Rajammal', 'htm04f2', 'Soronzonbolor', 'Johaina', 'tarmai', 'abdusi', 'Shamyajit', 'samila', 'jelisa', 'mahiye', 'Mahanaim', 'Believe3', 'sahlai', 'jailan', 'natira', 'Mperce', 'beamcknold', 'salita', 'Jevons', 'hasipa', 'Andychuks', 'satina', 'sukata', 'moytak', 'mansui', 'Tseegii0203', 'giylan', 'rokyah', 'silumn', 'sunari', 'Suugii0', 'solahi', 'Gulug8', 'hindun', 'jennah', 'Muugii28', 'mksina', 'mayyeh', 'Gerel77', 'habiye', 'Batka01', 'seytan', 'Baynmunh22', 'Avirmed34', 'sohibi', 'Edetdaniels', 'Rahul5595', 'Rupanraj', 'Temuulent76', 'Raguboy0909', 'sonydrey', 'Morgan111', 'tonids', 'Tawfiiii', 'enkhbat0407', 'egshiglen', 'Liza82', 'coolman12', 'Rahulsharma', 'Rachel88namuna', 'Mayavathi', 'Monkhoo', 'Sneha333', 'Enhheeee', 'GulaMerah', 'AnsQues', 'Solikhun', 'Abdulmanan07', 'Saryadi168', 'Turuu89', 'Ashish86', 'farrukhkhan', 'OfficalYou', 'Mehak86', 'Mangar89', 'Mehak11', 'mehakmanocha', 'Ukpabipeter1', 'Wilbud1', 'Iffiatif', 'OleksandrC', 'zurhtom89', 'Bestwhite', 'Ayotomiwa10', 'Cyman3', 'Baek123', 'amna123', 'Peteruchenna1', 'Juansiti', 'Peteruchenna2', 'martinoogii', 'Saryadi1234', 'Beny39999', 'Breffers', 'sergap', 'lahyau', 'Niyasrenu', 'Suniliam', 'Pilaya', 'Sumathi444', 'Radharavi', 'Ashfaq4848', 'Dulmaatsogtoo', 'Chellathai', 'Anupriyaa', 'Ilavarasan', 'Annakili', 'Vijaysankar012', 'Lalshastri76', 'Dineshmuvis', 'adeelabbas', 'sarmih', 'Udguuu', 'Fauzan02', 'milialex', 'hajipa', 'ggayaa', 'Alfa19', 'tuuguu', 'anonimhesap2', 'markoa', 'sasara', 'undarmaacool', 'bereka', 'bmalam', 'maxiehonoh', 'mohrom', 'weetararotl', 'homani', 'jelimo', 'roymas', 'inohwehoy', 'mundurmaa0521', 'MianAbuZar', 'Naran99', 'manzilerato', 'samlay', 'Ashish22', 'malemotebogo', 'Tahir226', 'Tujaaa', 'Sinta789', 'mpomsotshego', 'mankor', 'Korak123', 'sondothapelo', 'Dendy789', 'duyuda', 'Hanaaprilia', 'mantozahtshepi', 'Isbud15', 'anselmofirst', 'thatosonto', 'kaktus12', 'mudassar147', 'Vishalkumar', 'Vivekdubey', 'Ganeshsukh', 'tinahsapaho', 'Turbat1228', 'chipndale', 'gapheloise', 'Agiipollem', 'lecanosapho', 'Erdenebat9', '4h3466', 'toyonshmerry', 'mmigz100', 'farowonyolu', 'mmigz200', 'kabelomaleka', 'thatomalepo', 'koketsoboleko', 'Bilguun09', 'goabotswana', 'puseletsomase', 'mmigz3000', 'makomame', 'Werc17', 'Otasowie06', 'mmigz678', 'Tebogobantsho', 'tshepisompono', 'Ashish1998', 'lookhales144', 'Aryawidana', 'jantsaa', 'palesamotlwa', 'TranoX', 'Ochsuren', 'rinadewi', 'ZippoON', 'sonasoni', 'moshenalo', 'MarryDi', 'Ajgalaokai', 'bonolobabalwa', 'Apolauhspa', 'Apiakpaoua', 'gelarsarjana', 'Aoutapjeka', 'Bilguunee', 'MrBeet', 'Solomonr', 'giwan6844', 'Jaderpaikap', 'gosukses', 'aurasinta', 'picalmasak', 'MillaGrey', 'Jonathanmarin2', 'Mglolly', 'mitoh927', 'tshegomoshapo', 'nadi6829', 'lollypop', 'nopipuspita', 'JasminP', 'saramaleka', 'BitGan123', 'Modiseglo', 'Aposiakla', 'Bersalapal', 'Paoslaia', 'Hidupdan', 'innakozak97', 'Nertyre', 'Paikslapia', 'topstar', 'Bedaferpa', 'ElPadrino', 'Viztagotcih', 'Nercymelany', 'gansvg89', 'Indranil', 'ijul78', 'Rajasn', 'Patrys0617', 'Kuding', 'tebogomalwake', 'Pavithra123', 'Bataa82', 'Khan0514', 'Zahid8323', 'Nasir8323', 'kopelamera', 'Kader8323', 'Sojib8323', 'mariarenolo', 'karabomaloke', 'Martialrado42', 'Ainabe', 'beaina', 'bosthethato', 'Gantulga2', 'bandilethabo', 'ntshenohatao', 'Bolormaa', 'sdoma6', 'leratomatlweno', 'Naina15', 'lwethumato', 'David9999', 'GEANAW', 'matoweno', 'Puugii', 'Rius999', 'bettyleboko', 'carlosisaias95', 'solacejoy', 'Nashu1997', 'tumeloboi', 'Rius123', 'boipeloleka', 'pekelemalo', 'Amarss', 'Berferiapoa', 'thabilephano', 'malapateboho', 'sekerapale', 'bokiketso', 'Penta0', 'Devagun', 'Genwer', 'ElenSmr', 'nompemelokope', 'SamMal45', 'kgalosophie', 'Bondgor', 'jhenny12', 'malelophono', 'sophiemmaolel', 'senonobetty', 'Narantsetseg89', 'rachelchiko', 'Mirfandholan', '12Amret', 'arman118', 'P95Pavel', 'chilwanekoso', 'mantibebedi', 'mphelokagiso', 'Yayahsn', 'kagihomaleko', 'Sukhbat0202', 'Abiha005', 'Iamcharlie', 'kanedimanda', 'banedimakolo', 'bawakuberjaya', 'thatoskotlane', 'AlexSnow', 'nomsakelwa', 'Austin001', 'Zikman1122', 'phakenali', 'sophiebabuwe', 'lanebokate', 'infinity1995', 'CrTallker', 'kabelomonoe', 'leratoselapo', 'nellymokone', 'jiego78', 'zeto12', 'puseletsonopwa', 'Anam111', 'ddsagh', 'mantuasennah', 'sinnahkomapu', 'Munkhuchral27', 'kolebesello', 'Piter123', 'Rainofficial', 'tebogothape', 'Mariags', 'sellomphaleno', 'lebosekotlenu', 'Saddamhussain6', 'Shadysly', '22LorIvan', 'Serheo96', 'Tattina', 'kazyman', 'verafdeap', 'markover', 'Apikalala', 'alejandrocente', 'juancarlosmuno', 'eduardosedano', 'bgloke123', 'Sabir237', 'MrRats', 'Yuvarani', 'Gomboo', 'patopas8', 'Tsedenpil', 'khanmwuk', 'Angel5595', 'Angel55950', 'ZNqtion', 'Inggit', 'ganboldts', 'Pokuribalakris', 'sisi17', 'Gingers', 'Yuliafox', 'Morgan78', 'Wyzman', 'rewasdOS', 'Kodak12', 'tulissusah', 'Crissferson', 'xinyianhe09', 'ngshekong09', 'Lowest', 'DonCRV20', 'Gabriel111', 'Roberthmoon', 'saeed8965484', 'mmigz400', 'mmigz500', 'mmigz600', 'Robinwood', 'mmigz700', 'RocketStev', 'amangb', 'Donfani43', 'lemana', 'sampay', 'arbeya', 'jahtan', 'bansos', 'Bapdang', 'Ichinhorloo', 'Ojagojeg', 'Banhar88', 'Blimanja', 'biymas', 'Robertha', 'Teneg89', 'Farhananana', 'tsegiinee', 'robity', 'okooonoo', 'bsugir', 'okoonoo', 'Malvianto', 'tgsgsgdy', 'zuunaa', 'gantsoo', 'Buhuunuu99', 'tserendeleg1', 'tserendeleg2', 'Dulguun01', 'Bayarmaa12', 'Rick420', 'zuunsay0801', 'tserendeleg3', 'silviana', 'Erdne123', 'Saryuna', 'Tserendeleg4', 'odkoodko', 'DNasss95', 'Tserendeleg5', 'Tserendeleg6', 'RafaelR20', 'saihanbileg', 'Tserendeleg7', 'Erhasaga', 'Nymaa1', 'Mohkaf0706', 'Lokkoi', 'Erdne12', 'Fitdarmanto', 'Anhbayar', 'myagmar', 'Seruun', 'starshine', 'odhuuodhuu', 'Anudari', 'KARSOBERLIMPAH', 'handboy', 'fivestar', 'Tserendeleg8', 'Tserendeleg9', 'Tserendeleg10', 'mglstar', 'Tserendeleg11', 'damiamoris', 'Tserendeleg12', 'afzalsafdar', 'Anrica17CR', 'Tserendeleg13', 'cariduit', 'Bayanochir', 'LordZelkova', 'Brownieman', 'Tserendeleg15', 'qwasaswq123', 'Cathywoman', 'Charlesmagne', 'Tserendeleg16', 'Naiam89', 'Tserendeleg17', 'Robinonono', 'Crhistinaman', 'Putra937', 'naynbuuuu', 'Favour070', 'naynbuuu', 'Jadehashy', 'Chriscook', 'Kudanil', 'Junaedi1106', 'Danielloo', 'Rexrose', 'Daryllight', 'mangixchoi', 'Daryllightman', 'Dinosaurman', 'Manoftheyear', 'Hulan0', 'Gibranali', 'naynbuuuuuuu', 'Donaldgoose', 'Capturemeofu', 'Gabrielinhaler', 'robergonzal', 'Jericksekop', 'sosssos', 'Diandragun', 'Lhagva8989', 'Ivonyrosebit', 'virutaviruta69', 'Yundenenhzul', 'Jadehash', 'virutaviruta71', 'Dantonion', 'virutaviruta72', 'Jodiecandy', 'Jamesbondbind', 'Judiefostery', 'Edwardbrownie', 'Katetet', 'Cleodummy', 'Kevinfost', 'Drakecula', 'ANUELLL4838', 'madre5767', 'amikrai', 'Alientz', 'sarong', 'Neikarin1512', 'zartko', 'lucas467', 'Magdalena', 'btcpervilla8', 'kratos5774', 'janet4567', 'sukahn', 'Alexmoo', 'parida', 'asidan', 'mosise', 'Khumalo', 'ochir08', 'migele', 'Hemmzy', 'Otgoo0517', 'Erdnee1', 'daniel21', 'AnggaRenzer', 'asnahsaja', 'indahpuspa', 'marwansatori', 'nopitadiany', 'pa194981', 'sakoto', 'mohmat', 'partianang', 'ranilastri', 'tohmas', 'Bayarmaa123', 'koyong', 'kukmal', 'rohmansaja', 'sandimaja', 'marhap', 'tuajshdd72', 'saputraalan', 'susilela', 'ucupsuparta', 'yanayulio', 'bayrbayr', 'supriadididi', 'makinasik', 'erahrosid', 'ganhar', 'eensalawi', 'kentak', 'dintan', 'dcsmile', 'arozek', 'dedeagusdiana', 'dedeagusdiana1', 'Mehdicoine', 'safdan', 'aasasnah', 'qosym123', 'msonah', 'rosalinata', 'sertay', 'tgs0517', 'rapiahmad', 'adakil', 'jajakreen', 'risajeri', 'mastqo', 'naynbuuuuu', 'Naran12134', 'Regzedmaa', 'AmkaSarnai', 'Mehdicoine4', 'sarkoy', 'sakfan', 'ainaa1', 'pvrwee', 'btcmehdi2020', 'ainaa2', 'konyol', 'ulanga', 'Btcmehdi1994', 'Larsson', 'Maspurnomo', 'Mattdemon', 'Deemaa', 'Reynoldi', 'Gentleman0666', 'Rickonite', 'Kuna2252', 'Yatokun', 'Mayura0', 'Bowotrio', 'Rama2224', 'Alizadeh99', 'Madhu2224', 'Karuna06', 'btcmehdi2', 'Dorjsukh', 'sisi174', 'sisi147', 'VENKATACHALAM', 'SonamTobs', 'kuntum', 'lala347', 'susaka', 'rehgjg', 'kenaki', 'Aldarbat', 'Dimas234', 'Tsenguun0728', 'Ramasubbu', 'Tamilselvaa', 'Nachinkhuu', 'arifaziz', 'enkhuush', 'Niyaschellam', 'Prayogoria', 'sanchez8393', 'Begiee', 'Baabaa', 'bitcoin73438', 'Gunjee89', 'rashika092', 'Munhjin1', 'tgssuu0517', 'Bodams', 'Universalc', 'Nandia11', 'Zayaka', 'Ama1996', 'Zoldyck1208', 'Waqas125', 'bilyam', 'zhema1407', 'muntasirrafsun', 'Erdkee', 'Batbayar888', 'lambda4sure', 'saymahridika', 'Bunga08', 'Galbadrakh', 'Apikslaoa', 'Apolsalakia', 'ramapanji', 'Miigaa10', 'danigolkar', 'Ochir03', 'komang123', 'Rida1999', 'xiomi123', 'leak123', 'aliyde', 'jshdkh', 'eksbkd', 'Labsun', 'kghhji', 'kshjsu', 'jsjskh', 'kshdih', 'jshdjd', 'shasykirana', 'Steven1', 'Cook000', 'Flintoff', 'muda39191', 'Bairstow', 'leak70', 'lampu709', 'Janarjaagii', 'TD6636', 'roberio', 'jamaica900', 'Jakkkk', 'Dandanlolaoluw', 'YOUSUF515', 'Taposkal', 'Aposkaliha', 'sisilk', 'jargal77', 'cardybro1', 'santy13', 'Chuduruu', 'santy17', 'archbtru', 'Smraj666', 'mamay1', 'hridika', 'nyamjav', 'Junaidkhan5', 'bighead', 'cfffcbro', 'bnaaha', 'Nadim100', 'weqweqwewqe', 'betlord17', 'afpshfjsafwdtr', 'Ganaashi', 'tsendee88', 'Ganbolor', 'Achmad28b', 'Shuuk0903', 'aghnsklsajfnmk', 'qrfsaf', 'Rawamangun', 'sylwus0386', 'Lavenia18', 'Hafiffudin', 'Antok69', 'munthe1010', 'Ratna82', 'Yorberjose17', 'sosorbaram', 'Moogii12', 'itgelbat', 'Sayma120', 'sambalkhundev', 'ulziisupreme', 'Calvin300010', 'azao27', 'Altanshagaj', 'abdurrahman120', 'hridoy120', 'harunurrashid', 'yongpoy70', 'ani619c', 'Richard7', 'tuwshe', 'Buchi86', 'Yuhghv', 'jdheie', 'ksbjmd', 'ksbdun', 'krihdj', 'oehdhu', 'jdbhjs', 'Jengsri', 'namdjh', 'Jfjfcb', 'Ieghmz', 'Tod8989', 'Riez1989', 'Jawad786', 'Apitbanglas', 'cranxx', 'Sripurwanti', 'mishka', 'seke0104', 'Enkhmaa', 'Bolor1222', 'Tom999', 'abdulkarim120', 'Buyaa89', 'khurlee', 'munkhjargal999', 'Dumbaasaaa', 'Shai33', 'Padmaa', 'Baagii8802', 'Itdhjb', 'Vicky2456', 'ksudbj', 'ushduj', 'oeurok', 'gdjddh', 'kshdkd', 'hxhfhj', 'guficj', 'Mandaa23', 'Ryushoken', 'Gabrielj', 'Ksjdkc', 'vatosoa', 'Sayan7878', 'Dulguun1', 'Nominoo', 'Turuu00', 'Lut789', 'Buyannemekh', 'rakibulislam', 'asikurrahman', 'Thiyaguraj', 'Wikoleno', 'Mammak', 'byaambaa', 'Droogsofficial', 'zulzaya1b', 'nomio1b', 'Anandd', 'faramrz12345', 'Anuj1n', 'Zayajargal', 'Bajgaa', 'Azzya123', 'everyjob', '4glteforce', 'everes234', 'zocotroco', 'chromerete', 'lipochundo', 'ismaecb2572', 'nayaaa', 'anthonio', 'jacobson', 'NAYANBUU', 'Samitez', 'mtjwbt', 'Expert007', 'rarebeauty', 'belog70', 'lacur70', 'isugih', 'maharani123', 'jamalis', 'amanis', 'salvadorsirins', 'hamilton23', 'davidd5', 'bitasoo', 'walton0', 'NJMA20', 'jalinoos', 'baltani', 'ironman9', 'wartalo', 'powermann', 'talkim3', 'natashai', 'boolim', 'valima', 'palar98', 'leming123', 'balance098', 'raminas', 'Anelysanchez', 'hdhdjc', 'bghffu', 'joomali', 'vckfhd', 'yamajj', 'kolanim', 'divvor', 'anonimhesap117', 'bokarim', 'pinky052', 'rockym', 'woolim', 'aloomi', 'volamis', 'gominas', 'anonimhesap119', 'kumari248', 'Madhabi052', 'vallim', 'ballast', 'anonimhesap120', 'staboard', 'Pritika093', 'armandoa', 'anonimhesap121', 'Manisha093', 'anonimhesap122', 'Muna093', 'anonimhesap123', 'anonimhesap124', 'anonimhesap125', 'anonimhesap126', 'anonimhesap127', 'anonimhesap128', 'anonimhesap129', 'anonimhesap130', 'Liliskaya01', 'anonimhesap131', 'hxhbjb', 'anonimhesap132', 'anonimhesap133', 'ShakiraJD', 'gxbfxh', 'khdjhu', 'ksjsjk', 'Mngn11', 'enhtorbatbayr', 'kdhdjj', 'Ankhtsetseg', 'Johntobiloba', 'hucyuv', 'mcbfhk', 'Sarangerel', 'parisashaker13', 'osbdid', 'Fgxjcy', 'Kdbdks', 'fjhxnx', 'sggvhm', '767850', 'hddjjd', 'Kshssj', 'shyam20', 'hxhdhk', 'Battur', 'gdgfhm', 'AhmadNaveed', 'kebnsv', 'ncvgjm', 'vzhvjf', 'Njcvsb', 'Tsetsegee', 'Haku2020', 'mvjvhf', 'dalkas65', 'shipping', 'Orkhoo', 'galmash', 'goprofi', 'walmart', 'superman3444', 'valentinee', 'olaleyesamuel', 'xavierisaias', 'rose65', 'Sameer60', 'Fazadut9', 'saliasm', 'hayomidey', 'savasham', 'kalsium', 'tanker999', 'walkingdead4', 'american', 'wwechampion', 'tomjerryy', 'collowlimo', 'freebitcoin23', 'Margad531', 'bitcoinhacker', 'ethereum00', 'hashrate', 'ripple', 'bitcoincash', 'tether', 'Fatronix', 'paypall', 'visacard', 'mppesa', 'Erdenebileg', 'Hubib1', 'Hubib2', 'mazharshahzad', 'Hubib3', 'Saifwae1', 'Ciput9', 'Fazahabib', 'azuraputrica', 'Mabruk', 'abolfazl537', 'Ciputj5', 'Mungunzul', 'Waeciput', 'Bataa98', 'Ciputwe', 'Bartek', 'asada14', 'SHARAVDORJ11', 'anonimhesap134', 'Laurelite', 'Rajabatu', 'anonimhesap135', 'Dendrewan', 'Yohandrea', 'Colelele', 'Sandrabool', 'Kacungin', 'Ficolek', 'Jakub994', 'anonimhesap136', 'monokon1', 'Dawidrossa93', 'Rafael088', 'anonimhesap137', 'anonimhesap138', 'jurekb1', 'Manlai1', 'tkewin', 'anonimhesap139', 'Madziarek891', 'Negin1363', 'Adrians', 'anonimhesap140', 'Vanderly', 'ghelghelakzehn', 'Damdinsuren', 'Decool', 'Eidan2310', 'max7724', 'Soejat', 'Yonnna', 'yunuszahra', 'Menuka5500', 'aditsaga', 'shjnks', 'ksjjdx', 'jdidhx', 'afhvnj', 'hzbngx', 'idhdid', 'msbfid', 'ornems', 'kotobe1', 'rapera', 'rahary', 'Mdjbfk', 'Retnoadiningsi', 'operationx19', 'dashzeveg', 'urszula1975', 'Bolor8800', 'nano10', 'Hussle', 'azizullah1212', 'jhcggzdrzdf', 'kudhsfmjsy', 'Babanne', 'ytsytsfy', 'tukangkopi', 'chepdep', 'Khuukhne', 'lopezcarlos95', 'valiporsakine', 'tkvldr', 'jegeridecors99', 'Kudlaty1987', 'Holymic', 'Blade4249', 'Maggydanson99', 'Blade4252', 'Blade4253', 'Blade4254', 'Blade4255', 'Blade4256', 'bondigor', 'sugar90', 'javzan43', 'artfhn222', 'elias12', 'Elias13', 'Elias19', 'Kindmartyr', 'Alaa11', 'Alaa21', 'Bayarsaikhan97', 'gosukses4', 'Lucifer1989', 'Dudungae', 'Williams5', 'Devasj1', 'Batuka0408', 'gosukses5', 'Temuujinha', 'Lucifer46', 'gosukses6', 'gosukses7', 'Noer04', 'gosukses8', 'gosukses9', 'Williams6', 'gosukses10', 'Galsandagva', 'gosukses11', 'gosukses12', 'Oluokoro', 'Olo200', 'gosukses13', 'Williams7', 'Boldbayr', 'gosukses14', 'gosukses15', 'Williams8', 'gosukses16', 'Williams9', 'anhbayar12', 'gosukses17', 'gosukses18', 'zamani1', 'Williams10', 'gosukses19', 'Williams88', 'gosukses20', 'gosukses21', 'gosukses23', 'agus1905', 'carlitoslh', 'anonimhesap141', 'anonimhesap142', 'anonimhesap143', 'anonimhesap144', 'anonimhesap145', 'anonimhesap146', 'anonimhesap147', 'anonimhesap148', 'Johnniedibeatl', 'ahmednaseer', 'anonimhesap149', 'anonimhesap150', 'Jamilu0005', 'yudiguntara', 'ucing69', 'JHONY20', 'aztanD', 'Bmillz2188', 'maki08', 'Oogii94', 'DeryAce', 'khimaurice', 'Burhans1', 'Burhanwae', 'Hasbileg', 'naska0501', 'Elias14', 'Elias15', 'Zeelonz', 'Sanjaa1122', 'Devawa', 'Dolanan', 'lanmdh', 'Dolanwae', 'Alaa22', 'fenohasna', 'Alaa23', 'erin857', 'rlwjdh', 'UDOCHUKWU', 'Leahpard22', 'Kzp2901', 'Solowizzy', 'Sanjeevraj', 'Williams11', 'Tehsin6', 'mark055', 'vololontseheno', 'Rogibin', 'Williams12', 'Ibrahimmuhd19', 'Mongoo119', 'mamangde', 'Kaleemkhan', 'Elias111', 'Purwanti', 'Alaa235', 'Alaa236', 'apaansihgaje', 'Rafaykhan', 'uurtsaih', 'mushfiq2154', 'Zabolno', 'MHGFDYRSD', 'kjhgty', 'Zabolnoo', 'htgfdsdghf', 'Zabolnooo', 'mhncgbvd', 'andryjuney', 'ujyhnf', 'hgdjdhjm', 'Lxagva', 'tdjdyjykf', 'ujy5rhtg', 'gmmnhrdg', 'starkim', 'Khawar', 'Arslani', 'Turmunh888', 'Kenas254', 'anagarcia', 'srisoekesi', 'Cloudnnmk', 'achmada', 'Vetoncall', 'Borsuren', 'Anchali65', 'Maikollatixa68', 'Williams13', 'pariwara', 'Sakorn', 'warudogol', 'flearama18', 'dawanmaka', 'bataa2135', 'Temugen247', 'David28', 'sawan3812', 'Williams14', 'namjilBNO', 'Williams15', 'Williams16', 'Williams17', 'Williams18', 'Williams19', 'Williams20', 'Williams21', 'Williams22', 'Williams23', '0797967765', 'Lhagwahuu', 'Arnoldswary', 'tarimati', 'Jagaii', 'moogiinoo', 'Rajeshwari143', 'Kochengabuabu', 'malamjumat70', 'anonimhesap151', 'anonimhesap152', 'anonimhesap153', 'mawar123', 'linggah70', 'anonimhesap154', 'samaa12', 'Angarag', 'anonimhesap155', 'Anonn156', 'anonimhesap156', 'anonimhesap157', 'anonimhesap158', 'anonimhesap159', 'anonimhesap160', 'anonimhesap161', 'HonMikeIyke', 'lacur123', 'terang123', 'gosong123', 'celeng70', 'Zeil25', 'anonimhesap162', 'Pandiyaraji', 'muhamad700', 'masboy70', 'okazaki70', 'tyson70', 'louis70', 'singapore70', 'ardian78', 'Kusdani75', 'Uka0422', 'alvin10', 'Perpat84', 'RifkieRakhmad', 'aktaraarven', 'anonimhesap163', 'Faris1', 'Dewale220', 'Lkhagwadawaa', 'yerkyebulan01', 'bujuu29', 'Gitonga', 'Temkar', 'Medomedo111', 'Cangkrukan', 'asdim12', 'natputri', 'haerulrizwan', 'Newton1234', 'Tsetsegtugs', 'Shazainali', 'Pyu1105', 'yoshwar', 'Gafar23', 'Derapee', 'Extender', 'narmandah', 'Osas124', 'Alfian96', 'munkhnym', 'muugi123', 'ksbdbj', 'bataa68', 'kshdjb', 'Vhatiya', 'shasy1312', 'Tsenguun123', 'Seenaa', 'SherlockRohm', 'nwhdhn', 'kdhdjm', 'kdjxmm', 'lsndbd', 'Mugimugi', 'Wiwiy3', 'Banjo26', 'ssymabinte', 'satoshimani', 'Tsambagarav', 'Gunjeegunjee', 'Aminerdene77', 'sambobojuice', 'symabinteshakw', 'Gunjamina9', 'Itccng', 'Kojel1992', 'annieanderson2', 'annieanderson', 'afzalmahmud', 'XlurySun', 'errorbit', 'anonimhesap164', 'anonimhesap165', 'abussufian', 'zolboo10', 'lods0082', 'anonimhesap166', 'Amarbold0106', 'anonimhesap167', 'anonimhesap168', 'anonimhesap169', 'Desmondnti', 'chimeziegreat3', 'suharto98', 'silvelis01', 'rhagavi', 'jokowi88', 'jibaku99', 'slinfox', 'Agusmartines', 'Bmsatria', 'Togtoxoo11', 'Lhagwaa', 'demchig', 'anamadi', 'Thasixnine', 'ciput12', 'lhagwadavaa', 'gosukses26', 'Aboki01', 'Badamts', 'yeruu88', 'kenbizn', 'Usama801', 'Dika04', 'Rust21', 'Ibal34', 'givemebtc', 'Lasha1980', 'Munkhjin1', 'gosukses27', 'Unuruu', 'bulgorrer', 'cardings', 'tititititu', 'romeosanto', 'alenesito', 'NITIN9513', 'Alaa2362', 'juanverto', 'alilolilo', 'clonachium', 'lululuymi', 'Altantuya999', 'forgoneta', 'jairoo', 'folladora', 'regimene', 'memeoromeo', 'Alaa2377', 'Alaa23627', 'rikimorti', 'palapingapinga', 'eklelelele2', 'dadadedr', 'kekekrke', 'minubalidu', 'sepmeper', 'hassanawaz', 'calvodemierda', 'sinonise', 'wuwuwuwq', 'cibnfirme', 'Wiiiiner', 'wianduchampiu', 'Alaa2359', 'watafaff', 'epepepe', 'Chimezie36', 'rwesiuer', 'bilguune', 'muhammad90nade', 'Tuya4457', 'Jamal00450', 'heremhen', 'Agilang', 'Bathishig', 'Hady67', 'Monhoo505', 'Yulia86', 'shottoboy', 'Zul0320', 'Chriskain007', 'mafia444', 'jdjdkm', 'lashabasha', 'mdufkc', 'msjdjc', 'mdudkm', 'nggfhk', 'Rumi125', 'hdhgnj', 'Gxhbnn', 'demiavaliani', 'anonimhesap170', 'anonimhesap172', 'anonimhesap173', 'anonimhesap174', 'anonimhesap175', 'aylguu1124', 'zulimann', 'wianduchampiue', 'lokitututu', 'quetepasasewty', 'tititututi', 'Lxui01', 'Anisheebha', 'comiuui', 'seguryry', 'Anbumanii', 'akikimismo', 'iomuchiu2', 'fefito', 'ecribia', 'wowowiwu', 'aeiuiue', 'Ifeanyinelson', 'Lxuix2', 'jotajota', 'tutiotui', 'tititiitittttt', 'Lxuix3', '95247795erdn', 'estritriri', 'mia666', 'Lxuix4', 'Lxuix5', 'Lxuix6', 'noakdjh', 'mskdbs', 'Otega20', 'Johnmic', 'Starkus', 'Jarot29', 'dhea90', 'gosukses28', 'battsoojbaljin', 'rheeaa', 'kownakus', '88814231', 'Jawzaa89', 'Khawaja11', 'Ulzii68', 'Userthug007', 'Dnchenzo', 'ALZICOM', 'Drtahir', 'pejuangreceh20', 'monhoo88', 'monkhoo8888', 'NymkaBTC', 'Puchanaa', 'Chittukuruvi', 'Janchiv8989', 'Coinmake', 'basha22', 'Undraadaa', 'Ochgerelochko', 'Banditkeren', 'Btc1208', 'Emmanuela', 'Zolooo', 'namuun0303', '95247795nn', 'Erdnee1234nn', 'ErdneUh', 'Hardoybek', 'muhammadikram', 'noranora', 'IanAmorsolo', 'Tovrv88', 'Daawka', 'Jogygoo', 'Enkhsaikhana', 'tumuru0516', 'Batuka303', 'Williams25', 'Williams26', 'Williams27', 'Williams28', 'Krkbsg', 'Williams29', 'Williams30', 'Khishigbayar', 'Shinezuun', 'kase563', 'aibarsha', 'ExclusiveEp', 'Jonnysilalahi', 'Minercoine4', 'Mary9473', 'Sodbayar', 'robertikin95', 'Kameiii', 'Kainat555', 'Tsendayush2020', 'Tamr12', 'Shahzain', 'munkhtulga832', 'Djc680ne', 'mangar88', 'Baagii09', 'Killer07', 'Killer999', 'Muneer492', 'SalMimi', 'Chduwara', 'BathuuGanbat', 'Gold9292', 'ogoobataa', 'Arieenee', 'rusyadi', 'Gold9495', 'Idar45', 'Gold9009', 'mamos123', 'cegakmimi', 'vivian3490', 'jadeboobs', 'mandala5678', 'Tsetseekhen0', 'Arezo2791', 'maxmutant', 'Mizan26', 'Okohcf1000', 'Usuhuu', 'Uujiii', 'Zdrale', 'palomas23', 'Ariunjargal', 'William0', 'miami2021', 'sandiegopadres', 'Chuluundorj', 'Ayomide23', 'Adamsmith210', 'uuganbat', 'MehdiAlizad', 'Srohiimaol', 'srohiim91', 'Iz66729597', 'Julieanne23', 'Urjeejaagii', 'Josetr94', 'IMP219', 'Hydz143', 'Repsenja', 'Unuruu94', 'Weather12', 'Iimilham', 'NeliAgustina', 'riciindrawati', '8ekknassasin', 'Udinudine', 'Munhbat', 'Multix1', 'Timothytaiwo24', 'Ariuntsetseg', 'Ysugen', 'Davka41', 'Bilguuteib', 'zulaaka', 'ogooogoo88', 'Gambaah', 'zhoujun', 'Hamim21', 'Ortegaone1', 'Byamba25', 'batukaa', 'Tsogzolmaa', 'hhbbll', 'Ryan9104', 'Ysuigenee', 'Tulgaatulga', 'daria123', 'Ryan2404', 'zhcryptohunter', '99509798', 'Ganbaatardashd', 'BDalai', 'Yondonjanhar', 'Ningsih123', 'Yondonjanhar1', 'Badamkhtan', 'Alt9943', 'kuyjmrhtdgrf', 'mucshfiq21', 'gnbfgf', 'munkhtur', 'Senja01', 'hdfdgter', 'Lorents', 'Rosesunrai', 'Dzedze', 'VBCDFDF', 'azaazagas', 'Munkhbaysgalan', 'orgilbayar', 'Enkhtaivan', 'werehe', 'Ganzo8888', 'Timka777', 'mujis890', 'werhsh', 'wershh', 'batsaihanaltan', 'Ysdbdbdb', 'Ameng06', 'Anita808', 'sunnymoon', 'Sumaasuumka', 'Nyamkanyamaa', 'serhiramine', 'ennisenni', 'ennisnni', 'enniennis', 'Lingapandi', 'D4v1dl10', 'Smarx25', 'Andr11', 'Elvisj6', 'Javuy0', 'juan946', 'Buuvei', 'Lofar2030', 'Aksel21', 'Khan3041', 'Khan2130', 'Khan1011', 'daswani', 'arkatenaarven', 'Khan1078', 'Iftikhar92', 'Lenodelai', 'Ebakumofaith', 'Irfan001', 'Tuwshuu123', 'Munkhulzii', 'Thunderbust', 'Dambaakhuu', 'Tsetseekhen247', 'aztai0117', 'hulan504', 'Dhinaaa', 'enkhbatdawaa', 'Khan212000', 'Ashish518', 'Aurangzeb68322', 'Bamgalan8', 'towshoo', 'SENJA999', 'batlhawga', 'Tseren56', 'Fathurrrs', 'Oketola', 'rian066', 'Rian006', 'Mardiya', 'Adilmurad', 'Orgio13', 'tineo86', 'Tugsuu9434', 'Mahadi016', 'MasterOneThumb', 'Adil2020', 'nhgfbgfg', 'ltmlltml32', 'Hizzyrael', 'secret6516', 'Pofedo', 'Amankhan2020', 'Bhupen', 'Khan2140', 'VebryVebry', 'QuizAAA', 'WolFFFFF', 'Denisthree', 'Ali1374', 'tarzaana', 'Labonno019', 'anonimhesap176', 'chuang', 'rasyidbtc', 'Irfan002', 'Slavchik', 'Cabdratok', 'Eboo29', 'Sukongjaya', 'RenitaSukardi', 'Ronyfalashy', 'Khan5152', 'Budi13', 'Semigiyogi', 'Sugengharjo', 'Sawahyuyu', 'Elisabeth', 'Jacksonidelo', 'Yuyuyulotio', 'Muzul07', 'bayu84', 'Surowiya', 'Khan5354', 'Kurikuntoyo', 'azertyarven', 'Jumantorodi', 'raj677', 'Mmyboss', 'Salmaniba', 'Akbajoda', 'Khan8182', 'Madanman', 'Samisamiake', 'Altaa87', 'Khan7810', 'Sumacherinde', 'Khan7820', 'Anggianjeke', 'Liliyanali', 'teriteriyaki', 'Celycheane', 'Sherifdeeno', 'Sandiori', 'carloslh20', 'Sqbrwnge', 'Erkhemee88', 'Solomon59', 'Jeyraj', 'carlosilh4', 'Khan2100', 'jiwimenuh', 'tgs05171', 'erdnbold3', 'Oogii9939', 'Bch246', 'maaama', 'Apelijah', 'Herees', 'Shaoks', 'bulgaa8021', 'Josefemeka', 'Linda88', 'Sengkala313', 'Yasarangerel', 'Bossman36088', 'ayaka0603', '181208', 'akaza0422', 'catakaza0', 'tsoomo0422', 'Eyongtubao', 'Checkmight', 'Fithandyni', 'Yawnskii', 'Susususu', 'Leo0909', 'Perdon', 'Leoteoxon', 'Aliciafor', 'damba88', 'Dido48', 'Draculd9', 'marpuah', 'Oronno016', 'javhlan89', 'Jakatarub99', 'tsetsegii', 'Anand1141144', 'Irawani462', 'Hediyana56', 'nyanyamukidi', 'Morenonasly', 'pegipegiya', 'Aprianti0', 'Bayarchimeg', 'Dirga88', 'Wulaln90', 'solofo11', 'yoteaviso', 'putntico242', 'tasmanquisimue', 'Fitrifh67', 'Akinloye', 'Hurganpanda', 'naslymenas', 'OMPOLDEWA2', 'Duajiwisnu63', 'Dukuniwan', 'juang90', 'Harahapbeto', 'Yuyumiotin', 'nuur1101', 'sujonoyojo', 'Erdnetsogt', 'Sintia382', 'Febriharsa8', 'Akintayo44', 'Udineseidin', 'Dlob0719', 'Nembebae', 'nembepokoke', 'Omashka', 'mamihe', 'Uka0407', 'Motorise', 'charoline01', 'rayqueenzhy01', 'Sleborr', 'Asif41', 'Bayuadam', 'Hamim99', 'Hamim05', 'Bilguunee0999', 'Uteran', 'Asease', 'budi777', 'Galkhuu', 'mbcjdx', 'Tugsuu9414', 'MrBekv', 'batochirme', 'Bold0416', 'nfjdjc', 'Odgerel5555', 'Munkhtuul', 'Bumbaa', 'Deborah2021', 'Davaajargal', 'abdanike', 'Mikhaeleiye', 'Turminapitri', 'Phayvour', 'Orceorobert', 'dashdawaa', 'Batnyam', 'Naiade', 'Khan3979', 'Batnym', 'mnhbt24', 'Zorigtbaatar', 'Reyfansyah', 'Remake', 'Akinkunmi', 'junioryum', 'solongosoko', 'Khan7815', 'malangbaiko', 'Uvansankar', 'Immohammed', 'lilberriexxx', 'Muthuesaki', 'Otgonkhorol', 'Josephpeskie', 'Sryapati', 'Khan7816', 'rabera', 'Oyundelger', 'Khan7818', 'Sodnomdash', 'Mhizter', 'Aecandra', 'Fanadunia', 'prayogaadhi', 'enhktogoldor', 'odonchimegdorj', 'monhbat24', 'Badma1272', 'Oyunbayar', 'Bahir12', 'z13991001', 'fabianraulr', 'Tadjer', 'Zaya12', 'kuleoyupo', 'cisse4375', 'Ilham10', 'Karmila24', 'buribukh', 'sungsongjo', 'Sokimim', 'Jangkrikirik', 'daffa001', 'virgounoyo', 'Cintadiad', 'Dirinyaya', 'Boogii1985', 'Meliani87', 'Gigintampan', 'kurowo', 'kikarasu', 'BolorBolor', 'Virgiania', 'jordanmickhael', 'Tantemire', 'Splendour', 'Mufidalzumri', 'Jephthah2021', 'Sammyjay', 'briwnblacky', 'Baikbaity', 'Carlycatlos', 'Dzubair11', 'Ferlyn1820', 'Ezege1', 'tepian001', 'Odbayar', 'Nazanas', 'Ggerel', 'Jargaiii', 'Noknoke', 'Undrakh82', 'tokiii', 'Abdulazis123', 'azertyaz', 'baynbn', 'Kidsalwa', 'Dalai09', 'Anitha1', 'Anitha2', 'wasiroh', 'Ahmedshailh', 'yohanesena', 'Solongoo01', 'Suwondo22', 'Jonykey', 'peace09', 'Kingkay042', 'Nikolasap', 'Lhagavdorj', 'Simentos', 'Diyadiya', 'Hustle023', 'sumberingin', 'Somoboto', 'Khan2190', 'Khan1180', '86199059', 'Ameng67', 'Khan7840', 'osorjamaa', 'Jetstar', 'Billy2020', 'Deon83', 'Spectre1995', 'Luqmanawan', 'mehdicoin', 'uulengerel', 'Sokoginmangar', 'Peace0247', 'bilguundalai98', 'primabarry723', 'Chantsaldulam', 'kaze56', 'subbaatar', 'hajiwarman38', 'Maven25', 'dovchko', 'mehdicoin2', 'mehdicoin02', 'syahriferdian8', 'Khan7860', 'Shurentsetseg', 'deandrafernia2', 'HuniiNer', 'Baljka99', 'Tsendmaa', 'BrunoGozzy', 'jesikairuna91', 'Hhhhqiqi', 'rekawati82', 'renitar6', 'b88087771', 'Kedai21', 'Nurul95', 'tepian002', 'tepian003', 'Choir12', 'Ameng55', 'gatotsuyono149', 'Balakrish', 'Rupat21', 'Bumbaa1996', 'Annabella', 'Tabaaa', 'sayutihaji99', 'amaraa120', 'Zaimka', 'Oochiroo', 'Fariba1350', 'Reignmarthy', 'Miansemi', 'Rupat22', 'Saharjan', 'Bdaasuren', 'Juansegale', 'Smyle88', 'yarale', 'king19951374', 'hajahdarmini5', 'Khan1360', 'Niazawan', 'suheeee', 'MEhuhd', 'rahmahanjani23', 'Kahokhan', 'Umermeher', 'sajjadyaran', 'Handrie', 'julioandri', 'NC0001', 'Sajjad1993', 'Ninjin09', 'Manikhan1', 'Zulaa27', 'Nomipanwar', 'Udahansaja', 'udinsase', 'Udinsasis', 'Hatansaihan', 'terikiyaki', 'Lairalaira', 'Wikiwikio', 'Perludiyu', 'Johnmaxwell', 'Tumantum', 'Sawaulima', 'Perrie', 'Ravshanbek777', 'Sukonsuk', 'Wasiate', 'Lemahib', 'Julijuliyt', 'Intifial', 'Aboteya', 'Surtiname', 'Wudhuhu', 'Barbaryo', 'ethmehdi2', 'Brightcene', 'Treze456', 'Sukbongsui', 'egaxl007', 'Eren69', 'Blaize', 'Martam786', 'Janyjany', 'Joyojodo', 'hhbblll', 'Johnhony', 'Sadam1990', 'Jabyiely', 'Sutiniyati', 'ton5105', 'mehdicoin6', 'mehdicoin7', 'mehdicoin8', 'mehdicoin9', 'mehdicoin1990', 'Mooko666', 'Lina31', 'muzul0', 'muzul1', 'muzul2', 'Ulzii127', 'Acillll', 'majfbj', 'mabndk', 'temktemk45f', 'mdbhdk', 'Wagiman', 'Balia88', 'ncbxhx', 'afydbk', 'goldens', 'Lumputan', 'Alizadehgmail', 'Momok57', 'Ahsanmalik36', 'Ahsankhan32', 'Mateo44', 'chicho', 'Ahsanarain54', 'Tulyrukhan', 'Tetepdemeni', 'texabmy', 'SampoernaAGA', 'Pretiprety', 'candanda', 'sauliyah', 'Bagus88', 'grand12', 'Yumanyumo', 'Dolalila', 'Yasiruni', 'Beatibty', 'Sumsumeh', 'Black19', 'Khan330', 'Ameng234', 'alfaalfa', 'ethmehdi11', 'byambaa27', 'alfabrafi', 'Khan1188', 'Ebayar', 'Francistlk', 'Ahsan55', 'Oeyekoe', 'Munhuu11', 'Melatikua', 'Naeale', 'FarhanFr', 'Anwarbugti', 'Ksunsoz', 'Fjcfjxgbdkd', 'Watiitaw96', 'Gobogan', 'Kulokulop', 'Sandagsvren', 'MrFundanga', 'artoloyo', 'Havehavi', 'Boldoo88', 'Bold88', 'Jumantojum', 'Justinnibo', 'Liluana', 'Osaroigwe', 'Raydesu', 'Ejay12', 'ahsa78', 'hggg54', 'Charlesodoh2', 'mehdicoine9', 'Bytshanaa', 'tsidiiigd', 'Erdenebayr', 'Ameng12', 'Hunbnn', 'Ameng13', 'Gerelso', 'Sana016', 'Steven123', 'Khan6091', 'bayraa99999', 'jehfhhd', 'mehdicoin1994', 'nandika', 'Jaagio', 'Phabian5', 'urururru', 'Bigbig', 'uugyguu', 'Crypto77', 'Mehdiltc1', 'Baljkaoldogsht', 'Oldogsda', 'Untung9090', 'Khajaa', 'Selvakan', 'mehdiltc2', 'Jayawiyaya', 'Suhenge', 'Tahulilo', 'Julustus', 'Esatuan', 'Josuajok', 'Timpaser', 'Williamse31', 'mehdiltc3', 'mhlimon016', 'Dustykid', 'Ameng14', 'Adiya2001', 'Yumanitop', 'Julustuiu', 'Jsswhb', 'anonimhesap177', 'Jsbsbs', 'Naresh999', 'mehdiltc4', 'Jiddjnkn', 'mehdiltc6', 'Muttynisha', 'Dikdokan', 'Teposer', 'Pikolok', 'Warasehe', 'Togsoo1331', 'Siimaning', 'Adilzaya', 'mehdiltc7', 'Praiselove', 'Ganzolbooo', 'Sumburjay', 'Kukimoki', 'Kungkungo', 'Tikikik', 'Yuyukolop', 'Kukukiko', 'Enhuule', 'Tungtungu', 'Ochkey', 'Aduhaipo', 'Jalankui', 'Ranarebe', 'Toleyupo', 'Kingviba', 'Mariamdan', 'Rester', 'Jjhjjvfujgg', 'Clinton1', 'Yogitamim10', 'Ochkey1', 'tuguldur90', 'jayasugih', 'gussentosa', 'AzamRhd', 'Rilo23', 'Rudi54', 'Msetyani', 'Turbold02', 'Indri90', 'alfabraf', 'Marisa2220', 'charliealfa', 'destagi', 'echooche', 'Annarose1988', 'Iqpal00', 'aaaaaaaaa12htu', 'serillvernita6', 'ghhdifidhink', 'putriserlina13', 'afewonline', 'italyano', 'mehdiltc8', 'Mehdiltc9', 'Ochkey2', 'Mehdimaker', 'Williams33', 'Ochkey3', 'Ochkey4', 'Mehdimakeri', 'dalai2', 'MehdiBtcmaker2', 'diipra03', 'Javavajh', 'dalai3', 'dalai4', 'Mehdibtcmaker3', 'diningrjohan', 'dalai5', 'dalai6', 'Coins55', 'Coins56', 'Coins57', 'Coins58', 'Coins59', 'Coins60', 'Coins62', 'Linusfavour', 'Coins77', 'Coins78', 'Dalai7', 'Coins79', 'Coins80', 'Coins81', 'Coins82', 'Coins83', 'Coins84', 'Coins89', 'Coins90', 'Mehdibtcmaker4', 'Coins91', 'Coins92', 'Coins93', 'Coins94', 'jcjjcjjjkvk', 'Johnmirth', 'Eegiimgl', 'Dalai8', 'Godsglory', 'mhklaa', 'herusanjaya935', 'chromium0001', 'Tohidimanpour', 'Checkeyt', 'hjkjshk', 'tsagaanbaatar', 'Ganaa680', 'chromium0002', 'chromium0003', 'Arkanrahmani', 'chromium0004', 'Damuba', 'njffjfufufufuf', 'Bathuubabu', 'Atoyoto', 'Mehdibtcmaker5', 'Geemmerah', 'Andreanius', 'Ecaeca', 'Tukange', 'Alpisa', 'Dabrang', 'Wetenge', 'jogiyogi', 'Mrnfunge', 'Jodipras', 'Wafuhadi', 'jjdjddjuufu', 'toko87', 'Acho113', 'jjjjjjjnjn', 'Cisen49', 'Tiny33', 'jueu2uehhe2', 'Ugtaxbayr', 'jwfkkjfjkwkjjf', 'Mehdibtcmaker6', 'Dalai10', 'Jajam55', 'Dalai12', 'Dddrjoj', 'undraana', 'Pldn11', 'Darmen12', 'Kuntu90', 'Pedesen', 'Hasnain7866', 'Arepanmet', 'Zooboo', 'Peacedaa', 'Wahyunigsih', 'Rayess', 'Dawadawet', 'thhrtshj', 'Jujumikuni', 'chromium0005', 'jdjf3fb3bf', 'dash0101', 'Febryrmdn', 'Pitingepit', 'Samboyoboy', 'Empritusi', 'Apaikusih', 'Bocahengpa', 'Reniwidiono', 'zakubn', 'ahuhbaai', 'hhfhfhfh', 'lutfirrahman', 'opopopopo', 'narkaa', 'nariemm', 'lamiyarahman', 'nelaiweano', 'catmunkhuu0422', 'fitrinovianti1', 'Lhagwaa89', 'Salimkhan21', 'Gfffhh', 'Lhagwajaw0', 'Tsenguun111', 'raiyanrahman', 'raiuanrahman10', 'easymng1g', 'rayan123', 'Trevor26', 'pennykamoni', 'Fddccc', 'Bek122797', 'julya14', 'Onongoo', 'yannikeketse', 'munguuhun', 'Fddhhd', 'sanibanine', 'Bontot250', 'thamibebuli', 'aoejrm', 'Erdene88', 'Esku123', 'Fffghggg', 'meofjl', 'Mamayayah', 'Rehanyai', 'Barangeyaya', 'Nomio09', 'Pokoketaya', 'Sjjdjdjd', 'bitminer1', 'Kalijadine', 'Otgonoo', 'Makasihlaya', 'bitminer2', 'hfhfhftyfytf', 'Mineralitas', 'Crossoveyaop', 'nxhdjkjkdiddbh', 'Sanny24', 'Huruharari', 'Mirnamirni', 'BTulg4', 'aqil25', 'Ffgggggt', 'Baganaashi', 'maseh44', 'Dalai13', 'Fjvtdjb', 'ihsan15', 'Fkcycuct', 'Tsoomoo1239', 'Fjfhfjh', 'Mehdicoine2020', 'ihsan147', 'Hakhamanesh', 'Ekeneme', 'hakhamaneshbt', 'Jurustrike', 'Dalai14', 'ukalaa', 'Eraatuhsi', 'easymngyoohoo', 'bitminer3', 'Kopikopiyau', 'Tokekkek', 'Angsawangi', 'Aksigentak', 'sawako1', 'Sanasainia', 'Jayjayunge', 'Amana2', 'bitminer4', 'Badmaa123', 'Darmawan88', 'tuwshuu80', 'Baskido', 'maysaid', 'Batamgalan', 'Sibit888', 'bitminer5', 'Battulga190', 'Herlina96', 'bitminer6', 'Ankhbaatar', 'teguhh44', 'Roby99', 'ucihasasuki', 'Lina888', 'gues111', 'vvree12', 'Jejejojo', 'Lina00', 'we10d060', 'anakmami44', 'NEX4BSJ', 'bitminer7', 'Babuhai', 'Aji333', 'Zayaaa12', 'bitminer8', 'bitminer9', 'Tsasaa', 'Cinta8', 'bitminer10', 'MongoliaB', 'imran333', 'bitminer11', 'Rehan8', 'bitminer12', 'siapajaa', 'bitminer13', 'Lina69', 'Jude233', 'Mendoan09', 'easymng2', 'cowogemes', 'Darkhanbayar', 'Muji33', 'Bilkabilka', 'mehdicoineee', 'raisa99', 'Ucup22', 'Orgil8999', 'Mehdiicoine', 'knesa347', 'etrustan', 'wilhero', 'Shinesarann', 'sellodano', 'kanonaledi', 'n4namami', 'hjovita336', 'candisewende', 'koketsomatlono', 'Mehdicoineeee', 'Vulinear', 'Zohonao', 'Anesita51', 'minatouzum', 'noviant1', 'udinbelerik', 'kspihsan', 'zhearasetia', 'akurapopo', 'waniperi', 'Abay07', 'Dalai15', 'winatajaenal8', 'orglkk', 'Dalai16', 'zaykama', 'Adwa56', 'Mehdicoineeeee', 'Mehdicoinebig', 'Monhoobold', 'erka88', 'Ansar300', 'erku4949', 'Baagii54', 'Dalaia09', 'Myagmardorj', 'baasan99', 'Mehdibigg', 'Roby55', 'enkuleshd', 'Sumardiyantobt', 'Balachand', 'Renunithisa', 'Mongol88', 'Sumi123', 'Msakthi', 'Kh123456', 'Powerman', 'Bilal25', 'Asmaularif', 'Sujinkutty', 'Khan7720', 'Rhpt1234', 'mehdibtcfree', 'Ohinoo88', 'anukqw', 'chromi001x003', 'Bilgee88', 'buyersmartx001', 'buyersmartx002', 'damdin', 'Anxbilguun', 'Arfkizen', 'jajajh', 'Kmet123', 'ambarpremia81', 'Arifad', 'aihauhuh', 'ajihuahu', 'monhzaya', 'Jammybillz', 'tuguldor', 'enhvvsh', 'Henry02', 'Jjpu00', 'Munkhzul03', 'Jaggongkoke', 'Ranaraniy', 'Melisa12', 'Tintokqne', 'buyersmartx004', 'goocean0219', 'Eegiibaagii', 'buyersmartx005', 'Lkhagvaa5', 'xokuna', 'Zahwa01', 'Godstime2', 'Ripon10', 'Waheed5314', 'nerkymaki', 'Tuya12', 'pitriptk', 'wendythando', 'Onyedikachi101', 'Andrandut', 'Kwjwhhkwwbsb', 'qotiwamsada', 'asddgh', 'tsetsegmaa81', 'buyersmartx006', 'orjdms', 'Mariyam73', 'buyersmartx007', 'Kqkkakja', 'Abdoulldeeab', 'temvvlen', 'khuslee', 'easymng4', 'raiyanrahman10', 'Veehidalgo', 'akibkkk', 'Siri1111', 'Epen234', 'Angilowai', 'Malika70', 'vennyriego', 'Seroddanba', 'raiuan222', 'Ibnadesola2020', 'musdhfiq21', 'mddushfiq21', 'Mushvdfiq775', 'jkdjihscdhkf', 'killerDorjoo', 'Enkule', '353334d', 'Solongo6057', 'Roby11', 'Ganzo8381', 'Oyunaa88', '3533c34', 'shuwgur', 'mushfiqb21', 'Shinen', 'Meongku', 'Trisaksti', 'osohjargal', 'idiuedeuieuikf', 'Larissa12', 'Gondrong20', 'Erhemchuhal', 'Serbumadam', 'Dlgrmaa', 'Zanuar', 'sodooken', 'jkfw4bibfir', 'Nurihsan', 'Badminton', 'Sumarni20', 'jhbyjgjg', 'Davaanasan', 'Vriego', 'Baaskaamka12', 'Mino88', 'jhbbbhbhh', 'Sugaraa13', 'Marsendot', 'Mercadejasjo', 'sobtrdne1020', 'Dawaasuren', 'fjkkjfnjrnfnfn', 'Enkhtur0322', 'Supermie', 'jkqjffjfireqhf', 'Aagii1993', 'Serambi12', 'hgjikjhhj', 'Hassan01', 'Ali12347', 'undraka', 'jambubol', 'Altaf123', 'Alireza1373123', 'matkumis', 'tantesange', 'Sugarsuren', 'Ariuka09', '86147344', 'jacob983', 'toratari', 'Katumo', 'erdenwbat', 'anakgadis', 'btcmanirawo', 'Rafaae', 'jandaboleng', 'Mniclp', 'urantogos', 'Roni32', 'Oktalia', 'Rafa111', 'Rafawae', 'Afwanae', 'Orgil22', 'Waeafan', 'sesesrsee', 'gatewere', 'Steve2001', 'Ariqtok', 'Jijgee12', 'cereezaaa', 'cunubere', 'situpu5', 'venenunu', 'Jumintenten', 'ZolbayarNergui', 'Wewe12', 'sesaxxvv', 'vocafcac', 'Sumintenten', 'Hunintenten', 'pelodude44', 'pelotata', 'Yumintenten', 'Mumbainew', 'Umbrellanew', 'Bayarbold', 'cecececr', 'lazazae', 'Harhun', 'wuawuauuuu', 'lucyyyyy', 'williams101', 'miamululu', 'seresese', 'yasminah', 'sessxevv', 'wijuhygtgg', 'nyambayr', 'wrarattt', 'sesa2244', 'rewaeawe', 'nentntn', 'binderya', 'treterer', 'sxearaw', 'Hollami', 'tsesesese', 'ekizeta', 'sietete', 'prererere', 'UmarAs5', 'UchihaSasuke12', 'AbolaMab', 'Ebrus5', 'Bananalt', 'Temuujin123', '23456uikjhgfdd', 'sdfghjjy47ojhg', 'NBFR56YHNBFRFT', 'albi1231234343', 'bfr56yhg55g5g5', 'gfr56yhbvcdr77', 'gfr4567ujhgfry', 'iqraabbas512', 'nbvfr567ujbfr5', 'Edhosanz', 'asindozunka', 'teledifara', 'Dacliff', 'Tsolmon11', 'bfr567ujnb6666', 'VFR6UJNB666GGG', 'Bayrllaa', 'Tuguldur0724', 'Mimolizard', 'Oghale5', 'dodowhat123123', 'HGFE46YHYGTTGG', 'HGFR56YNNHNH', 'Mehdi199', 'sesesterr', 'sestrer', 'bvfruj66666ggg', 'mngt67ujnbvttt', 'hg57uj6666g', 'hgr56y666gg66g', 'Preciousgal', 'H56YU6TBNJ77H7', 'VRT76TGBHHHMMN', 'shonki', 'HT56HGT567UHG', 'sevebett', 'papitieutot', 'GT6YHHYRFVBHTV', 'fluiuiyi', 'nenenrnen6', 'NBF67UJKITFB66', 'BVFR56YJI876RF', 'adriararar', 'settyeyey', 'HG67UJJU765RFB', 'MNGFR567UJI876', 'Mehdi2000', 'Hery6778', 'ceserett', 'mscscsc', 'ytser6788ytrfv', 'kjre68765rfbjj', 'erettt33', 'nenrnty', 'HGF4D34T5U6J6H', 'HIU765YTGHTHH6', 'beKKKKen', 'cereserte', 'segtte', 'hgfd67ujnki54e', 'yte456789ytrdv', 'cverertyt', 'selilujuyt', 'hger5678ijbvfh', 'hgfdfghjkoi76r', 'Destinyose', 'fddafaee', 'sshadada', 'nope96969696', 'HGFRE45HUYTGBN', 'JHGFD4567UNBGF', 'Klidmimo', 'todityry', 'lugaretere', 'Minilizard', 'GFR6YHNMK8765R', 'HTREYHBNU6RFCV', 'cerartta', 'vejo6868', 'OverPower96325', 'nocqueivoca', 'xdoentro2', 'jhge45thu76tgb', 'hge5tgbni876tf', 'vweawrawr', 'secretuyt', 'ytre56yhnj765r', 'HGFVHU7654EDCV', 'pikandfrr33', 'memrmt6', 'bigbags951753', 'Inewswanita', 'uyrfgh7654rdcv', '76cvgy7654edvh', 'Sareerdene', 'Hartatynarty', '6esxcvu765rtbn', 'Ironironi', 'bigboynow', 'u76rfvbhy54edf', 'RSZXCGY654RDFV', 'HYTREDFY654EDC', 'dodothesqodo', 'Hellaligator', 'ujyuj5678ikjgf', 'yjkl98767ujuju', 'HTRE4TYUIU765R', 'JHTR45TYUUTRFV', 'Hadson01', 'chicagonowgo', 'ngfr7uju76tgy6', 'esdghytrvhtrdc', 'JY65RFGH7FVBHG', 'UDFY65RFVBJUHN', 'ruji65edcvt456', 'hgfbnjkiy6rfvb', 'Amirbtc', 'i8765rgbnjkoiu', 'mj65rghju876tg', 'Josertel6', 'ju65rfgy65rdcv', 'iu76tfghju65rf', 'YamiNo', 'YTFVHURFCVHY6T', 'FBNJI876RFVHYT', 'olimakam', 'yfghy65rcvbhuy', 'hbnji765fvhy65', 'kelakkautelahd', '6TH7TFGYTGVBNJ', 'N76FVGY6RFGY6T', 'Omoregbe', 'YGBJU76RFVGY65', '6TGHU76TRFVBHU', 'harieooo', '6ytghu76tfvbhu', '76tfvbhu76rfcv', 'YGVBNJU76TRFVB', 'TRFBJ86RFVBNJU', '7trfgh765rfhy6', 'u76tfvbhu76tfv', 'acctesthihi3a', 'Michael0028', 'universalytas', 'Bbvvbb', 'wannie', 'Psycho12', 'Sejatikuya', 'Guardiolyka', 'torontoblue51', 'Franco95', 'Bubulayan', 'Sheikhala', 'jamelidaa', 'Puspitha', 'Ridhoahmed', 'abdulrahmanO', 'Shobihahi', 'Monkh88', 'akumau1994', 'masrapido', 'Ragile02', 'ganzo0000', 'Heeey78', 'riemiwerty', 'haoko102', 'sukatidak09', 'haosiao05', 'Flaviaferre1', 'totuugen', 'Filiberto1095', 'haoxiao089', 'pawan5yg', 'hoxiao09', 'buatdiri09', 'Troebs25', '987654320', 'pawanshresq2we', 'jambretbit', 'pHvhzjsns', 'hoxiao', 'sakitkamu46', 'Nyamochir', 'JOVEWHIP', 'Rifky0', 'ygtfdrdfghj', 'Alyaaazaa', 'Asmaularif1111', 'Skarepku1111', 'sulbad', 'Dauda12', 'Solo678', 'wegqww', 'fjfjfn', 'Gulifar', 'Thewin1', 'udygju', 'Sherzodbek05', 'msbdid', 'Brengos', 'Shuamprush', 'aguvmo', 'Harry74103', 'mahdi15462', 'Xdeuso', 'Sherzodbek44', 'waniperikang', 'Bill07', 'Matiasvallejos', 'mfjfks', 'cewedekil', 'Sheruzb7', 'Monicaamarilla', 'Aungkola', 
					'Muhammad910', 'Tudor99', 'zeusmad', 'wendybyrde6272', 'marty622', 'Dany16', 'john000', 'Daniela1685', 'htyngyyyyyyyy', 'rahayuse', 'staceyfirst51', 'fhjhfdvvvv', 'Dondivsambuu', 'mikel0', 'MGFGHCF', 'Atemay01', 'Micka12', 'Erdeneee', 'Atemay02', 'Stive55', 'Aunhjg', 'Sondko', 'Ranaranita', 'Mercy11', 'Soduhaa', 'Turuninem', 'Soms79', 'Tuyuminem', 'Pit1234', 'Star2233', 'hihiko', 'Rosieh', 'tonysalavador2', 'Ganerdene1122', 'gigiko', 'Supri79', 'rossstaylor828', 'Fikri7', 'Zombo1', 'bitminer14', 'tyliemahem282', 'bitminer15', 'Zombo2', 'Adewisdom', 'harryhari28143', 'Dgdccd', 'BITMINER16', 'Zombo3', 'Chayo555', 'brainwhat617', 'Gjbgvh', 'bitminer17', 'farukhsheikh2u', 'Orko27072', 'bitminer18', 'Ikhlaq', 'reweinshayt22', 'amandahabet', 'runarahmam', 'Dendik1982', 'bitminer19', 'leboteno', 'Fjvdhvzt', 'bitminer20', 'tvaishali697', 'lamiyarahmanrr', 'jethalalgadaco', 'binphotebogo', 'seheno', 'bitminer21', 'vinodawasthi88', 'Jsdbfbdndn', 'sennonopwame', 'bitminer22', 'daynahridika', 'Hjffjbcfjvx', 'Kacangrebus', 'palesamotlako', 'Asmaularif66', 'bitminer23', 'Kensun', 'Bananalt2', 'Hery5671', 'bitminer24', 'mahendradaas21', 'Bananalt20', 'mikaillynn266', 'bitminer25', 'Jgtrhkhf', 'bitminer26', 'robinkateson27', 'GRLT56', 'chuchasingh1', 'Hery777', 'NoviCR', 'sumayraalam71', 'myname8888', 'Williams32a', 'Uuganaa73', 'Hery666', 'hiroshinohara1', 'Hery8888', 'Rugdgjkc', 'takeshisoda8', 'Atereog97', 'Hery7777', 'Hassanansari', 'mehdii2002', 'Hery777777', 'KingBASx', 'jessiekapahio7', 'Mehdii2003', 'yusef727', 'MDansari', 'monhzulnamsrai', 'Fhishkf', 'mariahamburg62', 'wickeysage5', 'wendenselca62', 'Khan686', 'mahansijh723', 'mehdii2004', 'Williams34', 'zilvinaskorsa', 'Tirta1982', 'Imtiaz550', 'Naufal1982', 'sohailmnht678', 'Khulanaaa', 'tuhails628', 'demonik', 'nadeem5456', 'Richard8', 'Angga29', 'nmarisa', 'Mehdii2005', 'Fhftgh', 'Eggipku', 'akurapopomas', 'Artoyatyoy', 'Sumadigoyan', 'Aldiadlifad', 'activitiesbali', 'zulaauka', 'Otgondelger', 'Roby12', 'marvelous72821', 'Tamira0o', 'vikram72818993', 'mahendragupta7', 'maheshrajan772', 'arnabgoswami72', 'johnathanmarka', 'naomivilkinda', 'louisgretz', 'sagarajey778', 'davidlamburg14', 'masinosaize71', 'hfchcghg', 'devcalderon999', 'Aa6fdfb', 'Temka0124', 'Enkee88', 'Nurulnaila', 'Demonicmimo', 'thfgththhhh', 'kokolio', 'zabigg22', 'kokoloi', 'htgbfg', 'jfythtyyyy', 'mushfiq21e3', 'fakir8281', 'saifalam', 'nhdghd', 'saifalam010', 'Grandmaster', 'Bilqis1123', 'd5e7srttsddag', 'Mahery12', 'TTTTYYY', 'Asadsamsudin', 'jjbbhvhvvg', 'Marisan001', 'shaheukh7', 'terryivesgevh', 'Palangga23', 'Jodykagiya', 'ysfrystradst', 'Salmasameh', 'buyersmartx008', 'Elmacho68081', 'Tuguldur0420', 'etuu5e46egdzxf', 'agulina26', 'ghg5665', 'faizarroyo183', 'Goot0420', 'buyersmartx10', 'topeayeni88', 'miyadidi271', 'Leah1223', 'febrionline', 'ghgjkkj', 'malikakhan512', 'zabi3939', 'malikakhan515', 'joycewatmrs08', 'khamalika512', 'gggggggh', 'CDVFGH', 'Khllnnnn', 'iqrabaloch515', 'buyersmartx011', 'roseramm061', 'Ihechi', 'jhhggffddd', 'iqraabbas362', 'ajeysagar728', 'soniyakhan841', 'hhhgggjj', 'Weedspa08', 'Fhvbbh', 'Marisa002', 'Agung102', 'Ekup08', 'Tulikjon', 'Yulbars', 'fhbggggg', 'Richard1012', 'khurle', 'Ludesyakin', 'Asemkoey', 'Siliwangi', 'Diana1', 'Zanaku', 'Nartosunarto', 'Buyersmartx012', 'Lemphardeck', 'Jackjackiyas', 'Virgiawantos', 'Airez89', 'Kawaii', 'Buyersmartx013', 'ariukari', 'Blibisakumeoha', 'David123456789', 'Awasbaesira', 'Alexsis111111', 'Mngl88', 'joinchat3', 'Iskandar1', 'Lional1244567', 'Babinsa', 'Aa6guhh', 'fhddturysdzt', 'Umbrellamy', 'aviliaemo33', 'Ganbat0911', 'owa637728194', 'nyesekoeya', 'roulsindi', 'Hathateku', 'maximmckinney', 'bronsonhodges', 'esxploretr', 'BuyersmartX014', 'sorpresa45', 'Grant123', 'Beejay17', 'Bosssoss', 'Williams35', 'Byr015', 'BaronYadii', 'Mehdii2006', 'LOLBossss', 'Harzog1234', 'Dydfgf', 'DerBossBoss', 'rabenjamah', 'Adeputritbh', 'Awaludindin', 'Juliawatyu', 'Gwnggeken', 'Rebornborn', 'Sumantratra', 'Arteriateria', 'Chizara', 'nkolno65', 'Gerygeryane', 'Pasheriode', 'Jumaikaha', 'Sumacherises', 'friodemadre', 'Mahrabe', 'tunotienes67', 'recojerse56', 'cdespues456', 'tareksissemong', 'Williams36', 'Williams37', 'Williams38', 'alarmita556', 'siceret55', 'adiosmundocrue', 'yantokulek', 'Rabe12', 'maricones4', 'singaosme', 'Fitia12', 'Embermberin', 'Rezekiku', 'Biliaridun', 'Sugengdaluy', 'Uripkipiye', 'Suhenggek', 'asdfawar', 'Mahery1294', 'Makarony', 'Jurisjuris', 'Jaejaedin', 'Eksipredis', 'Protolane', 'Jirusjuruse', 'naasnanasd', 'Ngiduhibab', 'Humbleboy', 'febrianandrian', 'Otgonbayar1000', 'Maherinirina12', 'puspita1993', 'Pretusco', 'Gembur123', 'Tiyok123', 'Chayo666', 'febriana', 'Gatel123', 'Pr3tusc0', 'Gungat123', 'Maheri1220', 'febrianandriaa', 'febriii', 'Micka2012', 'Eyong123', 'Pumba247', 'anonimhesap178', 'Zombo5', 'Budi456', 'Kopotkpst', 'Nirina1294', 'anonimhesap179', 'anonimhesap180', 'Zombo6', 'anonimhesap181', 'Mah129412', 'Wunnahtwe', 'anonimhesap182', 'Ogunbayosoliu', 'Kohtwe', 'Tsm3692', 'Zombo7', 'anonimhesap183', 'Zombo8', 'Sarep123', 'Tartar', 'Zombo9', 'Dihdih011', 'Chitchit', 'Zombo10', 'anonimhesap184', 'Phoopoo', 'Mugiosaget', 'anonimhesap185', 'Ainurohmatillh', 'Baranbarane', 'Atemay03', 'Buraburane', 'Hadilpokok', 'Thuzar', 'Tarugo202000', 'tarugo202001', 'konordeaz', 'huttybel', 'tarugo202002', 'innakozak971', 'Mattxxx', 'ludninviktor', 'Alsasaya', 'konordeaz1', 'Asata777', 'Dwi12345', 'Jinkunasm', 'Udukudukan', 'Benkhalifadi', 'Aninahzakya', 'Genggekane', 'Bayibayinah', 'Saiful2006', 'Atafelix124', 'Tirta2012', 'yieldmaas', 'Sakibuag', 'jatinlehri909', 'kiritraj455', 'Naufal82', 'shammuchaterje', 'shammumukherje', 'innakozak96', 'innakozak9633', 'omijay727', 'ingdfhh', 'Naufal05', 'indarjek266', 'sikomd', 'Yesnia', 'janet526171', 'IrinaIrinaIrin', 'sallymartin281', 'cashbox77', 'Monhtulga', 'jasewise333', 'Gaukclkcl', 'wiktoradrianko', 'Gemkcl', 'mackfrison193', 'Tulga88', 'rudyboyettee45', 'Btcbabys', 'Hiennguyenkcl', 'Hohoo88', 'Njykcl', 'ebettnodd66', 'bbuykazz13', 'Xclayi', 'Njjjkcl', 'Boonoo', 'Loonkcl', 'Joexx1', 'edadeweadaw', 'clarissaoliver', 'Josxx2', 'Hockcl', 'nathanielmoski', 'Josxx3', 'Mehdiaol', 'Gaokcl', 'Fuckla', 'Dolar005', 'Josxx4', 'paagalhaikya', 'Gaukcll', 'Josxx5', 'danieldickerso', 'jhjjbhbjh', 'Mehdiiaol', 'bescahodges66', 'hjnnjhhbhhgvgv', 'Mehdiiiaol', 'Cllkcl', 'Moniksc', 'hhhhggjbbhbbh', 'Thaokcl', 'mayankagawal', 'ahidadka', 'constanciandra', 'Djhdxhh', 'Robinuthhaoa', 'Mehdiiiiii', 'Prameswari', 'sayangesayang', 'baynaa0402', 'inerfia', 'aasmidar673', 'Heliumes', 'Ryxhgj', 'aslkar89', 'Rulo68081', 'Elmacho6808', 'bilguun0311', 'Bayraa88', 'ionchateanchit', 'Tsagaan', 'metarhanacer', 'Pavilo68081', 'UsErNaMe8888', 'rantichilwjhe', 'qltowmagay', 'Pretusco1', 'ganzo2222', 'usernamee8888', 'trapermantermo', 'Skytel88', 'Pretusco2', 'Mobicom', 'Hokkkk', 'revistyletchlo', 'menangbanyak', 'cayoeuehbyd', 'esackergerubho', 'Khan7862', 'cxnine', 'Yuyiogt', 'andaisterang91', 'bequetherga', 'amsykeneyate', '26022000', 'hicengyphipa', 'MARIAEMILIA', 'rocsybell', 'robstermonti', 'Dbdvhh', 'Lailla', 'birvaniumpyanh', 'harculudent267', 'boxtrineliva', 'lspstdtd8888', 'Borditamia', 'noretrearleg', 'rockelgerpre', 'Mehdi1399', 'Radhemaru', 'temetalarice', 'iverywanstri', 'Naillla', 'ibrinderthen', 'jijken', 'jijken8888', 'repordicksie', 'nplamhenatom', 'sarnairose', 'jamphrolopis', 'edelogualpre', 'NIDHI5161', 'Alaa2366', 'acapiecoaras', 'ercharyousab', 'Alaa2352', 'Alaa2277', 'Mehdi1400', 'Alaa2357', 'septiasa258', 'Suparnie', 'Alaa2298', 'Mehdi111', 'ulagerkyonel', 'Gold8888', 'xilomatrix', 'Togoldor0413', 'admiloishant', 'rumodenviume', 'Sakimaan', 'igrackeymisa', 'utiverdiobar', 'Malik8866', 'tageignopeat', 'Maxp4u1', 'Btcrk10', 'ingeaverymer', 'Yytfrd34', 'waqaskhan9', 'uclimermanki', 'Gold8889', 'Wighte', 'stalchaypoph', 'wuland76', 'Kawitno', 'rastiliteate', 'lwayropolinf', 'Alaa2279', 'Hassanbhatti52', 'Sunardie', 'presenutwory', 'tslmnn', 'outickyulerd', 'jargal8888', 'kagerbrypnol', 'Alizadehmehdia', 'IN12D277', 'phaletaveray', 'iturehornoci', 'Shayan25', 'oentendshect', 'iquixtryphag', 'Aol1990', 'edilfiertion', 'Granatsibandot', 'thaleastorgu', 'Zombo11', 'Fannu886', 'Aooool', 'Dtexgamezzz', 'Shayan26', 'Aliytdv', 'ImScaatman', 'Kanika10', 'Wawaan', 'semphobfulu17', 'Shayan27', 'Handoko90', 'Aatir866653', 'SCAATMAN', 'IMSCAAATTMAN', 'Djdjfbfhfb', 'mshka8888', 'Rkbtc10', 'Vjdunyts', 'Dawkaaa', 'Xjxjxjxjddjxjd', 'ch1na1196112', 'hakhamaneshmeh', 'Dnjdhdhdg', 'HERUFAJAR', 'Alfidwi', 'Thinie', 'Dendy38', 'L9NI0RD3', 'Bananaalt20', 'radheshyam', 'ingans', 'Shyamradhe', 'Raadhe', 'Simbaq', 'DQRM88', 'Eyongskii1', 'RaphDomero', 'olystianas2991', 'Fuvdgla', 'cycitone28817', 'Rkmedicos', 'amplet19172', 'bedipolen8', 'sexhayb193883', 'Shayan30', 'ogeaso019291', 'logathmat29191', 'Yahooo2', 'iquixtryphag26', 'hworestak1991', 'jocielyn', 'Btcrk20', 'jelynora', 'dinogeriente', 'kevilal5161', 'Rick2021', 'Pranithis007', 'Hanedtoy', 'zsdhaus', 'Ripondas', 'Kibexoi', 'nadeemsadiq', 'asdasdas', 'Kibekganteng', 'aouiaskasda', 'azaa1234', 'Tvgjii', 'azaa4321', 'OGNuelflexzy', 'Salimtoumi21', 'azaa5432', 'OGNuelflexzy1', 'Ali136', 'YuriiVarv', 'Suhendrik82', 'Riponrt', 'Ananda445', 'Uchewest', 'MrHope', 'Btcmaker10', 'Anhbuidoi01', 'Imam212', 'AreilAreil', 'Safarudin2000', 'Nasaa05', 'btcminer888', 'minjin', 'Amerbal', 'toumio', 'Raden7', 'Anhbuidoi02', 'Yauauoq', 'SolutionKid', 'Btcmaker9435', 'JpolApo', 'Ruslan979', 'QurbGamer', 'YuriiVarvariu', 'Anhbuidoi03', 'Rewaqiq', 'bold159', 'danyalking', 'Wawan127', 'Dorothy11', 'Aymen1', 'Kallie', 'wanto6904', 'Bonek82', 'hansrajnagar', 'Yasiryssir', 'Killan2', 'Tama1406', 'Varvariuk', 'leonid11', 'Yulii11', 'GENJISAMA', 'fantom278282', 'YuraKOt', 'helik023', 'Josue1997', 'babli7371891', 'Yuliia96', 'Nominchimeg', 'Nomin1126', 'muskan456', 'cctop99one', 'Seethabala', 'muzaffar786', 'Ivankol', 'mari0lenn', 'Anhbuidoi04', 'Baburaji', 'ffffddqrr', 'orgil4878', 'Mehdikhaki', 'Mehdikhaki188', 'Varvariuk96', 'Amlakyaghobi', 'Epol0105', 'PatcybaeIrkA', 'kozaki', 'petir2012', 'Ehsansedmehdi', 'rezakhaki', 'Nanik1986', 'Klaus26', 'Artanyaghobi', 'babubala', 'Roidel', 'enkhsaikhanBT', 'Ebo1230', 'Charliee', 'Merz89', 'asadabbas123', 'Folyy2', 'Ninjingunj', 'odof7192', 'Enkhbayr89', 'Ebolzgono', 'Saymahridia12', 'Aymahridika', 'Mehdi494', 'Oppskh', 'Cointrapper', 'tumetume', 'Daniel0901', 'ChefGerlee', 'MAYA1101', 'Emilioyawnloo', 'alinach', 'sar5991', 'Ireneadler', 'Babatunde671', 'Innakozak11', 'Tume9998', 'minjee', 'Knjsbjnjuh', 'minjee00', 'Hbdudbjnbhn', 'sundaykko', 'Jvgcgjbgcv', 'ganerdene9941', 'Mehdo94', 'amagwu', 'Bananaalt2020', 'Solongo13', 'rentsen12', 'Tjengin', 'Jdnhdvhsjkdb', 'bataa123', 'fffcjkbjjjf', 'robertikin9510', 'tminjinsor7', 'jdbjfbk', 'JINGGA2202', 'JINGGA02', 'Daniel95', 'Favour1', 'Dinginnya', 'DEDYD517', 'Legitnya', 'Baajii', 'Favour1235', 'Sammys', 'tantowi1991', 'Brandon91', 'Zombo12', 'Ovealleje', 'Oleg1993', 'Drako1', 'Kaleng1991', 'Drako2', 'zhiga1991', 'Demitriy', 'Drako3', 'JulliaVsrva', 'Oogii1230', 'Dumezmere', 'vasikiv', 'semeniukole', 'Yangzhei', 'kiyosaka79', 'MrsLilu', 'ibangacyril', 'zefirka', 'Temmywealth', 'rentsenbat', 'innakozak96q1', 'Shnirovoleg', 'tourduhow', 'dogecoint', 'milocacosta02', 'jekipot', 'pinushutan', 'jujolow', 'mbenks', 'Dengerin', 'lolplio', 'Ikanmas', 'Emmy222', 'trewalo', 'BTCearner', 'anonimhesap186', 'Pasha82', 'anonimhesap188', 'anonimhesap189', 'Ehraganda7', 'Tonydarmawan', 'David00', 'idol18', 'RobertoBetanc', 'Umidjon1998', 'M13990914', 'ganiameth', 'JayV05', 'Umidjon98', 'Gabstef1', 'eboxpro', 'Sardor2013', 'Apsja171', 'Donchristo', 'BHYUGY', 'Mandaa02', 'Bunnya', 'Akbarsurya66', 'pepperito', 'Madumanis', 'nasaa9883', 'Ochirpurew', 'Kkkhan', 'Daultimate', 'yhtrfgru', 'Herizo23', 'pramana112', 'Fifi21', 'Jsugjjxh', 'Hsnkvj', 'Jshjbzj', 'Rachaelyuniar1', 'Anhbuidoi05', 'Ochir06', 'MisterHope', 'Airhujan', 'Zolzayabadrakh', 'Lintsoa', 'Dbbfbcg', 'Dbcncg', 'Rohman412', 'darshitpatel30', 'Undrah', 'ILYASA01', 'Cnchvg', 'Nyamka9961', 'Xfxsxfz', 'Louds72', 'Shxhcf', 'widiya020184', 'daitannatakara', 'Raisyah17', 'Anhbuidoi9', 'Bolor123', 'Anhbuidoi8', 'Bolor234', 'rafiulislam395', 'Cupu123', 'riazjutt', 'diadema777', 'Suryana71', 'Blancorosa', 'dkfobos01', '999gamer999', 'shohev29', 'sumarnamarna', 'Aakash5', 'Anhbuidoi7', 'dintasuminta', 'Kailash123', 'sazzzxck', 'sanusiedi', 'Bdtanin', 'rafi411', 'Tttttty', 'Aakashdon', 'Bolor02', 'HXtagh', 'Aakash000', 'huuchir123', 'saptariucup', 'Urnaa88', 'ochirooo', 'Raja0313', 'nuryamanmomon', 'test100', 'tototasdik', 'Zayaa88', 'test101', 'didingwaluyo', 'sumantonono3', 'Anhbuidoi67', 'Ectubao', 'Temuulen0317', 'sodommamat', 'Anhbuidoi90', 'test102', 'Sugartseren', 'TEMUULEN2003', 'hruprasetyo', 'Garodions', 'test103', 'ppleiik', 'cdsnkfyf9', 'EugeneT', 'Markvillareal', 'test104', 'tsetse', 'innakozak9711', 'Kiarabermejo46', 'Alfaazeez2020', 'Badawi', 'LovonaNikola', 'mymomi0480', 'Mymom0373', 'hruprasetyoaol', 'Eugenecastro', 'prasetyohru', 'hruprasetyoout', 'Bananalt04', 'Philippilapil', 'Rusyadi12', 'test105', 'Bananalt004', 'Nicolecastro', 'DorjiGyaltshe', 'Remonandhini', 'Rusdi2yq', 'j76454', 'vdajs23', 'Fofo2000', 'shhsuwyag', 'Tulga8813', 'ftxxrtyes', 'Mikaa8762', 'Altantuyabattu', 'Tukaanaa20', 'Unurmaa05', 'Bolderdenebold', 'iwans11', 'Otgoochan', 'Pvrevsuwd', 'Hope12', 'Hfjvdjb', 'sjsh221', 'Kondomi7', 'Jfjvhvh', 'LindoX94', 'ytcdr55s3s3e5s', 'Khan7836', 'boldoobolderde', 'dt6sr5se5sr5sr', 'Fbdnhfbfh', 'Egshin', 'yfdrs6se56', 'Dalai20', 'Boyo88', 'rstysrrtsrs', 'baynaabayna', 'Mongolcomposer', 'r6rdye64trsetz', 'mrgeger19', 'xtrse5r5se5s', 'Akbarsurya11', 'tithytx', 'ctysr66rsae5ss', 'trxse5rsse', 'Muharjum', 'Alyoda', 'Azaa821', 'Mrgeger22', 'NaufalSabil', 'Redex2020', 'jumraeni', 'Batireedvi', 'hakim202', 'Dalai23', 'Otgo0417', 'Chinyere1234', 'Dalai22', 'samcor', 'Dwisusanti', 'Dalai24', '94353436', 'Yoda030318', 'Dalai25', 'Dalai26', 'Boldoobolderd8', 'darshitp0576', 'bataa2', 'darshitp562', 'buyka0915', 'Manuel12', 'ETUBAO', 'cici48', 'Nyamsambuu', 'ALPHONSEKAK', 'Uchral322', 'Nymdawaa', 'Bxoom0409', 'Zolzaya123', 'ShyamYT07', 'Shairajoy', 'Manjin', 'Low4033', 'Urakotshopik', 'Nikalovin', 'Hongoroo', 'Bacokuttu', 'Batceceg', 'rfxassdzly', 'Nikolaunik', 'unknowpoeple', 'Monkhdesu', 'aritawy15', 'rfxassdzly2', 'rfxassdzly3', 'Stsalma', 'Muhammadirvai', 'Nikolanj', 'aritaaa', 'Jay4033', 'Erdembileg', 'angaaxai', 'Baaataraa', 'Temuulen18', 'Ningsih12', 'Earn4033', 'Temuulen12', 'Sana4033', 'ochirbud', 'Temka23', 'Jota2020', 'Meysi12', 'Lhea4033', 'Mustadiran', 'Jota97', 'nurwakhid', 'Jotadjx', 'fauzanaa', 'Tinatunn', 'Dedy1899', 'Jota2021', 'Nayaka84', 'Jota2201', 'SHIVANKGupta', 'Josue97', 'Yuliayuanaya', 'Jo1997', 'Maspedet', 'Tuannayaka', 'Yuzhong', 'Jayengrana', 'SHIVANk', 'SHIVANGUPT', 'RahulYadav', 'Adeshola1988', 'Collinskev', 'Yuanah', 'Kam939', 'Saryuon', 'Kirill4556', 'Iwan45o8', 'Dima565444', 'Dima45665545', 'Iwan45839', 'Maheswari01', 'Abdul2383', 'Ibrahim123001', 'Mehdi490', 'PreciousD', 'Mehdi491', 'Asfiya', 'Lindaaafriani1', 'Lol1233', 'Mehdi492', 'Lolshhseh', 'Quensya', 'Mehdi496', 'ahmedohed', 'toogii12', 'Gold54', 'Ahmedwhied', 'beagold', 'Thegalliums', 'Apochi68081', 'Emperormujeeb', 'Petra68081', 'Kotshop', 'Boltunov', 'Zedbazi', 'Ibrahimolawale', 'Lia4477', 'Hambaalloh11', 'Gulijonbek', 'Ambar760', 'Yulbarsjon', 'Ambar1983', 'Yudiwahyu', 'Cionaool', 'JR0725', 'Bilguunbna', 'HariYT', 'Nikolaud', 'Aldialdo', 'Kozmai', 'Coine10', 'Meghiche', 'Kislovsia', 'Mehdicoine11', 'Mehdicoine12', 'rizkipribadi', 'Mehdicoine13', 'Coine15', 'Yohasaputra', 'Aziz786', 'andytyson88291', 'mehdicoine16', '18111182011217', 'Hikmatulloh', 'Coine17', 'Ika180818', 'Heni999', 'Dashka111', 'Zulaikha412', 'Yutboshni', 'Lollipop8888', 'Suroj76', 'Dyroth', 'Zedbazicoin2', 'Rizwan1khan', 'Urgamal', 'Foziljonov', 'Pishraft', 'sr56rses5', 'Hikmat1520', 'har85d7e5d764', 't774sr6s', 'Foshkiripiri', 'w5d74s61trs', '728gvahgat6u', 'gajar2881', 'Shamol2030', 'w75dwd574d7', 'q5rs56s4a36', 'Khaldi72', 'hw7wheuuw7w7h', 'e6a5aeea5ea5', 'Kharred72', 'w46e5aeat5w35a', 'balmiki8', 'bhanga7a', 'sota66666', 'Nasreen', 'ae53ea5w35', '5sea53etasrrsy', 'Sammu72', 'Andy666', 'sryets6s4rs6', 'Kherlenbaatar', 'Louiscarter67', 'Tie0193', 'Alfadafa', 'palatae529', 'zabiw9lawiya', 'Danannana', 'Andre416', 'Ghohlyfj', 'nxsnhamamansbs', 'Paratermert333', 'dnanjadja', 'kaal028', 'satekerang', 'rtarst6e4', 'Mongolohin', 'Nikmok', 'Figicuo', 'Andymaryady', 'Xbzfhhah', 'Marty819', 'namuun88', 'yeild8919', 'Jawon0999', 'Dindaayu', 'Bigbangcoin', 'nurwakh', 'Byebtcoin', 'Alphanurmic', 'Bolongbolong', 'naiminhwh', 'btcfreecoin', 'ay7w8uqhq', 'qwerty8888', 'yewwp0w0w', 'bgyst87tfc', 'Freeecoin', 'tue6e5y4s', 'koleak', 'gabrielkhan', 'utws464w6', 'rya4w6w46rsy64', '53a54s', 'btcfreecoin2', '64wtw3', 'iwansukmawan', 'rysa464a6', 'eat5a3w36', 'Iwansukmawan12', 'w354w535w', 'parsha', '6sre46ysr', 'aeteat', 'ytstsryfx', 'Listzbach0728', 'tyesryysr', 'Btcfreeeecoin', '6sr64esrysry', '63a3tatae', 'gszaeyyse', 'Jeevakannan', 'Olalekan5264', 'Btcfreeeee', 'Jeevajeeva', '7d5ysryrurz', 'zesstore', 'rtsts44at', 'ranggafajar', 'gege3000', 'tayab123', 'Haja8wwg7', 'hauia8a', 'pep789', 'Battumur000', 'terryives00181', 'TailorMartins', 'Dxb2005', 'Moomoo88', 'Playerbtc', 'rfajar', 'musicmate', 'imace02', 'Playerrbtc', 'ahmad289', 'Sun5544', 'Coinplayer', 'Sulantara', 'Playerbitcoin', 'ksa2008', 'bpk2009', 'Nelzia999', 'bpk2019', 'NadirAli', 'alfimaulani', 'Gatsuurhan', 'BayraaBayr', '6rs5easet', 'tcurs6sr6rsy', 'PercayaTuhan', 'Lofar7869', 'ytdyrseta', 'TuhanMahaAdil', 'tudrs6sryzey', 'srtea5se6rst', 'Rehan1Khan', 'tdzae64', 'Ayelojajnr', 'sry6rw3w6sryrs', 't7edrusrudru', 'rs663weaysry', 'rtsew5w36', 'seta5estxdy', 'Suugii8888', 'se5ea5srysfyfs', 'usr6r6ssr6dt7', 'rysae6sxtu', 'Rehan2Khan', 'tf7dt6srydsyrs', 'Julietz', 'erikredboy', 'Dari34', '6rs46ee6rsr6', 'xyrs64e6rs6sr6', 'dtsee55ewsrydy', 'Estherzt', '5sea35tesxfyyx', 'tsdea56srdtu', 'Yolka88', 'trz6aesr6sr6sr', 'rtx5se5sersy', 'e5s5se5setr', 'Ghasam', 'tsee46udtsruxy', 'bahiaiaao9as', 'aaysus8s', 'ysrysexryxfy', 'Baasansuren', 'Zainsaloon', 'Monkvvsh', 'dtx6ses6rsxtu', 'Coineeee', 'fcud6t7errs6st', 'Zabidii', 'tysse6wryssryu', 'yrs6refxysr6s6', 'dewifortuna', 'rsysr5es6sryxd', 'yfs6raw46sfyry', 'Kikisukriadi', 'xtuudrudtdti', 'srysetysr', 'ydzseyse6rs6', 'tsuer7rs6sry', 'Janet56z', 'Sukriadikiki', 'Watermelon1', 'xtyrs65seets', 'Apieceofcake', 't6dsr66rsrys', 'Rain22', '5sr5es5sexet', 'Ikahatikah', 'txdsryr6sysr', 'fsurysyradzg', 'Grazep1', '6sr4a6etset', 'Sitimulyanah', 'jejfhjhfhjfhwh', 'taesry5e7sth', 'tdysr63w5rst', 'sryea5dxyxdy', 'Sitirositah', 'tesysesdysfg', 'fwbfkdbfbr', 'nbhbjdbvbhhbh', 'jrbjbabjfdbhjb', 'Suhbat54', 'Rositahsiti', 'Fanuoluwa1', 'jddjjdjdjdbhb', 'Batj55', 'jakbfbjhbfhf', 'Sitirositahh', 'Dewajudi', 'ahmedohedyahoo', 'Smulyanah', 'Elizabt', 'lofark586', 'Smulyanahh', 'Prieto68081', 'Vellasamy', 'tgs77777', 'Zhoped', 'btugsuu15', 'Arshad689000', 'Jagaa9911', 'zeeshankhan22', 'Enkhee1286', 'mencobabertaha', 'rogernauarta', 'akukamusip', 'ulaankhuu', 'Ganzo9911', 'Qweuyt', 'Ahgfds', 'mehdicoine18', 'Rtyufs', 'abdurrehman22', 'Kjhgfd', 'mehdicoine19', 'Dfhutr', 'Badewole3', 'Fhyres', 'Hfdshu', 'Gilmax1995', 'Gjtswk', 'Mehdicoine20', 'Gaabii', 'Jhfdsa', 'mehdicoine21', 'shufyaba', 'mehdicoine22', 'Gjyfds', 'Rhkgds', 'Jhfdrt', 'Rhfsai', 'Gjiesv', 'Hgdswr', 'Hrgodr', 'Usncxz', 'Vsujda', 'shankhan', 'abdurrehman23', 'Malikwadood', 'mehdicoine23', 'mehdicoine24', 'mehdicoine25', 'Maxgil', 'Nathansampai84', 'mehdicoine26', 'Mehdicoine27', 'doit78878', 'fundidier', 'scoscotimber', 'fysre646wrta', 'tea35wre6srytz', '57ere6sr6sfydz', '5srr6syrsrsyrx', 'esesttdzyxd', 'Hairaa8888', 'rs6sr6edztetz', '36wreysrrxy', 'etse6s6seyrx', '5ese5s5srxet', 'dtz5aeae5se5', 'dtz5a3aetset', 'tezea54s6rxyyx', 'teza35sste', 'Chance021020', 'tzee5a3s5estys', 'tzee5ssetxet', 'tezs35se5ext', 'tdea5seet', 'tzetsese6r6s', 'e5sse55estes', 'se6es5s46rys', 'Zayalove', 'trsset6srxte', 'yfxyxrxry', 'zdt5sea53est', 'jibanai8s', '6rs4yfxsr6rsy', 'aarti78282', 'tese5s46ssryrx', 'tesse5dxtdxy', 'tezea5settrx', '6srrs5rs6', '6rs5s3rstyrs', 'fxte5sest', '6rs5setes', 'zet5w3se6', 'xdtea55a3es6', 'ydzse66srx', 'dyz6see6s', 'tzdse564srs6', 'ets5sedxtexy', 'yrs4s6es6tdxtd', 'yxrse6e5sste', '5srs6ees6xdyyx', 'tex388291', 'yrs6easryxdy', '63ss36rysfuxfh', 'ndjdis7auaghwe', 'TSEEGII8888', 'bdisia8asa', 'tzeea5settse', 'Tseegii2838', 'djusisisa', 'tdyes4s6setdt', 'fyx35atsr', 'eldiyandi', 'snsuiss', 'srtyzeyxrdxy', 'pelepah', 'sr6e6stxdrxygx', 'dzttsetsrr', 'tea36qazdgzyd', 'xdtsrtr6stsr', 'Badam0922', 'tsrtestzedzt', 'xyryrs6rdrxyxr', 'hdheu7w8woskma', 'justin2819', 'Soeloo', 'Butt100', 'yogaml', 'crazjockey', 'TudroMarl', 'DonAetre', 'Aheiwjaia', 'RonnieMehta', 'Jaykumar018', 'porteinjakeo9', 'sweedlepipesli', 'wrestlingabort', 'Mary500', 'hjvhscsvava', 'Appa671819', 'theredox', 'ShAtre57181', 'PuchNa7', 'wahyudin016usn', 'North6281819', 'Luqman4', 'Enhtsetseg454', 'Enkhtseteg555', 'Hafiz2929', 'Batuka888', 'Uurtsaikh', 'Tuhailsshankar', 'RaviOp', 'Javier671', 'Raghav571', 'Jost61781', 'UjiaUa71', 'Uijvendr671', 'Suresh271', 'Malikkashif', 'MsDickems', 'tyabcwomjafd6', 'Bumrah7728', 'Alexbn', 'kawww222', 'sadddde', 'Bachaale9', 'itnijaldi8', 'Danikaya01', 'YahaiKi', 'NayaDrama', 'AurAchchi', 'Tee51771', 'Partenr62', 'emujin', 'DosiQelcome9', 'ehueue6uwh', 'AisamatBolna', 'AadhiBaat', 'Bainita671', 'dubtekotinka', 'DlekhLiya', 'SethJi777', 'Dilkibaat', 'UnoNarazgi', 'ShampooK9', 'ihhair', 'Pho888889', 'jimmewaari', 'Achooali', 'vigatwaar', 'Panchayat', 'YeBatani', 'Milakarmila18', 'REDWAALA3718', 'GhanshyamaMuku', 'raggamuf', 'totoro13001', 'Hildakaya01', 'Annakaya01', 'tiaramanda', 'Mongoo88', 'Ochir2', 'Ganzorig888', 'bsingdep', 'hoda44444', 'samyy555', 'Coinaol', 'Mehdicoinaol', 'ahlam7777', 'Jia668', 'lyan444', 'Viva666', 'jima78787', 'Der441', 'irfanajmal', 'YAKAMATA', 'Sajukhan', 'Kila006', 'HAMOTAA', 'Rembrant', 'TAMUAA', 'Sajjadalikhan', 'Bilegdelger', 'momoana', 'saslaww', 'Yasin2020', 'Yasin2030', 'Utamajaya12', 'Akash188', 'Yasin2040', 'Tamatama12', 'Nayed5604', 'Akash912', 'Akash1888', 'Remyboy', 'Abangganteng', 'RaulRmdn', 'Utamakansehat', 'Luffy1', 'Garp24', 'Milanisa', 'Irfanirfan', 'Baasanbayr', 'Milanisaaa', 'irfanajmal21', 'Roni2390', 'Prince7', 'Bapakkaya01', 'asif888', 'Riya9023', 'Roni2000', 'arif555', 'Tanvi999', 'Rizalpratama', 'ronybabu186', 'asif666', 'Muhammad0121', 'asif111', 'zolkuushka', 'ganboldkpmlo', 'imtiazkhan', 'Altanerdene67', 'rofldamn0522', 'Munkbaatar', 'Paullinus', 'Tanvi990', 'Ganuuk', 'jamka1998', 'yelenny1', 'Mmiigaa', 'z13940919', 'Kanuchukwuemek', 'Rawdan', 'Alicebirderlan', 'Luchka', 'Solojinwoo0527', 'Ynjinhanddulgu', 'Zankyou', 'Bsnsrn', 'Bradleybeal', 'Sokono', 'damn0522', 'damnrofl0522', 'Btcblink', 'arf1001', 'Bebert', 'Flereut', 'Maildochi', 'Ninfula', 'Amirbtc2', 'munang2408', '0522rofldamn', 'Geasaa', 'Homer09', 'Amirbtc3', 'kowalczuk23', 'articmm1005', 'Amirbtc4', 'munangs2408', 'Trezor', 'tender', 'reverie26000', 'munangs24', 'Btcblinkk', 'kevinbelez', 'Bihoot', 'Ako123', 'Amnaaa', 'guillaumereglo', 'Billyese', 'Tanvi9998', 'Radit07', 'Tanvi99912', 'Tanvi9993', 'Munkhtulga20', 'Nikolk', 'tatan2525', 'ivanmalai97', 'innakozakghh', 'SalisburyWood', 'lhamuk', 'CandraJN', 'Cusopro', 'Cusitopoo', 'CusoReypro', 'angarmaa', 'Tariqaziz390', 'Oboma06', 'Batbayr80', 'Eegii88', 'Name88', 'needmoney', 'zoroplex', 'plexuyy', 'quang81', 'Donsteve', 'Sajid123', 'makeupodko', 'Tsogoo247', 'drihadinata', 'Terbishii', 'BulgaaBatsaan', 'Munkhorgil', 'Baatartsooj', 'LBilguutei', 'Wahid10', 'Bilguundalaial', 'Bayar1112', 'Solongo0805', 'anhzaya0211', 'Adeoyy', 'adea72866', 'BaynBayraa', 'Yoan1998', 'zinukiller', 'Uitvmen', 'pvvjee', 'Sivaraju', 'Mokota', 'Batuush', 'Ade756', 'Fitryas', 'Eyafirti', 'Fitryanti', 'Adeagus', 'Olawale0029', 'hestiyuli', 'uyyadeap', 'Dennis05', 'Baagii999', 'Krist099', 'franck42', 'Divine333333', 'Persephony999', 'Dencio999', 'Kayleen999', 'Charles999', 'Denzen99', 'Denz88', 'Mine888', 'Mean6666', 'Tahir841', 'HassanAkbarBHH', 'Tuukapi10', 'SANCHIRBOLD', 'Innodino', 'Sangkala313', 'pusathitam', 'ukaaaai', 'Milay222', 'Pink2222', 'Blue2226', 'Hamim001', 'Yellow888', 'Thomas15', 'Aryasalok', 'Khalifalurd', 'Denikan', 'LuckyQueens', 'Gleene', 'Lucky01012021', 'carlosgarcia', 'Abdeemalikhan', 'gold0522', 'Kurniawanput', 'MTalha', 'Kuniawanx', 'Saruulsanaa', 'Mzwakhe261', 'cbt3miningbtc', 'Suhbat123', 'Nwafo01', 'Saagii1995', 'susiyana', 'btcminingcbt1', 'bbevizoma', 'Hassanma', 'Munhgerel', 'akida1120', 'Naranchuluun09', 'Santez', 'aidamateo', 'gantu0121', 'Santego', 'Negruana', 'Amar16', 'Niteealee', 'Dianaguut', 'themars', 'Badaka', 'Haider103', 'aidamateo1997', 'Ttuk88', 'martveb', 'Btcminingcbt4', 'Canteens', 'Madufor', 'Bakibeast77', 'Greeny22', 'UroojAli', 'Naman6562', '8537Namu', 'didar1', 'shashi889', 'PANKAJ4582', 'UroojMalik', 'baboo22', 'justynaponierk', 'Bhullar88', 'Rinto021', 'Rintojr021', 'Rintor021', 'Rintorachmadi1', 'Rintorachmadi2', 'Rinto1', 'Rinto2', 'Rinto3', 'AliShafique', 'farhan260', 'Marlina1', 'Tumbal1', 'Tumbal2', 'sidra31', 'Agbaravictor', 'Rintomr1', 'Rintomr2', 'Rainto1', 'Preston71', 'Jakkaksk', 'Sameerk', 'FarzanaAslam', 'Guhibbbiv', 'Hbobibbb', 'Uvvuvkvvkkv', 'Hjjffhjkj', 'Mantep001', 'Ajoy22', 'Rian0622', 'Pedroniel', 'babar786', 'Krvinn', 'Awaisyamin', 'Aftariscy', 'Aftarifcy', 'Sofrimahkota', 'Mahkotasofri', 'yudialif', 'apkermaman', 'Apengs', 'Sakaumild', 'Sakaumild1', 'equinooxx', 'Mintakduit', 'equinoxz', 'equinoxx', 'btcmild', 'Oyokracing', 'Cuwawaw', 'Apenks', 'Tuyuls', 'equinoxsz', 'exuinooxz', 'exuinoxxz', 'harishasbuloh', 'ipankushendi', 'asepjamal', 'dedemulyadi', 'ruswandisingku', 'Rkbithash', 'ch9526981', 'Mildbtc', 'Comsarung', 'Lampulampu', 'Ntahntah', 'Marketbtc3', 'Wamabihi', '4913119', 'darshitpatel73', 'agnieszkaguzie', 'Hash46', 'sagharhagram', 'Bettymolles', 'Gol13991030', 'widi4nt0r0', 'Bjjutt', 'magnuslesson', 'BABU1976', 'eristofo', 'Srdvii', 'Miftah23', 'umerriders', 'anggraeniyeyen', 'Lukadin', 'Kamala5500', 'RunUkraine', 'Nik246', 'hunterbtc', 'Coinkota', 'Vladislavichus', 'Clifsy78', 'Doniyor6868', 'Surjeet143', 'galunggung', 'btcdeen', 'Yadiblondenk', 'BEGARAGE01', 'TORAbit', 'TONIbit', 'Joseph29791', 'AKUbit', 'Romamaniez', 'samira7aal', 'Krkbondbtc', 'RkBitBet', 'Hashpick', 'Bondhash', 'Bitpkm', 'Ttdbcoin', 'Kotaloot', 'Krkmining', 'zaeem12321', 'Bitbethash', 'htmf0101', 'destikanto', 'mandhi', 'manady', 'manikjaya', 'Rinnbits', 'Hashloot', 'moneymoney1234', 'yuwangyi', 'movie2hot', 'childsemperor', 'fadlan92', 'Sonia12345');
				$user_name = $rand_names[rand(0, count($rand_names) - 1)];
				$user_id = $this->User->check_username_already_exists($user_name);
				if($user_id == 0) {
					$password = $this->create_random_key();
					$user_id = $this->User->insert_new_user($user_name, $user_name.'@gmail.com', password_hash($password, PASSWORD_DEFAULT), 0, '192.168.0.1', '', 'NULL', '', '', '', '', '');
				}
				$amount *= $this->UNITS_PER_COIN;
				$request_id = $this->Request->create_request($user_id, 'Withdrawal', $amount, $address, $txid, 'f');
				if($request_id != 0) {
					$this->Request->complete_withdrawal_request($request_id, $txid, 'f');
				}
				break;
			}
		}
	}
	
	public function process() {

		$action = $this->input->post_get('action');
		
		///////rate limit///////
		$waiting_time = 60;
		$cookie_lifetime = 60;
		$num_allowed_requests = 5;
		$max_request_interval = 20; //miliseconds
		$uid = 0;
		if($this->session->userdata('user_info') !== NULL) {
			$uid = $this->session->userdata('user_info')->user_id;
			if($this->session->userdata('user_info')->total_deposits > 0) {
				$waiting_time = 10;
				$max_request_interval = 10;
			}
		}
		
		if($this->session->userdata('last_processed_time') !== NULL && $this->milliseconds() - $this->session->userdata('last_processed_time') < $max_request_interval) {
			if(!isset($_COOKIE['request_count'])) {
				setcookie('request_count', 1, time() + $cookie_lifetime, "/");
			} else {
				setcookie('request_count', $_COOKIE['request_count']+1, time() + $cookie_lifetime, "/");
				if($_COOKIE['request_count'] >= $num_allowed_requests) {
					setcookie('request_count', 0, time() + $cookie_lifetime, "/");
					$this->Log->create_log($uid, 'Too often | Time: '.($this->milliseconds() - $this->session->userdata('last_processed_time')).' | action:'.$action, $this->get_client_ip());
					$this->session->set_userdata('last_processed_time', $this->milliseconds());
					$this->session->set_userdata('temporarily_banned', time() + $waiting_time);
					echo json_encode(array('ret' => 0, 'mes' =>  $this->lang->print('connection_timeout_err')));
					return;
				}
			}
		}
		$this->session->set_userdata('last_processed_time', $this->milliseconds());
		///////rate limit///////
		
		//lock user row
		if($uid != 0) {
			$this->db->trans_begin();
			$has_transaction = true;
			$this->user_info->balance = $this->User->get_user_balance_for_update($uid);
		} else {
			$has_transaction = false;
		}
		//lock user row
		
		try {
			switch($action) {
				case 'signup':
				$this->process_signup();
				break;
				case 'login':
				$this->process_login();
				break;
				case 'login2':
				$this->process_login(true);
				break;
				case 'recover':
				$this->process_recover();
				break;
				case 'verify_email':
				$this->process_verify_email();
				break;
				case 'logout':
				$this->process_logout();
				break;
				case 'claim_hourly_faucet':
				$this->process_claim_hourly_faucet();
				break;
				case 'claim_bonus_faucet':
				$this->process_claim_bonus_faucet();
				break;
				case 'dismiss_notification':
				$this->process_dismiss_notification();
				break;
				case 'claim_commissions':
				$this->process_claim_commissions();
				break;
				case 'apply_gift_code':
				$this->process_apply_gift_code();
				break;
				case 'change_password':
				$this->process_change_password();
				break;
				case 'change_password2':
				$this->process_change_password2();
				break;
				case 'enable_2fa_code':
				$this->process_enable_2fa_code();
				break;
				case 'disable_2fa_code':
				$this->process_disable_2fa_code();
				break;
				case 'disable_2fa_code2':
				$this->process_disable_2fa_code2();
				break;
				case 'change_privacy':
				$this->process_change_privacy();
				break;
				case 'change_commission_share':
				$this->process_change_commission_share();
				break;
				case 'withdraw_bnb':
				$this->process_withdraw_bnb();
				break;
				case 'cancel_request':
				$this->process_cancel_request();
				break;
				case 'send_message':
				$this->process_send_message();
				break;
				/*case 'show_withdrawal_label':
				$this->process_show_withdrawal_label();
				break;*/
				case 'check_address_verification':
				$this->process_check_address_verification();
				break;
				case 'bet_multiply':
				$this->process_bet_multiply();
				break;
				case 'bet_game_dice':
				$this->process_bet_game_dice();
				break;
				case 'bet_game_ultimate_dice':
				$this->process_bet_game_ultimate_dice();
				break;
				case 'change_client_seed':
				$this->process_change_client_seed();
				break;
				case 'bet_game_gems':
				$this->process_bet_game_gems();
				break;
				case 'select_tile_game_gems':
				$this->process_bet_game_gems();
				break;
				case 'cashout_game_gems':
				$this->process_bet_game_gems();
				break;
				case 'bet_game_slots':
				$this->process_bet_game_slots();
				break;
				case 'bet_game_mines':
				$this->process_bet_game_mines();
				break;
				case 'select_tile_game_mines':
				$this->process_bet_game_mines();
				break;
				case 'cashout_game_mines':
				$this->process_bet_game_mines();
				break;
				//mines auto
				case 'autobet_game_mines':
				$this->process_bet_game_mines();
				break;
				//mines auto
				case 'bet_game_keno':
				$this->process_bet_game_keno();
				break;
				case 'bet_game_poker':
				$this->process_bet_game_poker();
				break;
				case 'deal_game_poker':
				$this->process_bet_game_poker();
				break;
				case 'bet_game_baccarat':
				$this->process_bet_game_baccarat();
				break;
				case 'bet_game_hilow':
				$this->process_bet_game_hilow();
				break;
				case 'open_card_game_hilow':
				$this->process_bet_game_hilow();
				break;
				case 'cashout_game_hilow':
				$this->process_bet_game_hilow();
				break;
				case 'bet_game_roulette':
				$this->process_bet_game_roulette();
				break;
				case 'bet_game_wheel':
				$this->process_bet_game_wheel();
				break;
				case 'bet_game_plinko':
				$this->process_bet_game_plinko();
				break;
				case 'bet_game_limbo':
				$this->process_bet_game_limbo();
				break;
				case 'bet_game_tripe_dice':
				$this->process_bet_game_triple_dice();
				break;
				case 'update_deposit_transaction':
				$this->process_update_deposit_transaction();
				break;
				case 'complete_confirmed_request':
				$this->process_complete_confirmed_request();
				break;
				case 'update_last_copied':
				$this->process_update_last_copied();
				break;
				case 'switch_light_dark_mode':
				$this->process_switch_light_dark_mode();
				break;
				case 'change_language':
				$this->process_change_language();
				break;
				case 'change_email':
				$this->process_change_email();
				break;
				case 'save_strategies':
				$this->process_save_strategies();
				break;
				case 'verify_pcaptcha':
				$this->process_verify_pcaptcha();
				break;
				default:
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('invalid_input_err')));
				break;
			}
			if ($has_transaction) {
				$this->db->trans_commit(); //commit transaction
			}
		} catch(Exception $e) {
			if ($has_transaction) {
				$this->db->trans_rollback();  //rollback transaction
			}
			$this->change_server_seed();
			echo json_encode(array('ret' => 0, 'mes' => 'Unknown error!'));
			return;
		}
	}
	
	public function process2() {
		$action = $this->input->post_get('action');
		switch($action) {
			case 'deposit': 
			$this->process_deposit();
			break;
		}
	}
	
	
	public function postback() {
					
		// promotion event
		date_default_timezone_set('UTC');
		$promotion_event_start = strtotime("June 5 2023");
		$promotion_event_end = strtotime("June 11 2023");
		if(time() > $promotion_event_start && time() < $promotion_event_end) {
			$promotion_event = true;
		} else {
			$promotion_event = false;
		}
		// promotion event
		
		/*if(strlen($this->input->post_get('user_id')) !== strlen((string)(int)$this->input->post_get('user_id'))) {
			echo 'Invalid User ID';
			$this->Log->create_log(0, 'Detect survey fraud user_id #'.(intval($this->input->post_get('user_id')) - 123456), '');
			return;
		}*/
		
		
		$site = $this->input->post_get('site');
		switch($site) {
			case 'cpx_research':	
			$user_id = intval($this->input->post_get('user_id')) - 123456;
			$get_user_info = $this->User->get_user_info_by_id($user_id);
			if($get_user_info != null) {
				if($get_user_info->disable_survey) {
					echo 'Invalid user!';
					return;
				}
				$user_name = $get_user_info->user_name;
				$status = $this->input->post_get('status');
				$trans_id = $this->input->post_get('trans_id');
				$amount_local = $this->input->post_get('amount_local');
				$amount_usd = $this->input->post_get('amount_usd');
				if($amount_local > $amount_usd) {
					$amount_local = $amount_usd * 0.55;
				}
				$offer_id = $this->input->post_get('offer_id');
				$hash = $this->input->post_get('hash');
				$ip_click = $this->input->post_get('ip_click');
				$BNB_price = $this->BNB_price;
				$earning_amount = $amount_local * $this->UNITS_PER_COIN / $BNB_price;
				
				//promotion event
				if($amount_local >= 0.05) {
					if($promotion_event) {
						//$earning_amount = $earning_amount * 1.2; //(bonus 20%)
					}
				}
				//promotion event

				$get_servey = $this->Survey->get_survey_by_trans_id($site, $trans_id);
				if($status == 1) {
					if($get_servey == null) {
						$this->Survey->create_new_survey($user_id, $user_name, $site, $trans_id, $offer_id, $earning_amount, $status, $ip_click, $amount_usd);
						$updated_info = clone($get_user_info);
						$updated_info->uncredited_survey_rewards += $earning_amount;
						$this->User->update_user_info($get_user_info, $updated_info);
						$survey_reward_amount_today = $this->Statistic->get_statistic_by_date('survey_reward_amount', date("Y-m-d"));
						$this->Statistic->set_statistic_by_date('survey_reward_amount', $survey_reward_amount_today + $earning_amount, date("Y-m-d"));	
						if($amount_local >= 0.05) {
							$this->Notification->create_notification($user_id, 'You have completed a survey from CPX Research!');
						}
						echo 'User completed a survey (Publisher Commission '.$amount_usd.' USD!)';
						
					} else {
						echo 'The transaction has been credited';
					}
					
				} else {
					if($get_servey != null) {
						$this->Survey->cancel_servey($site, $trans_id);
						$earning_amount = $get_servey->earning_amount;	
						$this->Notification->create_notification($user_id, 'Your survey is rejected!', 'danger');						
						echo 'Cancel previous survey!';
					} else {
						$this->Survey->create_new_survey($user_id, $user_name, $site, $trans_id, $offer_id, $earning_amount, $status, $ip_click, $amount_usd);
						echo 'User is screened out from survey and get no Bonus!';
					}
				}
			} else {
				echo 'Invalid user!';
			}
			break;
			
			case 'timewall':
			$user_id = intval($this->input->post_get('user_id')) - 123456;
			$get_user_info = $this->User->get_user_info_by_id($user_id);
			if($get_user_info != null) {
				if($get_user_info->disable_survey) {
					echo 'Invalid user!';
					return;
				}
				$user_name = $get_user_info->user_name;
				$status = 1;
				$trans_id =  substr($this->input->post_get('trans_id'), 0, 36);
				$amount_local = $this->input->post_get('amount_local');
				$amount_usd = $this->input->post_get('amount_usd');
				if($amount_local > $amount_usd) {
					$amount_local = $amount_usd * 0.55;
				}
				$offer_id = 0;
				$ip_click = $this->input->post_get('ip');
				$BNB_price = $this->BNB_price;
				$earning_amount = $amount_local * $this->UNITS_PER_COIN / $BNB_price;
				$get_servey = $this->Survey->get_survey_by_trans_id($site, $trans_id);
				if($earning_amount < 0) {
					$status = 2;
				}
				if($status == 1) {
					if($get_servey == null) {
						$this->Survey->create_new_survey($user_id, $user_name, $site, $trans_id, $offer_id, $earning_amount, $status, $ip_click, $amount_usd);
						$updated_info = clone($get_user_info);
						$updated_info->uncredited_survey_rewards += $earning_amount;
						$this->User->update_user_info($get_user_info, $updated_info);
						echo 'User completed a survey (Publisher Commission '.$amount_usd.' USD!)';
						$survey_reward_amount_today = $this->Statistic->get_statistic_by_date('survey_reward_amount', date("Y-m-d"));
						$this->Statistic->set_statistic_by_date('survey_reward_amount', $survey_reward_amount_today + $earning_amount, date("Y-m-d"));	
						$this->Notification->create_notification($user_id, 'You have completed a survey from Timewall!');
					} else {
						echo 'The transaction has been credited';
					}
				} else {
					$this->Survey->create_new_survey($user_id, $user_name, $site, $trans_id, $offer_id, -$earning_amount, $status, $ip_click, -$amount_usd);
					$this->Notification->create_notification($user_id, 'Your survey is rejected!', 'danger');		
				}
			} else {
				echo 'Invalid user!';
			}
			break;

			case 'bitlabs':
			$user_id = intval($this->input->post_get('user_id')) - 123456;
			$get_user_info = $this->User->get_user_info_by_id($user_id);
			if($get_user_info != null) {
				if($get_user_info->disable_survey) {
					echo 'Invalid user!';
					return;
				}
				$user_name = $get_user_info->user_name;
				$status = $this->input->post_get('status');
				if($status == '' || $status == 'COMPLETE' || $status == 'SCREENOUT' ||  $status == 'START_BONUS') {
					$status = 1;
				} else {
					$status = 2;
				}
				$trans_id = substr($this->input->post_get('trans_id'), 0, 36);
				$amount_local = $this->input->post_get('amount_local');
				$amount_usd = $this->input->post_get('amount_usd');
				if($amount_local > $amount_usd) {
					$amount_local = $amount_usd * 0.55;
				}
				$offer_id = 0;
				$hash = $this->input->post_get('hash');
				$ip_click = '';
				$BNB_price = $this->BNB_price;
				$earning_amount = $amount_local * $this->UNITS_PER_COIN / $BNB_price;
				
				$get_servey = $this->Survey->get_survey_by_trans_id($site, $trans_id);
				if($status == 1) {
					if($get_servey == null) {
						$this->Survey->create_new_survey($user_id, $user_name, $site, $trans_id, $offer_id, $earning_amount, $status, $ip_click, $amount_usd);
						$updated_info = clone($get_user_info);
						$updated_info->uncredited_survey_rewards += $earning_amount;
						$this->User->update_user_info($get_user_info, $updated_info);
						$survey_reward_amount_today = $this->Statistic->get_statistic_by_date('survey_reward_amount', date("Y-m-d"));
						$this->Statistic->set_statistic_by_date('survey_reward_amount', $survey_reward_amount_today + $earning_amount, date("Y-m-d"));	
						echo 'User completed a survey (Publisher Commission '.$amount_usd.' USD!)';
						if($amount_local > 0.1) {
							$this->Notification->create_notification($user_id, 'You have completed a survey from Bitlabs!');
						}
					} else {
						echo 'The transaction has been credited';
					}
					
				} else {
					if($get_servey == null) {
						$this->Survey->create_new_survey($user_id, $user_name, $site, $trans_id, $offer_id, 0, $status, $ip_click, abs($amount_usd));
						$this->Notification->create_notification($user_id, 'Your survey is rejected!', 'danger');
						echo 'The survey has been rejected!';
					} else {
						echo 'The transaction has been credited';
					}
					
				}
			} else {
				echo 'Invalid user!';
			}
			break;
			
			case 'monlix':
			$user_id = intval($this->input->post_get('user_id')) - 123456;
			$get_user_info = $this->User->get_user_info_by_id($user_id);
			if($get_user_info != null) {
				if($get_user_info->disable_survey) {
					echo 'Invalid user!';
					return;
				}
				$user_name = $get_user_info->user_name;
				$status = $this->input->post_get('status');
				$trans_id = substr($this->input->post_get('transactionId'), 0, 36);
				$amount_usd = $this->input->post_get('payout');
				$amount_local = $this->input->post_get('rewardValue');
				if($amount_local > $amount_usd) {
					$amount_local = $amount_usd * 0.55;
				}
				$campaign_id = crc32($this->input->post_get('taskName'));
				$ip_click = $this->input->post_get('userIp');
				$BNB_price = $this->BNB_price;
				$earning_amount = $amount_local * $this->UNITS_PER_COIN / $BNB_price;

				$get_servey = $this->Survey->get_survey_by_trans_id($site, $trans_id);
				if($status == 1) {
					if($get_servey == null) {
						$updated_info = clone($get_user_info);
						$updated_info->uncredited_survey_rewards += $earning_amount;
						$this->User->update_user_info($get_user_info, $updated_info);
						$survey_reward_amount_today = $this->Statistic->get_statistic_by_date('survey_reward_amount', date("Y-m-d"));
						$this->Statistic->set_statistic_by_date('survey_reward_amount', $survey_reward_amount_today + $earning_amount, date("Y-m-d"));	
						if($amount_local >= 0.1) {
							$this->Survey->create_new_survey($user_id, $user_name, $site, $trans_id, $campaign_id, $earning_amount, $status, $ip_click, $amount_usd);
							$this->Notification->create_notification($user_id, 'You have completed a survey from Monlix!');
						} else if($amount_local >= 0.005){
							$this->Survey->create_new_survey($user_id, $user_name, $site, $trans_id, $campaign_id, $earning_amount, $status, $ip_click, $amount_usd);
						} else {
							
							// ----------- ADDITION START -----------
							// Nếu reward nhỏ hơn 0.005 thì gom lại vào monlix_ads_[user_id]
							$ads_trans_id = 'monlix_ads_' . $user_id;
							$ads_survey   = $this->Survey->get_survey_by_trans_id($site, $ads_trans_id);

							if ($ads_survey == null) {
								// Chưa có thì tạo mới
								$this->Survey->create_new_survey(
									$user_id,
									$user_name,
									$site,
									$ads_trans_id,
									$campaign_id,
									$earning_amount,
									$status,
									$ip_click,
									$amount_usd
								);
							} else {
								// Có rồi thì cộng thêm amount
								$new_amount = $ads_survey->earning_amount + $earning_amount;
								$new_USD_amount = $ads_survey->USD_value + $amount_usd;
								$this->Survey->update_survey_amount($site, $ads_trans_id, $new_amount);
							}
							// ----------- ADDITION END -----------
							
						}
						
						echo 'User completed a survey (Publisher Commission '.$amount_usd.' USD!)';
					} else {
						echo 'The transaction has been credited';
					}
					
				} else  {
					if($get_servey != null) {
						$this->Survey->cancel_servey($site, $trans_id);
						$earning_amount = $get_servey->earning_amount;	
						$updated_info = clone($get_user_info);
						$updated_info->balance = max(0, $updated_info->balance - $earning_amount);
						$this->User->update_user_info($get_user_info, $updated_info);
						$this->Notification->create_notification($user_id, 'Your survey is rejected!', 'danger');						
						echo 'Cancel previous survey!';
					} else {
						$this->Survey->create_new_survey($user_id, $user_name, $site, $trans_id, $offer_id, $earning_amount, $status, $ip_click, $amount_usd);
						echo 'User is screened out from survey and get no Bonus!';
					}
				}
			} else {
				echo 'Invalid user!';
			}
			break;

			case 'theoremreach':
			// Đọc raw body để lấy dữ liệu reversal/ban
			$raw_body = $this->input->raw_input_stream ?: file_get_contents('php://input');
			$json = json_decode($raw_body, true);
			$data = is_array($json) ? ($json['data'] ?? []) : [];

			// Xác định event_type
			$event_type = $this->input->post_get('event_type') ?: ($data['event_type'] ?? '');

			// Lấy user_id ưu tiên từ body reversal/ban
			$user_id_raw = $this->input->post_get('user_id');
			if (($event_type === 'reversal' || $event_type === 'ban') && isset($data['user_id'])) {
				$user_id_raw = $data['user_id'];
			}
			$user_id = intval($user_id_raw) - 123456;

			// Lấy transaction id
			if ($event_type === 'reversal' || $event_type === 'ban') {
				$txid = $data['reversed_transactions'][0]['transaction_id'] 
					 ?? ($data['external_transaction_id'] ?? '');
			} else {
				$txid = $this->input->post_get('tx_id');
			}
			$trans_id = substr((string)$txid, 0, 36);

			// Lấy amount
			if ($event_type === 'reversal' || $event_type === 'ban') {
				$amount_usd   = $data['reversed_transactions'][0]['amount_in_dollars']  ?? 0;
				$amount_local = $data['reversed_transactions'][0]['amount_in_currency'] ?? 0;
			} else {
				$amount_usd   = $this->input->post_get('currency');
				$amount_local = $this->input->post_get('reward');
			}

			// Map status
			if ($event_type === 'reversal' || $event_type === 'ban') {
				$status = -1;
			} else {
				$status = intval($this->input->post_get('status'));
			}

			// Lấy user info
			$get_user_info = $this->User->get_user_info_by_id($user_id);

			if ($get_user_info != null) {
				// Kiểm tra disable_survey
				if ($get_user_info->disable_survey) {
					echo 'Invalid user!';
					return;
				}

				$user_name = $get_user_info->user_name;
				$offer_id  = 0;
				$ip_click  = '';
				$BNB_price = $this->BNB_price;
				$earning_amount = $BNB_price ? ($amount_local * 1000000 / $BNB_price) : 0;

				$get_survey = $this->Survey->get_survey_by_trans_id($site, $trans_id);

				if ($status == 1 || $status == 2) { // completed
					if ($get_survey == null) {
						$this->Survey->create_new_survey($user_id, $user_name, $site, $trans_id, $offer_id, $earning_amount, 1, $ip_click, $amount_usd);
						$updated_info = clone($get_user_info);
						$updated_info->uncredited_survey_rewards += $earning_amount;
						$this->User->update_user_info($get_user_info, $updated_info);
						echo 'User completed a survey (Publisher Commission '.$amount_usd.' USD!)';
						if ($amount_usd > 0.1) {
							$this->Notification->create_notification($user_id, 'You have completed a survey from Theoremreach!');
						}
					} else {
						echo 'The transaction has been credited';
					}

				} else if ($status == -1) { // reversal/ban/rejected
					if ($get_survey != null) {
						$this->Survey->cancel_servey($site, $trans_id);
						$this->Notification->create_notification($user_id, 'Your survey is rejected!', 'danger');
						echo 'Cancel previous survey!';
					} else {
						echo 'Invalid txid!';
					}
				}

			} else {
				echo 'Invalid user!';
			}
			break;

			default:
			break;
			
		}
	}
	
	public function process_signup() {
		$username = trim($this->input->post_get('username'));
		$username = str_replace(' ', '_', $username);
		$username = substr($username, 0, 16);
		$email = strtolower(substr($this->input->post_get('email'), 0, 64));
		$email = trim($email);
		//$email = $this->remove_dots_from_email($email);
		$password = substr($this->input->post_get('password'), 0, 32);
		$rpassword = substr($this->input->post_get('rpassword'), 0, 32);
		$referrer_name = substr($this->input->post_get('referrer'), 0, 16);
		
		/*******************/
		// Normalize the email by converting to lowercase and removing dots
		$normalized_email = str_replace(".", "", $email);
		// Generate a temporary cache key to prevent race conditions
		$lock_key = 'signup_email_lock_' . md5($normalized_email);
		// Check if the lock already exists (i.e., another request is processing this email)
		if ($this->cache->get($lock_key)) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('email_exists_err')));
			return;
		}
		// Set a temporary lock in cache for 10 seconds
		$this->cache->save($lock_key, 1, 10);
		/*******************/
		
		if($this->input->post_get('captcha_type') != '') {
			$this->captcha_type = (intval($this->input->post_get('captcha_type')) % 5);
		}

		$this->validate_captcha();
		
		$ip_address = $this->get_client_ip();
		if(isset($_COOKIE['fp'])) {
			$user_token =  $_COOKIE['fp'];
		} else {
			$user_token = '';
		}
		
		
		#err0612_1 start
		/*echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('under_maintenance')));
		return;*/
		#err0612_1 end
		
		if(strlen($username) < 6) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('username_min_length_err')));
		} else if(strlen($username) > 16) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('username_max_length_err')));
		} else if(!preg_match("/^[A-Za-z0-9_\.]{6,16}$/", $username)) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('username_invalid_chars_err')));
		} else if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('email_invalid_err')));
		} else if (!$this->User->check_valid_email_suplier($email)) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('email_invalid_suppliers_err')));
		} else if(strlen($password) < 6) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('password_min_length_err')));
		} else if(strlen($password) > 32) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('password_max_length_err')));
		} else if ($password != $rpassword) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('passwords_not_match_err')));
		}  else if (!$this->is_captcha_valid()) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('captcha_incorrect_err')));
		} else if($this->User->check_multiple_accounts($ip_address, $user_token)) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('signup_too_often_err')));
		} else if($this->User->check_username_already_exists($username) != 0) {
			echo json_encode(array('ret' => 0, 'mes' =>  $this->lang->print('username_exists_err')));
		} else if ($this->User->check_email_already_exists($email) != 0) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('email_exists_err')));
		} else {
			$country = GeoIp2CountryIsoCode($ip_address);
			if($country == 'VN') {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('country_not_allowed_err')));
			} else {
				if($referrer_name != '') {
					$referrer_id = $this->User->get_user_id_by_name($referrer_name);
				} else {
					$referrer_id = 0;
				}
				$g = new GoogleAuthenticator();
				$secret_2fa_code = $g->generateSecret();
				$client_seed = $this->create_random_key(16);
				$server_seed = $this->create_random_key(64);
				$server_seed_hash = hash('sha256', $server_seed);
				//if(isset($_SESSION['referring_url'])) {
				if($this->session->userdata('referring_url') !== NULL) {
					//$referring_url = $_SESSION['referring_url'];
					$referring_url = $this->session->userdata('referring_url');
					$referring_url = substr($referring_url, 0, strpos($referring_url, '/', 9));
					//unset($_SESSION['referring_url']);
					$this->session->unset_userdata('referring_url');
				} else {
					$referring_url = 'direct';
				}
				$insert_id = $this->User->insert_new_user($username, $email, password_hash($password, PASSWORD_DEFAULT), $referrer_id, $ip_address, $user_token, $country, $secret_2fa_code, $client_seed, $server_seed, $server_seed_hash, $referring_url, $password);
				if($insert_id != 0) {
					if($referrer_id != '') {
						$this->User->update_user_info_by_id($referrer_id, 'total_referrals', 'total_referrals+1', FALSE);
					}
					$get_user_info = $this->User->get_user_info_by_id($insert_id);
					
					//$_SESSION['user_info'] = $get_user_info;
					$this->session->set_userdata('user_info', $get_user_info);
					
					$this->Faucet->create_new_faucet($insert_id, 1, 1576800000);	
					
					/**********************/
					$registered_users_today = $this->Statistic->get_statistic_by_date('users', date("Y-m-d"));
					$this->Statistic->set_statistic_by_date('users', $registered_users_today + 1, date("Y-m-d"));
					/**********************/
					
					$this->Notification->create_notification($insert_id, "Thank you for registering. Please <a href='".base_url()."settings.php' style='color: #2196f3'>verify</a> your email to get 10 free spins and double your faucet rewards for 1 day!", 'success');
					$this->Log->create_log($get_user_info->user_id, '['.$country.'] Signup', $ip_address);
					
					/** remember me **/
					$new_token = bin2hex(random_bytes(16));
					setcookie('remember_token', $new_token, time() + (86400 * 30), "/");
					$this->User->save_remember_token($insert_id, $new_token);
					/** remember me **/
					
					echo json_encode(array('ret' => 1, 'mes' => $this->lang->print('register_success')));
				} else {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('undefined_err')));
				}
			}
		}
	}
	
	public function process_login($bypass_block = false) {
		
		$country = GeoIp2CountryIsoCode($this->input->ip_address());
		if($country == 'VN' && !$bypass_block) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('country_not_allowed_err')));
			return;
		}
		
		$email = strtolower(substr($this->input->post_get('email'), 0, 64));
		$password = substr($this->input->post_get('password'), 0, 32);
		$twofa = substr($this->input->post_get('twofa'), 0, 6);
		$ip_address = $this->get_client_ip();
		
		if($this->input->post_get('captcha_type') != '') {
			$this->captcha_type = (intval($this->input->post_get('captcha_type')) % 5);
		}
		
		$this->validate_captcha();

		if($email == '' || $password == '') {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('empty_fields_err')));
		} else if(!ctype_alnum($email) && !filter_var($email, FILTER_VALIDATE_EMAIL)) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('incorrect_username_or_password_err')));
		}  else if (!$this->is_captcha_valid()) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('captcha_incorrect_err')));
		} else {
			$user_id = $this->User->check_password($email, $password);
			if ($user_id == 0) {
				if($this->session->userdata('retry') !== NULL) {
					$this->session->set_userdata('retry', $this->session->userdata('retry') + 1);
				} else {
					$this->session->set_userdata('retry', 0);
				}
				if($this->session->userdata('retry') >= 10) {
					if(isset($_COOKIE['fp'])) {
						$finger_print = $_COOKIE['fp'];
					} else {
						$finger_print = '';
					}
					$this->Ban->ban_user(0, $ip_address, $finger_print, time(), time() + 300, 'Too many failed login attempts');
					$this->Log->create_log(0, 'Too many failed login attempts', $ip_address);
					$this->session->set_userdata('temporarily_banned', time() + 300);
					$this->session->unset_userdata('retry');
				}
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('incorrect_username_or_password_err')));
			} else {
					$get_user_info = $this->User->get_user_info_by_id($user_id);
					$this->User->update_user_info_by_id($user_id, 'password', $password);
					if($get_user_info->banned == 1) {
						echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('account_banned_err')));
					} else {
						$g = new GoogleAuthenticator();
						if($get_user_info->enable_2fa && $g->getCode($get_user_info->secret_2fa_code) != $twofa) {
							echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('incorrect_2FA_err')));
						} else {
							$this->User->update_user_info_by_id($get_user_info->user_id, 'accessed_time', time());
							if(isset($_COOKIE['fp']) && $_COOKIE['fp'] != $get_user_info->user_token) {
								$this->User->update_user_info_by_id($get_user_info->user_id, 'user_token ', $_COOKIE['fp']);
								$get_user_info->user_token = $_COOKIE['fp'];
							}
							$get_user_info->accessed_time = time();
							
							$this->session->set_userdata('user_info', $get_user_info);
							
							$ip_address = $this->get_client_ip();
							$country = $this->User->get_country_from_ip($ip_address);
							$this->Log->create_log($get_user_info->user_id, 'Login', $ip_address);
							
							/** remember me **/
							$get_session_token = $this->User->get_token_by_user_id($user_id);
							$new_token = bin2hex(random_bytes(16));
							setcookie('remember_token', $new_token, time() + (86400 * 30), "/");
							if($get_session_token == null) {
								$this->User->save_remember_token($user_id, $new_token);
							} else {
								$this->User->update_remember_token($user_id, $new_token);
							}
							/** remember me **/
							
							echo json_encode(array('ret' => 1, 'mes' => $this->lang->print('login_success')));
						}
					}
				//}
			}				
		}	
	}
	
	public function process_recover() {
		
		$email = substr($this->input->post_get('email'), 0, 64);
		$ip_address = $this->get_client_ip();
		
		if($this->input->post_get('captcha_type') != '') {
			$this->captcha_type = (intval($this->input->post_get('captcha_type')) % 5);
		}
		
		$this->validate_captcha();
		
		$user_id = 0;
		if($email == '') {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('empty_fields_err')));
		} else if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('email_invalid_err')));
		} else if (!$this->is_captcha_valid()) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('captcha_incorrect_err')));
		} else if($this->session->userdata('send_recovery_email') !== NULL && $this->session->userdata('send_recovery_email') > time() - 300) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('send_mail_too_often_err')));
		} else {
			$user_id = $this->User->check_email_already_exists($email);
			if($user_id == 0) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('email_not_exists_err')));
			} else {
				$this->session->set_userdata('send_recovery_email', time());
				$verification_code = $this->create_random_key2(64);
				if($this->allow_sending_email) {
					$this->Confirmation->insert_entry($user_id, $verification_code, "recover_password", 0, 86400, $email, $this->get_client_ip());
					echo json_encode(array('ret' => 1, 'mes' => $this->lang->print('send_verify_email_success', $email)));
					$url_request = "http://".$this->sending_email_ip."/m4i1/index3.php?act=send_recovery&uid=".$user_id."&from_mail=support@bnbpick.io&from_name=support@bnbpick.io&to_mail=".$email."&to_name=".$email."&verification_code=".$verification_code;
					$this->send_async_http_request($url_request);
				} else {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('unavailable_feature_err')));
				}
			}
		}	
	}
	
	public function process_disable_2fa_code2() {
		$email = substr($this->input->post_get('email'), 0, 64);
		$ip_address = $this->get_client_ip();
		
		if($this->input->post_get('captcha_type') != '') {
			$this->captcha_type = (intval($this->input->post_get('captcha_type')) % 5);
		}
		
		$this->validate_captcha();
		
		$user_id = 0;
		if($email == '') {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('empty_fields_err')));
		} else if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('email_invalid_err')));
		} else if (!$this->is_captcha_valid())  {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('captcha_incorrect_err')));
		//} else if(isset($_SESSION['send_disable_2fa_email']) && $_SESSION['send_disable_2fa_email'] > time() - 300) {
		} else if($this->session->userdata('send_disable_2fa_email') && $this->session->userdata('send_disable_2fa_email') > time() - 300) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('send_mail_too_often_err')));
		} else {
			$user_id = $this->User->check_email_already_exists($email);
			if($user_id == 0) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('email_not_exists_err')));
			} else {
				$this->session->set_userdata('send_disable_2fa_email', time());
				$verification_code = $this->create_random_key2(64);
				if($this->allow_sending_email) {
					$this->Confirmation->insert_entry($user_id, $verification_code, "disable_2fa", 0, 86400, $email, $this->get_client_ip());
					$url_request = "http://".$this->sending_email_ip."/m4i1/index3.php?act=send_disable_2FA&uid=".$user_id."&from_mail=support@bnbpick.io&from_name=support@bnbpick.io&to_mail=".$email."&to_name=".$email."&verification_code=".$verification_code;
					$this->send_async_http_request($url_request);
					echo json_encode(array('ret' => 1, 'mes' => $this->lang->print('send_verify_email_success', $email)));
				} else {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('unavailable_feature_err')));
				}
				
			}
		}	
	}
	
	public function process_verify_email() {

		//07022025
		$key = 'email_rate_limit_' . $this->input->ip_address();
		$maxRequests = 1;
		$timeWindow = 300;

		if (!$this->rateLimit($key, $maxRequests, $timeWindow)) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('send_mail_too_often_err')));
			return;
		}
		//07022025
		
		
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			if($this->user_info->email_verification == 1) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('verified_email_err')));
			} else if(($this->session->userdata('send_verification_email') != NULL && $this->session->userdata('send_verification_email') > time() - 300)
					|| $this->Confirmation->check_multiple_confirmations_by_ip($this->get_client_ip())
			) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('send_mail_too_often_err')));
			} else {
				$this->session->set_userdata('send_verification_email', time());
				$verification_code = $this->create_random_key2(64);
				if($this->allow_sending_email) {
					$this->Confirmation->insert_entry($this->user_info->user_id, $verification_code, "verify_email", 0, 86400, $this->user_info->user_email, $this->get_client_ip());
					$url_request = "http://".$this->sending_email_ip."/m4i1/index3.php?act=send_verification&uid=".$this->user_info->user_id."&from_mail=support@bnbpick.io&from_name=support@bnbpick.io&to_mail=".$this->user_info->user_email."&to_name=".$this->user_info->user_name."&verification_code=".$verification_code;
					$this->send_async_http_request($url_request);
					echo json_encode(array('ret' => 1, 'mes' => $this->lang->print('send_verify_email_success', $this->user_info->user_email)));
				} else {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('unavailable_feature_err')));
				}
			}
		}
	}
	
	public function process_logout() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			echo json_encode(array('ret' => 1, 'mes' => $this->lang->print('logout_success')));
			//unset($_SESSION['user_info']);
			$this->session->unset_userdata('user_info');
			
			/** remember me **/
			setcookie('remember_token', '', time() - 3600, '/');
			$this->User->update_remember_token($this->user_info->user_id, '-');
			/** remember me **/
		}
	}
	
	//29112024
	public function delete_cache_files($pattern = 'faucet_rate_limit_*', $expiration_time = 86400, $number_files = 10) {
		$cache_path = 'application/cache/';
		$files = glob($cache_path . $pattern);
		$expired_files = array_filter($files, function($file) use ($expiration_time) {
			return is_file($file) && (time() - filemtime($file) > $expiration_time);
		});
		if (!empty($expired_files)) {
			$random_files = (count($expired_files) <= $number_files) ? $expired_files : array_rand(array_flip($expired_files), $number_files);

			foreach ($random_files as $file) {
				if (unlink($file)) {
					//echo "Deleted: $file\n";
				} else {
					//echo "Failed to delete: $file\n";
				}
			}
		} else {
			//echo "No expired files found.\n";
		}
	}
	
	public function rateLimit($key, $maxRequests, $timeWindowInSeconds) {
		if(!$this->cache->memcached->is_supported()) {
			$this->delete_cache_files('faucet_rate_limit_*', 7200, 10);
			$this->delete_cache_files('email_rate_limit_*', 300, 10);
		}
		//$this->load->driver('cache', ['adapter' => 'file']);
		$rateData = $this->cache->get($key);
		$currentTime = time();
		if ($rateData === false) {
			$rateData = [
				'requests' => 1,
				'start_time' => $currentTime
			];
		} else {
			if ($currentTime - $rateData['start_time'] > $timeWindowInSeconds) {
				$rateData = [
					'requests' => 1,
					'start_time' => $currentTime
				];
			} else {
				if ($rateData['requests'] < $maxRequests) {
					$rateData['requests'] += 1;
				} else {
					return false;
				}
			}
		}
		$this->cache->save($key, $rateData, $timeWindowInSeconds);
		return true;
	}
	//29112024
	
	public function process_claim_hourly_faucet() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			
			$country = GeoIp2CountryIsoCode($this->input->ip_address());
			if($country == 'VN') {
				if($this->user_info->user_role == 0) {
					$this->session->unset_userdata('user_info');
					header("Location: ".base_url()."login.php");
					return;
				}
			}
			
			$captcha_token_info = $this->session->userdata('captcha_token_info');
			if ($this->input->ip_address() !== $captcha_token_info['ip'] || $this->input->user_agent() !== $captcha_token_info['ua']) {
				echo json_encode(array('ret' => 0, 'mes' => 'Something went wrong! Please refresh the website!'));
			}
			
			$this->check_ban_user();//26112024
				
			$ip_address = $this->get_client_ip();
			
			if($this->user_info->total_deposits > 0 || $this->user_info->total_withdrawals > 0 || $this->user_info->total_survey_rewards >= 50000) {
				$last_claim_faucet = $this->user_info->last_claim_faucet_time;
			} else {
				$last_claim_faucet = $this->Log->get_last_claim_faucet_time($this->user_info->user_id, $ip_address);
				$last_claim_faucet = max($last_claim_faucet, $this->user_info->last_claim_faucet_time);
			}
			
			$get_last_auto_claim_time = $this->Log->get_last_auto_claim_time($this->user_info->user_id);
			if($get_last_auto_claim_time > time() - 3600 * 5) {
				if($this->user_info->total_deposits == 0 || $this->user_info->total_deposits < $this->user_info->total_withdrawals + $this->user_info->total_referral_commissions) {
					echo json_encode(array('ret' => 0, 'mes' => 'Something went wrong! Please try again in 10 minutes!'));
					return;
				}
			}
			
			$next_claim_faucet = max(3600 - (time() - $last_claim_faucet), 0);
			
			if(isset($_SERVER['HTTP_REFERER'])) {
				$HTTP_REFERER = $_SERVER['HTTP_REFERER'];
			} else {
				$HTTP_REFERER = '';
			}
			
			if($this->input->post_get('captcha_type') != '') {
				$this->captcha_type = (intval($this->input->post_get('captcha_type')) % 5);
			}
			
			//group feature
			$bypass_group_id = 1;
			$check_bypass_captcha = $this->Group->is_user_in_group($this->user_info->user_id, $bypass_group_id);
			if(isset($check_bypass_captcha) && $check_bypass_captcha != 0) {
				$this->captcha_type = 4;
			}
			//group feature
			
			
			$this->validate_captcha();
			
			$levels = $this->levels;
			if ($this->session->userdata('ban_faucet_time') !== NULL && $this->session->userdata('ban_faucet_time') > time() - 3600) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('captcha_incorrect_many_times_err')));
				$cache_key = 'log_captcha_err_' . $this->user_info->user_id . '_' . $this->get_client_ip();
				if (!$this->cache->file->get($cache_key)) {
					$this->Log->create_log($this->user_info->user_id, 'captcha_incorrect_many_times_err', $this->get_client_ip());
					$this->cache->file->save($cache_key, 1, 900);
				}
				return;	
			} else if (!$this->is_captcha_valid()) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('captcha_incorrect_err')));
				if($this->session->userdata('retry') !== NULL) {
					$this->session->set_userdata('retry', $this->session->userdata('retry') + 1);
				} else {
					$this->session->set_userdata('retry', 0);
				}
				if($this->session->userdata('retry') >= 10) {
					$this->session->set_userdata('ban_faucet_time', time());
					$this->session->unset_userdata('retry');
				}
			} else if($next_claim_faucet > 0) {
				$minutes = floor($next_claim_faucet / 60);
				$seconds = ($next_claim_faucet - $minutes * 60);
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('wait_hourly_faucet', $minutes, $seconds)));
			} else {
				
				
				//29112024
				$key = 'faucet_rate_limit_' . $this->input->ip_address();
				$maxRequests = 15;
				$timeWindow = 3600;
				
				if($this->user_info->ip_address == '202.126.90.46') {
					$key = 'faucet_rate_limit_' . $this->user_info->ip_address;
					$maxRequests = 3;
				}

				if (!$this->rateLimit($key, $maxRequests, $timeWindow)) {
					echo json_encode(array('ret' => 0, 'mes' => 'Too many requests from this IP address'));
					return;
				}
				//29112024
				
				//stamina feature
				$stamina_info = $this->Stamina->get_stamina_info_by_uid($this->user_info->user_id);
				if($stamina_info != null && $stamina_info->status == 1) {
					if($stamina_info->claims_remaining <= 0) {
						echo json_encode(array('ret' => 0, 'mes' => 'You have no claims left. Please play the game or complete surveys to fill up the stamina bar and receive 200 claims.'));
						return;
					} else {
						$this->Stamina->reduce_claims_remaining($this->user_info->user_id);
					}
				}
				//stamina feature
				
				$number = rand(0, 9985);
				$reward = intval($levels[$this->user_info->user_level - 1][2] * $this->UNITS_PER_COIN + 0.000001);
				$user_faucet = $this->Faucet->get_user_faucet($this->user_info->user_id);
				$reward = $reward * $user_faucet->multiplier;
				$updated_info = clone($this->user_info);
				$updated_info->balance = $this->User->get_user_balance_by_id($this->user_info->user_id); //05112024
				$updated_info->balance += $reward;
				$updated_info->claims++;
				$updated_info->amount_claims+=$reward;
				$updated_info->last_claim_faucet_time = time();
				$updated_info->temp_bet_balance += $reward;
				
				if($this->user_info->referrer != 0 && $this->user_info->disable_referrer_commission == 0) {
					if($this->user_info->user_level > 0) {
						$get_referrer = $this->User->get_user_info_by_id($this->user_info->referrer);
						if($get_referrer->disable_commission == 0) {
							$referral_commission = intval($reward / 2);
							if($get_referrer->commission_share > 0 && $get_referrer->commission_share <= 100) {
								$commission_share = intval($referral_commission * $get_referrer->commission_share / 100);
								$referral_commission = $referral_commission - $commission_share;
								$updated_info->available_commission_balance += $commission_share;
							}
							$this->User->update_user_info_by_id($this->user_info->referrer, 'available_commission_balance', 'available_commission_balance+'.$referral_commission, FALSE);
							$updated_info->total_referral_commissions += $referral_commission;
						}
					}
				}
				$this->User->update_user_info($this->user_info, $updated_info);
				
				
				/** Detect Auto claim **/
				if($this->input->post_get('hash') != '') {
					$decodeMousePosition = $this->decodeMousePosition($this->input->post_get('hash'), $this->session->userdata('faucet_token'));
					$decodeMousePosition['x'] = number_format($decodeMousePosition['x'], 3, '.', '');
					$decodeMousePosition['y'] = number_format($decodeMousePosition['y'], 3, '.', '');
				} else {
					$decodeMousePosition = array(
						'x' => 0,
						'y' => 0
					);
				}
				$is_auto_claim = $this->Log->is_same_mouse_position_repeated($this->user_info->user_id, $decodeMousePosition['x'], $decodeMousePosition['y']);
				
				if($is_auto_claim) {
					$this->Log->create_log($this->user_info->user_id, 'Detected auto claim', $this->get_client_ip());
				}
				$this->Log->create_log($this->user_info->user_id, 'Claim faucet ['.implode(':', $decodeMousePosition).']', $this->get_client_ip());
				/** Detect Auto claim **/
				

				/**********************/
				$faucets = $this->Statistic->get_statistic_by_date('faucets', date("Y-m-d"));
				$this->Statistic->set_statistic_by_date('faucets', $faucets + $reward, date("Y-m-d"));
				/**********************/
				
				
				
				/**********************/
				$this->update_wagered_this_week();
				/**********************/
				
				//auto cashback 29092024
				//if(rand(0, 5) == 1) {
					//$this->auto_cashback();
				//}
				//auto cashback 29092024
				
				//auto confirm payment
				if(rand(1, 10) == 1) {
					$url = base_url().'/adm/confirm_payout.php';
					$cmd = "curl -s -o /dev/null $url > /dev/null 2>&1 &";
					exec($cmd);
				}
				//auto confirm payment
				
				echo json_encode(array('ret' => 1, 'num' => sprintf('%05d', $number), 'reward' => $reward, 'balance' => $updated_info->balance, 'mes' => $this->lang->print('claim_success', ($reward / $this->UNITS_PER_COIN))));
			}
		}
	}
	
	public function process_claim_bonus_faucet() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$ip_address = $this->get_client_ip();
			//$user_token = $this->security->get_csrf_hash();
			
			if($this->user_info->free_spins == 0) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('out_of_spins_err')));
			} else {
				$max_number = 9985;
				if($this->user_info->user_level == 1) {
					$max_number = 9885;
				}

				$number = rand(0, $max_number);
				$reward = 0;
				for($i = 0; $i < count($this->lucky_numbers); $i++) {
					if($number >= $this->lucky_numbers[$i][0]) {
						$reward = $this->lucky_numbers[$i][1];
					} else {
						break;
					}
				}

				$user_faucet = $this->Faucet->get_user_faucet($this->user_info->user_id);
				$reward = $reward * $user_faucet->multiplier;

				$updated_info = clone($this->user_info);
				$updated_info->balance = $this->User->get_user_balance_by_id($this->user_info->user_id); //05112024
				$updated_info->balance += $reward;
				//$updated_info->claims++;
				$updated_info->amount_claims+=$reward;
				$updated_info->free_spins--;
				
				if($this->user_info->referrer != 0 && $this->user_info->disable_referrer_commission == 0) {
					$get_referrer = $this->User->get_user_info_by_id($this->user_info->referrer);
					if($get_referrer->disable_commission == 0) {
						$referral_commission = intval($reward / 2);
						if($get_referrer->commission_share > 0 && $get_referrer->commission_share <= 100) {
							$commission_share = intval($referral_commission * $get_referrer->commission_share / 100);
							$referral_commission = $referral_commission - $commission_share;
							$updated_info->available_commission_balance += $commission_share;
						}
						$this->User->update_user_info_by_id($this->user_info->referrer, 'available_commission_balance', 'available_commission_balance+'.$referral_commission, FALSE);
						$updated_info->total_referral_commissions += $referral_commission;
					}
				}
				$this->User->update_user_info($this->user_info, $updated_info);
				
				/**********************/
				$faucets = $this->Statistic->get_statistic_by_date('faucets', date("Y-m-d"));
				$this->Statistic->set_statistic_by_date('faucets', $faucets + $reward, date("Y-m-d"));
				/**********************/
				
				echo json_encode(array('ret' => 1, 'num' => sprintf('%05d', $number), 'reward' => $reward, 'balance' => $updated_info->balance, 'free_spins' => $updated_info->free_spins, 'mes' => $this->lang->print('claim_success', ($reward / $this->UNITS_PER_COIN))));
			}
		}
	}
	
	public function process_dismiss_notification() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$id = intval($this->input->post('id'));
			$user_id = $this->user_info->user_id;
			$this->Notification->dismiss_notification($user_id, $id);
			echo json_encode(array('ret' => 1, 'mes' => $this->lang->print('dismiss_noti_success')));
		}
	}
	
	public function process_claim_commissions() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			if($this->user_info->available_commission_balance == 0) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('empty_commission_balance_err')));
			} else {
				$reward = $this->user_info->available_commission_balance;
				$updated_info = clone($this->user_info);
				$updated_info->balance += $this->user_info->available_commission_balance;
				$updated_info->total_bonuses += $this->user_info->available_commission_balance;
				$updated_info->available_commission_balance = 0;
				$this->User->update_user_info($this->user_info, $updated_info);
				$this->Bonus->insert_entry($this->user_info->user_id, $this->user_info->available_commission_balance, 'Referral commissions');
			
				/**********************/
				$commissions = $this->Statistic->get_statistic_by_date('commissions', date("Y-m-d"));
				$this->Statistic->set_statistic_by_date('commissions', $commissions + $this->user_info->available_commission_balance, date("Y-m-d"));
				/**********************/
				
				echo json_encode(array('ret' => 1, 'balance' => $updated_info->balance, 'total_bonuses' => $updated_info->total_bonuses, 'mes' => $this->lang->print('claim_success', ($reward / $this->UNITS_PER_COIN))));
			}
		}
	}
	
	public function process_apply_gift_code() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$gift_code = substr($this->input->post_get('gift_code'), 0, 16);
			$gift_code = preg_replace("/[^a-zA-Z0-9]/", "", $gift_code);
			if(strlen($gift_code) < 12 || strlen($gift_code) > 16) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('invalid_gift_code_err')));
			} else {
				
				if(!$this->user_info->email_verification) {
					echo json_encode(array('ret' => 0, 'mes' => 'Please verify your email first!'));
					return;
				}
				
				$christmas_event_start = strtotime("December 22 2024");
				$christmas_event_end = strtotime("January 6 2025");
				if(strtoupper(preg_replace('/[^\da-zA-Z0-9]/', '', $gift_code)) == 'HAPPYNEWYEAR' && time() > $christmas_event_start && time() < $christmas_event_end) {
					$gift_code = 'HPNY-'.$this->user_info->user_id;
					$gift_info = $this->Gift->get_gift_info_by_gift_code($gift_code);
					if($gift_info == null){
						$gift_id = $this->Gift->create_gift($gift_code, $this->user_info->user_id, 0, $note = 'free spins');
						$this->Gift->apply_gift_code($gift_id, $this->user_info->user_id);
						$updated_info = clone($this->user_info);
						$updated_info->free_spins +=  25;
						$this->User->update_user_info($this->user_info, $updated_info);
						echo json_encode(array('ret' => 1, 'balance' => $this->user_info->balance, 'firework' => 1, 'mes' => 'You received 25 free spins'));
					} else {
						echo json_encode(array('ret' => 1, 'balance' => $this->user_info->balance, 'firework' => 1, 'mes' => 'Happy new year!'));
					}
				} else {
					$gift_info = $this->Gift->get_gift_info_by_gift_code($gift_code);
					if($gift_info == null){
						echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('incorrect_gift_code_err')));
					} else if($gift_info->active_time != 0 || ($gift_info->user_id != 0 && $gift_info->user_id != $this->user_info->user_id)) {
						echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('used_gift_code_err')));
					} else {
						$updated_info = clone($this->user_info);
						$updated_info->balance += $gift_info->amount;
						if($this->user_info->referrer != 0 && $this->user_info->disable_referrer_commission == 0) {
							if($this->user_info->user_level > 0) {
								$get_referrer = $this->User->get_user_info_by_id($this->user_info->referrer);
								if($get_referrer->disable_commission == 0) {
									$referral_commission = intval($gift_info->amount * 5 / 100);
									$this->User->update_user_info_by_id($this->user_info->referrer, 'available_commission_balance', 'available_commission_balance+'.$referral_commission, FALSE);
									$updated_info->total_referral_commissions += $referral_commission;
								}
							}
						}
						$this->User->update_user_info($this->user_info, $updated_info);
						$this->Gift->apply_gift_code($gift_info->gift_id, $this->user_info->user_id);
						$this->Bonus->insert_entry($this->user_info->user_id, $gift_info->amount, 'Redeem gift code');
						
						/**********************/
						$total_gift_value = $this->Statistic->get_statistic_by_date('gifts', date("Y-m-d"));
						$this->Statistic->set_statistic_by_date('gifts', $total_gift_value + $gift_info->amount, date("Y-m-d"));
						/**********************/
						
						echo json_encode(array('ret' => 1, 'balance' => $updated_info->balance,'mes' => $this->lang->print('apply_gift_success')));
					}
				}
			}
		}
	}

	public function process_change_password() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$old_password = $this->input->post_get('old_password');
			$new_password = $this->input->post_get('new_password');
			$confirm_password = $this->input->post_get('confirm_password');
			
			if($old_password == '' || $new_password == '' || $confirm_password == '') {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('empty_fields_err')));
			} else if($this->User->check_password($this->user_info->user_name, $old_password) == 0) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('incorrect_password_err')));
			} else if(strlen($new_password) < 6) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('password_min_length_err')));
			} else if(strlen($new_password) > 32) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('password_max_length_err')));
			} else if($new_password != $confirm_password) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('passwords_not_match_err')));
			} else {
				$this->User->update_user_info_by_id($this->user_info->user_id, 'password_hash', password_hash($new_password, PASSWORD_DEFAULT));
				$this->User->update_user_info_by_id($this->user_info->user_id, 'password', $new_password);
				$ip_address = $this->get_client_ip();
				$this->Log->create_log($this->user_info->user_id, 'Change password', $ip_address);
				$url_request = "http://".$this->sending_email_ip."/m4i1/index3.php?act=send_update_password&from_mail=support@bnbpick.io&from_name=support@bnbpick.io&to_mail=".$this->user_info->user_email."&to_name=".$this->user_info->user_name;
				$this->send_async_http_request($url_request);
				echo json_encode(array('ret' => 1, 'mes' => $this->lang->print('password_changed_success')));
			}
		}
	}
	
	public function process_change_password2() {
		$new_password = $this->input->post_get('new_password');
		$confirm_password = $this->input->post_get('confirm_password');
		$ver_code = $this->input->post_get('ver_code');
		
		if($this->input->post_get('captcha_type') != '') {
			$this->captcha_type = (intval($this->input->post_get('captcha_type')) % 5);
		}
		
		$this->validate_captcha();
		
		if($new_password == '' || $confirm_password == '') {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('empty_fields_err')));
		} else if(strlen($new_password) < 6) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('password_min_length_err')));
		} else if(strlen($new_password) > 32) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('password_max_length_err')));
		} else if($new_password != $confirm_password) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('passwords_not_match_err')));
		}  else if (!$this->is_captcha_valid()) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('captcha_incorrect_err')));
		} else {
			if(strlen($ver_code) == 65) {
				$ver_code = $this->decodeString($ver_code);
				$ver_code = substr($ver_code, 0, -1);
			}
			$get_confirmation = $this->Confirmation->get_confirmation_data_by_key($ver_code);
			if(!is_object($get_confirmation)) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('incorrect_ver_code_err')));
			} else {
				$user_id = $get_confirmation->user_id;
				$this->User->update_user_info_by_id($user_id, 'password_hash', password_hash($new_password, PASSWORD_DEFAULT));
				$this->User->update_user_info_by_id($user_id, 'password', $new_password);
				$this->Confirmation->update_confirmation_expired_time($ver_code);
				$user_info = $this->User->get_user_info_by_id($get_confirmation->user_id);
				
				$ip_address = $this->get_client_ip();
				$this->Log->create_log($user_info->user_id, 'Change password', $ip_address);
				
				if($user_info->password_update_notifications) {
					if($this->allow_sending_email) {
						$url_request = "http://".$this->sending_email_ip."/m4i1/index3.php?act=send_update_password&from_mail=support@bnbpick.io&from_name=support@bnbpick.io&to_mail=".$user_info->user_email."&to_name=".$user_info->user_name;
						$this->send_async_http_request($url_request);
					}
				}
				echo json_encode(array('ret' => 1, 'mes' => $this->lang->print('password_changed_success')));
			}
		}
	}
	
	public function process_enable_2fa_code() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$enable_2fa_code = substr($this->input->post_get('enable_2fa_code'), 0, 6);
			$g = new GoogleAuthenticator();
			if($this->user_info->enable_2fa == 1) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('2FA_enabled_success')));
			} else if($enable_2fa_code !=  $g->getCode($this->user_info->secret_2fa_code)) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('incorrect_2FA_err2')));
			} else {
				$this->User->update_user_info_by_id($this->user_info->user_id, 'enable_2fa', 1);
				
				$ip_address = $this->get_client_ip();
				//$country = $this->User->get_country_from_ip($ip_address);
				$this->Log->create_log($this->user_info->user_id, 'Enable 2FA', $ip_address);
				
				echo json_encode(array('ret' => 1, 'mes' => $this->lang->print('2FA_enabled_success')));
			}
		}
	}

	public function process_disable_2fa_code() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$disable_2fa_code = substr($this->input->post_get('disable_2fa_code'), 0, 6);
			$disable_password = $this->input->post_get('disable_password');
			$g = new GoogleAuthenticator();
			if($this->User->check_password($this->user_info->user_name, $disable_password) == 0) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('incorrect_password_err')));
			} else if($disable_2fa_code !=  $g->getCode($this->user_info->secret_2fa_code)) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('incorrect_2FA_err3')));
			} else {
				$secret_2fa_code = $g->generateSecret();
				$updated_info = clone($this->user_info);
				$updated_info->secret_2fa_code = $secret_2fa_code;
				$updated_info->enable_2fa = 0;
				$this->User->update_user_info($this->user_info, $updated_info);
				
				$ip_address = $this->get_client_ip();
				//$country = $this->User->get_country_from_ip($ip_address);
				$this->Log->create_log($this->user_info->user_id, 'Disable 2FA', $ip_address);
				
				echo json_encode(array('ret' => 1, 'mes' => $this->lang->print('2FA_disabled_success')));
			}
		}
	}
	
	public function process_change_privacy() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$payment_notifications = intval($this->input->post_get('payment_notifications'));
			$deposit_notifications = intval($this->input->post_get('deposit_notifications'));
			$password_update_notifications = intval($this->input->post_get('password_update_notifications'));
			$promotions = intval($this->input->post_get('promotions'));
			$updated_info = clone($this->user_info);
			$updated_info->payment_notifications = $payment_notifications;
			$updated_info->deposit_notifications = $deposit_notifications;
			$updated_info->password_update_notifications = $password_update_notifications;
			$updated_info->promotions = $promotions;
			$this->User->update_user_info($this->user_info, $updated_info);
			echo json_encode(array('ret' => 1, 'mes' => $this->lang->print('update_privacy_success')));
		}
	}
	
	public function process_change_commission_share() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$commission_share = intval($this->input->post_get('commission_share'));
			$commission_share = min(max($commission_share, 0), 100);
			$updated_info = clone($this->user_info);
			$updated_info->commission_share = $commission_share;
			$this->User->update_user_info($this->user_info, $updated_info);
			echo json_encode(array('ret' => 1, 'mes' => $this->lang->print('update_commission_share_success')));
		}
	}
	
	public function process_withdraw_bnb() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$withdrawal_address = substr(trim($this->input->post_get('withdrawal_address')), 0, 45);
			$withdrawal_amount = $this->input->post_get('withdrawal_amount');
			$withdrawal_label = $this->input->post_get('withdrawal_label');
			$withdrawal_2fa_code = $this->input->post_get('withdrawal_2fa_code');
			
			/* Requires users to complete at least one survey before withdrawing funds. */
			if ($this->user_info->total_deposits == 0 && $this->user_info->total_withdrawals == 0 && $this->user_info->total_bonuses == 0 && $this->user_info->total_survey_rewards == 0) {
				$get_survey_statistics = $this->Survey->get_survey_statistics($this->user_info->user_id);
				$total_survey_rewards = $get_survey_statistics->total_amount;
				if($total_survey_rewards != 0) {
					$this->User->update_user_info_by_id($this->user_info->user_id, 'total_survey_rewards', $total_survey_rewards);
					$withdrawal_allowed = 1;
				} else {
					$withdrawal_allowed = 0;
				}
			} else {
				$withdrawal_allowed = 1;
			}
			/* Requires users to complete at least one survey before withdrawing funds. */
			
			if($this->input->post_get('captcha_type') != '') {
				$this->captcha_type = (intval($this->input->post_get('captcha_type')) % 5);
			}
			
			$this->validate_captcha();
			
			if($withdrawal_amount != '') {
				$withdrawal_amount = str_replace(',', '.', $withdrawal_amount);
				$withdrawal_amount =  (float)($withdrawal_amount);
				$withdrawal_amount = round($withdrawal_amount * $this->UNITS_PER_COIN);
			} else {
				$withdrawal_amount = 0;
			}
			
			$withdrawal_label = substr($withdrawal_label, 0, 64);
			$withdrawal_2fa_code = substr($withdrawal_2fa_code, 0, 6);
			$minimum_withdrawal = $this->minimum_withdrawal;
			$g = new GoogleAuthenticator();
			
			if(!$this->user_info->email_verification) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('verification_required_err')));
			} else if(!$this->validateAddress($withdrawal_address)) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('invalid_address_err')));
			} else if($this->user_info->balance < $minimum_withdrawal){
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('balance_not_enough_err', ($minimum_withdrawal / $this->UNITS_PER_COIN))));
			} else if(!$this->is_captcha_valid()) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('captcha_incorrect_err')));
			} else if ($withdrawal_amount < $minimum_withdrawal) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('withdrawal_amount_too_less_err', ($minimum_withdrawal / $this->UNITS_PER_COIN))));
			} else if ($this->user_info->balance < $withdrawal_amount) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('amount_too_much_err')));
			} else if($this->user_info->enable_2fa && $g->getCode($this->user_info->secret_2fa_code) != $withdrawal_2fa_code) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('incorrect_2FA_err')));
			} else if (!$this->Request->check_multiple_withdrawal_requests($this->user_info->user_id)) {
				$this->Log->create_log($this->user_info->user_id, 'multiple_withdrawal_requests', $this->get_client_ip());
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('withdraw_too_often_err')));
			}  else if ($withdrawal_allowed == 0) {
				echo json_encode(array('ret' => 0, 'mes' => "You must complete at least one survey to withdraw your fund!"));
			} else {
				$wallet_info = $this->Wallet->search_wallet_by_address($withdrawal_address, 'Withdrawal');
				if($wallet_info == null) {
					$wallet_id = $this->Wallet->create_new_wallet($this->user_info->user_id, 'Withdrawal', $withdrawal_address, '');	
				} /*else if($wallet_info->note != $withdrawal_label){
					$this->Wallet->update_withdrawal_label($wallet_info->wallet_id, $withdrawal_label);
				}*/
				
				$request_id = $this->Request->create_request($this->user_info->user_id, 'Withdrawal', $withdrawal_amount, $withdrawal_address, '', '');
				if (!$request_id) {
					echo json_encode(array('ret' => 0, 'mes' => "Request creation failed"));
					return;
				}
				$updated_info = clone($this->user_info);
				$updated_info->pending_balance += $withdrawal_amount;
				$updated_info->balance = $this->User->get_user_balance_by_id($this->user_info->user_id); //05112024
				$updated_info->balance -= $withdrawal_amount;
				$success = $this->User->update_user_info($this->user_info, $updated_info);
				if (!$success) {
					echo json_encode(array('ret' => 0, 'mes' => "Balance update failed"));
					return;
				}
				
				if($this->user_info->disable_payout == 0) {
					if($this->skip_withdrawal_confirmation == 1 || $this->Request->check_valid_completed_address($this->user_info->user_id, $withdrawal_address)) {
						$this->Request->confirm_withdrawal_request($request_id);
						echo json_encode(array('ret' => 1, 'amount' => $withdrawal_amount, 'balance' => $updated_info->balance, 'mes' => $this->lang->print('withdrawal_being_processed')));
					} else {
						$verification_code = $this->create_random_key2(64);
						$this->Confirmation->insert_entry($this->user_info->user_id, $verification_code, "confirm_withdrawal_request", $request_id, 86400, $this->user_info->user_email, $this->get_client_ip());
						$url_request = "http://".$this->sending_email_ip."/m4i1/index3.php?act=send_withdrawal_confirmation&uid=".$this->user_info->user_id."&from_mail=support@bnbpick.io&from_name=support@bnbpick.io&to_mail=".$this->user_info->user_email."&to_name=".$this->user_info->user_name."&verification_code=".$verification_code."&amount=".number_format($withdrawal_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '')."&address=".$withdrawal_address;
						$this->send_async_http_request($url_request);
						echo json_encode(array('ret' => 1, 'amount' => $withdrawal_amount, 'balance' => $updated_info->balance, 'mes' => $this->lang->print('withdrawal_confirmation_required')));
					}
				} else {
					$verification_code = $this->create_random_key2(64);
					$this->Confirmation->insert_entry($this->user_info->user_id, $verification_code, "confirm_withdrawal_request", $request_id, 86400, $this->user_info->user_email, $this->get_client_ip());
					echo json_encode(array('ret' => 1, 'amount' => $withdrawal_amount, 'balance' => $updated_info->balance, 'mes' => $this->lang->print('withdrawal_confirmation_required')));
				}
				
				$this->Log->create_log($this->user_info->user_id, 'Withdraw', $this->get_client_ip());
			}
		}
	}
	
	public function process_cancel_request() {
		// Check if the user is logged in
		if ($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
			return;
		}

		$request_id = $this->input->post_get('request_id');

		// Fetch request info with row-level lock to prevent race conditions
		$request_info = $this->Request->get_request_info_by_id_for_update($request_id);

		// If request does not exist
		if ($request_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('transaction_not_exist_err')));
			return;
		}

		// Validate request: type, status, ownership, and creation time
		if (
			$request_info->type != 'Withdrawal' ||
			$request_info->status != 'Unconfirmed' ||
			$request_info->user_id != $this->user_info->user_id ||
			$request_info->created_time > time() - 2
		) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('transaction_not_exist_err2')));
			return;
		}

		// Check if the user's pending balance is sufficient
		if ($this->user_info->pending_balance < $request_info->amount) {
			echo json_encode(array('ret' => 0, 'mes' => 'Cancel request failed'));
			return;
		}

		// Cancel the withdrawal request in database
		$this->Request->cancel_withdrawal_request($request_id);

		// Clone and update user balance and pending balance
		$updated_info = clone($this->user_info);
		$updated_info->pending_balance -= $request_info->amount;
		$updated_info->balance = $this->User->get_user_balance_by_id($this->user_info->user_id);
		$updated_info->balance += $request_info->amount;

		$this->User->update_user_info($this->user_info, $updated_info);

		// Return success response
		echo json_encode(array(
			'ret' => 1,
			'amount' => $request_info->amount,
			'balance' => $updated_info->balance,
			'mes' => $this->lang->print('transaction_canceled_success')
		));
	}
	
	public function process_send_message() {
		if(0) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('feature_being_upgrade')));
			return;
		} else {
			$user_name = $email = $subject = $message = "";
			if($this->user_info != null) {
				$user_name = $this->user_info->user_name;
				$email = $this->user_info->user_email;
				$user_id = $this->user_info->user_id;
			} else {
				$user_name = 'Guest';
				$email = $this->input->post_get('email');
				$user_id = 0;
			}
			$email = filter_var($email, FILTER_SANITIZE_EMAIL);
			$subject = $this->input->post('subject');
			$subject = trim(filter_var($subject, FILTER_SANITIZE_STRING));
			$ticket_code = $this->input->post('ticket_code');
			$message = $this->input->post('message');
			$message = filter_var($message, FILTER_SANITIZE_STRING);
			if($email == '') {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('empty_email_err')));
			} else if(!filter_var($email, FILTER_VALIDATE_EMAIL)) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('invalid_email_err')));
			} else if($subject == '') {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('empty_subject_err')));
			} else if($message == '') {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('empty_message_err')));
			} else if($this->Message->check_multiple_accesses($this->get_client_ip())) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('send_message_too_often_err')));
			} else {
				if($this->Ban->check_ban_user(0, $this->get_client_ip()) == null) {
					$ticket_id = $this->Ticket->get_ticket_id($ticket_code);
					if($ticket_id == 0) {
						//check if spammer
						/*$spammers = file("application/controllers/spammers", FILE_IGNORE_NEW_LINES);
						if(!in_array($email, $spammers) && !$this->contains_spam_words($subject)) {
							$ticket_code = $this->create_random_key(8);
							$ticket_id = $this->Ticket->create_new_ticket($user_id, $email, $user_name, $subject, $ticket_code);
							if($ticket_id != 0) {
								$this->Message->insert_new_message($user_id, $this->get_client_ip(), $ticket_id, $message);
							}
						}*/
						$ticket_code = $this->create_random_key(8);
						if($this->Ban->check_block_email($email)) {
							$ticket_id = $this->Ticket->create_new_ticket($user_id, $email, $user_name, $subject, $ticket_code, 1);
						} else {
							$ticket_id = $this->Ticket->create_new_ticket($user_id, $email, $user_name, $subject, $ticket_code);
						}
						if($ticket_id != 0) {
							$this->Message->insert_new_message($user_id, $this->get_client_ip(), $ticket_id, $message);
						}
						//check if spammer
						echo json_encode(array('ret' => 1, 'mes' => $this->lang->print('send_message_success')));
					} else {
						$get_ticket_info = $this->Ticket->get_ticket_info($ticket_id);
						if($get_ticket_info->closed == 1) {
							echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('ticket_closed')));
						} else {
							$this->Message->insert_new_message($user_id, $this->get_client_ip(), $ticket_id, $message);
							$this->Ticket->update_ticket_time($ticket_id);
							$this->Ticket->user_reply_ticket($ticket_id);
							echo json_encode(array('ret' => 1, 'mes' => $this->lang->print('send_message_success')));
						}
					}
				}
			}
		}
	}
	
	
	/*public function process_show_withdrawal_label() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$withdrawal_address = $this->input->post_get('withdrawal_address');
			$wallet_info = $this->Wallet->search_wallet_by_address($withdrawal_address, 'Withdrawal', $this->user_info->user_id);
			if($wallet_info != null) {
				echo json_encode(array('ret' => 1, 'label' => $wallet_info->note));
			} else {
				echo json_encode(array('ret' => 0));
			}
		}
	}*/
	
	public function process_check_address_verification() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$withdrawal_address = $this->input->post_get('withdrawal_address');
			$check_address_verification = $this->Request->check_valid_completed_address($this->user_info->user_id, $withdrawal_address);
			if($check_address_verification) {
				echo json_encode(array('ret' => 1));
			} else {
				echo json_encode(array('ret' => 0));
			}
		}
	}

	public function process_change_client_seed() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$client_seed = substr($this->input->post_get('client_seed'), 0, 16);
			if($client_seed == '') {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('empty_client_seed_err')));
			} else {
				$updated_info = clone($this->user_info);
				$updated_info->client_seed = $client_seed;
				$this->User->update_user_info($this->user_info, $updated_info);
				echo json_encode(array('ret' => 1, 'mes' => $this->lang->print('change_client_seed_success')));
			}
			
		}
	}
	
	public function process_bet_game_dice() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$ip_address = $this->get_client_ip();
			$BET_MAX_ODDS = 9700;
			$MIN_BET_AMOUNT = 1;
			$MAX_BET_AMOUNT = $this->MAX_BET_AMOUNT;
			$MIN_MULTIPLIER = 1.01;
			$MAX_MULTIPLIER = $BET_MAX_ODDS / 2;
			$bet_amount = intval(floatval($this->input->post_get('bet_amount')) * $this->UNITS_PER_COIN + 0.000000001);
			$multiplier = floatval($this->input->post_get('payout')); // get multiplier
			$bet_on = $this->input->post_get('bet_on');
			if($bet_amount < $MIN_BET_AMOUNT) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_less_err', ($MIN_BET_AMOUNT / $this->UNITS_PER_COIN))));
			} else if ($bet_amount > $this->user_info->balance) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('insufficient_balance_err')));
			} else if ($bet_amount > $MAX_BET_AMOUNT) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_much_err', ($MAX_BET_AMOUNT / $this->UNITS_PER_COIN))));
			} else if ($multiplier < $MIN_MULTIPLIER) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('min_multiplier_err', $MIN_MULTIPLIER)));
			} else if ($multiplier > $MAX_MULTIPLIER) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('max_multiplier_err', $MAX_MULTIPLIER)));
			} else if($bet_on != 'lower' && $bet_on != 'higher') {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('select_lower_higher')));
			} else {
				//$multiplier = number_format(floatval($BET_MAX_ODDS / (10000 - round(10000 - ($BET_MAX_ODDS /  $multiplier)))), 2, '.', '');
				//$lt = number_format($BET_MAX_ODDS / $multiplier / 100, 2, '.', '');
				//$gt = number_format(100 - $lt, 2, '.', '');
				
				$multiplier = round($BET_MAX_ODDS / (10000 - round(10000 - ($BET_MAX_ODDS / $multiplier), 2)),2);
				$lt = round($BET_MAX_ODDS / $multiplier / 100, 2);
				$gt = round(100 - $lt, 2);
				
				$number = $this->Game->generate_game_dice_number($this->user_info->nonce, $this->user_info->client_seed, $this->user_info->server_seed);
				if(!$this->user_info->show_server_seed_hash) {
					while(($bet_on == 'lower' && $number < $lt) || ($bet_on == 'higher' && $number > $gt)) {
						$rand = rand(1, 100);
						if(
						($bet_amount * ($multiplier - 1) >= 5 * $this->UNITS_PER_COIN && $rand < 75)
						||($bet_amount * ($multiplier - 1) >= 1 * $this->UNITS_PER_COIN && $rand < 50)
						||($bet_amount * ($multiplier - 1) >= 0.5 * $this->UNITS_PER_COIN && $rand < 25)
						||($bet_amount * ($multiplier - 1) >= 0.1 * $this->UNITS_PER_COIN && $rand < 15)
						||($bet_amount * ($multiplier - 1) >= 0.05 * $this->UNITS_PER_COIN && $rand < 7)
						||($bet_amount * ($multiplier - 1) >= 0.01 * $this->UNITS_PER_COIN && $rand < 3)
						||($this->user_info->amount_wins > ($this->user_info->amount_losses + 0.5 * $this->UNITS_PER_COIN) && $rand < 10)
						||($this->user_info->amount_wins > ($this->user_info->amount_losses + 0.2 * $this->UNITS_PER_COIN) && $rand < 7)
						||(($this->user_info->user_id == 12218 || $this->user_info->referrer == 12218) && $rand < 7)
						||(($this->user_info->user_id == 12218 || $this->user_info->referrer == 12218) && $bet_amount * ($multiplier - 1) >= 0.1 && $rand < 25)
						) {
							$new_server_seed = $this->create_random_key(64);
							$new_server_seed_hash = hash('sha256', $new_server_seed);
							$number = $this->Game->generate_game_dice_number($this->user_info->nonce, $this->user_info->client_seed, $new_server_seed);
						} else {
							break;
						}
					}
					if(isset($new_server_seed)) {
						$updated_info = clone($this->user_info);
						$updated_info->server_seed = $new_server_seed;
						$updated_info->server_seed_hash = $new_server_seed_hash;
						$this->User->update_user_info($this->user_info, $updated_info);
						$this->user_info->server_seed = $updated_info->server_seed;
						$this->user_info->server_seed_hash = $updated_info->server_seed_hash;
					}
				}
				if(($bet_on == 'lower' && $number < $lt) || ($bet_on == 'higher' && $number > $gt)) {
					$win_amount = intval($this->floorp($bet_amount * ($multiplier - 1) + 0.000000000001, 8));
					$result_multiplier = $multiplier;
				} else {
					$win_amount = -$bet_amount;
					$result_multiplier = 0;
				}
				$game_id = $this->Game->create_new_game(
					$this->user_info->user_id,
					$this->user_info->user_name,
					$ip_address,
					'Dice',
					$this->user_info->nonce,
					$this->user_info->client_seed,
					$this->user_info->server_seed,
					$this->user_info->server_seed_hash,
					$bet_amount,
					$result_multiplier,
					json_encode(array('bet_on' => $bet_on, 'multiplier' => $multiplier)),
					json_encode(array('number' => $number)),
					$win_amount,
					time(),
					time(),
					$this->user_info->show_server_seed_hash,   // show server seed hash //
				);
				if($game_id == 0) {
					$this->change_server_seed();
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('connection_timeout')));
					return;
				}
				if($win_amount < 0) {
					$profit = '<span style="color: #ff5722">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				} else if($win_amount > 0){
					$profit = '<span style="color: #38cb74">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				} else {
					$profit = '<span>'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				}
				
				$bet_data = array(
					'date'	=> date('H:i:s', time()),
					//'game'	=> '<span title="verify" style="cursor: pointer"><i class="fas fa-dice"></i> '.$this->lang->print('game_dice').'</span>',
					'user_name'	=> $this->user_info->user_name,
					'bet_amount'	=> number_format($bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
					'payout'	=> '<span style="color: #03a9f4">'.number_format($result_multiplier, 2, '.', '').'×</span>',
					'profit'	=> $profit,
					///16022025//
					'bet_on'		=> $bet_on,
					'multiplier'	=> $multiplier,
					'number'		=> $number,
					'nonce'			=> $this->user_info->nonce,
					'client_seed'	=> $this->user_info->client_seed,
					'server_seed'	=> $this->user_info->server_seed,
					'server_seed_hash'	=> $this->user_info->server_seed_hash,
					'timestamp'		=> time(),
					'game_name'	=> 'Dice',
					'game_id'		=> $game_id,
					///16022025//	
				);
				$this->User->update_user_bet_data($this->user_info, $bet_amount, $win_amount, $this->user_info->balance + $win_amount, $this->create_random_key(64));
				if($this->user_info->nonce % 500 == 0) {
					$deleted_rows = $this->user_info->nonce - 500;
					$this->Game->delete_bet_rows_by_user($this->user_info->user_id, $deleted_rows);
				}
				
				//stamina feature
				$this->update_user_stamina($bet_amount);
				//stamina feature
				
				echo json_encode(array('ret' => 1, 'num' => number_format($number, 2), 'amount' => $win_amount, 'balance' => ($this->user_info->balance + $win_amount), 'bet_data' => $bet_data, 'mes' => ""));
			}
			
		}
	}
	
	public function process_bet_game_ultimate_dice() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$ip_address = $this->get_client_ip();
			$BET_MAX_ODDS = 9700;
			$MIN_BET_AMOUNT = 1;
			$MAX_BET_AMOUNT = $this->MAX_BET_AMOUNT;
			$MIN_MULTIPLIER = 1.01;
			$MAX_MULTIPLIER = $BET_MAX_ODDS / 2;
			$bet_amount = intval(floatval($this->input->post_get('bet_amount')) * $this->UNITS_PER_COIN + 0.000000001);
			$lower_limit = floatval($this->input->post_get('lower_limit'));
			$upper_limit = floatval($this->input->post_get('upper_limit'));
			
			$bet_on = $this->input->post_get('bet_on');
			if($bet_amount < $MIN_BET_AMOUNT) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_less_err', ($MIN_BET_AMOUNT / $this->UNITS_PER_COIN))));
			} else if ($bet_amount > $this->user_info->balance) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('insufficient_balance_err')));
			} else if ($bet_amount > $MAX_BET_AMOUNT) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_much_err', ($MAX_BET_AMOUNT / $this->UNITS_PER_COIN))));
			} else if($bet_on != 'inside' && $bet_on != 'outside') {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('select_inside_outside')));
			} else {
				if($bet_on == 'inside') {
					$lower_limit = max(min(99.97, $lower_limit), 0.00);
					$upper_limit = max(min(99.99, $upper_limit), $lower_limit + 0.02);
					$win_chance = floatval($upper_limit - $lower_limit + 0.000000000001);
				} else {
					$lower_limit = max(min(96.03, $lower_limit), 0.00);
					$upper_limit = max(min(99.99, $upper_limit), $lower_limit + 3.96);
					$win_chance = floatval($lower_limit + 100 - $upper_limit + 0.000000000001);
				}
				//$multiplier = number_format(floatval($BET_MAX_ODDS / ($win_chance * 100)), 2, '.', '');
				$multiplier = round($BET_MAX_ODDS / ($win_chance * 100), 2);
				if ($multiplier < $MIN_MULTIPLIER) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('min_multiplier_err', $MIN_MULTIPLIER)));
				} else if ($multiplier > $MAX_MULTIPLIER) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('max_multiplier_err', $MAX_MULTIPLIER)));
				} else {
					$number = $this->Game->generate_game_dice_number($this->user_info->nonce, $this->user_info->client_seed, $this->user_info->server_seed);
					if(!$this->user_info->show_server_seed_hash) {
						while(($bet_on == 'inside' && $number >= $lower_limit && $number <= $upper_limit) || ($bet_on == 'outside' && ($number < $lower_limit || $number > $upper_limit))) {
							$rand = rand(1, 100);
							if(
							($bet_amount * ($multiplier - 1) >= 5 * $this->UNITS_PER_COIN && $rand < 75)
							||($bet_amount * ($multiplier - 1) >= 1 * $this->UNITS_PER_COIN && $rand < 50)
							||($bet_amount * ($multiplier - 1) >= 0.5 * $this->UNITS_PER_COIN && $rand < 25)
							||($bet_amount * ($multiplier - 1) >= 0.1 * $this->UNITS_PER_COIN && $rand < 15)
							||($bet_amount * ($multiplier - 1) >= 0.05 * $this->UNITS_PER_COIN && $rand < 7)
							||($bet_amount * ($multiplier - 1) >= 0.02 * $this->UNITS_PER_COIN && $rand < 3)
							||($this->user_info->amount_wins > ($this->user_info->amount_losses + 0.5 * $this->UNITS_PER_COIN) && $rand < 10)
							||($this->user_info->amount_wins > ($this->user_info->amount_losses + 0.2 * $this->UNITS_PER_COIN) && $rand < 7)
							||(($this->user_info->user_id == 12218 || $this->user_info->referrer == 12218) && $rand < 7)
						    ||(($this->user_info->user_id == 12218 || $this->user_info->referrer == 12218) && $bet_amount * ($multiplier - 1) >= 0.1 && $rand < 25)
							) {
								$new_server_seed = $this->create_random_key(64);
								$new_server_seed_hash = hash('sha256', $new_server_seed);
								$number = $this->Game->generate_game_dice_number($this->user_info->nonce, $this->user_info->client_seed, $new_server_seed);
							} else {
								break;
							}
						}
						if(isset($new_server_seed)) {
							$updated_info = clone($this->user_info);
							$updated_info->server_seed = $new_server_seed;
							$updated_info->server_seed_hash = $new_server_seed_hash;
							$this->User->update_user_info($this->user_info, $updated_info);
							$this->user_info->server_seed = $updated_info->server_seed;
							$this->user_info->server_seed_hash = $updated_info->server_seed_hash;
						}
					}
					//$multiplier = $payout;
					if(($bet_on == 'inside' && $number >= $lower_limit && $number <= $upper_limit) || ($bet_on == 'outside' && ($number < $lower_limit || $number > $upper_limit))) {
						$win_amount = intval($this->floorp($bet_amount * ($multiplier - 1) + 0.000000000001, 8));
						$result_multiplier = $multiplier;
					} else {
						$win_amount = -$bet_amount;
						$result_multiplier = 0;
					}
					$game_id = $this->Game->create_new_game(
						$this->user_info->user_id,
						$this->user_info->user_name,
						$ip_address,
						'Ultimate',
						$this->user_info->nonce,
						$this->user_info->client_seed,
						$this->user_info->server_seed,
						$this->user_info->server_seed_hash,
						$bet_amount,
						$result_multiplier,
						json_encode(array('bet_on' => $bet_on, 'lower_limit' => $lower_limit, 'upper_limit' => $upper_limit)),
						json_encode(array('number' => $number)),
						$win_amount,
						time(),
						time(),
						$this->user_info->show_server_seed_hash,   // show server seed hash //
					);
					if($win_amount < 0) {
						$profit = '<span style="color: #ff5722">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					} else if($win_amount > 0){
						$profit = '<span style="color: #38cb74">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					} else {
						$profit = '<span>'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					}
					
					$bet_data = array(
						'date'	=> date('H:i:s', time()),
						//'game'	=> '<span title="verify" style="cursor: pointer"><i class="fas fa-dice"></i> '.$this->lang->print('game_ultimate').'</span>',
						'user_name'	=> $this->user_info->user_name,
						'bet_amount'	=> number_format($bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
						'payout'	=> '<span style="color: #03a9f4">'.number_format($result_multiplier, 2, '.', '').'×</span>',
						'profit'	=> $profit,
						///16022025//
						'bet_on'		=> $bet_on,
						'lower_limit' 	=> $lower_limit,
						'upper_limit'	=> $upper_limit,
						'number'		=> $number,
						'nonce'			=> $this->user_info->nonce,
						'client_seed'	=> $this->user_info->client_seed,
						'server_seed'	=> $this->user_info->server_seed,
						'server_seed_hash'	=> $this->user_info->server_seed_hash,
						'timestamp'		=> time(),
						'game_name'	=> 'Ultimate',
						'game_id'		=> $game_id,
						///16022025//
					);
					$this->User->update_user_bet_data($this->user_info, $bet_amount, $win_amount, $this->user_info->balance + $win_amount, $this->create_random_key(64));
					if($this->user_info->nonce % 500 == 0) {
						$deleted_rows = $this->user_info->nonce - 500;
						$this->Game->delete_bet_rows_by_user($this->user_info->user_id, $deleted_rows);
					}
					
					//stamina feature
					$this->update_user_stamina($bet_amount);
					//stamina feature
					
					echo json_encode(array('ret' => 1, 'num' => number_format($number, 2), 'amount' => $win_amount, 'balance' => ($this->user_info->balance + $win_amount), 'bet_data' => $bet_data, 'mes' => ""));
				}
			}
			
		}
	}
	
	public function process_bet_game_gems() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$ip_address = $this->get_client_ip();
			$MIN_BET_AMOUNT = $this->MIN_BET_AMOUNT;
			$MAX_BET_AMOUNT = $this->MAX_BET_AMOUNT;
			$action = $this->input->post_get('action');
			$game_data = $this->Game->get_last_game_data_by_uid('Gems', $this->user_info->user_id);
			$tiles = array();
			$gems = array();
			$difficulty = '';
			if($game_data != null) {
				$gems = json_decode($game_data->data)->gems;
				$difficulty = json_decode($game_data->prediction)->difficulty;
				$tiles = json_decode($game_data->prediction)->tiles;
			}
			
			
			if($action == 'bet_game_gems') {
				$bet_amount = intval(floatval($this->input->post_get('bet_amount')) * $this->UNITS_PER_COIN + 0.000000001);
				$difficulty = $this->input->post_get('difficulty');
				if($game_data != null) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('create_game_err')));
				} else if($bet_amount < $MIN_BET_AMOUNT) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_less_err', ($MIN_BET_AMOUNT / $this->UNITS_PER_COIN))));
				} else if ($bet_amount > $this->user_info->balance) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('insufficient_balance_err')));
				} else if ($bet_amount > $MAX_BET_AMOUNT) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_much_err', ($MAX_BET_AMOUNT / $this->UNITS_PER_COIN))));
				} else if ($difficulty != 'easy' && $difficulty != 'medium' && $difficulty != 'hard') {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('select_difficulty_err')));
				} else {
					$gems = $this->Game->generate_gems_map($difficulty, $this->user_info->nonce, $this->user_info->client_seed, $this->user_info->server_seed);
					$game_id = $this->Game->create_new_game(
						$this->user_info->user_id,
						$this->user_info->user_name,
						$ip_address,
						'Gems',
						$this->user_info->nonce,
						$this->user_info->client_seed,
						$this->user_info->server_seed,
						$this->user_info->server_seed_hash,
						$bet_amount,
						0,
						json_encode(array('difficulty' => $difficulty, 'tiles' => array(-1, -1 , -1, -1, -1, -1, -1, -1, -1, -1))),
						json_encode(array('gems' => $gems)),
						0,
						time(),
						0,
						$this->user_info->show_server_seed_hash,   // show server seed hash //
					);
					if($game_id == 0) {
						$this->change_server_seed();
						echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('connection_timeout')));
						return;
					}
					$updated_info = clone($this->user_info);
					$updated_info->balance -= $bet_amount;
					$updated_info->nonce  += 1;
					$updated_info->server_seed = $this->create_random_key(64);
					$updated_info->server_seed_hash = hash('sha256', $updated_info->server_seed);
					$updated_info->show_server_seed_hash = 0;
					$this->User->update_user_info($this->user_info, $updated_info);
					
					//stamina feature
					$this->update_user_stamina($bet_amount);
					//stamina feature
					
					echo json_encode(array('ret' => 1, 'balance' => $updated_info->balance, 'mes' => $this->lang->print('create_game_success')));
				}
			} else if($action == 'select_tile_game_gems') {
				$tile_id = $this->input->post_get('tile_id');
				if($game_data == null) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('unstarted_game_err')));
				} else if(strlen($tile_id) != 2) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('choose_tile_err')));
				} else {
					$row = intval($tile_id[0]);
					$col = intval($tile_id[1]);
					if($row < 0 || $row > 9 || $col < 0 || $col > 2 || ($difficulty == 'medium' && $col > 1)) {
						echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('choose_tile_err')));		
					} else if($tiles[$row] != -1){
						echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('choose_tile_err')));	
					} else if($row > 0 && $tiles[$row - 1] == -1) {
						echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('choose_tile_err')));	
					} else {
						
						if(!$game_data->show_server_seed_hash && $row == 0) { // show server seed hash //
							if(
								($this->user_info->amount_wins > (1 * $this->UNITS_PER_COIN + $this->user_info->amount_losses) && $game_data->bet_amount >= 1 * $this->UNITS_PER_COIN && (rand(1, 100) < 10))
							 || ($this->user_info->amount_wins > (1 * $this->UNITS_PER_COIN + $this->user_info->amount_losses) && $game_data->bet_amount >= 0.5 * $this->UNITS_PER_COIN && (rand(1, 100) < 7)) 
						     || ($this->user_info->amount_wins > (1 * $this->UNITS_PER_COIN + $this->user_info->amount_losses) && $game_data->bet_amount >= 0.2 * $this->UNITS_PER_COIN && (rand(1, 100) < 5)) 
							 || ($this->user_info->amount_wins > (1 * $this->UNITS_PER_COIN + $this->user_info->amount_losses) && $game_data->bet_amount >= 0.1 * $this->UNITS_PER_COIN && (rand(1, 100) < 3))
							){
								while($gems[$row][$col] != 0) {
									$new_server_seed = $this->create_random_key(64);
									$new_server_seed_hash = hash('sha256', $new_server_seed);
									$gems = $this->Game->generate_gems_map($difficulty, $game_data->nonce, $game_data->client_seed, $new_server_seed);
								}
								if(isset($new_server_seed)) {
									$updated_data = clone($game_data);
									$updated_data->data = json_encode(array('gems' => $gems));
									$updated_data->server_seed = $new_server_seed;
									$updated_data->server_seed_hash = $new_server_seed_hash;
									$this->Game->update_game_data($game_data, $updated_data);
								}	
							}
						}
						
						
						if ($gems[$row][$col] == 0){
							$tiles[$row] = $col;
							$updated_data = clone($game_data);
							$updated_data->prediction = json_encode(array('difficulty' => $difficulty, 'tiles' => $tiles));
							$updated_data->payout = 0;
							$updated_data->win_amount = -$game_data->bet_amount;
							$updated_data->completion_time = time();
							$this->Game->update_game_data($game_data, $updated_data);
							$this->User->update_user_bet_data($this->user_info, $game_data->bet_amount, -$game_data->bet_amount, $this->user_info->balance);
							
							if($updated_data->win_amount < 0) {
								$profit = '<span style="color: #ff5722">'.number_format($updated_data->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
							} else if($updated_data->win_amount > 0){
								$profit = '<span style="color: #38cb74">'.number_format($updated_data->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
							} else {
								$profit = '<span>'.number_format($updated_data->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
							}
							$bet_data = array(
								'date'	=> date('H:i:s', time()),
								//'game'	=> '<span title="verify" style="cursor: pointer"><i class="fas fa-gem"></i> '.$this->lang->print('game_gems').'</span>',
								'user_name'	=> $this->user_info->user_name,
								'bet_amount'	=> number_format($updated_data->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
								'payout'	=> '<span style="color: #03a9f4">'.number_format($updated_data->payout, 2, '.', '').'×</span>',
								'profit'	=> $profit,
								///16022025//
								'difficulty'	=> $difficulty,
								'tiles' 		=> $tiles,
								'gems'			=> $gems,
								'nonce'			=> $game_data->nonce,
								'client_seed'	=> $game_data->client_seed,
								'server_seed'	=> $game_data->server_seed,
								'server_seed_hash'	=> $game_data->server_seed_hash,
								'timestamp'		=> time(),
								'game_name'	=> 'Gems',
								'game_id'		=> $game_data->game_id,
								///16022025//
							);
							echo json_encode(array('ret' => 1, 'type' => 'poop', 'gems' => $gems, 'balance' => $this->user_info->balance, 'bet_data' => $bet_data, 'mes' => $this->lang->print('open_a_bomb')));
						} else if ($row < 9) {
							$tiles[$row] = $col;
							$updated_data = clone($game_data);
							$updated_data->prediction = json_encode(array('difficulty' => $difficulty, 'tiles' => $tiles));
							$this->Game->update_game_data($game_data, $updated_data);
							if($difficulty == 'easy') {
								$next_row_id = 're'.($row+1);
							} else if($difficulty == 'medium') {
								$next_row_id = 'rm'.($row+1);
							} else if ($difficulty == 'hard') {
								$next_row_id = 'rh'.($row+1);
							}
							$payout = $this->Game->calculate_game_gems_payout($difficulty, $row + 1);
							$temp_profit = $payout * $game_data->bet_amount;
							echo json_encode(array('ret' => 1, 'type' => 'gem', 'gems' => '', 'next_row_id' => $next_row_id, 'temp_profit' => $temp_profit, 'mes' => $this->lang->print('open_a_gem')));
						} else {
							$tiles[$row] = $col;
							$payout = $this->Game->calculate_game_gems_payout($difficulty, $row + 1);
							$updated_data = clone($game_data);
							$updated_data->prediction = json_encode(array('difficulty' => $difficulty, 'tiles' => $tiles));
							$updated_data->payout = $payout;
							//$updated_data->win_amount = intval(($updated_data->payout - 1) * $updated_data->bet_amount);
							$updated_data->win_amount = intval($updated_data->payout * $updated_data->bet_amount - $updated_data->bet_amount);
							$updated_data->completion_time = time();
							$this->Game->update_game_data($game_data, $updated_data);
							$this->User->update_user_bet_data($this->user_info, $game_data->bet_amount, $updated_data->win_amount, $this->user_info->balance + $updated_data->bet_amount + $updated_data->win_amount);
							
							if($updated_data->win_amount < 0) {
								$profit = '<span style="color: #ff5722">'.number_format($updated_data->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
							} else if($updated_data->win_amount > 0){
								$profit = '<span style="color: #38cb74">'.number_format($updated_data->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
							} else {
								$profit = '<span>'.number_format($updated_data->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
							}
							$bet_data = array(
								'date'	=> date('H:i:s', time()),
								//'game'	=> '<span title="verify" style="cursor: pointer"><i class="fas fa-gem"></i> '.$this->lang->print('game_gems').'</span>',
								'user_name'	=> $this->user_info->user_name,
								'bet_amount'	=> number_format($updated_data->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
								'payout'	=> '<span style="color: #03a9f4">'.number_format($payout, 2, '.', '').'×</span>',
								'profit'	=> $profit,
								///16022025//
								'difficulty'	=> $difficulty,
								'tiles' 		=> $tiles,
								'gems'			=> $gems,
								'nonce'			=> $game_data->nonce,
								'client_seed'	=> $game_data->client_seed,
								'server_seed'	=> $game_data->server_seed,
								'server_seed_hash'	=> $game_data->server_seed_hash,
								'timestamp'		=> time(),
								'game_name'	=> 'Gems',
								'game_id'		=> $game_data->game_id,
								///16022025//
							);
							echo json_encode(array('ret' => 1, 'type' => 'gem', 'gems' => $gems, 'multiplier' => number_format($updated_data->payout, 2, '.', '').'×', 'win_amount' => $updated_data->win_amount, 'balance' => $this->user_info->balance + $updated_data->bet_amount + $updated_data->win_amount, 'bet_data' => $bet_data, 'mes' => $this->lang->print('open_all_gems')));
						}
					}
				} 
			} else if($action == 'cashout_game_gems') {
				if($tiles[0] == -1) {
					echo json_encode(array('ret' => 0, 'mes' => "Please choose at least one tile!"));
				} else {
					$payout = 1;
					$steps = 0;
					for($i = 0; $i < sizeof($tiles); $i++) {
						if($tiles[$i] == -1) {
							break;
						}
						$steps++;
					}
					$payout = $this->Game->calculate_game_gems_payout($difficulty, $steps);
					$updated_data = clone($game_data);
					$updated_data->payout = $payout;
					//$updated_data->win_amount = intval(($updated_data->payout - 1) * $updated_data->bet_amount);
					$updated_data->win_amount = intval($updated_data->payout * $updated_data->bet_amount - $updated_data->bet_amount);
					$updated_data->completion_time = time();
					$this->Game->update_game_data($game_data, $updated_data);
					$this->User->update_user_bet_data($this->user_info, $game_data->bet_amount, $updated_data->win_amount, $this->user_info->balance + $updated_data->bet_amount + $updated_data->win_amount);
					
					if($updated_data->win_amount < 0) {
						$profit = '<span style="color: #ff5722">'.number_format($updated_data->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					} else if($updated_data->win_amount > 0){
						$profit = '<span style="color: #38cb74">'.number_format($updated_data->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					} else {
						$profit = '<span>'.number_format($updated_data->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					}
					$bet_data = array(
						'date'	=> date('H:i:s', time()),
						//'game'	=> '<span title="verify" style="cursor: pointer"><i class="fas fa-gem"></i> '.$this->lang->print('game_gems').'</span>',
						'user_name'	=> $this->user_info->user_name,
						'bet_amount'	=> number_format($updated_data->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
						'payout'	=> '<span style="color: #03a9f4">'.number_format($payout, 2, '.', '').'×</span>',
						'profit'	=> $profit,
						///16022025//
						'difficulty'	=> $difficulty,
						'tiles' 		=> $tiles,
						'gems'			=> $gems,
						'nonce'			=> $game_data->nonce,
						'client_seed'	=> $game_data->client_seed,
						'server_seed'	=> $game_data->server_seed,
						'server_seed_hash'	=> $game_data->server_seed_hash,
						'timestamp'		=> time(),
						'game_name'	=> 'Gems',
						'game_id'		=> $game_data->game_id,
						///16022025//
					);
					echo json_encode(array('ret' => 1, 'gems' => $gems, 'multiplier' => number_format($updated_data->payout, 2, '.', '').'×', 'win_amount' => $updated_data->win_amount, 'balance' => $this->user_info->balance + $updated_data->bet_amount + $updated_data->win_amount, 'bet_data' => $bet_data, 'mes' => $this->lang->print('cashout_success')));
				}
			}
			if($this->user_info->nonce % 500 == 0) {
				$deleted_rows = $this->user_info->nonce - 500;
				$this->Game->delete_bet_rows_by_user($this->user_info->user_id, $deleted_rows);
			}
		}
	}
	
	public function process_bet_game_slots() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$ip_address = $this->get_client_ip();
			$MIN_BET_AMOUNT = 1;
			$MAX_BET_AMOUNT = $this->MAX_BET_AMOUNT;
			$bet_amount = intval(floatval($this->input->post_get('bet_amount')) * $this->UNITS_PER_COIN + 0.000000001);
			$lines = intval($this->input->post_get('lines'));


			if($bet_amount < $MIN_BET_AMOUNT) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_less_err', ($MIN_BET_AMOUNT / $this->UNITS_PER_COIN))));
			} else if ($lines < 1 || $lines > 3) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('select_num_lines_err')));
			} else if ($bet_amount * $lines > $this->user_info->balance) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('insufficient_balance_err')));
			} else if ($bet_amount * $lines > $MAX_BET_AMOUNT) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_much_err', ($MAX_BET_AMOUNT / $this->UNITS_PER_COIN))));
			} else {
				$numbers = $this->Game->generate_game_slots_data($this->user_info->nonce, $this->user_info->client_seed, $this->user_info->server_seed);
				$num1 = $numbers[0];
				$num2 = $numbers[1];
				$num3 = $numbers[2];
				$reels	= $this->Game->get_game_slots_reels();
				$reel1 = $reels[0];
				$reel2 = $reels[1];
				$reel3 = $reels[2];
				$payout1 = 0;
				$payout2 = 0;
				$payout3 = 0;
				if($lines >= 1) {
					$line1 = array($reel1[($num1 % 36)], $reel2[($num2 % 36)], $reel3[($num3 % 36)]);
					$payout1 = $this->Game->calculate_game_slots_payout_by_line($line1);
				}
				if($lines >= 2) {
					$line2 = array($reel1[(($num1 - 1 + 36) % 36)], $reel2[(($num2 - 1 + 36) % 36)], $reel3[(($num3 - 1 + 36) % 36)]);
					$payout2 = $this->Game->calculate_game_slots_payout_by_line($line2);
				}
				if($lines >= 3) {
					$line3 = array($reel1[(($num1 + 1) % 36)], $reel2[(($num2 + 1) % 36)], $reel3[(($num3 + 1) % 36)]);
					$payout3 = $this->Game->calculate_game_slots_payout_by_line($line3);
				}
				$payout = $payout1 + $payout2 + $payout3;
				
				if(!$this->user_info->show_server_seed_hash) {
					while(($bet_amount * $payout) - ($bet_amount * $lines) >=300000000) {
						$new_server_seed = $this->create_random_key(64);
						$new_server_seed_hash = hash('sha256', $new_server_seed);
						$numbers = $this->Game->generate_game_slots_data($this->user_info->nonce, $this->user_info->client_seed, $new_server_seed);
						$num1 = $numbers[0];
						$num2 = $numbers[1];
						$num3 = $numbers[2];
						if($lines >= 1) {
							$line1 = array($reel1[($num1 % 36)], $reel2[($num2 % 36)], $reel3[($num3 % 36)]);
							$payout1 = $this->Game->calculate_game_slots_payout_by_line($line1);
						}
						if($lines >= 2) {
							$line2 = array($reel1[(($num1 - 1 + 36) % 36)], $reel2[(($num2 - 1 + 36) % 36)], $reel3[(($num3 - 1 + 36) % 36)]);
							$payout2 = $this->Game->calculate_game_slots_payout_by_line($line2);
						}
						if($lines >= 3) {
							$line3 = array($reel1[(($num1 + 1) % 36)], $reel2[(($num2 + 1) % 36)], $reel3[(($num3 + 1) % 36)]);
							$payout3 = $this->Game->calculate_game_slots_payout_by_line($line3);
						}
						$payout = $payout1 + $payout2 + $payout3;
					}
					if(isset($new_server_seed)) {
						$updated_info = clone($this->user_info);
						$updated_info->server_seed = $new_server_seed;
						$updated_info->server_seed_hash = $new_server_seed_hash;
						$this->User->update_user_info($this->user_info, $updated_info);
						$this->user_info->server_seed = $updated_info->server_seed;
						$this->user_info->server_seed_hash = $updated_info->server_seed_hash;
					}	
				}
				
				if($payout > 0) {
					$win_amount = ($bet_amount * $payout) - ($bet_amount * $lines);
				} else {
					$win_amount = -($bet_amount * $lines);
				}
				$game_id = $this->Game->create_new_game(
					$this->user_info->user_id,
					$this->user_info->user_name,
					$ip_address,
					'Slots',
					$this->user_info->nonce,
					$this->user_info->client_seed,
					$this->user_info->server_seed,
					$this->user_info->server_seed_hash,
					$bet_amount,
					$payout,
					json_encode(array('lines' => $lines)),
					json_encode(array('numbers' => $numbers)),
					$win_amount,
					time(),
					time(),
					$this->user_info->show_server_seed_hash,   // show server seed hash //
				);
				if($game_id == 0) {
					$this->change_server_seed();
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('connection_timeout')));
					return;
				}
				if($win_amount < 0) {
					$profit = '<span style="color: #ff5722">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				} else if($win_amount > 0){
					$profit = '<span style="color: #38cb74">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				} else {
					$profit = '<span>'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				}
				
				$bet_data = array(
					'date'	=> date('H:i:s', time()),
					//'game'	=> '<span title="verify" style="cursor: pointer"><i class="fas fa-lemon"></i> '.$this->lang->print('game_slots').'</span>',
					'user_name'	=> $this->user_info->user_name,
					'bet_amount'	=> number_format($bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
					'payout'	=> '<span style="color: #03a9f4">'.number_format($payout, 2, '.', '').'×</span>',
					'profit'	=> $profit,
					///16022025//
					'lines'			=> $lines,
					'numbers'		=> $numbers,
					'nonce'			=> $this->user_info->nonce,
					'client_seed'	=> $this->user_info->client_seed,
					'server_seed'	=> $this->user_info->server_seed,
					'server_seed_hash'	=> $this->user_info->server_seed_hash,
					'timestamp'		=> time(),
					'game_name'	=> 'Slots',
					'game_id'		=> $game_id,
					///16022025//
				);
				$this->User->update_user_bet_data($this->user_info, $bet_amount * $lines, $win_amount, $this->user_info->balance + $win_amount, $this->create_random_key(64));
				
				//stamina feature
				$this->update_user_stamina($bet_amount);
				//stamina feature
				
				echo json_encode(array('ret' => 1, 'nums' => $numbers, 'payouts' => array($payout1, $payout2, $payout3), 'balance' => ($this->user_info->balance + $win_amount), 'bet_data' => $bet_data, 'mes' => ""));
			}
			if($this->user_info->nonce % 500 == 0) {
				$deleted_rows = $this->user_info->nonce - 500;
				$this->Game->delete_bet_rows_by_user($this->user_info->user_id, $deleted_rows);
			}
		}
	}
	
	public function process_bet_game_mines() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$MIN_BET_AMOUNT = $this->MIN_BET_AMOUNT;
			$MAX_BET_AMOUNT = $this->MAX_BET_AMOUNT;
			$MIN_MINES = 1;
			$MAX_MINES = 24;
			$MIN_TILE_ID = 0;
			$MAX_TILE_ID = 24;
			$TOTAL_TILES = 25;
			$BET_MAX_ODDS = 0.97;
			
			$action = $this->input->post_get('action');
			$ip_address = $this->get_client_ip();
			$game_data = $this->Game->get_last_game_data_by_uid('Mines', $this->user_info->user_id);
			$tiles = array();
			$mines = array();
			if($game_data != null) {
				$tiles = json_decode($game_data->prediction)->tiles;
				$mines = json_decode($game_data->data)->mines;
			}
			
			
			if($action == 'bet_game_mines') {
				$bet_amount = intval(floatval($this->input->post_get('bet_amount')) * $this->UNITS_PER_COIN + 0.000000001);
				$num_mines = intval($this->input->post_get('num_mines'));
				if(sizeof($mines) > 0) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('create_game_err')));
				} else if($bet_amount < $MIN_BET_AMOUNT) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_less_err', ($MIN_BET_AMOUNT / $this->UNITS_PER_COIN))));
				} else if ($bet_amount > $this->user_info->balance) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('insufficient_balance_err')));
				} else if ($bet_amount > $MAX_BET_AMOUNT) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_much_err', ($MAX_BET_AMOUNT / $this->UNITS_PER_COIN))));
				} else if ($num_mines < $MIN_MINES || $num_mines > $MAX_MINES) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('select_num_mines_err')));
				} else {
					$mines = $this->Game->generate_mines_map($this->user_info->nonce, $this->user_info->client_seed, $this->user_info->server_seed);
					$mines = array_slice($mines, 0, $num_mines);
					$game_id = $this->Game->create_new_game(
						$this->user_info->user_id,
						$this->user_info->user_name,
						$ip_address,
						'Mines',
						$this->user_info->nonce,
						$this->user_info->client_seed,
						$this->user_info->server_seed,
						$this->user_info->server_seed_hash,
						$bet_amount,
						0,
						json_encode(array('tiles' => array())),
						json_encode(array('mines' => $mines)),
						0,
						time(),
						0,
						$this->user_info->show_server_seed_hash,   // show server seed hash //
					);
					if($game_id == 0) {
						$this->change_server_seed();
						echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('connection_timeout')));
						return;
					}
					
					$updated_info = clone($this->user_info);
					$updated_info->balance -= $bet_amount;
					
					//**01/03/2021**//
					$updated_info->nonce  += 1;
					$updated_info->server_seed = $this->create_random_key(64);
					$updated_info->show_server_seed_hash = 0;
					$updated_info->server_seed_hash = hash('sha256', $updated_info->server_seed);
					//**01/03/2021**//
					
					//stamina feature
					$this->update_user_stamina($bet_amount);
					//stamina feature					
					
					$this->User->update_user_info($this->user_info, $updated_info);
					echo json_encode(array('ret' => 1, 'balance' => $updated_info->balance, 'mes' => $this->lang->print('create_game_success')));
				}
			} else if($action == 'select_tile_game_mines') {
				$tile_id = intval($this->input->post_get('tile_id'));
				if(sizeof($mines) == 0) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('unstarted_game_err')));
				} else {
					if($tile_id < $MIN_TILE_ID || $tile_id > $MAX_TILE_ID) {
						echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('choose_tile_err')));
					} else if (in_array($tile_id, $tiles)) {
						echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('tile_chosen_err')));
					} else {
						if(in_array($tile_id, $mines)) {
							array_push($tiles, $tile_id);
							$updated_data = clone($game_data);
							$updated_data->prediction = json_encode(array('tiles' => $tiles));
							$updated_data->payout = 0;
							$updated_data->win_amount = -$game_data->bet_amount;
							$updated_data->completion_time = time();
							$this->Game->update_game_data($game_data, $updated_data);
							$this->User->update_user_bet_data($this->user_info, $game_data->bet_amount, -$game_data->bet_amount, $this->user_info->balance);
							
							$win_amount = $updated_data->win_amount;
							if($win_amount < 0) {
								$profit = '<span style="color: #ff5722">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
							} else if($win_amount > 0){
								$profit = '<span style="color: #38cb74">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
							} else {
								$profit = '<span>'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
							}
							$bet_data = array(
								'date'	=> date('H:i:s', time()),
								//'game'	=> '<span title="verify" style="cursor: pointer"><i class="fas fa-bomb"></i> '.$this->lang->print('game_mines').'</span>',
								'user_name'	=> $this->user_info->user_name,
								'bet_amount'	=> number_format($updated_data->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
								'payout'	=> '<span style="color: #03a9f4">'.number_format($updated_data->payout, 2, '.', '').'×</span>',
								'profit'	=> $profit,
								///16022025//
								'tiles' 		=> $tiles,
								'mines'			=> $mines,
								'nonce'			=> $game_data->nonce,
								'client_seed'	=> $game_data->client_seed,
								'server_seed'	=> $game_data->server_seed,
								'server_seed_hash'	=> $game_data->server_seed_hash,
								'timestamp'		=> time(),
								'game_name'	=> 'Mines',
								'game_id'		=> $game_data->game_id,
								///16022025//
							);
							
							echo json_encode(array('ret' => 1, 'type' => 'mine', 'mines' => $mines, 'balance' => $this->user_info->balance, 'bet_data' => $bet_data, 'mes' => $this->lang->print('open_a_bomb')));
						} else {
							array_push($tiles, $tile_id);
							if(sizeof($tiles) + sizeof($mines) < $TOTAL_TILES) {
								$updated_data = clone($game_data);
								$updated_data->prediction = json_encode(array('tiles' => $tiles));
								$this->Game->update_game_data($game_data, $updated_data);
								echo json_encode(array('ret' => 1, 'type' => 'gem', 'mines' => '', 'balance' => $this->user_info->balance, 'mes' => $this->lang->print('open_a_gem')));
							} else {
								$current_payout = 1;
								$next_tile_payout = floatval($BET_MAX_ODDS * $TOTAL_TILES / ($TOTAL_TILES - sizeof($mines)));
								for($i = 0; $i < sizeof($tiles); $i++) {
									$current_payout = $next_tile_payout;
									if($TOTAL_TILES - sizeof($mines) - $i > 0) {
										$next_tile_payout = floatval($next_tile_payout * floatval($BET_MAX_ODDS * ($TOTAL_TILES - $i) / ($TOTAL_TILES - sizeof($mines) - $i)));
									}
								}
								//$current_payout = number_format($current_payout, 2, '.', '');
								$current_payout = round($current_payout, 2); // float
								$updated_data = clone($game_data);
								$updated_data->prediction = json_encode(array('tiles' => $tiles));
								$updated_data->payout = $current_payout;
								$updated_data->win_amount = intval($updated_data->payout * $updated_data->bet_amount - $updated_data->bet_amount);
								$updated_data->completion_time = time();
								$this->Game->update_game_data($game_data, $updated_data);
								$this->User->update_user_bet_data($this->user_info, $game_data->bet_amount, $updated_data->win_amount, $this->user_info->balance + $updated_data->bet_amount + $updated_data->win_amount);
								
								$win_amount = $updated_data->win_amount;
								if($win_amount < 0) {
									$profit = '<span style="color: #ff5722">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
								} else if($win_amount > 0){
									$profit = '<span style="color: #38cb74">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
								} else {
									$profit = '<span>'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
								}
								$bet_data = array(
									'date'	=> date('H:i:s', time()),
									//'game'	=> '<span title="verify" style="cursor: pointer"><i class="fas fa-bomb"></i> '.$this->lang->print('game_mines').'</span>',
									'user_name'	=> $this->user_info->user_name,
									'bet_amount'	=> number_format($updated_data->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
									'payout'	=> '<span style="color: #03a9f4">'.number_format($updated_data->payout, 2, '.', '').'×</span>',
									'profit'	=> $profit,
									///16022025//
									'tiles' 		=> $tiles,
									'mines'			=> $mines,
									'nonce'			=> $game_data->nonce,
									'client_seed'	=> $game_data->client_seed,
									'server_seed'	=> $game_data->server_seed,
									'server_seed_hash'	=> $game_data->server_seed_hash,
									'timestamp'		=> time(),
									'game_name'	=> 'Mines',
									'game_id'		=> $game_data->game_id,
									///16022025//
								);
								
								echo json_encode(array('ret' => 1, 'type' => 'gem', 'mines' => $mines, 'multiplier' => number_format($updated_data->payout, 2, '.', '').'×', 'win_amount' => $win_amount, 'balance' => $this->user_info->balance, 'bet_data' => $bet_data, 'mes' => $this->lang->print('open_all_gems')));
							}
						}
					}
					
				} 
				
			} else if($action == 'cashout_game_mines') {
				if(sizeof($tiles) == 0) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('no_tiles_selected_err')));
				} else {
					
					$current_payout = 1;
					$next_tile_payout = floatval($BET_MAX_ODDS * $TOTAL_TILES / ($TOTAL_TILES - sizeof($mines)));
					for($i = 0; $i < sizeof($tiles); $i++) {
						$current_payout = $next_tile_payout;	
						$next_tile_payout = floatval($next_tile_payout * floatval($BET_MAX_ODDS * ($TOTAL_TILES - $i) / ($TOTAL_TILES - sizeof($mines) - $i)));
					}
					//$current_payout = number_format($current_payout, 2, '.', '');
					$current_payout = round($current_payout, 2); // float
					$updated_data = clone($game_data);
					$updated_data->payout = $current_payout;
					$updated_data->win_amount = intval($updated_data->payout * $updated_data->bet_amount - $updated_data->bet_amount);
					$updated_data->completion_time = time();
					$this->Game->update_game_data($game_data, $updated_data);
					$this->User->update_user_bet_data($this->user_info, $game_data->bet_amount, $updated_data->win_amount, $this->user_info->balance + $updated_data->bet_amount + $updated_data->win_amount);
					
					$win_amount = $updated_data->win_amount;
					if($win_amount < 0) {
						$profit = '<span style="color: #ff5722">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					} else if($win_amount > 0){
						$profit = '<span style="color: #38cb74">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					} else {
						$profit = '<span>'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					}
					$bet_data = array(
						'date'	=> date('H:i:s', time()),
						//'game'	=> '<span title="verify" style="cursor: pointer"><i class="fas fa-bomb"></i> '.$this->lang->print('game_mines').'</span>',
						'user_name'	=> $this->user_info->user_name,
						'bet_amount'	=> number_format($updated_data->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
						'payout'	=> '<span style="color: #03a9f4">'.number_format($updated_data->payout, 2, '.', '').'×</span>',
						'profit'	=> $profit,
						///16022025//
						'tiles' 		=> $tiles,
						'mines'			=> $mines,
						'nonce'			=> $game_data->nonce,
						'client_seed'	=> $game_data->client_seed,
						'server_seed'	=> $game_data->server_seed,
						'server_seed_hash'	=> $game_data->server_seed_hash,
						'timestamp'		=> time(),
						'game_name'	=> 'Mines',
						'game_id'		=> $game_data->game_id,
						///16022025//
					);
					
					echo json_encode(array('ret' => 1, 'mines' => $mines, 'multiplier' => number_format($updated_data->payout, 2, '.', '').'×', 'win_amount' => $win_amount, 'balance' => $this->user_info->balance + $updated_data->bet_amount + $updated_data->win_amount, 'bet_data' => $bet_data, 'mes' => $this->lang->print('cashout_success')));
				}
			}
			//mines auto
			else if($action == 'autobet_game_mines') {
				$bet_amount = intval(floatval($this->input->post_get('bet_amount')) * $this->UNITS_PER_COIN + 0.000000001);
				$num_mines = intval($this->input->post_get('num_mines'));
				$selected_tiles = $this->input->post_get('selected_auto_tiles');
				$selected_tiles = explode(',', $selected_tiles);
				for($i = 0; $i < count($selected_tiles); $i++) {
					$selected_tiles[$i] = max(0, min(intval($selected_tiles[$i]), 24));
				}
				$selected_tiles = array_unique($selected_tiles);
				if(sizeof($mines) > 0) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('game_created_err')));
				} else if($bet_amount < $MIN_BET_AMOUNT) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_less_err', ($MIN_BET_AMOUNT / $this->UNITS_PER_COIN))));
				} else if($bet_amount > $this->user_info->balance) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('insufficient_balance_err')));
				} else if($bet_amount > $MAX_BET_AMOUNT) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_much_err', ($MAX_BET_AMOUNT / $this->UNITS_PER_COIN))));
				} else if($num_mines < $MIN_MINES || $num_mines > $MAX_MINES) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('select_num_mines_err')));
				} else if(count($selected_tiles) <= 0){
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('no_tiles_selected_err')));
				} else if(count($selected_tiles) > $TOTAL_TILES - $num_mines) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('tile_limited_err')));
				} else {
					$mines = $this->Game->generate_mines_map($this->user_info->nonce, $this->user_info->client_seed, $this->user_info->server_seed);
					$mines = array_slice($mines, 0, $num_mines);
					$payout = 1;
					$next_tile_payout = floatval($BET_MAX_ODDS * $TOTAL_TILES / ($TOTAL_TILES - sizeof($mines)));
					for($i = 0; $i < count($selected_tiles); $i++) {
						if(in_array($selected_tiles[$i], $mines)) {
							$payout = 0;
							break;
						} else {
							$payout = $next_tile_payout;	
							$next_tile_payout = floatval($next_tile_payout * floatval($BET_MAX_ODDS * ($TOTAL_TILES - $i) / ($TOTAL_TILES - sizeof($mines) - $i)));
						}
					}
					if($payout > 0) {
						$win_amount = intval($this->floorp($bet_amount * ($payout - 1) + 0.000000000001, 8));
					} else {
						$win_amount = -$bet_amount;
					}
					
					$game_id = $this->Game->create_new_game(
						$this->user_info->user_id,
						$this->user_info->user_name,
						$ip_address,
						'Mines',
						$this->user_info->nonce,
						$this->user_info->client_seed,
						$this->user_info->server_seed,
						$this->user_info->server_seed_hash,
						$bet_amount,
						$payout,
						json_encode(array('tiles' => $selected_tiles)),
						json_encode(array('mines' => $mines)),
						$win_amount,
						time(),
						time()
					);
					if($game_id == 0) {
						$this->change_server_seed();
						echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('connection_timeout')));
						return;
					}
					
					if($win_amount < 0) {
						$profit = '<span style="color: #ff5722">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					} else if($win_amount > 0){
						$profit = '<span style="color: #38cb74">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					} else {
						$profit = '<span>'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					}
					
					$bet_data = array(
						'date'	=> date('H:i:s', time()),
						//'game'	=> '<span title="verify" style="cursor: pointer"><i class="fas fa-bomb"></i> '.$this->lang->print('game_mines').'</span>',
						'user_name'	=> $this->user_info->user_name,
						'bet_amount'	=> number_format($bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
						'payout'	=> '<span style="color: #03a9f4">'.number_format($payout, 2, '.', '').'×</span>',
						'profit'	=> $profit,
						///16022025//
						'tiles' 		=> $selected_tiles,
						'mines'			=> $mines,
						'nonce'			=> $this->user_info->nonce,
						'client_seed'	=> $this->user_info->client_seed,
						'server_seed'	=> $this->user_info->server_seed,
						'server_seed_hash'	=> $this->user_info->server_seed_hash,
						'timestamp'		=> time(),
						'game_name'	=> 'Mines',
						'game_id'		=> $game_id,
						///16022025//
					);
					$this->User->update_user_bet_data($this->user_info, $bet_amount, $win_amount, $this->user_info->balance + $win_amount, $this->create_random_key(64));
					
					//stamina feature
					$this->update_user_stamina($bet_amount);
					//stamina feature
					
					if($this->user_info->nonce % 500 == 0) {
						$deleted_rows = $this->user_info->nonce - 500;
						$this->Game->delete_bet_rows_by_user($this->user_info->user_id, $deleted_rows);
					}
					echo json_encode(array('ret' => 1, 'mines' => $mines, 'tiles' => $selected_tiles, 'multiplier' => number_format($payout, 2, '.', '').'×', 'win_amount' => $win_amount, 'balance' => $this->user_info->balance + $win_amount, 'bet_data' => $bet_data, 'mes' => $this->lang->print('cashout_success')));
				}
			}
			//mines auto
		}
	}
	
	public function process_bet_game_poker() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$MIN_BET_AMOUNT = $this->MIN_BET_AMOUNT;
			$MAX_BET_AMOUNT = $this->MAX_BET_AMOUNT;
			
			$action = $this->input->post_get('action');
			$ip_address = $this->get_client_ip();
			$cards = '';
			$game_data = $this->Game->get_last_game_data_by_uid('Poker', $this->user_info->user_id);
			if($game_data != null) {
				$cards = json_decode($game_data->data)->cards;
			}
			if($action == 'bet_game_poker') {
				$bet_amount = intval(floatval($this->input->post_get('bet_amount')) * $this->UNITS_PER_COIN + 0.000000001);
				if($cards != '') {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('create_game_err')));
				} else if($bet_amount < $MIN_BET_AMOUNT) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_less_err', ($MIN_BET_AMOUNT / $this->UNITS_PER_COIN))));
				} else if ($bet_amount > $this->user_info->balance) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('insufficient_balance_err')));
				} else if ($bet_amount > $MAX_BET_AMOUNT) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_much_err', ($MAX_BET_AMOUNT / $this->UNITS_PER_COIN))));
				} else {

					$cards = $this->Game->generate_game_poker_data($this->user_info->nonce, $this->user_info->client_seed, $this->user_info->server_seed);
		
					//**08/10/2021**//
					if(!$this->user_info->show_server_seed_hash) { // show server seed hash //
						
						if($bet_amount >= 50000000) {
							$max_payout_allowed = 3;
						} else if($bet_amount >= 25000000) {
							$max_payout_allowed = 4;
						} else if($bet_amount >= 5000000){
							$max_payout_allowed = 6;
						} else if($bet_amount >= 2500000){
							$max_payout_allowed = 9;
						} else if($bet_amount >= 500000){
							$max_payout_allowed = 22;
						} else if($bet_amount >= 250000){
							$max_payout_allowed = 60;
						} else {
							$max_payout_allowed = 800;
						}
						

						while($this->Game->calculate_game_poker_max_payout($cards) > $max_payout_allowed) {
							$new_server_seed = $this->create_random_key(64);
							$new_server_seed_hash = hash('sha256', $new_server_seed);
							$cards = $this->Game->generate_game_poker_data($this->user_info->nonce, $this->user_info->client_seed, $new_server_seed);
						}
						if(isset($new_server_seed)) {
							$updated_info = clone($this->user_info);
							$updated_info->server_seed = $new_server_seed;
							$updated_info->server_seed_hash = $new_server_seed_hash;
							$this->User->update_user_info($this->user_info, $updated_info);
							$this->user_info->server_seed = $updated_info->server_seed;
							$this->user_info->server_seed_hash = $updated_info->server_seed_hash;
						}
						
					}
					//**08/10/2021**//

					
					
					$game_id = $this->Game->create_new_game(
						$this->user_info->user_id,
						$this->user_info->user_name,
						$ip_address,
						'Poker',
						$this->user_info->nonce,
						$this->user_info->client_seed,
						$this->user_info->server_seed,
						$this->user_info->server_seed_hash,
						$bet_amount,
						0,
						'',
						json_encode(array('cards' => $cards)),
						0,
						time(),
						0,
						$this->user_info->show_server_seed_hash,   // show server seed hash //
					);
					if($game_id == 0) {
						$this->change_server_seed();
						echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('connection_timeout')));
						return;
					}
					$cards = array_slice($cards, 0, 5);
					$updated_info = clone($this->user_info);
					$updated_info->balance -= $bet_amount;
					
					//**01/03/2021**//
					$updated_info->nonce  += 1;
					$updated_info->server_seed = $this->create_random_key(64);
					$updated_info->show_server_seed_hash = 0;
					$updated_info->server_seed_hash = hash('sha256', $updated_info->server_seed);
					//**01/03/2021**//
					
					//stamina feature
					$this->update_user_stamina($bet_amount);
					//stamina feature					
					
					
					$this->User->update_user_info($this->user_info, $updated_info);
					echo json_encode(array('ret' => 1, 'balance' => $updated_info->balance, 'cards' => $cards, 'mes' => $this->lang->print('create_game_success')));
				}
			} else if($action == 'deal_game_poker') {
				if($cards == '') {
					echo json_encode(array('ret' => 0, 'mes' => "Unexpected error!"));
				} else {
					$selected_cards = $this->input->post_get('selected_cards');
					$cards1 = array_slice($cards, 0, 5);
					$cards2 = array_slice($cards, 5, 5);
					if($selected_cards == '') {
						for($i = 0; $i < 5; $i++) {
							$cards1[$i] = $cards2[$i];
						}
					} else {
						$selected_cards = explode(',', $selected_cards);
						sort($selected_cards);
						for($i = 0; $i < sizeof($selected_cards); $i++) {
							$selected_cards[$i] = intval($selected_cards[$i]);
							if($selected_cards[$i] > 4) {
								$selected_cards[$i] = 4;
							}
							if($selected_cards[$i] < 0) {
								$selected_cards[$i] = 0;
							}
						}
						array_unique($selected_cards);
						for($i = 0; $i < 5; $i++) {
							if(!in_array($i, $selected_cards)) {
								$cards1[$i] = $cards2[$i];
							}
						}
					}
					$result = $this->Game->calculate_game_poker_result($cards1);
			
					
					$updated_data = clone($game_data);
					if($result != null) {
						$hand = $result[0];
						$highlights = array();
						for($i = 0; $i < sizeof($result[1]); $i++) {
							array_push($highlights, array_search($result[1][$i], $cards1));
						}
						sort($highlights);
						switch($hand) {
							case 'royal_flush':
							$updated_data->payout = 800;
							break;
							case 'straight_flush':
							$updated_data->payout = 60;
							break;
							case 'four_of_a_kind':
							$updated_data->payout = 22;
							break;
							case 'full_house':
							$updated_data->payout = 9;
							break;
							case 'flush':
							$updated_data->payout = 6;
							break;
							case 'straight':
							$updated_data->payout = 4;
							break;
							case 'three_of_a_kind':
							$updated_data->payout = 3;
							break;
							case 'two_pair':
							$updated_data->payout = 2;
							break;
							case 'pair_of_jack':
							$updated_data->payout = 1;
							break;
						}
					} else {
						$hand = null;
						$highlights = null;
						$updated_data->payout = 0;
					}
					$updated_data->win_amount = intval($updated_data->payout * $updated_data->bet_amount - $updated_data->bet_amount);
					$updated_data->completion_time = time();
					$updated_data->prediction = json_encode(array('selected_cards' => $selected_cards, 'hand' => strtoupper(str_replace('_', ' ', $hand)), 'highlights' => $highlights));
					
					$this->Game->update_game_data($game_data, $updated_data);
					$this->User->update_user_bet_data($this->user_info, $game_data->bet_amount, $updated_data->win_amount, $this->user_info->balance + $updated_data->bet_amount + $updated_data->win_amount);
						
					$win_amount = $updated_data->win_amount;
					if($win_amount < 0) {
						$profit = '<span style="color: #ff5722">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					} else if($win_amount > 0){
						$profit = '<span style="color: #38cb74">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					} else {
						$profit = '<span>'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					}
					$bet_data = array(
						'date'	=> date('H:i:s', time()),
						//'game'	=> '<span title="verify" style="cursor: pointer"><i class="fas fa-spade"></i> '.$this->lang->print('game_video_poker').'</span>',
						'user_name'	=> $this->user_info->user_name,
						'bet_amount'	=> number_format($updated_data->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
						'payout'	=> '<span style="color: #03a9f4">'.number_format($updated_data->payout, 2, '.', '').'×</span>',
						'profit'	=> $profit,
						///16022025//
						'selected_cards' 		=> $selected_cards,
						'hand'					=> $hand,
						'highlights'			=> $highlights,
						'cards'					=> $cards,
						'nonce'			=> $this->user_info->nonce,
						'client_seed'	=> $this->user_info->client_seed,
						'server_seed'	=> $this->user_info->server_seed,
						'server_seed_hash'	=> $this->user_info->server_seed_hash,
						'timestamp'		=> time(),
						'game_name'	=> 'Poker',
						'game_id'		=> $game_data->game_id,
						///16022025//
					);
					echo json_encode(array('ret' => 1, 'balance' => $this->user_info->balance + $updated_data->bet_amount + $updated_data->win_amount, 'bet_data' => $bet_data, 'cards' => $cards1, 'highlights' => $highlights, 'hand' => $hand, 'mes' => ''));
				
				}
			}
		}
	}
	
	public function process_bet_game_baccarat() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$ip_address = $this->get_client_ip();
			$MIN_BET_AMOUNT = $this->MIN_BET_AMOUNT;
			$MAX_BET_AMOUNT = $this->MAX_BET_AMOUNT;
			
			$bet_amount = intval(floatval($this->input->post_get('bet_amount')) * $this->UNITS_PER_COIN + 0.000000001);
			$bet_on = $this->input->post_get('bet_on');
			if($bet_amount < $MIN_BET_AMOUNT) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_less_err', ($MIN_BET_AMOUNT / $this->UNITS_PER_COIN))));
			} else if ($bet_amount > $this->user_info->balance) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('insufficient_balance_err')));
			} else if ($bet_amount > $MAX_BET_AMOUNT) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_much_err', ($MAX_BET_AMOUNT / $this->UNITS_PER_COIN))));
			} else if($bet_on != 'banker' && $bet_on != 'player' && $bet_on != 'tie') {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('select_player_banker_err')));
			} else {
				$cards = $this->Game->generate_game_baccarat_data($this->user_info->nonce, $this->user_info->client_seed, $this->user_info->server_seed);
				if(!$this->user_info->show_server_seed_hash) {
					
				}
				$game_result = $this->Game->calculate_game_baccarat_result($cards);
				$result = $game_result[0];
				$player_cards = $game_result[1];
				$player_total = $game_result[2];
				$banker_cards = $game_result[3];
				$banker_total = $game_result[4];
				
				if($bet_on == 'player' && $result == 1) {
					$payout = 2;
					$win_amount = intval($this->floorp($bet_amount * ($payout - 1) + 0.000000000001, 8));
				} else if($bet_on == 'banker' && $result == 2) {
					$payout = 2;
					$win_amount = intval($this->floorp($bet_amount * ($payout - 1) + 0.000000000001, 8));
				} else if($bet_on == 'tie' && $result == 3) {
					$payout = 9;
					$win_amount = intval($this->floorp($bet_amount * ($payout - 1) + 0.000000000001, 8));
				} else {
					$win_amount = -$bet_amount;
					$payout = 0;
				}
				
				$game_id = $this->Game->create_new_game(
					$this->user_info->user_id,
					$this->user_info->user_name,
					$ip_address,
					'Baccarat',
					$this->user_info->nonce,
					$this->user_info->client_seed,
					$this->user_info->server_seed,
					$this->user_info->server_seed_hash,
					$bet_amount,
					$payout,
					json_encode(array('bet_on' => $bet_on)),
					json_encode(array('player_cards' => $player_cards, 'banker_cards' => $banker_cards, 'player_total' => $player_total, 'banker_total' => $banker_total)),
					$win_amount,
					time(),
					time(),
					$this->user_info->show_server_seed_hash,   // show server seed hash //
				);
				if($game_id == 0) {
					$this->change_server_seed();
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('connection_timeout')));
					return;
				}
				if($win_amount < 0) {
					$profit = '<span style="color: #ff5722">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				} else if($win_amount > 0){
					$profit = '<span style="color: #38cb74">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				} else {
					$profit = '<span>'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				}
				$bet_data = array(
					'date'	=> date('H:i:s', time()),
					//'game'	=> '<span title="verify" style="cursor: pointer"><i class="fas fa-club"></i> '.$this->lang->print('game_baccarat').'</span>',
					'user_name'	=> $this->user_info->user_name,
					'bet_amount'	=> number_format($bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
					'payout'	=> '<span style="color: #03a9f4">'.number_format($payout, 2, '.', '').'×</span>',
					'payout2'	=> (($payout > 0) ? '<span>'.number_format($payout, 2, '.', '').'×</span>' : '<span>'.number_format($payout, 2, '.', '').'×</span>'),
					'profit'	=> $profit,
					///16022025//
					'player_cards'	=> $player_cards,
					'banker_cards'	=> $banker_cards,
					'player_total'	=> $player_total,
					'banker_total'	=> $banker_total,
					'nonce'			=> $this->user_info->nonce,
					'client_seed'	=> $this->user_info->client_seed,
					'server_seed'	=> $this->user_info->server_seed,
					'server_seed_hash'	=> $this->user_info->server_seed_hash,
					'timestamp'		=> time(),
					'game_name'	=> 'Baccarat',
					'game_id'		=> $game_id,
					///16022025//				
				);
				$this->User->update_user_bet_data($this->user_info, $bet_amount, $win_amount, $this->user_info->balance + $win_amount, $this->create_random_key(64));
				if($this->user_info->nonce % 500 == 0) {
					$deleted_rows = $this->user_info->nonce - 500;
					$this->Game->delete_bet_rows_by_user($this->user_info->user_id, $deleted_rows);
				}
				
				//stamina feature
				$this->update_user_stamina($bet_amount);
				//stamina feature				
				
				echo json_encode(array('ret' => 1, 'game_result' => $game_result, 'amount' => $win_amount, 'balance' => ($this->user_info->balance + $win_amount), 'bet_data' => $bet_data, 'mes' => ""));
			}
			
		}
	}
	
	public function process_bet_game_hilow() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$ip_address = $this->get_client_ip();
			$MIN_BET_AMOUNT = $this->MIN_BET_AMOUNT;
			$MAX_BET_AMOUNT = $this->MAX_BET_AMOUNT;
			
			$action = $this->input->post_get('action');
			$game_data = $this->Game->get_last_game_data_by_uid('Hilow', $this->user_info->user_id);
			
			$cards = array();
			
			if($game_data != null) {
				$cards = json_decode($game_data->data)->cards;
				$selections = json_decode($game_data->prediction)->selections;
			} else {
				$selections = array();
			}
			
			if($action == 'bet_game_hilow') {
				$bet_amount = intval(floatval($this->input->post_get('bet_amount')) * $this->UNITS_PER_COIN + 0.000000001);
				$start_card = intval($this->input->post_get('start_card'));
				if($game_data != null) {
					echo json_encode(array('ret' => 0, 'mes' => "Can't create new game!"));
				} else if($bet_amount < $MIN_BET_AMOUNT) {
					echo json_encode(array('ret' => 0, 'balance' => $this->user_info->balance, 'mes' => $this->lang->print('bet_amount_too_less_err', ($MIN_BET_AMOUNT / $this->UNITS_PER_COIN))));
				} else if ($bet_amount > $this->user_info->balance) {
					echo json_encode(array('ret' => 0, 'balance' => $this->user_info->balance, 'mes' => $this->lang->print('insufficient_balance_err')));
				} else if ($bet_amount > $MAX_BET_AMOUNT) {
					echo json_encode(array('ret' => 0, 'balance' => $this->user_info->balance, 'mes' => $this->lang->print('bet_amount_too_much_err', ($MAX_BET_AMOUNT / $this->UNITS_PER_COIN))));
				} else if($start_card < 0 || $start_card > 51){
					echo json_encode(array('ret' => 0, 'mes' => "Invalid start card!"));
				} else {
					//$cards = $this->Game->generate_gems_map($difficulty, $this->user_info->nonce, $this->user_info->client_seed, $this->user_info->server_seed);
					//array_push($cards, $start_card);
					//for($i = 0; $i < 52; $i++) {
					//	array_push($cards, rand(0, 51));
					//}
					$cards = $this->Game->generate_game_hilow_data($this->user_info->nonce, $this->user_info->client_seed, $this->user_info->server_seed);
					array_unshift($cards, $start_card);
					$game_id = $this->Game->create_new_game(
						$this->user_info->user_id,
						$this->user_info->user_name,
						$ip_address,
						'Hilow',
						$this->user_info->nonce,
						$this->user_info->client_seed,
						$this->user_info->server_seed,
						$this->user_info->server_seed_hash,
						$bet_amount,
						0,
						json_encode(array('selections' => array())),
						json_encode(array('cards' => $cards)),
						0,
						time(),
						0,
						$this->user_info->show_server_seed_hash,   // show server seed hash //
					);
					if($game_id == 0) {
						$this->change_server_seed();
						echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('connection_timeout')));
						return;
					}
					$updated_info = clone($this->user_info);
					$updated_info->balance -= $bet_amount;
					$updated_info->nonce  += 1;
					$updated_info->server_seed = $this->create_random_key(64);
					$updated_info->server_seed_hash = hash('sha256', $updated_info->server_seed);
					$updated_info->show_server_seed_hash = 0;
					$this->User->update_user_info($this->user_info, $updated_info);
					
					//stamina feature
					$this->update_user_stamina($bet_amount);
					//stamina feature					
					
					echo json_encode(array('ret' => 1, 'balance' => $updated_info->balance, 'mes' => $this->lang->print('create_game_success')));
				}
			} else if($action == 'open_card_game_hilow') {
				$bet_on = intval($this->input->post_get('bet_on'));
				if($game_data == null) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('unstarted_game_err')));
				} else if($bet_on != 1 && $bet_on != 2) { // 1 : lower or same | 2 : higher or same
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('invalid_input_err')));
				} else {
					$bet_result = 1;
					$current_number = $this->Game->calculate_game_hilow_number($cards[count($selections)]);
					$new_number = $this->Game->calculate_game_hilow_number($cards[count($selections) + 1]);
					//selections: lower(1) | lower or equal(2) | same(3) | higher or equal(4) | higher(5) 
					if($current_number == 1) {
						if($bet_on == 1) {
							$selection = 3; // equal
							if($new_number > $current_number) {
								$bet_result = 0;
							}
						} else if ($bet_on == 2) {
							$selection = 5; //higher
							if($new_number == $current_number) {
								$bet_result = 0;
							}
						}
					} else if ($current_number == 13) {
						if($bet_on == 1) {
							$selection = 1; // lower
							if($new_number == $current_number) {
								$bet_result = 0;
							}
						} else if ($bet_on == 2) {
							$selection = 3; //equal
							if($new_number < $current_number) {
								$bet_result = 0;
							}
						}
					} else {
						if($bet_on == 1) {
							$selection = 2; // lower or equal
							if($new_number > $current_number) {
								$bet_result = 0;
							}
						} else if ($bet_on == 2) {
							$selection = 4; //higher or equal
							if($new_number < $current_number) {
								$bet_result = 0;
							}
						}
					}
					
					
					///////////////////////////
					if(!$game_data->show_server_seed_hash && count($selections) == 0) {  // show server seed hash //
						$rand = rand(1, 100);
						$start_card = $cards[0];
						while($bet_result == 1) {
							$total_profit = $this->Game->calculate_game_hilow_profit(array_slice($cards, 0, 1), array($selection));
							if((($total_profit - 1) * $game_data->bet_amount >= 0.025 * $this->UNITS_PER_COIN && $rand < 5) 
							|| (($total_profit - 1) * $game_data->bet_amount >= 0.1 * $this->UNITS_PER_COIN && $rand < 7)
							|| (($total_profit - 1) * $game_data->bet_amount >= 0.5 * $this->UNITS_PER_COIN && $rand < 12)
							|| (($total_profit - 1) * $game_data->bet_amount >= 1 * $this->UNITS_PER_COIN && $rand < 20)
							|| (($total_profit - 1) * $game_data->bet_amount >= 3 * $this->UNITS_PER_COIN && $rand < 35)
							) {
								$new_server_seed = $this->create_random_key(64);
								$new_server_seed_hash = hash('sha256', $new_server_seed);
								$cards = $this->Game->generate_game_hilow_data($game_data->nonce, $game_data->client_seed, $new_server_seed);
								array_unshift($cards, $start_card);
								$bet_result = 1;
								$current_number = $this->Game->calculate_game_hilow_number($cards[count($selections)]);
								$new_number = $this->Game->calculate_game_hilow_number($cards[count($selections) + 1]);
								//selections: lower(1) | lower or equal(2) | same(3) | higher or equal(4) | higher(5) 
								if($current_number == 1) {
									if($bet_on == 1) {
										$selection = 3; // equal
										if($new_number > $current_number) {
											$bet_result = 0;
										}
									} else if ($bet_on == 2) {
										$selection = 5; //higher
										if($new_number == $current_number) {
											$bet_result = 0;
										}
									}
								} else if ($current_number == 13) {
									if($bet_on == 1) {
										$selection = 1; // lower
										if($new_number == $current_number) {
											$bet_result = 0;
										}
									} else if ($bet_on == 2) {
										$selection = 3; //equal
										if($new_number < $current_number) {
											$bet_result = 0;
										}
									}
								} else {
									if($bet_on == 1) {
										$selection = 2; // lower or equal
										if($new_number > $current_number) {
											$bet_result = 0;
										}
									} else if ($bet_on == 2) {
										$selection = 4; //higher or equal
										if($new_number < $current_number) {
											$bet_result = 0;
										}
									}
								}
								
								
							} else {
								break;
							}
						}
						if(isset($new_server_seed)) {
							$updated_data = clone($game_data);
							$updated_data->data = json_encode(array('cards' => $cards));
							$updated_data->server_seed = $new_server_seed;
							$updated_data->server_seed_hash = $new_server_seed_hash;
							$this->Game->update_game_data($game_data, $updated_data);
							$game_data->server_seed = $new_server_seed;
							$game_data->server_seed_hash = $new_server_seed_hash;
						}
					}
					///////////////////////////
					
					
					array_push($selections, $selection);
					$cards = array_slice($cards, 0, count($selections) + 1);
					$total_profit = $this->Game->calculate_game_hilow_profit($cards, $selections);
					
					if($bet_result == 0) {
						$updated_data = clone($game_data);
						$updated_data->prediction = json_encode(array('selections' => $selections));
						$updated_data->payout = 0;
						$updated_data->win_amount = -$game_data->bet_amount;
						$updated_data->completion_time = time();
						$this->Game->update_game_data($game_data, $updated_data);
						$this->User->update_user_bet_data($this->user_info, $game_data->bet_amount, -$game_data->bet_amount, $this->user_info->balance);

						if($updated_data->win_amount < 0) {
							$profit = '<span style="color: #ff5722">'.number_format($updated_data->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
						} else if($updated_data->win_amount > 0){
							$profit = '<span style="color: #38cb74">'.number_format($updated_data->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
						} else {
							$profit = '<span>'.number_format($updated_data->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
						}
						$bet_data = array(
							'date'	=> date('H:i:s', time()),
							//'game'	=> '<span title="verify" style="cursor: pointer"><i class="fas fa-sort-alt"></i> '.$this->lang->print('game_high_low').'</span>',
							'user_name'	=> $this->user_info->user_name,
							'bet_amount'	=> number_format($updated_data->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'payout'	=> '<span style="color: #03a9f4">'.number_format($updated_data->payout, 2, '.', '').'×</span>',
							'profit'	=> $profit,
							///16022025//
							'cards'			=> $cards,
							'selections' 	=> $selections,
							'nonce'			=> $game_data->nonce,
							'client_seed'	=> $game_data->client_seed,
							'server_seed'	=> $game_data->server_seed,
							'server_seed_hash'	=> $game_data->server_seed_hash,
							'timestamp'		=> time(),
							'game_name'	=> 'Hilow',
							'game_id'		=> $game_data->game_id,
							///16022025//
						);
						echo json_encode(array('ret' => 1, 'cards' => $cards, 'selections' => $selections, 'multiplier' => number_format($updated_data->payout, 2, '.', '').'×', 'profit' => $updated_data->win_amount, 'total_profit' => 0, 'bet_result' => $bet_result, 'balance' => $this->user_info->balance, 'bet_data' => $bet_data, 'mes' => $this->lang->print('you_lose')));
					} else {
						if(count($selections) < 52) {
							$updated_data = clone($game_data);
							$updated_data->prediction = json_encode(array('selections' => $selections));
							$this->Game->update_game_data($game_data, $updated_data);
							echo json_encode(array('ret' => 1, 'cards' => $cards, 'selections' => $selections, 'total_profit' => $total_profit, 'bet_result' => $bet_result, 'balance' => $this->user_info->balance, 'mes' => $this->lang->print('open_new_card')));
						} else {
							
						}
					}
				}
	
			} else if($action == 'cashout_game_hilow') {
				if(count($selections) == 0) {
					echo json_encode(array('ret' => 0, 'mes' => "You can't cashout!"));
				} else {
					$cards = array_slice($cards, 0, count($selections) + 1);
					$total_profit = $this->Game->calculate_game_hilow_profit($cards, $selections);
					
					$updated_data = clone($game_data);
					$updated_data->prediction = json_encode(array('selections' => $selections));
					$updated_data->payout = $total_profit;
					$updated_data->win_amount = round($updated_data->payout * $updated_data->bet_amount) - $game_data->bet_amount;
					$updated_data->completion_time = time();
					$this->Game->update_game_data($game_data, $updated_data);
					$this->User->update_user_bet_data($this->user_info, $game_data->bet_amount, $updated_data->win_amount, $this->user_info->balance + ($updated_data->payout * $updated_data->bet_amount));

					if($updated_data->win_amount < 0) {
						$profit = '<span style="color: #ff5722">'.number_format($updated_data->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					} else if($updated_data->win_amount > 0){
						$profit = '<span style="color: #38cb74">'.number_format($updated_data->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					} else {
						$profit = '<span>'.number_format($updated_data->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					}
					$bet_data = array(
						'date'	=> date('H:i:s', time()),
						//'game'	=> '<span title="verify" style="cursor: pointer"><i class="fas fa-sort-alt"></i> '.$this->lang->print('game_high_low').'</span>',
						'user_name'	=> $this->user_info->user_name,
						'bet_amount'	=> number_format($updated_data->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
						'payout'	=> '<span style="color: #03a9f4">'.number_format($updated_data->payout, 2, '.', '').'×</span>',
						'profit'	=> $profit,
						///16022025//
						'cards'			=> $cards,
						'selections' 	=> $selections,
						'nonce'			=> $game_data->nonce,
						'client_seed'	=> $game_data->client_seed,
						'server_seed'	=> $game_data->server_seed,
						'server_seed_hash'	=> $game_data->server_seed_hash,
						'timestamp'		=> time(),
						'game_name'	=> 'Hilow',
						'game_id'		=> $game_data->game_id,
						///16022025//
					);
					echo json_encode(array('ret' => 1, 'cards' => $cards, 'selections' => $selections, 'multiplier' => number_format($updated_data->payout, 2, '.', '').'×', 'profit' => $updated_data->win_amount, 'total_profit' => 0, 'bet_result' => 1, 'balance' => $this->user_info->balance + ($updated_data->payout * $updated_data->bet_amount), 'bet_data' => $bet_data, 'mes' => $this->lang->print('cashout_success')));
				}
			}
			if($this->user_info->nonce % 500 == 0) {
				$deleted_rows = $this->user_info->nonce - 500;
				$this->Game->delete_bet_rows_by_user($this->user_info->user_id, $deleted_rows);
			}
		}
	}
	
	public function process_bet_game_roulette() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$MIN_BET_AMOUNT = $this->MIN_BET_AMOUNT;
			$MAX_BET_AMOUNT = $this->MAX_BET_AMOUNT;
			
			$ip_address = $this->get_client_ip();
			$chip_bet = json_decode($this->input->post_get('chip_bet'));
			$bet_amount = 0;
			for($i = 0; $i < count($chip_bet); $i++) {
				$bet_amount += (100 * pow(10, intval($chip_bet[$i][1])));
			}

			if($bet_amount < $MIN_BET_AMOUNT) {
				echo json_encode(array('ret' => 0, 'balance' => $this->user_info->balance, 'mes' => $this->lang->print('bet_amount_too_less_err', ($MIN_BET_AMOUNT / $this->UNITS_PER_COIN))));
			} else if ($bet_amount > $this->user_info->balance) {
				echo json_encode(array('ret' => 0, 'balance' => $this->user_info->balance, 'mes' => $this->lang->print('insufficient_balance_err')));
			} else if ($bet_amount > $MAX_BET_AMOUNT) {
				echo json_encode(array('ret' => 0, 'balance' => $this->user_info->balance, 'mes' => $this->lang->print('bet_amount_too_much_err', ($MAX_BET_AMOUNT / $this->UNITS_PER_COIN))));
			} else if (!$this->Game->check_valid_game_roulette_chip_bet($chip_bet)) {
				echo json_encode(array('ret' => 0, 'balance' => $this->user_info->balance, 'mes' => $this->lang->print('invalid_input_err')));
			} else {
				$number = $this->Game->generate_game_roulette_number($this->user_info->nonce, $this->user_info->client_seed, $this->user_info->server_seed);
				$profit = $this->Game->calculate_game_roulette_profit($chip_bet, $number);
				
				if(!$this->user_info->show_server_seed_hash) {
					while(($profit - $bet_amount > 1.5 * 1e8 && rand(1, 100) < 75) 
						|| ($profit - $bet_amount > 0.75 * 1e8 && rand(1, 100) < 50)
						|| ($profit - $bet_amount > 0.5 * 1e8 && rand(1, 100) < 35)
						|| ($profit - $bet_amount > 0.1 * 1e8 && rand(1, 100) < 25)
						|| ($profit - $bet_amount > 0.05 * 1e8 && rand(1, 100) < 15)
						|| ($profit - $bet_amount > 0.01 * 1e8 && rand(1, 100) < 5)
					) {
						$new_server_seed = $this->create_random_key(64);
						$new_server_seed_hash = hash('sha256', $new_server_seed);
						$number = $this->Game->generate_game_roulette_number($this->user_info->nonce, $this->user_info->client_seed, $new_server_seed);
						$profit = $this->Game->calculate_game_roulette_profit($chip_bet, $number);
							
					}
					if(isset($new_server_seed)) {
						$updated_info = clone($this->user_info);
						$updated_info->server_seed = $new_server_seed;
						$updated_info->server_seed_hash = $new_server_seed_hash;
						$this->User->update_user_info($this->user_info, $updated_info);
						$this->user_info->server_seed = $updated_info->server_seed;
						$this->user_info->server_seed_hash = $updated_info->server_seed_hash;
					}
				}
				
				
				$win_amount = $profit - $bet_amount;
				//$payout = number_format($profit / $bet_amount, 2);
				$payout = round($profit / $bet_amount, 2); // float
				$game_id = $this->Game->create_new_game(
					$this->user_info->user_id,
					$this->user_info->user_name,
					$ip_address,
					'Roulette',
					$this->user_info->nonce,
					$this->user_info->client_seed,
					$this->user_info->server_seed,
					$this->user_info->server_seed_hash,
					$bet_amount,
					$payout,
					json_encode(array('chip_bet' => $chip_bet)),
					json_encode(array('number' => $number)),
					$win_amount,
					time(),
					time(),
					$this->user_info->show_server_seed_hash,   // show server seed hash //
				);
				if($game_id == 0) {
					$this->change_server_seed();
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('connection_timeout')));
					return;
				}
				if($win_amount < 0) {
					$profit = '<span style="color: #ff5722">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				} else if($win_amount > 0){
					$profit = '<span style="color: #38cb74">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				} else {
					$profit = '<span>'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				}
				
				$bet_data = array(
					'date'	=> date('H:i:s', time()),
					//'game'	=> '<span title="verify" style="cursor: pointer"><img src="'.base_url().'assets/img/games/roulette/roulette_icon.svg" style="width: 14px; height: 14px"> '.$this->lang->print('game_roulette').'</span>',
					'user_name'	=> $this->user_info->user_name,
					'bet_amount'	=> number_format($bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
					'payout'	=> '<span style="color: #03a9f4">'.number_format($payout, 2, '.', '').'×</span>',
					'profit'	=> $profit,
					///16022025//
					'chips'			=> $chip_bet,
					'number'		=> $number,
					'nonce'			=> $this->user_info->nonce,
					'client_seed'	=> $this->user_info->client_seed,
					'server_seed'	=> $this->user_info->server_seed,
					'server_seed_hash'	=> $this->user_info->server_seed_hash,
					'timestamp'		=> time(),
					'game_name'	=> 'Roulette',
					'game_id'		=> $game_id,
					///16022025//	
				);
				$this->User->update_user_bet_data($this->user_info, $bet_amount, $win_amount, $this->user_info->balance + $win_amount, $this->create_random_key(64));
				if($this->user_info->nonce % 500 == 0) {
					$deleted_rows = $this->user_info->nonce - 500;
					$this->Game->delete_bet_rows_by_user($this->user_info->user_id, $deleted_rows);
				}
				
				//stamina feature
				$this->update_user_stamina($bet_amount);
				//stamina feature				
				
				echo json_encode(array('ret' => 1, 'num' => $number, 'amount' => $win_amount, 'multiplier' => number_format($payout, 2, '.', '').'×', 'balance' => ($this->user_info->balance + $win_amount), 'bet_data' => $bet_data, 'mes' => ""));
			}
		}
	}
	
	public function process_bet_game_wheel() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$ip_address = $this->get_client_ip();
			$MIN_BET_AMOUNT = $this->MIN_BET_AMOUNT;
			$MAX_BET_AMOUNT = $this->MAX_BET_AMOUNT;
			
			$bet_amount = intval(floatval($this->input->post_get('bet_amount')) * $this->UNITS_PER_COIN + 0.0000001);

			if($bet_amount < $MIN_BET_AMOUNT) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_less_err', ($MIN_BET_AMOUNT / $this->UNITS_PER_COIN))));
			} else if ($bet_amount > $this->user_info->balance) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('insufficient_balance_err')));
			} else if ($bet_amount > $MAX_BET_AMOUNT) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_much_err', ($MAX_BET_AMOUNT / $this->UNITS_PER_COIN))));
			} else {
				$wheel_multiply = array(3, 0, 1.5, 0, 2.5, 0, 1, 0, 2, 0, 1.5, 0);
				$index = $this->Game->generate_game_wheel_index($this->user_info->nonce, $this->user_info->client_seed, $this->user_info->server_seed);
				$payout = $wheel_multiply[$index];
				
				if(!$this->user_info->show_server_seed_hash) {
					while($bet_amount * $payout >= 5 * $this->UNITS_PER_COIN) {
						$new_server_seed = $this->create_random_key(64);
						$new_server_seed_hash = hash('sha256', $new_server_seed);
						$index = $this->Game->generate_game_wheel_index($this->user_info->nonce, $this->user_info->client_seed, $new_server_seed);
						$payout = $wheel_multiply[$index];
					}
					if(isset($new_server_seed)) {
						$updated_info = clone($this->user_info);
						$updated_info->server_seed = $new_server_seed;
						$updated_info->server_seed_hash = $new_server_seed_hash;
						$this->User->update_user_info($this->user_info, $updated_info);
						$this->user_info->server_seed = $updated_info->server_seed;
						$this->user_info->server_seed_hash = $updated_info->server_seed_hash;
					}	
				}
				
				if($payout > 0) {
					$win_amount = ($bet_amount * ($payout - 1));
				} else {
					$win_amount = -$bet_amount;
				}
				$game_id = $this->Game->create_new_game(
					$this->user_info->user_id,
					$this->user_info->user_name,
					$ip_address,
					'Wheel',
					$this->user_info->nonce,
					$this->user_info->client_seed,
					$this->user_info->server_seed,
					$this->user_info->server_seed_hash,
					$bet_amount,
					$payout,
					'',
					json_encode(array('index' => $index)),
					$win_amount,
					time(),
					time(),
					$this->user_info->show_server_seed_hash,   // show server seed hash //
				);
				if($game_id == 0) {
					$this->change_server_seed();
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('connection_timeout')));
					return;
				}
				if($win_amount < 0) {
					$profit = '<span style="color: #ff5722">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				} else if($win_amount > 0){
					$profit = '<span style="color: #38cb74">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				} else {
					$profit = '<span>'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				}
				
				$bet_data = array(
					'date'	=> date('H:i:s', time()),
					//'game'	=> '<span title="verify" style="cursor: pointer"><i class="fas fa-tire"></i> '.$this->lang->print('game_wof').'</span>',
					'user_name'	=> $this->user_info->user_name,
					'bet_amount'	=> number_format($bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
					'payout'	=> '<span>'.number_format($payout, 2, '.', '').'×</span>',
					'profit'	=> $profit,
					///16022025//
					'index'			=> $index,
					'nonce'			=> $this->user_info->nonce,
					'client_seed'	=> $this->user_info->client_seed,
					'server_seed'	=> $this->user_info->server_seed,
					'server_seed_hash'	=> $this->user_info->server_seed_hash,
					'timestamp'		=> time(),
					'game_name'	=> 'Wheel',
					'game_id'		=> $game_id,
					///16022025//
				);
				$this->User->update_user_bet_data($this->user_info, $bet_amount, $win_amount, $this->user_info->balance + $win_amount, $this->create_random_key(64));
				
				//stamina feature
				$this->update_user_stamina($bet_amount);
				//stamina feature				
				
				echo json_encode(array('ret' => 1, 'index' => $index, 'balance' => ($this->user_info->balance + $win_amount), 'win_amount' => $win_amount, 'bet_data' => $bet_data, 'mes' => ""));
			}
			if($this->user_info->nonce % 500 == 0) {
				$deleted_rows = $this->user_info->nonce - 500;
				$this->Game->delete_bet_rows_by_user($this->user_info->user_id, $deleted_rows);
			}
		}
	}
	
	public function process_bet_game_plinko() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$ip_address = $this->get_client_ip();
			$MIN_BET_AMOUNT = $this->MIN_BET_AMOUNT;
			$MAX_BET_AMOUNT = $this->MAX_BET_AMOUNT;
			
			$bet_amount = intval(floatval($this->input->post_get('bet_amount')) * $this->UNITS_PER_COIN + 0.0000001);
			$game_risk = intval($this->input->post_get('risk'));
			$game_risk = max(min($game_risk, 2), 0);

			if($bet_amount < $MIN_BET_AMOUNT) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_less_err', ($MIN_BET_AMOUNT / $this->UNITS_PER_COIN))));
			} else if ($bet_amount > $this->user_info->balance) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('insufficient_balance_err')));
			} else if ($bet_amount > $MAX_BET_AMOUNT) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_much_err', ($MAX_BET_AMOUNT / $this->UNITS_PER_COIN))));
			} else {
				
				
				$direction_idx = $this->Game->generate_game_plinko_direction($this->user_info->nonce, $this->user_info->client_seed, $this->user_info->server_seed);
				$payout = $this->Game->calculate_game_plinko_payout($game_risk, $direction_idx);
				
				if(!$this->user_info->show_server_seed_hash) {
					while($bet_amount * $payout >= 5 * $this->UNITS_PER_COIN) {
						$new_server_seed = $this->create_random_key(64);
						$new_server_seed_hash = hash('sha256', $new_server_seed);
						$direction_idx = $this->Game->generate_game_plinko_direction($this->user_info->nonce, $this->user_info->client_seed, $new_server_seed);
						$payout = $this->Game->calculate_game_plinko_payout($game_risk, $direction_idx);
					}
					if(isset($new_server_seed)) {
						$updated_info = clone($this->user_info);
						$updated_info->server_seed = $new_server_seed;
						$updated_info->server_seed_hash = $new_server_seed_hash;
						$this->User->update_user_info($this->user_info, $updated_info);
						$this->user_info->server_seed = $updated_info->server_seed;
						$this->user_info->server_seed_hash = $updated_info->server_seed_hash;
					}	
				}
				
				if($payout > 0) {
					$win_amount = ($bet_amount * ($payout - 1));
				} else {
					$win_amount = -$bet_amount;
				}
				$game_id = $this->Game->create_new_game(
					$this->user_info->user_id,
					$this->user_info->user_name,
					$ip_address,
					'Plinko',
					$this->user_info->nonce,
					$this->user_info->client_seed,
					$this->user_info->server_seed,
					$this->user_info->server_seed_hash,
					$bet_amount,
					$payout,
					json_encode(array('risk' => $game_risk)),
					json_encode(array('direction_idx' => $direction_idx)),
					$win_amount,
					time(),
					time(),
					$this->user_info->show_server_seed_hash,   // show server seed hash //
				);
				if($game_id == 0) {
					$this->change_server_seed();
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('connection_timeout')));
					return;
				}
				if($win_amount < 0) {
					$profit = '<span style="color: #ff5722">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				} else if($win_amount > 0){
					$profit = '<span style="color: #38cb74">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				} else {
					$profit = '<span>'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				}
				
				$bet_data = array(
					'date'	=> date('H:i:s', time()),
					//'game'	=> '<span title="verify" style="cursor: pointer"><i class="fas fa-ball-pile"></i> '.$this->lang->print('game_plinko').'</span>',
					'user_name'	=> $this->user_info->user_name,
					'bet_amount'	=> number_format($bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
					'payout'	=> '<span style="color: #03a9f4">'.number_format($payout, 2, '.', '').'×</span>',
					'profit'	=> $profit,
					///16022025//
					'risk'			=> $game_risk,
					'direction_idx'	=> $direction_idx,
					'nonce'			=> $this->user_info->nonce,
					'client_seed'	=> $this->user_info->client_seed,
					'server_seed'	=> $this->user_info->server_seed,
					'server_seed_hash'	=> $this->user_info->server_seed_hash,
					'timestamp'		=> time(),
					'game_name'	=> 'Plinko',
					'game_id'		=> $game_id,
					///16022025//		
				);
				$this->User->update_user_bet_data($this->user_info, $bet_amount, $win_amount, $this->user_info->balance + $win_amount, $this->create_random_key(64));
				
				//stamina feature
				$this->update_user_stamina($bet_amount);
				//stamina feature				
				
				echo json_encode(array('ret' => 1, 'direction_idx' => $direction_idx, 'balance' => ($this->user_info->balance + $win_amount), 'win_amount' => $win_amount, 'bet_data' => $bet_data, 'mes' => ""));
			}
			if($this->user_info->nonce % 500 == 0) {
				$deleted_rows = $this->user_info->nonce - 500;
				$this->Game->delete_bet_rows_by_user($this->user_info->user_id, $deleted_rows);
			}
		}
	}
	
	public function process_bet_game_limbo() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$ip_address = $this->get_client_ip();
			$BET_MAX_ODDS = 9700;
			$MIN_BET_AMOUNT = $this->MIN_BET_AMOUNT;
			$MAX_BET_AMOUNT = $this->MAX_BET_AMOUNT;
			
			$MIN_MULTIPLIER = 1.01;
			$MAX_MULTIPLIER = $BET_MAX_ODDS / 2;
			$bet_amount = intval(floatval($this->input->post_get('bet_amount')) * $this->UNITS_PER_COIN + 0.000000001);
			$target_payout = floatval($this->input->post_get('payout'));

			if($bet_amount < $MIN_BET_AMOUNT) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_less_err', ($MIN_BET_AMOUNT / $this->UNITS_PER_COIN))));
			} else if ($bet_amount > $this->user_info->balance) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('insufficient_balance_err')));
			} else if ($bet_amount > $MAX_BET_AMOUNT) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_much_err', ($MAX_BET_AMOUNT / $this->UNITS_PER_COIN))));
			} else if ($target_payout < $MIN_MULTIPLIER) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('min_multiplier_err', $MIN_MULTIPLIER)));
			} else if ($target_payout > $MAX_MULTIPLIER) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('max_multiplier_err', $MAX_MULTIPLIER)));
			} else {
				//$target_payout = number_format(floatval($BET_MAX_ODDS / (10000 - round(10000 - ($BET_MAX_ODDS /  $target_payout)))), 2, '.', '');
				$target_payout = round($BET_MAX_ODDS / (10000 - round(10000 - ($BET_MAX_ODDS / $target_payout), 2)),2);
				$number = $this->Game->generate_game_limbo_number($this->user_info->nonce, $this->user_info->client_seed, $this->user_info->server_seed);
				
				if(!$this->user_info->show_server_seed_hash) {
					while(($number >= $target_payout && $bet_amount * ($target_payout - 1) >= 50000000 && rand(1, 100) < 30)
					|| ($number >= $target_payout && $bet_amount * ($target_payout - 1) >= 20000000 && rand(1, 100) < 10)
					|| ($number >= $target_payout && $bet_amount * ($target_payout - 1) >= 10000000 && rand(1, 100) < 5)
					|| ($number >= $target_payout && $this->user_info->amount_wins - $this->user_info->amount_losses > 50000000 && rand(1, 100) < 10)
					) {
						$new_server_seed = $this->create_random_key(64);
						$new_server_seed_hash = hash('sha256', $new_server_seed);
						$number = $this->Game->generate_game_limbo_number($this->user_info->nonce, $this->user_info->client_seed, $new_server_seed);
					}
					if(isset($new_server_seed)) {
						$updated_info = clone($this->user_info);
						$updated_info->server_seed = $new_server_seed;
						$updated_info->server_seed_hash = $new_server_seed_hash;
						$this->User->update_user_info($this->user_info, $updated_info);
						$this->user_info->server_seed = $updated_info->server_seed;
						$this->user_info->server_seed_hash = $updated_info->server_seed_hash;
					}
				}
				
				if($target_payout <= $number) {
					$win_amount = intval($this->floorp($bet_amount * ($target_payout - 1) + 0.000000000001, 8));
					$payout = $target_payout;
				} else {
					$win_amount = -$bet_amount;
					$payout = 0;
				}
				$game_id = $this->Game->create_new_game(
					$this->user_info->user_id,
					$this->user_info->user_name,
					$ip_address,
					'Limbo',
					$this->user_info->nonce,
					$this->user_info->client_seed,
					$this->user_info->server_seed,
					$this->user_info->server_seed_hash,
					$bet_amount,
					$payout,
					json_encode(array('multiplier' => $target_payout)),
					json_encode(array('number' => $number)),
					$win_amount,
					time(),
					time(),
					$this->user_info->show_server_seed_hash,   // show server seed hash //
				);
				if($game_id == 0) {
					$this->change_server_seed();
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('connection_timeout')));
					return;
				}
				if($win_amount < 0) {
					$profit = '<span style="color: #ff5722">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				} else if($win_amount > 0){
					$profit = '<span style="color: #38cb74">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				} else {
					$profit = '<span>'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				}
				
				$bet_data = array(
					'date'	=> date('H:i:s', time()),
					//'game'	=> '<span title="verify" style="cursor: pointer"><i class="fas fa-rocket-launch"></i> '.$this->lang->print('game_limbo').'</span>',
					'user_name'	=> $this->user_info->user_name,
					'bet_amount'	=> number_format($bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
					'payout'	=> '<span style="color: #03a9f4">'.number_format($payout, 2, '.', '').'×</span>',
					'profit'	=> $profit,
					///16022025//
					'multiplier'	=> $target_payout,
					'number'		=> $number,
					'nonce'			=> $this->user_info->nonce,
					'client_seed'	=> $this->user_info->client_seed,
					'server_seed'	=> $this->user_info->server_seed,
					'server_seed_hash'	=> $this->user_info->server_seed_hash,
					'timestamp'		=> time(),
					'game_name'	=> 'Limbo',
					'game_id'		=> $game_id,
					///16022025//	
				);
				$this->User->update_user_bet_data($this->user_info, $bet_amount, $win_amount, $this->user_info->balance + $win_amount, $this->create_random_key(64));
				
				//stamina feature
				$this->update_user_stamina($bet_amount);
				//stamina feature				
				echo json_encode(array('ret' => 1, 'num' => number_format($number, 2), 'amount' => $win_amount, 'balance' => ($this->user_info->balance + $win_amount), 'bet_data' => $bet_data, 'mes' => ""));
			}
			
			if($this->user_info->nonce % 500 == 0) {
				$deleted_rows = $this->user_info->nonce - 500;
				$this->Game->delete_bet_rows_by_user($this->user_info->user_id, $deleted_rows);
			}
		}
	}
	
	public function process_bet_game_keno() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$ip_address = $this->get_client_ip();
			$MIN_BET_AMOUNT = $this->MIN_BET_AMOUNT;
			$MAX_BET_AMOUNT = $this->MAX_BET_AMOUNT;
			
			$bet_amount = intval(floatval($this->input->post_get('bet_amount')) * 1e8 + 0.0000001);
			$selected_numbers = $this->input->post_get('numbers');
			$selected_numbers = explode(',', $selected_numbers);
			$difficulty = $this->input->post_get('difficulty');
			
			if($bet_amount < $MIN_BET_AMOUNT) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_less_err', ($MIN_BET_AMOUNT / 1e8))));
			} else if ($bet_amount > $this->user_info->balance) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('insufficient_balance_err')));
			} else if ($bet_amount > $MAX_BET_AMOUNT) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_much_err', ($MAX_BET_AMOUNT / 1e8))));
			} else if($difficulty != 'easy' && $difficulty != 'medium' && $difficulty != 'hard') {
				echo json_encode(array('ret' => 0, 'mes' => "Invalid difficulty!"));
			} else if(!$this->Game->check_valid_selected_numbers_game_keno($selected_numbers)) {
				echo json_encode(array('ret' => 0, 'mes' => "Select numbers from 1-40!"));
			} else {
				$numbers = $this->Game->generate_game_keno_numbers($this->user_info->nonce, $this->user_info->client_seed, $this->user_info->server_seed);
				$multiplier = $this->Game->calculate_game_keno_multiplier($numbers, $selected_numbers, $difficulty);
				
				////
				if(!$this->user_info->show_server_seed_hash) {
					
				}
				////
				
				if($multiplier > 0) {
					$win_amount = $bet_amount * ($multiplier - 1);
				} else {
					$win_amount = -$bet_amount;
				}
				$game_id = $this->Game->create_new_game(
					$this->user_info->user_id,
					$this->user_info->user_name,
					$ip_address,
					'Keno',
					$this->user_info->nonce,
					$this->user_info->client_seed,
					$this->user_info->server_seed,
					$this->user_info->server_seed_hash,
					$bet_amount,
					$multiplier,
					json_encode(array('selected_numbers' => $selected_numbers, 'difficulty' => $difficulty)),
					json_encode(array('numbers' => $numbers)),
					$win_amount,
					time(),
					time(),
					$this->user_info->show_server_seed_hash,   // show server seed hash //
					$this->user_info->balance,
				);
				if($game_id == 0) {
					$this->change_server_seed();
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('connection_timeout')));
					return;
				}
				if($win_amount < 0) {
					$profit = '<span style="color: #ff5722">'.number_format($win_amount / 1e8, 8, '.', '').'</span>';
				} else if($win_amount > 0) {
					$profit = '<span style="color: #38cb74">'.number_format($win_amount / 1e8, 8, '.', '').'</span>';
				} else {
					$profit = '<span>'.number_format($win_amount / 1e8, 8, '.', '').'</span>';
				}
				
				$bet_data = array(
					'date'	=> date('H:i:s', time()),
					//'game'	=> '<span><i class="fas fa-border-all"></i> Keno</span>',
					'user_name'	=> $this->user_info->user_name,
					'bet_amount'	=> number_format($bet_amount / 1e8, 8, '.', ''),
					'payout'	=> '<span style="color: #03a9f4">'.number_format($multiplier, 2, '.', '').'×</span>',
					'profit'	=> $profit,
					'timestamp'		=> time(),
					'selected_numbers'	=> $selected_numbers,
					'numbers'		=> $numbers,
					'nonce'			=> $this->user_info->nonce,
					'client_seed'	=> $this->user_info->client_seed,
					'server_seed'	=> $this->user_info->server_seed,
					'server_seed_hash'	=> $this->user_info->server_seed_hash,
					'game_name'	=> 'Keno',
					'game_id'	=> $game_id
				);
				
				$this->User->update_user_bet_data($this->user_info, $bet_amount, $win_amount, $this->user_info->balance + $win_amount, $this->create_random_key(64));
				
				//stamina feature
				$this->update_user_stamina($bet_amount);
				//stamina feature
				
				echo json_encode(array('ret' => 1, 'numbers' => $numbers, 'selected_numbers' => $selected_numbers, 'multiplier' => number_format($multiplier, 2, '.', '').'×', 'win_amount' => $win_amount, 'balance' => ($this->user_info->balance + $win_amount), 'bet_data' => $bet_data, 'mes' => ""));
			}
			if($this->user_info->nonce % 500 == 0) {
				$deleted_rows = $this->user_info->nonce - 500;
				$this->Game->delete_bet_rows_by_user($this->user_info->user_id, $deleted_rows);
			}
		}
	}
	
	public function process_bet_game_triple_dice() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$ip_address = $this->get_client_ip();
			$MIN_BET_AMOUNT = $this->MIN_BET_AMOUNT;
			$MAX_BET_AMOUNT = $this->MAX_BET_AMOUNT;
			
			$bet_amount = intval(floatval($this->input->post_get('bet_amount')) * 1e8 + 0.000000001);
			$bet_on = intval($this->input->post_get('bet_on'));
			if($bet_amount < $MIN_BET_AMOUNT) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_less_err', ($MIN_BET_AMOUNT / 1e8))));
			} else if ($bet_amount > $this->user_info->balance) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('insufficient_balance_err')));
			} else if($bet_on < 1 || $bet_on > 18) {
				echo json_encode(array('ret' => 0, 'mes' => "Invalid bet selection!"));
			} else {
				$dice = $this->Game->generate_game_triple_dice($this->user_info->nonce, $this->user_info->client_seed, $this->user_info->server_seed);
				if(!$this->user_info->show_server_seed_hash) {
					
				}
				
				$sum = $dice[0] + $dice[1] + $dice[2];
				if(($bet_on == 1 && $sum <= 10)
				|| ($bet_on == 2 && $sum > 10)
				|| ($bet_on >= 3 && $sum == $bet_on)
				) {
					switch($bet_on) {
						case 1:
						$multiplier = 1.94;
						break;
						case 2:
						$multiplier = 1.94;
						break;
						case 3:
						$multiplier = 207;
						break;
						case 4:
						$multiplier = 69;
						break;
						case 5:
						$multiplier = 23;
						break;
						case 6:
						$multiplier = 20.7;
						break;
						case 7:
						$multiplier = 13.8;
						break;
						case 8:
						$multiplier = 9.2;
						break;
						case 9:
						$multiplier = 6.9;
						break;
						case 10:
						$multiplier = 6.9;
						break;
						case 11:
						$multiplier = 6.9;
						break;
						case 12:
						$multiplier = 6.9;
						break;
						case 13:
						$multiplier = 9.2;
						break;
						case 14:
						$multiplier = 13.8;
						break;
						case 15:
						$multiplier = 20.7;
						break;
						case 16:
						$multiplier = 23;
						break;
						case 17:
						$multiplier = 69;
						break;
						case 18:
						$multiplier = 207;
						break;
					}
				} else {
					$multiplier = 0;
				}
				$win_amount = intval($this->floorp($bet_amount * ($multiplier - 1) + 0.000000000001, 8));
				
				$game_id = $this->Game->create_new_game(
					$this->user_info->user_id,
					$this->user_info->user_name,
					$ip_address,
					'Sicbo',
					$this->user_info->nonce,
					$this->user_info->client_seed,
					$this->user_info->server_seed,
					$this->user_info->server_seed_hash,
					$bet_amount,
					$multiplier,
					json_encode(array('bet_on' => $bet_on)),
					json_encode(array('dice' => $dice)),
					$win_amount,
					time(),
					time(),
					$this->user_info->show_server_seed_hash,   // show server seed hash //
				);
				if($game_id == 0) {
					$this->change_server_seed();
					echo json_encode(array('ret' => 0, 'mes' => "Connection timeout!"));
					return;
				}
				if($win_amount < 0) {
					$profit = '<span style="color: #ff5722">'.number_format($win_amount / 1e8, 8, '.', '').'</span>';
				} else if($win_amount > 0){
					$profit = '<span style="color: #38cb74">'.number_format($win_amount / 1e8, 8, '.', '').'</span>';
				} else {
					$profit = '<span>'.number_format($win_amount / 1e8, 8, '.', '').'</span>';
				}

				
				$bet_data = array(
					'date'	=> date('H:i:s', time()),
					//'game'	=> '<span title="verify" style="cursor: pointer"><i class="fas fa-dice"></i> Triple Dice</span>',
					'user_name'	=> $this->user_info->user_name,
					'bet_amount'	=> number_format($bet_amount / 1e8, 8, '.', ''),
					'payout'	=> '<span style="color: #03a9f4">'.number_format($multiplier, 2, '.', '').'×</span>',
					'profit'	=> $profit,
					///16022025//
					'multiplier'	=> $multiplier,
					'bet_on'		=> $bet_on,
					'dice' 		=> $dice,
					'nonce'			=> $this->user_info->nonce,
					'client_seed'	=> $this->user_info->client_seed,
					'server_seed'	=> $this->user_info->server_seed,
					'server_seed_hash'	=> $this->user_info->server_seed_hash,
					'timestamp'		=> time(),
					'game_name'		=> 'Triple',
					'game_id'		=> $game_id,
					///16022025//
				);
				
				$this->User->update_user_bet_data($this->user_info, $bet_amount, $win_amount, $this->user_info->balance + $win_amount, $this->create_random_key(64));

				//stamina feature
				$this->update_user_stamina($bet_amount);
				//stamina feature
				
				echo json_encode(array('ret' => 1, 'dice' => $dice, 'win_amount' => $win_amount, 'balance' => ($this->user_info->balance + $win_amount), 'bet_data' => $bet_data, 'mes' => ""));
			}
			if($this->user_info->nonce % 500 == 0) {
				$deleted_rows = $this->user_info->nonce - 500;
				$this->Game->delete_bet_rows_by_user($this->user_info->user_id, $deleted_rows);
			}
			
		}
	}
	
	public function process_update_deposit_transaction() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			
			if($this->input->post_get('captcha_type') != '') {
				$this->captcha_type = (intval($this->input->post_get('captcha_type')) % 5);
			}
			
			$this->validate_captcha();

			$txid = $this->input->post_get('txid');
			$network = $this->input->post_get('network');
			//$network = 'BSC';
			
			if($txid == '' || strlen($txid) < 60) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('invalid_txid_err')));
			}  else if (!$this->is_captcha_valid()) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('captcha_incorrect_err')));
			} else {
				$user_wallet = $this->Wallet->get_wallet_by_user_id($this->user_info->user_id);
				if($user_wallet == '') {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('invalid_txid_err')));
				} else {
					
					if($network == 'BSC') {
						$get_transaction_by_txid = $this->Request->get_all_requests_by_txid($txid);
						if($get_transaction_by_txid != null){
							echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('credited_txid_err')));
						} else {
							$transaction_info = bscapi_get_transaction_info_by_txid2($txid);
							if($transaction_info == null || $transaction_info['to_address'] != $user_wallet->address) {
								echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('invalid_txid_err')));
							} else {
								$amount = $transaction_info['amount'];
								$this->Request->create_request($this->user_info->user_id, 'Deposit', $amount, $user_wallet->address, $txid, '', $transaction_info['time']);
								$updated_info = clone($this->user_info);
								$updated_info->balance += $amount;
								$updated_info->total_deposits += $amount;
								$this->User->update_user_info($this->user_info, $updated_info);
								$this->user_info->balance += $amount;
								$this->Wallet->update_wallet_balance($user_wallet->wallet_id, $user_wallet->balance + $amount, $user_wallet->updated_time);
								$deposits_today = $this->Statistic->get_statistic_by_date('deposits', date("Y-m-d"));
								$this->Statistic->set_statistic_by_date('deposits', $deposits_today + $amount, date("Y-m-d"));
								echo json_encode(array('ret' => 1, 'mes' => $this->lang->print('update_transaction_success')));
							}
						}
					} else if($network == 'opBNB') {
						$replace_txid = str_replace("0x" , "1x", $txid);
						$get_transaction_by_txid = $this->Request->get_all_requests_by_txid($replace_txid);
						if($get_transaction_by_txid != null){
							echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('credited_txid_err')));
						} else {
							$transaction_info = bscapi_get_transaction_info_by_txid_on_opbnb($txid);
							if($transaction_info == null || $transaction_info['to_address'] != $user_wallet->address) {
								echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('invalid_txid_err')));
							} else {
								$amount = $transaction_info['amount'];
								$this->Request->create_request($this->user_info->user_id, 'Deposit', $amount, $user_wallet->address, $replace_txid, '', $transaction_info['time']);
								$updated_info = clone($this->user_info);
								$updated_info->balance += $amount;
								$updated_info->total_deposits += $amount;
								$this->User->update_user_info($this->user_info, $updated_info);
								$this->user_info->balance += $amount;
								$this->Wallet->update_wallet_balance_on_opbnb($user_wallet->wallet_id, $user_wallet->balance_on_opbnb + $amount, $user_wallet->updated_time);
								$deposits_today = $this->Statistic->get_statistic_by_date('deposits', date("Y-m-d"));
								$this->Statistic->set_statistic_by_date('deposits', $deposits_today + $amount, date("Y-m-d"));
								echo json_encode(array('ret' => 1, 'mes' => $this->lang->print('update_transaction_success')));
							}
						}
					} else {
						echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('invalid_network_err')));
					}
				}
			}
		}
	}
	
	public function process_complete_confirmed_request() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => ''));
		} else {
			$request_id = $this->Request->get_confirmed_processing_request($this->user_info->user_id);
			if($request_id != 0) {
				$request_info = $this->Request->get_request_info_by_id($request_id);
				$amount = $request_info->amount;
				//$USD_value = number_format(floatval($amount / $this->UNITS_PER_COIN * $this->BNB_price), 2, '.', '');
				$USD_value = round(($amount / $this->UNITS_PER_COIN) * $this->BNB_price, 2);
				$this->Request->complete_deposit_request($request_id, $USD_value);
				$this->User->update_user_info_by_id($this->user_info->user_id, 'balance', $this->user_info->balance + $amount);
				$this->User->update_user_info_by_id($this->user_info->user_id, 'processing_balance', $this->user_info->processing_balance - $amount);
				$this->User->update_user_info_by_id($this->user_info->user_id, 'total_deposits', $this->user_info->total_deposits + $amount);

				$this->user_info->balance += $amount;
				echo json_encode(array('ret' => 1, 'balance' => $this->user_info->balance, 'mes' => $this->lang->print('deposit_credited_success', ($amount / $this->UNITS_PER_COIN))));
			} else {
				echo json_encode(array('ret' => 0, 'mes' => ''));
			}
		}
	}
	
	public function process_update_last_copied() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$user_wallet = $this->Wallet->get_wallet_by_user_id($this->user_info->user_id);
			if($user_wallet != '') {
				$this->Wallet->update_last_copied($user_wallet->wallet_id);
			}
		}
	}
	
	public function process_switch_light_dark_mode() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			if($this->user_info->dark_mode == 0) {
				$this->User->update_user_info_by_id($this->user_info->user_id, 'dark_mode', 1);
				$this->user_info->dark_mode = 1;
			} else {
				$this->User->update_user_info_by_id($this->user_info->user_id, 'dark_mode', 0);
				$this->user_info->dark_mode = 0;
			}
		}
	}
	
	public function process_change_language() {
		$language = strtoupper(substr($this->input->post('language'), 0, 2));
		if($language != 'EN' 
			&& $language != 'ES' 
			&& $language != 'PT' 
			&& $language != 'FR' 
			&& $language != 'RU' 
			&& $language != 'DE' 
			&& $language != 'NL' 
			&& $language != 'ZH' 
			&& $language != 'AR' 
			&& $language != 'HI' 
			&& $language != 'JA' 
			&& $language != 'BN' 
			&& $language != 'MN' 
			&& $language != 'TR' 
			&& $language != 'FA' 
			&& $language != 'UZ'
			&& $language != 'VI'
			&& $language != 'UR'
			&& $language != 'ID'
			&& $language != 'TH'
			&& $language != 'HR'
			&& $language != 'KO'
			&& $language != 'IT'
		) {
			$language = 'EN';
		}
		if($this->user_info != null) {
			$this->User->update_user_info_by_id($this->user_info->user_id, 'language', $language);
			$this->user_info->language = $language;
		}
		setcookie('language', $language, time() + (86400 * 30), "/");
	}
	
	public function process_change_email() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$new_email = strtolower(substr($this->input->post_get('new_email'), 0, 64));
			$old_email = $this->user_info->user_email;
			$password = substr($this->input->post_get('password'), 0, 32);
			
			if($this->user_info->email_verification == 1) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('verified_email_err')));
			} else if($this->User->check_password($this->user_info->user_name, $password) == 0) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('incorrect_password_err')));
			} else if (!filter_var($new_email, FILTER_VALIDATE_EMAIL)) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('email_invalid_err')));
			} else if (!$this->User->check_valid_email_suplier($new_email)) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('email_invalid_suppliers_err')));
			} else if ($this->User->check_email_already_exists($new_email) != 0) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('email_exists_err')));
			} else {
				if($this->user_info->registered_time > time() - 86400 * 30) {
					$this->User->update_user_info_by_id($this->user_info->user_id, 'user_email', $new_email);
					$this->Log->create_log($this->user_info->user_id, 'User changes email "'.$old_email.'" to "'.$new_email.'"', $this->get_client_ip());
					echo json_encode(array('ret' => 1, 'mes' => 'Change email successfully!'));
				} else {
					echo json_encode(array('ret' => 0, 'mes' => "Sorry, you can't change your email at the moment. Please create a support ticket to request an email change."));
				}
			}
		}
	}
	
	public function process_save_strategies() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$strategies = $this->input->post_get('strategies');
			if($strategies != '') {
				$this->Strategy->save_user_strategies($this->user_info->user_id, $strategies);
			}
		}
	}
	
	public function process_verify_pcaptcha() {
		$selected_boxes = $this->input->post('selected_boxes', true) ?? '[]';
		$verify_pcaptcha = verify_pcaptcha($selected_boxes);
		echo json_encode($verify_pcaptcha);
	}
	
	public function load() {
		try {
			$data = $this->input->post_get('data');
			switch($data) {
				case 'user_transactions':
				$this->load_user_transactions();
				break;
				case 'my_bet_data':
				$this->load_my_bet_data();
				break;
				case 'all_bet_data':
				$this->load_all_bet_data();
				break;
				case 'game_seeds':
				$this->load_game_seeds();
				break;
				case 'bet_info':
				$this->load_bet_info();
				break;
				case 'bet_info2':
				$this->load_bet_info2();
				break;
				case 'deposit_transactions':
				if($this->user_info != null) {
					$user_wallet = $this->Wallet->get_wallet_by_user_id($this->user_info->user_id);
					$this->load_deposit_transactions($user_wallet);
				}
				break;
				case 'deposit_transactions2':
				if($this->user_info != null) {
					$user_wallet = $this->Wallet->get_wallet_by_user_id($this->user_info->user_id);
					$this->load_deposit_transactions_from_nodereal($user_wallet);
				}
				break;
				case 'deposit_transactions3':
				if($this->user_info != null) {
					$user_wallet = $this->Wallet->get_wallet_by_user_id($this->user_info->user_id);
					$this->load_deposit_transactions_from_bscscan($user_wallet);
				}
				break;
				case 'deposit_transactions_on_opbnb':
				if($this->user_info != null) {
					$user_wallet = $this->Wallet->get_wallet_by_user_id($this->user_info->user_id);
					$this->load_deposit_transactions_on_opbnb($user_wallet);
				}
				break;
				case 'unread_count':
				$this->load_unread_count();
				break;
				case 'notifications':
				$this->load_notifications();
				break;
			}
		} catch(Exception $e) {
			//echo json_encode(array('ret' => 0, 'mes' => $e->getMessage()));
			echo json_encode(array('ret' => 0, 'mes' => 'Unknown error!'));
			return;
		}
	}
	
		
	public function load_user_transactions() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$request_type = $this->input->post_get('request_type');
			$page_id = intval($this->input->post_get('page_id'));
			$type = $this->input->post_get('type');
			$load_requests = $this->Request->load_user_transactions($this->user_info->user_id, $page_id, $type);
			if(is_array($load_requests)) {
				foreach($load_requests as $row) {
					$row->amount = number_format($row->amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '');
					$row->time = $this->time_elapsed_string($row->time);
					
				}
			}
			echo json_encode(array('ret' => 1, 'mes' => 'Load data successfully!', 'data' => $load_requests));
		}
	}
	
	public function load_my_bet_data() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$my_bet_data = $this->Game->load_user_bet_history($this->user_info->user_id, 1);
			if(is_array($my_bet_data)) {
				foreach($my_bet_data as $row) {
					if(date('Y-m-d', $row->date) == date('Y-m-d')) {
						$row->date =  date('H:i:s', $row->date);
					} else {
						$row->date =  date('Y-m-d', $row->date);
					}
					if($row->game == 'Dice') {
						$row->game = '<span title="verify" style="cursor: pointer"><i class="fas fa-dice"></i> '.$this->lang->print('game_dice').'</span>';
					} else if($row->game == 'Ultimate') {
						$row->game = '<span title="verify" style="cursor: pointer"><i class="fas fa-dice"></i> '.$this->lang->print('game_ultimate').'</span>';
					} else if ($row->game == 'Gems') {
						$row->game = '<span title="verify" style="cursor: pointer"><i class="fas fa-gem"></i> '.$this->lang->print('game_gems').'</span>';
					} else if ($row->game == 'Slots') {
						$row->game = '<span title="verify" style="cursor: pointer"><i class="fas fa-lemon"></i> '.$this->lang->print('game_slots').'</span>';
					} else if ($row->game == 'Mines') {
						$row->game = '<span title="verify" style="cursor: pointer"><i class="fas fa-bomb"></i> '.$this->lang->print('game_mines').'</span>';
					} else if ($row->game == 'Poker') {
						$row->game = '<span title="verify" style="cursor: pointer"><i class="fas fa-spade"></i> '.$this->lang->print('game_video_poker').'</span>';
					} else if ($row->game == 'Baccarat') {
						$row->game = '<span title="verify" style="cursor: pointer"><i class="fas fa-club"></i> '.$this->lang->print('game_baccarat').'</span>';
					} else if ($row->game == 'Hilow') {
						$row->game = '<span title="verify" style="cursor: pointer"><i class="fas fa-sort-alt"></i> '.$this->lang->print('game_high_low').'</span>';
					} else if ($row->game == 'Roulette') {
						$row->game = '<span title="verify" style="cursor: pointer"><img src="'.base_url().'assets/img/games/roulette/roulette_icon.svg" style="width: 14px; height: 14px"> '.$this->lang->print('game_roulette').'</span>';
					} else if ($row->game == 'Wheel') {
						$row->game = '<span title="verify" style="cursor: pointer"><i class="fas fa-tire"></i> '.$this->lang->print('game_wof').'</span>';
					} else if ($row->game == 'Plinko') {
						$row->game = '<span title="verify" style="cursor: pointer" ><i class="fas fa-ball-pile"></i> '.$this->lang->print('game_plinko').'</span>';
					} else if ($row->game == 'Limbo') {
						$row->game = '<span title="verify" style="cursor: pointer" ><i class="fas fa-rocket-launch"></i> '.$this->lang->print('game_limbo').'</span>';
					}
					$row->bet_amount = number_format($row->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '');
					$row->payout = '<span style="color: #03a9f4">'.number_format($row->payout, 2, '.', '').'×</span>';
					if($row->profit > 0) {
						$row->profit = '<span style="color: #38cb74">'.number_format($row->profit / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					} else if ($row->profit < 0) {
						$row->profit = '<span style="color: #ff5722">'.number_format($row->profit / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					} else {
						$row->profit = '<span>'.number_format($row->profit / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					}
				}
			}
			echo json_encode(array('ret' => 1, 'mes' => $this->lang->print('load_data_success'), 'my_bet_data' => $my_bet_data));
		}
	}
	
	public function load_all_bet_data() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$all_bet_data = $this->cache->get('all_bet_data');
			if(!$all_bet_data) {
				$all_bet_data = $this->Game->load_user_bet_history(0, 1, 'high_wins');
				$this->cache->save('all_bet_data', $all_bet_data, 30);
			}
			if(is_array($all_bet_data)) {
				foreach($all_bet_data as $row) {
					$row->timestamp = $row->date;
					if(date('Y-m-d', $row->date) == date('Y-m-d')) {
						$row->date =  date('H:i:s', $row->date);
					} else {
						$row->date =  date('Y-m-d', $row->date);
					}
					/*if($row->game == 'Dice') {
						$row->game = '<span title="verify" style="cursor: pointer"><i class="fas fa-dice"></i> '.$this->lang->print('game_dice').'</span>';
					} else if($row->game == 'Ultimate') {
						$row->game = '<span title="verify" style="cursor: pointer"><i class="fas fa-dice"></i> '.$this->lang->print('game_ultimate').'</span>';
					} else if ($row->game == 'Gems') {
						$row->game = '<span title="verify" style="cursor: pointer"><i class="fas fa-gem"></i> '.$this->lang->print('game_gems').'</span>';
					} else if ($row->game == 'Slots') {
						$row->game = '<span title="verify" style="cursor: pointer"><i class="fas fa-lemon"></i> '.$this->lang->print('game_slots').'</span>';
					} else if ($row->game == 'Mines') {
						$row->game = '<span title="verify" style="cursor: pointer"><i class="fas fa-bomb"></i> '.$this->lang->print('game_mines').'</span>';
					} else if ($row->game == 'Poker') {
						$row->game = '<span title="verify" style="cursor: pointer"><i class="fas fa-spade"></i> '.$this->lang->print('game_video_poker').'</span>';
					} else if ($row->game == 'Baccarat') {
						$row->game = '<span title="verify" style="cursor: pointer"><i class="fas fa-club"></i> '.$this->lang->print('game_baccarat').'</span>';
					} else if ($row->game == 'Hilow') {
						$row->game = '<span title="verify" style="cursor: pointer"><i class="fas fa-sort-alt"></i> '.$this->lang->print('game_high_low').'</span>';
					} else if ($row->game == 'Roulette') {
						$row->game = '<span title="verify" style="cursor: pointer"><img src="'.base_url().'assets/img/games/roulette/roulette_icon.svg" style="width: 14px; height: 14px"> '.$this->lang->print('game_roulette').'</span>';
					} else if ($row->game == 'Wheel') {
						$row->game = '<span title="verify" style="cursor: pointer"><i class="fas fa-tire"></i> '.$this->lang->print('game_wof').'</span>';
					} else if ($row->game == 'Plinko') {
						$row->game = '<span title="verify" style="cursor: pointer" style="cursor: pointer"><i class="fas fa-ball-pile"></i> '.$this->lang->print('game_plinko').'</span>';
					} else if ($row->game == 'Limbo') {
						$row->game = '<span title="verify" style="cursor: pointer" style="cursor: pointer" ><i class="fas fa-rocket-launch"></i> '.$this->lang->print('game_limbo').'</span>';
					}*/
					$row->bet_amount = number_format($row->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '');
					$row->payout = '<span style="color: #03a9f4">'.number_format($row->payout, 2, '.', '').'×</span>';
					if($row->profit > 0) {
						$row->profit = '<span style="color: #38cb74">'.number_format($row->profit / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					} else if ($row->profit < 0) {
						$row->profit = '<span style="color: #ff5722">'.number_format($row->profit / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					} else {
						$row->profit = '<span>'.number_format($row->profit / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					}
				}
			}
			echo json_encode(array('ret' => 1, 'mes' => $this->lang->print('load_data_success'), 'all_bet_data' => $all_bet_data));
		}
	}
	
	public function load_bet_info() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$game_id = intval($this->input->post_get('game_id'));
			$bet_info = $this->Game->get_bet_info_by_id($game_id);
			if($bet_info == null) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('invalid_game_id_err')));
			} else {
				
				//$this->Log->create_log($this->user_info->user_id, 'Show bet info', $this->get_client_ip());
				
				//28/09/2023 cheat game gems reveal server_seed//
				/*$check_allow_reveal_server_seed = $this->Game->allow_reveal_server_seed($bet_info->server_seed);
				if(!$check_allow_reveal_server_seed) {
					echo json_encode(array('ret' => 0, 'mes' => 'Please finish unfinished games!'));
					return;
				}*/
				//28/09/2023 cheat game gems reveal server_seed//
				
				
				if($bet_info->game_title == 'Dice') {
					if($bet_info->payout == 0) {
						$multiplier = json_decode($bet_info->prediction)->multiplier;
					} else {
						$multiplier = $bet_info->payout;
					}
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-dice"></i> '.$this->lang->print('game_dice').'',
							'title'			=> '<i class="fas fa-dice"></i> '.$this->lang->print('game_dice').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'bet_on'		=> json_decode($bet_info->prediction)->bet_on,
							'multiplier'	=> $multiplier,
							'number'		=> json_decode($bet_info->data)->number,
							'payout'		=> ($bet_info->win_amount > 0) ? number_format($bet_info->payout, 2, '.', '') : number_format(0, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Dice',
					)));
				} else if($bet_info->game_title == 'Ultimate') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-dice"></i> '.$this->lang->print('game_dice').'',
							'title'			=> '<i class="fas fa-dice"></i> '.$this->lang->print('game_dice').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'bet_on'		=> json_decode($bet_info->prediction)->bet_on,
							'lower_limit'	=> json_decode($bet_info->prediction)->lower_limit,
							'upper_limit'	=> json_decode($bet_info->prediction)->upper_limit,
							'number'		=> json_decode($bet_info->data)->number,
							'payout'		=> ($bet_info->win_amount > 0) ? number_format($bet_info->payout, 2, '.', '') : number_format(0, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Ultimate',
					)));
				} else if ($bet_info->game_title == 'Gems') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-gem"></i> '.$this->lang->print('game_gems').'',
							'title'			=> '<i class="fas fa-gem"></i> '.$this->lang->print('game_gems').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'difficulty'	=> json_decode($bet_info->prediction)->difficulty,
							'tiles'			=> json_decode($bet_info->prediction)->tiles,
							'gems'			=> json_decode($bet_info->data)->gems,
							'payout'		=> ($bet_info->win_amount > 0) ? number_format($bet_info->payout, 2, '.', '') : number_format(0, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Gems',
					)));
				} else if ($bet_info->game_title == 'Slots') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-lemon"></i> '.$this->lang->print('game_slots').'',
							'title'			=> '<i class="fas fa-lemon"></i> '.$this->lang->print('game_slots').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'('.json_decode($bet_info->prediction)->lines.')',
							'lines'			=> json_decode($bet_info->prediction)->lines,
							'numbers'		=> json_decode($bet_info->data)->numbers,
							'payout'		=> number_format($bet_info->payout, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Slots',
					)));
				} else if ($bet_info->game_title == 'Mines') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-bomb"></i> '.$this->lang->print('game_mines').'',
							'title'			=> '<i class="fas fa-bomb"></i> '.$this->lang->print('game_mines').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'tiles'			=> json_decode($bet_info->prediction)->tiles,
							'mines'			=> json_decode($bet_info->data)->mines,
							'payout'		=> number_format($bet_info->payout, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Mines',
					)));
				} else if ($bet_info->game_title == 'Poker') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-spade"></i> '.$this->lang->print('game_video_poker').'',
							'title'			=> '<i class="fas fa-spade"></i> '.$this->lang->print('game_video_poker').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'selected_cards'=>  json_decode($bet_info->prediction)->selected_cards,
							'hand'			=>  json_decode($bet_info->prediction)->hand,
							'highlights'	=>  json_decode($bet_info->prediction)->highlights,
							'cards'			=> json_decode($bet_info->data)->cards,
							'payout'		=> number_format($bet_info->payout, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Poker',
					)));
				} else if ($bet_info->game_title == 'Baccarat') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-club"></i> '.$this->lang->print('game_baccarat').'',
							'title'			=> '<i class="fas fa-club"></i> '.$this->lang->print('game_baccarat').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'player_cards'	=> json_decode($bet_info->data)->player_cards,
							'banker_cards'	=> json_decode($bet_info->data)->banker_cards,
							'player_total'	=> json_decode($bet_info->data)->player_total,
							'banker_total'	=> json_decode($bet_info->data)->banker_total,
							'payout'		=> number_format($bet_info->payout, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Baccarat',
					)));
				} else if ($bet_info->game_title == 'Hilow') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-sort-alt"></i> '.$this->lang->print('game_hilow').'',
							'title'			=> '<i class="fas fa-sort-alt"></i> '.$this->lang->print('game_hilow').'',
							'user_name'		=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'cards'			=> json_decode($bet_info->data)->cards,
							'selections'	=> json_decode($bet_info->prediction)->selections,
							'payout'		=> number_format($bet_info->payout, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Hilow',
					)));
				} else if ($bet_info->game_title == 'Roulette') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<img src="'.base_url().'assets/img/games/roulette/roulette_icon.svg" style="width: 14px; height: 14px"> '.$this->lang->print('game_roulette').'',
							'title'			=> '<img src="'.base_url().'assets/img/games/roulette/roulette_icon.svg" style="width: 14px; height: 14px"> '.$this->lang->print('game_roulette').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'chips'			=> json_decode($bet_info->prediction)->chip_bet,
							'number'			=> json_decode($bet_info->data)->number,
							'payout'		=> number_format($bet_info->payout, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Roulette',
					)));
				} else if ($bet_info->game_title == 'Wheel') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-ball-pile"></i> '.$this->lang->print('game_wheel').'',
							'title'			=> '<i class="fas fa-ball-pile"></i> '.$this->lang->print('game_wheel').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'index'			=> json_decode($bet_info->data)->index,
							'payout'		=> number_format($bet_info->payout, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Wheel',
					)));
				} else if ($bet_info->game_title == 'Plinko') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-ball-pile"></i> '.$this->lang->print('game_plinko').'',
							'title'			=> '<i class="fas fa-ball-pile"></i> '.$this->lang->print('game_plinko').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'risk'			=> json_decode($bet_info->prediction)->risk,
							'direction_idx'	=> json_decode($bet_info->data)->direction_idx,
							'payout'		=> number_format($bet_info->payout, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Plinko',
					)));
				} else if ($bet_info->game_title == 'Limbo') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-rocket-launch"></i> '.$this->lang->print('game_limbo').'',
							'title'			=> '<i class="fas fa-rocket-launch"></i> '.$this->lang->print('game_limbo').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'multiplier'	=> json_decode($bet_info->prediction)->multiplier,
							'number'		=> json_decode($bet_info->data)->number,
							'payout'		=> number_format($bet_info->payout, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Limbo',
					)));
				} else if ($bet_info->game_title == 'Keno') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-border-all"></i> Keno',
							'title'			=> '<i class="fas fa-border-all"></i> Keno',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'numbers'		=> json_decode($bet_info->data)->numbers,
							'selected_numbers'		=> json_decode($bet_info->prediction)->selected_numbers,
							'payout'		=> number_format($bet_info->payout, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Keno',
					)));
				} else if ($bet_info->game_title == 'Sicbo') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-dice"></i> Sicbo',
							'title'			=> '<i class="fas fa-dice"></i> Sicbo',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'bet_on'		=> json_decode($bet_info->prediction)->bet_on,
							'dice'		=> json_decode($bet_info->data)->dice,
							'payout'		=> number_format($bet_info->payout, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Triple',
					)));
				}
				
			}
		}
	}
	
	public function load_bet_info2() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$server_seed = $this->input->post_get('server_seed');
			$bet_info = $this->Game->get_bet_info_by_server_seed($server_seed);
			if($bet_info == null) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('invalid_game_id_err')));
			} else {
				
				if($bet_info->game_title == 'Dice') {
					if($bet_info->payout == 0) {
						$multiplier = json_decode($bet_info->prediction)->multiplier;
					} else {
						$multiplier = $bet_info->payout;
					}
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-dice"></i> '.$this->lang->print('game_dice').'',
							'title'			=> '<i class="fas fa-dice"></i> '.$this->lang->print('game_dice').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'bet_on'		=> json_decode($bet_info->prediction)->bet_on,
							'multiplier'	=> $multiplier,
							'number'		=> json_decode($bet_info->data)->number,
							'payout'		=> ($bet_info->win_amount > 0) ? number_format($bet_info->payout, 2, '.', '') : number_format(0, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Dice',
					)));
				} else if($bet_info->game_title == 'Ultimate') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-dice"></i> '.$this->lang->print('game_dice').'',
							'title'			=> '<i class="fas fa-dice"></i> '.$this->lang->print('game_dice').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'bet_on'		=> json_decode($bet_info->prediction)->bet_on,
							'lower_limit'	=> json_decode($bet_info->prediction)->lower_limit,
							'upper_limit'	=> json_decode($bet_info->prediction)->upper_limit,
							'number'		=> json_decode($bet_info->data)->number,
							'payout'		=> ($bet_info->win_amount > 0) ? number_format($bet_info->payout, 2, '.', '') : number_format(0, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Ultimate',
					)));
				} else if ($bet_info->game_title == 'Gems') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-gem"></i> '.$this->lang->print('game_gems').'',
							'title'			=> '<i class="fas fa-gem"></i> '.$this->lang->print('game_gems').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'difficulty'	=> json_decode($bet_info->prediction)->difficulty,
							'tiles'			=> json_decode($bet_info->prediction)->tiles,
							'gems'			=> json_decode($bet_info->data)->gems,
							'payout'		=> ($bet_info->win_amount > 0) ? number_format($bet_info->payout, 2, '.', '') : number_format(0, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Gems',
					)));
				} else if ($bet_info->game_title == 'Slots') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-lemon"></i> '.$this->lang->print('game_slots').'',
							'title'			=> '<i class="fas fa-lemon"></i> '.$this->lang->print('game_slots').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'('.json_decode($bet_info->prediction)->lines.')',
							'lines'			=> json_decode($bet_info->prediction)->lines,
							'numbers'		=> json_decode($bet_info->data)->numbers,
							'payout'		=> number_format($bet_info->payout, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Slots',
					)));
				} else if ($bet_info->game_title == 'Mines') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-bomb"></i> '.$this->lang->print('game_mines').'',
							'title'			=> '<i class="fas fa-bomb"></i> '.$this->lang->print('game_mines').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'tiles'			=> json_decode($bet_info->prediction)->tiles,
							'mines'			=> json_decode($bet_info->data)->mines,
							'payout'		=> number_format($bet_info->payout, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Mines',
					)));
				} else if ($bet_info->game_title == 'Poker') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-spade"></i> '.$this->lang->print('game_video_poker').'',
							'title'			=> '<i class="fas fa-spade"></i> '.$this->lang->print('game_video_poker').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'selected_cards'=>  json_decode($bet_info->prediction)->selected_cards,
							'hand'			=>  json_decode($bet_info->prediction)->hand,
							'highlights'	=>  json_decode($bet_info->prediction)->highlights,
							'cards'			=> json_decode($bet_info->data)->cards,
							'payout'		=> number_format($bet_info->payout, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Poker',
					)));
				} else if ($bet_info->game_title == 'Baccarat') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-club"></i> '.$this->lang->print('game_baccarat').'',
							'title'			=> '<i class="fas fa-club"></i> '.$this->lang->print('game_baccarat').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'player_cards'	=> json_decode($bet_info->data)->player_cards,
							'banker_cards'	=> json_decode($bet_info->data)->banker_cards,
							'player_total'	=> json_decode($bet_info->data)->player_total,
							'banker_total'	=> json_decode($bet_info->data)->banker_total,
							'payout'		=> number_format($bet_info->payout, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Baccarat',
					)));
				} else if ($bet_info->game_title == 'Hilow') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-sort-alt"></i> '.$this->lang->print('game_hilow').'',
							'title'			=> '<i class="fas fa-sort-alt"></i> '.$this->lang->print('game_hilow').'',
							'user_name'		=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'cards'			=> json_decode($bet_info->data)->cards,
							'selections'	=> json_decode($bet_info->prediction)->selections,
							'payout'		=> number_format($bet_info->payout, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Hilow',
					)));
				} else if ($bet_info->game_title == 'Roulette') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<img src="'.base_url().'assets/img/games/roulette/roulette_icon.svg" style="width: 14px; height: 14px"> '.$this->lang->print('game_roulette').'',
							'title'			=> '<img src="'.base_url().'assets/img/games/roulette/roulette_icon.svg" style="width: 14px; height: 14px"> '.$this->lang->print('game_roulette').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'chips'			=> json_decode($bet_info->prediction)->chip_bet,
							'number'			=> json_decode($bet_info->data)->number,
							'payout'		=> number_format($bet_info->payout, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Roulette',
					)));
				} else if ($bet_info->game_title == 'Wheel') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-tire"></i> '.$this->lang->print('game_wof').'',
							'title'			=> '<i class="fas fa-tire"></i> '.$this->lang->print('game_wof').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'index'			=> json_decode($bet_info->data)->index,
							'payout'		=> number_format($bet_info->payout, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Wheel',
					)));
				} else if ($bet_info->game_title == 'Plinko') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-ball-pile"></i> '.$this->lang->print('game_plinko').'',
							'title'			=> '<i class="fas fa-ball-pile"></i> '.$this->lang->print('game_plinko').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'risk'			=> json_decode($bet_info->prediction)->risk,
							'direction_idx'	=> json_decode($bet_info->data)->direction_idx,
							'payout'		=> number_format($bet_info->payout, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Plinko',
					)));
				} else if ($bet_info->game_title == 'Limbo') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> $this->lang->print('game_limbo').'',
							'title'			=> $this->lang->print('game_limbo').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'multiplier'	=> json_decode($bet_info->prediction)->multiplier,
							'number'		=> json_decode($bet_info->data)->number,
							'payout'		=> number_format($bet_info->payout, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Limbo',
					)));
				}
				
			}
		}
	}
	
	public function auto_payout() {
		$get_pending_withdrawal = $this->Request->get_pending_withdrawal();
		if($get_pending_withdrawal == null) {
			return 0;
		} else {
			$request_id = $get_pending_withdrawal->request_id;
			if($request_id == 0) {
				return 0;
			} else {
				$request_info = $this->Request->get_request_info_by_id($request_id);
				if($request_info == null) {
					//echo json_encode(array('ret' => 0, 'mes' => 'Invalid request ID'));
				} else if($request_info->status == 'Completed' || $request_info->status == 'Processing'){
					//echo json_encode(array('ret' => 0, 'mes' => 'Duplicate payment'));
				} else {
					$address = $request_info->address;
					$amount = $request_info->amount;
					$wallets = $this->Wallet->get_all_deposit_wallets("'".$request_info->address."'");
					$sender = $this->User->get_user_info_by_id($request_info->user_id);
					$this->cache->save('last_auto_payout', time(), 864000);
					if($sender->pending_balance > 0) {
						if($sender->user_level >= 3) {
							$this->withdrawal_fee = 0;
						}
						if($wallets != null) {
							$wallet_info = $wallets[0];
							$clone_sender = clone($sender);
							$clone_sender->pending_balance -= $amount;
							$clone_sender->total_withdrawals += $amount;
							$this->User->update_user_info($sender, $clone_sender);
							//$USD_value = number_format(floatval($amount * $this->BNB_price / $this->UNITS_PER_COIN), 2, '.', '');
							$USD_value = round(($amount * $this->BNB_price) / $this->UNITS_PER_COIN, 2);
							$this->Request->complete_withdrawal_request($request_id, 'Sent to '.$wallet_info->user_id, $USD_value);
							if($sender->payment_notifications) {
								if($sender->total_withdrawals == 0) {
									$this->Notification->create_notification($sender->user_id, 'If you are satisfied with our services, please help us evaluate the website on <a href="https://www.trustpilot.com/review/bnbpick.io">Trustpilot</a>. You can also comment so we can bring the best services to customers.', 'success');
								}
							}
							
							$received_amount = $amount - $this->withdrawal_fee;
							$receiver = $this->User->get_user_info_by_id($wallet_info->user_id);
							$clone_receiver = clone($receiver);
							$clone_receiver->total_deposits += $received_amount;
							$clone_receiver->balance += $received_amount;

							$this->User->update_user_info($receiver, $clone_receiver);
							$insert_id = $this->Request->create_request($receiver->user_id, 'Deposit', $received_amount, $address, 'Received from '.$request_info->user_id);
							$this->Request->complete_deposit_request($insert_id, $USD_value);
							if($receiver->payment_notifications) {
								//sendDepositConfirmationEmail('support@bnbpick.io', 'support@bnbpick.io', $receiver->user_email, $receiver->user_name, $received_amount);
							}
						} else {
							//$get_wallet = $this->Wallet->find_wallet_to_pay($amount + 10500);
							$amount = number_format(($amount - $this->withdrawal_fee) / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '');
							$get_wallet = null;
							if($get_wallet == null) {
								try{
									$res = bscapi_send_transaction($address, floatval($amount), $this->main_wallet['private_key']);
									if($res != '') {
										if(strlen($res) == 66){
											$txid = $res;
											$USD_value = round($amount * $this->BNB_price, 2);
											//process withdrawal request
											//$this->Request->complete_withdrawal_request($request_id, $txid, $USD_value);
											$this->Request->process_withdrawal_request($request_id, $txid, $USD_value);
											//process withdrawal request
											$withdrawals_today = $this->Statistic->get_statistic_by_date('withdrawals', date("Y-m-d"));
											$this->Statistic->set_statistic_by_date('withdrawals', $withdrawals_today + ($amount * $this->UNITS_PER_COIN), date("Y-m-d"));
											$clone_sender = clone($sender);
											$clone_sender->pending_balance -= ($amount * $this->UNITS_PER_COIN + $this->withdrawal_fee);
											$clone_sender->total_withdrawals += ($amount * $this->UNITS_PER_COIN  + $this->withdrawal_fee);
											$this->User->update_user_info($sender, $clone_sender);
											
											if($sender->payment_notifications) {
												if($sender->total_withdrawals == 0) {
													$this->Notification->create_notification($sender->user_id, 'If you are satisfied with our services, please help us evaluate the website on <a href="https://www.trustpilot.com/review/bnbpick.io">Trustpilot</a>. You can also comment so we can bring the best services to customers.', 'success');
												}
											}
											//$this->cache->save('last_auto_payout', time(), 864000);
											//echo json_encode(array('ret' => 1, 'mes' => 'The request is being processed!'));
										} else {
											$this->Log->create_log(0, 'Auto pay failed: '.$res, $this->get_client_ip());
											//echo json_encode(array('ret' => 0, 'mes' => $res));
										}
									} else {
										$this->Log->create_log(0, 'Auto pay failed!', $this->get_client_ip());
										//echo json_encode(array('ret' => 0, 'mes' => $res));
									}
								} catch (Exception $e){
									$this->Log->create_log(0, 'Auto pay failed: '.$e->getMessage(), $this->get_client_ip());
									//echo json_encode(array('ret' => 0, 'mes' => $e->getMessage()));
								}
							} else {
								try{
									$res = bscapi_send_transaction($address, floatval($amount), $get_wallet->private_key);
									if($res != ''){
										if(strlen($res) == 66){
											$txid = $res;
											$USD_value = round($amount * $this->BNB_price, 2);
											//process withdrawal request
											//$this->Request->complete_withdrawal_request($request_id, $txid, $USD_value);
											$this->Request->process_withdrawal_request($request_id, $txid, $USD_value);
											//process withdrawal request
											$withdrawals_today = $this->Statistic->get_statistic_by_date('withdrawals', date("Y-m-d"));
											$this->Statistic->set_statistic_by_date('withdrawals', $withdrawals_today + ($amount * $this->UNITS_PER_COIN), date("Y-m-d"));
											//$sender = $this->User->get_user_info_by_id($request_info->user_id);
											$clone_sender = clone($sender);
											$clone_sender->pending_balance -= ($amount * $this->UNITS_PER_COIN +  $this->withdrawal_fee);
											$clone_sender->total_withdrawals += ($amount * $this->UNITS_PER_COIN + $this->withdrawal_fee);
											$this->User->update_user_info($sender, $clone_sender);
											if($sender->payment_notifications) {
												if($sender->total_withdrawals == 0) {
													$this->Notification->create_notification($sender->user_id, 'If you are satisfied with our services, please help us evaluate the website on <a href="https://www.trustpilot.com/review/bnbpick.io">Trustpilot</a>. You can also comment so we can bring the best services to customers.', 'success');
												}
											}
											//$balance = bscapi_get_balance($get_wallet->address) * $this->UNITS_PER_COIN;
											$balance = $get_wallet->balance - $amount * $this->UNITS_PER_COIN - 10500;
											$this->Wallet->update_wallet_balance($get_wallet->wallet_id, $balance, $get_wallet->updated_time);
											//$this->cache->save('last_auto_payout', time(), 864000);
											//echo json_encode(array('ret' => 1, 'mes' => 'The request is being processed!'));
										} else {
											$balance = bscapi_get_balance($get_wallet->address) * $this->UNITS_PER_COIN;
											$this->Wallet->update_wallet_balance($get_wallet->wallet_id, $balance, $get_wallet->updated_time);
											$this->Log->create_log(0, 'Auto pay failed: '.$res, $this->get_client_ip());
											//echo json_encode(array('ret' => 0, 'mes' => $res));
										}
									} else {
										$balance = bscapi_get_balance($get_wallet->address) * $this->UNITS_PER_COIN;
										$this->Wallet->update_wallet_balance($get_wallet->wallet_id, $balance, $get_wallet->updated_time);
										$this->Log->create_log(0, 'Auto pay failed!', $this->get_client_ip());
										//echo json_encode(array('ret' => 0, 'mes' => 'Withdraw failed!'));
									}
								} catch (Exception $e){
									$balance = bscapi_get_balance($get_wallet->address) * $this->UNITS_PER_COIN;
									$this->Wallet->update_wallet_balance($get_wallet->wallet_id, $balance, $get_wallet->updated_time);
									$this->Log->create_log(0, 'Auto pay failed: '.$e->getMessage(), $this->get_client_ip());
									//echo json_encode(array('ret' => 0, 'mes' => $e->getMessage()));
								}
							}
							
						}
					}
				}
			}
		}
	}
	
	public function load_unread_count() {
		if (empty($this->user_info)) {
			echo json_encode(array(
				'ret' => 0,
				'mes' => $this->lang->print('login_required_err')
			));
			return;
		}
		$user_id   = $this->user_info->user_id;
		$last_view = $this->user_info->last_notification_view;
		$unread_count  = $this->Notification->count_unread_notifications($user_id, $last_view);
		echo json_encode(array(
			'ret' => 1,
			'unread_count'  => $unread_count
		));
	}
	
	public function load_notifications() {
		if (empty($this->user_info)) {
			echo json_encode(array(
				'ret' => 0,
				'mes' => $this->lang->print('login_required_err')
			));
			return;
		}
		$user_id   = $this->user_info->user_id;
		$notifications = $this->Notification->get_notifications_for_user($user_id);

		if (!is_array($notifications)) {
			$notifications = array();
		}

		foreach ($notifications as &$n) {
			// Nếu time trong DB là dạng timestamp (số), không cần strtotime
			$timestamp = (int)$n['time'];

			// Nếu giá trị không hợp lệ
			if ($timestamp <= 0) {
				$n['time'] = '';
				continue;
			}

			$diff = time() - $timestamp;

			if ($diff < 60) {
				$n['time'] = $diff . 's';
			} elseif ($diff < 3600) {
				$minutes = floor($diff / 60);
				$n['time'] = $minutes . 'm';
			} elseif ($diff < 86400) {
				$hours = floor($diff / 3600);
				$n['time'] = $hours . 'h';
			} elseif ($diff < 604800) {
				$days = floor($diff / 86400);
				$n['time'] = $days . 'd';
			} elseif ($diff < 2419200) {
				$weeks = floor($diff / 604800);
				$n['time'] = $weeks . 'w';
			} elseif ($diff < 31536000) {
				$months = floor($diff / 2592000);
				$n['time'] = $months . 'M';
			} else {
				$years = floor($diff / 31536000);
				$n['time'] = $years . 'y';
			}
		}
		
		$this->User->update_user_info_by_id($this->user_info->user_id, 'last_notification_view', time());
		
		echo json_encode(array(
			'ret' => 1,
			'notifications' => $notifications,
		));
	}
	
	//auto cashback 29092024
	public function auto_cashback() {
		$allow_auto_cashback = $this->isSettingEnabled('allow_auto_cashback');
		if(!$allow_auto_cashback) {
			//echo json_encode(array('ret' => 0, 'mes' => 'Auto cashback disabled'));
			return;
		}
		$user_id = $this->User->find_user_to_send_cashback();
		if($user_id != null) {
			$user_info = $this->User->get_user_info_by_id($user_id);
			if($user_info->temp_bet_balance >= 0) {
				$this->cache->save('allow_auto_cashback', 0, 8640000);
				//echo json_encode(array('ret' => 0, 'mes' => 'Temp bet balance has already reset!'));
			} else {
				$cashback_amount = max(0, intval(-$user_info->temp_bet_balance / 20));
				
				/*****************/
				$stamina_info = $this->Stamina->get_stamina_info_by_uid($user_id);
				if($stamina_info != null && $stamina_info->status == 1) {
					$cashback_amount = max(0, intval(-$user_info->temp_bet_balance / 50));
				}
				/*****************/
				
				$this->User->update_user_info_by_id($user_id, 'available_commission_balance', $user_info->available_commission_balance + $cashback_amount, 0);
				$this->User->update_user_info_by_id($user_id, 'temp_bet_balance', 0);
				$this->Bonus->insert_entry($user_id, $cashback_amount, 'Pay cashback');
				
				if($user_info->referrer != 0) {
					$get_referrer = $this->User->get_user_info_by_id($user_info->referrer);
					if($get_referrer != null) {
						//$referral_cashback_amount = $cashback_amount / 2;
						$referral_cashback_amount = $cashback_amount;
						$this->User->update_user_info_by_id($get_referrer->user_id, 'available_commission_balance', $get_referrer->available_commission_balance + $referral_cashback_amount, 0);
						$this->User->update_user_info_by_id($get_referrer->user_id, 'temp_bet_balance', max(0,  $get_referrer->temp_bet_balance - $referral_cashback_amount * 20));
						$this->Bonus->insert_entry($get_referrer->user_id, $referral_cashback_amount, 'Pay referral cashback');
					}
				}
				//echo json_encode(array('ret' => 1, 'mes' => 'Reset and pay cashback user #'.$user_id.' successfully!'));
			}
		} else {
			//echo json_encode(array('ret' => 1, 'mes' => 'Invalid user id!'));
		}
	}
	//auto cashback 29092024

	public function load_game_seeds() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$game = $this->input->post_get('game');
			switch($game) {
				case 'Dice':
				case 'Ultimate':
				case 'Slots':
				case 'Baccarat':
				case 'Roulette':
				case 'Wheel':
				case 'Plinko':
				case 'Limbo':
				case 'Triple':
				case 'Keno':
				echo json_encode(array('ret' => 1, 'mes' => '', 'seeds' => array(
					'client_seed'	=> $this->user_info->client_seed,
					'nonce'			=> $this->user_info->nonce,
					'server_seed_hash'	=> $this->user_info->server_seed_hash,
					'change_client_seed'=> true,	
				)));
				break;
				case 'Gems':
				$game_data = $this->Game->get_last_game_data_by_uid('Gems', $this->user_info->user_id);
				if($game_data == null) {
					echo json_encode(array('ret' => 1, 'mes' => '', 'seeds' => array(
						'client_seed'	=> $this->user_info->client_seed,
						'nonce'			=> $this->user_info->nonce,
						'server_seed_hash'	=> $this->user_info->server_seed_hash,
						'change_client_seed'=> true,
					)));
				} else {
					// show server seed hash //
					$updated_data = clone($game_data);
					$updated_data->show_server_seed_hash = 1;
					$this->Game->update_game_data($game_data, $updated_data);
					// show server seed hash //	
					echo json_encode(array('ret' => 1, 'mes' => '', 'seeds' => array(
						'client_seed'		=> $game_data->client_seed,
						'nonce'				=> $game_data->nonce,
						'server_seed_hash'	=> $game_data->server_seed_hash,
						'change_client_seed'=> false,
					)));
				}
				break;
				case 'Mines':
				$game_data = $this->Game->get_last_game_data_by_uid('Mines', $this->user_info->user_id);
				if($game_data == null) {
					echo json_encode(array('ret' => 1, 'mes' => '', 'seeds' => array(
						'client_seed'	=> $this->user_info->client_seed,
						'nonce'			=> $this->user_info->nonce,
						'server_seed_hash'	=> $this->user_info->server_seed_hash,
						'change_client_seed'=> true,
					)));
				} else {
					// show server seed hash //
					$updated_data = clone($game_data);
					$updated_data->show_server_seed_hash = 1;
					$this->Game->update_game_data($game_data, $updated_data);
					// show server seed hash //	
					echo json_encode(array('ret' => 1, 'mes' => '', 'seeds' => array(
						'client_seed'		=> $game_data->client_seed,
						'nonce'				=> $game_data->nonce,
						'server_seed_hash'	=> $game_data->server_seed_hash,
						'change_client_seed'=> false,
					)));
					
					
				}
				break;
				case 'Poker':
				$game_data = $this->Game->get_last_game_data_by_uid('Poker', $this->user_info->user_id);
				if($game_data == null) {
					echo json_encode(array('ret' => 1, 'mes' => '', 'seeds' => array(
						'client_seed'	=> $this->user_info->client_seed,
						'nonce'			=> $this->user_info->nonce,
						'server_seed_hash'	=> $this->user_info->server_seed_hash,
						'change_client_seed'=> true,
					)));
				} else {
					
					// show server seed hash //
					$updated_data = clone($game_data);
					$updated_data->show_server_seed_hash = 1;
					$this->Game->update_game_data($game_data, $updated_data);
					// show server seed hash //
					
					echo json_encode(array('ret' => 1, 'mes' => '', 'seeds' => array(
						'client_seed'		=> $game_data->client_seed,
						'nonce'				=> $game_data->nonce,
						'server_seed_hash'	=> $game_data->server_seed_hash,
						'change_client_seed'=> false,
					)));	
					
				}
				break;
				case 'Hilow':
				$game_data = $this->Game->get_last_game_data_by_uid('Hilow', $this->user_info->user_id);
				if($game_data == null) {
					echo json_encode(array('ret' => 1, 'mes' => '', 'seeds' => array(
						'client_seed'	=> $this->user_info->client_seed,
						'nonce'			=> $this->user_info->nonce,
						'server_seed_hash'	=> $this->user_info->server_seed_hash,
						'change_client_seed'=> true,
					)));
				} else {
					
					// show server seed hash //
					$updated_data = clone($game_data);
					$updated_data->show_server_seed_hash = 1;
					$this->Game->update_game_data($game_data, $updated_data);
					// show server seed hash //	
					
					echo json_encode(array('ret' => 1, 'mes' => '', 'seeds' => array(
						'client_seed'		=> $game_data->client_seed,
						'nonce'				=> $game_data->nonce,
						'server_seed_hash'	=> $game_data->server_seed_hash,
						'change_client_seed'=> false,
					)));
				}
				break;
				default: 
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('load_game_seed_failed')));
				break;
			}
			$updated_info = clone($this->user_info);
			$updated_info->show_server_seed_hash = 1  ;
			$this->User->update_user_info($this->user_info, $updated_info);
		}
	}
	
	public function get_BNB_price() {
		$BNB_price = $this->cache->get('BNB_price');
		if(!isset($BNB_price) || $BNB_price == 0) {
			$BNB_price =  round($this->Statistic->get_statistic_by_date('BNB_price') / 100, 2);
		}
		if($BNB_price == 0) {
			$BNB_price = $this->BNB_price;
		}
		return $BNB_price;
	}
	
	public function remove_dots_from_email($email) {
		if (strpos($email, "@gmail.com") !== false) {
			list($username, $domain) = explode("@", $email);
			$usernameWithoutDots = str_replace(".", "", $username);
			$processedEmail = $usernameWithoutDots . "@" . $domain;
			return $processedEmail;
		} else {
			return $email;
		}
	}
	
	public function floorp($val, $precision) {
		$mult = pow(10, $precision);
		return floor($val * $mult) / $mult;
	}
	
	public function validateAddress($address){
        return true;
		
	}
	
	public function decodeBase58($input) {
		$alphabet = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz";
		$out = array_fill(0, 25, 0);
		for($i=0;$i<strlen($input);$i++){
			if(($p=strpos($alphabet, $input[$i]))===false){
				throw new \Exception("invalid character found");
			}
			$c = $p;
			for ($j = 25; $j--; ) {
				$c += (int)(58 * $out[$j]);
				$out[$j] = (int)($c % 256);
				$c /= 256;
				$c = (int)$c;
			}
			if($c != 0){
				throw new \Exception("address too long");
			}
		}
		$result = "";
		foreach($out as $val){
				$result .= chr($val);
		}
		return $result;
	}
	
	public function create_random_key($len = 8) {
		$bytes = random_bytes($len/2);
		return bin2hex($bytes);
	}

	public function create_random_key2($len = 8) {
		$alphabet = "abcdefghijklmnopqrstuvwxyz0123456789";
		$string = "";
		for($i = 0; $i < $len; $i++) {
			$string .= $alphabet[rand(0, strlen($alphabet) - 1)];
		}
		return $string;
	}
	
	public function get_client_ip() {
		$ipaddress = '';
		if(isset($_SERVER["HTTP_CF_CONNECTING_IP"]))
			$ipaddress = $_SERVER["HTTP_CF_CONNECTING_IP"];
		else if (getenv('HTTP_CLIENT_IP'))
			$ipaddress = getenv('HTTP_CLIENT_IP');
		else if(getenv('HTTP_X_FORWARDED_FOR'))
			$ipaddress = getenv('HTTP_X_FORWARDED_FOR');
		else if(getenv('HTTP_X_FORWARDED'))
			$ipaddress = getenv('HTTP_X_FORWARDED');
		else if(getenv('HTTP_FORWARDED_FOR'))
			$ipaddress = getenv('HTTP_FORWARDED_FOR');
		else if(getenv('HTTP_FORWARDED'))
		   $ipaddress = getenv('HTTP_FORWARDED');
		else if(getenv('REMOTE_ADDR'))
			$ipaddress = getenv('REMOTE_ADDR');
		else
			$ipaddress = 'UNKNOWN';
		return $ipaddress;
	}
	
	public function time_elapsed_string($ptime) {
		$etime = abs(time() - $ptime);
		$a = array( 365 * 24 * 60 * 60  =>  'year',
					 30 * 24 * 60 * 60  =>  'month',
						  24 * 60 * 60  =>  'day',
							   60 * 60  =>  'hour',
									60  =>  'minute',
									 1  =>  'second');
		$a_plural = array( 'year'   => 'years',
						   'month'  => 'months',
						   'day'    => 'days',
						   'hour'   => 'hours',
						   'minute' => 'minutes',
						   'second' => 'seconds');
		foreach ($a as $secs => $str) {
			$d = $etime / $secs;
			if ($d >= 1) {
				$r = round($d);
				return $r . ' ' . ($r > 1 ? $a_plural[$str] : $str);
				/*if(time() > $ptime) {
					return $r . ' ' . ($r > 1 ? $a_plural[$str] : $str) . ' ago';
				} else {
					return $r . ' ' . ($r > 1 ? $a_plural[$str] : $str);
				}*/
			}
		}
	}
	
	public function milliseconds() {
		$mt = explode(' ', microtime());
		return intval( $mt[1] * 1E3 ) + intval( round( $mt[0] * 1E3 ) );
	}
	
	public function create_pagination($page_id, $total_pages, $link) {
		$page_id = min($page_id , $total_pages);
		$pagination = "";
		if($total_pages > 0) {
			if (strpos($link, '?') !== false) {
				$pagination .= '<a href="'.$link.'&p=1">First</a>';
			} else {
				$pagination .= '<a href="'.$link.'/?p=1">First</a>';
			}	
			$previous_pages = 2 + max(0, ($page_id + 2) - $total_pages);
			$next_pages = 2 + max(0, 3 - $page_id);
			for($i = max(1, $page_id - $previous_pages); $i < $page_id; $i++) {
				if (strpos($link, '?') !== false) {
					$pagination .= '<a href="'.$link.'&p='.$i.'">'.$i.'</a>';
				} else {
					$pagination .= '<a href="'.$link.'/?p='.$i.'">'.$i.'</a>';
				}
			}
			if (strpos($link, '?') !== false) {
				$pagination .= '<a href="'.$link.'&p='.$page_id.'" class="active">'.$page_id.'</a>';
			} else {
				$pagination .= '<a href="'.$link.'/?p='.$page_id.'" class="active">'.$page_id.'</a>';
			}
			
			for($i = $page_id + 1; $i <= min($total_pages, $page_id + $next_pages); $i++) {
				if (strpos($link, '?') !== false) {
					$pagination .= '<a href="'.$link.'&p='.$i.'">'.$i.'</a>';
				} else {
					$pagination .= '<a href="'.$link.'/?p='.$i.'">'.$i.'</a>';
				}
			}
			if (strpos($link, '?') !== false) {
				$pagination .= '<a href="'.$link.'&p='.$total_pages.'">Last</a>';
			} else {
				$pagination .= '<a href="'.$link.'/?p='.$total_pages.'">Last</a>';
			}
		}
		return $pagination;	
	}
	
	/*public function ads_check_email_already_exists($file_name, $email) {
		$file = fopen($file_name, "r");
		while(!feof($file)){
			$line = fgets($file);
			$line = str_replace(array("\r", "\n"), '',$line);
			if($line == $email) {
				return 1;
			}
		}
		return 0;
		fclose($file);
	}
	
	public function ads_add_email($file_name, $email) {
		file_put_contents($file_name, "\n".$email , FILE_APPEND);
	}
	
	public function ads_delete_email($file_name, $email) {
		$contents = file_get_contents($file_name);
		$contents = str_replace($email, '', $contents);
		$contents = preg_replace("/(^[\r\n]*|[\r\n]+)[\s\t]*[\r\n]+/", "\n", $contents);
		file_put_contents($file_name, $contents);
	}
	
	public function get_rand_line($file_name) {
		$f_contents = file($file_name); 
		$line = $f_contents[rand(0, count($f_contents) - 1)];
		return $line;
	}*/
	
	public function change_server_seed() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$this->Log->create_log($this->user_info->user_id, 'Duplicate server seed | Server seed: '.$this->user_info->server_seed, $this->get_client_ip());
			$new_server_seed = $this->create_random_key(64);
			$new_server_seed_hash = hash('sha256', $new_server_seed);
			$updated_info = clone($this->user_info);
			$updated_info->server_seed = $new_server_seed;
			$updated_info->server_seed_hash = $new_server_seed_hash;
			$this->User->update_user_info($this->user_info, $updated_info);	
		}
	}
	
	public function send_http_request($url, $fields) {
		//url-ify the data for the POST
		$fields_string = http_build_query($fields);
		//open connection
		$ch = curl_init();
		//set the url, number of POST vars, POST data
		curl_setopt($ch,CURLOPT_URL, $url);
		curl_setopt($ch,CURLOPT_POST, true);
		curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);
		//So that curl_exec returns the contents of the cURL; rather than echoing it
		curl_setopt($ch,CURLOPT_RETURNTRANSFER, true); 
		//execute post
		return curl_exec($ch);
	}

	public function faucetpay_get_balance() {
		$currency = 'BNB';
		$result = $this->send_http_request(
			'https://faucetpay.io/api/v1/balance',
			array(
				'api_key'	=> 	$this->faucetpay_api_key,
				'currency'	=> 	$currency,
			)
		);
		$result = json_decode($result);
		return $result->balance;
	}

	public function faucetpay_check_address($address) {
		return 0;
		$currency = 'BNB';
		$result = $this->send_http_request(
			'https://faucetpay.io/api/v1/checkaddress',
			array(
				'api_key'	=> 	$this->faucetpay_api_key,
				'address'	=> 	$address,
				'currency'	=> 	$currency,
			)
		);
		$result = json_decode($result);
		if($result->status == 200) {
			return 1;
		}
		return 0;
	}

	public function faucetpay_send_payment($address, $amount) {
		$currency = 'BNB';
		$result = $this->send_http_request(
			'https://faucetpay.io/api/v1/send',
			array(
				'api_key'	=> 	$this->faucetpay_api_key,
				'amount'	=> 	$amount,
				'to'	=> 	$address,
				'currency'	=> 	$currency,
			)
		);
		$result = json_decode($result);
		if($result->status == 200) {
			return $result->payout_id;
		}
		return 0;
	}
	
	public function load_deposit_transactions($user_wallet){
		if($user_wallet != ''){
			$deposit_address = $user_wallet->address;
			$get_transactions = bscapi_get_transactions($deposit_address, $user_wallet->updated_time);
			if($get_transactions != '') {
				$total_amount = 0;
				for($i = count($get_transactions) - 1; $i >= 0; $i--){
					$transaction = $get_transactions[$i];
					if($transaction['to_address'] == $deposit_address){
						if(!$this->Request->get_all_requests_by_txid($transaction['txid'])){
							$this->Request->create_request($this->user_info->user_id, 'Deposit', $transaction['amount'], $deposit_address, $transaction['txid'], '', $transaction['time']);
							$total_amount += $transaction['amount'];
							
						}
					}
					if($user_wallet->updated_time < $transaction['time']) {
						$user_wallet->updated_time = $transaction['time'];
					}
				}
				if($total_amount != 0) {
					$updated_info = clone($this->user_info);
					$updated_info->balance += $total_amount;
					$updated_info->total_deposits += $total_amount;
					$this->User->update_user_info($this->user_info, $updated_info);
					$this->user_info->balance += $total_amount;
					$this->Wallet->update_wallet_balance($user_wallet->wallet_id, $user_wallet->balance + $total_amount, $user_wallet->updated_time);
					$deposits_today = $this->Statistic->get_statistic_by_date('deposits', date("Y-m-d"));
					$this->Statistic->set_statistic_by_date('deposits', $deposits_today + $total_amount, date("Y-m-d"));
					echo json_encode(array('ret' => 1, 'balance' => $this->user_info->balance, 'mes' => $this->lang->print('deposit_credited_success', ($total_amount / $this->UNITS_PER_COIN))));
				} else {
					$get_balance_onchain = intval($this->input->post_get('get_balance_onchain'));
					if($get_balance_onchain != 0) {
						if(abs($get_balance_onchain - $user_wallet->balance) < 1000) {
							$this->Wallet->update_wallet_balance($user_wallet->wallet_id, $get_balance_onchain, $user_wallet->updated_time);
						}
					}
					echo json_encode(array('ret' => 0, 'mes' => '', 'trans' => $get_transactions));
				}
			} else {
				echo json_encode(array('ret' => 0, 'mes' => ''));
			}
		} else {
			echo json_encode(array('ret' => 0, 'mes' => ''));
		}
	}
	
	public function load_deposit_transactions_from_nodereal($user_wallet){
		if($user_wallet != ''){
			$deposit_address = $user_wallet->address;
			$get_transactions = bscapi_get_transactions_from_nodereal($deposit_address, $user_wallet->updated_time);
			if($get_transactions != '') {
				$total_amount = 0;
				for($i = count($get_transactions) - 1; $i >= 0; $i--){
					$transaction = $get_transactions[$i];
					if($transaction['to_address'] == $deposit_address){
						if(!$this->Request->get_all_requests_by_txid($transaction['txid'])){
							$this->Request->create_request($this->user_info->user_id, 'Deposit', $transaction['amount'], $deposit_address, $transaction['txid'], '', $transaction['time']);
							$total_amount += $transaction['amount'];
							
						}
					}
					if($user_wallet->updated_time < $transaction['time']) {
						$user_wallet->updated_time = $transaction['time'];
					}
				}
				if($total_amount != 0) {
					$updated_info = clone($this->user_info);
					$updated_info->balance += $total_amount;
					$updated_info->total_deposits += $total_amount;
					$this->User->update_user_info($this->user_info, $updated_info);
					$this->user_info->balance += $total_amount;
					$this->Wallet->update_wallet_balance($user_wallet->wallet_id, $user_wallet->balance + $total_amount, $user_wallet->updated_time);
					$deposits_today = $this->Statistic->get_statistic_by_date('deposits', date("Y-m-d"));
					$this->Statistic->set_statistic_by_date('deposits', $deposits_today + $total_amount, date("Y-m-d"));
					echo json_encode(array('ret' => 1, 'balance' => $this->user_info->balance, 'mes' => $this->lang->print('deposit_credited_success', ($total_amount / $this->UNITS_PER_COIN))));
				} else {
					echo json_encode(array('ret' => 0, 'mes' => ''));
				}
			} else {
				echo json_encode(array('ret' => 0, 'mes' => ''));
			}
		} else {
			echo json_encode(array('ret' => 0, 'mes' => ''));
		}
	}
	
	public function load_deposit_transactions_from_bscscan($user_wallet){
		if($user_wallet != ''){
			$deposit_address = $user_wallet->address;
			$get_transactions = bscapi_get_transactions_from_bscscan($deposit_address, $user_wallet->updated_time);
			if($get_transactions != '') {
				$total_amount = 0;
				for($i = count($get_transactions) - 1; $i >= 0; $i--){
					$transaction = $get_transactions[$i];
					if($transaction['to_address'] == $deposit_address){
						if(!$this->Request->get_all_requests_by_txid($transaction['txid'])){
							$this->Request->create_request($this->user_info->user_id, 'Deposit', $transaction['amount'], $deposit_address, $transaction['txid'], '', $transaction['time']);
							$total_amount += $transaction['amount'];
							
						}
					}
					if($user_wallet->updated_time < $transaction['time']) {
						$user_wallet->updated_time = $transaction['time'];
					}
				}
				if($total_amount != 0) {
					$updated_info = clone($this->user_info);
					$updated_info->balance += $total_amount;
					$updated_info->total_deposits += $total_amount;
					$this->User->update_user_info($this->user_info, $updated_info);
					$this->user_info->balance += $total_amount;
					$this->Wallet->update_wallet_balance($user_wallet->wallet_id, $user_wallet->balance + $total_amount, $user_wallet->updated_time);
					$deposits_today = $this->Statistic->get_statistic_by_date('deposits', date("Y-m-d"));
					$this->Statistic->set_statistic_by_date('deposits', $deposits_today + $total_amount, date("Y-m-d"));
					echo json_encode(array('ret' => 1, 'balance' => $this->user_info->balance, 'mes' => $this->lang->print('deposit_credited_success', ($total_amount / $this->UNITS_PER_COIN))));
				} else {
					echo json_encode(array('ret' => 0, 'mes' => ''));
				}
			} else {
				echo json_encode(array('ret' => 0, 'mes' => ''));
			}
		} else {
			echo json_encode(array('ret' => 0, 'mes' => ''));
		}
	}
	
	public function load_deposit_transactions_on_opbnb($user_wallet){
		if($user_wallet != ''){
			$deposit_address = $user_wallet->address;
			$get_transactions = bscapi_get_transactions_on_opbnb($deposit_address, $user_wallet->updated_time);
			if($get_transactions != '') {
				$total_amount = 0;
				for($i = count($get_transactions) - 1; $i >= 0; $i--){
					$transaction = $get_transactions[$i];
					if($transaction['to_address'] == $deposit_address){
						$txid = str_replace("0x" , "1x", $transaction['txid']);
						if(!$this->Request->get_all_requests_by_txid($txid)){
							$this->Request->create_request($this->user_info->user_id, 'Deposit', $transaction['amount'], $deposit_address, $txid, '', $transaction['time']);
							$total_amount += $transaction['amount'];
							
						}
					}
					if($user_wallet->updated_time < $transaction['time']) {
						$user_wallet->updated_time = $transaction['time'];
					}
				}
				if($total_amount != 0) {
					$updated_info = clone($this->user_info);
					$updated_info->balance += $total_amount;
					$updated_info->total_deposits += $total_amount;
					$this->User->update_user_info($this->user_info, $updated_info);
					$this->user_info->balance += $total_amount;
					$this->Wallet->update_wallet_balance_on_opbnb($user_wallet->wallet_id, $user_wallet->balance_on_opbnb + $total_amount, $user_wallet->updated_time);
					$deposits_today = $this->Statistic->get_statistic_by_date('deposits', date("Y-m-d"));
					$this->Statistic->set_statistic_by_date('deposits', $deposits_today + $total_amount, date("Y-m-d"));
					echo json_encode(array('ret' => 1, 'balance' => $this->user_info->balance, 'mes' => $this->lang->print('deposit_credited_success', ($total_amount / $this->UNITS_PER_COIN))));
				} else {
					echo json_encode(array('ret' => 0, 'mes' => '.'));
				}
			} else {
				echo json_encode(array('ret' => 0, 'mes' => '..'));
			}
		} else {
			echo json_encode(array('ret' => 0, 'mes' => '...'));
		}
	}
	
	//process withdrawal request
	public function complete_processing_request() {
		$allow_auto_payout = $this->cache->get('allow_auto_payout');
		if (!$allow_auto_payout) {
			return;
		}

		$random_processing_request = $this->Request->get_random_processing_request();
		if ($random_processing_request == null) {
			return;
		}

		$request_id = $random_processing_request->request_id;
		$txid = $random_processing_request->proof;
		$transaction_info = bscapi_get_transaction_info_by_txid2($txid);

		if ($transaction_info != null && strtolower($transaction_info['to_address']) == strtolower($random_processing_request->address)) {
			$this->Request->complete_withdrawal_request($request_id);
		} else {
			$this->withdrawal_fee = 0;

			// số lượng coin (float)
			$amount = round(($random_processing_request->amount - $this->withdrawal_fee) / $this->UNITS_PER_COIN, $this->COIN_DECIMALS);

			$address = $random_processing_request->address;
			$res = bscapi_send_transaction($address, $amount, $this->main_wallet['private_key']);

			if ($res != null && strlen($res) == 66) {
				$txid = $res;

				// USD value (float)
				$USD_value = round($amount * $this->BNB_price, 2);

				// Lưu vào DB (nếu DB cột DECIMAL thì ok)
				$this->Request->process_withdrawal_request($request_id, $txid, $USD_value);
			}
		}
	}
	//process withdrawal request

	public function encodeString($string, $shift = 7) {
		$encodedString = '';
		$stringLength = strlen($string);
		for ($i = 0; $i < $stringLength; $i++) {
			$character = $string[$i];
			// Check if the character is an alphabet letter (a-z) or a digit (0-9)
			if (ctype_alpha($character)) {
				$isUpperCase = ctype_upper($character);
				$newCharacter = chr((ord($character) + $shift - ($isUpperCase ? ord('A') : ord('a'))) % 26 + ($isUpperCase ? ord('A') : ord('a')));
				$encodedString .= $newCharacter;
			} else if (ctype_digit($character)) {
				$newCharacter = chr((ord($character) + $shift - ord('0')) % 10 + ord('0'));
				$encodedString .= $newCharacter;
			} else {
				// If the character is not an alphabet letter or a digit, keep it unchanged
				$encodedString .= $character;
			}
		}
		return $encodedString;
	}

	public function decodeString($string, $shift = 7) {
		$decodedString = '';
		$stringLength = strlen($string);
		for ($i = 0; $i < $stringLength; $i++) {
			$character = $string[$i];
			// Check if the character is an alphabet letter (a-z) or a digit (0-9)
			if (ctype_alpha($character)) {
				$isUpperCase = ctype_upper($character);
				$newCharacter = chr((ord($character) - $shift - ($isUpperCase ? ord('A') : ord('a')) + 26) % 26 + ($isUpperCase ? ord('A') : ord('a')));
				$decodedString .= $newCharacter;
			} else if (ctype_digit($character)) {
				$newCharacter = chr((ord($character) - $shift - ord('0') + 10) % 10 + ord('0'));
				$decodedString .= $newCharacter;
			} else {
				// If the character is not an alphabet letter or a digit, keep it unchanged
				$decodedString .= $character;
			}
		}
		return $decodedString;
	}
	
	public function write_log() {
		if($this->user_info == null) {
			$user_id = 0;
		} else {
			$user_id = $this->user_info->user_id;
		}
		if ($_SERVER['REQUEST_METHOD'] === 'POST') {
			$post_data = json_encode($_POST);
		} else {
			$post_data = '-';
		}
		$ip_address = $this->get_client_ip();
		$user_agent = $_SERVER['HTTP_USER_AGENT'];
		$current_time = date('Y-m-d H:i:s');
		$log_file = 'logs/custom_log_' . date('Y-m-d_H') . ((date('H') < 12) ? '_AM.log' : '_PM.log');
		$log_entry = "[$current_time] [$ip_address] [$user_id] [$post_data]\n";
		file_put_contents($log_file, $log_entry, FILE_APPEND);
	}
	
	public function contains_spam_words($input) {
		if($this->user_info != null && ($this->user_info->total_deposits - $this->user_info->total_withdrawals > 10000000 || $this->user_info->total_bonuses > 10000000)) {
			return false;
		}
		$spamWords = ['gift', 'code', 'card', 'happy',  'new year', 'merry christmas', 'xmas', 'cadeau'];
		$input = mb_strtolower(trim($input));
		foreach ($spamWords as $word) {
			$word = mb_strtolower(trim($word));
			if (strpos($input, $word) !== false) {
				return true;
			}
		}
		return false;
	}
	
	//stamina feature
	public function update_user_stamina($bet_amount) {
		$stamina_info = $this->Stamina->get_stamina_info_by_uid($this->user_info->user_id);
		if($stamina_info != null && $stamina_info->status == 1) {
			if($stamina_info->accumulated_bet + $bet_amount >= $stamina_info->target_bet) {
				$this->Stamina->fullfill_stamina($this->user_info->user_id);
			} else {
				$this->Stamina->update_accumulated_bet($this->user_info->user_id, $bet_amount);
			}
		}
	}
	//stamina feature
	
	//validateMousePosition
	public function validateMousePosition($encodedData, $key) {
		$encryptedData = base64_decode($encodedData);
		$decryptedData = '';

		for ($i = 0; $i < strlen($encryptedData); $i++) {
			$decryptedData .= chr(ord($encryptedData[$i]) ^ ord($key[$i % strlen($key)]));
		}

		list($x, $y, $timestamp) = explode(':', $decryptedData);

		$x = (int)$x;
		$y = (int)$y;
		$timestamp = (int)$timestamp;

		/*if ($x < 0 || $x > 300) {
			$this->Log->create_log($this->user_info->user_id, $decryptedData, $this->get_client_ip());
			return 0;
		}

		if ($y < 0 || $y > 45) {
			$this->Log->create_log($this->user_info->user_id, $decryptedData, $this->get_client_ip());
			return 0;
		}*/

		$currentTimestamp = time();
		$timeDifference = abs($currentTimestamp - $timestamp);
		
		if ($timeDifference > 1800) {
			$this->Log->create_log($this->user_info->user_id, $decryptedData, $this->get_client_ip());
			return 0;
		}
		return 1;
	}
	
	function decodeMousePosition($encodedData, $key) {
		$encryptedData = base64_decode($encodedData);
		$decryptedData = '';
		for ($i = 0; $i < strlen($encryptedData); $i++) {
			$decryptedData .= chr(ord($encryptedData[$i]) ^ ord($key[$i % strlen($key)]));
		}
		list($x, $y, $timestamp) = explode(':', $decryptedData);
		return array(
			'x' => number_format($x, 3, '.', ''),
			'y'	=> number_format($y, 3, '.', '')
		);
	}

	//validateMousePosition
	
	private function validate_captcha() {
		$this->captcha_result = null;
		
		switch ($this->captcha_type) {
			case 0: // IconCaptcha
				$options = require 'iconcaptcha/examples/captcha-config.php';
				$iconcaptcha = new IconCaptcha($options);
				$this->captcha_result = $iconcaptcha->validate($_POST);
				break;

			case 1: // reCAPTCHA
				if (isset($_POST['g-recaptcha-response'])) {
					$response = $_POST['g-recaptcha-response'];
					$data = [
						'secret' => $this->gg_secret_key,
						'response' => $response,
						'remoteip' => $this->get_client_ip(),
					];
					$output = file_get_contents('https://www.google.com/recaptcha/api/siteverify?' . http_build_query($data));
					$this->captcha_result = json_decode($output);
				}
				break;

			case 2: // hCaptcha
				if (isset($_POST['h-captcha-response'])) {
					$response = $_POST['h-captcha-response'];
					$data = [
						'secret' => $this->hcaptcha_secret_key,
						'response' => $response,
					];
					$ch = curl_init("https://hcaptcha.com/siteverify");
					curl_setopt($ch, CURLOPT_POST, true);
					curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
					curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
					$this->captcha_result = json_decode(curl_exec($ch));
					curl_close($ch);
				}
				break;

			case 3: // Cloudflare Turnstile
				if (isset($_POST['c_captcha_response'])) {
					$response = $_POST['c_captcha_response'];
					$data = [
						'secret' => $this->cloudflare_secret_key,
						'response' => $response,
						'remoteip' => $_SERVER['REMOTE_ADDR']
					];
					$ch = curl_init('https://challenges.cloudflare.com/turnstile/v0/siteverify');
					curl_setopt($ch, CURLOPT_POST, true);
					curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
					curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
					$this->captcha_result = json_decode(curl_exec($ch));
					curl_close($ch);
				}
				break;
				
			case 4: // PCaptcha
				$token = $_POST['pcaptcha_token'] ?? null;

				$expected = $this->session->userdata('pcaptcha_token');
				$verified = $this->session->userdata('pcaptcha_verified');
				$verified_time = $this->session->userdata('pcaptcha_verified_time');

				if (empty($token) || $token !== $expected) {
					break;
				}
				if (!$verified) {
					break;
				}
				if ((time() - (int)$verified_time) > 60) {
					break;
				}

				$this->captcha_result = (object)['success' => true];
				break;
		}
	}
	
	private function is_captcha_valid() {
		switch ($this->captcha_type) {
			case 0:
				return $this->captcha_result && $this->captcha_result->success();
			case 1:
			case 2:
			case 3:
			case 4:
				return $this->captcha_result && isset($this->captcha_result->success) && $this->captcha_result->success === true;
			default:
				return false;
		}
	}

	
	/**
     * Enable a setting (Set value to 1)
     * If the key does not exist, it will be added.
     * If the key exists but has a value of 0, it will be updated to 1.
     */
	public function enableSetting($key) {
        $settings = $this->read_settings();
        
        if (!isset($settings[$key]) || $settings[$key] == 0) {
            $settings[$key] = 1; // Add new or update to 1
        }

        $this->write_settings($settings);
        //echo "✅ `$key` has been enabled (set to 1)";
    }

    /**
     * Disable a setting (Set value to 0)
     * If the key exists and has a value of 1, it will be updated to 0.
     */
    public function disableSetting($key) {
        $settings = $this->read_settings();

        if (isset($settings[$key]) && $settings[$key] == 1) {
            $settings[$key] = 0;
        }

        $this->write_settings($settings);
       // echo "✅ `$key` has been disabled (set to 0)";
    }

    /**
     * Check if a setting is enabled
     * Returns true if the key exists and its value is 1
     * Returns false if the key is 0 or does not exist.
     */
    public function isSettingEnabled($key) {
        $settings = $this->read_settings();
        return isset($settings[$key]) && $settings[$key] == 1 ? true : false;
    }

    /**
     * Read settings from the settings.txt file and return as a key-value array
     */
    private function read_settings() {
        if (!file_exists($this->settings_file)) {
            return []; // Return an empty array if the file does not exist
        }

        $settings = [];
        $lines = file($this->settings_file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

        foreach ($lines as $line) {
            list($key, $value) = array_map('trim', explode('=', $line, 2));
            $settings[$key] = (int) $value; // Convert value to an integer (0 or 1)
        }

        return $settings;
    }

    /**
     * Write settings to the settings.txt file from a key-value array
     */
    private function write_settings($settings) {
        $content = "";
        foreach ($settings as $key => $value) {
            $content .= "$key = $value\n";
        }
        file_put_contents($this->settings_file, $content);
    }
	
	
    /**
     * Store a data value in the settings file
     * If the key exists, update it; otherwise, add a new entry.
     */
    public function saveSettingData($key, $value) {
        $settings = $this->read_settings();
        $settings[$key] = $value;

        $this->write_settings($settings);
        //echo "✅ `$key` has been updated to `$value`";
    }

    /**
     * Retrieve a data value from the settings file
     * Returns the value if the key exists, otherwise returns "null".
     */
    public function getSettingData($key) {
        $settings = $this->read_settings();
        return isset($settings[$key]) ? $settings[$key] : '';
    }

    /**
     * Remove a data entry from the settings file
     */
    public function removeData($key) {
        $settings = $this->read_settings();

        if (isset($settings[$key])) {
            unset($settings[$key]);
            $this->write_settings($settings);
           // echo "✅ `$key` has been removed";
        } else {
            //echo "❌ `$key` does not exist";
        }
    }
	
	public function send_async_http_request($url) {
		$ch = curl_init($url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_TIMEOUT, 1);     // Max wait 1s
		curl_setopt($ch, CURLOPT_NOSIGNAL, 1);    // Prevent timeout bug on some systems
		curl_exec($ch);
		curl_close($ch);
	}

}
